/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: galdlg.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:52:08 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVX_GALDLG_HXX_
#define _SVX_GALDLG_HXX_

// auto strip #include <vos/thread.hxx>
// auto strip #include <bootstrp/sstring.hxx>
// auto strip #include <vcl/dialog.hxx>
// auto strip #include <vcl/graph.hxx>
// auto strip #include <vcl/fixed.hxx>
// auto strip #include <vcl/button.hxx>
// auto strip #include <vcl/lstbox.hxx>
// auto strip #include <vcl/menu.hxx>
// auto strip #include <vcl/edit.hxx>
// auto strip #include <vcl/combobox.hxx>
// auto strip #include <vcl/sound.hxx>
// auto strip #include <svtools/slstitm.hxx>
// auto strip #include <svtools/transfer.hxx>
// auto strip #include <goodies/grfmgr.hxx>
// auto strip #include <bf_sfx2/tabdlg.hxx>
// auto strip #include "galctrl.hxx"
// auto strip #include "galmisc.hxx"
namespace binfilter {


// ------------
// - Forwards -
// ------------

class Gallery;
class GalleryTheme;
class SearchProgress;
class TakeProgress;
class TPGalleryThemeProperties;

// ---------------
// - FilterEntry -
// ---------------

//STRIP001 struct FilterEntry
//STRIP001 {
//STRIP001 	String	aFilterName;
//STRIP001 };

// ----------------
// - ExchangeData -
// ----------------

//STRIP001 struct ExchangeData
//STRIP001 {
//STRIP001 	GalleryTheme*	pTheme;
//STRIP001 	String			aEditedTitle;
//STRIP001 	Date			aThemeChangeDate;
//STRIP001 	Time			aThemeChangeTime;
//STRIP001 };

// ----------------
// - SearchThread -
// ----------------

//STRIP001 class SearchThread : public ::vos::OThread
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 	SearchProgress*				mpProgress;
//STRIP001 	TPGalleryThemeProperties*	mpBrowser;
//STRIP001 	INetURLObject				maStartURL;
//STRIP001 
//STRIP001 	void						ImplSearch( const INetURLObject& rStartURL, 
//STRIP001                                             const ::std::vector< String >& rFormats,
//STRIP001                                             BOOL bRecursive );
//STRIP001 
//STRIP001 	virtual void SAL_CALL		run();
//STRIP001     virtual void SAL_CALL       onTerminated();
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 								SearchThread( SearchProgress* pProgess,
//STRIP001 											  TPGalleryThemeProperties* pBrowser,
//STRIP001 											  const INetURLObject& rStartURL );
//STRIP001     virtual						~SearchThread();
//STRIP001 };

// ------------------
// - SearchProgress -
// ------------------

//STRIP001 class SearchProgress : public ModalDialog
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 	FixedText			aFtSearchDir;
//STRIP001     FixedLine           aFLSearchDir;
//STRIP001 	FixedText			aFtSearchType;
//STRIP001     FixedLine           aFLSearchType;
//STRIP001 	CancelButton		aBtnCancel;
//STRIP001 	SearchThread		maSearchThread;
//STRIP001 
//STRIP001 						DECL_LINK( ClickCancelBtn, void* );
//STRIP001 
//STRIP001 public:
//STRIP001 						SearchProgress( Window* pParent, const INetURLObject& rStartURL );
//STRIP001 						~SearchProgress() {};
//STRIP001 
//STRIP001 						DECL_LINK( CleanUpHdl, void* );
//STRIP001 
//STRIP001 	virtual short		Execute();
//STRIP001 	void 				SetFileType( const String& rType ) { aFtSearchType.SetText( rType ); }
//STRIP001 	void 				SetDirectory( const INetURLObject& rURL ) { aFtSearchDir.SetText( GetReducedString( rURL, 30 ) ); }
//STRIP001 };

// --------------
// - TakeThread -
// --------------

//STRIP001 class TakeThread : public ::vos::OThread
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 	TakeProgress*				mpProgress;
//STRIP001 	TPGalleryThemeProperties*	mpBrowser;
//STRIP001 	List&						mrTakenList;
//STRIP001 
//STRIP001 	virtual void SAL_CALL		run();
//STRIP001     virtual void SAL_CALL       onTerminated();
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 								TakeThread( TakeProgress* pProgess, TPGalleryThemeProperties* pBrowser, List& rTakenList );
//STRIP001 	virtual                     ~TakeThread();
//STRIP001 };

// ----------------
// - TakeProgress -
// ----------------

//STRIP001 class TakeProgress : public ModalDialog
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 	FixedText			aFtTakeFile;
//STRIP001     FixedLine           aFLTakeProgress;
//STRIP001 	CancelButton		aBtnCancel;
//STRIP001 	TakeThread			maTakeThread;
//STRIP001 	List				maTakenList;
//STRIP001 
//STRIP001 						DECL_LINK( ClickCancelBtn, void* );
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 						TakeProgress( Window* pWindow );
//STRIP001 						~TakeProgress() {};
//STRIP001 
//STRIP001 						DECL_LINK( CleanUpHdl, void* );
//STRIP001 
//STRIP001 	void 				SetFile( const INetURLObject& rURL ) { aFtTakeFile.SetText( GetReducedString( rURL, 30 ) ); }
//STRIP001 	virtual short		Execute();
//STRIP001 };

// ---------------------
// - ActualizeProgress -
// ---------------------

//STRIP001 class ActualizeProgress : public ModalDialog
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 	FixedText			aFtActualizeFile;
//STRIP001     FixedLine           aFLActualizeProgress;
//STRIP001 	CancelButton		aBtnCancel;
//STRIP001 	Timer*				pTimer;
//STRIP001 	GalleryTheme*		pTheme;
//STRIP001 	GalleryProgress		aStatusProgress;
//STRIP001 
//STRIP001 						DECL_LINK( ClickCancelBtn, void* );
//STRIP001 						DECL_LINK( TimeoutHdl, Timer* );
//STRIP001 						DECL_LINK( ActualizeHdl, INetURLObject* pURL );
//STRIP001 
//STRIP001 public:
//STRIP001 						ActualizeProgress( Window* pWindow, GalleryTheme* pThm );
//STRIP001 						~ActualizeProgress() {};
//STRIP001 
//STRIP001 	virtual short		Execute();
//STRIP001 };

// ---------------
// - TitleDialog -
// ---------------

//STRIP001 class TitleDialog : public ModalDialog
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 	OKButton			maOk;
//STRIP001 	CancelButton		maCancel;
//STRIP001 	HelpButton			maHelp;
//STRIP001     FixedLine           maFL;
//STRIP001 	Edit				maEdit;
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 						TitleDialog( Window* pParent, const String& rOldText );
//STRIP001 	String				GetTitle() const { return maEdit.GetText(); }
//STRIP001 };

// -------------------
// - GalleryIdDialog -
// -------------------

//STRIP001 class GalleryIdDialog : public ModalDialog
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 	OKButton		aBtnOk;
//STRIP001 	CancelButton	aBtnCancel;
//STRIP001     FixedLine       aFLId;
//STRIP001 	ListBox			aLbResName;
//STRIP001 	GalleryTheme*	pThm;
//STRIP001 
//STRIP001 					DECL_LINK( ClickOkHdl, void* );
//STRIP001 					DECL_LINK( ClickResNameHdl, void* );
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 					GalleryIdDialog( Window* pParent, GalleryTheme* pThm );
//STRIP001 					~GalleryIdDialog() {}
//STRIP001 
//STRIP001 	ULONG			GetId() const { return aLbResName.GetSelectEntryPos(); }
//STRIP001 };

// --------------------------
// - GalleryThemeProperties -
// --------------------------

//STRIP001 class GalleryThemeProperties : public SfxTabDialog
//STRIP001 {
//STRIP001 	ExchangeData*	pData;
//STRIP001 
//STRIP001 	virtual void	PageCreated( USHORT nId, SfxTabPage &rPage );
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 					GalleryThemeProperties( Window* pParent, ExchangeData* pData, SfxItemSet* pItemSet  );
//STRIP001 					~GalleryThemeProperties() {}
//STRIP001 };

// -------------------------
// - TPGalleryThemeGeneral -
// -------------------------

//STRIP001 class TPGalleryThemeGeneral : public SfxTabPage
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 	FixedImage			aFiMSImage;
//STRIP001 	Edit				aEdtMSName;
//STRIP001 	FixedLine			aFlMSGeneralFirst;
//STRIP001 	FixedText			aFtMSType;
//STRIP001 	FixedText			aFtMSShowType;
//STRIP001 	FixedText			aFtMSPath;
//STRIP001 	FixedText			aFtMSShowPath;
//STRIP001 	FixedText			aFtMSContent;
//STRIP001 	FixedText			aFtMSShowContent;
//STRIP001 	FixedLine			aFlMSGeneralSecond;
//STRIP001 	FixedText			aFtMSChangeDate;
//STRIP001 	FixedText			aFtMSShowChangeDate;
//STRIP001 	ExchangeData*		pData;
//STRIP001 
//STRIP001 	virtual void		Reset( const SfxItemSet& ) {}
//STRIP001 	virtual BOOL        FillItemSet( SfxItemSet& rSet );
//STRIP001 
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 						TPGalleryThemeGeneral( Window* pParent, const SfxItemSet& rSet );
//STRIP001 						~TPGalleryThemeGeneral() {}
//STRIP001 
//STRIP001 	void				SetXChgData( ExchangeData* pData );
//STRIP001 	const ExchangeData*	GetXChgData() const { return pData; }
//STRIP001 
//STRIP001 	static SfxTabPage*	Create( Window* pParent, const SfxItemSet& rSet );
//STRIP001 };

// ----------------------------
// - TPGalleryThemeProperties -
// ----------------------------

//STRIP001 class TPGalleryThemeProperties : public SfxTabPage
//STRIP001 {
//STRIP001 	friend class SearchThread;
//STRIP001 	friend class TakeProgress;
//STRIP001 	friend class TakeThread;
//STRIP001 
//STRIP001 	PushButton			aBtnSearch;
//STRIP001 	PushButton			aBtnTake;
//STRIP001 	PushButton			aBtnTakeAll;
//STRIP001 	CheckBox			aCbxPreview;
//STRIP001 	ComboBox			aCbbFileType;
//STRIP001     MultiListBox		aLbxFound;
//STRIP001 	FixedText			aFtFileType;
//STRIP001 	GalleryPreview		aWndPreview;
//STRIP001 
//STRIP001 	ExchangeData*		pData;
//STRIP001 	Sound				aSound;
//STRIP001 	StringList			aFoundList;
//STRIP001 	List				aFilterEntryList;
//STRIP001 	Timer				aPreviewTimer;
//STRIP001 	String				aLastFilterName;
//STRIP001 	String				aPreviewString;
//STRIP001 	INetURLObject		aURL;
//STRIP001 	USHORT				nCurFilterPos;
//STRIP001 	USHORT				nFirstExtFilterPos;
//STRIP001 	BOOL				bEntriesFound;
//STRIP001 	BOOL				bInputAllowed;
//STRIP001 	BOOL				bTakeAll;
//STRIP001 	BOOL				bSearchRecursive;
//STRIP001 
//STRIP001 	virtual	void		Reset( const SfxItemSet& rSet ) {}
//STRIP001 	virtual BOOL        FillItemSet( SfxItemSet& rSet ) { return TRUE; }
//STRIP001 	::rtl::OUString 	addExtension( const ::rtl::OUString&, const ::rtl::OUString& );
//STRIP001 	void				FillFilterList();
//STRIP001 
//STRIP001 	void				SearchFiles();
//STRIP001 	void 				TakeFiles();
//STRIP001 	void				DoPreview();
//STRIP001 
//STRIP001 						DECL_LINK( ClickPreviewHdl, void* );
//STRIP001 						DECL_LINK( ClickCloseBrowserHdl, void* );
//STRIP001 						DECL_LINK( ClickSearchHdl, void* );
//STRIP001 						DECL_LINK( ClickTakeHdl, void* );
//STRIP001 						DECL_LINK( ClickTakeAllHdl, void* );
//STRIP001 						DECL_LINK( SelectFoundHdl, void* );
//STRIP001 						DECL_LINK( SelectThemeHdl, void* );
//STRIP001 						DECL_LINK( SelectFileTypeHdl, void* );
//STRIP001 						DECL_LINK( DClickFoundHdl, void* );
//STRIP001 						DECL_LINK( PreviewTimerHdl, void* );
//STRIP001 						DECL_LINK( SoundEndHdl, Sound* );
//STRIP001 
//STRIP001 public:
//STRIP001 						TPGalleryThemeProperties( Window* pWindow, const SfxItemSet& rSet );
//STRIP001 						~TPGalleryThemeProperties();
//STRIP001 
//STRIP001 	void				SetXChgData( ExchangeData* pData );
//STRIP001 	const ExchangeData*	GetXChgData() const { return pData; }
//STRIP001 
//STRIP001 	static SfxTabPage*	Create( Window* pParent, const SfxItemSet& rSet );
//STRIP001 };

}//end of namespace binfilter
#endif // _SVX_GALDLG_HXX_
