/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_navigatortreemodel.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:48:37 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _SVX_DIALMGR_HXX //autogen
// auto strip #include "dialmgr.hxx"
// auto strip #endif
// auto strip #ifndef _SVX_FMSHELL_HXX
// auto strip #include "fmshell.hxx"
// auto strip #endif
// auto strip #ifndef _SVX_FMMODEL_HXX
// auto strip #include "fmmodel.hxx"
// auto strip #endif
// auto strip #ifndef _SVX_FMPAGE_HXX
// auto strip #include "fmpage.hxx"
// auto strip #endif
// auto strip #ifndef _SVX_FMGLOB_HXX
// auto strip #include "fmglob.hxx"
// auto strip #endif
// auto strip #ifndef _SVDITER_HXX
// auto strip #include "svditer.hxx"
// auto strip #endif
// auto strip #ifndef _SVDOGRP_HXX
// auto strip #include "svdogrp.hxx"
// auto strip #endif
// auto strip #ifndef _SVDPAGV_HXX //autogen
// auto strip #include "svdpagv.hxx"
// auto strip #endif


// auto strip #ifndef _SVX_FMUNDO_HXX
// auto strip #include "fmundo.hxx"
// auto strip #endif
#ifndef _SVX_FMHELP_HRC
#include "fmhelp.hrc"
#endif
#ifndef _SVX_FMEXPL_HRC
#include "fmexpl.hrc"
#endif
#ifndef _SVX_FMEXPL_HXX
#include "fmexpl.hxx"
#endif
#ifndef _SVX_FMRESIDS_HRC
#include "fmresids.hrc"
#endif

#ifndef _COM_SUN_STAR_SDBC_XROWSETLISTENER_HPP_
#include <com/sun/star/sdbc/XRowSetListener.hpp>
#endif

#ifndef _COM_SUN_STAR_SDB_XSQLQUERYCOMPOSERFACTORY_HPP_
#include <com/sun/star/sdb/XSQLQueryComposerFactory.hpp>
#endif

// auto strip #ifndef _SVX_FMSHIMP_HXX
// auto strip #include "fmshimp.hxx"
// auto strip #endif

// auto strip #ifndef _SFX_OBJSH_HXX
// auto strip #include <bf_sfx2/objsh.hxx>
// auto strip #endif

// auto strip #ifndef _COM_SUN_STAR_CONTAINER_XCONTAINER_HPP_
// auto strip #include <com/sun/star/container/XContainer.hpp>
// auto strip #endif
namespace binfilter {

//............................................................................
//STRIP001 namespace svxform
//STRIP001 {
//STRIP001 //............................................................................
//STRIP001 
//STRIP001 	using namespace ::com::sun::star::uno;
//STRIP001 	using namespace ::com::sun::star::lang;
//STRIP001 	using namespace ::com::sun::star::beans;
//STRIP001 	using namespace ::com::sun::star::form;
//STRIP001 	using namespace ::com::sun::star::awt;
//STRIP001 	using namespace ::com::sun::star::container;
//STRIP001 	using namespace ::com::sun::star::script;
//STRIP001 	using namespace ::com::sun::star::sdb;
//STRIP001 
//STRIP001 	//========================================================================
//STRIP001 	// class OFormComponentObserver
//STRIP001 	//========================================================================
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	OFormComponentObserver::OFormComponentObserver(NavigatorTreeModel* _pModel)
//STRIP001 							  :m_pNavModel(_pModel)
//STRIP001 							  ,m_bCanUndo(sal_True)
//STRIP001 							  ,m_nLocks(0)
//STRIP001 	{
//STRIP001 	}
//STRIP001 
//STRIP001 	// XPropertyChangeListener
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void SAL_CALL OFormComponentObserver::disposing(const EventObject& Source) throw( RuntimeException )
//STRIP001 	{
//STRIP001 		Remove( Source.Source );
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void SAL_CALL OFormComponentObserver::propertyChange(const PropertyChangeEvent& evt) throw(RuntimeException)
//STRIP001 	{
//STRIP001 		if( !m_pNavModel ) return;
//STRIP001 		if( evt.PropertyName != FM_PROP_NAME ) return;
//STRIP001 
//STRIP001 		Reference< XFormComponent >  xFormComponent(evt.Source, UNO_QUERY);
//STRIP001 		Reference< XForm >  xForm(evt.Source, UNO_QUERY);
//STRIP001 
//STRIP001 		FmEntryData* pEntryData;
//STRIP001 		if( xForm.is() )
//STRIP001 			pEntryData = m_pNavModel->FindData( xForm, m_pNavModel->GetRootList() );
//STRIP001 		else if( xFormComponent.is() )
//STRIP001 			pEntryData = m_pNavModel->FindData( xFormComponent, m_pNavModel->GetRootList() );
//STRIP001 
//STRIP001 		if( pEntryData )
//STRIP001 		{
//STRIP001 			::rtl::OUString aNewName =  ::comphelper::getString(evt.NewValue);
//STRIP001 			pEntryData->SetText( aNewName );
//STRIP001 			FmNavNameChangedHint aNameChangedHint( pEntryData, aNewName );
//STRIP001 			m_pNavModel->Broadcast( aNameChangedHint );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// XContainerListener
//STRIP001 	//------------------------------------------------------------------------------
//STRIP001 	void SAL_CALL OFormComponentObserver::elementInserted(const ContainerEvent& evt) throw(RuntimeException)
//STRIP001 	{
//STRIP001 		if (IsLocked() || !m_pNavModel)
//STRIP001 			return;
//STRIP001 
//STRIP001 		// keine Undoaction einfuegen
//STRIP001 		m_bCanUndo = sal_False;
//STRIP001 
//STRIP001 		Reference< XInterface > xTemp;
//STRIP001 		evt.Element >>= xTemp;
//STRIP001 		Insert(xTemp, ::comphelper::getINT32(evt.Accessor));
//STRIP001 
//STRIP001 		m_bCanUndo = sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------------
//STRIP001 	void OFormComponentObserver::Insert(const Reference< XInterface > & xIface, sal_Int32 nIndex)
//STRIP001 	{
//STRIP001 		Reference< XForm >  xForm(xIface, UNO_QUERY);
//STRIP001 		if (xForm.is())
//STRIP001 		{
//STRIP001 			m_pNavModel->InsertForm(xForm, sal_uInt32(nIndex));
//STRIP001 			Reference< XIndexContainer >  xContainer(xForm, UNO_QUERY);
//STRIP001 			Reference< XInterface > xTemp;
//STRIP001 			for (sal_Int32 i = 0; i < xContainer->getCount(); i++)
//STRIP001 			{
//STRIP001 				xContainer->getByIndex(i) >>= xTemp;
//STRIP001 				Insert(xTemp, i);
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			Reference< XFormComponent >  xFormComp(xIface, UNO_QUERY);
//STRIP001 			if (xFormComp.is())
//STRIP001 				m_pNavModel->InsertFormComponent(xFormComp, sal_uInt32(nIndex));
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------------
//STRIP001 	void SAL_CALL OFormComponentObserver::elementReplaced(const ContainerEvent& evt) throw(RuntimeException)
//STRIP001 	{
//STRIP001 		if (IsLocked() || !m_pNavModel)
//STRIP001 			return;
//STRIP001 
//STRIP001 		m_bCanUndo = sal_False;
//STRIP001 
//STRIP001 		// EntryData loeschen
//STRIP001 		Reference< XFormComponent >  xReplaced;
//STRIP001 		evt.ReplacedElement >>= xReplaced;
//STRIP001 		FmEntryData* pEntryData = m_pNavModel->FindData(xReplaced, m_pNavModel->GetRootList(), sal_True);
//STRIP001 		if (pEntryData)
//STRIP001 		{
//STRIP001 			if (pEntryData->ISA(FmControlData))
//STRIP001 			{
//STRIP001 				Reference< XFormComponent >  xComp;
//STRIP001 				evt.Element >>= xComp;
//STRIP001 				DBG_ASSERT(xComp.is(), "OFormComponentObserver::elementReplaced : invalid argument !");
//STRIP001 					// an einer FmControlData sollte eine XFormComponent haengen
//STRIP001 				m_pNavModel->ReplaceFormComponent(xReplaced, xComp);
//STRIP001 			}
//STRIP001 			else if (pEntryData->ISA(FmFormData))
//STRIP001 			{
//STRIP001 				DBG_ERROR("replacing forms not implemented yet !");
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		m_bCanUndo = sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------------
//STRIP001 	void OFormComponentObserver::Remove( const ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >& _rxElement )
//STRIP001 	{
//STRIP001 		if (IsLocked() || !m_pNavModel)
//STRIP001 			return;
//STRIP001 
//STRIP001 		m_bCanUndo = sal_False;
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////
//STRIP001 		// EntryData loeschen
//STRIP001 		FmEntryData* pEntryData = m_pNavModel->FindData( _rxElement, m_pNavModel->GetRootList(), sal_True );
//STRIP001 		if (pEntryData)
//STRIP001 			m_pNavModel->Remove(pEntryData);
//STRIP001 
//STRIP001 		m_bCanUndo = sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------------
//STRIP001 	void SAL_CALL OFormComponentObserver::elementRemoved(const ContainerEvent& evt) throw(RuntimeException)
//STRIP001 	{
//STRIP001 		Reference< XInterface > xElement;
//STRIP001 		evt.Element >>= xElement;
//STRIP001 		Remove( xElement );
//STRIP001 	}
//STRIP001 
//STRIP001 	//========================================================================
//STRIP001 	// class NavigatorTreeModel
//STRIP001 	//========================================================================
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	NavigatorTreeModel::NavigatorTreeModel( const ImageList& _rNormalImages, const ImageList& _rHCImages )
//STRIP001 					:m_pFormShell(NULL)
//STRIP001 					,m_pFormPage(NULL)
//STRIP001 					,m_pFormModel(NULL)
//STRIP001 					,m_aNormalImages( _rNormalImages )
//STRIP001 					,m_aHCImages( _rHCImages )
//STRIP001 	{
//STRIP001 		m_pPropChangeList = new OFormComponentObserver(this);
//STRIP001 		m_pPropChangeList->acquire();
//STRIP001 		m_pRootList = new FmEntryDataList();
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	NavigatorTreeModel::~NavigatorTreeModel()
//STRIP001 	{
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Als Listener abmelden
//STRIP001 		if( m_pFormShell)
//STRIP001 		{
//STRIP001 			FmFormModel* pFormModel = m_pFormShell->GetFormModel();
//STRIP001 			if( pFormModel && IsListening(*pFormModel))
//STRIP001 				EndListening( *pFormModel );
//STRIP001 
//STRIP001 			if (IsListening(*m_pFormShell))
//STRIP001 				EndListening(*m_pFormShell);
//STRIP001 		}
//STRIP001 
//STRIP001 		Clear();
//STRIP001 		delete m_pRootList;
//STRIP001 		m_pPropChangeList->ReleaseModel();
//STRIP001 		m_pPropChangeList->release();
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTreeModel::SetModified( sal_Bool bMod )
//STRIP001 	{
//STRIP001 		if( !m_pFormShell ) return;
//STRIP001 		SfxObjectShell* pObjShell = m_pFormShell->GetFormModel()->GetObjectShell();
//STRIP001 		if( !pObjShell ) return;
//STRIP001 		pObjShell->SetModified( bMod );
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTreeModel::Clear()
//STRIP001 	{
//STRIP001 		Reference< XNameContainer >  xForms( GetForms());
//STRIP001 		Reference< XContainer >  xContainer(xForms, UNO_QUERY);
//STRIP001 		if (xContainer.is())
//STRIP001 			xContainer->removeContainerListener((XContainerListener*)m_pPropChangeList);
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// RootList loeschen
//STRIP001 		FmEntryData* pChildData;
//STRIP001 		FmEntryDataList* pRootList = GetRootList();
//STRIP001 
//STRIP001 		for( sal_uInt32 i=pRootList->Count(); i>0; i-- )
//STRIP001 		{
//STRIP001 			pChildData = pRootList->GetObject(i-1);
//STRIP001 			pRootList->Remove( pChildData );
//STRIP001 			delete pChildData;
//STRIP001 		}
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// UI benachrichtigen
//STRIP001 		FmNavClearedHint aClearedHint;
//STRIP001 		Broadcast( aClearedHint );
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	Reference< XNameContainer >  NavigatorTreeModel::GetForms() const
//STRIP001 	{
//STRIP001 		if( !m_pFormShell || !m_pFormShell->GetCurPage())
//STRIP001 			return NULL;
//STRIP001 		else
//STRIP001 			return m_pFormShell->GetCurPage()->GetForms();
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTreeModel::Insert(FmEntryData* pEntry, sal_uInt32 nRelPos, sal_Bool bAlterModel)
//STRIP001 	{
//STRIP001 		if (IsListening(*m_pFormModel))
//STRIP001 			EndListening(*m_pFormModel);
//STRIP001 
//STRIP001 		m_pPropChangeList->Lock();
//STRIP001 		FmFormData* pFolder     = (FmFormData*) pEntry->GetParent();
//STRIP001 		Reference< XChild > xElement( pEntry->GetChildIFace() );
//STRIP001 		if (bAlterModel)
//STRIP001 		{
//STRIP001 			XubString aStr;
//STRIP001 			if (pEntry->ISA(FmFormData))
//STRIP001 				aStr = SVX_RES(RID_STR_FORM);
//STRIP001 			else
//STRIP001 				aStr = SVX_RES(RID_STR_CONTROL);
//STRIP001 
//STRIP001 			Reference< XIndexContainer >  xContainer;
//STRIP001 			if (pFolder)
//STRIP001 				xContainer = Reference< XIndexContainer > (pFolder->GetFormIface(), UNO_QUERY);
//STRIP001 			else
//STRIP001 				xContainer = Reference< XIndexContainer > (GetForms(), UNO_QUERY);
//STRIP001 
//STRIP001 			XubString aUndoStr(SVX_RES(RID_STR_UNDO_CONTAINER_INSERT));
//STRIP001 			aUndoStr.SearchAndReplace('#', aStr);
//STRIP001 			m_pFormModel->BegUndo(aUndoStr);
//STRIP001 
//STRIP001 			if (nRelPos >= (sal_uInt32)xContainer->getCount())
//STRIP001 				nRelPos = (sal_uInt32)xContainer->getCount();
//STRIP001 
//STRIP001 			// UndoAction
//STRIP001 			if (m_pPropChangeList->CanUndo())
//STRIP001 				m_pFormModel->AddUndo(new FmUndoContainerAction(*m_pFormModel,
//STRIP001 														 FmUndoContainerAction::Inserted,
//STRIP001 														 xContainer,
//STRIP001 														 xElement,
//STRIP001 														 nRelPos));
//STRIP001 
//STRIP001 			// das Element muss den Typ haben, den der Container erwartet
//STRIP001 			if (xContainer->getElementType() ==
//STRIP001 				::getCppuType((const Reference< XForm>*)0))
//STRIP001 
//STRIP001 			{
//STRIP001 				Reference< XForm >  xElementAsForm(xElement, UNO_QUERY);
//STRIP001 				xContainer->insertByIndex(nRelPos, makeAny(xElementAsForm));
//STRIP001 			}
//STRIP001 			else if (xContainer->getElementType() ==
//STRIP001 				::getCppuType((const Reference< XFormComponent>*)0))
//STRIP001 
//STRIP001 			{
//STRIP001 				Reference< XFormComponent >  xElementAsComponent(xElement, UNO_QUERY);
//STRIP001 				xContainer->insertByIndex(nRelPos, makeAny(xElementAsComponent));
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				DBG_ERROR("NavigatorTreeModel::Insert : the parent container needs an elementtype I don't know !");
//STRIP001 			}
//STRIP001 
//STRIP001 			m_pFormModel->EndUndo();
//STRIP001 		}
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Als PropertyChangeListener anmelden
//STRIP001 		Reference< XPropertySet >  xSet(xElement, UNO_QUERY);
//STRIP001 		if( xSet.is() )
//STRIP001 			xSet->addPropertyChangeListener( FM_PROP_NAME, m_pPropChangeList );
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Daten aus Model entfernen
//STRIP001 		if (pEntry->ISA(FmFormData))
//STRIP001 		{
//STRIP001 			Reference< XContainer >  xContainer(xElement, UNO_QUERY);
//STRIP001 			if (xContainer.is())
//STRIP001 				xContainer->addContainerListener((XContainerListener*)m_pPropChangeList);
//STRIP001 		}
//STRIP001 
//STRIP001 		if (pFolder)
//STRIP001 			pFolder->GetChildList()->Insert( pEntry, nRelPos );
//STRIP001 		else
//STRIP001 			GetRootList()->Insert( pEntry, nRelPos );
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// UI benachrichtigen
//STRIP001 		FmNavInsertedHint aInsertedHint( pEntry, nRelPos );
//STRIP001 		Broadcast( aInsertedHint );
//STRIP001 
//STRIP001 		m_pPropChangeList->UnLock();
//STRIP001 		if (IsListening(*m_pFormModel))
//STRIP001 			StartListening(*m_pFormModel);
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTreeModel::Remove(FmEntryData* pEntry, sal_Bool bAlterModel)
//STRIP001 	{
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Form und Parent holen
//STRIP001 		if (!pEntry || !m_pFormModel)
//STRIP001 			return;
//STRIP001 
//STRIP001 		if (IsListening(*m_pFormModel))
//STRIP001 			EndListening(*m_pFormModel);
//STRIP001 
//STRIP001 		m_pPropChangeList->Lock();
//STRIP001 		FmFormData*     pFolder     = (FmFormData*) pEntry->GetParent();
//STRIP001 		Reference< XChild > xElement ( pEntry->GetChildIFace() );
//STRIP001 		if (bAlterModel)
//STRIP001 		{
//STRIP001 			XubString        aStr;
//STRIP001 			if (pEntry->ISA(FmFormData))
//STRIP001 				aStr = SVX_RES(RID_STR_FORM);
//STRIP001 			else
//STRIP001 				aStr = SVX_RES(RID_STR_CONTROL);
//STRIP001 
//STRIP001 			XubString aUndoStr(SVX_RES(RID_STR_UNDO_CONTAINER_REMOVE));
//STRIP001 			aUndoStr.SearchAndReplace('#', aStr);
//STRIP001 			m_pFormModel->BegUndo(aUndoStr);
//STRIP001 		}
//STRIP001 
//STRIP001 		// jetzt die eigentliche Entfernung der Daten aus dem Model
//STRIP001 		if (pEntry->ISA(FmFormData))
//STRIP001 			RemoveForm((FmFormData*)pEntry);
//STRIP001 		else
//STRIP001 			RemoveFormComponent((FmControlData*)pEntry);
//STRIP001 
//STRIP001 
//STRIP001 		if (bAlterModel)
//STRIP001 		{
//STRIP001 			Reference< XIndexContainer >  xContainer(xElement->getParent(), UNO_QUERY);
//STRIP001 			// aus dem Container entfernen
//STRIP001 			sal_Int32 nContainerIndex = getElementPos(xContainer.get(), xElement);
//STRIP001 			// UndoAction
//STRIP001 			if (nContainerIndex >= 0)
//STRIP001 			{
//STRIP001 				if (m_pPropChangeList->CanUndo())
//STRIP001 					m_pFormModel->AddUndo(new FmUndoContainerAction(*m_pFormModel,
//STRIP001 														  FmUndoContainerAction::Removed,
//STRIP001 														  xContainer,
//STRIP001 														  xElement, nContainerIndex ));
//STRIP001 				xContainer->removeByIndex(nContainerIndex );
//STRIP001 			}
//STRIP001 			m_pFormModel->EndUndo();
//STRIP001 		}
//STRIP001 
//STRIP001 		// beim Vater austragen
//STRIP001 		if (pFolder)
//STRIP001 			pFolder->GetChildList()->Remove(pEntry);
//STRIP001 		else
//STRIP001 		{
//STRIP001 			GetRootList()->Remove(pEntry);
//STRIP001 			//////////////////////////////////////////////////////////////////////
//STRIP001 			// Wenn keine Form mehr in der Root, an der Shell CurForm zuruecksetzen
//STRIP001 			if (!GetRootList()->Count())
//STRIP001 				m_pFormShell->GetImpl()->setCurForm( Reference< XForm > () );
//STRIP001 		}
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// UI benachrichtigen
//STRIP001 		FmNavRemovedHint aRemovedHint( pEntry );
//STRIP001 		Broadcast( aRemovedHint );
//STRIP001 
//STRIP001 		// Eintrag loeschen
//STRIP001 		delete pEntry;
//STRIP001 
//STRIP001 		m_pPropChangeList->UnLock();
//STRIP001 		StartListening(*m_pFormModel);
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTreeModel::RemoveForm(FmFormData* pFormData)
//STRIP001 	{
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Form und Parent holen
//STRIP001 		if (!pFormData || !m_pFormModel)
//STRIP001 			return;
//STRIP001 
//STRIP001 		FmEntryDataList*    pChildList = pFormData->GetChildList();
//STRIP001 		sal_uInt32 nCount = pChildList->Count();
//STRIP001 		for (sal_uInt32 i = nCount; i > 0; i--)
//STRIP001 		{
//STRIP001 			FmEntryData* pEntryData = pChildList->GetObject(i - 1);
//STRIP001 
//STRIP001 			//////////////////////////////////////////////////////////////////////
//STRIP001 			// Child ist Form -> rekursiver Aufruf
//STRIP001 			if( pEntryData->ISA(FmFormData) )
//STRIP001 				RemoveForm( (FmFormData*)pEntryData);
//STRIP001 			else if( pEntryData->ISA(FmControlData) )
//STRIP001 				RemoveFormComponent((FmControlData*) pEntryData);
//STRIP001 		}
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Als PropertyChangeListener abmelden
//STRIP001 		Reference< XPropertySet > xSet( pFormData->GetPropertySet() );
//STRIP001 		if ( xSet.is() )
//STRIP001 			xSet->removePropertyChangeListener( FM_PROP_NAME, m_pPropChangeList );
//STRIP001 
//STRIP001 		Reference< XContainer >  xContainer( pFormData->GetContainer() );
//STRIP001 		if (xContainer.is())
//STRIP001 			xContainer->removeContainerListener((XContainerListener*)m_pPropChangeList);
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTreeModel::RemoveFormComponent(FmControlData* pControlData)
//STRIP001 	{
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Control und Parent holen
//STRIP001 		if (!pControlData)
//STRIP001 			return;
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Als PropertyChangeListener abmelden
//STRIP001 		Reference< XPropertySet >  xSet( pControlData->GetPropertySet() );
//STRIP001 		if (xSet.is())
//STRIP001 			xSet->removePropertyChangeListener( FM_PROP_NAME, m_pPropChangeList);
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTreeModel::ClearBranch( FmFormData* pParentData )
//STRIP001 	{
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Alle Eintraege dieses Zweiges loeschen
//STRIP001 		FmEntryDataList* pChildList = pParentData->GetChildList();
//STRIP001 		FmEntryData* pChildData;
//STRIP001 
//STRIP001 		for( sal_uInt32 i=pChildList->Count(); i>0; i-- )
//STRIP001 		{
//STRIP001 			pChildData = pChildList->GetObject(i-1);
//STRIP001 			if( pChildData->ISA(FmFormData) )
//STRIP001 				ClearBranch( (FmFormData*)pChildData );
//STRIP001 
//STRIP001 			pChildList->Remove( pChildData );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTreeModel::FillBranch( FmFormData* pFormData )
//STRIP001 	{
//STRIP001 		//////////////////////////////////////////////////////////////
//STRIP001 		// Forms aus der Root einfuegen
//STRIP001 		if( pFormData == NULL )
//STRIP001 		{
//STRIP001 			Reference< XIndexContainer >   xForms(GetForms(), UNO_QUERY);
//STRIP001 			if (!xForms.is())
//STRIP001 				return;
//STRIP001 
//STRIP001 			Reference< XForm >     xSubForm;
//STRIP001 			FmFormData* pSubFormData;
//STRIP001 			for (sal_Int32 i=0; i<xForms->getCount(); ++i)
//STRIP001 			{
//STRIP001 				DBG_ASSERT( xForms->getByIndex(i).getValueType() == ::getCppuType((const Reference< XForm>*)NULL),
//STRIP001 					"NavigatorTreeModel::FillBranch : the root container should supply only elements of type XForm");
//STRIP001 
//STRIP001 				xForms->getByIndex(i) >>= xSubForm;
//STRIP001 				pSubFormData = new FmFormData( xSubForm, m_aNormalImages, m_aHCImages, pFormData );
//STRIP001 				Insert( pSubFormData, LIST_APPEND );
//STRIP001 
//STRIP001 				//////////////////////////////////////////////////////////////
//STRIP001 				// Neuer Branch, wenn SubForm wiederum Subforms enthaelt
//STRIP001 				FillBranch( pSubFormData );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////
//STRIP001 		// Componenten einfuegen
//STRIP001 		else
//STRIP001 		{
//STRIP001 			Reference< XIndexContainer >  xComponents( GetFormComponents(pFormData));
//STRIP001 			if( !xComponents.is() ) return;
//STRIP001 
//STRIP001 			::rtl::OUString aControlName;
//STRIP001 			Reference< XInterface >  xInterface;
//STRIP001 			Reference< XPropertySet >  xSet;
//STRIP001 			FmControlData* pNewControlData;
//STRIP001 			FmFormData* pSubFormData;
//STRIP001 
//STRIP001 			Reference< XFormComponent >  xCurrentComponent;
//STRIP001 			for (sal_Int32 j=0; j<xComponents->getCount(); ++j)
//STRIP001 			{
//STRIP001 				xComponents->getByIndex(j) >>= xCurrentComponent;
//STRIP001 				Reference< XForm >  xSubForm(xCurrentComponent, UNO_QUERY);
//STRIP001 
//STRIP001 				if (xSubForm.is())
//STRIP001 				{   // die aktuelle Component ist eine Form
//STRIP001 					pSubFormData = new FmFormData(xSubForm, m_aNormalImages, m_aHCImages, pFormData);
//STRIP001 					Insert(pSubFormData, LIST_APPEND);
//STRIP001 
//STRIP001 					//////////////////////////////////////////////////////////////
//STRIP001 					// Neuer Branch, wenn SubForm wiederum Subforms enthaelt
//STRIP001 					FillBranch(pSubFormData);
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					pNewControlData = new FmControlData(xCurrentComponent, m_aNormalImages, m_aHCImages, pFormData);
//STRIP001 					Insert(pNewControlData, LIST_APPEND);
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTreeModel::InsertForm(const Reference< XForm > & xForm, sal_uInt32 nRelPos)
//STRIP001 	{
//STRIP001 		FmFormData* pFormData = (FmFormData*)FindData( xForm, GetRootList() );
//STRIP001 		if (pFormData)
//STRIP001 			return;
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////
//STRIP001 		// ParentData setzen
//STRIP001 		Reference< XInterface >  xIFace( xForm->getParent());
//STRIP001 		Reference< XForm >  xParentForm(xIFace, UNO_QUERY);
//STRIP001 		FmFormData* pParentData = NULL;
//STRIP001 		if (xParentForm.is())
//STRIP001 			pParentData = (FmFormData*)FindData( xParentForm, GetRootList() );
//STRIP001 
//STRIP001 		pFormData = new FmFormData( xForm, m_aNormalImages, m_aHCImages, pParentData );
//STRIP001 		Insert( pFormData, nRelPos );
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTreeModel::InsertFormComponent(const Reference< XFormComponent > & xComp, sal_uInt32 nRelPos)
//STRIP001 	{
//STRIP001 		//////////////////////////////////////////////////////////
//STRIP001 		// ParentData setzen
//STRIP001 		Reference< XInterface >  xIFace( xComp->getParent());
//STRIP001 		Reference< XForm >  xForm(xIFace, UNO_QUERY);
//STRIP001 		if (!xForm.is())
//STRIP001 			return;
//STRIP001 
//STRIP001 		FmFormData* pParentData = (FmFormData*)FindData( xForm, GetRootList() );
//STRIP001 		if( !pParentData )
//STRIP001 		{
//STRIP001 			pParentData = new FmFormData( xForm, m_aNormalImages, m_aHCImages, NULL );
//STRIP001 			Insert( pParentData, LIST_APPEND );
//STRIP001 		}
//STRIP001 
//STRIP001 		if (!FindData(xComp, pParentData->GetChildList(),sal_False))
//STRIP001 		{
//STRIP001 			//////////////////////////////////////////////////////////
//STRIP001 			// Neue EntryData setzen
//STRIP001 			FmEntryData* pNewEntryData = new FmControlData( xComp, m_aNormalImages, m_aHCImages, pParentData );
//STRIP001 
//STRIP001 			//////////////////////////////////////////////////////////
//STRIP001 			// Neue EntryData einfuegen
//STRIP001 			Insert( pNewEntryData, nRelPos );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTreeModel::ReplaceFormComponent(const Reference< XFormComponent > & xOld, const Reference< XFormComponent > & xNew)
//STRIP001 	{
//STRIP001 		FmEntryData* pData = FindData(xOld, GetRootList(), sal_True);
//STRIP001 		DBG_ASSERT(pData && pData->ISA(FmControlData), "NavigatorTreeModel::ReplaceFormComponent : invalid argument !");
//STRIP001 		((FmControlData*)pData)->ModelReplaced( xNew, m_aNormalImages, m_aHCImages );
//STRIP001 
//STRIP001 		FmNavModelReplacedHint aReplacedHint( pData );
//STRIP001 		Broadcast( aReplacedHint );
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	FmEntryData* NavigatorTreeModel::FindData(const Reference< XInterface > & xElement, FmEntryDataList* pDataList, sal_Bool bRecurs)
//STRIP001 	{
//STRIP001 		// normalize
//STRIP001 		Reference< XInterface > xIFace( xElement, UNO_QUERY );
//STRIP001 
//STRIP001 		for (sal_uInt16 i=0; i < pDataList->Count(); i++)
//STRIP001 		{
//STRIP001 			FmEntryData* pEntryData = pDataList->GetObject(i);
//STRIP001 			if ( pEntryData->GetElement().get() == xIFace.get() )
//STRIP001 				return pEntryData;
//STRIP001 			else if (bRecurs)
//STRIP001 			{
//STRIP001 				pEntryData = FindData( xElement, pEntryData->GetChildList() );
//STRIP001 				if (pEntryData)
//STRIP001 					return pEntryData;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		return NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	FmEntryData* NavigatorTreeModel::FindData( const ::rtl::OUString& rText, FmFormData* pParentData, sal_Bool bRecurs )
//STRIP001 	{
//STRIP001 		FmEntryDataList* pDataList;
//STRIP001 		if( !pParentData )
//STRIP001 			pDataList = GetRootList();
//STRIP001 		else
//STRIP001 			pDataList = pParentData->GetChildList();
//STRIP001 
//STRIP001 		::rtl::OUString aEntryText;
//STRIP001 		FmEntryData* pEntryData;
//STRIP001 		FmEntryData* pChildData;
//STRIP001 
//STRIP001 		for( sal_uInt16 i=0; i<pDataList->Count(); i++ )
//STRIP001 		{
//STRIP001 			pEntryData = pDataList->GetObject(i);
//STRIP001 			aEntryText = pEntryData->GetText();
//STRIP001 
//STRIP001 			if (rText == aEntryText)
//STRIP001 				return pEntryData;
//STRIP001 
//STRIP001 			if( bRecurs && pEntryData->ISA(FmFormData) )
//STRIP001 			{
//STRIP001 				pChildData = FindData( rText, (FmFormData*)pEntryData );
//STRIP001 				if( pChildData )
//STRIP001 					return pChildData;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		return NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTreeModel::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
//STRIP001 	{
//STRIP001 		if( rHint.ISA(SdrHint) )
//STRIP001 		{
//STRIP001 			SdrHint* pSdrHint = (SdrHint*)&rHint;
//STRIP001 			switch( pSdrHint->GetKind() )
//STRIP001 			{
//STRIP001 				case HINT_OBJINSERTED:
//STRIP001 					InsertSdrObj(pSdrHint->GetObject());
//STRIP001 					break;
//STRIP001 				case HINT_OBJREMOVED:
//STRIP001 					RemoveSdrObj(pSdrHint->GetObject());
//STRIP001 					break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		// hat sich die shell verabschiedet?
//STRIP001 		else if ( rHint.ISA(SfxSimpleHint) && ((SfxSimpleHint&)rHint).GetId() == SFX_HINT_DYING)
//STRIP001 			Update((FmFormShell*)NULL);
//STRIP001 
//STRIP001 		// hat sich die Markierung der Controls veraendert ?
//STRIP001 		else if (rHint.ISA(FmNavViewMarksChanged))
//STRIP001 		{
//STRIP001 			FmNavViewMarksChanged* pvmcHint = (FmNavViewMarksChanged*)&rHint;
//STRIP001 			BroadcastMarkedObjects( pvmcHint->GetAffectedView()->GetMarkList() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTreeModel::InsertSdrObj(const SdrObject* pObj)
//STRIP001 	{
//STRIP001 		if (pObj->GetObjInventor() == FmFormInventor)
//STRIP001 		{                                           //////////////////////////////////////////////////////////////////////
//STRIP001 			// Ist dieses Objekt ein XFormComponent?
//STRIP001 			Reference< XFormComponent >  xFormComponent(((SdrUnoObj*)pObj)->GetUnoControlModel(), UNO_QUERY);
//STRIP001 			if (xFormComponent.is())
//STRIP001 			{
//STRIP001 				Reference< XIndexContainer >  xContainer(xFormComponent->getParent(), UNO_QUERY);
//STRIP001 				if (xContainer.is())
//STRIP001 				{
//STRIP001 					sal_Int32 nPos = getElementPos(Reference< XIndexAccess > (xContainer, UNO_QUERY), xFormComponent);
//STRIP001 					InsertFormComponent(xFormComponent, nPos);
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if (pObj->IsGroupObject())
//STRIP001 		{
//STRIP001 			SdrObjListIter aIter(*pObj->GetSubList());
//STRIP001 			while (aIter.IsMore())
//STRIP001 				InsertSdrObj(aIter.Next());
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTreeModel::RemoveSdrObj(const SdrObject* pObj)
//STRIP001 	{
//STRIP001 		if (pObj->GetObjInventor() == FmFormInventor)
//STRIP001 		{                                           //////////////////////////////////////////////////////////////////////
//STRIP001 			// Ist dieses Objekt ein XFormComponent?
//STRIP001 			Reference< XFormComponent >  xFormComponent(((SdrUnoObj*)pObj)->GetUnoControlModel(), UNO_QUERY);
//STRIP001 			if (xFormComponent.is())
//STRIP001 			{
//STRIP001 				FmEntryData* pEntryData = FindData(xFormComponent, GetRootList(), sal_True);
//STRIP001 				if (pEntryData)
//STRIP001 					Remove(pEntryData);
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if (pObj->IsGroupObject())
//STRIP001 		{
//STRIP001 			SdrObjListIter aIter(*pObj->GetSubList());
//STRIP001 			while (aIter.IsMore())
//STRIP001 				RemoveSdrObj(aIter.Next());
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	sal_Bool NavigatorTreeModel::InsertFormComponent(FmNavRequestSelectHint& rHint, SdrObject* pObject)
//STRIP001 	{
//STRIP001 		if ( pObject->ISA(SdrObjGroup) )
//STRIP001 		{   // rekursiv absteigen
//STRIP001 			const SdrObjList *pChilds = ((SdrObjGroup*)pObject)->GetSubList();
//STRIP001 			for ( sal_uInt16 i=0; i<pChilds->GetObjCount(); ++i )
//STRIP001 			{
//STRIP001 				SdrObject* pCurrent = pChilds->GetObj(i);
//STRIP001 				if (!InsertFormComponent(rHint, pCurrent))
//STRIP001 					return sal_False;
//STRIP001 			}
//STRIP001 		} else
//STRIP001 			if (pObject->IsUnoObj())
//STRIP001 			{
//STRIP001 				Reference< XInterface >  xControlModel( ((SdrUnoObj*)pObject)->GetUnoControlModel());
//STRIP001 				// Ist dieses Objekt ein XFormComponent?
//STRIP001 				Reference< XFormComponent >  xFormViewControl(xControlModel, UNO_QUERY);
//STRIP001 				if (xFormViewControl.is())
//STRIP001 				{   // es ist ein Form-Control -> selektieren lassen
//STRIP001 					FmEntryData* pControlData = FindData( xFormViewControl, GetRootList() );
//STRIP001 					if (pControlData)
//STRIP001 						rHint.AddItem( pControlData );
//STRIP001 				} else
//STRIP001 				{   // es ist kein Form-Control -> im Baum ueberhaupt nix selektieren lassen
//STRIP001 					return sal_False;
//STRIP001 				}
//STRIP001 			} else
//STRIP001 				return sal_False;
//STRIP001 
//STRIP001 		return sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	void NavigatorTreeModel::BroadcastMarkedObjects(const SdrMarkList& mlMarked)
//STRIP001 	{
//STRIP001 		// gehen wir durch alle markierten Objekte und suchen wir die raus, mit denen ich was anfangen kann
//STRIP001 		FmNavRequestSelectHint rshRequestSelection;
//STRIP001 		sal_Bool bIsMixedSelection = sal_False;
//STRIP001 
//STRIP001 		for (ULONG i=0; (i<mlMarked.GetMarkCount()) && !bIsMixedSelection; i++)
//STRIP001 		{
//STRIP001 			SdrObject* pobjCurrent = mlMarked.GetMark(i)->GetObj();
//STRIP001 			bIsMixedSelection |= !InsertFormComponent(rshRequestSelection, pobjCurrent);
//STRIP001 				// bei einem Nicht-Form-Control liefert InsertFormComponent sal_False !
//STRIP001 		}
//STRIP001 
//STRIP001 		rshRequestSelection.SetMixedSelection(bIsMixedSelection);
//STRIP001 		if (bIsMixedSelection)
//STRIP001 			rshRequestSelection.ClearItems();
//STRIP001 
//STRIP001 		Broadcast(rshRequestSelection);
//STRIP001 			// eine leere Liste interpretiert der NavigatorTree so, dass er seine Selektion komplett rausnimmt
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTreeModel::Update( const Reference< XNameContainer > & xForms )
//STRIP001 	{
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Model von der Root aufwaerts neu fuellen
//STRIP001 		Clear();
//STRIP001 		if (xForms.is())
//STRIP001 		{
//STRIP001 			Reference< XContainer >  xFormContainer(xForms, UNO_QUERY);
//STRIP001 			if (xFormContainer.is())
//STRIP001 				xFormContainer->addContainerListener((XContainerListener*)m_pPropChangeList);
//STRIP001 
//STRIP001 			FillBranch(NULL);
//STRIP001 
//STRIP001 			// jetzt in meinem Tree genau die das in meiner View markierte Control selektieren
//STRIP001 			// (bzw alle solchen), falls es eines gibt ...
//STRIP001 			if(!m_pFormShell) return;       // keine Shell -> wech
//STRIP001 
//STRIP001 			FmFormView* pFormView = m_pFormShell->GetFormView();
//STRIP001 			DBG_ASSERT(pFormView != NULL, "NavigatorTreeModel::Update : keine FormView");
//STRIP001 			BroadcastMarkedObjects(pFormView->GetMarkList());
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	void NavigatorTreeModel::Update( FmFormShell* pShell )
//STRIP001 	{
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Wenn Shell sich nicht veraendert hat, nichts machen
//STRIP001 		FmFormPage* pNewPage = pShell ? pShell->GetCurPage() : NULL;
//STRIP001 		if ((pShell == m_pFormShell) && (m_pFormPage == pNewPage))
//STRIP001 			return;
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Als Listener abmelden
//STRIP001 		if( m_pFormShell )
//STRIP001 		{
//STRIP001 			if (m_pFormModel)
//STRIP001 				EndListening( *m_pFormModel );
//STRIP001 			m_pFormModel = NULL;
//STRIP001 			EndListening( *m_pFormShell );
//STRIP001 			Clear();
//STRIP001 		}
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Vollupdate
//STRIP001 		m_pFormShell = pShell;
//STRIP001 		if (m_pFormShell)
//STRIP001 		{
//STRIP001 			m_pFormPage = pNewPage;
//STRIP001 			Update(m_pFormPage->GetForms());
//STRIP001 		} else
//STRIP001 			m_pFormPage = NULL;
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Als Listener neu anmelden
//STRIP001 		if( m_pFormShell )
//STRIP001 		{
//STRIP001 			StartListening( *m_pFormShell );
//STRIP001 			m_pFormModel = m_pFormShell->GetFormModel();
//STRIP001 			if( m_pFormModel )
//STRIP001 				StartListening( *m_pFormModel );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	Reference< XIndexContainer >  NavigatorTreeModel::GetFormComponents( FmFormData* pFormData )
//STRIP001 	{
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Von der Form Components holen
//STRIP001 		if (pFormData)
//STRIP001 			return Reference< XIndexContainer > (pFormData->GetFormIface(), UNO_QUERY);
//STRIP001 
//STRIP001 		return Reference< XIndexContainer > ();
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	sal_Bool NavigatorTreeModel::CheckEntry( FmEntryData* pEntryData )
//STRIP001 	{
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Nur Forms duerfen auf Doppeldeutigkeit untersucht werden
//STRIP001 		if( !pEntryData->ISA(FmFormData) ) return sal_True;
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// ChildListe des Parents holen
//STRIP001 		FmFormData* pParentData = (FmFormData*)pEntryData->GetParent();
//STRIP001 		FmEntryDataList* pChildList;
//STRIP001 		if( !pParentData )
//STRIP001 			pChildList = GetRootList();
//STRIP001 		else
//STRIP001 			pChildList = pParentData->GetChildList();
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// In ChildListe nach doppelten Namen suchen
//STRIP001 		::rtl::OUString aChildText;
//STRIP001 		FmEntryData* pChildData;
//STRIP001 
//STRIP001 		for( sal_uInt16 i=0; i<pChildList->Count(); i++ )
//STRIP001 		{
//STRIP001 			pChildData = pChildList->GetObject(i);
//STRIP001 			aChildText = pChildData->GetText();
//STRIP001 
//STRIP001 			//////////////////////////////////////////////////////////////////////
//STRIP001 			// Gleichen Eintrag gefunden
//STRIP001 			if	(	(aChildText == pEntryData->GetText())
//STRIP001 				&&	(pEntryData!=pChildData)
//STRIP001 				)
//STRIP001 			{
//STRIP001 				
//STRIP001 
//STRIP001 				SQLContext aError;
//STRIP001 				aError.Message = String(SVX_RES(RID_ERR_CONTEXT_ADDFORM));
//STRIP001 				aError.Details = String(SVX_RES(RID_ERR_DUPLICATE_NAME));
//STRIP001 				displayException(aError);
//STRIP001 
//STRIP001 				return sal_False;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		return sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	sal_Bool NavigatorTreeModel::Rename( FmEntryData* pEntryData, const ::rtl::OUString& rNewText )
//STRIP001 	{
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Wenn Name schon vorhanden, Fehlermeldung
//STRIP001 		pEntryData->SetText( rNewText );
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// PropertySet besorgen
//STRIP001 		Reference< XFormComponent >  xFormComponent;
//STRIP001 
//STRIP001 		if( pEntryData->ISA(FmFormData) )
//STRIP001 		{
//STRIP001 			FmFormData* pFormData = (FmFormData*)pEntryData;
//STRIP001 			Reference< XForm >  xForm( pFormData->GetFormIface());
//STRIP001 			xFormComponent = Reference< XFormComponent > (xForm, UNO_QUERY);
//STRIP001 		}
//STRIP001 
//STRIP001 		if( pEntryData->ISA(FmControlData) )
//STRIP001 		{
//STRIP001 			FmControlData* pControlData = (FmControlData*)pEntryData;
//STRIP001 			xFormComponent = pControlData->GetFormComponent();
//STRIP001 		}
//STRIP001 
//STRIP001 		if( !xFormComponent.is() ) return sal_False;
//STRIP001 		Reference< XPropertySet >  xSet(xFormComponent, UNO_QUERY);
//STRIP001 		if( !xSet.is() ) return sal_False;
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Namen setzen
//STRIP001 		xSet->setPropertyValue( FM_PROP_NAME, makeAny(rNewText) );
//STRIP001 
//STRIP001 		return sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	sal_Bool NavigatorTreeModel::IsNameAlreadyDefined( const ::rtl::OUString& rName, FmFormData* pParentData )
//STRIP001 	{
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Form in der Root
//STRIP001 		if( !pParentData )
//STRIP001 		{
//STRIP001 			if (GetForms()->hasByName(rName))
//STRIP001 				return sal_True;
//STRIP001 		}
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// Restliche Components
//STRIP001 		else
//STRIP001 		{
//STRIP001 			Reference< XNameContainer >  xFormComponents(GetFormComponents(pParentData), UNO_QUERY);
//STRIP001 			if (xFormComponents.is() && xFormComponents->hasByName(rName))
//STRIP001 				return sal_True;
//STRIP001 		}
//STRIP001 
//STRIP001 		return sal_False;
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------------
//STRIP001 	SdrObject* NavigatorTreeModel::GetSdrObj( FmControlData* pControlData )
//STRIP001 	{
//STRIP001 		if (!pControlData || !m_pFormShell)
//STRIP001 			return NULL;
//STRIP001 
//STRIP001 		//////////////////////////////////////////////////////////////////////
//STRIP001 		// In der Page das entsprechende SdrObj finden und selektieren
//STRIP001 		Reference< XFormComponent >  xFormComponent( pControlData->GetFormComponent());
//STRIP001 		if (!xFormComponent.is())
//STRIP001 			return NULL;
//STRIP001 
//STRIP001 		FmFormView*     pFormView       = m_pFormShell->GetFormView();
//STRIP001 		SdrPageView*    pPageView       = pFormView->GetPageViewPvNum(0);
//STRIP001 		SdrPage*        pPage           = pPageView->GetPage();
//STRIP001 
//STRIP001 		SdrObjListIter  aIter( *pPage );
//STRIP001 		return Search(aIter, xFormComponent);
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------------------------------------------------------------
//STRIP001 	SdrObject* NavigatorTreeModel::Search(SdrObjListIter& rIter, const Reference< XFormComponent > & xComp)
//STRIP001 	{
//STRIP001 		while (rIter.IsMore())
//STRIP001 		{
//STRIP001 			SdrObject* pObj = rIter.Next();
//STRIP001 			//////////////////////////////////////////////////////////////////////
//STRIP001 			// Es interessieren nur Uno-Objekte
//STRIP001 			if (pObj->GetObjInventor() == FmFormInventor)
//STRIP001 			{                                           //////////////////////////////////////////////////////////////////////
//STRIP001 				// Ist dieses Objekt ein XFormComponent?
//STRIP001 				Reference< XFormComponent >  xFormViewControl(((SdrUnoObj*)pObj)->GetUnoControlModel(), UNO_QUERY);
//STRIP001 				if (xFormViewControl == xComp)
//STRIP001 					return pObj;
//STRIP001 			}
//STRIP001 			else if (pObj->IsGroupObject())
//STRIP001 			{
//STRIP001 				SdrObjListIter aIter(*pObj->GetSubList());
//STRIP001 				pObj = Search(aIter, xComp);
//STRIP001 				if (pObj)
//STRIP001 					return pObj;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		return NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 //............................................................................
//STRIP001 }	// namespace svxform
//............................................................................


}
