/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_iconcdlg.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:51:15 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SFXAPP_HXX
#include <bf_sfx2/app.hxx>
#endif

#ifndef _TOOLS_RC_H
#include <tools/rc.h>
#endif
#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif

#define _SVSTDARR_USHORTS
#include <svtools/svstdarr.hxx>

#ifndef _SVX_DIALMGR_HXX
#include "dialmgr.hxx"
#endif

#include "iconcdlg.hxx"

#ifndef _SVX_HELPID_HRC
#include "helpid.hrc"
#endif
#ifndef _SVX_DIALOGS_HRC
#include "dialogs.hrc"
#endif

#ifndef INCLUDED_SVTOOLS_VIEWOPTIONS_HXX
#include <svtools/viewoptions.hxx>
#endif
#ifndef _SV_MNEMONIC_HXX
#include <vcl/mnemonic.hxx>
#endif
#ifndef _VCL_I18NHELP_HXX
#include <vcl/i18nhelp.hxx>
#endif
namespace binfilter {

//STRIP001 #ifdef WNT
//STRIP001 int __cdecl IconcDlgCmpUS_Impl( const void* p1, const void* p2 )
//STRIP001 #else
//STRIP001 #if defined(OS2) && defined(ICC)
//STRIP001 int _Optlink IconcDlgCmpUS_Impl( const void* p1, const void* p2 )
//STRIP001 #else
//STRIP001 int IconcDlgCmpUS_Impl( const void* p1, const void* p2 )
//STRIP001 #endif
//STRIP001 #endif
//STRIP001 {
//STRIP001 	return *(USHORT*)p1 - *(USHORT*)p2;
//STRIP001 }
//STRIP001 
//STRIP001 // some stuff for easier changes for SvtViewOptions
//STRIP001 static const sal_Char*		pViewOptDataName = "dialog data";
//STRIP001 #define VIEWOPT_DATANAME	::rtl::OUString::createFromAscii( pViewOptDataName )
//STRIP001 
//STRIP001 static inline void SetViewOptUserItem( SvtViewOptions& rOpt, const String& rData )
//STRIP001 {
//STRIP001 	rOpt.SetUserItem( VIEWOPT_DATANAME, ::com::sun::star::uno::makeAny( ::rtl::OUString( rData ) ) );
//STRIP001 }
//STRIP001 
//STRIP001 static inline String GetViewOptUserItem( const SvtViewOptions& rOpt )
//STRIP001 {
//STRIP001 	::com::sun::star::uno::Any aAny( rOpt.GetUserItem( VIEWOPT_DATANAME ) );
//STRIP001 	::rtl::OUString aUserData;
//STRIP001 	aAny >>= aUserData;
//STRIP001 
//STRIP001 	return String( aUserData );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 //#####################################################################
//STRIP001 //
//STRIP001 // Class IconChoicePage
//STRIP001 //
//STRIP001 //#####################################################################
//STRIP001 
//STRIP001 /**********************************************************************
//STRIP001 |
//STRIP001 | Ctor / Dtor
//STRIP001 |
//STRIP001 \**********************************************************************/
//STRIP001 
//STRIP001 IconChoicePage::IconChoicePage( Window *pParent, const ResId &rResId,
//STRIP001 							    const SfxItemSet &rAttrSet )
//STRIP001 :	TabPage					  ( pParent, rResId ),
//STRIP001 	pSet					  ( &rAttrSet ),
//STRIP001 	bHasExchangeSupport		  ( FALSE ),
//STRIP001 	pDialog					  ( NULL ),
//STRIP001 	bStandard				  ( FALSE )
//STRIP001 {
//STRIP001 	SetStyle ( GetStyle()  | WB_DIALOGCONTROL | WB_HIDE );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IconChoicePage::~IconChoicePage()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 /**********************************************************************
//STRIP001 |
//STRIP001 | Activate / Deaktivate
//STRIP001 |
//STRIP001 \**********************************************************************/
//STRIP001 
//STRIP001 void IconChoicePage::ActivatePage( const SfxItemSet& )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 int IconChoicePage::DeactivatePage( SfxItemSet* )
//STRIP001 {
//STRIP001 	return LEAVE_PAGE;
//STRIP001 }
//STRIP001 
//STRIP001 /**********************************************************************
//STRIP001 |
//STRIP001 | ...
//STRIP001 |
//STRIP001 \**********************************************************************/
//STRIP001 
//STRIP001 void IconChoicePage::FillUserData()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL IconChoicePage::IsReadOnly() const
//STRIP001 {
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 /**********************************************************************
//STRIP001 |
//STRIP001 | handling itemsets
//STRIP001 |
//STRIP001 \**********************************************************************/
//STRIP001 
//STRIP001 const SfxPoolItem* IconChoicePage::GetItem( const SfxItemSet& rSet,
//STRIP001 										    USHORT nSlot )
//STRIP001 {
//STRIP001 	const SfxItemPool* pPool = rSet.GetPool();
//STRIP001 	USHORT nWh = pPool->GetWhich( nSlot );
//STRIP001 	const SfxPoolItem* pItem = 0;
//STRIP001 	SfxItemState eState = rSet.GetItemState( nWh, TRUE, &pItem );
//STRIP001 
//STRIP001 	if ( !pItem && nWh != nSlot )
//STRIP001 		pItem = &pPool->GetDefaultItem( nWh );
//STRIP001 
//STRIP001 	return pItem;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 const SfxPoolItem* IconChoicePage::GetOldItem( const SfxItemSet& rSet,
//STRIP001 											   USHORT nSlot )
//STRIP001 {
//STRIP001 	const SfxItemSet& rOldSet = GetItemSet();
//STRIP001 	USHORT nWh = GetWhich( nSlot );
//STRIP001 	const SfxPoolItem* pItem = 0;
//STRIP001 
//STRIP001 	if ( bStandard && rOldSet.GetParent() )
//STRIP001 		pItem = GetItem( *rOldSet.GetParent(), nSlot );
//STRIP001 	else if ( rSet.GetParent() && SFX_ITEM_DONTCARE == rSet.GetItemState( nWh ) )
//STRIP001 		pItem = GetItem( *rSet.GetParent(), nSlot );
//STRIP001 	else
//STRIP001 		pItem = GetItem( rOldSet, nSlot );
//STRIP001 
//STRIP001 	return pItem;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 const SfxPoolItem* IconChoicePage::GetExchangeItem( const SfxItemSet& rSet,
//STRIP001 												    USHORT nSlot )
//STRIP001 {
//STRIP001 	if ( pDialog && !pDialog->IsInOK() && pDialog->GetExampleSet() )
//STRIP001 		return GetItem( *pDialog->GetExampleSet(), nSlot );
//STRIP001 	else
//STRIP001 		return GetOldItem( rSet, nSlot );
//STRIP001 }
//STRIP001 
//STRIP001 /**********************************************************************
//STRIP001 |
//STRIP001 | window-methods
//STRIP001 |
//STRIP001 \**********************************************************************/
//STRIP001 
//STRIP001 void IconChoicePage::ImplInitSettings()
//STRIP001 {
//STRIP001 	Window* pParent = GetParent();
//STRIP001 	if ( pParent->IsChildTransparentModeEnabled() && !IsControlBackground() )
//STRIP001 	{
//STRIP001 		EnableChildTransparentMode( TRUE );
//STRIP001 		SetParentClipMode( PARENTCLIPMODE_NOCLIP );
//STRIP001 		SetPaintTransparent( TRUE );
//STRIP001 		SetBackground();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		EnableChildTransparentMode( FALSE );
//STRIP001 		SetParentClipMode( 0 );
//STRIP001 		SetPaintTransparent( FALSE );
//STRIP001 
//STRIP001 		if ( IsControlBackground() )
//STRIP001 			SetBackground( GetControlBackground() );
//STRIP001 		else
//STRIP001 			SetBackground( pParent->GetBackground() );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void IconChoicePage::StateChanged( StateChangedType nType )
//STRIP001 {
//STRIP001 	Window::StateChanged( nType );
//STRIP001 
//STRIP001 	if ( nType == STATE_CHANGE_CONTROLBACKGROUND )
//STRIP001 	{
//STRIP001 		ImplInitSettings();
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void IconChoicePage::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	Window::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001 		 (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001 	{
//STRIP001 		ImplInitSettings();
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //#####################################################################
//STRIP001 //
//STRIP001 // Class IconChoiceDialog
//STRIP001 //
//STRIP001 //#####################################################################
//STRIP001 
//STRIP001 /**********************************************************************
//STRIP001 |
//STRIP001 | Ctor / Dtor
//STRIP001 |
//STRIP001 \**********************************************************************/
//STRIP001 
//STRIP001 IconChoiceDialog::IconChoiceDialog ( Window* pParent, const ResId &rResId,
//STRIP001 									 const EIconChoicePos ePos,
//STRIP001 									 const SfxItemSet *pItemSet )//, BOOL bEditFmt, const String *pUserButtonText = 0 )
//STRIP001 : 	ModalDialog			( pParent, rResId ),
//STRIP001 	aOKBtn			( this, WB_DEFBUTTON ),
//STRIP001 	aCancelBtn		( this, WB_DEFBUTTON ),
//STRIP001 	aHelpBtn		( this ),
//STRIP001 	aResetBtn		( this ),
//STRIP001 	//pUserBtn		( pUserButtonText? new PushButton(this): 0 ),
//STRIP001 	//aBaseFmtBtn		( this ),
//STRIP001 	maIconCtrl		( this, WB_3DLOOK | WB_ICON | WB_BORDER |
//STRIP001 							WB_NOCOLUMNHEADER | WB_HIGHLIGHTFRAME |
//STRIP001 							/* WB_NOSELECTION | */ WB_NODRAGSELECTION | WB_TABSTOP ),
//STRIP001 	meChoicePos		( ePos ),
//STRIP001 	mnCurrentPageId	( USHRT_MAX ),
//STRIP001 	pSet			( pItemSet ),
//STRIP001 	pExampleSet		( NULL ),
//STRIP001 	pOutSet			( NULL ),
//STRIP001 	pRanges			( NULL ),
//STRIP001 	bHideResetBtn	( FALSE ),
//STRIP001 	bModal			( FALSE ),
//STRIP001 	bInOK			( FALSE ),
//STRIP001 	bModified		( FALSE ),
//STRIP001 	bItemsReset		( FALSE ),
//STRIP001 	nResId			( rResId.GetId() )
//STRIP001 {
//STRIP001 	// IconChoiceCtrl-Settings
//STRIP001 	//maIconCtrl.SetBackground ( Wallpaper( Color (146, 146, 186) ) );
//STRIP001 
//STRIP001 	maIconCtrl.SetStyle (WB_3DLOOK | WB_ICON | WB_BORDER | WB_NOCOLUMNHEADER | WB_HIGHLIGHTFRAME | /* WB_NOSELECTION | */ WB_NODRAGSELECTION | WB_TABSTOP | WB_CLIPCHILDREN );
//STRIP001 	SetCtrlPos ( meChoicePos );
//STRIP001 	maIconCtrl.SetClickHdl ( LINK ( this, IconChoiceDialog , ChosePageHdl_Impl ) );
//STRIP001 	maIconCtrl.Show();
//STRIP001 	maIconCtrl.SetChoiceWithCursor ( TRUE );
//STRIP001 	maIconCtrl.SetSelectionMode( SINGLE_SELECTION );
//STRIP001 	maIconCtrl.SetHelpId( HID_ICCDIALOG_CHOICECTRL );
//STRIP001 
//STRIP001 	// ItemSet
//STRIP001 	if ( pSet )
//STRIP001 	{
//STRIP001 		pExampleSet = new SfxItemSet( *pSet );
//STRIP001 		pOutSet = new SfxItemSet( *pSet->GetPool(), pSet->GetRanges() );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Buttons
//STRIP001 	aOKBtn.SetClickHdl	 ( LINK( this, IconChoiceDialog, OkHdl ) );
//STRIP001 	aOKBtn.SetHelpId( HID_ICCDIALOG_OK_BTN );
//STRIP001 	aCancelBtn.SetHelpId( HID_ICCDIALOG_CANCEL_BTN );
//STRIP001 	aResetBtn.SetClickHdl( LINK( this, IconChoiceDialog, ResetHdl ) );
//STRIP001 	aResetBtn.SetText( SVX_RESSTR(RID_SVXSTR_ICONCHOICEDLG_RESETBUT) );
//STRIP001 	aResetBtn.SetHelpId( HID_ICCDIALOG_RESET_BTN );
//STRIP001 	aOKBtn.Show();
//STRIP001 	aCancelBtn.Show();
//STRIP001 	aHelpBtn.Show();
//STRIP001 	aResetBtn.Show();
//STRIP001 
//STRIP001 	SetPosSizeCtrls ( TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 /*
//STRIP001 IconChoiceDialog ::IconChoiceDialog ( SfxViewFrame *pViewFrame, Window* pParent, const ResId &rResId,
//STRIP001 				   const SfxItemSet * = 0, BOOL bEditFmt = FALSE,
//STRIP001 				   const String *pUserButtonText = 0 )
//STRIP001 : 	meChoicePos		( PosLeft ),	// Default erst ma Links
//STRIP001 	maIconCtrl		( this, Die_Winbits ),
//STRIP001 	aOKBtn			( this ),
//STRIP001 	pUserBtn		( pUserButtonText? new PushButton(this): 0 ),
//STRIP001 	aCancelBtn		( this ),
//STRIP001 	aHelpBtn		( this ),
//STRIP001 	aResetBtn		( this ),
//STRIP001 	aBaseFmtBtn		( this ),
//STRIP001 	mnCurrentPageId	( 0 )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 }
//STRIP001 */
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IconChoiceDialog ::~IconChoiceDialog ()
//STRIP001 {
//STRIP001 	ULONG i;
//STRIP001 
//STRIP001 	// save configuration at INI-Manager
//STRIP001 	// and remove pages
//STRIP001 	SvtViewOptions aTabDlgOpt( E_TABDIALOG, String::CreateFromInt32( nResId ) );
//STRIP001 	aTabDlgOpt.SetWindowState( ::rtl::OUString::createFromAscii( GetWindowState((WINDOWSTATE_MASK_X | WINDOWSTATE_MASK_Y | WINDOWSTATE_MASK_STATE | WINDOWSTATE_MASK_MINIMIZED)).GetBuffer() ) );
//STRIP001 	aTabDlgOpt.SetPageID( mnCurrentPageId );
//STRIP001 
//STRIP001 	const ULONG nCount = maPageList.Count();
//STRIP001 
//STRIP001 	for ( i = 0; i < nCount; ++i )
//STRIP001 	{
//STRIP001 		IconChoicePageData* pData = maPageList.GetObject(i);
//STRIP001 
//STRIP001 		if ( pData->pPage )
//STRIP001 		{
//STRIP001 			pData->pPage->FillUserData();
//STRIP001 			String aPageData(pData->pPage->GetUserData());
//STRIP001 			if ( aPageData.Len() )
//STRIP001 			{
//STRIP001 				SvtViewOptions aTabPageOpt( E_TABPAGE, String::CreateFromInt32( pData->nId ) );
//STRIP001 
//STRIP001 				SetViewOptUserItem( aTabPageOpt, aPageData );
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( pData->bOnDemand )
//STRIP001 				delete (SfxItemSet*)&pData->pPage->GetItemSet();
//STRIP001 			delete pData->pPage;
//STRIP001 		}
//STRIP001 		delete pData;
//STRIP001 	}
//STRIP001 
//STRIP001 	// remove Pagelist
//STRIP001 /*	for ( i=0; i<maPageList.Count(); i++ )
//STRIP001 	{
//STRIP001 		IconChoicePageData* pData = (IconChoicePageData*)maPageList.GetObject ( i );
//STRIP001 
//STRIP001 		if ( pData->bOnDemand )
//STRIP001 			delete ( SfxItemSet * )&( pData->pPage->GetItemSet() );
//STRIP001 
//STRIP001 		delete pData->pPage;
//STRIP001 		delete pData;
//STRIP001 	}*/
//STRIP001 
//STRIP001 	// remove Userdata from Icons
//STRIP001 	for ( i=0; i<maIconCtrl.GetEntryCount(); i++)
//STRIP001 	{
//STRIP001 		SvxIconChoiceCtrlEntry* pEntry = maIconCtrl.GetEntry ( i );
//STRIP001 		USHORT* pUserData = (USHORT*) pEntry->GetUserData();
//STRIP001 		delete pUserData;
//STRIP001 	}
//STRIP001 
//STRIP001 	//
//STRIP001 	if ( pRanges )
//STRIP001 		delete pRanges;
//STRIP001 	if ( pOutSet )
//STRIP001 		delete pOutSet;
//STRIP001 }
//STRIP001 
//STRIP001 /**********************************************************************
//STRIP001 |
//STRIP001 | add new page
//STRIP001 |
//STRIP001 \**********************************************************************/
//STRIP001 
//STRIP001 SvxIconChoiceCtrlEntry* IconChoiceDialog::AddTabPage( USHORT nId, const String& rIconText,
//STRIP001 								   const Image& rChoiceIcon,
//STRIP001 								   CreatePage pCreateFunc /* != 0 */,
//STRIP001 								   GetPageRanges pRangesFunc /* darf 0 sein */,
//STRIP001 								   BOOL bItemsOnDemand, ULONG nPos )
//STRIP001 {
//STRIP001 	IconChoicePageData* pData = new IconChoicePageData ( nId, pCreateFunc,
//STRIP001 		                                                 pRangesFunc,
//STRIP001 														 bItemsOnDemand );
//STRIP001 	maPageList.Insert ( pData, LIST_APPEND );
//STRIP001 
//STRIP001 	pData->fnGetRanges = pRangesFunc;
//STRIP001 	pData->bOnDemand = bItemsOnDemand;
//STRIP001 
//STRIP001 	USHORT *pId = new USHORT ( nId );
//STRIP001 	SvxIconChoiceCtrlEntry*	pEntry = maIconCtrl.InsertEntry( rIconText, rChoiceIcon );
//STRIP001 	pEntry->SetUserData ( (void*) pId );
//STRIP001 	return pEntry;
//STRIP001 }
//STRIP001 
//STRIP001 SvxIconChoiceCtrlEntry* IconChoiceDialog::AddTabPage( USHORT nId, const String& rIconText,
//STRIP001 								   const Image& rChoiceIcon,
//STRIP001 								   const Image& rChoiceIconHC,
//STRIP001 								   CreatePage pCreateFunc /* != 0 */,
//STRIP001 								   GetPageRanges pRangesFunc /* darf 0 sein */,
//STRIP001 								   BOOL bItemsOnDemand, ULONG nPos )
//STRIP001 {
//STRIP001 	IconChoicePageData* pData = new IconChoicePageData ( nId, pCreateFunc,
//STRIP001 		                                                 pRangesFunc,
//STRIP001 														 bItemsOnDemand );
//STRIP001 	maPageList.Insert ( pData, LIST_APPEND );
//STRIP001 
//STRIP001 	pData->fnGetRanges = pRangesFunc;
//STRIP001 	pData->bOnDemand = bItemsOnDemand;
//STRIP001 
//STRIP001 	USHORT *pId = new USHORT ( nId );
//STRIP001 	SvxIconChoiceCtrlEntry*	pEntry = maIconCtrl.InsertEntry( rIconText, rChoiceIcon, rChoiceIconHC );
//STRIP001 	pEntry->SetUserData ( (void*) pId );
//STRIP001 	return pEntry;
//STRIP001 }
//STRIP001 
//STRIP001 /**********************************************************************
//STRIP001 |
//STRIP001 | remove page
//STRIP001 |
//STRIP001 \**********************************************************************/
//STRIP001 
//STRIP001 void IconChoiceDialog::RemoveTabPage( USHORT nId )
//STRIP001 {
//STRIP001 	IconChoicePageData* pData = GetPageData ( nId );
//STRIP001 
//STRIP001 	// remove page from list
//STRIP001 	if ( pData )
//STRIP001 	{
//STRIP001 		maPageList.Remove ( pData );
//STRIP001 
//STRIP001 		// save settings
//STRIP001 		if ( pData->pPage )
//STRIP001 		{
//STRIP001 			pData->pPage->FillUserData();
//STRIP001 			String aPageData(pData->pPage->GetUserData());
//STRIP001 			if ( aPageData.Len() )
//STRIP001 			{
//STRIP001 				SvtViewOptions aTabPageOpt( E_TABPAGE, String::CreateFromInt32( pData->nId ) );
//STRIP001 
//STRIP001 				SetViewOptUserItem( aTabPageOpt, aPageData );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( pData->bOnDemand )
//STRIP001 			delete ( SfxItemSet * )&( pData->pPage->GetItemSet() );
//STRIP001 
//STRIP001 		delete pData->pPage;
//STRIP001 		delete pData;
//STRIP001 	}
//STRIP001 
//STRIP001 	// remove Icon
//STRIP001 	BOOL bFound=FALSE;
//STRIP001 	for ( ULONG i=0; i<maIconCtrl.GetEntryCount() && !bFound; i++)
//STRIP001 	{
//STRIP001 		SvxIconChoiceCtrlEntry* pEntry = maIconCtrl.GetEntry ( i );
//STRIP001 		USHORT* pUserData = (USHORT*) pEntry->GetUserData();
//STRIP001 
//STRIP001 		if ( *pUserData == nId )
//STRIP001 		{
//STRIP001 			delete pUserData;
//STRIP001 			maIconCtrl.RemoveEntry ( pEntry );
//STRIP001 			bFound = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// was it the current page ?
//STRIP001 	if ( nId = mnCurrentPageId )
//STRIP001 	{
//STRIP001 		mnCurrentPageId = maPageList.First()->nId;
//STRIP001 	}
//STRIP001 
//STRIP001 	Invalidate ();
//STRIP001 }
//STRIP001 
//STRIP001 /**********************************************************************
//STRIP001 |
//STRIP001 | Paint-method
//STRIP001 |
//STRIP001 \**********************************************************************/
//STRIP001 
//STRIP001 void IconChoiceDialog::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	Dialog::Paint ( rRect );
//STRIP001 
//STRIP001 	for ( ULONG i=0; i<maPageList.Count(); i++ )
//STRIP001 	{
//STRIP001 		IconChoicePageData* pData = (IconChoicePageData*)maPageList.GetObject ( i );
//STRIP001 
//STRIP001 		if ( pData->nId == mnCurrentPageId )
//STRIP001 		{
//STRIP001 			ShowPageImpl ( pData );
//STRIP001 			pData->pPage->Invalidate();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			HidePageImpl ( pData );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 EIconChoicePos IconChoiceDialog::SetCtrlPos( const EIconChoicePos& rPos )
//STRIP001 {
//STRIP001 	WinBits aWinBits = maIconCtrl.GetStyle ();
//STRIP001 
//STRIP001 	switch ( meChoicePos )
//STRIP001 	{
//STRIP001 		case PosLeft :
//STRIP001 			aWinBits &= ~WB_ALIGN_TOP & ~WB_NOVSCROLL;
//STRIP001 			aWinBits |= WB_ALIGN_LEFT | WB_NOHSCROLL;
//STRIP001 			break;
//STRIP001 		case PosRight :
//STRIP001 			aWinBits &= ~WB_ALIGN_TOP & ~WB_NOVSCROLL;
//STRIP001 			aWinBits |= WB_ALIGN_LEFT | WB_NOHSCROLL;
//STRIP001 			break;
//STRIP001 		case PosTop :
//STRIP001 			aWinBits &= ~WB_ALIGN_LEFT & ~WB_NOHSCROLL;
//STRIP001 			aWinBits |= WB_ALIGN_TOP | WB_NOVSCROLL;
//STRIP001 			break;
//STRIP001 		case PosBottom :
//STRIP001 			aWinBits &= ~WB_ALIGN_LEFT & ~WB_NOHSCROLL;
//STRIP001 			aWinBits |= WB_ALIGN_TOP | WB_NOVSCROLL;
//STRIP001 			break;
//STRIP001 	};
//STRIP001 	maIconCtrl.SetStyle ( aWinBits );
//STRIP001 
//STRIP001 	SetPosSizeCtrls();
//STRIP001 	Invalidate ();
//STRIP001 
//STRIP001 	EIconChoicePos eOldPos = meChoicePos;
//STRIP001 	meChoicePos = rPos;
//STRIP001 
//STRIP001 	return eOldPos;
//STRIP001 }
//STRIP001 
//STRIP001 void IconChoiceDialog::SetCtrlColor ( const Color& rColor )
//STRIP001 {
//STRIP001 	Wallpaper aWallpaper ( rColor );
//STRIP001 	maIconCtrl.SetBackground( aWallpaper );
//STRIP001 	maIconCtrl.SetFontColorToBackground ();
//STRIP001 }
//STRIP001 
//STRIP001 /**********************************************************************
//STRIP001 |
//STRIP001 | Show / Hide page or button
//STRIP001 |
//STRIP001 \**********************************************************************/
//STRIP001 
//STRIP001 void IconChoiceDialog::ShowPageImpl ( IconChoicePageData* pData )
//STRIP001 {
//STRIP001 	if ( pData->pPage )
//STRIP001 		pData->pPage->Show();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void IconChoiceDialog::HidePageImpl ( IconChoicePageData* pData )
//STRIP001 {
//STRIP001 	if ( pData->pPage )
//STRIP001 		pData->pPage->Hide();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void IconChoiceDialog::RemoveResetButton()
//STRIP001 {
//STRIP001 	aResetBtn.Hide();
//STRIP001 	bHideResetBtn = TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void IconChoiceDialog::ShowPage( USHORT nId )
//STRIP001 {
//STRIP001 	SetCurPageId( nId );
//STRIP001 	ActivatePageImpl( );
//STRIP001 }
//STRIP001 
//STRIP001 /**********************************************************************
//STRIP001 |
//STRIP001 | Resize Dialog
//STRIP001 |
//STRIP001 \**********************************************************************/
//STRIP001 
//STRIP001 #define ICONCTRL_WIDTH_PIXEL	   110
//STRIP001 #define ICONCTRL_HEIGHT_PIXEL	    75
//STRIP001 #define MINSIZE_BUTTON_WIDTH		70
//STRIP001 #define MINSIZE_BUTTON_HEIGHT		22
//STRIP001 
//STRIP001 void IconChoiceDialog::Resize()
//STRIP001 {
//STRIP001 	Dialog::Resize ();
//STRIP001 
//STRIP001 	if ( IsReallyVisible() )
//STRIP001 	{
//STRIP001 		SetPosSizeCtrls ();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void IconChoiceDialog::SetPosSizeCtrls ( BOOL bInit )
//STRIP001 {
//STRIP001 	const Point aCtrlOffset ( LogicToPixel( Point( CTRLS_OFFSET, CTRLS_OFFSET ), MAP_APPFONT ) );
//STRIP001 	Size aOutSize ( GetOutputSizePixel() );
//STRIP001 
//STRIP001 	////////////////////////////////////////
//STRIP001 	// Button-Defaults
//STRIP001 	//
//STRIP001 	Size aDefaultButtonSize = LogicToPixel( Size( 50, 14 ), MAP_APPFONT );
//STRIP001 
//STRIP001 	// Reset-Button
//STRIP001 	Size aResetButtonSize ( bInit ? aDefaultButtonSize :
//STRIP001 	                                aResetBtn.GetSizePixel () );
//STRIP001 
//STRIP001 	////////////////////////////////////////
//STRIP001 	// IconChoiceCtrl resizen & positionieren
//STRIP001 	//
//STRIP001 	Size aNewIconCtrlSize  ( ICONCTRL_WIDTH_PIXEL,
//STRIP001 		                     aOutSize.Height()-(2*aCtrlOffset.X()) );
//STRIP001 	Point aIconCtrlPos;
//STRIP001 	switch ( meChoicePos )
//STRIP001 	{
//STRIP001 		case PosLeft :
//STRIP001 			aIconCtrlPos = aCtrlOffset;
//STRIP001 			aNewIconCtrlSize = Size ( ICONCTRL_WIDTH_PIXEL,
//STRIP001 		                              aOutSize.Height()-(2*aCtrlOffset.X()) );
//STRIP001 			break;
//STRIP001 		case PosRight :
//STRIP001 			aIconCtrlPos = Point ( aOutSize.Width() - ICONCTRL_WIDTH_PIXEL -
//STRIP001 				                   aCtrlOffset.X(), aCtrlOffset.X() );
//STRIP001 			aNewIconCtrlSize = Size ( ICONCTRL_WIDTH_PIXEL,
//STRIP001 		                              aOutSize.Height()-(2*aCtrlOffset.X()) );
//STRIP001 			break;
//STRIP001 		case PosTop :
//STRIP001 			aIconCtrlPos = aCtrlOffset;
//STRIP001 			aNewIconCtrlSize = Size ( aOutSize.Width()-(2*aCtrlOffset.X()),
//STRIP001 				                      ICONCTRL_HEIGHT_PIXEL );
//STRIP001 			break;
//STRIP001 		case PosBottom :
//STRIP001 			aIconCtrlPos = Point ( aCtrlOffset.X(), aOutSize.Height() -
//STRIP001 				                   aResetButtonSize.Height() - (2*aCtrlOffset.X()) -
//STRIP001 								   ICONCTRL_HEIGHT_PIXEL );
//STRIP001 			aNewIconCtrlSize = Size ( aOutSize.Width()-(2*aCtrlOffset.X()),
//STRIP001 				                      ICONCTRL_HEIGHT_PIXEL );
//STRIP001 			break;
//STRIP001 	};
//STRIP001 	maIconCtrl.SetPosSizePixel ( aIconCtrlPos, aNewIconCtrlSize );
//STRIP001 	maIconCtrl.ArrangeIcons();
//STRIP001 
//STRIP001 	////////////////////////////////////////
//STRIP001 	// Pages resizen & positionieren
//STRIP001 	//
//STRIP001 	for ( ULONG i=0; i<maPageList.Count(); i++ )
//STRIP001 	{
//STRIP001 		IconChoicePageData* pData = (IconChoicePageData*)maPageList.GetObject ( i );
//STRIP001 
//STRIP001 		Point aNewPagePos;
//STRIP001 		Size aNewPageSize;
//STRIP001 		switch ( meChoicePos )
//STRIP001 		{
//STRIP001 			case PosLeft :
//STRIP001 				aNewPagePos = Point ( aNewIconCtrlSize.Width() + (2*CTRLS_OFFSET),
//STRIP001 			                          CTRLS_OFFSET );
//STRIP001 				aNewPageSize = Size ( aOutSize.Width() - aNewIconCtrlSize.Width() -
//STRIP001 							          (3*CTRLS_OFFSET),
//STRIP001 							          aOutSize.Height() - aOKBtn.GetSizePixel().Height() -
//STRIP001 							          (3*CTRLS_OFFSET) );
//STRIP001 				break;
//STRIP001 			case PosRight :
//STRIP001 				aNewPagePos = aCtrlOffset;
//STRIP001 				aNewPageSize = Size ( aOutSize.Width() - aNewIconCtrlSize.Width() -
//STRIP001 							          (3*aCtrlOffset.X()),
//STRIP001 							          aOutSize.Height() - aOKBtn.GetSizePixel().Height() -
//STRIP001 							          (3*aCtrlOffset.X()) );
//STRIP001 				break;
//STRIP001 			case PosTop :
//STRIP001 				aNewPagePos = Point ( aCtrlOffset.X(), aNewIconCtrlSize.Height() +
//STRIP001 					                  (2*aCtrlOffset.X()) );
//STRIP001 				aNewPageSize = Size ( aOutSize.Width() - (2*aCtrlOffset.X()),
//STRIP001 							          aOutSize.Height() - aOKBtn.GetSizePixel().Height() -
//STRIP001 							          aNewIconCtrlSize.Height() - (4*aCtrlOffset.X()) );
//STRIP001 				break;
//STRIP001 			case PosBottom :
//STRIP001 				aNewPagePos = aCtrlOffset;
//STRIP001 				aNewPageSize = Size ( aOutSize.Width() - (2*aCtrlOffset.X()),
//STRIP001 							          aOutSize.Height() - aOKBtn.GetSizePixel().Height() -
//STRIP001 							          aNewIconCtrlSize.Height() - (4*aCtrlOffset.X()) );
//STRIP001 				break;
//STRIP001 		};
//STRIP001 
//STRIP001 		if ( pData->pPage )
//STRIP001 			pData->pPage->SetPosSizePixel ( aNewPagePos, aNewPageSize );
//STRIP001 	}
//STRIP001 
//STRIP001 	////////////////////////////////////////
//STRIP001 	// Buttons positionieren
//STRIP001 	//
//STRIP001 	ULONG nXOffset=0;
//STRIP001 	if ( meChoicePos == PosRight )
//STRIP001 		nXOffset = aNewIconCtrlSize.Width()+(2*aCtrlOffset.X());
//STRIP001 
//STRIP001 	aResetBtn.SetPosSizePixel ( Point( aOutSize.Width() - nXOffset -
//STRIP001 		                               aResetButtonSize.Width()-aCtrlOffset.X(),
//STRIP001 								       aOutSize.Height()-aResetButtonSize.Height()-
//STRIP001 									   aCtrlOffset.X() ),
//STRIP001 							   aResetButtonSize );
//STRIP001 	// Help-Button
//STRIP001 	Size aHelpButtonSize ( bInit ? aDefaultButtonSize :
//STRIP001 	                               aHelpBtn.GetSizePixel () );
//STRIP001 	aHelpBtn.SetPosSizePixel ( Point( aOutSize.Width()-aResetButtonSize.Width()-
//STRIP001 		                              aHelpButtonSize.Width()- nXOffset -
//STRIP001 								      (2*aCtrlOffset.X()),
//STRIP001 								      aOutSize.Height()-aHelpButtonSize.Height()-
//STRIP001 									  aCtrlOffset.X() ),
//STRIP001 							   aHelpButtonSize );
//STRIP001 	// Cancel-Button
//STRIP001 	Size aCancelButtonSize ( bInit ? aDefaultButtonSize :
//STRIP001 	                                 aCancelBtn.GetSizePixel () );
//STRIP001 	aCancelBtn.SetPosSizePixel ( Point( aOutSize.Width()-aCancelButtonSize.Width()-
//STRIP001 									    aResetButtonSize.Width()-aHelpButtonSize.Width()-
//STRIP001 									    (3*aCtrlOffset.X()) -  nXOffset,
//STRIP001 								        aOutSize.Height()-aCancelButtonSize.Height()-
//STRIP001 										aCtrlOffset.X() ),
//STRIP001 								aCancelButtonSize );
//STRIP001 	// OK-Button
//STRIP001 	Size aOKButtonSize ( bInit ? aDefaultButtonSize : aOKBtn.GetSizePixel () );
//STRIP001 	aOKBtn.SetPosSizePixel ( Point( aOutSize.Width()-aOKButtonSize.Width()-
//STRIP001 		                            aCancelButtonSize.Width()-aResetButtonSize.Width()-
//STRIP001 									aHelpButtonSize.Width()-(4*aCtrlOffset.X())-  nXOffset,
//STRIP001 								    aOutSize.Height()-aOKButtonSize.Height()-aCtrlOffset.X() ),
//STRIP001 							aOKButtonSize );
//STRIP001 
//STRIP001 	Invalidate();
//STRIP001 }
//STRIP001 
//STRIP001 void IconChoiceDialog::SetPosSizePages ( USHORT nId )
//STRIP001 {
//STRIP001 	const Point aCtrlOffset ( LogicToPixel( Point( CTRLS_OFFSET, CTRLS_OFFSET ), MAP_APPFONT ) );
//STRIP001 	IconChoicePageData* pData = GetPageData ( nId );
//STRIP001 
//STRIP001 	if ( pData->pPage )
//STRIP001 	{
//STRIP001 		Size aOutSize ( GetOutputSizePixel() );
//STRIP001 		Size aIconCtrlSize ( maIconCtrl.GetSizePixel() );
//STRIP001 
//STRIP001 		Point aNewPagePos;
//STRIP001 		Size aNewPageSize;
//STRIP001 		switch ( meChoicePos )
//STRIP001 		{
//STRIP001 			case PosLeft :
//STRIP001 				aNewPagePos = Point ( aIconCtrlSize.Width() + (2*aCtrlOffset.X()),
//STRIP001 			                          aCtrlOffset.X() );
//STRIP001 				aNewPageSize = Size ( aOutSize.Width() - maIconCtrl.GetSizePixel().Width() -
//STRIP001 							          (3*aCtrlOffset.X()),
//STRIP001 							          aOutSize.Height() - aOKBtn.GetSizePixel().Height() -
//STRIP001 							          (3*aCtrlOffset.X()) );
//STRIP001 				break;
//STRIP001 			case PosRight :
//STRIP001 				aNewPagePos = aCtrlOffset;
//STRIP001 				aNewPageSize = Size ( aOutSize.Width() - maIconCtrl.GetSizePixel().Width() -
//STRIP001 							          (3*aCtrlOffset.X()),
//STRIP001 							          aOutSize.Height() - aOKBtn.GetSizePixel().Height() -
//STRIP001 							          (3*aCtrlOffset.X()) );
//STRIP001 				break;
//STRIP001 			case PosTop :
//STRIP001 				aNewPagePos = Point ( aCtrlOffset.X(), aIconCtrlSize.Height() +
//STRIP001 					                  (2*aCtrlOffset.X()) );
//STRIP001 				aNewPageSize = Size ( aOutSize.Width() - (2*aCtrlOffset.X()),
//STRIP001 							          aOutSize.Height() - aOKBtn.GetSizePixel().Height() -
//STRIP001 							          maIconCtrl.GetSizePixel().Height() - (4*aCtrlOffset.X()) );
//STRIP001 				break;
//STRIP001 			case PosBottom :
//STRIP001 				aNewPagePos = aCtrlOffset;
//STRIP001 				aNewPageSize = Size ( aOutSize.Width() - (2*aCtrlOffset.X()),
//STRIP001 							          aOutSize.Height() - aOKBtn.GetSizePixel().Height() -
//STRIP001 							          maIconCtrl.GetSizePixel().Height() - (4*aCtrlOffset.X()) );
//STRIP001 				break;
//STRIP001 		};
//STRIP001 
//STRIP001 		pData->pPage->SetPosSizePixel ( aNewPagePos, aNewPageSize );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /**********************************************************************
//STRIP001 |
//STRIP001 | select a page
//STRIP001 |
//STRIP001 \**********************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK ( IconChoiceDialog , ChosePageHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	ULONG nPos;
//STRIP001 
//STRIP001 	SvxIconChoiceCtrlEntry *pEntry = maIconCtrl.GetSelectedEntry ( nPos );
//STRIP001 	if ( !pEntry )
//STRIP001 		pEntry = maIconCtrl.GetCursor( );
//STRIP001 
//STRIP001 	USHORT *pId = (USHORT*)pEntry->GetUserData ();
//STRIP001 
//STRIP001 	if( *pId != mnCurrentPageId )
//STRIP001 	{
//STRIP001 		IconChoicePageData* pData = GetPageData ( mnCurrentPageId );
//STRIP001 		if ( pData->pPage )
//STRIP001 			DeActivatePageImpl();
//STRIP001 
//STRIP001 		SetCurPageId ( *pId );
//STRIP001 
//STRIP001 		ActivatePageImpl();
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 /**********************************************************************
//STRIP001 |
//STRIP001 | Button-handler
//STRIP001 |
//STRIP001 \**********************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK( IconChoiceDialog, OkHdl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	bInOK = TRUE;
//STRIP001 
//STRIP001 	if ( OK_Impl() )
//STRIP001 	{
//STRIP001 		if ( bModal )
//STRIP001 			EndDialog( Ok() );
//STRIP001 		else
//STRIP001 		{
//STRIP001 			Ok();
//STRIP001 			Close();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( IconChoiceDialog, ResetHdl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	ResetPageImpl ();
//STRIP001 
//STRIP001 	IconChoicePageData* pData = GetPageData ( mnCurrentPageId );
//STRIP001 	DBG_ASSERT( pData, "Id nicht bekannt" );
//STRIP001 
//STRIP001 	if ( pData->bOnDemand )
//STRIP001 	{
//STRIP001 		// CSet auf AIS hat hier Probleme, daher getrennt
//STRIP001 		const SfxItemSet* pSet = &( pData->pPage->GetItemSet() );
//STRIP001 		pData->pPage->Reset( *(SfxItemSet*)pSet );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pData->pPage->Reset( *pSet );
//STRIP001 
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( IconChoiceDialog, CancelHdl, Button*, pButton )
//STRIP001 {
//STRIP001 	Close();
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /**********************************************************************
//STRIP001 |
//STRIP001 | call page
//STRIP001 |
//STRIP001 \**********************************************************************/
//STRIP001 
//STRIP001 void IconChoiceDialog::ActivatePageImpl ()
//STRIP001 {
//STRIP001 	DBG_ASSERT( maPageList.Count(), "keine Pages angemeldet" );
//STRIP001 	IconChoicePageData* pData = GetPageData ( mnCurrentPageId );
//STRIP001 	DBG_ASSERT( pData, "Id nicht bekannt" );
//STRIP001 	if ( pData )
//STRIP001 	{
//STRIP001 		if ( !pData->pPage )
//STRIP001 		{
//STRIP001 			const SfxItemSet* pTmpSet = 0;
//STRIP001 
//STRIP001 			if ( pSet )
//STRIP001 			{
//STRIP001 				if ( bItemsReset && pSet->GetParent() )
//STRIP001 					pTmpSet = pSet->GetParent();
//STRIP001 				else
//STRIP001 					pTmpSet = pSet;
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( pTmpSet && !pData->bOnDemand )
//STRIP001 				pData->pPage = (pData->fnCreatePage)( this, *pTmpSet );
//STRIP001 			else
//STRIP001 				pData->pPage = (pData->fnCreatePage)( this, *CreateInputItemSet( mnCurrentPageId ) );
//STRIP001 
//STRIP001 			SvtViewOptions aTabPageOpt( E_TABPAGE, String::CreateFromInt32( pData->nId ) );
//STRIP001 			pData->pPage->SetUserData( GetViewOptUserItem( aTabPageOpt ) );
//STRIP001 			SetPosSizePages ( pData->nId );
//STRIP001 			PageCreated( mnCurrentPageId, *(pData->pPage) );
//STRIP001 
//STRIP001 			if ( pData->bOnDemand )
//STRIP001 				pData->pPage->Reset( (SfxItemSet &)pData->pPage->GetItemSet() );
//STRIP001 			else
//STRIP001 				pData->pPage->Reset( *pSet );
//STRIP001 		}
//STRIP001 		else if ( pData->bRefresh )
//STRIP001 		{
//STRIP001 			pData->pPage->Reset( *pSet );
//STRIP001 		}
//STRIP001 
//STRIP001 		pData->bRefresh = FALSE;
//STRIP001 
//STRIP001 		if ( pExampleSet )
//STRIP001 			pData->pPage->ActivatePage( *pExampleSet );
//STRIP001 	}
//STRIP001 
//STRIP001 	SetHelpId( pData->pPage->GetHelpId() );
//STRIP001 
//STRIP001 	BOOL bReadOnly = pData->pPage->IsReadOnly();
//STRIP001 	if ( bReadOnly || bHideResetBtn )
//STRIP001 		aResetBtn.Hide();
//STRIP001 	else
//STRIP001 		aResetBtn.Show();
//STRIP001 
//STRIP001 	Invalidate ();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL IconChoiceDialog::DeActivatePageImpl ()
//STRIP001 {
//STRIP001 	IconChoicePageData *pData = GetPageData ( mnCurrentPageId );
//STRIP001 
//STRIP001 	int nRet = IconChoicePage::LEAVE_PAGE;
//STRIP001 
//STRIP001 	if ( pData )
//STRIP001 	{
//STRIP001 		IconChoicePage * pPage = pData->pPage;
//STRIP001 
//STRIP001 		if ( !pExampleSet && pPage->HasExchangeSupport() && pSet )
//STRIP001 			pExampleSet = new SfxItemSet( *pSet->GetPool(), pSet->GetRanges() );
//STRIP001 
//STRIP001 		if ( pSet )
//STRIP001 		{
//STRIP001 			SfxItemSet aTmp( *pSet->GetPool(), pSet->GetRanges() );
//STRIP001 
//STRIP001 			if ( pPage->HasExchangeSupport() )
//STRIP001 				nRet = pPage->DeactivatePage( &aTmp );
//STRIP001 
//STRIP001 			if ( ( IconChoicePage::LEAVE_PAGE & nRet ) == IconChoicePage::LEAVE_PAGE &&
//STRIP001 				 aTmp.Count() )
//STRIP001 			{
//STRIP001 				pExampleSet->Put( aTmp );
//STRIP001 				pOutSet->Put( aTmp );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if ( pPage->HasExchangeSupport() ) //!!!
//STRIP001 			{
//STRIP001 				if ( !pExampleSet )
//STRIP001 				{
//STRIP001 					SfxItemPool* pPool = pPage->GetItemSet().GetPool();
//STRIP001 					pExampleSet =
//STRIP001 						new SfxItemSet( *pPool, GetInputRanges( *pPool ) );
//STRIP001 				}
//STRIP001 				nRet = pPage->DeactivatePage( pExampleSet );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				nRet = pPage->DeactivatePage( NULL );
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( nRet & IconChoicePage::REFRESH_SET )
//STRIP001 		{
//STRIP001 			pSet = GetRefreshedSet();
//STRIP001 			DBG_ASSERT( pSet, "GetRefreshedSet() liefert NULL" );
//STRIP001 			// alle Pages als neu zu initialsieren flaggen
//STRIP001 			const ULONG nCount = maPageList.Count();
//STRIP001 
//STRIP001 			for ( USHORT i = 0; i < nCount; ++i )
//STRIP001 			{
//STRIP001 				IconChoicePageData* pObj = (IconChoicePageData*)maPageList.GetObject(i);
//STRIP001 
//STRIP001 				if ( pObj->pPage != pPage ) // eigene Page nicht mehr refreshen
//STRIP001 					pObj->bRefresh = TRUE;
//STRIP001 				else
//STRIP001 					pObj->bRefresh = FALSE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nRet & IconChoicePage::LEAVE_PAGE )
//STRIP001 		return TRUE;
//STRIP001 	else
//STRIP001 		return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void IconChoiceDialog::ResetPageImpl ()
//STRIP001 {
//STRIP001 	IconChoicePageData *pData = GetPageData ( mnCurrentPageId );
//STRIP001 
//STRIP001 	DBG_ASSERT( pData, "Id nicht bekannt" );
//STRIP001 
//STRIP001 	if ( pData->bOnDemand )
//STRIP001 	{
//STRIP001 		// CSet auf AIS hat hier Probleme, daher getrennt
//STRIP001 		const SfxItemSet* pSet = &pData->pPage->GetItemSet();
//STRIP001 		pData->pPage->Reset( *(SfxItemSet*)pSet );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pData->pPage->Reset( *pSet );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void IconChoiceDialog::PageCreated( USHORT nId, IconChoicePage &rPage )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 /**********************************************************************
//STRIP001 |
//STRIP001 | handling itemsets
//STRIP001 |
//STRIP001 \**********************************************************************/
//STRIP001 
//STRIP001 const USHORT* IconChoiceDialog::GetInputRanges( const SfxItemPool& rPool )
//STRIP001 {
//STRIP001 	if ( pSet )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "Set bereits vorhanden!" );
//STRIP001 		return pSet->GetRanges();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pRanges )
//STRIP001 		return pRanges;
//STRIP001 	SvUShorts aUS( 16, 16 );
//STRIP001 	ULONG nCount = maPageList.Count();
//STRIP001 
//STRIP001 	USHORT i;
//STRIP001 	for ( i = 0; i < nCount; ++i )
//STRIP001 	{
//STRIP001 		IconChoicePageData* pData = maPageList.GetObject (i);
//STRIP001 
//STRIP001 		if ( pData->fnGetRanges )
//STRIP001 		{
//STRIP001 			const USHORT* pTmpRanges = (pData->fnGetRanges)();
//STRIP001 			const USHORT* pIter = pTmpRanges;
//STRIP001 
//STRIP001 			USHORT nLen;
//STRIP001 			for( nLen = 0; *pIter; ++nLen, ++pIter )
//STRIP001 				;
//STRIP001 			aUS.Insert( pTmpRanges, nLen, aUS.Count() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// remove double Id's
//STRIP001 #ifndef TF_POOLABLE
//STRIP001 	if ( rPool.HasMap() )
//STRIP001 #endif
//STRIP001 	{
//STRIP001 		nCount = aUS.Count();
//STRIP001 
//STRIP001 		for ( i = 0; i < nCount; ++i )
//STRIP001 			aUS[i] = rPool.GetWhich( aUS[i] );
//STRIP001 	}
//STRIP001 
//STRIP001 	// sortieren
//STRIP001 	if ( aUS.Count() > 1 )
//STRIP001 		qsort( (void*)aUS.GetData(),
//STRIP001 			   aUS.Count(), sizeof(USHORT), IconcDlgCmpUS_Impl );
//STRIP001 
//STRIP001 	pRanges = new USHORT[aUS.Count() + 1];
//STRIP001 	memcpy(pRanges, aUS.GetData(), sizeof(USHORT) * aUS.Count());
//STRIP001 	pRanges[aUS.Count()] = 0;
//STRIP001 
//STRIP001 	return pRanges;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void IconChoiceDialog::SetInputSet( const SfxItemSet* pInSet )
//STRIP001 {
//STRIP001 	FASTBOOL bSet = ( pSet != NULL );
//STRIP001 
//STRIP001 	pSet = pInSet;
//STRIP001 
//STRIP001 	if ( !bSet && !pExampleSet && !pOutSet )
//STRIP001 	{
//STRIP001 		pExampleSet = new SfxItemSet( *pSet );
//STRIP001 		pOutSet = new SfxItemSet( *pSet->GetPool(), pSet->GetRanges() );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 //	Liefert die Pages, die ihre Sets onDemand liefern, das OutputItemSet.
//STRIP001 const SfxItemSet* IconChoiceDialog::GetOutputItemSet ( USHORT nId )
//STRIP001 {
//STRIP001 	IconChoicePageData * pData = GetPageData ( nId );
//STRIP001 	DBG_ASSERT( pData, "TabPage nicht gefunden" );
//STRIP001 
//STRIP001 	if ( pData )
//STRIP001 	{
//STRIP001 		if ( !pData->pPage )
//STRIP001 			return NULL;
//STRIP001 
//STRIP001 		if ( pData->bOnDemand )
//STRIP001 			return &pData->pPage->GetItemSet();
//STRIP001 
//STRIP001 		return pOutSet;
//STRIP001 	}
//STRIP001 
//STRIP001 	return NULL;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 int IconChoiceDialog::FillOutputItemSet()
//STRIP001 {
//STRIP001 	int nRet = IconChoicePage::LEAVE_PAGE;
//STRIP001 	if ( OK_Impl() )
//STRIP001 		Ok();
//STRIP001 	else
//STRIP001 		nRet = IconChoicePage::KEEP_PAGE;
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxItemSet* IconChoiceDialog::CreateInputItemSet( USHORT )
//STRIP001 {
//STRIP001 	DBG_WARNINGFILE( "CreateInputItemSet nicht implementiert" );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /**********************************************************************
//STRIP001 |
//STRIP001 | start dialog
//STRIP001 |
//STRIP001 \**********************************************************************/
//STRIP001 
//STRIP001 short IconChoiceDialog::Execute()
//STRIP001 {
//STRIP001 	if ( !maPageList.Count() )
//STRIP001 		return RET_CANCEL;
//STRIP001 
//STRIP001 	Start_Impl();
//STRIP001 
//STRIP001 	return Dialog::Execute();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void IconChoiceDialog::Start( BOOL bShow )
//STRIP001 {
//STRIP001 
//STRIP001 	aCancelBtn.SetClickHdl( LINK( this, IconChoiceDialog, CancelHdl ) );
//STRIP001 	bModal = FALSE;
//STRIP001 
//STRIP001 	Start_Impl();
//STRIP001 
//STRIP001 	if ( bShow )
//STRIP001 		Window::Show();
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void IconChoiceDialog::Start_Impl()
//STRIP001 {
//STRIP001 	Point aPos;
//STRIP001 	USHORT nActPage;
//STRIP001 
//STRIP001 	if ( mnCurrentPageId == 0 || mnCurrentPageId == USHRT_MAX )
//STRIP001 		nActPage = maPageList.GetObject(0)->nId;//First()->nId;
//STRIP001 	else
//STRIP001 		nActPage = mnCurrentPageId;
//STRIP001 
//STRIP001 	// Konfiguration vorhanden?
//STRIP001 	SvtViewOptions aTabDlgOpt( E_TABDIALOG, String::CreateFromInt32( nResId ) );
//STRIP001 
//STRIP001 	if ( aTabDlgOpt.Exists() )
//STRIP001 	{
//STRIP001 		// ggf. Position aus Konfig
//STRIP001 		SetWindowState( ByteString( aTabDlgOpt.GetWindowState().getStr(), RTL_TEXTENCODING_ASCII_US ) );
//STRIP001 
//STRIP001 		// initiale TabPage aus Programm/Hilfe/Konfig
//STRIP001 		nActPage = (USHORT)aTabDlgOpt.GetPageID();
//STRIP001 
//STRIP001 		if ( USHRT_MAX != mnCurrentPageId )
//STRIP001 			nActPage = mnCurrentPageId;
//STRIP001 
//STRIP001 		if ( GetPageData ( nActPage ) == NULL )
//STRIP001 			nActPage = ( (IconChoicePageData*)maPageList.GetObject(0) )->nId;
//STRIP001 	}
//STRIP001 	else if ( USHRT_MAX != mnCurrentPageId && GetPageData ( mnCurrentPageId ) != NULL )
//STRIP001 		nActPage = mnCurrentPageId;
//STRIP001 
//STRIP001 	mnCurrentPageId = nActPage;
//STRIP001 
//STRIP001 	FocusOnIcon( mnCurrentPageId );
//STRIP001 
//STRIP001 	ActivatePageImpl();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 const SfxItemSet* IconChoiceDialog::GetRefreshedSet()
//STRIP001 {
//STRIP001 	DBG_ERRORFILE( "GetRefreshedSet nicht implementiert" );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /**********************************************************************
//STRIP001 |
//STRIP001 | tool-methods
//STRIP001 |
//STRIP001 \**********************************************************************/
//STRIP001 
//STRIP001 IconChoicePageData* IconChoiceDialog::GetPageData ( USHORT nId )
//STRIP001 {
//STRIP001 	IconChoicePageData *pRet = NULL;
//STRIP001 	BOOL bFound = FALSE;
//STRIP001 
//STRIP001 	for ( ULONG i=0; i<maPageList.Count() && !bFound; i++ )
//STRIP001 	{
//STRIP001 		IconChoicePageData* pData = (IconChoicePageData*)maPageList.GetObject ( i );
//STRIP001 
//STRIP001 		if ( pData->nId == nId )
//STRIP001 		{
//STRIP001 			pRet = pData;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return pRet;
//STRIP001 }
//STRIP001 
//STRIP001 /**********************************************************************
//STRIP001 |
//STRIP001 | OK-Status
//STRIP001 |
//STRIP001 \**********************************************************************/
//STRIP001 
//STRIP001 BOOL IconChoiceDialog::OK_Impl()
//STRIP001 {
//STRIP001 	IconChoicePage* pPage = GetPageData ( mnCurrentPageId )->pPage;
//STRIP001 
//STRIP001 	BOOL bEnd = !pPage;
//STRIP001 	if ( pPage )
//STRIP001 	{
//STRIP001 		int nRet = IconChoicePage::LEAVE_PAGE;
//STRIP001 		if ( pSet )
//STRIP001 		{
//STRIP001 			SfxItemSet aTmp( *pSet->GetPool(), pSet->GetRanges() );
//STRIP001 			BOOL bRet = FALSE;
//STRIP001 
//STRIP001 			if ( pPage->HasExchangeSupport() )
//STRIP001 				nRet = pPage->DeactivatePage( &aTmp );
//STRIP001 
//STRIP001 			if ( ( IconChoicePage::LEAVE_PAGE & nRet ) == IconChoicePage::LEAVE_PAGE
//STRIP001 				 && aTmp.Count() )
//STRIP001 			{
//STRIP001 				pExampleSet->Put( aTmp );
//STRIP001 				pOutSet->Put( aTmp );
//STRIP001 			}
//STRIP001 			else if ( bRet )
//STRIP001 				bModified |= TRUE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			nRet = pPage->DeactivatePage( NULL );
//STRIP001 		bEnd = nRet;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bEnd;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 short IconChoiceDialog::Ok()
//STRIP001 {
//STRIP001 	bInOK = TRUE;
//STRIP001 
//STRIP001 	if ( !pOutSet )
//STRIP001 	{
//STRIP001 		if ( !pExampleSet && pSet )
//STRIP001 			pOutSet = pSet->Clone( FALSE );	// ohne Items
//STRIP001 		else if ( pExampleSet )
//STRIP001 			pOutSet = new SfxItemSet( *pExampleSet );
//STRIP001 	}
//STRIP001 	BOOL bModified = FALSE;
//STRIP001 
//STRIP001 	const ULONG nCount = maPageList.Count();
//STRIP001 
//STRIP001 	for ( USHORT i = 0; i < nCount; ++i )
//STRIP001 	{
//STRIP001 		IconChoicePageData* pData = GetPageData ( i );
//STRIP001 
//STRIP001 		IconChoicePage* pPage = pData->pPage;
//STRIP001 
//STRIP001 		if ( pPage )
//STRIP001 		{
//STRIP001 			if ( pData->bOnDemand )
//STRIP001 			{
//STRIP001 				SfxItemSet& rSet = (SfxItemSet&)pPage->GetItemSet();
//STRIP001 				rSet.ClearItem();
//STRIP001 				bModified |= pPage->FillItemSet( rSet );
//STRIP001 			}
//STRIP001 			else if ( pSet && !pPage->HasExchangeSupport() )
//STRIP001 			{
//STRIP001 				SfxItemSet aTmp( *pSet->GetPool(), pSet->GetRanges() );
//STRIP001 
//STRIP001 				if ( pPage->FillItemSet( aTmp ) )
//STRIP001 				{
//STRIP001 					bModified |= TRUE;
//STRIP001 					pExampleSet->Put( aTmp );
//STRIP001 					pOutSet->Put( aTmp );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bModified || ( pOutSet && pOutSet->Count() > 0 ) )
//STRIP001 		bModified |= TRUE;
//STRIP001 
//STRIP001 	return bModified ? RET_OK : RET_CANCEL;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL IconChoiceDialog::IsInOK() const
//STRIP001 {
//STRIP001 	return bInOK;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void IconChoiceDialog::FocusOnIcon( USHORT nId )
//STRIP001 {
//STRIP001 	// set focus to icon for the current visible page
//STRIP001 	for ( USHORT i=0; i<maIconCtrl.GetEntryCount(); i++)
//STRIP001 	{
//STRIP001 		SvxIconChoiceCtrlEntry* pEntry = maIconCtrl.GetEntry ( i );
//STRIP001 		USHORT* pUserData = (USHORT*) pEntry->GetUserData();
//STRIP001 
//STRIP001 		if ( pUserData && *pUserData == nId )
//STRIP001 		{
//STRIP001 			maIconCtrl.SetCursor( pEntry );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void IconChoiceDialog::CreateIconTextAutoMnemonics( void )
//STRIP001 {
//STRIP001 	// !!!!!!! this might be done by IconChoice control -> SvtIconChoiceCtrl::CreateAutoMnemonics() !!!!!!!
//STRIP001 	MnemonicGenerator	aMnemonicGenerator;
//STRIP001 	const ULONG			nEntryCount = maIconCtrl.GetEntryCount();
//STRIP001 	ULONG				i;
//STRIP001 
//STRIP001 	for( i = 0 ; i < nEntryCount ; ++i )
//STRIP001 	{
//STRIP001 		DBG_ASSERT( maIconCtrl.GetEntry( i ), "-IconChoiceDialog::CreateIconTextAutoMnemonics(): NULL-entry found!" );
//STRIP001 		aMnemonicGenerator.RegisterMnemonic( maIconCtrl.GetEntry( i )->GetText() );
//STRIP001 	}
//STRIP001 
//STRIP001 	for( i = 0 ; i < nEntryCount ; ++i )
//STRIP001 	{
//STRIP001 		SvxIconChoiceCtrlEntry*	pEntry = maIconCtrl.GetEntry( i );
//STRIP001 		DBG_ASSERT( pEntry, "-IconChoiceDialog::CreateIconTextAutoMnemonics(): NULL-entry found!" );
//STRIP001 		String					aText = pEntry->GetText();
//STRIP001 		if( aMnemonicGenerator.CreateMnemonic( aText ) )
//STRIP001 			pEntry->SetText( aText );
//STRIP001 	}
//STRIP001 }
}
