/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_hdft.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:46:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif
#ifndef _SFXITEMITER_HXX
#include <svtools/itemiter.hxx>
#endif
#ifndef _SFXAPP_HXX
#include <bf_sfx2/app.hxx>
#endif
#ifndef _SFX_OBJSH_HXX //autogen
#include <bf_sfx2/objsh.hxx>
#endif
#ifndef _SFXMODULE_HXX
#include <bf_sfx2/module.hxx>
#endif
#include <vcl/msgbox.hxx>
#include <vcl/graph.hxx>
#pragma hdrstop

#include "dialogs.hrc"
#include "hdft.hrc"

#define ITEMID_PAGE 	0
#define ITEMID_SIZE 	0
#define ITEMID_ULSPACE  0
#define ITEMID_LRSPACE  0
#define ITEMID_PAPERBIN 0
#define ITEMID_SETITEM  0
#define ITEMID_BRUSH    0
#define ITEMID_BOX		0
#define ITEMID_BOXINFO	0
#define ITEMID_SHADOW	0

//STRIP001 #define _SVX_HDFT_CXX

#include "hdft.hxx"
#include "pageitem.hxx"
#include "bbdlg.hxx"
#include "dlgutil.hxx"
#include "dialmgr.hxx"
#include "htmlmode.hxx"

#include "brshitem.hxx"
#include "lrspitem.hxx"
#include "ulspitem.hxx"
#include "shaditem.hxx"
#include "sizeitem.hxx"
#include "boxitem.hxx"
namespace binfilter {

// static ----------------------------------------------------------------

//STRIP001 static const long MINBODY = 284;			// 0,5cm in twips aufgerundet

// default distance to Header or footer
//STRIP001 static const long DEF_DIST_WRITER = 500;	// 5mm (Writer)
//STRIP001 static const long DEF_DIST_CALC = 250;		// 2,5mm (Calc)

//STRIP001 static USHORT pRanges[] =
//STRIP001 {
//STRIP001 	SID_ATTR_BRUSH,			 SID_ATTR_BRUSH,
//STRIP001 	SID_ATTR_BORDER_OUTER,	 SID_ATTR_BORDER_OUTER,
//STRIP001 	SID_ATTR_BORDER_INNER,	 SID_ATTR_BORDER_INNER,
//STRIP001 	SID_ATTR_BORDER_SHADOW,	 SID_ATTR_BORDER_SHADOW,
//STRIP001 	SID_ATTR_LRSPACE,		 SID_ATTR_LRSPACE,
//STRIP001 	SID_ATTR_ULSPACE,		 SID_ATTR_ULSPACE,
//STRIP001 	SID_ATTR_PAGE_SIZE,		 SID_ATTR_PAGE_SIZE,
//STRIP001 	SID_ATTR_PAGE_HEADERSET, SID_ATTR_PAGE_HEADERSET,
//STRIP001 	SID_ATTR_PAGE_FOOTERSET, SID_ATTR_PAGE_FOOTERSET,
//STRIP001 	SID_ATTR_PAGE_ON,		 SID_ATTR_PAGE_ON,
//STRIP001 	SID_ATTR_PAGE_DYNAMIC,	 SID_ATTR_PAGE_DYNAMIC,
//STRIP001 	SID_ATTR_PAGE_SHARED,	 SID_ATTR_PAGE_SHARED,
//STRIP001     SID_ATTR_HDFT_DYNAMIC_SPACING, SID_ATTR_HDFT_DYNAMIC_SPACING,
//STRIP001 	0
//STRIP001 };

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

// gibt den Bereich der Which-Werte zurueck


//STRIP001 USHORT* SvxHeaderPage::GetRanges()
//STRIP001 {
//STRIP001 	return pRanges;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 SfxTabPage* SvxHeaderPage::Create( Window* pParent, const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	return new SvxHeaderPage( pParent, rSet );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 USHORT* SvxFooterPage::GetRanges()
//STRIP001 {
//STRIP001 	return pRanges;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxTabPage* SvxFooterPage::Create( Window* pParent, const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	return new SvxFooterPage( pParent, rSet );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SvxHeaderPage::SvxHeaderPage( Window* pParent, const SfxItemSet& rAttr ) :
//STRIP001 
//STRIP001 	SvxHFPage( pParent, RID_SVXPAGE_HEADER, rAttr, SID_ATTR_PAGE_HEADERSET )
//STRIP001 
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SvxFooterPage::SvxFooterPage( Window* pParent, const SfxItemSet& rAttr ) :
//STRIP001 
//STRIP001 	SvxHFPage( pParent, RID_SVXPAGE_FOOTER, rAttr, SID_ATTR_PAGE_FOOTERSET )
//STRIP001 
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SvxHFPage::SvxHFPage( Window* pParent, USHORT nResId, const SfxItemSet& rAttr, USHORT nSetId ) :
//STRIP001 
//STRIP001 	SfxTabPage( pParent, ResId( nResId, DIALOG_MGR() ), rAttr ),
//STRIP001 
//STRIP001 	aTurnOnBox		( this, ResId( CB_TURNON ) ),
//STRIP001 	aDistFT			( this, ResId( FT_DIST ) ),
//STRIP001 	aDistEdit		( this, ResId( ED_DIST ) ),
//STRIP001     aDynSpacingCB   ( this, ResId( CB_DYNSPACING ) ),
//STRIP001     aHeightFT       ( this, ResId( FT_HEIGHT ) ),
//STRIP001 	aHeightEdit		( this, ResId( ED_HEIGHT ) ),
//STRIP001 	aHeightDynBtn	( this, ResId( CB_HEIGHT_DYN ) ),
//STRIP001 	aLMLbl			( this, ResId( FT_LMARGIN ) ),
//STRIP001 	aLMEdit			( this, ResId( ED_LMARGIN ) ),
//STRIP001 	aRMLbl			( this, ResId( FT_RMARGIN ) ),
//STRIP001 	aRMEdit			( this, ResId( ED_RMARGIN ) ),
//STRIP001 	aCntSharedBox	( this, ResId( CB_SHARED ) ),
//STRIP001 	aFrm			( this, ResId( FL_FRAME ) ),
//STRIP001 	aBspWin			( this, ResId( WN_BSP ) ),
//STRIP001 	aBackgroundBtn	( this, ResId( BTN_EXTRAS ) ),
//STRIP001 
//STRIP001 	pBBSet						( NULL ),
//STRIP001 	nId							( nSetId ),
//STRIP001 	bDisableQueryBox			( FALSE ),
//STRIP001 	bEnableBackgroundSelector	( TRUE )
//STRIP001 
//STRIP001 {
//STRIP001 	InitHandler();
//STRIP001 
//STRIP001 	// diese Page braucht ExchangeSupport
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	// Metrik einstellen
//STRIP001 	FieldUnit eFUnit = GetModuleFieldUnit( &rAttr );
//STRIP001 	SetFieldUnit( aDistEdit, eFUnit );
//STRIP001 	SetFieldUnit( aHeightEdit, eFUnit );
//STRIP001 	SetFieldUnit( aLMEdit, eFUnit );
//STRIP001 	SetFieldUnit( aRMEdit, eFUnit );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SvxHFPage::~SvxHFPage()
//STRIP001 {
//STRIP001 	delete pBBSet;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 BOOL SvxHFPage::FillItemSet( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	const USHORT		nWSize		= GetWhich( SID_ATTR_PAGE_SIZE );
//STRIP001 	const USHORT		nWLRSpace	= GetWhich( SID_ATTR_LRSPACE );
//STRIP001 	const USHORT		nWULSpace	= GetWhich( SID_ATTR_ULSPACE );
//STRIP001 	const USHORT		nWOn		= GetWhich( SID_ATTR_PAGE_ON );
//STRIP001 	const USHORT		nWDynamic	= GetWhich( SID_ATTR_PAGE_DYNAMIC );
//STRIP001     const USHORT        nWDynSpacing = GetWhich( SID_ATTR_HDFT_DYNAMIC_SPACING );
//STRIP001 	const USHORT		nWShared	= GetWhich( SID_ATTR_PAGE_SHARED );
//STRIP001 	const USHORT		nWBrush		= GetWhich( SID_ATTR_BRUSH );
//STRIP001 	const USHORT		nWBox		= GetWhich( SID_ATTR_BORDER_OUTER );
//STRIP001 	const USHORT		nWBoxInfo	= GetWhich( SID_ATTR_BORDER_INNER );
//STRIP001 	const USHORT		nWShadow	= GetWhich( SID_ATTR_BORDER_SHADOW );
//STRIP001 #ifdef SINIX
//STRIP001 	USHORT		aWhichTab[23];
//STRIP001 	aWhichTab[0]	=	aWhichTab[1]	= nWSize;
//STRIP001 	aWhichTab[2]	=	aWhichTab[3]	= nWLRSpace;
//STRIP001 	aWhichTab[4]	=	aWhichTab[5]	= nWULSpace;
//STRIP001 	aWhichTab[6]	=	aWhichTab[7]	= nWOn;
//STRIP001 	aWhichTab[8]	=	aWhichTab[9]	= nWDynamic;
//STRIP001 	aWhichTab[10]	=	aWhichTab[11]	= nWShared;
//STRIP001 	aWhichTab[12]	=	aWhichTab[13]	= nWBrush;
//STRIP001 	aWhichTab[14]	=	aWhichTab[15]	= nWBoxInfo;
//STRIP001 	aWhichTab[16]	=	aWhichTab[17]	= nWBox;
//STRIP001 	aWhichTab[18]	=	aWhichTab[19]	= nWShadow;
//STRIP001     aWhichTab[20]   =   aWhichTab[21]  = nWDynSpacing;
//STRIP001     aWhichTab[22] = 0;
//STRIP001 
//STRIP001 #else
//STRIP001 	const USHORT		aWhichTab[] = { nWSize,		nWSize,
//STRIP001 										nWLRSpace,	nWLRSpace,
//STRIP001 										nWULSpace,	nWULSpace,
//STRIP001 										nWOn,		nWOn,
//STRIP001 										nWDynamic,	nWDynamic,
//STRIP001 										nWShared,	nWShared,
//STRIP001 										nWBrush,	nWBrush,
//STRIP001 										nWBoxInfo,	nWBoxInfo,
//STRIP001 										nWBox,		nWBox,
//STRIP001 										nWShadow,	nWShadow,
//STRIP001                                         nWDynSpacing, nWDynSpacing,
//STRIP001 										0 };
//STRIP001 #endif
//STRIP001 	const SfxItemSet&	rOldSet		= GetItemSet();
//STRIP001 	SfxItemPool*		pPool		= rOldSet.GetPool();
//STRIP001 	DBG_ASSERT( pPool, "no pool :-(" );
//STRIP001 	SfxMapUnit			eUnit		= pPool->GetMetric( nWSize );
//STRIP001 	SfxItemSet			aSet		( *pPool, aWhichTab );
//STRIP001 
//STRIP001 	//--------------------------------------------------------------------
//STRIP001 
//STRIP001 	aSet.Put( SfxBoolItem( nWOn,	  aTurnOnBox.IsChecked() ) );
//STRIP001 	aSet.Put( SfxBoolItem( nWDynamic, aHeightDynBtn.IsChecked() ) );
//STRIP001 	aSet.Put( SfxBoolItem( nWShared,  aCntSharedBox.IsChecked() ) );
//STRIP001     if(aDynSpacingCB.IsVisible() && SFX_WHICH_MAX > nWDynSpacing)
//STRIP001     {
//STRIP001         SfxBoolItem* pBoolItem = (SfxBoolItem*)pPool->GetDefaultItem(nWDynSpacing).Clone();
//STRIP001         pBoolItem->SetValue(aDynSpacingCB.IsChecked());
//STRIP001         aSet.Put(*pBoolItem);
//STRIP001         delete pBoolItem;
//STRIP001     }
//STRIP001 
//STRIP001 	// Groesse
//STRIP001 	SvxSizeItem aSizeItem( (const SvxSizeItem&)rOldSet.Get( nWSize ) );
//STRIP001 	Size		aSize( aSizeItem.GetSize() );
//STRIP001 	long		nDist = GetCoreValue( aDistEdit, eUnit );
//STRIP001 	long		nH	  = GetCoreValue( aHeightEdit, eUnit );
//STRIP001 
//STRIP001 	// fixe Hoehe?
//STRIP001 //	if ( !aHeightDynBtn.IsChecked() )
//STRIP001 		nH += nDist; // dann Abstand dazu addieren
//STRIP001 	aSize.Height() = nH;
//STRIP001 	aSizeItem.SetSize( aSize );
//STRIP001 	aSet.Put( aSizeItem );
//STRIP001 
//STRIP001 	// Raender
//STRIP001 	SvxLRSpaceItem aLR( nWLRSpace );
//STRIP001 	aLR.SetLeft( (USHORT)GetCoreValue( aLMEdit, eUnit ) );
//STRIP001 	aLR.SetRight( (USHORT)GetCoreValue( aRMEdit, eUnit ) );
//STRIP001 	aSet.Put( aLR );
//STRIP001 
//STRIP001 	SvxULSpaceItem aUL( nWULSpace );
//STRIP001 	if ( nId == SID_ATTR_PAGE_HEADERSET )
//STRIP001 		aUL.SetLower( (USHORT)nDist );
//STRIP001 	else
//STRIP001 		aUL.SetUpper( (USHORT)nDist );
//STRIP001 	aSet.Put( aUL );
//STRIP001 
//STRIP001 	// Hintergrund und Umrandung?
//STRIP001 	if ( pBBSet )
//STRIP001 		aSet.Put( *pBBSet );
//STRIP001 	else
//STRIP001 	{
//STRIP001 		const SfxItemSet* pSet;
//STRIP001 		const SfxPoolItem* pItem;
//STRIP001 
//STRIP001 		if ( SFX_ITEM_SET ==
//STRIP001 			 GetItemSet().GetItemState( GetWhich( nId ), FALSE, &pItem ) )
//STRIP001 		{
//STRIP001 			pSet = &( (SvxSetItem*)pItem )->GetItemSet();
//STRIP001 
//STRIP001 			if ( pSet->GetItemState( nWBrush ) == SFX_ITEM_SET )
//STRIP001 				aSet.Put( (const SvxBrushItem&)pSet->Get( nWBrush ) );
//STRIP001 			if ( pSet->GetItemState( nWBoxInfo ) == SFX_ITEM_SET )
//STRIP001 				aSet.Put( (const SvxBoxInfoItem&)pSet->Get( nWBoxInfo ) );
//STRIP001 			if ( pSet->GetItemState( nWBox ) == SFX_ITEM_SET )
//STRIP001 				aSet.Put( (const SvxBoxItem&)pSet->Get( nWBox ) );
//STRIP001 			if ( pSet->GetItemState( nWShadow ) == SFX_ITEM_SET )
//STRIP001 				aSet.Put( (const SvxShadowItem&)pSet->Get( nWShadow ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Das SetItem wegschreiben
//STRIP001 	SvxSetItem aSetItem( GetWhich( nId ), aSet );
//STRIP001 	rSet.Put( aSetItem );
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

// -----------------------------------------------------------------------
//STRIP001 void SvxHFPage::Reset( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	ActivatePage( rSet );
//STRIP001 	ResetBackground_Impl( rSet );
//STRIP001 
//STRIP001 	SfxItemPool* pPool = GetItemSet().GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool" );
//STRIP001 	SfxMapUnit eUnit = pPool->GetMetric( GetWhich( SID_ATTR_PAGE_SIZE ) );
//STRIP001 
//STRIP001 	// Kopf-/Fusszeilen-Attribute auswerten
//STRIP001 	//
//STRIP001 	const SvxSetItem* pSetItem = 0;
//STRIP001 
//STRIP001 	if ( SFX_ITEM_SET == rSet.GetItemState( GetWhich(nId), FALSE,
//STRIP001 											(const SfxPoolItem**)&pSetItem ) )
//STRIP001 	{
//STRIP001 		const SfxItemSet& rHeaderSet = pSetItem->GetItemSet();
//STRIP001 		const SfxBoolItem& rHeaderOn =
//STRIP001 			(const SfxBoolItem&)rHeaderSet.Get(GetWhich(SID_ATTR_PAGE_ON));
//STRIP001 
//STRIP001 		aTurnOnBox.Check(rHeaderOn.GetValue());
//STRIP001 
//STRIP001 		if ( rHeaderOn.GetValue() )
//STRIP001 		{
//STRIP001 			const SfxBoolItem& rDynamic =
//STRIP001 				(const SfxBoolItem&)rHeaderSet.Get( GetWhich( SID_ATTR_PAGE_DYNAMIC ) );
//STRIP001 			const SfxBoolItem& rShared =
//STRIP001 				(const SfxBoolItem&)rHeaderSet.Get( GetWhich( SID_ATTR_PAGE_SHARED ) );
//STRIP001 			const SvxSizeItem& rSize =
//STRIP001 				(const SvxSizeItem&)rHeaderSet.Get( GetWhich( SID_ATTR_PAGE_SIZE ) );
//STRIP001 			const SvxULSpaceItem& rUL =
//STRIP001 				(const SvxULSpaceItem&)rHeaderSet.Get( GetWhich( SID_ATTR_ULSPACE ) );
//STRIP001 			const SvxLRSpaceItem& rLR =
//STRIP001 				(const SvxLRSpaceItem&)rHeaderSet.Get( GetWhich( SID_ATTR_LRSPACE ) );
//STRIP001             if(aDynSpacingCB.IsVisible())
//STRIP001             {
//STRIP001                 const SfxBoolItem& rDynSpacing =
//STRIP001                     (const SfxBoolItem&)rHeaderSet.Get(GetWhich(SID_ATTR_HDFT_DYNAMIC_SPACING));
//STRIP001                 aDynSpacingCB.Check(rDynSpacing.GetValue());
//STRIP001             }
//STRIP001 
//STRIP001 
//STRIP001             if ( nId == SID_ATTR_PAGE_HEADERSET )
//STRIP001 			{	// Kopfzeile
//STRIP001 				SetMetricValue( aDistEdit, rUL.GetLower(), eUnit );
//STRIP001 				SetMetricValue( aHeightEdit, rSize.GetSize().Height() - rUL.GetLower(), eUnit );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{	// Fusszeile
//STRIP001 				SetMetricValue( aDistEdit, rUL.GetUpper(), eUnit );
//STRIP001 				SetMetricValue( aHeightEdit, rSize.GetSize().Height() - rUL.GetUpper(), eUnit );
//STRIP001 			}
//STRIP001 
//STRIP001 			aHeightDynBtn.Check(rDynamic.GetValue());
//STRIP001 			SetMetricValue( aLMEdit, rLR.GetLeft(), eUnit );
//STRIP001 			SetMetricValue( aRMEdit, rLR.GetRight(), eUnit );
//STRIP001 			aCntSharedBox.Check(rShared.GetValue());
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pSetItem = 0;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// defaults for distance and height
//STRIP001 		long nDefaultDist = DEF_DIST_WRITER;
//STRIP001 		const SfxPoolItem* pExt1 = GetItem( rSet, SID_ATTR_PAGE_EXT1 );
//STRIP001 		const SfxPoolItem* pExt2 = GetItem( rSet, SID_ATTR_PAGE_EXT2 );
//STRIP001 
//STRIP001 		if ( pExt1 && pExt1->ISA(SfxBoolItem) && pExt2 && pExt2->ISA(SfxBoolItem) )
//STRIP001 			nDefaultDist = DEF_DIST_CALC;
//STRIP001 
//STRIP001 		SetMetricValue( aDistEdit, nDefaultDist, SFX_MAPUNIT_100TH_MM );
//STRIP001 		SetMetricValue( aHeightEdit, 500, SFX_MAPUNIT_100TH_MM );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !pSetItem )
//STRIP001 	{
//STRIP001 		aTurnOnBox.Check( FALSE );
//STRIP001 		aHeightDynBtn.Check( TRUE );
//STRIP001 		aCntSharedBox.Check( TRUE );
//STRIP001 	}
//STRIP001 
//STRIP001 	TurnOnHdl(0);
//STRIP001 
//STRIP001 	aTurnOnBox.SaveValue();
//STRIP001 	aDistEdit.SaveValue();
//STRIP001 	aHeightEdit.SaveValue();
//STRIP001 	aHeightDynBtn.SaveValue();
//STRIP001 	aLMEdit.SaveValue();
//STRIP001 	aRMEdit.SaveValue();
//STRIP001 	aCntSharedBox.SaveValue();
//STRIP001 	RangeHdl( 0 );
//STRIP001 
//STRIP001 	USHORT nHtmlMode = 0;
//STRIP001 	const SfxPoolItem* pItem = 0;
//STRIP001 	SfxObjectShell* pShell;
//STRIP001 	if(SFX_ITEM_SET == rSet.GetItemState(SID_HTML_MODE, FALSE, &pItem) ||
//STRIP001 		( 0 != (pShell = SfxObjectShell::Current()) &&
//STRIP001 					0 != (pItem = pShell->GetItem(SID_HTML_MODE))))
//STRIP001 	{
//STRIP001 		nHtmlMode = ((SfxUInt16Item*)pItem)->GetValue();
//STRIP001 		if(nHtmlMode && HTMLMODE_ON)
//STRIP001 		{
//STRIP001 			aCntSharedBox.Hide();
//STRIP001 			aBackgroundBtn.Hide();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:	Handler initialisieren
 --------------------------------------------------------------------*/

//STRIP001 void SvxHFPage::InitHandler()
//STRIP001 {
//STRIP001 	aTurnOnBox.SetClickHdl(LINK(this, 	SvxHFPage, TurnOnHdl));
//STRIP001 	aDistEdit.SetModifyHdl(LINK(this, 	SvxHFPage, DistModify));
//STRIP001 	aDistEdit.SetLoseFocusHdl(LINK(this, SvxHFPage, RangeHdl));
//STRIP001 
//STRIP001 	aHeightEdit.SetModifyHdl(LINK(this, 	SvxHFPage, HeightModify));
//STRIP001 	aHeightEdit.SetLoseFocusHdl(LINK(this,SvxHFPage,RangeHdl));
//STRIP001 
//STRIP001 	aLMEdit.SetModifyHdl(LINK(this, 		SvxHFPage, BorderModify));
//STRIP001 	aLMEdit.SetLoseFocusHdl(LINK(this,	SvxHFPage, RangeHdl));
//STRIP001 	aRMEdit.SetModifyHdl(LINK(this, 		SvxHFPage, BorderModify));
//STRIP001 	aRMEdit.SetLoseFocusHdl(LINK(this,	SvxHFPage, RangeHdl));
//STRIP001 	aBackgroundBtn.SetClickHdl(LINK(this,SvxHFPage, BackgroundHdl));
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:	Ein/aus
 --------------------------------------------------------------------*/

//STRIP001 IMPL_LINK( SvxHFPage, TurnOnHdl, CheckBox *, pBox )
//STRIP001 {
//STRIP001 	if ( aTurnOnBox.IsChecked() )
//STRIP001 	{
//STRIP001 		aDistFT.Enable();
//STRIP001 		aDistEdit.Enable();
//STRIP001         aDynSpacingCB.Enable();
//STRIP001 		aHeightFT.Enable();
//STRIP001 		aHeightEdit.Enable();
//STRIP001 		aHeightDynBtn.Enable();
//STRIP001 		aLMLbl.Enable();
//STRIP001 		aLMEdit.Enable();
//STRIP001 		aRMLbl.Enable();
//STRIP001 		aRMEdit.Enable();
//STRIP001 
//STRIP001 		USHORT nUsage = aBspWin.GetUsage();
//STRIP001 
//STRIP001 		if( nUsage == SVX_PAGE_RIGHT || nUsage == SVX_PAGE_LEFT )
//STRIP001 			aCntSharedBox.Disable();
//STRIP001 		else
//STRIP001 			aCntSharedBox.Enable();
//STRIP001 		aBackgroundBtn.Enable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		BOOL bDelete = TRUE;
//STRIP001 
//STRIP001 		if ( !bDisableQueryBox && pBox && aTurnOnBox.GetSavedValue() == TRUE )
//STRIP001 			bDelete = ( QueryBox( this, ResId( RID_SVXQBX_DELETE_HEADFOOT, DIALOG_MGR() ) ).Execute() == RET_YES );
//STRIP001 
//STRIP001 		if ( bDelete )
//STRIP001 		{
//STRIP001 			aDistFT.Disable();
//STRIP001 			aDistEdit.Disable();
//STRIP001             aDynSpacingCB.Enable(FALSE);
//STRIP001             aHeightFT.Disable();
//STRIP001 			aHeightEdit.Disable();
//STRIP001 			aHeightDynBtn.Disable();
//STRIP001 
//STRIP001 			aLMLbl.Disable();
//STRIP001 			aLMEdit.Disable();
//STRIP001 			aRMLbl.Disable();
//STRIP001 			aRMEdit.Disable();
//STRIP001 
//STRIP001 			aCntSharedBox.Disable();
//STRIP001 			aBackgroundBtn.Disable();
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aTurnOnBox.Check();
//STRIP001 	}
//STRIP001 	UpdateExample();
//STRIP001 	return 0;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:	Abstand im Bsp Modifizieren
 --------------------------------------------------------------------*/

//STRIP001 IMPL_LINK_INLINE_START( SvxHFPage, DistModify, MetricField *, EMPTYARG )
//STRIP001 {
//STRIP001 	UpdateExample();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SvxHFPage, DistModify, MetricField *, EMPTYARG )

//STRIP001 IMPL_LINK_INLINE_START( SvxHFPage, HeightModify, MetricField *, EMPTYARG )
//STRIP001 {
//STRIP001 	UpdateExample();
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SvxHFPage, HeightModify, MetricField *, EMPTYARG )

/*--------------------------------------------------------------------
	Beschreibung: Raender einstellen
 --------------------------------------------------------------------*/

//STRIP001 IMPL_LINK_INLINE_START( SvxHFPage, BorderModify, MetricField *, EMPTYARG )
//STRIP001 {
//STRIP001 	UpdateExample();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SvxHFPage, BorderModify, MetricField *, EMPTYARG )

/*--------------------------------------------------------------------
	Beschreibung:	Hintergrund
 --------------------------------------------------------------------*/

//STRIP001 IMPL_LINK( SvxHFPage, BackgroundHdl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	if ( !pBBSet )
//STRIP001 	{
//STRIP001 		// nur die n"otigen Items f"uer Umrandung und Hintergrund benutzen
//STRIP001 		USHORT nBrush = GetWhich( SID_ATTR_BRUSH );
//STRIP001 		USHORT nOuter = GetWhich( SID_ATTR_BORDER_OUTER );
//STRIP001 		USHORT nInner = GetWhich( SID_ATTR_BORDER_INNER );
//STRIP001 		USHORT nShadow = GetWhich( SID_ATTR_BORDER_SHADOW );
//STRIP001 
//STRIP001 		// einen leeren Set erzeugen
//STRIP001 		pBBSet = new SfxItemSet( *GetItemSet().GetPool(), nBrush, nBrush,
//STRIP001 								 nOuter, nOuter, nInner, nInner,
//STRIP001 								 nShadow, nShadow, 0 );
//STRIP001 		const SfxPoolItem* pItem;
//STRIP001 
//STRIP001 		if ( SFX_ITEM_SET ==
//STRIP001 			 GetItemSet().GetItemState( GetWhich( nId ), FALSE, &pItem ) )
//STRIP001 			// wenn es schon einen gesetzen Set gibt, dann diesen benutzen
//STRIP001 			pBBSet->Put( ( (SvxSetItem*)pItem)->GetItemSet() );
//STRIP001 
//STRIP001 		if ( SFX_ITEM_SET ==
//STRIP001 			 GetItemSet().GetItemState( nInner, FALSE, &pItem ) )
//STRIP001 			// das gesetze InfoItem wird immer ben"otigt
//STRIP001 			pBBSet->Put( *pItem );
//STRIP001 	}
//STRIP001 
//STRIP001 	SvxBorderBackgroundDlg* pDlg =
//STRIP001 		new SvxBorderBackgroundDlg( this, *pBBSet, bEnableBackgroundSelector );
//STRIP001 
//STRIP001 	if ( pDlg->Execute() == RET_OK && pDlg->GetOutputItemSet() )
//STRIP001 	{
//STRIP001 		SfxItemIter aIter( *pDlg->GetOutputItemSet() );
//STRIP001 		const SfxPoolItem* pItem = aIter.FirstItem();
//STRIP001 
//STRIP001 		while ( pItem )
//STRIP001 		{
//STRIP001 			if ( !IsInvalidItem( pItem ) )
//STRIP001 				pBBSet->Put( *pItem );
//STRIP001 			pItem = aIter.NextItem();
//STRIP001 		}
//STRIP001 
//STRIP001 		//----------------------------------------------------------------
//STRIP001 
//STRIP001 		USHORT nWhich = GetWhich( SID_ATTR_BRUSH );
//STRIP001 
//STRIP001 		if ( pBBSet->GetItemState( nWhich ) == SFX_ITEM_SET )
//STRIP001 		{
//STRIP001 			const SvxBrushItem& rItem = (const SvxBrushItem&)pBBSet->Get( nWhich );
//STRIP001 			if ( nId == SID_ATTR_PAGE_HEADERSET )
//STRIP001 				aBspWin.SetHdColor( rItem.GetColor() );
//STRIP001 			else
//STRIP001 				aBspWin.SetFtColor( rItem.GetColor() );
//STRIP001 		}
//STRIP001 
//STRIP001 		//----------------------------------------------------------------
//STRIP001 
//STRIP001 		nWhich = GetWhich( SID_ATTR_BORDER_OUTER );
//STRIP001 
//STRIP001 		if ( pBBSet->GetItemState( nWhich ) == SFX_ITEM_SET )
//STRIP001 		{
//STRIP001 			const SvxBoxItem& rItem = (const SvxBoxItem&)pBBSet->Get( nWhich );
//STRIP001 
//STRIP001 			if ( nId == SID_ATTR_PAGE_HEADERSET )
//STRIP001 				aBspWin.SetHdBorder( rItem );
//STRIP001 			else
//STRIP001 				aBspWin.SetFtBorder( rItem );
//STRIP001 		}
//STRIP001 
//STRIP001 		UpdateExample();
//STRIP001 	}
//STRIP001 	delete pDlg;
//STRIP001 	return 0;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:	Bsp
 --------------------------------------------------------------------*/

//STRIP001 void SvxHFPage::UpdateExample()
//STRIP001 {
//STRIP001 	if ( nId == SID_ATTR_PAGE_HEADERSET )
//STRIP001 	{
//STRIP001 		aBspWin.SetHeader( aTurnOnBox.IsChecked() );
//STRIP001 		aBspWin.SetHdHeight( GetCoreValue( aHeightEdit, SFX_MAPUNIT_TWIP ) );
//STRIP001 		aBspWin.SetHdDist( GetCoreValue( aDistEdit, SFX_MAPUNIT_TWIP ) );
//STRIP001 		aBspWin.SetHdLeft( GetCoreValue( aLMEdit, SFX_MAPUNIT_TWIP ) );
//STRIP001 		aBspWin.SetHdRight( GetCoreValue( aRMEdit, SFX_MAPUNIT_TWIP ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aBspWin.SetFooter( aTurnOnBox.IsChecked() );
//STRIP001 		aBspWin.SetFtHeight( GetCoreValue( aHeightEdit, SFX_MAPUNIT_TWIP ) );
//STRIP001 		aBspWin.SetFtDist( GetCoreValue( aDistEdit, SFX_MAPUNIT_TWIP ) );
//STRIP001 		aBspWin.SetFtLeft( GetCoreValue( aLMEdit, SFX_MAPUNIT_TWIP ) );
//STRIP001 		aBspWin.SetFtRight( GetCoreValue( aRMEdit, SFX_MAPUNIT_TWIP ) );
//STRIP001 	}
//STRIP001 	aBspWin.Invalidate();
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung: Hintergrund im Beispiel setzen
 --------------------------------------------------------------------*/

//STRIP001 void SvxHFPage::ResetBackground_Impl( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	USHORT nWhich = GetWhich( SID_ATTR_PAGE_HEADERSET );
//STRIP001 
//STRIP001 	if ( rSet.GetItemState( nWhich, FALSE ) == SFX_ITEM_SET )
//STRIP001 	{
//STRIP001 		const SvxSetItem& rSetItem =
//STRIP001 			(const SvxSetItem&)rSet.Get( nWhich, FALSE );
//STRIP001 		const SfxItemSet& rTmpSet = rSetItem.GetItemSet();
//STRIP001 		const SfxBoolItem& rOn =
//STRIP001 			(const SfxBoolItem&)rTmpSet.Get( GetWhich( SID_ATTR_PAGE_ON ) );
//STRIP001 
//STRIP001 		if ( rOn.GetValue() )
//STRIP001 		{
//STRIP001 			nWhich = GetWhich( SID_ATTR_BRUSH );
//STRIP001 
//STRIP001 			if ( rTmpSet.GetItemState( nWhich ) == SFX_ITEM_SET )
//STRIP001 			{
//STRIP001 				const SvxBrushItem& rItem = (const SvxBrushItem&)rTmpSet.Get( nWhich );
//STRIP001 				aBspWin.SetHdColor( rItem.GetColor() );
//STRIP001 			}
//STRIP001 			nWhich = GetWhich( SID_ATTR_BORDER_OUTER );
//STRIP001 
//STRIP001 			if ( rTmpSet.GetItemState( nWhich ) == SFX_ITEM_SET )
//STRIP001 			{
//STRIP001 				const SvxBoxItem& rItem =
//STRIP001 					(const SvxBoxItem&)rTmpSet.Get( nWhich );
//STRIP001 				aBspWin.SetHdBorder( rItem );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	nWhich = GetWhich( SID_ATTR_PAGE_FOOTERSET );
//STRIP001 
//STRIP001 	if ( rSet.GetItemState( nWhich, FALSE ) == SFX_ITEM_SET )
//STRIP001 	{
//STRIP001 		const SvxSetItem& rSetItem =
//STRIP001 			(const SvxSetItem&)rSet.Get( nWhich, FALSE );
//STRIP001 		const SfxItemSet& rTmpSet = rSetItem.GetItemSet();
//STRIP001 		const SfxBoolItem& rOn =
//STRIP001 			(const SfxBoolItem&)rTmpSet.Get( GetWhich( SID_ATTR_PAGE_ON ) );
//STRIP001 
//STRIP001 		if ( rOn.GetValue() )
//STRIP001 		{
//STRIP001 			nWhich = GetWhich( SID_ATTR_BRUSH );
//STRIP001 
//STRIP001 			if ( rTmpSet.GetItemState( nWhich ) == SFX_ITEM_SET )
//STRIP001 			{
//STRIP001 				const SvxBrushItem& rItem = (const SvxBrushItem&)rTmpSet.Get( nWhich );
//STRIP001 				aBspWin.SetFtColor( rItem.GetColor() );
//STRIP001 			}
//STRIP001 			nWhich = GetWhich( SID_ATTR_BORDER_OUTER );
//STRIP001 
//STRIP001 			if ( rTmpSet.GetItemState( nWhich ) == SFX_ITEM_SET )
//STRIP001 			{
//STRIP001 				const SvxBoxItem& rItem =
//STRIP001 					(const SvxBoxItem&)rTmpSet.Get( nWhich );
//STRIP001 				aBspWin.SetFtBorder( rItem );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	nWhich = GetWhich( SID_ATTR_BRUSH );
//STRIP001 
//STRIP001 	if ( rSet.GetItemState( nWhich ) >= SFX_ITEM_AVAILABLE )
//STRIP001 	{
//STRIP001 		const SvxBrushItem& rItem = (const SvxBrushItem&)rSet.Get( nWhich );
//STRIP001 		aBspWin.SetColor( rItem.GetColor() );
//STRIP001 		const Graphic* pGrf = rItem.GetGraphic();
//STRIP001 
//STRIP001 		if ( pGrf )
//STRIP001 		{
//STRIP001 			Bitmap aBitmap = pGrf->GetBitmap();
//STRIP001 			aBspWin.SetBitmap( &aBitmap );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aBspWin.SetBitmap( NULL );
//STRIP001 	}
//STRIP001 	nWhich = GetWhich( SID_ATTR_BORDER_OUTER );
//STRIP001 
//STRIP001 	if ( rSet.GetItemState( nWhich ) >= SFX_ITEM_AVAILABLE )
//STRIP001 	{
//STRIP001 		const SvxBoxItem& rItem = (const SvxBoxItem&)rSet.Get( nWhich );
//STRIP001 		aBspWin.SetBorder( rItem );
//STRIP001 	}
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 void SvxHFPage::ActivatePage( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	const SfxPoolItem* pItem = GetItem( rSet, SID_ATTR_LRSPACE );
//STRIP001 
//STRIP001 	if ( pItem )
//STRIP001 	{
//STRIP001 		// linken und rechten Rand einstellen
//STRIP001 		const SvxLRSpaceItem& rLRSpace = (const SvxLRSpaceItem&)*pItem;
//STRIP001 
//STRIP001 		aBspWin.SetLeft( rLRSpace.GetLeft() );
//STRIP001 		aBspWin.SetRight( rLRSpace.GetRight() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aBspWin.SetLeft( 0 );
//STRIP001 		aBspWin.SetRight( 0 );
//STRIP001 	}
//STRIP001 
//STRIP001 	pItem = GetItem( rSet, SID_ATTR_ULSPACE );
//STRIP001 
//STRIP001 	if ( pItem )
//STRIP001 	{
//STRIP001 		// oberen und unteren Rand einstellen
//STRIP001 		const SvxULSpaceItem& rULSpace = (const SvxULSpaceItem&)*pItem;
//STRIP001 
//STRIP001 		aBspWin.SetTop( rULSpace.GetUpper() );
//STRIP001 		aBspWin.SetBottom( rULSpace.GetLower() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aBspWin.SetTop( 0 );
//STRIP001 		aBspWin.SetBottom( 0 );
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nUsage = SVX_PAGE_ALL;
//STRIP001 	pItem = GetItem( rSet, SID_ATTR_PAGE );
//STRIP001 
//STRIP001 	if ( pItem )
//STRIP001 		nUsage = ( (const SvxPageItem*)pItem )->GetPageUsage();
//STRIP001 
//STRIP001 	aBspWin.SetUsage( nUsage );
//STRIP001 
//STRIP001 	if ( SVX_PAGE_RIGHT == nUsage || SVX_PAGE_LEFT == nUsage )
//STRIP001 		aCntSharedBox.Disable();
//STRIP001 	else
//STRIP001 		aCntSharedBox.Enable();
//STRIP001 	pItem = GetItem( rSet, SID_ATTR_PAGE_SIZE );
//STRIP001 
//STRIP001 	if ( pItem )
//STRIP001 	{
//STRIP001 		// Orientation und Size aus dem PageItem
//STRIP001 		const SvxSizeItem& rSize = (const SvxSizeItem&)*pItem;
//STRIP001 		// die Groesse ist ggf. schon geswappt (Querformat)
//STRIP001 		aBspWin.SetSize( rSize.GetSize() );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Kopfzeilen-Attribute auswerten
//STRIP001 	const SvxSetItem* pSetItem = 0;
//STRIP001 
//STRIP001 	if ( SFX_ITEM_SET == rSet.GetItemState( GetWhich( SID_ATTR_PAGE_HEADERSET ),
//STRIP001 											FALSE,
//STRIP001 											(const SfxPoolItem**)&pSetItem ) )
//STRIP001 	{
//STRIP001 		const SfxItemSet& rHeaderSet = pSetItem->GetItemSet();
//STRIP001 		const SfxBoolItem& rHeaderOn =
//STRIP001 			(const SfxBoolItem&)rHeaderSet.Get( GetWhich( SID_ATTR_PAGE_ON ) );
//STRIP001 
//STRIP001 		if ( rHeaderOn.GetValue() )
//STRIP001 		{
//STRIP001 			const SfxBoolItem& rDynamic = (const SfxBoolItem&)
//STRIP001 				rHeaderSet.Get( GetWhich( SID_ATTR_PAGE_DYNAMIC ) );
//STRIP001 			const SvxSizeItem& rSize = (const SvxSizeItem&)
//STRIP001 				rHeaderSet.Get( GetWhich( SID_ATTR_PAGE_SIZE ) );
//STRIP001 			const SvxULSpaceItem& rUL = (const SvxULSpaceItem&)
//STRIP001 				rHeaderSet.Get( GetWhich(SID_ATTR_ULSPACE ) );
//STRIP001 			const SvxLRSpaceItem& rLR = (const SvxLRSpaceItem&)
//STRIP001 				rHeaderSet.Get( GetWhich( SID_ATTR_LRSPACE ) );
//STRIP001 			long nDist = rUL.GetLower();
//STRIP001 
//STRIP001 			aBspWin.SetHdHeight( rSize.GetSize().Height() - nDist );
//STRIP001 			aBspWin.SetHdDist( nDist );
//STRIP001 			aBspWin.SetHdLeft( rLR.GetLeft() );
//STRIP001 			aBspWin.SetHdRight( rLR.GetRight() );
//STRIP001 			aBspWin.SetHeader( TRUE );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pSetItem = 0;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !pSetItem )
//STRIP001 	{
//STRIP001 		aBspWin.SetHeader( FALSE );
//STRIP001 
//STRIP001 		if ( SID_ATTR_PAGE_HEADERSET == nId )
//STRIP001 			aCntSharedBox.Disable();
//STRIP001 	}
//STRIP001 	pSetItem = 0;
//STRIP001 
//STRIP001 	if ( SFX_ITEM_SET == rSet.GetItemState( GetWhich( SID_ATTR_PAGE_FOOTERSET ),
//STRIP001 											FALSE,
//STRIP001 											(const SfxPoolItem**)&pSetItem ) )
//STRIP001 	{
//STRIP001 		const SfxItemSet& rFooterSet = pSetItem->GetItemSet();
//STRIP001 		const SfxBoolItem& rFooterOn =
//STRIP001 			(const SfxBoolItem&)rFooterSet.Get( GetWhich( SID_ATTR_PAGE_ON ) );
//STRIP001 
//STRIP001 		if ( rFooterOn.GetValue() )
//STRIP001 		{
//STRIP001 			const SfxBoolItem& rDynamic = (const SfxBoolItem&)
//STRIP001 				rFooterSet.Get( GetWhich( SID_ATTR_PAGE_DYNAMIC ) );
//STRIP001 			const SvxSizeItem& rSize = (const SvxSizeItem&)
//STRIP001 				rFooterSet.Get( GetWhich( SID_ATTR_PAGE_SIZE ) );
//STRIP001 			const SvxULSpaceItem& rUL = (const SvxULSpaceItem&)
//STRIP001 				rFooterSet.Get( GetWhich( SID_ATTR_ULSPACE ) );
//STRIP001 			const SvxLRSpaceItem& rLR = (const SvxLRSpaceItem&)
//STRIP001 				rFooterSet.Get( GetWhich( SID_ATTR_LRSPACE ) );
//STRIP001 			long nDist = rUL.GetUpper();
//STRIP001 
//STRIP001 			aBspWin.SetFtHeight( rSize.GetSize().Height() - nDist );
//STRIP001 			aBspWin.SetFtDist( nDist );
//STRIP001 			aBspWin.SetFtLeft( rLR.GetLeft() );
//STRIP001 			aBspWin.SetFtRight( rLR.GetRight() );
//STRIP001 			aBspWin.SetFooter( TRUE );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pSetItem = 0;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !pSetItem )
//STRIP001 	{
//STRIP001 		aBspWin.SetFooter( FALSE );
//STRIP001 
//STRIP001 		if ( SID_ATTR_PAGE_FOOTERSET == nId )
//STRIP001 			aCntSharedBox.Disable();
//STRIP001 	}
//STRIP001 
//STRIP001 	pItem = GetItem( rSet, SID_ATTR_PAGE_EXT1 );
//STRIP001 
//STRIP001 	if ( pItem && pItem->ISA(SfxBoolItem) )
//STRIP001 	{
//STRIP001 		aBspWin.SetTable( TRUE );
//STRIP001 		aBspWin.SetHorz( ( (SfxBoolItem*)pItem )->GetValue() );
//STRIP001 	}
//STRIP001 
//STRIP001 	pItem = GetItem( rSet, SID_ATTR_PAGE_EXT2 );
//STRIP001 
//STRIP001 	if ( pItem && pItem->ISA(SfxBoolItem) )
//STRIP001 	{
//STRIP001 		aBspWin.SetTable( TRUE );
//STRIP001 		aBspWin.SetVert( ( (SfxBoolItem*)pItem )->GetValue() );
//STRIP001 	}
//STRIP001 	ResetBackground_Impl( rSet );
//STRIP001 	RangeHdl( 0 );
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 int SvxHFPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	if ( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 	return LEAVE_PAGE;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:	Berech
 --------------------------------------------------------------------*/

//STRIP001 IMPL_LINK( SvxHFPage, RangeHdl, Edit *, EMPTYARG )
//STRIP001 {
//STRIP001 	long nHHeight = aBspWin.GetHdHeight();
//STRIP001 	long nHDist   = aBspWin.GetHdDist();
//STRIP001 
//STRIP001 	long nFHeight = aBspWin.GetFtHeight();
//STRIP001 	long nFDist   = aBspWin.GetFtDist();
//STRIP001 
//STRIP001 	long nHeight = Max( (long)MINBODY,
//STRIP001 		aHeightEdit.Denormalize( aHeightEdit.GetValue( FUNIT_TWIP ) ) );
//STRIP001 	long nDist   = aTurnOnBox.IsChecked() ?
//STRIP001 		aDistEdit.Denormalize( aDistEdit.GetValue( FUNIT_TWIP ) ) : 0;
//STRIP001 
//STRIP001 	long nMin;
//STRIP001 	long nMax;
//STRIP001 
//STRIP001 	if ( nId == SID_ATTR_PAGE_HEADERSET )
//STRIP001 	{
//STRIP001 		nHHeight = nHeight;
//STRIP001 		nHDist   = nDist;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nFHeight = nHeight;
//STRIP001 		nFDist 	 = nDist;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Aktuelle Werte der Seitenraender
//STRIP001 	long nBT = aBspWin.GetTop();
//STRIP001 	long nBB = aBspWin.GetBottom();
//STRIP001 	long nBL = aBspWin.GetLeft();
//STRIP001 	long nBR = aBspWin.GetRight();
//STRIP001 
//STRIP001 	long nH  = aBspWin.GetSize().Height();
//STRIP001 	long nW  = aBspWin.GetSize().Width();
//STRIP001 
//STRIP001 	// Grenzen
//STRIP001 	if ( nId == SID_ATTR_PAGE_HEADERSET )
//STRIP001 	{
//STRIP001 		// Header
//STRIP001 		nMin = ( nH - nBB - nBT ) / 5; // 20%
//STRIP001 		nMax = Max( nH - nMin - nHDist - nFDist - nFHeight - nBB - nBT,
//STRIP001 					nMin );
//STRIP001 		aHeightEdit.SetMax( aHeightEdit.Normalize( nMax ), FUNIT_TWIP );
//STRIP001 		nMin = ( nH - nBB - nBT ) / 5; // 20%
//STRIP001 		nDist = Max( nH - nMin - nHHeight - nFDist - nFHeight - nBB - nBT,
//STRIP001 					 long(0) );
//STRIP001 		aDistEdit.SetMax( aDistEdit.Normalize( nDist ), FUNIT_TWIP );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Footer
//STRIP001 		nMin = ( nH - nBT - nBB ) / 5; // 20%
//STRIP001 		nMax = Max( nH - nMin - nFDist - nHDist - nHHeight - nBT - nBB,
//STRIP001 					nMin );
//STRIP001 		aHeightEdit.SetMax( aHeightEdit.Normalize( nMax ), FUNIT_TWIP );
//STRIP001 		nMin = ( nH - nBT - nBB ) / 5; // 20%
//STRIP001 		nDist = Max( nH - nMin - nFHeight - nHDist - nHHeight - nBT - nBB,
//STRIP001 					 long(0) );
//STRIP001 		aDistEdit.SetMax( aDistEdit.Normalize( nDist ), FUNIT_TWIP );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Einzuege beschraenken
//STRIP001 	nMax = nW - nBL - nBR -
//STRIP001 		   aRMEdit.Denormalize( aRMEdit.GetValue( FUNIT_TWIP ) ) - MINBODY;
//STRIP001 	aLMEdit.SetMax( aLMEdit.Normalize( nMax ), FUNIT_TWIP );
//STRIP001 
//STRIP001 	nMax = nW - nBL - nBR -
//STRIP001 		   aLMEdit.Denormalize( aLMEdit.GetValue( FUNIT_TWIP ) ) - MINBODY;
//STRIP001 	aRMEdit.SetMax( aLMEdit.Normalize( nMax ), FUNIT_TWIP );
//STRIP001 	return 0;
//STRIP001 }
/* -----------------------------26.08.2002 12:49------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 void lcl_Move(Window& rWin, sal_Int32 nDiff)
//STRIP001 {
//STRIP001 	Point aPos(rWin.GetPosPixel());
//STRIP001 	aPos.Y() -= nDiff;
//STRIP001 	rWin.SetPosPixel(aPos);
//STRIP001 }
//STRIP001 void SvxHFPage::EnableDynamicSpacing()
//STRIP001 {
//STRIP001     aDynSpacingCB.Show();
//STRIP001     //move all following controls
//STRIP001     Window* aMoveWindows[] =
//STRIP001     {
//STRIP001         &aHeightFT,
//STRIP001         &aHeightEdit,
//STRIP001         &aHeightDynBtn,
//STRIP001         &aBackgroundBtn,
//STRIP001         0
//STRIP001     };
//STRIP001     sal_Int32 nOffset = aTurnOnBox.GetPosPixel().Y() - aCntSharedBox.GetPosPixel().Y();
//STRIP001     sal_Int32 nIdx = 0;
//STRIP001     while(aMoveWindows[nIdx])
//STRIP001         lcl_Move(*aMoveWindows[nIdx++], nOffset);
//STRIP001 }

}
