/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_grfpage.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:45:17 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#define ITEMID_GRF_CROP	 		0
#define ITEMID_SIZE 			0
#define ITEMID_BRUSH 			0

#ifndef _SHL_HXX //autogen
#include <tools/shl.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <bf_sfx2/app.hxx>
#endif
#ifndef _SFXMODULE_HXX //autogen
#include <bf_sfx2/module.hxx>
#endif

#ifndef _SFXSIDS_HRC
#include <bf_sfx2/sfxsids.hrc>
#endif


#ifndef _SVX_DIALMGR_HXX //autogen
#include <dialmgr.hxx>
#endif
#ifndef _SVX_DLGUTIL_HXX
#include <dlgutil.hxx>
#endif
#ifndef _SVX_SIZEITEM_HXX //autogen
#include <sizeitem.hxx>
#endif
#ifndef _SVX_BRSHITEM_HXX //autogen
#include <brshitem.hxx>
#endif

#ifndef _GRFPAGE_HXX
#include <grfpage.hxx>
#endif
#ifndef _SVX_GRFCROP_HXX
#include <grfcrop.hxx>
#endif

#ifndef _GRFPAGE_HRC
#include <grfpage.hrc>
#endif
#ifndef _SVX_DIALOGS_HRC
#include <dialogs.hrc>
#endif
#ifndef _SVX_SVXIDS_HRC
#include <svxids.hrc>
#endif
namespace binfilter {


//STRIP001 #define CM_1_TO_TWIP 		567


//STRIP001 inline long lcl_GetValue( MetricField& rMetric, FieldUnit eUnit )
//STRIP001 {
//STRIP001 	return rMetric.Denormalize( rMetric.GetValue( eUnit ));
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung: Grafik zuschneiden
 --------------------------------------------------------------------*/

//STRIP001 SvxGrfCropPage::SvxGrfCropPage ( Window *pParent, const SfxItemSet &rSet )
//STRIP001 	: SfxTabPage( pParent, 	SVX_RES( RID_SVXPAGE_GRFCROP ), rSet ),
//STRIP001     aSizeFL(        this, ResId( FL_SIZE    )),
//STRIP001 	aWidthFT( 		this, ResId( FT_WIDTH 	)),
//STRIP001 	aWidthMF( 		this, ResId( MF_WIDTH 	)),
//STRIP001 	aHeightFT( 		this, ResId( FT_HEIGHT	)),
//STRIP001 	aHeightMF( 		this, ResId( MF_HEIGHT	)),
//STRIP001     aZoomFL(        this, ResId( FL_ZOOM    )),
//STRIP001 	aWidthZoomFT( 	this, ResId( FT_WIDTHZOOM )),
//STRIP001 	aWidthZoomMF( 	this, ResId( MF_WIDTHZOOM )),
//STRIP001 	aHeightZoomFT( 	this, ResId( FT_HEIGHTZOOM)),
//STRIP001 	aHeightZoomMF( 	this, ResId( MF_HEIGHTZOOM)),
//STRIP001     aCropFL(        this, ResId( FL_CROP    )),
//STRIP001 	aLeftFT( 		this, ResId( FT_LEFT 	)),
//STRIP001 	aLeftMF( 		this, ResId( MF_LEFT 	)),
//STRIP001 	aRightFT( 		this, ResId( FT_RIGHT 	)),
//STRIP001 	aRightMF( 		this, ResId( MF_RIGHT 	)),
//STRIP001 	aTopFT( 		this, ResId( FT_TOP 	)),
//STRIP001 	aTopMF( 		this, ResId( MF_TOP		)),
//STRIP001 	aBottomFT( 		this, ResId( FT_BOTTOM 	)),
//STRIP001 	aBottomMF( 		this, ResId( MF_BOTTOM 	)),
//STRIP001 	aSizeConstRB( 	this, ResId( RB_SIZECONST)),
//STRIP001 	aZoomConstRB( 	this, ResId( RB_ZOOMCONST)),
//STRIP001 	aExampleWN( 	this, ResId( WN_BSP		)),
//STRIP001 	aOrigSizeFT(	this, ResId(FT_ORIG_SIZE)),
//STRIP001 	aOrigSizePB( 	this, ResId( PB_ORGSIZE )),
//STRIP001 	pLastCropField(0),
//STRIP001 	bInitialized(FALSE),
//STRIP001 	bSetOrigSize(FALSE)
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001     // set the correct metric
//STRIP001 	const FieldUnit eMetric = GetModuleFieldUnit( &rSet );
//STRIP001 
//STRIP001 	SetFieldUnit( aWidthMF, eMetric );
//STRIP001 	SetFieldUnit( aHeightMF, eMetric );
//STRIP001 	SetFieldUnit( aLeftMF, eMetric );
//STRIP001 	SetFieldUnit( aRightMF, eMetric );
//STRIP001 	SetFieldUnit( aTopMF , eMetric );
//STRIP001 	SetFieldUnit( aBottomMF, eMetric );
//STRIP001 
//STRIP001 	Link aLk = LINK(this, SvxGrfCropPage, SizeHdl);
//STRIP001 	aWidthMF.SetModifyHdl( aLk );
//STRIP001 	aHeightMF.SetModifyHdl( aLk );
//STRIP001 
//STRIP001 	aLk = LINK(this, SvxGrfCropPage, ZoomHdl);
//STRIP001 	aWidthZoomMF.SetModifyHdl( aLk );
//STRIP001 	aHeightZoomMF.SetModifyHdl( aLk );
//STRIP001 
//STRIP001 	aLk = LINK(this, SvxGrfCropPage, CropHdl);
//STRIP001 	aLeftMF.SetDownHdl( aLk );
//STRIP001 	aRightMF.SetDownHdl( aLk );
//STRIP001 	aTopMF.SetDownHdl( aLk );
//STRIP001 	aBottomMF.SetDownHdl( aLk );
//STRIP001 	aLeftMF.SetUpHdl( aLk );
//STRIP001 	aRightMF.SetUpHdl( aLk );
//STRIP001 	aTopMF.SetUpHdl( aLk );
//STRIP001 	aBottomMF.SetUpHdl( aLk );
//STRIP001 
//STRIP001 	aLk = LINK(this, SvxGrfCropPage, CropModifyHdl);
//STRIP001 	aLeftMF.SetModifyHdl( aLk );
//STRIP001 	aRightMF.SetModifyHdl( aLk );
//STRIP001 	aTopMF.SetModifyHdl( aLk );
//STRIP001 	aBottomMF.SetModifyHdl( aLk );
//STRIP001 
//STRIP001 	aLk = LINK(this, SvxGrfCropPage, CropLoseFocusHdl);
//STRIP001 	aLeftMF.SetLoseFocusHdl( aLk );
//STRIP001 	aRightMF.SetLoseFocusHdl( aLk );
//STRIP001 	aTopMF.SetLoseFocusHdl( aLk );
//STRIP001 	aBottomMF.SetLoseFocusHdl( aLk );
//STRIP001 
//STRIP001 	aLk = LINK(this, SvxGrfCropPage, OrigSizeHdl);
//STRIP001 	aOrigSizePB.SetClickHdl( aLk );
//STRIP001 
//STRIP001 	aTimer.SetTimeoutHdl(LINK(this, SvxGrfCropPage, Timeout));
//STRIP001 	aTimer.SetTimeout( 1500 );
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 SvxGrfCropPage::~SvxGrfCropPage()
//STRIP001 {
//STRIP001 	aTimer.Stop();
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 SfxTabPage* SvxGrfCropPage::Create(Window *pParent, const SfxItemSet &rSet)
//STRIP001 {
//STRIP001 	return new SvxGrfCropPage( pParent, rSet );
//STRIP001 }
/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 void SvxGrfCropPage::Reset( const SfxItemSet &rSet )
//STRIP001 {
//STRIP001 	const SfxPoolItem* pItem;
//STRIP001 	const SfxItemPool& rPool = *rSet.GetPool();
//STRIP001 
//STRIP001 	if(SFX_ITEM_SET == rSet.GetItemState( rPool.GetWhich(
//STRIP001 									SID_ATTR_GRAF_KEEP_ZOOM ), TRUE, &pItem ))
//STRIP001 	{
//STRIP001 		if( ((const SfxBoolItem*)pItem)->GetValue() )
//STRIP001 			aZoomConstRB.Check();
//STRIP001 		else
//STRIP001 			aSizeConstRB.Check();
//STRIP001 		aZoomConstRB.SaveValue();
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT nW = rPool.GetWhich( SID_ATTR_GRAF_CROP );
//STRIP001 	if( SFX_ITEM_SET == rSet.GetItemState( nW, TRUE, &pItem))
//STRIP001 	{
//STRIP001 		FieldUnit eUnit = MapToFieldUnit( rSet.GetPool()->GetMetric( nW ));
//STRIP001 
//STRIP001 		SvxGrfCrop* pCrop =  (SvxGrfCrop*)pItem;
//STRIP001 
//STRIP001 		aExampleWN.SetLeft(		pCrop->GetLeft());
//STRIP001 		aExampleWN.SetRight(	pCrop->GetRight());
//STRIP001 		aExampleWN.SetTop(		pCrop->GetTop());
//STRIP001 		aExampleWN.SetBottom(	pCrop->GetBottom());
//STRIP001 
//STRIP001 		aLeftMF.SetValue( aLeftMF.Normalize( pCrop->GetLeft()), eUnit );
//STRIP001 		aRightMF.SetValue( aRightMF.Normalize( pCrop->GetRight()), eUnit );
//STRIP001 		aTopMF.SetValue( aTopMF.Normalize( pCrop->GetTop()), eUnit );
//STRIP001 		aBottomMF.SetValue( aBottomMF.Normalize( pCrop->GetBottom()), eUnit );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aLeftMF.SetValue( 0 );
//STRIP001 		aRightMF.SetValue( 0 );
//STRIP001 		aTopMF.SetValue( 0 );
//STRIP001 		aBottomMF.SetValue( 0 );
//STRIP001 	}
//STRIP001 
//STRIP001 	nW = rPool.GetWhich( SID_ATTR_PAGE_SIZE );
//STRIP001 	if ( SFX_ITEM_SET == rSet.GetItemState( nW, FALSE, &pItem ) )
//STRIP001 	{
//STRIP001 		// Orientation und Size aus dem PageItem
//STRIP001 		FieldUnit eUnit = MapToFieldUnit( rSet.GetPool()->GetMetric( nW ));
//STRIP001 
//STRIP001 		aPageSize = ((const SvxSizeItem*)pItem)->GetSize();
//STRIP001 
//STRIP001 		long nTmp = aHeightMF.Normalize(aPageSize.Height());
//STRIP001 		aHeightMF.SetMax( nTmp, eUnit );
//STRIP001 		nTmp = aWidthMF.Normalize(aPageSize.Width());
//STRIP001 		aWidthMF.SetMax( nTmp, eUnit );
//STRIP001 		nTmp = aWidthMF.Normalize( 23 );
//STRIP001 		aHeightMF.SetMin( nTmp, eUnit );
//STRIP001 		aWidthMF.SetMin( nTmp, eUnit );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aPageSize = OutputDevice::LogicToLogic(
//STRIP001 						Size( CM_1_TO_TWIP,  CM_1_TO_TWIP ),
//STRIP001 						MapMode( MAP_TWIP ),
//STRIP001 						MapMode( (MapUnit)rSet.GetPool()->GetMetric( nW ) ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bFound = FALSE;
//STRIP001 	if( SFX_ITEM_SET == rSet.GetItemState( SID_ATTR_GRAF_GRAPHIC, FALSE, &pItem ) )
//STRIP001 	{
//STRIP001 		const Graphic* pGrf = ((SvxBrushItem*)pItem)->GetGraphic();
//STRIP001 		if( pGrf )
//STRIP001 			aOrigSize = GetGrfOrigSize( *pGrf );
//STRIP001 
//STRIP001 		if( aOrigSize.Width() && aOrigSize.Height() )
//STRIP001 		{
//STRIP001 			CalcMinMaxBorder();
//STRIP001 			aExampleWN.SetGraphic( *pGrf );
//STRIP001 			aExampleWN.SetFrameSize( aOrigSize );
//STRIP001 
//STRIP001 			bFound = TRUE;
//STRIP001 			if( ((SvxBrushItem*)pItem)->GetGraphicLink() )
//STRIP001 				aGraphicName = *((SvxBrushItem*)pItem)->GetGraphicLink();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	GraphicHasChanged( bFound );
//STRIP001 	bReset = TRUE;
//STRIP001 	ActivatePage( rSet );
//STRIP001 	bReset = FALSE;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 BOOL SvxGrfCropPage::FillItemSet(SfxItemSet &rSet)
//STRIP001 {
//STRIP001 	const SfxItemPool& rPool = *rSet.GetPool();
//STRIP001 	BOOL bModified = FALSE;
//STRIP001 	if( aWidthMF.GetSavedValue() != aWidthMF.GetText() ||
//STRIP001 		aHeightMF.GetSavedValue() != aHeightMF.GetText() )
//STRIP001 	{
//STRIP001 		USHORT nW = rPool.GetWhich( SID_ATTR_GRAF_FRMSIZE );
//STRIP001 		FieldUnit eUnit = MapToFieldUnit( rSet.GetPool()->GetMetric( nW ));
//STRIP001 
//STRIP001 		SvxSizeItem aSz( nW );
//STRIP001 
//STRIP001 		// die Groesse koennte schon von einer anderen Page gesetzt worden sein
//STRIP001 		// #44204#
//STRIP001 		const SfxItemSet* pExSet = GetTabDialog() ? GetTabDialog()->GetExampleSet() : NULL;
//STRIP001 		const SfxPoolItem* pItem = 0;
//STRIP001 		if( pExSet && SFX_ITEM_SET ==
//STRIP001 				pExSet->GetItemState( nW, FALSE, &pItem ) )
//STRIP001 			aSz = *(const SvxSizeItem*)pItem;
//STRIP001 		else
//STRIP001 			aSz = (const SvxSizeItem&)GetItemSet().Get( nW );
//STRIP001 
//STRIP001 		Size aTmpSz( aSz.GetSize() );
//STRIP001 		if( aWidthMF.GetText() != aWidthMF.GetSavedValue() )
//STRIP001 			aTmpSz.Width() = lcl_GetValue( aWidthMF, eUnit );
//STRIP001 		if( aHeightMF.GetText() != aHeightMF.GetSavedValue() )
//STRIP001 			aTmpSz.Height() = lcl_GetValue( aHeightMF, eUnit );
//STRIP001 		aSz.SetSize( aTmpSz );
//STRIP001 		aWidthMF.SaveValue();
//STRIP001 		aHeightMF.SaveValue();
//STRIP001 
//STRIP001 		bModified |= 0 != rSet.Put( aSz );
//STRIP001 
//STRIP001 		if( bSetOrigSize )
//STRIP001 		{
//STRIP001 			bModified |= 0 != rSet.Put( SvxSizeItem( rPool.GetWhich(
//STRIP001 						SID_ATTR_GRAF_FRMSIZE_PERCENT ), Size( 0, 0 )) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if( aLeftMF.IsModified() || aRightMF.IsModified() ||
//STRIP001 		aTopMF.IsModified()  ||	aBottomMF.IsModified() )
//STRIP001 	{
//STRIP001 		USHORT nW = rPool.GetWhich( SID_ATTR_GRAF_CROP );
//STRIP001 		FieldUnit eUnit = MapToFieldUnit( rSet.GetPool()->GetMetric( nW ));
//STRIP001 		SvxGrfCrop* pNew = (SvxGrfCrop*)rSet.Get( nW ).Clone();
//STRIP001 
//STRIP001 		pNew->SetLeft( lcl_GetValue( aLeftMF, eUnit ) );
//STRIP001 		pNew->SetRight( lcl_GetValue( aRightMF, eUnit ) );
//STRIP001 		pNew->SetTop( lcl_GetValue( aTopMF, eUnit ) );
//STRIP001 		pNew->SetBottom( lcl_GetValue( aBottomMF, eUnit ) );
//STRIP001 		bModified |= 0 != rSet.Put( *pNew );
//STRIP001 		delete pNew;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( aZoomConstRB.GetSavedValue() != aZoomConstRB.IsChecked() )
//STRIP001 	{
//STRIP001 		bModified |= 0 != rSet.Put( SfxBoolItem( rPool.GetWhich(
//STRIP001 					SID_ATTR_GRAF_KEEP_ZOOM), aZoomConstRB.IsChecked() ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	bInitialized = FALSE;
//STRIP001 
//STRIP001 	return bModified;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 void SvxGrfCropPage::ActivatePage(const SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	SfxItemPool* pPool = GetItemSet().GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool" );
//STRIP001 	FieldUnit eUnit = MapToFieldUnit( pPool->GetMetric( pPool->GetWhich(
//STRIP001 													SID_ATTR_GRAF_CROP ) ) );
//STRIP001 
//STRIP001 	bSetOrigSize = FALSE;
//STRIP001 
//STRIP001 	// Size
//STRIP001 	Size aSize;
//STRIP001 	const SfxPoolItem* pItem;
//STRIP001 	if( SFX_ITEM_SET == rSet.GetItemState( SID_ATTR_GRAF_FRMSIZE, FALSE, &pItem ) )
//STRIP001 		aSize = ((const SvxSizeItem*)pItem)->GetSize();
//STRIP001 
//STRIP001 	nOldWidth = aSize.Width();
//STRIP001 	nOldHeight = aSize.Height();
//STRIP001 
//STRIP001 	long nWidth = aWidthMF.Normalize(nOldWidth);
//STRIP001 	long nHeight = aHeightMF.Normalize(nOldHeight);
//STRIP001 
//STRIP001 	if (nWidth != aWidthMF.GetValue(FUNIT_TWIP))
//STRIP001 	{
//STRIP001 		if(!bReset)
//STRIP001 		{
//STRIP001 			// Wert wurde von Umlauf-Tabpage geaendert und muss
//STRIP001 			// mit Modify-Flag gesetzt werden
//STRIP001 			aWidthMF.SetUserValue(nWidth, FUNIT_TWIP);
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aWidthMF.SetValue(nWidth, FUNIT_TWIP);
//STRIP001 	}
//STRIP001 	aWidthMF.SaveValue();
//STRIP001 
//STRIP001 	if (nHeight != aHeightMF.GetValue(FUNIT_TWIP))
//STRIP001 	{
//STRIP001 		if (!bReset)
//STRIP001 		{
//STRIP001 			// Wert wurde von Umlauf-Tabpage geaendert und muss
//STRIP001 			// mit Modify-Flag gesetzt werden
//STRIP001 			aHeightMF.SetUserValue(nHeight, FUNIT_TWIP);
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aHeightMF.SetValue(nHeight, FUNIT_TWIP);
//STRIP001 	}
//STRIP001 	aHeightMF.SaveValue();
//STRIP001 	bInitialized = TRUE;
//STRIP001 
//STRIP001 	if( SFX_ITEM_SET == rSet.GetItemState( SID_ATTR_GRAF_GRAPHIC, FALSE, &pItem ) )
//STRIP001 	{
//STRIP001 		const SvxBrushItem& rBrush = *(SvxBrushItem*)pItem;
//STRIP001 		if( rBrush.GetGraphicLink() &&
//STRIP001 			aGraphicName != *rBrush.GetGraphicLink() )
//STRIP001 			aGraphicName = *rBrush.GetGraphicLink();
//STRIP001 
//STRIP001 		const Graphic* pGrf = rBrush.GetGraphic();
//STRIP001 		if( pGrf )
//STRIP001 		{
//STRIP001 			aExampleWN.SetGraphic( *pGrf );
//STRIP001 			aOrigSize = GetGrfOrigSize( *pGrf );
//STRIP001 			aExampleWN.SetFrameSize(aOrigSize);
//STRIP001 			GraphicHasChanged( aOrigSize.Width() && aOrigSize.Height() );
//STRIP001 			CalcMinMaxBorder();
//STRIP001 		}
//STRIP001 		else
//STRIP001 			GraphicHasChanged( FALSE );
//STRIP001 	}
//STRIP001 
//STRIP001 	CalcZoom();
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 int SvxGrfCropPage::DeactivatePage(SfxItemSet *pSet)
//STRIP001 {
//STRIP001 	if ( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 	return TRUE;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung: Massstab geaendert, Groesse anpassen
 --------------------------------------------------------------------*/

//STRIP001 IMPL_LINK( SvxGrfCropPage, ZoomHdl, MetricField *, pField )
//STRIP001 {
//STRIP001 	SfxItemPool* pPool = GetItemSet().GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool" );
//STRIP001 	FieldUnit eUnit = MapToFieldUnit( pPool->GetMetric( pPool->GetWhich(
//STRIP001 													SID_ATTR_GRAF_CROP ) ) );
//STRIP001 
//STRIP001 	if( pField == &aWidthZoomMF )
//STRIP001 	{
//STRIP001 		long nLRBorders = lcl_GetValue(aLeftMF, eUnit)
//STRIP001 						 +lcl_GetValue(aRightMF, eUnit);
//STRIP001 		aWidthMF.SetValue( aWidthMF.Normalize(
//STRIP001 			((aOrigSize.Width() - nLRBorders) * pField->GetValue())/100L),
//STRIP001 			eUnit);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		long nULBorders = lcl_GetValue(aTopMF, eUnit)
//STRIP001 						 +lcl_GetValue(aBottomMF, eUnit);
//STRIP001 		aHeightMF.SetValue( aHeightMF.Normalize(
//STRIP001 			((aOrigSize.Height() - nULBorders ) * pField->GetValue())/100L) ,
//STRIP001 			eUnit );
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung: Groesse aendern, Massstab anpassen
 --------------------------------------------------------------------*/

//STRIP001 IMPL_LINK( SvxGrfCropPage, SizeHdl, MetricField *, pField )
//STRIP001 {
//STRIP001 	SfxItemPool* pPool = GetItemSet().GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool" );
//STRIP001 	FieldUnit eUnit = MapToFieldUnit( pPool->GetMetric( pPool->GetWhich(
//STRIP001 													SID_ATTR_GRAF_CROP ) ) );
//STRIP001 
//STRIP001 	Size aSize( lcl_GetValue(aWidthMF, eUnit),
//STRIP001 				lcl_GetValue(aHeightMF, eUnit) );
//STRIP001 
//STRIP001 	if(pField == &aWidthMF)
//STRIP001 	{
//STRIP001 		long nWidth = aOrigSize.Width() -
//STRIP001 				( lcl_GetValue(aLeftMF, eUnit) +
//STRIP001 				  lcl_GetValue(aRightMF, eUnit) );
//STRIP001 		if(!nWidth)
//STRIP001 			nWidth++;
//STRIP001 		USHORT nZoom = (USHORT)( aSize.Width() * 100L / nWidth);
//STRIP001 		aWidthZoomMF.SetValue(nZoom);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		long nHeight = aOrigSize.Height() -
//STRIP001 				( lcl_GetValue(aTopMF, eUnit) +
//STRIP001 				  lcl_GetValue(aBottomMF, eUnit));
//STRIP001 		if(!nHeight)
//STRIP001 			nHeight++;
//STRIP001 		USHORT nZoom = (USHORT)( aSize.Height() * 100L/ nHeight);
//STRIP001 		aHeightZoomMF.SetValue(nZoom);
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung: Raender auswerten
 --------------------------------------------------------------------*/

//STRIP001 IMPL_LINK( SvxGrfCropPage, CropHdl, const MetricField *, pField )
//STRIP001 {
//STRIP001 	SfxItemPool* pPool = GetItemSet().GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool" );
//STRIP001 	FieldUnit eUnit = MapToFieldUnit( pPool->GetMetric( pPool->GetWhich(
//STRIP001 													SID_ATTR_GRAF_CROP ) ) );
//STRIP001 
//STRIP001 	BOOL bZoom = aZoomConstRB.IsChecked();
//STRIP001 	if( pField == &aLeftMF || pField == &aRightMF )
//STRIP001 	{
//STRIP001 		long nLeft = lcl_GetValue( aLeftMF, eUnit );
//STRIP001 		long nRight = lcl_GetValue( aRightMF, eUnit );
//STRIP001 		long nWidthZoom = aWidthZoomMF.GetValue();
//STRIP001 		if(bZoom && ( ( ( aOrigSize.Width() - (nLeft + nRight )) * nWidthZoom )
//STRIP001 							/ 100 >= aPageSize.Width() ) )
//STRIP001 		{
//STRIP001 			if(pField == &aLeftMF)
//STRIP001 			{
//STRIP001 //				nLeft = aPageSize.Width() -
//STRIP001 //					((nRight + aOrigSize.Width()) * nWidthZoom) / 100;
//STRIP001 				nLeft = aOrigSize.Width() -
//STRIP001 							( aPageSize.Width() * 100 / nWidthZoom + nRight );
//STRIP001 				aLeftMF.SetValue( aLeftMF.Normalize( nLeft ), eUnit );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 //				nRight = aPageSize.Width() -
//STRIP001 //					((nLeft - aOrigSize.Width()) * nWidthZoom) / 100;
//STRIP001 				nRight = aOrigSize.Width() -
//STRIP001 							( aPageSize.Width() * 100 / nWidthZoom + nLeft );
//STRIP001 				aRightMF.SetValue( aRightMF.Normalize( nRight ), eUnit );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		aExampleWN.SetLeft(nLeft);
//STRIP001 		aExampleWN.SetRight(nRight);
//STRIP001 		if(bZoom)
//STRIP001 		{
//STRIP001 			//Massstab bleibt -> Breite neu berechnen
//STRIP001 			ZoomHdl(&aWidthZoomMF);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		long nTop = lcl_GetValue( aTopMF, eUnit );
//STRIP001 		long nBottom = lcl_GetValue( aBottomMF, eUnit );
//STRIP001 		long nHeightZoom = aHeightZoomMF.GetValue();
//STRIP001 		if(bZoom && ( ( ( aOrigSize.Height() - (nTop + nBottom )) * nHeightZoom)
//STRIP001 											/ 100 >= aPageSize.Height()))
//STRIP001 		{
//STRIP001 			if(pField == &aTopMF)
//STRIP001 			{
//STRIP001 //				nTop = aPageSize.Height() -
//STRIP001 //					((aOrigSize.Height() - nBottom) * nHeightZoom)/ 100;
//STRIP001 				nTop = aOrigSize.Height() -
//STRIP001 							( aPageSize.Height() * 100 / nHeightZoom + nBottom);
//STRIP001 				aTopMF.SetValue( aWidthMF.Normalize( nTop ), eUnit );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 //				nBottom = aPageSize.Height() -
//STRIP001 //					((aOrigSize.Height() - nTop)*nHeightZoom) / 100;
//STRIP001 				nBottom = aOrigSize.Height() -
//STRIP001 							( aPageSize.Height() * 100 / nHeightZoom + nTop);
//STRIP001 				aBottomMF.SetValue( aWidthMF.Normalize( nBottom ), eUnit );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		aExampleWN.SetTop( nTop );
//STRIP001 		aExampleWN.SetBottom( nBottom );
//STRIP001 		if(bZoom)
//STRIP001 		{
//STRIP001 			//Massstab bleibt -> Hoehe neu berechnen
//STRIP001 			ZoomHdl(&aHeightZoomMF);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	aExampleWN.Invalidate();
//STRIP001 	//Groesse und Raender veraendert -> Massstab neu berechnen
//STRIP001 	if(!bZoom)
//STRIP001 		CalcZoom();
//STRIP001 	CalcMinMaxBorder();
//STRIP001 	return 0;
//STRIP001 }
/*--------------------------------------------------------------------
	Beschreibung: Originalgroesse einstellen
 --------------------------------------------------------------------*/

//STRIP001 IMPL_LINK( SvxGrfCropPage, OrigSizeHdl, PushButton *, EMPTYARG )
//STRIP001 {
//STRIP001 	SfxItemPool* pPool = GetItemSet().GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool" );
//STRIP001 	FieldUnit eUnit = MapToFieldUnit( pPool->GetMetric( pPool->GetWhich(
//STRIP001 													SID_ATTR_GRAF_CROP ) ) );
//STRIP001 
//STRIP001 	long nWidth = aOrigSize.Width() -
//STRIP001 		lcl_GetValue( aLeftMF, eUnit ) -
//STRIP001 		lcl_GetValue( aRightMF, eUnit );
//STRIP001 	aWidthMF.SetValue( aWidthMF.Normalize( nWidth ), eUnit );
//STRIP001 	long nHeight = aOrigSize.Height() -
//STRIP001 		lcl_GetValue( aTopMF, eUnit ) -
//STRIP001 		lcl_GetValue( aBottomMF, eUnit );
//STRIP001 	aHeightMF.SetValue( aHeightMF.Normalize( nHeight ), eUnit );
//STRIP001 	aWidthZoomMF.SetValue(100);
//STRIP001 	aHeightZoomMF.SetValue(100);
//STRIP001 	bSetOrigSize = TRUE;
//STRIP001 	return 0;
//STRIP001 }
/*--------------------------------------------------------------------
	Beschreibung: Massstab berechnen
 --------------------------------------------------------------------*/

//STRIP001 void SvxGrfCropPage::CalcZoom()
//STRIP001 {
//STRIP001 	SfxItemPool* pPool = GetItemSet().GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool" );
//STRIP001 	FieldUnit eUnit = MapToFieldUnit( pPool->GetMetric( pPool->GetWhich(
//STRIP001 													SID_ATTR_GRAF_CROP ) ) );
//STRIP001 
//STRIP001 	long nWidth = lcl_GetValue( aWidthMF, eUnit );
//STRIP001 	long nHeight = lcl_GetValue( aHeightMF, eUnit );
//STRIP001 	long nLRBorders = lcl_GetValue( aLeftMF, eUnit ) +
//STRIP001 					  lcl_GetValue( aRightMF, eUnit );
//STRIP001 	long nULBorders = lcl_GetValue( aTopMF, eUnit ) +
//STRIP001 					  lcl_GetValue( aBottomMF, eUnit );
//STRIP001 	USHORT nZoom = 0;
//STRIP001 	long nDen;
//STRIP001 	if( (nDen = aOrigSize.Width() - nLRBorders) > 0)
//STRIP001 		nZoom = (USHORT)((( nWidth  * 1000L / nDen )+5)/10);
//STRIP001 	aWidthZoomMF.SetValue(nZoom);
//STRIP001 	if( (nDen = aOrigSize.Height() - nULBorders) > 0)
//STRIP001 		nZoom = (USHORT)((( nHeight * 1000L / nDen )+5)/10);
//STRIP001 	else
//STRIP001 		nZoom = 0;
//STRIP001 	aHeightZoomMF.SetValue(nZoom);
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung: Minimal-/Maximalwerte fuer die Raender setzen
 --------------------------------------------------------------------*/

//STRIP001 void SvxGrfCropPage::CalcMinMaxBorder()
//STRIP001 {
//STRIP001 	SfxItemPool* pPool = GetItemSet().GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool" );
//STRIP001 	FieldUnit eUnit = MapToFieldUnit( pPool->GetMetric( pPool->GetWhich(
//STRIP001 													SID_ATTR_GRAF_CROP ) ) );
//STRIP001 	long nR = lcl_GetValue(aRightMF, eUnit );
//STRIP001 	long nMinWidth = (aOrigSize.Width() * 10) /11;
//STRIP001 	long nMin = nMinWidth - (nR >= 0 ? nR : 0);
//STRIP001 	aLeftMF.SetMax( aLeftMF.Normalize(nMin), eUnit );
//STRIP001 
//STRIP001 	long nL = lcl_GetValue(aLeftMF, eUnit );
//STRIP001 	nMin = nMinWidth - (nL >= 0 ? nL : 0);
//STRIP001 	aRightMF.SetMax( aRightMF.Normalize(nMin), eUnit );
//STRIP001 
//STRIP001 	// Zoom nicht unter 2%
//STRIP001 /*	nMin = (aOrigSize.Width() * 102) /100;
//STRIP001 	aLeftMF.SetMax(aPageSize.Width() - nR - nMin);
//STRIP001 	aRightMF.SetMax(aPageSize.Width() - nL - nMin);
//STRIP001 */
//STRIP001 	long nUp  = lcl_GetValue( aTopMF, eUnit );
//STRIP001 	long nMinHeight = (aOrigSize.Height() * 10) /11;
//STRIP001 	nMin = nMinHeight - (nUp >= 0 ? nUp : 0);
//STRIP001 	aBottomMF.SetMax( aBottomMF.Normalize(nMin), eUnit );
//STRIP001 
//STRIP001 	long nLow = lcl_GetValue(aBottomMF, eUnit );
//STRIP001 	nMin = nMinHeight - (nLow >= 0 ? nLow : 0);
//STRIP001 	aTopMF.SetMax( aTopMF.Normalize(nMin), eUnit );
//STRIP001 
//STRIP001 	// Zoom nicht unter 2%
//STRIP001 /*	nMin = (aOrigSize.Height() * 102) /100;
//STRIP001 	aTopMF.SetMax(aPageSize.Height() - nLow - nMin);
//STRIP001 	aBottomMF.SetMax(aPageSize.Height() - nUp - nMin);*/
//STRIP001 }
/*--------------------------------------------------------------------
	Beschreibung: 	Spinsize auf 1/20 der Originalgroesse setzen,
					FixedText mit der Originalgroesse fuellen
 --------------------------------------------------------------------*/

//STRIP001 void SvxGrfCropPage::GraphicHasChanged( BOOL bFound )
//STRIP001 {
//STRIP001 	if( bFound )
//STRIP001 	{
//STRIP001 		SfxItemPool* pPool = GetItemSet().GetPool();
//STRIP001 		DBG_ASSERT( pPool, "Wo ist der Pool" );
//STRIP001 		FieldUnit eUnit = MapToFieldUnit( pPool->GetMetric( pPool->GetWhich(
//STRIP001 													SID_ATTR_GRAF_CROP ) ));
//STRIP001 
//STRIP001 		long nSpin = aLeftMF.Normalize(aOrigSize.Width()) / 20;
//STRIP001 		nSpin = MetricField::ConvertValue( nSpin, aOrigSize.Width(), 0,
//STRIP001 									   		eUnit, aLeftMF.GetUnit());
//STRIP001 
//STRIP001 		// Ist der Rand zu gross, wird er auf beiden Seiten auf 1/3 eingestellt.
//STRIP001 		long nR = lcl_GetValue( aRightMF, eUnit );
//STRIP001 		long nL = lcl_GetValue( aLeftMF, eUnit );
//STRIP001 		if((nL + nR) < - aOrigSize.Width())
//STRIP001 		{
//STRIP001 			long nVal = aOrigSize.Width() / -3;
//STRIP001 			aRightMF.SetValue( aRightMF.Normalize( nVal ), eUnit );
//STRIP001 			aLeftMF.SetValue( aLeftMF.Normalize( nVal ), eUnit );
//STRIP001 			aExampleWN.SetLeft(nVal);
//STRIP001 			aExampleWN.SetRight(nVal);
//STRIP001 		}
//STRIP001 		long nUp  = lcl_GetValue(aTopMF, eUnit );
//STRIP001 		long nLow = lcl_GetValue(aBottomMF, eUnit );
//STRIP001 		if((nUp + nLow) < - aOrigSize.Height())
//STRIP001 		{
//STRIP001 			long nVal = aOrigSize.Height() / -3;
//STRIP001 			aTopMF.SetValue( aTopMF.Normalize( nVal ), eUnit );
//STRIP001 			aBottomMF.SetValue( aBottomMF.Normalize( nVal ), eUnit );
//STRIP001 			aExampleWN.SetTop(nVal);
//STRIP001 			aExampleWN.SetBottom(nVal);
//STRIP001 		}
//STRIP001 
//STRIP001 		aLeftMF.SetSpinSize(nSpin);
//STRIP001 		aRightMF.SetSpinSize(nSpin);
//STRIP001 		nSpin = aTopMF.Normalize(aOrigSize.Height()) / 20;
//STRIP001 		nSpin = MetricField::ConvertValue( nSpin, aOrigSize.Width(), 0,
//STRIP001 									   		eUnit, aLeftMF.GetUnit() );
//STRIP001 		aTopMF.SetSpinSize(nSpin);
//STRIP001 		aBottomMF.SetSpinSize(nSpin);
//STRIP001 
//STRIP001 		//Originalgroesse anzeigen
//STRIP001 		const FieldUnit eMetric = GetModuleFieldUnit( &GetItemSet() );
//STRIP001 
//STRIP001 		MetricField aFld(this, WB_HIDE);
//STRIP001 		SetFieldUnit( aFld, eMetric );
//STRIP001 		aFld.SetDecimalDigits( aWidthMF.GetDecimalDigits() );
//STRIP001 		aFld.SetMax( LONG_MAX - 1 );
//STRIP001 
//STRIP001 		aFld.SetValue( aFld.Normalize( aOrigSize.Width() ), eUnit );
//STRIP001 		String sTemp = aFld.GetText();
//STRIP001 		aFld.SetValue( aFld.Normalize( aOrigSize.Height() ), eUnit );
//STRIP001 		sTemp += UniString::CreateFromAscii(" x ");
//STRIP001 		sTemp += aFld.GetText();
//STRIP001 		aOrigSizeFT.SetText(sTemp);
//STRIP001 	}
//STRIP001 	aLeftFT			.Enable(bFound);
//STRIP001 	aLeftMF         .Enable(bFound);
//STRIP001 	aRightFT        .Enable(bFound);
//STRIP001 	aRightMF        .Enable(bFound);
//STRIP001 	aTopFT          .Enable(bFound);
//STRIP001 	aTopMF          .Enable(bFound);
//STRIP001 	aBottomFT       .Enable(bFound);
//STRIP001 	aBottomMF       .Enable(bFound);
//STRIP001 	aSizeConstRB    .Enable(bFound);
//STRIP001 	aZoomConstRB    .Enable(bFound);
//STRIP001 	aWidthFT        .Enable(bFound);
//STRIP001 	aWidthMF        .Enable(bFound);
//STRIP001 	aHeightFT       .Enable(bFound);
//STRIP001 	aHeightMF		.Enable(bFound);
//STRIP001 	aWidthZoomFT    .Enable(bFound);
//STRIP001 	aWidthZoomMF    .Enable(bFound);
//STRIP001 	aHeightZoomFT   .Enable(bFound);
//STRIP001 	aHeightZoomMF   .Enable(bFound);
//STRIP001 	aExampleWN      .Enable(bFound);
//STRIP001 	aOrigSizePB     .Enable(bFound);
//STRIP001 	aOrigSizeFT     .Enable(bFound);
//STRIP001 }

//STRIP001 IMPL_LINK( SvxGrfCropPage, Timeout, Timer *, EMPTYARG )
//STRIP001 {
//STRIP001 	DBG_ASSERT(pLastCropField,"Timeout ohne Feld?")
//STRIP001 	CropHdl(pLastCropField);
//STRIP001 	pLastCropField = 0;
//STRIP001 	return 0;
//STRIP001 }


//STRIP001 IMPL_LINK( SvxGrfCropPage, CropLoseFocusHdl, MetricField*, pField )
//STRIP001 {
//STRIP001 	aTimer.Stop();
//STRIP001 	CropHdl(pField);
//STRIP001 	pLastCropField = 0;
//STRIP001 	return 0;
//STRIP001 }


//STRIP001 IMPL_LINK( SvxGrfCropPage, CropModifyHdl, MetricField *, pField )
//STRIP001 {
//STRIP001 	aTimer.Start();
//STRIP001 	pLastCropField = pField;
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 Size SvxGrfCropPage::GetGrfOrigSize( const Graphic& rGrf ) const
//STRIP001 {
//STRIP001     const MapMode aMapTwip( MAP_TWIP );
//STRIP001     Size aSize( rGrf.GetPrefSize() );
//STRIP001     if( MAP_PIXEL == rGrf.GetPrefMapMode().GetMapUnit() )
//STRIP001         aSize = PixelToLogic( aSize, aMapTwip );
//STRIP001     else
//STRIP001         aSize = OutputDevice::LogicToLogic( aSize,
//STRIP001 										rGrf.GetPrefMapMode(), aMapTwip );
//STRIP001 	return aSize;
//STRIP001 }

/*****************************************************************/

//STRIP001 SvxGrfCropPage::SvxCropExample::SvxCropExample( Window* pPar,
//STRIP001 												const ResId& rResId )
//STRIP001 	: Window( pPar, rResId ),
//STRIP001 	aTopLeft(0,0), aBottomRight(0,0),
//STRIP001     aFrameSize( OutputDevice::LogicToLogic(
//STRIP001 							Size( CM_1_TO_TWIP / 2, CM_1_TO_TWIP / 2 ),
//STRIP001 							MapMode( MAP_TWIP ), GetMapMode() ))
//STRIP001 
//STRIP001 {
//STRIP001     SetBorderStyle( WINDOW_BORDER_MONO );
//STRIP001 }

//STRIP001 void SvxGrfCropPage::SvxCropExample::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	Size aWinSize( PixelToLogic(GetOutputSizePixel() ));
//STRIP001     SetLineColor();
//STRIP001 	SetFillColor( GetSettings().GetStyleSettings().GetWindowColor() );
//STRIP001 	SetRasterOp( ROP_OVERPAINT );
//STRIP001     DrawRect( Rectangle( Point(), aWinSize ) );
//STRIP001 
//STRIP001     SetLineColor( Color( COL_WHITE ) );
//STRIP001 	Rectangle aRect(Point((aWinSize.Width() - aFrameSize.Width())/2,
//STRIP001 						  (aWinSize.Height() - aFrameSize.Height())/2),
//STRIP001 						  aFrameSize );
//STRIP001 	aGrf.Draw( this,  aRect.TopLeft(), aRect.GetSize() );
//STRIP001 
//STRIP001 	Size aSz( 2, 0 );
//STRIP001 	aSz = PixelToLogic( aSz );
//STRIP001 	SetFillColor( Color( COL_TRANSPARENT ) );
//STRIP001 	SetRasterOp( ROP_INVERT );
//STRIP001 	aRect.Left() 	+= aTopLeft.Y();
//STRIP001 	aRect.Top() 	+= aTopLeft.X();
//STRIP001 	aRect.Right() 	-= aBottomRight.Y();
//STRIP001 	aRect.Bottom() 	-= aBottomRight.X();
//STRIP001 	DrawRect( aRect );
//STRIP001 }

//STRIP001 void SvxGrfCropPage::SvxCropExample::SetFrameSize( const Size& rSz )
//STRIP001 {
//STRIP001 	aFrameSize = rSz;
//STRIP001 	if(!aFrameSize.Width())
//STRIP001 		aFrameSize.Width() = 1;
//STRIP001 	if(!aFrameSize.Height())
//STRIP001 		aFrameSize.Height() = 1;
//STRIP001 	Size aWinSize( GetOutputSizePixel() );
//STRIP001 	Fraction aXScale( aWinSize.Width() * 4, aFrameSize.Width() * 5 );
//STRIP001 	Fraction aYScale( aWinSize.Height() * 4, aFrameSize.Height() * 5 );
//STRIP001 
//STRIP001 	if( aYScale < aXScale )
//STRIP001 		aXScale = aYScale;
//STRIP001 
//STRIP001 	MapMode aMapMode( GetMapMode() );
//STRIP001 
//STRIP001 	aMapMode.SetScaleX( aXScale );
//STRIP001 	aMapMode.SetScaleY( aXScale );
//STRIP001 
//STRIP001 	SetMapMode( aMapMode );
//STRIP001 	Invalidate();
//STRIP001 }




}
