/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_helper.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:35:40 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "helper.hxx"

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XRESULTSET_HPP_
#include <com/sun/star/sdbc/XResultSet.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XROW_HPP_
#include <com/sun/star/sdbc/XRow.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_COMMANDABORTEDEXCEPTION_HPP_
#include <com/sun/star/ucb/CommandAbortedException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_ILLEGALIDENTIFIEREXCEPTION_HPP_
#include <com/sun/star/ucb/IllegalIdentifierException.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_NAMECLASH_HPP_
#include <com/sun/star/ucb/NameClash.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_NUMBEREDSORTINGINFO_HPP_
#include <com/sun/star/ucb/NumberedSortingInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_TRANSFERINFO_HPP_
#include <com/sun/star/ucb/TransferInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XANYCOMPAREFACTORY_HPP_
#include <com/sun/star/ucb/XAnyCompareFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCOMMANDINFO_HPP_
#include <com/sun/star/ucb/XCommandInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTACCESS_HPP_
#include <com/sun/star/ucb/XContentAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XDYNAMICRESULTSET_HPP_
#include <com/sun/star/ucb/XDynamicResultSet.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XSORTEDDYNAMICRESULTSETFACTORY_HPP_
#include <com/sun/star/ucb/XSortedDynamicResultSetFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_DATETIME_HPP_
#include <com/sun/star/util/DateTime.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif
#ifndef _UNOTOOLS_LOCALEDATAWRAPPER_HXX
#include <unotools/localedatawrapper.hxx>
#endif
#ifndef _RTL_STRBUF_HXX_
#include <rtl/strbuf.hxx>
#endif

#include <tools/ref.hxx>
#include <tools/debug.hxx>
#include <tools/urlobj.hxx>
#include <tools/datetime.hxx>
#include <vcl/svapp.hxx>
#include <ucbhelper/content.hxx>
#include <ucbhelper/commandenvironment.hxx>
#include <comphelper/processfactory.hxx>
#include <osl/file.hxx>

#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
namespace binfilter {

using namespace ::ucb;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::ucb;
using namespace ::com::sun::star::task;
using namespace rtl;
using namespace comphelper;
using namespace osl;

DECLARE_LIST( StringList_Impl, OUString* )//STRIP008 ;

#define CONVERT_DATETIME( aUnoDT, aToolsDT ) \
	aToolsDT = DateTime( Date( aUnoDT.Day, aUnoDT.Month, aUnoDT.Year ), \
						 Time( aUnoDT.Hours, aUnoDT.Minutes, aUnoDT.Seconds, aUnoDT.HundredthSeconds ) );

//STRIP001 void AppendDateTime_Impl( const ::com::sun::star::util::DateTime rDT,
//STRIP001 						  String& rRow, const LocaleDataWrapper& rWrapper )
//STRIP001 {
//STRIP001 	DateTime aDT;
//STRIP001 	CONVERT_DATETIME( rDT, aDT );
//STRIP001 	String aDateStr = rWrapper.getDate( aDT );
//STRIP001 	aDateStr += String::CreateFromAscii( ", " );
//STRIP001 	aDateStr += rWrapper.getTime( aDT );
//STRIP001 	rRow += aDateStr;
//STRIP001 }

// SfxContentHelper ------------------------------------------------------

//STRIP001 sal_Bool SfxContentHelper::Transfer_Impl( const String& rSource, const String& rDest, sal_Bool bMoveData, sal_Int32 nNameClash )
//STRIP001 {
//STRIP001 	sal_Bool bRet = sal_True, bKillSource = sal_False;
//STRIP001     INetURLObject aSourceObj( rSource );
//STRIP001     DBG_ASSERT( aSourceObj.GetProtocol() != INET_PROT_NOT_VALID, "Invalid URL!" );
//STRIP001 
//STRIP001     INetURLObject aDestObj( rDest );
//STRIP001     DBG_ASSERT( aDestObj.GetProtocol() != INET_PROT_NOT_VALID, "Invalid URL!" );
//STRIP001 	if ( bMoveData && aSourceObj.GetProtocol() != aDestObj.GetProtocol() )
//STRIP001 	{
//STRIP001 		bMoveData = sal_False;
//STRIP001 		bKillSource = sal_True;
//STRIP001 	}
//STRIP001 	String aName = aDestObj.getName();
//STRIP001 	aDestObj.removeSegment();
//STRIP001 	aDestObj.setFinalSlash();
//STRIP001 
//STRIP001 	try
//STRIP001 	{
//STRIP001 		Content aDestPath( aDestObj.GetMainURL( INetURLObject::NO_DECODE ), Reference< ::com::sun::star::ucb::XCommandEnvironment > () );
//STRIP001 		Reference< ::com::sun::star::ucb::XCommandInfo > xInfo = aDestPath.getCommands();
//STRIP001 		OUString aTransferName = OUString::createFromAscii( "transfer" );
//STRIP001 		if ( xInfo->hasCommandByName( aTransferName ) )
//STRIP001 		{
//STRIP001 			aDestPath.executeCommand( aTransferName, makeAny(
//STRIP001                 ::com::sun::star::ucb::TransferInfo( bMoveData, aSourceObj.GetMainURL( INetURLObject::NO_DECODE ), aName, nNameClash ) ) );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			DBG_ERRORFILE( "transfer command not available" );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	catch( ::com::sun::star::ucb::CommandAbortedException& )
//STRIP001 	{
//STRIP001 		bRet = sal_False;
//STRIP001 	}
//STRIP001 	catch( ::com::sun::star::uno::Exception& )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "Any other exception" );
//STRIP001 		bRet = sal_False;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bKillSource )
//STRIP001 		SfxContentHelper::Kill( rSource );
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 sal_Bool SfxContentHelper::IsDocument( const String& rContent )
//STRIP001 {
//STRIP001 	sal_Bool bRet = sal_False;
//STRIP001     INetURLObject aObj( rContent );
//STRIP001     DBG_ASSERT( aObj.GetProtocol() != INET_PROT_NOT_VALID, "Invalid URL!" );
//STRIP001 
//STRIP001 	try
//STRIP001 	{
//STRIP001 		Content aCnt( aObj.GetMainURL( INetURLObject::NO_DECODE ), Reference< ::com::sun::star::ucb::XCommandEnvironment > () );
//STRIP001 		bRet = aCnt.isDocument();
//STRIP001 	}
//STRIP001 	catch( ::com::sun::star::ucb::CommandAbortedException& )
//STRIP001 	{
//STRIP001         DBG_WARNING( "CommandAbortedException" );
//STRIP001 	}
//STRIP001     catch( ::com::sun::star::ucb::IllegalIdentifierException& )
//STRIP001 	{
//STRIP001         DBG_WARNING( "IllegalIdentifierException" );
//STRIP001 	}
//STRIP001     catch( ContentCreationException& )
//STRIP001 	{
//STRIP001         DBG_WARNING( "IllegalIdentifierException" );
//STRIP001 	}
//STRIP001     catch( ::com::sun::star::uno::Exception& )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "Any other exception" );
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 sal_Bool SfxContentHelper::IsFolder( const String& rContent )
//STRIP001 {
//STRIP001 	sal_Bool bRet = sal_False;
//STRIP001     INetURLObject aObj( rContent );
//STRIP001     DBG_ASSERT( aObj.GetProtocol() != INET_PROT_NOT_VALID, "Invalid URL!" );
//STRIP001 	try
//STRIP001 	{
//STRIP001 		Content aCnt( aObj.GetMainURL( INetURLObject::NO_DECODE ), Reference< ::com::sun::star::ucb::XCommandEnvironment > () );
//STRIP001 		bRet = aCnt.isFolder();
//STRIP001 	}
//STRIP001 	catch( ::com::sun::star::ucb::CommandAbortedException& )
//STRIP001 	{
//STRIP001         DBG_WARNING( "CommandAbortedException" );
//STRIP001 	}
//STRIP001     catch( ::com::sun::star::ucb::IllegalIdentifierException& )
//STRIP001 	{
//STRIP001         DBG_WARNING( "IllegalIdentifierException" );
//STRIP001 	}
//STRIP001     catch( ContentCreationException& )
//STRIP001 	{
//STRIP001         DBG_WARNING( "IllegalIdentifierException" );
//STRIP001 	}
//STRIP001 	catch( ::com::sun::star::uno::Exception& )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "Any other exception" );
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 sal_Bool SfxContentHelper::GetTitle( const String& rContent, String& rTitle )
//STRIP001 {
//STRIP001 	sal_Bool bRet = sal_False;
//STRIP001     INetURLObject aObj( rContent );
//STRIP001     DBG_ASSERT( aObj.GetProtocol() != INET_PROT_NOT_VALID, "Invalid URL!" );
//STRIP001 	try
//STRIP001 	{
//STRIP001 		Content aCnt( aObj.GetMainURL( INetURLObject::NO_DECODE ), Reference< ::com::sun::star::ucb::XCommandEnvironment > () );
//STRIP001 		OUString aTemp;
//STRIP001 		aCnt.getPropertyValue( OUString::createFromAscii( "Title" ) ) >>= aTemp;
//STRIP001 		rTitle = String( aTemp );
//STRIP001 		bRet = sal_True;
//STRIP001 	}
//STRIP001 	catch( ::com::sun::star::ucb::CommandAbortedException& )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "CommandAbortedException" );
//STRIP001 	}
//STRIP001 	catch( ::com::sun::star::uno::Exception& )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "Any other exception" );
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 sal_Bool SfxContentHelper::Kill( const String& rContent )
//STRIP001 {
//STRIP001 	sal_Bool bRet = sal_True;
//STRIP001     INetURLObject aDeleteObj( rContent );
//STRIP001     DBG_ASSERT( aDeleteObj.GetProtocol() != INET_PROT_NOT_VALID, "Invalid URL!" );
//STRIP001 
//STRIP001 	try
//STRIP001 	{
//STRIP001 		Content aCnt( aDeleteObj.GetMainURL( INetURLObject::NO_DECODE ), Reference< ::com::sun::star::ucb::XCommandEnvironment > () );
//STRIP001 		aCnt.executeCommand( OUString::createFromAscii( "delete" ), makeAny( sal_Bool( sal_True ) ) );
//STRIP001 	}
//STRIP001 	catch( ::com::sun::star::ucb::CommandAbortedException& )
//STRIP001 	{
//STRIP001         DBG_WARNING( "CommandAbortedException" );
//STRIP001 		bRet = sal_False;
//STRIP001 	}
//STRIP001 	catch( ::com::sun::star::uno::Exception& )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "Any other exception" );
//STRIP001 		bRet = sal_False;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 Sequence < OUString > SfxContentHelper::GetFolderContents( const String& rFolder, sal_Bool bFolder, sal_Bool bSorted )
//STRIP001 {
//STRIP001 	StringList_Impl* pFiles = NULL;
//STRIP001     INetURLObject aFolderObj( rFolder );
//STRIP001     DBG_ASSERT( aFolderObj.GetProtocol() != INET_PROT_NOT_VALID, "Invalid URL!" );
//STRIP001 	try
//STRIP001 	{
//STRIP001 		Content aCnt( aFolderObj.GetMainURL( INetURLObject::NO_DECODE ), Reference< ::com::sun::star::ucb::XCommandEnvironment > () );
//STRIP001 		Reference< XResultSet > xResultSet;
//STRIP001         Sequence< OUString > aProps(2);
//STRIP001 		OUString* pProps = aProps.getArray();
//STRIP001         pProps[0] = OUString::createFromAscii( "Title" );
//STRIP001         pProps[1] = OUString::createFromAscii( "IsFolder" );
//STRIP001 
//STRIP001 		try
//STRIP001 		{
//STRIP001 			ResultSetInclude eInclude =	bFolder ? INCLUDE_FOLDERS_AND_DOCUMENTS : INCLUDE_DOCUMENTS_ONLY;
//STRIP001             if ( !bSorted )
//STRIP001             {
//STRIP001                 xResultSet = aCnt.createCursor( aProps, eInclude );
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 Reference< ::com::sun::star::ucb::XDynamicResultSet > xDynResultSet;
//STRIP001                 xDynResultSet = aCnt.createDynamicCursor( aProps, eInclude );
//STRIP001 
//STRIP001                 Reference < ::com::sun::star::ucb::XAnyCompareFactory > xFactory;
//STRIP001                 Reference < XMultiServiceFactory > xMgr = ::legacy_binfilters::getLegacyProcessServiceFactory();
//STRIP001                 Reference < ::com::sun::star::ucb::XSortedDynamicResultSetFactory > xSRSFac(
//STRIP001                     xMgr->createInstance( ::rtl::OUString::createFromAscii("com.sun.star.ucb.SortedDynamicResultSetFactory") ), UNO_QUERY );
//STRIP001 
//STRIP001                 Sequence< ::com::sun::star::ucb::NumberedSortingInfo > aSortInfo( 2 );
//STRIP001                 ::com::sun::star::ucb::NumberedSortingInfo* pInfo = aSortInfo.getArray();
//STRIP001                 pInfo[ 0 ].ColumnIndex = 2;
//STRIP001                 pInfo[ 0 ].Ascending   = sal_False;
//STRIP001                 pInfo[ 1 ].ColumnIndex = 1;
//STRIP001                 pInfo[ 1 ].Ascending   = sal_True;
//STRIP001 
//STRIP001                 Reference< ::com::sun::star::ucb::XDynamicResultSet > xDynamicResultSet;
//STRIP001                 xDynamicResultSet =
//STRIP001                     xSRSFac->createSortedDynamicResultSet( xDynResultSet, aSortInfo, xFactory );
//STRIP001                 if ( xDynamicResultSet.is() )
//STRIP001                 {
//STRIP001                     sal_Int16 nCaps = xDynamicResultSet->getCapabilities();
//STRIP001                     xResultSet = xDynamicResultSet->getStaticResultSet();
//STRIP001                 }
//STRIP001             }
//STRIP001 		}
//STRIP001 		catch( ::com::sun::star::ucb::CommandAbortedException& )
//STRIP001 		{
//STRIP001 			DBG_ERRORFILE( "createCursor: CommandAbortedException" );
//STRIP001 		}
//STRIP001 		catch( ::com::sun::star::uno::Exception& )
//STRIP001 		{
//STRIP001 			DBG_ERRORFILE( "createCursor: Any other exception" );
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( xResultSet.is() )
//STRIP001 		{
//STRIP001 			pFiles = new StringList_Impl;
//STRIP001 			Reference< ::com::sun::star::ucb::XContentAccess > xContentAccess( xResultSet, UNO_QUERY );
//STRIP001 			try
//STRIP001 			{
//STRIP001 				while ( xResultSet->next() )
//STRIP001 				{
//STRIP001 					OUString aId = xContentAccess->queryContentIdentifierString();
//STRIP001 					OUString* pFile = new OUString( aId );
//STRIP001 					pFiles->Insert( pFile, LIST_APPEND );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			catch( ::com::sun::star::ucb::CommandAbortedException& )
//STRIP001 			{
//STRIP001 				DBG_ERRORFILE( "XContentAccess::next(): CommandAbortedException" );
//STRIP001 			}
//STRIP001 			catch( ::com::sun::star::uno::Exception& )
//STRIP001 			{
//STRIP001 				DBG_ERRORFILE( "XContentAccess::next(): Any other exception" );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	catch( ::com::sun::star::uno::Exception& )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "GetFolderContents: Any other exception" );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pFiles )
//STRIP001 	{
//STRIP001         ULONG nCount = pFiles->Count();
//STRIP001 		Sequence < OUString > aRet( nCount );
//STRIP001 		OUString* pRet = aRet.getArray();
//STRIP001 		for ( ULONG i = 0; i < nCount; ++i )
//STRIP001 		{
//STRIP001 			OUString* pFile = pFiles->GetObject(i);
//STRIP001 			pRet[i] = *( pFile );
//STRIP001 			delete pFile;
//STRIP001 		}
//STRIP001 		delete pFiles;
//STRIP001 		return aRet;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return Sequence < OUString > ();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 Sequence < OUString > SfxContentHelper::GetFolderContentProperties( const String& rFolder, sal_Bool bFolder )
//STRIP001 {
//STRIP001 	StringList_Impl* pProperties = NULL;
//STRIP001     INetURLObject aFolderObj( rFolder );
//STRIP001     DBG_ASSERT( aFolderObj.GetProtocol() != INET_PROT_NOT_VALID, "Invalid URL!" );
//STRIP001 	try
//STRIP001 	{
//STRIP001         Reference< XMultiServiceFactory > xFactory = ::legacy_binfilters::getLegacyProcessServiceFactory();
//STRIP001         Reference< XInteractionHandler > xInteractionHandler = Reference< XInteractionHandler > (
//STRIP001                     xFactory->createInstance( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("com.sun.star.task.InteractionHandler") ) ), UNO_QUERY );
//STRIP001 
//STRIP001         Content aCnt( aFolderObj.GetMainURL( INetURLObject::NO_DECODE ), new ::ucb::CommandEnvironment( xInteractionHandler, Reference< XProgressHandler >() ) );
//STRIP001 		Reference< XResultSet > xResultSet;
//STRIP001 		Sequence< OUString > aProps(5);
//STRIP001 		OUString* pProps = aProps.getArray();
//STRIP001 		pProps[0] = OUString::createFromAscii( "Title" );
//STRIP001 		pProps[1] = OUString::createFromAscii( "ContentType" );
//STRIP001 		pProps[2] = OUString::createFromAscii( "Size" );
//STRIP001 		pProps[3] = OUString::createFromAscii( "DateModified" );
//STRIP001 		pProps[4] = OUString::createFromAscii( "IsFolder" );
//STRIP001 
//STRIP001 		try
//STRIP001 		{
//STRIP001             Reference< ::com::sun::star::ucb::XDynamicResultSet > xDynResultSet;
//STRIP001 			ResultSetInclude eInclude =	bFolder ? INCLUDE_FOLDERS_AND_DOCUMENTS : INCLUDE_DOCUMENTS_ONLY;
//STRIP001 			xDynResultSet = aCnt.createDynamicCursor( aProps, eInclude );
//STRIP001 
//STRIP001 			Reference < ::com::sun::star::ucb::XAnyCompareFactory > xFactory;
//STRIP001 			Reference < XMultiServiceFactory > xMgr = ::legacy_binfilters::getLegacyProcessServiceFactory();
//STRIP001 		    Reference < ::com::sun::star::ucb::XSortedDynamicResultSetFactory > xSRSFac(
//STRIP001 				xMgr->createInstance( ::rtl::OUString::createFromAscii("com.sun.star.ucb.SortedDynamicResultSetFactory") ), UNO_QUERY );
//STRIP001 
//STRIP001 			Sequence< ::com::sun::star::ucb::NumberedSortingInfo > aSortInfo( 2 );
//STRIP001 			::com::sun::star::ucb::NumberedSortingInfo* pInfo = aSortInfo.getArray();
//STRIP001 			pInfo[ 0 ].ColumnIndex = 5;
//STRIP001 			pInfo[ 0 ].Ascending   = sal_False;
//STRIP001 			pInfo[ 1 ].ColumnIndex = 1;
//STRIP001 			pInfo[ 1 ].Ascending   = sal_True;
//STRIP001 
//STRIP001 			Reference< ::com::sun::star::ucb::XDynamicResultSet > xDynamicResultSet;
//STRIP001 			xDynamicResultSet =
//STRIP001 				xSRSFac->createSortedDynamicResultSet( xDynResultSet, aSortInfo, xFactory );
//STRIP001 			if ( xDynamicResultSet.is() )
//STRIP001 			{
//STRIP001 				sal_Int16 nCaps = xDynamicResultSet->getCapabilities();
//STRIP001 				xResultSet = xDynamicResultSet->getStaticResultSet();
//STRIP001 			}
//STRIP001 
//STRIP001 //			if ( xDynResultSet.is() )
//STRIP001 //				xResultSet = xDynResultSet->getStaticResultSet();
//STRIP001 		}
//STRIP001 		catch( ::com::sun::star::ucb::CommandAbortedException& )
//STRIP001 		{
//STRIP001 			DBG_ERRORFILE( "createCursor: CommandAbortedException" );
//STRIP001 		}
//STRIP001 		catch( ::com::sun::star::uno::Exception& )
//STRIP001 		{
//STRIP001 			DBG_ERRORFILE( "createCursor: Any other exception" );
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( xResultSet.is() )
//STRIP001 		{
//STRIP001 			LocaleDataWrapper aLocaleWrapper( ::legacy_binfilters::getLegacyProcessServiceFactory(), Application::GetSettings().GetLocale() );
//STRIP001 			pProperties = new StringList_Impl;
//STRIP001 			Reference< ::com::sun::star::sdbc::XRow > xRow( xResultSet, UNO_QUERY );
//STRIP001 			Reference< ::com::sun::star::ucb::XContentAccess > xContentAccess( xResultSet, UNO_QUERY );
//STRIP001 			ULONG nFolderPos = LIST_APPEND;
//STRIP001 
//STRIP001 			try
//STRIP001 			{
//STRIP001 				while ( xResultSet->next() )
//STRIP001 				{
//STRIP001 					String aTitle( xRow->getString(1) );
//STRIP001 					String aType( xRow->getString(2) );
//STRIP001 					sal_Int64 nSize = xRow->getLong(3);
//STRIP001 					::com::sun::star::util::DateTime aDT = xRow->getTimestamp(4);
//STRIP001 					sal_Bool bFolder = xRow->getBoolean(5);
//STRIP001 
//STRIP001 					String aRow = aTitle;
//STRIP001 					aRow += '\t';
//STRIP001 //!					aRow += aType;
//STRIP001 //!					aRow += '\t';
//STRIP001 					aRow += String::CreateFromInt64( nSize );
//STRIP001 					aRow += '\t';
//STRIP001 					AppendDateTime_Impl( aDT, aRow, aLocaleWrapper );
//STRIP001 					aRow += '\t';
//STRIP001 					aRow += String( xContentAccess->queryContentIdentifierString() );
//STRIP001 					aRow += '\t';
//STRIP001 					aRow += bFolder ? '1' : '0';
//STRIP001 					OUString* pRow = new OUString( aRow );
//STRIP001 					ULONG nPos = LIST_APPEND;
//STRIP001 					if ( bFolder )
//STRIP001 					{
//STRIP001 						if ( LIST_APPEND == nFolderPos )
//STRIP001 							nFolderPos = 0;
//STRIP001 						else
//STRIP001 							nFolderPos++;
//STRIP001 						nPos = nFolderPos;
//STRIP001 					}
//STRIP001 					pProperties->Insert( pRow, nPos );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			catch( ::com::sun::star::ucb::CommandAbortedException& )
//STRIP001 			{
//STRIP001 				DBG_ERRORFILE( "XContentAccess::next(): CommandAbortedException" );
//STRIP001 			}
//STRIP001 			catch( ::com::sun::star::uno::Exception& )
//STRIP001 			{
//STRIP001 				DBG_ERRORFILE( "XContentAccess::next(): Any other exception" );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	catch( ::com::sun::star::uno::Exception& )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "GetFolderContents: Any other exception" );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pProperties )
//STRIP001 	{
//STRIP001         ULONG nCount = pProperties->Count();
//STRIP001 		Sequence < OUString > aRet( nCount );
//STRIP001 		OUString* pRet = aRet.getArray();
//STRIP001 		for ( ULONG i = 0; i < nCount; ++i )
//STRIP001 		{
//STRIP001 			OUString* pProperty = pProperties->GetObject(i);
//STRIP001 			pRet[i] = *( pProperty );
//STRIP001 			delete pProperty;
//STRIP001 		}
//STRIP001 		delete pProperties;
//STRIP001 		return aRet;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return Sequence < OUString > ();
//STRIP001 }

// -----------------------------------------------------------------------

/*N*/ Sequence < OUString > SfxContentHelper::GetResultSet( const String& rURL )
/*N*/ {
/*N*/ 	StringList_Impl* pList = NULL;
/*N*/ 	try
/*N*/ 	{
/*N*/ 		Content aCnt( rURL, Reference< ::com::sun::star::ucb::XCommandEnvironment >() );
/*N*/ 		Reference< XResultSet > xResultSet;
/*N*/ 		Reference< ::com::sun::star::ucb::XDynamicResultSet > xDynResultSet;
/*N*/ 		Sequence< OUString > aProps(3);
/*N*/ 		OUString* pProps = aProps.getArray();
/*N*/ 		pProps[0] = OUString::createFromAscii( "Title" );
/*N*/ 		pProps[1] = OUString::createFromAscii( "ContentType" );
/*N*/ 		pProps[2] = OUString::createFromAscii( "IsFolder" );
/*N*/ 
/*N*/ 		try
/*N*/ 		{
/*N*/ 			xDynResultSet = aCnt.createDynamicCursor( aProps, INCLUDE_FOLDERS_AND_DOCUMENTS );
/*N*/ 			if ( xDynResultSet.is() )
/*N*/ 				xResultSet = xDynResultSet->getStaticResultSet();
/*N*/ 		}
/*N*/ 		catch( ::com::sun::star::ucb::CommandAbortedException& )
/*N*/ 		{
/*N*/ 			DBG_ERRORFILE( "createCursor: CommandAbortedException" );
/*N*/ 		}
/*N*/ 		catch( ::com::sun::star::uno::Exception& )
/*N*/ 		{
/*N*/ 			DBG_ERRORFILE( "createCursor: Any other exception" );
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( xResultSet.is() )
/*N*/ 		{
/*N*/ 			pList = new StringList_Impl;
/*N*/ 			Reference< ::com::sun::star::sdbc::XRow > xRow( xResultSet, UNO_QUERY );
/*N*/ 			Reference< ::com::sun::star::ucb::XContentAccess > xContentAccess( xResultSet, UNO_QUERY );
/*N*/ 
/*N*/ 			try
/*N*/ 			{
/*N*/ 				while ( xResultSet->next() )
/*N*/ 				{
/*N*/ 					String aTitle( xRow->getString(1) );
/*N*/ 					String aType( xRow->getString(2) );
/*N*/ 					sal_Bool bFolder = xRow->getBoolean(3);
/*N*/ 					String aRow = aTitle;
/*N*/ 					aRow += '\t';
/*N*/ 					aRow += aType;
/*N*/ 					aRow += '\t';
/*N*/ 					aRow += String( xContentAccess->queryContentIdentifierString() );
/*N*/ 					OUString* pRow = new OUString( aRow );
/*N*/ 					pList->Insert( pRow, LIST_APPEND );
/*N*/ 				}
/*N*/ 			}
/*N*/ 			catch( ::com::sun::star::ucb::CommandAbortedException& )
/*N*/ 			{
/*N*/ 				DBG_ERRORFILE( "XContentAccess::next(): CommandAbortedException" );
/*N*/ 			}
/*N*/ 			catch( ::com::sun::star::uno::Exception& )
/*N*/ 			{
/*N*/ 				DBG_ERRORFILE( "XContentAccess::next(): Any other exception" );
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 	catch( ::com::sun::star::uno::Exception& )
/*N*/ 	{
/*N*/ 		DBG_ERRORFILE( "GetResultSet: Any other exception" );
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( pList )
/*N*/ 	{
/*N*/ 		ULONG nCount = pList->Count();
/*N*/ 		Sequence < OUString > aRet( nCount );
/*N*/ 		OUString* pRet = aRet.getArray();
/*N*/ 		for ( ULONG i = 0; i < nCount; ++i )
/*N*/ 		{
/*N*/ 			OUString* pEntry = pList->GetObject(i);
/*N*/ 			pRet[i] = *( pEntry );
/*N*/ 			delete pEntry;
/*N*/ 		}
/*N*/ 		delete pList;
/*N*/ 		return aRet;
/*N*/ 	}
/*N*/ 	else
/*N*/ 		return Sequence < OUString > ();
/*N*/ }

// -----------------------------------------------------------------------

//STRIP001 Sequence< OUString > SfxContentHelper::GetHelpTreeViewContents( const String& rURL )
//STRIP001 {
//STRIP001 	StringList_Impl* pProperties = NULL;
//STRIP001 	try
//STRIP001 	{
//STRIP001         Reference< XMultiServiceFactory > xFactory = ::legacy_binfilters::getLegacyProcessServiceFactory();
//STRIP001         Reference< XInteractionHandler > xInteractionHandler = Reference< XInteractionHandler > (
//STRIP001                     xFactory->createInstance( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("com.sun.star.task.InteractionHandler") ) ), UNO_QUERY );
//STRIP001 
//STRIP001         Content aCnt( rURL, new ::ucb::CommandEnvironment( xInteractionHandler, Reference< XProgressHandler >() ) );
//STRIP001 		Reference< XResultSet > xResultSet;
//STRIP001 		Sequence< OUString > aProps(2);
//STRIP001 		OUString* pProps = aProps.getArray();
//STRIP001 		pProps[0] = OUString::createFromAscii( "Title" );
//STRIP001 		pProps[1] = OUString::createFromAscii( "IsFolder" );
//STRIP001 
//STRIP001 		try
//STRIP001 		{
//STRIP001             Reference< ::com::sun::star::ucb::XDynamicResultSet > xDynResultSet;
//STRIP001 			xDynResultSet = aCnt.createDynamicCursor( aProps, INCLUDE_FOLDERS_AND_DOCUMENTS );
//STRIP001 			if ( xDynResultSet.is() )
//STRIP001 				xResultSet = xDynResultSet->getStaticResultSet();
//STRIP001 		}
//STRIP001 		catch( ::com::sun::star::ucb::CommandAbortedException& )
//STRIP001 		{
//STRIP001 		}
//STRIP001 		catch( ::com::sun::star::uno::Exception& )
//STRIP001 		{
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( xResultSet.is() )
//STRIP001 		{
//STRIP001 			pProperties = new StringList_Impl;
//STRIP001 			Reference< ::com::sun::star::sdbc::XRow > xRow( xResultSet, UNO_QUERY );
//STRIP001 			Reference< ::com::sun::star::ucb::XContentAccess > xContentAccess( xResultSet, UNO_QUERY );
//STRIP001 
//STRIP001 			try
//STRIP001 			{
//STRIP001 				while ( xResultSet->next() )
//STRIP001 				{
//STRIP001 					String aTitle( xRow->getString(1) );
//STRIP001 					sal_Bool bFolder = xRow->getBoolean(2);
//STRIP001 					String aRow = aTitle;
//STRIP001 					aRow += '\t';
//STRIP001 					aRow += String( xContentAccess->queryContentIdentifierString() );
//STRIP001 					aRow += '\t';
//STRIP001 					aRow += bFolder ? '1' : '0';
//STRIP001 					OUString* pRow = new OUString( aRow );
//STRIP001 					pProperties->Insert( pRow, LIST_APPEND );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			catch( ::com::sun::star::ucb::CommandAbortedException& )
//STRIP001 			{
//STRIP001 			}
//STRIP001 			catch( ::com::sun::star::uno::Exception& )
//STRIP001 			{
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	catch( ::com::sun::star::uno::Exception& )
//STRIP001 	{
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pProperties )
//STRIP001 	{
//STRIP001         ULONG nCount = pProperties->Count();
//STRIP001 		Sequence < OUString > aRet( nCount );
//STRIP001 		OUString* pRet = aRet.getArray();
//STRIP001 		for ( ULONG i = 0; i < nCount; ++i )
//STRIP001 		{
//STRIP001 			OUString* pProperty = pProperties->GetObject(i);
//STRIP001 			pRet[i] = *( pProperty );
//STRIP001 			delete pProperty;
//STRIP001 		}
//STRIP001 		delete pProperties;
//STRIP001 		return aRet;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return Sequence < OUString > ();
//STRIP001 }

// -----------------------------------------------------------------------

/*N*/ String SfxContentHelper::GetActiveHelpString( const String& rURL )
/*N*/ {
/*N*/ 	String aRet;
/*N*/ 	try
/*N*/ 	{
/*N*/         Reference< XMultiServiceFactory > xFactory = ::legacy_binfilters::getLegacyProcessServiceFactory();
/*N*/         Reference< XInteractionHandler > xInteractionHandler = Reference< XInteractionHandler > (
/*N*/                     xFactory->createInstance( ::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM("com.sun.star.task.InteractionHandler") ) ), UNO_QUERY );
/*N*/         Content aCnt( rURL, new ::ucb::CommandEnvironment( xInteractionHandler, Reference< XProgressHandler >() ) );
/*N*/ 		// open the "active help" stream
/*N*/ 		Reference< ::com::sun::star::io::XInputStream > xStream = aCnt.openStream();
/*N*/ 		// and convert it to a String
/*N*/ 		Sequence< sal_Int8 > lData;
/*N*/ 		sal_Int32 nRead = xStream->readBytes( lData, 1024 );
/*N*/ 		while ( nRead > 0 )
/*N*/ 		{
/*N*/ 			OStringBuffer sBuffer( nRead );
/*N*/ 			for( sal_Int32 i = 0; i < nRead; ++i )
/*N*/     			sBuffer.append( (sal_Char)lData[i] );
/*N*/ 			OUString sString = OStringToOUString( sBuffer.makeStringAndClear(), RTL_TEXTENCODING_UTF8 );
/*N*/ 			aRet += String( sString );
/*N*/ 
/*N*/ 			nRead = xStream->readBytes( lData, 1024 );
/*N*/ 		}
/*N*/ 	}
/*N*/ 	catch( ::com::sun::star::uno::Exception& )
/*N*/ 	{
/*N*/ 	}
/*N*/ 
/*N*/ 	return aRet;
/*N*/ }

// -----------------------------------------------------------------------

//STRIP001 sal_Bool SfxContentHelper::IsHelpErrorDocument( const String& rURL )
//STRIP001 {
//STRIP001 	sal_Bool bRet = sal_False;
//STRIP001 	try
//STRIP001 	{
//STRIP001 		Content aCnt( INetURLObject( rURL ).GetMainURL( INetURLObject::NO_DECODE ),
//STRIP001 					  Reference< ::com::sun::star::ucb::XCommandEnvironment > () );
//STRIP001 		if ( !( aCnt.getPropertyValue( OUString::createFromAscii( "IsErrorDocument" ) ) >>= bRet ) )
//STRIP001 		{
//STRIP001 			DBG_ERRORFILE( "Property 'IsErrorDocument' is missing" );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	catch( ::com::sun::star::uno::Exception& )
//STRIP001 	{
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 sal_Bool SfxContentHelper::CopyTo( const String& rSource, const String& rDest )
//STRIP001 {
//STRIP001     return Transfer_Impl( rSource, rDest, sal_False, NameClash::ERROR );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 sal_Bool SfxContentHelper::MoveTo( const String& rSource, const String& rDest, sal_Int32 nNameClash )
//STRIP001 {
//STRIP001     return Transfer_Impl( rSource, rDest, sal_True, nNameClash );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 sal_Bool SfxContentHelper::MakeFolder( const String& rFolder )
//STRIP001 {
//STRIP001     INetURLObject aURL( rFolder );
//STRIP001     DBG_ASSERT( aURL.GetProtocol() != INET_PROT_NOT_VALID, "Invalid URL!" );
//STRIP001 	String aTitle = aURL.getName( INetURLObject::LAST_SEGMENT, true, INetURLObject::DECODE_WITH_CHARSET );
//STRIP001 	aURL.removeSegment();
//STRIP001     Sequence < OUString > aNames(2);
//STRIP001 	OUString* pNames = aNames.getArray();
//STRIP001 	pNames[0] = OUString( RTL_CONSTASCII_USTRINGPARAM( "Title" ) );
//STRIP001 	pNames[1] = OUString( RTL_CONSTASCII_USTRINGPARAM( "IsFolder" ) );
//STRIP001 	Sequence<Any> aValues(2);
//STRIP001 	Any* pValues = aValues.getArray();
//STRIP001 	pValues[0] = makeAny( OUString( aTitle ) );
//STRIP001 	pValues[1] = makeAny( sal_Bool( sal_True ) );
//STRIP001 	Reference< ::com::sun::star::ucb::XCommandEnvironment > aCmdEnv;
//STRIP001 	sal_Bool bRet = sal_False;
//STRIP001 	try
//STRIP001 	{
//STRIP001 		Content aCnt( aURL.GetMainURL( INetURLObject::NO_DECODE ), aCmdEnv );
//STRIP001         Content aNewFolder;
//STRIP001 		OUString aType( RTL_CONSTASCII_USTRINGPARAM( "application/vnd.sun.staroffice.fsys-folder" ) );
//STRIP001 		bRet = aCnt.insertNewContent( aType, aNames, aValues, aNewFolder );
//STRIP001 	}
//STRIP001 	catch( ::com::sun::star::ucb::CommandAbortedException& )
//STRIP001 	{
//STRIP001 		// double name?
//STRIP001 	}
//STRIP001 	catch( ::com::sun::star::ucb::IllegalIdentifierException& )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "Illegal identifier" );
//STRIP001 	}
//STRIP001     catch( ::com::sun::star::uno::Exception& )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "Any other exception" );
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 ErrCode SfxContentHelper::QueryDiskSpace( const String& rPath, sal_Int64& rFreeBytes )
//STRIP001 {
//STRIP001 	ErrCode nErr = 0;
//STRIP001 	rFreeBytes = 0;
//STRIP001     INetURLObject aObj( rPath );
//STRIP001     DBG_ASSERT( aObj.GetProtocol() != INET_PROT_NOT_VALID, "Invalid URL!" );
//STRIP001 	try
//STRIP001 	{
//STRIP001 		Content aCnt( aObj.GetMainURL( INetURLObject::NO_DECODE ), Reference< ::com::sun::star::ucb::XCommandEnvironment > () );
//STRIP001 		aCnt.getPropertyValue( OUString::createFromAscii( "FreeSpace" ) ) >>= rFreeBytes;
//STRIP001 	}
//STRIP001 	catch( ::com::sun::star::ucb::CommandAbortedException& )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "CommandAbortedException" );
//STRIP001 		nErr = ERRCODE_IO_GENERAL;
//STRIP001 	}
//STRIP001 	catch( ::com::sun::star::uno::Exception& )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "Any other exception" );
//STRIP001 		nErr = ERRCODE_IO_GENERAL;
//STRIP001 	}
//STRIP001 	return nErr;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 ULONG SfxContentHelper::GetSize( const String& rContent )
//STRIP001 {
//STRIP001 	ULONG nSize = 0;
//STRIP001 	sal_Int64 nTemp = 0;
//STRIP001     INetURLObject aObj( rContent );
//STRIP001     DBG_ASSERT( aObj.GetProtocol() != INET_PROT_NOT_VALID, "Invalid URL!" );
//STRIP001 	try
//STRIP001 	{
//STRIP001 		Content aCnt( aObj.GetMainURL( INetURLObject::NO_DECODE ), Reference< ::com::sun::star::ucb::XCommandEnvironment > () );
//STRIP001 		aCnt.getPropertyValue( OUString::createFromAscii( "Size" ) ) >>= nTemp;
//STRIP001 	}
//STRIP001 	catch( ::com::sun::star::ucb::CommandAbortedException& )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "CommandAbortedException" );
//STRIP001 	}
//STRIP001 	catch( ::com::sun::star::uno::Exception& )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "Any other exception" );
//STRIP001 	}
//STRIP001 	nSize = (UINT32)nTemp;
//STRIP001 	return nSize;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 sal_Bool SfxContentHelper::IsYounger( const String& rIsYoung, const String& rIsOlder )
//STRIP001 {
//STRIP001 	DateTime aYoungDate, aOlderDate;
//STRIP001     INetURLObject aYoungObj( rIsYoung );
//STRIP001     DBG_ASSERT( aYoungObj.GetProtocol() != INET_PROT_NOT_VALID, "Invalid URL!" );
//STRIP001     INetURLObject aOlderObj( rIsOlder );
//STRIP001     DBG_ASSERT( aOlderObj.GetProtocol() != INET_PROT_NOT_VALID, "Invalid URL!" );
//STRIP001 	try
//STRIP001 	{
//STRIP001 		Reference< ::com::sun::star::ucb::XCommandEnvironment > aCmdEnv;
//STRIP001 		Content aYoung( aYoungObj.GetMainURL( INetURLObject::NO_DECODE ), aCmdEnv );
//STRIP001 		::com::sun::star::util::DateTime aTempYoungDate;
//STRIP001 		aYoung.getPropertyValue( OUString::createFromAscii( "DateModified" ) ) >>= aTempYoungDate;
//STRIP001 		CONVERT_DATETIME( aTempYoungDate, aYoungDate );
//STRIP001 		Content aOlder( aOlderObj.GetMainURL( INetURLObject::NO_DECODE ), aCmdEnv );
//STRIP001 		::com::sun::star::util::DateTime aTempOlderDate;
//STRIP001 		aOlder.getPropertyValue( OUString::createFromAscii( "DateModified" ) ) >>= aTempOlderDate;
//STRIP001 		CONVERT_DATETIME( aTempOlderDate, aOlderDate );
//STRIP001 	}
//STRIP001 	catch( ::com::sun::star::ucb::CommandAbortedException& )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "CommandAbortedException" );
//STRIP001 	}
//STRIP001 	catch( ::com::sun::star::uno::Exception& )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "Any other exception" );
//STRIP001 	}
//STRIP001 
//STRIP001 	return ( aYoungDate > aOlderDate );
//STRIP001 }

// -----------------------------------------------------------------------
// please don't use it (only used in appbas.cxx and appcfg.cxx)
//STRIP001 sal_Bool SfxContentHelper::Exists( const String& rContent )
//STRIP001 {
//STRIP001 	sal_Bool bRet = sal_False;
//STRIP001 	INetURLObject aObj( rContent );
//STRIP001 	DBG_ASSERT( aObj.GetProtocol() != INET_PROT_NOT_VALID, "Invalid URL!" );
//STRIP001 
//STRIP001 	try
//STRIP001 	{
//STRIP001 		Content aCnt( aObj.GetMainURL( INetURLObject::NO_DECODE ), Reference< ::com::sun::star::ucb::XCommandEnvironment > () );
//STRIP001 		// just try to get the property; if no exception is thrown, the content exists!
//STRIP001 		aCnt.isDocument();
//STRIP001 		bRet = sal_True;
//STRIP001 	}
//STRIP001 	catch( ::com::sun::star::ucb::CommandAbortedException& )
//STRIP001 	{
//STRIP001         	DBG_WARNING( "CommandAbortedException" );
//STRIP001 	}
//STRIP001 	catch( ::com::sun::star::ucb::IllegalIdentifierException& )
//STRIP001 	{
//STRIP001 	        DBG_WARNING( "IllegalIdentifierException" );
//STRIP001 	}
//STRIP001 	catch( ContentCreationException& )
//STRIP001 	{
//STRIP001         	DBG_WARNING( "IllegalIdentifierException" );
//STRIP001 	}
//STRIP001 	catch( Exception& )
//STRIP001 	{
//STRIP001 		DBG_ERRORFILE( "Any other exception" );
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 sal_Bool SfxContentHelper::Find( const String& rFolder, const String& rName, String& rFile )
//STRIP001 {
//STRIP001 	sal_Bool bRet = sal_False;
//STRIP001     ::rtl::OUString aFile;
//STRIP001 
//STRIP001     if ( FileBase::searchFileURL( rName, rFolder, aFile ) == FileBase::E_None )
//STRIP001 	{
//STRIP001 		rFile = aFile;
//STRIP001 		bRet = sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }


}
