/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_sdwindow.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:44:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _B3D_BASE3D_HXX
// auto strip #include "goodies/base3d.hxx"
// auto strip #endif
// auto strip #ifndef _SFXDISPATCH_HXX
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
// auto strip #ifndef _SFXREQUEST_HXX
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #endif

#pragma hdrstop

#include "app.hrc"
#include "helpids.h"
#include "sdwindow.hxx"
// auto strip #include "viewshel.hxx"
#include "drviewsh.hxx"
// auto strip #include "sdview.hxx"
// auto strip #include "frmview.hxx"
// auto strip #include "outlnvsh.hxx"
// auto strip #include "drawdoc.hxx"

// auto strip #ifndef _COM_SUN_STAR_DOCUMENT_XEVENTLISTENER_HPP_
// auto strip #include <com/sun/star/document/XEventListener.hpp>
// auto strip #endif

// auto strip #ifndef _SVX_ACCESSIBILITY_ACCESSIBLE_SHAPE_TREE_INFO_HXX
// auto strip #include <bf_svx/AccessibleShapeTreeInfo.hxx>
// auto strip #endif

#ifndef _SVX_ACCESSIBILITY_CHILDREN_MANAGER_HXX
#include <bf_svx/ChildrenManager.hxx>
#endif

// auto strip #ifndef _SD_ACCESSIBILITY_ACCESSIBLE_DRAW_DOCUMENT_VIEW_HXX
// auto strip #include "AccessibleDrawDocumentView.hxx"
// auto strip #endif
// auto strip #include "WindowUpdater.hxx"
namespace binfilter {


#define SCROLL_LINE_FACT   0.05     // Faktor fuer Zeilenscrolling
#define SCROLL_PAGE_FACT   0.5      // Faktor fuer Seitenscrolling
#define SCROLL_SENSITIVE   20       // Sensitiver Bereich (Pixel)
#define ZOOM_MULTIPLICATOR 10000    // Multiplikator um Rundungsfehler zu vermeiden
#define MIN_ZOOM	       5        // Minimaler Zoomfaktor
#define MAX_ZOOM	       3000	    // Maximaler Zoomfaktor


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

/*N*/ SdWindow::SdWindow(Window* pParent) :
/*N*/ 	Window(pParent, WinBits(WB_CLIPCHILDREN | WB_DIALOGCONTROL)),
/*N*/ 	DropTargetHelper( this ),
/*N*/ 	pShareWin(NULL),
/*N*/ 	pViewShell(NULL),
/*N*/ 	aWinPos(0, 0),			// vorsichtshalber; die Werte sollten aber
/*N*/ 	aViewOrigin(0, 0),		// vom Besitzer des Fensters neu gesetzt
/*N*/ 	aViewSize(1000, 1000),	// werden
/*N*/ 	nMinZoom(MIN_ZOOM),
/*N*/ 	nMaxZoom(MAX_ZOOM),
/*N*/ 	bMinZoomAutoCalc(FALSE),
/*N*/ 	bCalcMinZoomByMinSide(TRUE),
/*N*/ 	bCenterAllowed(TRUE),
/*N*/ 	nTicks (0)
/*N*/ {
/*N*/ 	SetDialogControlFlags( WINDOW_DLGCTRL_RETURN | WINDOW_DLGCTRL_WANTFOCUS );
/*N*/ 
/*N*/ 	MapMode aMap(GetMapMode());
/*N*/ 	aMap.SetMapUnit(MAP_100TH_MM);
/*N*/ 	SetMapMode(aMap);
/*N*/ 
/*N*/ 	// Damit im Diamodus die WindowColor genommen wird
/*N*/ 	SetBackground( Wallpaper( GetSettings().GetStyleSettings().GetWindowColor() ) );
/*N*/ 
/*N*/ 	// adjust contrast mode initially
/*N*/ 	bool bUseContrast = GetSettings().GetStyleSettings().GetHighContrastMode();
/*N*/     SetDrawMode( bUseContrast ? OUTPUT_DRAWMODE_CONTRAST : OUTPUT_DRAWMODE_COLOR );
/*N*/ 
/*N*/ 	// Hilfe-ID setzen
/*N*/ 	// SetHelpId(HID_SD_WIN_DOCUMENT);
/*N*/ 	SetUniqueId(HID_SD_WIN_DOCUMENT);
/*N*/ }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ SdWindow::~SdWindow()
/*N*/ {
/*N*/     if (pViewShell != NULL)
/*N*/     {
/*?*/         DBG_BF_ASSERT(0, "STRIP"); //STRIP001 ::binfilter::bifilter::sd::WindowUpdater* pWindowUpdater = pViewShell->GetWindowUpdater();
//STRIP001 /*?*/         if (pWindowUpdater != NULL)
//STRIP001 /*?*/             pWindowUpdater->UnregisterWindow (this);
/*N*/     }
/*N*/ }




/*N*/ void SdWindow::SetViewShell(SdViewShell* pViewSh) 
/*N*/ {
/*N*/     ::binfilter::sd::WindowUpdater* pWindowUpdater = NULL;
/*N*/     // Unregister at device updater of old view shell.
/*N*/     if (pViewShell != NULL)
/*N*/     {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001         pWindowUpdater = pViewShell->GetWindowUpdater();
//STRIP001         if (pWindowUpdater != NULL)
//STRIP001             pWindowUpdater->UnregisterWindow (this);
/*N*/     }
/*N*/ 
/*N*/     pViewShell = pViewSh;
/*N*/ 
/*N*/     // Register at device updater of new view shell
/*N*/     if (pViewShell != NULL)
/*N*/     {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001         pWindowUpdater = pViewShell->GetWindowUpdater();
//STRIP001         if (pWindowUpdater != NULL)
//STRIP001             pWindowUpdater->RegisterWindow (this);
/*N*/     }
/*N*/ }




/*************************************************************************
|*
|* Die Haelfte des Sichtbaren Bereich eines anderen Fensters darstellen
|*
\************************************************************************/

//STRIP001 void SdWindow::ShareViewArea(SdWindow* pOtherWin)
//STRIP001 {
//STRIP001 	pShareWin		= pOtherWin;
//STRIP001 	aViewOrigin 	= pOtherWin->aViewOrigin;
//STRIP001 	aViewSize		= pOtherWin->aViewSize;
//STRIP001 	nMinZoom		= pOtherWin->nMinZoom;
//STRIP001 	nMaxZoom		= pOtherWin->nMaxZoom;
//STRIP001 	bCenterAllowed	= pOtherWin->bCenterAllowed;
//STRIP001 
//STRIP001 	long nZoom = pOtherWin->GetZoom();
//STRIP001 	MapMode aMap(GetMapMode());
//STRIP001 	aMap.SetScaleX(Fraction(nZoom, 100));
//STRIP001 	aMap.SetScaleY(Fraction(nZoom, 100));
//STRIP001 	aMap.SetOrigin(pOtherWin->GetMapMode().GetOrigin());
//STRIP001 	SetMapMode(aMap);
//STRIP001 }




/*N*/ void SdWindow::CalcMinZoom()
/*N*/ {
/*N*/     // Are we entitled to change the minimal zoom factor?
/*N*/ 	if ( bMinZoomAutoCalc )
/*N*/ 	{
/*N*/         // Get current zoom factor.
/*N*/ 		long nZoom = GetZoom();
/*N*/ 
/*N*/ 		if ( pShareWin )
/*N*/ 		{
/*?*/ 			pShareWin->CalcMinZoom();
/*?*/ 			nMinZoom = pShareWin->nMinZoom;
/*?*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/             // Get the rectangle of the output area in logical coordinates
/*N*/             // and calculate the scaling factors that would lead to the view
/*N*/             // area (also called application area) to completely fill the
/*N*/             // window.
/*N*/ 			Size aWinSize = PixelToLogic(GetOutputSizePixel());
/*N*/ 			ULONG nX = (ULONG) ((double) aWinSize.Width()  
/*N*/                 * (double) ZOOM_MULTIPLICATOR / (double) aViewSize.Width());
/*N*/ 			ULONG nY = (ULONG) ((double) aWinSize.Height() 
/*N*/                 * (double) ZOOM_MULTIPLICATOR / (double) aViewSize.Height());
/*N*/ 
/*N*/             // Decide whether to take the larger or the smaller factor.
/*N*/ 			ULONG nFact;
/*N*/ 			if ( bCalcMinZoomByMinSide )	nFact = Min(nX, nY);
/*N*/ 			else							nFact = Max(nX, nY);
/*N*/ 
/*N*/             // The factor is tansfomed according to the current zoom factor.
/*N*/ 			nFact = nFact * nZoom / ZOOM_MULTIPLICATOR;
/*N*/ 			nMinZoom = Max((USHORT) MIN_ZOOM, (USHORT) nFact);
/*N*/ 		}
/*N*/         // If the current zoom factor is smaller than the calculated minimal
/*N*/         // zoom factor then set the new minimal factor as the current zoom
/*N*/         // factor.
/*N*/  		if ( nZoom < (long) nMinZoom )
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SetZoomFactor(nMinZoom);
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Resize event
|*
\************************************************************************/

/*N*/ void SdWindow::Resize()
/*N*/ {
/*N*/ 	Window::Resize();
/*N*/ 	CalcMinZoom();
/*N*/ }

/*************************************************************************
|*
|* Paint event
|*
\************************************************************************/

//STRIP001 void SdWindow::Paint(const Rectangle& rRect)
//STRIP001 {
//STRIP001 	if ( pViewShell )
//STRIP001 		pViewShell->Paint(rRect, this);
//STRIP001 }

/*************************************************************************
|*
|* Keyboard event
|*
\************************************************************************/

//STRIP001 void SdWindow::KeyInput(const KeyEvent& rKEvt)
//STRIP001 {
//STRIP001 	BOOL aReturn = FALSE;
//STRIP001 
//STRIP001 	if (!(pViewShell && pViewShell->KeyInput(rKEvt, this)))
//STRIP001 	{
//STRIP001 		if (pViewShell && rKEvt.GetKeyCode().GetCode() == KEY_ESCAPE)
//STRIP001 		{
//STRIP001 			// Wenn IP aktiv, wird der IP-Modus abgebrochen
//STRIP001 			pViewShell->GetDocSh()->DoInPlaceActivate(FALSE);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			Window::KeyInput(rKEvt);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* MouseButtonDown event
|*
\************************************************************************/

//STRIP001 void SdWindow::MouseButtonDown(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	if ( pViewShell )
//STRIP001 		pViewShell->MouseButtonDown(rMEvt, this);
//STRIP001 }

/*************************************************************************
|*
|* MouseMove event
|*
\************************************************************************/

//STRIP001 void SdWindow::MouseMove(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	if ( pViewShell )
//STRIP001 		pViewShell->MouseMove(rMEvt, this);
//STRIP001 }

/*************************************************************************
|*
|* MouseButtonUp event
|*
\************************************************************************/

//STRIP001 void SdWindow::MouseButtonUp(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	nTicks = 0;
//STRIP001 
//STRIP001 	if ( pViewShell )
//STRIP001 		pViewShell->MouseButtonUp(rMEvt, this);
//STRIP001 }

/*************************************************************************
|*
|* Command event
|*
\************************************************************************/

//STRIP001 void SdWindow::Command(const CommandEvent& rCEvt)
//STRIP001 {
//STRIP001 	if ( pViewShell )
//STRIP001 		pViewShell->Command(rCEvt, this);
//STRIP001 }

/*************************************************************************
|*
|* RequestHelp event
|*
\************************************************************************/

//STRIP001 void SdWindow::RequestHelp(const HelpEvent& rEvt)
//STRIP001 {
//STRIP001 	if ( pViewShell )
//STRIP001 	{
//STRIP001 		if( !pViewShell->RequestHelp( rEvt, this) )
//STRIP001 			Window::RequestHelp( rEvt );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		Window::RequestHelp( rEvt );
//STRIP001 }

/*************************************************************************
|*
|* Position der linken oberen Ecke des im Fenster sichtbaren Bereichs
|* setzen
|*
\************************************************************************/

/*N*/ void SdWindow::SetWinViewPos(const Point& rPnt)
/*N*/ {
/*N*/ 	aWinPos = rPnt;
/*N*/ }

/*************************************************************************
|*
|* Ursprung der Darstellung in Bezug zur gesamten Arbeitsflaeche setzen
|*
\************************************************************************/

/*N*/ void SdWindow::SetViewOrigin(const Point& rPnt)
/*N*/ {
/*N*/ 	aViewOrigin = rPnt;
/*N*/ }

/*************************************************************************
|*
|* Groesse der gesamten Arbeitsflaeche, die mit dem Fenster betrachtet
|* werden kann, setzen
|*
\************************************************************************/

/*N*/ void SdWindow::SetViewSize(const Size& rSize)
/*N*/ {
/*N*/ 	aViewSize = rSize;
/*N*/ 	CalcMinZoom();
/*N*/ }




//STRIP001 long SdWindow::SetZoomFactor(long nZoom)
//STRIP001 {
//STRIP001     // Clip the zoom factor to the valid range marked by nMinZoom as
//STRIP001     // calculated by CalcMinZoom() and the constant MAX_ZOOM.
//STRIP001 	if ( nZoom > MAX_ZOOM ) 
//STRIP001         nZoom = MAX_ZOOM;
//STRIP001 	if ( nZoom < (long) nMinZoom ) 
//STRIP001         nZoom = nMinZoom;
//STRIP001 
//STRIP001     // Set the zoom factor at the window's map mode.
//STRIP001 	MapMode aMap(GetMapMode());
//STRIP001 	aMap.SetScaleX(Fraction(nZoom, 100));
//STRIP001 	aMap.SetScaleY(Fraction(nZoom, 100));
//STRIP001 	SetMapMode(aMap);
//STRIP001 
//STRIP001     // Update the map mode's origin (to what effect?).
//STRIP001 	UpdateMapOrigin();
//STRIP001 
//STRIP001     // Update the view's snapping to the the new zoom factor.
//STRIP001 	if ( pViewShell && pViewShell->ISA(SdDrawViewShell) )
//STRIP001 		((SdDrawViewShell*) pViewShell)->GetView()->
//STRIP001 										RecalcLogicSnapMagnetic(*this);
//STRIP001 
//STRIP001     // Return the zoom factor just in case it has been changed above to lie
//STRIP001     // inside the valid range.
//STRIP001 	return nZoom;
//STRIP001 }




//STRIP001 void SdWindow::SetZoom(long nZoom)
//STRIP001 {
//STRIP001     // Clip the zoom factor to the valid range marked by nMinZoom as
//STRIP001     // previously calculated by <member>CalcMinZoom()</member> and the
//STRIP001     // MAX_ZOOM constant.
//STRIP001 	if ( nZoom > MAX_ZOOM ) 
//STRIP001         nZoom = MAX_ZOOM;
//STRIP001 	if ( nZoom < (long) nMinZoom ) 
//STRIP001         nZoom = nMinZoom;
//STRIP001 
//STRIP001     // Calculate the window's new origin.
//STRIP001 	Size aSize = PixelToLogic(GetOutputSizePixel());
//STRIP001 	long nW = aSize.Width()  * GetZoom() / nZoom;
//STRIP001 	long nH = aSize.Height() * GetZoom() / nZoom;
//STRIP001 	aWinPos.X() += (aSize.Width()  - nW) / 2;
//STRIP001 	aWinPos.Y() += (aSize.Height() - nH) / 2;
//STRIP001 	if ( aWinPos.X() < 0 ) aWinPos.X() = 0;
//STRIP001 	if ( aWinPos.Y() < 0 ) aWinPos.Y() = 0;
//STRIP001 
//STRIP001     // Finally update this window's map mode to the given zoom factor that
//STRIP001     // has been clipped to the valid range.
//STRIP001 	SetZoomFactor(nZoom);
//STRIP001 }




/** Recalculate the zoom factor and translation so that the given rectangle
    is displayed centered and as large as possible while still being fully
    visible in the window.
*/
//STRIP001 long SdWindow::SetZoomRect(const Rectangle& rZoomRect)
//STRIP001 {
//STRIP001 	long nNewZoom = 100;
//STRIP001 
//STRIP001 	if (rZoomRect.GetWidth() == 0 || rZoomRect.GetHeight() == 0)
//STRIP001 	{
//STRIP001         // The given rectangle is degenerate.  Use the default zoom factor
//STRIP001         // (above) of 100%.
//STRIP001 		SetZoom(nNewZoom);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		Point aPos = rZoomRect.TopLeft();
//STRIP001         // Transform the output area from pixel coordinates into logical
//STRIP001         // coordinates.
//STRIP001 		Size aWinSize = PixelToLogic(GetOutputSizePixel());
//STRIP001         // Paranoia!  The degenerate case of zero width or height has been
//STRIP001         // taken care of above.
//STRIP001 		DBG_ASSERT(rZoomRect.GetWidth(), "ZoomRect-Breite = 0!");
//STRIP001 		DBG_ASSERT(rZoomRect.GetHeight(), "ZoomRect-Hoehe = 0!");
//STRIP001 
//STRIP001         // Calculate the scale factors which will lead to the given
//STRIP001         // rectangle being fully visible (when translated accordingly) as
//STRIP001         // large as possible in the output area independently in both
//STRIP001         // coordinate directions .
//STRIP001 		ULONG nX = (ULONG) ((double) aWinSize.Width()  
//STRIP001             * (double) ZOOM_MULTIPLICATOR / (double) rZoomRect.GetWidth());
//STRIP001 		ULONG nY = (ULONG) ((double) aWinSize.Height() 
//STRIP001             * (double) ZOOM_MULTIPLICATOR / (double) rZoomRect.GetHeight());
//STRIP001         // Use the smaller one of both so that the zoom rectangle will be
//STRIP001         // fully visible with respect to both coordinate directions.
//STRIP001 		ULONG nFact = Min(nX, nY);
//STRIP001         
//STRIP001         // Transform the current zoom factor so that it leads to the desired
//STRIP001         // scaling.
//STRIP001 		long nZoom = nFact * GetZoom() / ZOOM_MULTIPLICATOR;
//STRIP001 
//STRIP001         // Calculate the new origin.
//STRIP001 		if ( nFact == 0 )
//STRIP001 		{
//STRIP001             // Don't change anything if the scale factor is degenrate.
//STRIP001 			nNewZoom = GetZoom();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001             // Calculate the new window position that centers the given
//STRIP001             // rectangle on the screen.
//STRIP001 			if ( nZoom > MAX_ZOOM )
//STRIP001 				nFact = nFact * MAX_ZOOM / nZoom;
//STRIP001 
//STRIP001 			aWinPos = aViewOrigin + aPos;
//STRIP001 
//STRIP001 			aWinSize.Width() = (long) ((double) aWinSize.Width() * (double) ZOOM_MULTIPLICATOR / (double) nFact);
//STRIP001 			aWinPos.X() += (rZoomRect.GetWidth() - aWinSize.Width()) / 2;
//STRIP001 			aWinSize.Height() = (long) ((double) aWinSize.Height() * (double) ZOOM_MULTIPLICATOR / (double) nFact);
//STRIP001 			aWinPos.Y() += (rZoomRect.GetHeight() - aWinSize.Height()) / 2;
//STRIP001 
//STRIP001 			if ( aWinPos.X() < 0 )	aWinPos.X() = 0;
//STRIP001 			if ( aWinPos.Y() < 0 )	aWinPos.Y() = 0;
//STRIP001 
//STRIP001             // Adapt the window's map mode to the new zoom factor.
//STRIP001 			nNewZoom = SetZoomFactor(nZoom);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return(nNewZoom);
//STRIP001 }

/*************************************************************************
|*
|* Neuen MapMode-Origin berechnen und setzen; wenn aWinPos.X()/Y()
|* gleich -1 ist, wird die entsprechende Position zentriert
|* (z.B. fuer Initialisierung)
|*
\************************************************************************/

/*N*/ void SdWindow::UpdateMapOrigin(BOOL bInvalidate)
/*N*/ {
/*N*/ 	MapMode aMap(GetMapMode());
/*N*/ 	Point	aNewOrigin;
/*N*/ 	BOOL	bChanged = FALSE;
/*N*/ 	Size	aWinSize = PixelToLogic(GetOutputSizePixel());
/*N*/ 
/*N*/ 	if ( bCenterAllowed )
/*N*/ 	{
/*N*/ 		if ( aWinPos.X() > aViewSize.Width() - aWinSize.Width() )
/*N*/ 		{
/*N*/ 			aWinPos.X() = aViewSize.Width() - aWinSize.Width();
/*N*/ 			bChanged = TRUE;
/*N*/ 		}
/*N*/ 		if ( aWinPos.Y() > aViewSize.Height() - aWinSize.Height() )
/*N*/ 		{
/*N*/ 			aWinPos.Y() = aViewSize.Height() - aWinSize.Height();
/*N*/ 			bChanged = TRUE;
/*N*/ 		}
/*N*/ 		if ( aWinSize.Width() > aViewSize.Width() || aWinPos.X() < 0 )
/*N*/ 		{
/*N*/ 			aWinPos.X() = aViewSize.Width()  / 2 - aWinSize.Width()  / 2;
/*N*/ 			bChanged = TRUE;
/*N*/ 		}
/*N*/ 		if ( aWinSize.Height() > aViewSize.Height() || aWinPos.Y() < 0 )
/*N*/ 		{
/*N*/ 			aWinPos.Y() = aViewSize.Height() / 2 - aWinSize.Height() / 2;
/*N*/ 			bChanged = TRUE;
/*N*/ 		}
/*N*/ 		aWinPos -= aViewOrigin;
/*N*/ 		Size aPix(aWinPos.X(), aWinPos.Y());
/*N*/ 		aPix = LogicToPixel(aPix);
/*N*/ 		// Groesse muss vielfaches von BRUSH_SIZE sein, damit Muster
/*N*/ 		// richtig dargestellt werden
		// #i2237#
		// removed old stuff here which still forced zoom to be
		// %BRUSH_SIZE which is outdated now
/*N*/ 
/*N*/ 		if (pViewShell && pViewShell->ISA(SdDrawViewShell))
/*N*/ 		{
/*N*/ 			Size aViewSizePixel = LogicToPixel(aViewSize);
/*N*/ 			Size aWinSizePixel = LogicToPixel(aWinSize);
/*N*/ 
/*N*/ 			// Seite soll nicht am Fensterrand "kleben"
/*N*/ 			if (aPix.Width() == 0)
/*N*/ 			{
/*N*/ 				// #i2237#
/*N*/ 				// Since BRUSH_SIZE alignment is outdated now, i use the
/*N*/ 				// former constant here directly
/*N*/ 				aPix.Width() -= 8;
/*N*/ 			}
/*N*/ 			if (aPix.Height() == 0)
/*N*/ 			{
/*N*/ 				// #i2237#
/*N*/ 				// Since BRUSH_SIZE alignment is outdated now, i use the
/*N*/ 				// former constant here directly
/*N*/ 				aPix.Height() -= 8;
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		aPix = PixelToLogic(aPix);
/*N*/ 		aWinPos.X() = aPix.Width();
/*N*/ 		aWinPos.Y() = aPix.Height();
/*N*/ 		aNewOrigin.X() = - aWinPos.X();
/*N*/ 		aNewOrigin.Y() = - aWinPos.Y();
/*N*/ 		aWinPos += aViewOrigin;
/*N*/ 
/*N*/ 		aMap.SetOrigin(aNewOrigin);
/*N*/ 		SetMapMode(aMap);
/*N*/ 
/*N*/ 		if ( bChanged && bInvalidate )
/*N*/ 			Invalidate();
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* X-Position des sichtbaren Bereichs als Bruchteil (< 1)
|* der gesamten Arbeitsbereichbreite zuruegeben
|*
\************************************************************************/

/*N*/ double SdWindow::GetVisibleX()
/*N*/ {
/*N*/ 	return ((double) aWinPos.X() / aViewSize.Width());
/*N*/ }

/*************************************************************************
|*
|* Y-Position des sichtbaren Bereichs als Bruchteil (< 1)
|* der gesamten Arbeitsbereichhoehe zuruegeben
|*
\************************************************************************/

/*N*/ double SdWindow::GetVisibleY()
/*N*/ {
/*N*/ 	return ((double) aWinPos.Y() / aViewSize.Height());
/*N*/ }

/*************************************************************************
|*
|* X- und Y-Position des sichtbaren Bereichs als Bruchteile (< 1)
|* der gesamten Arbeitsbereichgroesse setzen
|* negative Werte werden ignoriert
|*
\************************************************************************/

//STRIP001 void SdWindow::SetVisibleXY(double fX, double fY)
//STRIP001 {
//STRIP001 	long nOldX = aWinPos.X();
//STRIP001 	long nOldY = aWinPos.Y();
//STRIP001 
//STRIP001 	if ( fX >= 0 )
//STRIP001 		aWinPos.X() = (long) (fX * aViewSize.Width());
//STRIP001 	if ( fY >= 0 )
//STRIP001 		aWinPos.Y() = (long) (fY * aViewSize.Height());
//STRIP001 	UpdateMapOrigin(FALSE);
//STRIP001 	Size sz(nOldX - aWinPos.X(), nOldY - aWinPos.Y());
//STRIP001 	sz = LogicToPixel(sz);
//STRIP001 	Scroll(nOldX - aWinPos.X(), nOldY - aWinPos.Y(), SCROLL_CHILDREN);
//STRIP001 	Update();
//STRIP001 }

/*************************************************************************
|*
|* Breite des sichtbaren Bereichs im Verhaeltnis zur
|* gesamten Arbeitsbereichbreite zuruegeben
|*
\************************************************************************/

/*N*/ double SdWindow::GetVisibleWidth()
/*N*/ {
/*N*/ 	Size aWinSize = PixelToLogic(GetOutputSizePixel());
/*N*/ 	if ( aWinSize.Width() > aViewSize.Width() )
/*N*/ 		aWinSize.Width() = aViewSize.Width();
/*N*/ 	return ((double) aWinSize.Width() / aViewSize.Width());
/*N*/ }

/*************************************************************************
|*
|* Hoehe des sichtbaren Bereichs im Verhaeltnis zur
|* gesamten Arbeitsbereichhoehe zuruegeben
|*
\************************************************************************/

/*N*/ double SdWindow::GetVisibleHeight()
/*N*/ {
/*N*/ 	Size aWinSize = PixelToLogic(GetOutputSizePixel());
/*N*/ 	if ( aWinSize.Height() > aViewSize.Height() )
/*N*/ 		aWinSize.Height() = aViewSize.Height();
/*N*/ 	return ((double) aWinSize.Height() / aViewSize.Height());
/*N*/ }

/*************************************************************************
|*
|* Breite einer Scrollspalte im Verhaeltnis zur gesamten
|* Arbeitsbereichbreite zuruegeben
|*
\************************************************************************/

/*N*/ double SdWindow::GetScrlLineWidth()
/*N*/ {
/*N*/ 	return (GetVisibleWidth() * SCROLL_LINE_FACT);
/*N*/ }

/*************************************************************************
|*
|* Breite einer Scrollspalte im Verhaeltnis zur gesamten
|* Arbeitsbereichhoehe zuruegeben
|*
\************************************************************************/

/*N*/ double SdWindow::GetScrlLineHeight()
/*N*/ {
/*N*/ 	return (GetVisibleHeight() * SCROLL_LINE_FACT);
/*N*/ }

/*************************************************************************
|*
|* Breite einer Scrollpage im Verhaeltnis zur gesamten
|* Arbeitsbereichbreite zuruegeben
|*
\************************************************************************/

/*N*/ double SdWindow::GetScrlPageWidth()
/*N*/ {
/*N*/ 	return (GetVisibleWidth() * SCROLL_PAGE_FACT);
/*N*/ }

/*************************************************************************
|*
|* Breite einer Scrollpage im Verhaeltnis zur gesamten
|* Arbeitsbereichhoehe zuruegeben
|*
\************************************************************************/

/*N*/ double SdWindow::GetScrlPageHeight()
/*N*/ {
/*N*/ 	return (GetVisibleHeight() * SCROLL_PAGE_FACT);
/*N*/ }

/*************************************************************************
|*
|* Scrolling bei AcceptDrop-Events
|*
\************************************************************************/

//STRIP001 void SdWindow::DropScroll(const Point& rMousePos)
//STRIP001 {
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 
//STRIP001 	short nDx = 0;
//STRIP001 	short nDy = 0;
//STRIP001 
//STRIP001 	Size aSize = GetOutputSizePixel();
//STRIP001 
//STRIP001 	if (aSize.Width() > SCROLL_SENSITIVE * 3)
//STRIP001 	{
//STRIP001 		if ( rMousePos.X() < SCROLL_SENSITIVE )
//STRIP001 		{
//STRIP001 			nDx = -1;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( rMousePos.X() >= aSize.Width() - SCROLL_SENSITIVE )
//STRIP001 		{
//STRIP001 			nDx = 1;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (aSize.Height() > SCROLL_SENSITIVE * 3)
//STRIP001 	{
//STRIP001 		if ( rMousePos.Y() < SCROLL_SENSITIVE )
//STRIP001 		{
//STRIP001 			nDy = -1;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( rMousePos.Y() >= aSize.Height() - SCROLL_SENSITIVE )
//STRIP001 		{
//STRIP001 			nDy = 1;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( (nDx || nDy) && (rMousePos.X()!=0 || rMousePos.Y()!=0 ) )
//STRIP001 	{
//STRIP001 				if (nTicks > 20) pViewShell->ScrollLines(nDx, nDy);
//STRIP001 		else nTicks ++;
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Fenster deaktivieren
|*
\************************************************************************/

/*N*/ void SdWindow::LoseFocus()
/*N*/ {
/*N*/ 	nTicks = 0;
/*N*/ 		Window::LoseFocus ();
/*N*/ }

/*************************************************************************
|*
|* Fenster aktivieren
|*
\************************************************************************/

//STRIP001 void SdWindow::GrabFocus()
//STRIP001 {
//STRIP001 	nTicks		 = 0;
//STRIP001 		Window::GrabFocus ();
//STRIP001 }


/*************************************************************************
|*
|* DataChanged
|*
\************************************************************************/

//STRIP001 void SdWindow::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	Window::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	// PRINTER bei allen Dokumenten weglassen, die keinen Printer benutzen.
//STRIP001 	// FONTS und FONTSUBSTITUTION weglassen, wenn keine Textausgaben
//STRIP001 	// vorhanden sind, bzw. wenn das Dokument keinen Text zulaesst.
//STRIP001 
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_PRINTER) ||
//STRIP001 		 (rDCEvt.GetType() == DATACHANGED_DISPLAY) ||
//STRIP001 		 (rDCEvt.GetType() == DATACHANGED_FONTS) ||
//STRIP001 		 (rDCEvt.GetType() == DATACHANGED_FONTSUBSTITUTION) ||
//STRIP001 		 ((rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001 		  (rDCEvt.GetFlags() & SETTINGS_STYLE)) )
//STRIP001 	{
//STRIP001 		if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001 			 (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001 		{
//STRIP001             // When the screen zoom factor has changed then reset the zoom
//STRIP001             // factor of the frame to allways display the whole page.
//STRIP001             const AllSettings* pOldSettings = rDCEvt.GetOldSettings ();
//STRIP001             const AllSettings& rNewSettings = GetSettings ();
//STRIP001             if (pOldSettings)
//STRIP001                 if (pOldSettings->GetStyleSettings().GetScreenZoom() 
//STRIP001                     != rNewSettings.GetStyleSettings().GetScreenZoom())
//STRIP001                     pViewShell->GetViewFrame()->GetDispatcher()->
//STRIP001                         Execute(SID_SIZE_PAGE, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 
//STRIP001 			// ScrollBars neu anordnen bzw. Resize ausloesen, da sich
//STRIP001 			// ScrollBar-Groesse geaendert haben kann. Dazu muss dann im
//STRIP001 			// Resize-Handler aber auch die Groesse der ScrollBars aus
//STRIP001 			// den Settings abgefragt werden.
//STRIP001 			Resize();
//STRIP001             
//STRIP001 			// Daten neu Setzen, die aus den Systemeinstellungen bzw. aus
//STRIP001 			// den Settings uebernommen werden. Evtl. weitere Daten neu
//STRIP001 			// berechnen, da sich auch die Aufloesung hierdurch geaendert
//STRIP001 			// haben kann.
//STRIP001             if( pViewShell )
//STRIP001             {
//STRIP001 				const StyleSettings&    rStyleSettings = GetSettings().GetStyleSettings();
//STRIP001 				SvtAccessibilityOptions aAccOptions;
//STRIP001 		        ULONG                   nOutputMode;
//STRIP001 			    USHORT                  nPreviewSlot;
//STRIP001 
//STRIP001 				if( rStyleSettings.GetHighContrastMode() )
//STRIP001 					nOutputMode = OUTPUT_DRAWMODE_CONTRAST;
//STRIP001 				else
//STRIP001 					nOutputMode = OUTPUT_DRAWMODE_COLOR;
//STRIP001 
//STRIP001 				if( rStyleSettings.GetHighContrastMode() && aAccOptions.GetIsForPagePreviews() )
//STRIP001 					nPreviewSlot = SID_PREVIEW_QUALITY_CONTRAST;
//STRIP001 				else
//STRIP001 					nPreviewSlot = SID_PREVIEW_QUALITY_COLOR;
//STRIP001 
//STRIP001                 if( pViewShell->ISA( SdDrawViewShell ) )
//STRIP001                 {
//STRIP001 			        SetDrawMode( nOutputMode );
//STRIP001                     pViewShell->GetFrameView()->SetDrawMode( nOutputMode );
//STRIP001 			        pViewShell->GetView()->ReleaseMasterPagePaintCache();
//STRIP001 			        Invalidate();
//STRIP001                 }
//STRIP001 
//STRIP001                 // #103100# Overwrite window color for OutlineView
//STRIP001                 if( pViewShell->ISA( SdOutlineViewShell ) )
//STRIP001                 {
//STRIP001                     svtools::ColorConfig aColorConfig;
//STRIP001                     const Color aDocColor( aColorConfig.GetColorValue( svtools::DOCCOLOR ).nColor );
//STRIP001 					SetBackground( Wallpaper( aDocColor ) );
//STRIP001                 }
//STRIP001 
//STRIP001                 SfxRequest aReq( nPreviewSlot, 0, pViewShell->GetDocSh()->GetDoc()->GetItemPool() );
//STRIP001                 pViewShell->ExecReq( aReq );
//STRIP001 				pViewShell->Invalidate();
//STRIP001                 pViewShell->ArrangeGUIElements();
//STRIP001 				
//STRIP001 				// #101928# re-create handles to show new outfit
//STRIP001 				if(pViewShell->ISA(SdDrawViewShell))
//STRIP001 				{
//STRIP001 					pViewShell->GetView()->AdjustMarkHdl();
//STRIP001 				}
//STRIP001             }
//STRIP001         }
//STRIP001 
//STRIP001 		if ( (rDCEvt.GetType() == DATACHANGED_DISPLAY) ||
//STRIP001 			 ((rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001 			  (rDCEvt.GetFlags() & SETTINGS_STYLE)) )
//STRIP001 		{
//STRIP001 			// Virtuelle Device die auch von der Aufloesung oder von
//STRIP001 			// Systemeinstellungen abhaengen, sollten geupdatet werden.
//STRIP001 			// Ansonsten sollte zumindest bei DATACHANGED_DISPLAY
//STRIP001 			// die virtuellen Devices geupdatet werden, da es einige
//STRIP001 			// Systeme erlauben die Aufloesung und Farbtiefe waehrend
//STRIP001 			// der Laufzeit zu aendern oder eben bei Palettenaenderungen
//STRIP001 			// die virtuellen Device geupdatet werden muessen, da bei
//STRIP001 			// Ausgaben ein anderes Farbmatching stattfinden kann.
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( rDCEvt.GetType() == DATACHANGED_FONTS )
//STRIP001 		{
//STRIP001 			// Wenn das Dokument Font-AuswahlBoxen anbietet, muessen
//STRIP001 			// diese geupdatet werden. Wie dies genau aussehen muss,
//STRIP001 			// weiss ich leider auch nicht. Aber evtl. kann man das
//STRIP001 			// ja global handeln. Dies muessten wir evtl. mal
//STRIP001 			// mit PB absprechen, aber der ist derzeit leider Krank.
//STRIP001 			// Also bevor dies hier gehandelt wird, vorher mit
//STRIP001 			// PB und mir absprechen.
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( (rDCEvt.GetType() == DATACHANGED_FONTS) ||
//STRIP001 			 (rDCEvt.GetType() == DATACHANGED_FONTSUBSTITUTION) )
//STRIP001 		{
//STRIP001 			// Formatierung neu durchfuehren, da Fonts die im Dokument
//STRIP001 			// vorkommen, nicht mehr vorhanden sein muessen oder
//STRIP001 			// jetzt vorhanden sind oder durch andere ersetzt wurden
//STRIP001 			// sind.
//STRIP001 			if( pViewShell )
//STRIP001 			{
//STRIP001 				SdDrawDocShell* pDocSh = pViewShell->GetDocSh();
//STRIP001 				if( pDocSh )
//STRIP001 					pDocSh->SetPrinter( pDocSh->GetPrinter( TRUE ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( rDCEvt.GetType() == DATACHANGED_PRINTER )
//STRIP001 		{
//STRIP001 			// Wie hier die Behandlung aussehen soll, weiss ich leider
//STRIP001 			// selbst noch nicht. Evtl. mal einen Printer loeschen und
//STRIP001 			// schauen was gemacht werden muss. Evtl. muesste ich in
//STRIP001 			// VCL dafuer noch etwas einbauen, wenn der benutze Printer
//STRIP001 			// geloescht wird. Ansonsten wuerde ich hier evtl. die
//STRIP001 			// Formatierung neu berechnen, wenn der aktuelle Drucker
//STRIP001 			// zerstoert wurde.
//STRIP001 			if( pViewShell )
//STRIP001 			{
//STRIP001 				SdDrawDocShell* pDocSh = pViewShell->GetDocSh();
//STRIP001 				if( pDocSh )
//STRIP001 					pDocSh->SetPrinter( pDocSh->GetPrinter( TRUE ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		// Alles neu ausgeben
//STRIP001 		Invalidate();
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* DropTargetHelper::AcceptDrop
|*
\************************************************************************/

//STRIP001 sal_Int8 SdWindow::AcceptDrop( const AcceptDropEvent& rEvt )
//STRIP001 {
//STRIP001 	sal_Int8 nRet = DND_ACTION_NONE;
//STRIP001 
//STRIP001 	if( pViewShell && !pViewShell->GetDocSh()->IsReadOnly() )
//STRIP001 	{
//STRIP001 		if( pViewShell )
//STRIP001 			nRet = pViewShell->AcceptDrop( rEvt, *this, this, SDRPAGE_NOTFOUND, SDRLAYER_NOTFOUND );
//STRIP001 
//STRIP001 		if( !pViewShell->ISA( SdOutlineViewShell ) )
//STRIP001 			DropScroll( rEvt.maPosPixel );
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }

/*************************************************************************
|*
|* DropTargetHelper::ExecuteDrop
|*
\************************************************************************/

//STRIP001 sal_Int8 SdWindow::ExecuteDrop( const ExecuteDropEvent& rEvt )
//STRIP001 {
//STRIP001 	sal_Int8 nRet = DND_ACTION_NONE;
//STRIP001 
//STRIP001 	if( pViewShell )
//STRIP001 	{
//STRIP001 		nRet = pViewShell->ExecuteDrop( rEvt, *this, this, SDRPAGE_NOTFOUND, SDRLAYER_NOTFOUND );
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }




//STRIP001 ::com::sun::star::uno::Reference<
//STRIP001     ::com::sun::star::accessibility::XAccessible>
//STRIP001     SdWindow::CreateAccessible (void)
//STRIP001 {
//STRIP001     if (pViewShell != NULL)
//STRIP001 	return pViewShell->CreateAccessibleDocumentView (this);
//STRIP001     else
//STRIP001     {
//STRIP001         OSL_TRACE ("SdWindow::CreateAccessible: no view shell");
//STRIP001 	return Window::CreateAccessible ();
//STRIP001     }
//STRIP001 }

}
