/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_drviewsb.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:38:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_UI_DIALOGS_XEXECUTABLEDIALOG_HPP_
#include <com/sun/star/ui/dialogs/XExecutableDialog.hpp>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#ifndef _SVDLAYER_HXX
#include <bf_svx/svdlayer.hxx>
#endif
#ifndef _SVXIDS_HXX
#include <bf_svx/svxids.hrc>
#endif
#define ITEMID_HYPERLINK    SID_HYPERLINK_SETLINK
#ifndef _SVX_DLG_HYPERLINK_HXX
#include <bf_offmgr/hyprlink.hxx>
#endif
#ifndef _SVX_HLNKITEM_HXX
#include <bf_svx/hlnkitem.hxx>
#endif
#ifndef _SVX_ADRITEM_HXX
#include <bf_svx/adritem.hxx>
#endif
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _EEITEM_HXX //autogen
#include <bf_svx/eeitem.hxx>
#endif

#ifndef _PSTM_HXX
#include <tools/pstm.hxx>
#endif

#ifndef _SFXPOOLITEM_HXX
#include <svtools/poolitem.hxx>
#endif

#ifndef _SVX_ITEMDATA_HXX
#include <bf_svx/itemdata.hxx>
#endif

#ifndef _DATE_HXX
#include <tools/date.hxx>
#endif

#ifndef _TOOLS_TIME_HXX
#include <tools/time.hxx>
#endif

#define ITEMID_FIELD    EE_FEATURE_FIELD
#ifndef _FLDITEM_HXX
#include <bf_svx/flditem.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
#ifndef _SVDORECT_HXX //autogen
#include <bf_svx/svdorect.hxx>
#endif
#ifndef _SFXDOCFILE_HXX //autogen
#include <bf_sfx2/docfile.hxx>
#endif
#ifndef _SB_SBSTAR_HXX //autogen
#include <basic/sbstar.hxx>
#endif
#ifndef _SB_SBERRORS_HXX //autogen
#include <basic/sberrors.hxx>
#endif
#ifndef _SVX_FMSHELL_HXX
#include <bf_svx/fmshell.hxx>
#endif
#ifndef _SVX_DLG_NAME_HXX
#include <bf_svx/dlgname.hxx>
#endif

#pragma hdrstop

#include "app.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"
#include "glob.hrc"

#include "sdoutl.hxx"
#include "sdwindow.hxx"
#include "app.hxx"
#include "sdattr.hxx"
#include "ins_page.hxx"
#include "drawdoc.hxx"
#include "docshell.hxx"
#include "sdresid.hxx"
#include "sdpage.hxx"
#include "drviewsh.hxx"
#include "dlgfield.hxx"
#include "drawview.hxx"
#include "unmodpg.hxx"
#include "undolayer.hxx"

#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
namespace binfilter {

/*************************************************************************
|*
|* SfxRequests fuer temporaere Funktionen
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::FuTemp02(SfxRequest& rReq)
/*N*/ {
/*N*/ 	USHORT nSId = rReq.GetSlot();
/*N*/ 	switch( nSId )
/*N*/ 	{
/*?*/ 		case SID_INSERTLAYER:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pDrView->IsTextEdit() )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				pDrView->EndTextEdit();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			SdrLayerAdmin& rLayerAdmin = pDoc->GetLayerAdmin();
//STRIP001 /*?*/ 			USHORT nLayerCnt = rLayerAdmin.GetLayerCount();
//STRIP001 /*?*/ 			USHORT nLayer = nLayerCnt - 2 + 1;
//STRIP001 /*?*/ 			String aLayerName ( SdResId(STR_LAYER) );
//STRIP001 /*?*/ 			aLayerName += String::CreateFromInt32( (sal_Int32)nLayer );
//STRIP001 /*?*/ 			BOOL bIsVisible;
//STRIP001 /*?*/ 			BOOL bIsLocked;
//STRIP001 /*?*/ 			BOOL bIsPrintable;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			const SfxItemSet* pArgs = rReq.GetArgs();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if (! pArgs)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				SfxItemSet aNewAttr( pDoc->GetPool(), ATTR_LAYER_START, ATTR_LAYER_END );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				aNewAttr.Put( SdAttrLayerName( aLayerName ) );
//STRIP001 /*?*/ 				aNewAttr.Put( SdAttrLayerVisible() );
//STRIP001 /*?*/ 				aNewAttr.Put( SdAttrLayerPrintable() );
//STRIP001 /*?*/ 				aNewAttr.Put( SdAttrLayerLocked() );
//STRIP001 /*?*/ 				aNewAttr.Put( SdAttrLayerThisPage() );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				SdInsertLayerDlg* pDlg = new SdInsertLayerDlg( NULL, aNewAttr );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				pDlg->SetHelpId( SID_INSERTLAYER );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				// Ueberpruefung auf schon vorhandene Namen
//STRIP001 /*?*/ 				BOOL bLoop = TRUE;
//STRIP001 /*?*/ 				while( bLoop && pDlg->Execute() == RET_OK )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					pDlg->GetAttr( aNewAttr );
//STRIP001 /*?*/ 					aLayerName	 = ((SdAttrLayerName &) aNewAttr.Get (ATTR_LAYER_NAME)).GetValue ();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if( rLayerAdmin.GetLayer( aLayerName, FALSE )
//STRIP001 /*?*/ 						|| aLayerName.Len()==0 )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						// Name ist schon vorhanden
//STRIP001 /*?*/ 						WarningBox aWarningBox( &GetViewFrame()->GetWindow(),
//STRIP001 /*?*/ 												WinBits( WB_OK ),
//STRIP001 /*?*/ 												String(SdResId( STR_WARN_NAME_DUPLICATE ) ) );
//STRIP001 /*?*/ 						aWarningBox.Execute();
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 						bLoop = FALSE;
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				if( bLoop ) // wurde abgebrochen
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					delete pDlg;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					Cancel();
//STRIP001 /*?*/ 					rReq.Ignore ();
//STRIP001 /*?*/ 					break;
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				else
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					//pDlg->GetAttr( aNewAttr );
//STRIP001 /*?*/ 					//aLayerName	 = ((SdAttrLayerName &) aNewAttr.Get (ATTR_LAYER_NAME)).GetValue ();
//STRIP001 /*?*/ 					bIsVisible	 = ((SdAttrLayerVisible &) aNewAttr.Get (ATTR_LAYER_VISIBLE)).GetValue ();
//STRIP001 /*?*/ 					bIsLocked	 = ((SdAttrLayerLocked &) aNewAttr.Get (ATTR_LAYER_LOCKED)).GetValue () ;
//STRIP001 /*?*/ 					bIsPrintable = ((SdAttrLayerPrintable &) aNewAttr.Get (ATTR_LAYER_PRINTABLE)).GetValue () ;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					delete pDlg;
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else if (pArgs->Count () != 4)
//STRIP001 /*?*/ 				 {
//STRIP001 /*?*/ 					 StarBASIC::FatalError (SbERR_WRONG_ARGS);
//STRIP001 /*?*/ 					 Cancel();
//STRIP001 /*?*/ 					 rReq.Ignore ();
//STRIP001 /*?*/ 					 break;
//STRIP001 /*?*/ 				 }
//STRIP001 /*?*/ 				 else
//STRIP001 /*?*/ 				 {
//STRIP001 /*?*/ 					 SFX_REQUEST_ARG (rReq, pLayerName, SfxStringItem, ID_VAL_LAYERNAME, FALSE);
//STRIP001 /*?*/ 					 SFX_REQUEST_ARG (rReq, pIsVisible, SfxBoolItem, ID_VAL_ISVISIBLE, FALSE);
//STRIP001 /*?*/ 					 SFX_REQUEST_ARG (rReq, pIsLocked, SfxBoolItem, ID_VAL_ISLOCKED, FALSE);
//STRIP001 /*?*/ 					 SFX_REQUEST_ARG (rReq, pIsPrintable, SfxBoolItem, ID_VAL_ISPRINTABLE, FALSE);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					 aLayerName   = pLayerName->GetValue ();
//STRIP001 /*?*/ 					 bIsVisible   = pIsVisible->GetValue ();
//STRIP001 /*?*/ 					 bIsLocked	  = pIsLocked->GetValue ();
//STRIP001 /*?*/ 					 bIsPrintable = pIsPrintable->GetValue ();
//STRIP001 /*?*/ 				 }
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			String aPrevLayer = pDrView->GetActiveLayer();
//STRIP001 /*?*/ 			String aName;
//STRIP001 /*?*/ 			SdrLayer* pLayer;
//STRIP001 /*?*/ 			USHORT nPrevLayer = 0;
//STRIP001 /*?*/ 			nLayerCnt = rLayerAdmin.GetLayerCount();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			for ( nLayer = 0; nLayer < nLayerCnt; nLayer++ )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				pLayer = rLayerAdmin.GetLayer(nLayer);
//STRIP001 /*?*/ 				aName = pLayer->GetName();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if ( aPrevLayer == aName )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ //                    nPrevLayer = nLayer;
//STRIP001 /*?*/ 					nPrevLayer = Max(nLayer, (USHORT) 4);
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			SdrLayer* pNewLayer = pDrView->InsertNewLayer(aLayerName, nPrevLayer + 1);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			pDrView->SetLayerVisible( aLayerName, bIsVisible );
//STRIP001 /*?*/ 			pDrView->SetLayerLocked( aLayerName, bIsLocked);
//STRIP001 /*?*/ 			pDrView->SetLayerPrintable(aLayerName, bIsPrintable);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			pDrView->SetActiveLayer(aLayerName);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			ResetActualLayer();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			pDoc->SetChanged(TRUE);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			GetViewFrame()->GetDispatcher()->Execute(SID_SWITCHLAYER,
//STRIP001 /*?*/ 					SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_MODIFYLAYER:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pDrView->IsTextEdit() )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				pDrView->EndTextEdit();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			SdrLayerAdmin& rLayerAdmin = pDoc->GetLayerAdmin();
//STRIP001 /*?*/ 			USHORT nCurPage = aLayerTab.GetCurPageId();
//STRIP001 /*?*/ 			String aLayerName = aLayerTab.GetPageText(nCurPage);
//STRIP001 /*?*/ 			String aOldLayerName( aLayerName );
//STRIP001 /*?*/ 			SdrLayer* pLayer = rLayerAdmin.GetLayer(aLayerName, FALSE);
//STRIP001 /*?*/ 			const SfxItemSet* pArgs = rReq.GetArgs();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			BOOL bIsVisible;
//STRIP001 /*?*/ 			BOOL bIsLocked;
//STRIP001 /*?*/ 			BOOL bIsPrintable;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			 // darf der Layer geloescht werden ?
//STRIP001 /*?*/ 			BOOL bDelete;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			String aLayoutLayer ( SdResId(STR_LAYER_LAYOUT) );
//STRIP001 /*?*/ 			String aControlsLayer ( SdResId(STR_LAYER_CONTROLS) );
//STRIP001 /*?*/ 			String aMeasureLinesLayer ( SdResId(STR_LAYER_MEASURELINES) );
//STRIP001 /*?*/ 			String aBackgroundLayer( SdResId(STR_LAYER_BCKGRND) );
//STRIP001 /*?*/ 			String aBackgroundObjLayer( SdResId(STR_LAYER_BCKGRNDOBJ) );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if( aLayerName == aLayoutLayer       || aLayerName == aControlsLayer ||
//STRIP001 /*?*/ 				aLayerName == aMeasureLinesLayer ||
//STRIP001 /*?*/ 				aLayerName == aBackgroundLayer   || aLayerName == aBackgroundObjLayer )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				bDelete = FALSE;
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 				bDelete = TRUE;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if (! pArgs)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				SfxItemSet aNewAttr( pDoc->GetPool(), ATTR_LAYER_START, ATTR_LAYER_END );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				aNewAttr.Put( SdAttrLayerName( aLayerName ) );
//STRIP001 /*?*/ 				aNewAttr.Put( SdAttrLayerVisible( pDrView->IsLayerVisible(aLayerName) ) );
//STRIP001 /*?*/ 				aNewAttr.Put( SdAttrLayerLocked( pDrView->IsLayerLocked(aLayerName) ) );
//STRIP001 /*?*/ 				aNewAttr.Put( SdAttrLayerPrintable( pDrView->IsLayerPrintable(aLayerName) ) );
//STRIP001 /*?*/ 				aNewAttr.Put( SdAttrLayerThisPage() );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				SdInsertLayerDlg* pDlg = new SdInsertLayerDlg( NULL,
//STRIP001 /*?*/ 												aNewAttr, bDelete, String( SdResId( STR_MODIFYLAYER ) ) );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				pDlg->SetHelpId( SID_MODIFYLAYER );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				// Ueberpruefung auf schon vorhandene Namen
//STRIP001 /*?*/ 				BOOL	bLoop = TRUE;
//STRIP001 /*?*/ 				USHORT	nRet;
//STRIP001 /*?*/ 				String	aOldLayerName( aLayerName );
//STRIP001 /*?*/ 				while( bLoop && ( nRet = pDlg->Execute() == RET_OK ) )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					pDlg->GetAttr( aNewAttr );
//STRIP001 /*?*/ 					aLayerName	 = ((SdAttrLayerName &) aNewAttr.Get (ATTR_LAYER_NAME)).GetValue ();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if( (rLayerAdmin.GetLayer( aLayerName, FALSE ) &&
//STRIP001 /*?*/ 						 aLayerName != aOldLayerName) || aLayerName.Len()==0 )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						// Name ist schon vorhanden
//STRIP001 /*?*/ 						WarningBox aWarningBox( &GetViewFrame()->GetWindow(),
//STRIP001 /*?*/ 												WinBits( WB_OK ),
//STRIP001 /*?*/ 												String( SdResId( STR_WARN_NAME_DUPLICATE ) ) );
//STRIP001 /*?*/ 						aWarningBox.Execute();
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 						bLoop = FALSE;
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				switch (nRet)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					case RET_OK :
//STRIP001 /*?*/ 						//pDlg->GetAttr( aNewAttr );
//STRIP001 /*?*/ 						//aLayerName   = ((SdAttrLayerName &) aNewAttr.Get (ATTR_LAYER_NAME)).GetValue ();
//STRIP001 /*?*/ 						bIsVisible	 = ((const SdAttrLayerVisible &) aNewAttr.Get (ATTR_LAYER_VISIBLE)).GetValue ();
//STRIP001 /*?*/ 						bIsLocked	 = ((const SdAttrLayerLocked &) aNewAttr.Get (ATTR_LAYER_LOCKED)).GetValue ();
//STRIP001 /*?*/ 						bIsPrintable = ((const SdAttrLayerLocked &) aNewAttr.Get (ATTR_LAYER_PRINTABLE)).GetValue ();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						delete pDlg;
//STRIP001 /*?*/ 						break;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					case RET_DELETE :
//STRIP001 /*?*/ 						pDrView->DeleteLayer (((SdAttrLayerName &) aNewAttr.Get (ATTR_LAYER_NAME)).GetValue ());
//STRIP001 /*?*/ 						aLayerTab.RemovePage(nCurPage);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					default :
//STRIP001 /*?*/ 						delete pDlg;
//STRIP001 /*?*/ 						rReq.Ignore ();
//STRIP001 /*?*/ 						Cancel ();
//STRIP001 /*?*/ 						return;
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else if (pArgs->Count () == 4)
//STRIP001 			{
//STRIP001 				SFX_REQUEST_ARG (rReq, pLayerName, SfxStringItem, ID_VAL_LAYERNAME, FALSE);
//STRIP001 				SFX_REQUEST_ARG (rReq, pIsVisible, SfxBoolItem, ID_VAL_ISVISIBLE, FALSE);
//STRIP001 				SFX_REQUEST_ARG (rReq, pIsLocked, SfxBoolItem, ID_VAL_ISLOCKED, FALSE);
//STRIP001 				SFX_REQUEST_ARG (rReq, pIsPrintable, SfxBoolItem, ID_VAL_ISPRINTABLE, FALSE);
//STRIP001 
//STRIP001 				aLayerName   = pLayerName->GetValue ();
//STRIP001 				bIsVisible   = pIsVisible->GetValue ();
//STRIP001 				bIsLocked	  = pIsLocked->GetValue ();
//STRIP001 				bIsPrintable = pIsPrintable->GetValue ();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				StarBASIC::FatalError (SbERR_WRONG_ARGS);
//STRIP001 				Cancel ();
//STRIP001 				rReq.Ignore ();
//STRIP001 				break;
//STRIP001 			}
//STRIP001 
//STRIP001 			SfxUndoManager* pManager = pDoc->GetDocSh()->GetUndoManager();
//STRIP001 			SdLayerModifyUndoAction* pAction = new SdLayerModifyUndoAction(
//STRIP001 				pDoc,
//STRIP001 				pLayer,
//STRIP001 				// old values
//STRIP001 				aOldLayerName,
//STRIP001 				pDrView->IsLayerVisible(aOldLayerName),
//STRIP001 				pDrView->IsLayerLocked(aOldLayerName),
//STRIP001 				pDrView->IsLayerPrintable(aOldLayerName),
//STRIP001 				// new values
//STRIP001 				aLayerName,
//STRIP001 				bIsVisible,
//STRIP001 				bIsLocked,
//STRIP001 				bIsPrintable
//STRIP001 				);
//STRIP001 			pManager->AddUndoAction( pAction );
//STRIP001 
//STRIP001 			ModifyLayer( pLayer, aLayerName, bIsVisible, bIsLocked, bIsPrintable );
//STRIP001 
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_RENAMELAYER:
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 			if ( pDrView->IsTextEdit() )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				pDrView->EndTextEdit();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			aLayerTab.StartEditMode( aLayerTab.GetCurPageId() );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_EDIT_HYPERLINK :
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 GetViewFrame()->GetDispatcher()->Execute( SID_HYPERLINK_DIALOG );
/*?*/ 
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/         case SID_OPEN_HYPERLINK:
/*?*/         {
/*?*/             DBG_BF_ASSERT(0, "STRIP"); //STRIP001 OutlinerView* pOutView = pDrView->GetTextEditOutlinerView();
//STRIP001 /*?*/             if ( pOutView )
//STRIP001 /*?*/             {
//STRIP001 /*?*/                 const SvxFieldItem* pFieldItem = pOutView->GetFieldAtSelection();
//STRIP001 /*?*/                 if ( pFieldItem )
//STRIP001 /*?*/                 {
//STRIP001 /*?*/                     const SvxFieldData* pField = pFieldItem->GetField();
//STRIP001 /*?*/                     if( pField && pField->ISA( SvxURLField ) )
//STRIP001 /*?*/                     {
//STRIP001 /*?*/                         const SvxURLField* pURLField = static_cast< const SvxURLField* >( pField );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						SfxStringItem aUrl( SID_FILE_NAME, pURLField->GetURL() );
//STRIP001 /*?*/ 						SfxStringItem aTarget( SID_TARGETNAME, pURLField->GetTargetFrame() );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						String aReferName;
//STRIP001 /*?*/ 						SfxViewFrame* pFrame = GetViewFrame();
//STRIP001 /*?*/ 						SfxMedium* pMed = pFrame->GetObjectShell()->GetMedium();
//STRIP001 /*?*/ 						if (pMed)
//STRIP001 /*?*/ 							aReferName = pMed->GetName();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						SfxFrameItem aFrm( SID_DOCFRAME, pFrame );
//STRIP001 /*?*/ 						SfxStringItem aReferer( SID_REFERER, aReferName );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						SfxBoolItem aNewView( SID_OPEN_NEW_VIEW, FALSE );
//STRIP001 /*?*/ 						SfxBoolItem aBrowsing( SID_BROWSE, TRUE );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						SfxViewFrame* pViewFrm = SfxViewFrame::Current();
//STRIP001 /*?*/ 						if (pViewFrm)
//STRIP001 /*?*/ 							pViewFrm->GetDispatcher()->Execute( SID_OPENDOC,
//STRIP001 /*?*/ 														SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD,
//STRIP001 /*?*/ 														&aUrl, &aTarget,
//STRIP001 /*?*/ 														&aFrm, &aReferer,
//STRIP001 /*?*/ 														&aNewView, &aBrowsing,
//STRIP001 /*?*/ 														0L );
//STRIP001 /*?*/                     }
//STRIP001 /*?*/                 }
//STRIP001 /*?*/             }
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Done ();
/*?*/         }
/*?*/         break;

/*?*/ 		case SID_HYPERLINK_SETLINK:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 const SfxItemSet* pReqArgs = rReq.GetArgs();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if (pReqArgs)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				SvxHyperlinkItem* pHLItem =
//STRIP001 /*?*/ 				(SvxHyperlinkItem*) &pReqArgs->Get(ITEMID_HYPERLINK);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if (pHLItem->GetInsertMode() == HLINK_FIELD)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					InsertURLField(pHLItem->GetURL(), pHLItem->GetName(),
//STRIP001 /*?*/ 								   pHLItem->GetTargetFrame(), NULL);
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				else if (pHLItem->GetInsertMode() == HLINK_BUTTON)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					InsertURLButton(pHLItem->GetURL(), pHLItem->GetName(),
//STRIP001 /*?*/ 									pHLItem->GetTargetFrame(), NULL);
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				else if (pHLItem->GetInsertMode() == HLINK_DEFAULT)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					OutlinerView* pOlView = pDrView->GetTextEditOutlinerView();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if (pOlView)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						InsertURLField(pHLItem->GetURL(), pHLItem->GetName(),
//STRIP001 /*?*/ 									   pHLItem->GetTargetFrame(), NULL);
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						InsertURLButton(pHLItem->GetURL(), pHLItem->GetName(),
//STRIP001 /*?*/ 										pHLItem->GetTargetFrame(), NULL);
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_INSERT_FLD_DATE_FIX:
/*?*/ 		case SID_INSERT_FLD_DATE_VAR:
/*?*/ 		case SID_INSERT_FLD_TIME_FIX:
/*?*/ 		case SID_INSERT_FLD_TIME_VAR:
/*?*/ 		case SID_INSERT_FLD_AUTHOR:
/*?*/ 		case SID_INSERT_FLD_PAGE:
/*?*/ 		case SID_INSERT_FLD_FILE:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 USHORT nMul = 1;
//STRIP001 /*?*/ 			SvxFieldItem* pFieldItem;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			switch( nSId )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				case SID_INSERT_FLD_DATE_FIX:
//STRIP001 /*?*/ 					pFieldItem = new SvxFieldItem(
//STRIP001 /*?*/ 						SvxDateField( Date(), SVXDATETYPE_FIX ) );
//STRIP001 /*?*/ 				break;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				case SID_INSERT_FLD_DATE_VAR:
//STRIP001 /*?*/ 					pFieldItem = new SvxFieldItem( SvxDateField() );
//STRIP001 /*?*/ 				break;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				case SID_INSERT_FLD_TIME_FIX:
//STRIP001 /*?*/ 					pFieldItem = new SvxFieldItem(
//STRIP001 /*?*/ 						SvxExtTimeField( Time(), SVXTIMETYPE_FIX ) );
//STRIP001 /*?*/ 				break;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				case SID_INSERT_FLD_TIME_VAR:
//STRIP001 /*?*/ 					pFieldItem = new SvxFieldItem( SvxExtTimeField() );
//STRIP001 /*?*/ 				break;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				case SID_INSERT_FLD_AUTHOR:
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					SvxAddressItem aAdrItem;
//STRIP001 /*?*/ 					pFieldItem = new SvxFieldItem( SvxAuthorField( aAdrItem ) );
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				break;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				case SID_INSERT_FLD_PAGE:
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					pFieldItem = new SvxFieldItem( SvxPageField() );
//STRIP001 /*?*/ 					nMul = 3;
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				break;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				case SID_INSERT_FLD_FILE:
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					String aName;
//STRIP001 /*?*/ 					if( pDocSh->HasName() )
//STRIP001 /*?*/ 						aName = pDocSh->GetMedium()->GetName();
//STRIP001 /*?*/ 					//else
//STRIP001 /*?*/ 					//	aName = pDocSh->GetName();
//STRIP001 /*?*/ 					pFieldItem = new SvxFieldItem( SvxExtFileField( aName ) );
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				break;
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			OutlinerView* pOLV = pDrView->GetTextEditOutlinerView();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if( pOLV )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				const SvxFieldItem* pOldFldItem = pOLV->GetFieldAtSelection();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if( pOldFldItem && ( pOldFldItem->GetField()->ISA( SvxURLField ) ||
//STRIP001 /*?*/ 									pOldFldItem->GetField()->ISA( SvxDateField ) ||
//STRIP001 /*?*/ 									pOldFldItem->GetField()->ISA( SvxTimeField ) ||
//STRIP001 /*?*/ 									pOldFldItem->GetField()->ISA( SvxExtTimeField ) ||
//STRIP001 /*?*/ 									pOldFldItem->GetField()->ISA( SvxExtFileField ) ||
//STRIP001 /*?*/ 									pOldFldItem->GetField()->ISA( SvxAuthorField ) ||
//STRIP001 /*?*/ 									pOldFldItem->GetField()->ISA( SvxPageField ) ) )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					// Feld selektieren, so dass es beim Insert geloescht wird
//STRIP001 /*?*/ 					ESelection aSel = pOLV->GetSelection();
//STRIP001 /*?*/ 					if( aSel.nStartPos == aSel.nEndPos )
//STRIP001 /*?*/ 						aSel.nEndPos++;
//STRIP001 /*?*/ 					pOLV->SetSelection( aSel );
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				pOLV->InsertField( *pFieldItem );
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				Outliner* pOutl = pDoc->GetInternalOutliner();
//STRIP001 /*?*/ 				pOutl->Init( OUTLINERMODE_TEXTOBJECT );
//STRIP001 /*?*/ 				USHORT nOutlMode = pOutl->GetMode();
//STRIP001 /*?*/ 				USHORT nMinDepth = pOutl->GetMinDepth();
//STRIP001 /*?*/ 				pOutl->SetMinDepth( 0 );
//STRIP001 /*?*/ 				pOutl->SetStyleSheet( 0, NULL );
//STRIP001 /*?*/ 				pOutl->QuickInsertField( *pFieldItem, ESelection() );
//STRIP001 /*?*/ 				OutlinerParaObject* pOutlParaObject = pOutl->CreateParaObject();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				SdrRectObj* pRectObj = new SdrRectObj( OBJ_TEXT );
//STRIP001 /*?*/ 				pRectObj->SetItem(SdrTextAutoGrowWidthItem(TRUE));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				pOutl->UpdateFields();
//STRIP001 /*?*/ 				pOutl->SetUpdateMode( TRUE );
//STRIP001 /*?*/ 				Size aSize( pOutl->CalcTextSize() );
//STRIP001 /*?*/ 				aSize.Width() *= nMul;
//STRIP001 /*?*/ 				pOutl->SetUpdateMode( FALSE );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				Point aPos;
//STRIP001 /*?*/ 				Rectangle aRect( aPos, pWindow->GetOutputSizePixel() );
//STRIP001 /*?*/ 				aPos = aRect.Center();
//STRIP001 /*?*/ 				aPos = pWindow->PixelToLogic(aPos);
//STRIP001 /*?*/ 				aPos.X() -= aSize.Width() / 2;
//STRIP001 /*?*/ 				aPos.Y() -= aSize.Height() / 2;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				Rectangle aLogicRect(aPos, aSize);
//STRIP001 /*?*/ 				pRectObj->SetLogicRect(aLogicRect);
//STRIP001 /*?*/ 				pRectObj->SetOutlinerParaObject( pOutlParaObject );
//STRIP001 /*?*/ 				pDrView->InsertObject(pRectObj, *pDrView->GetPageViewPvNum(0));
//STRIP001 /*?*/ 				pOutl->Init( nOutlMode );
//STRIP001 /*?*/ 				pOutl->SetMinDepth( nMinDepth );
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			delete pFieldItem;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/ 		case SID_MODIFY_FIELD:
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 OutlinerView* pOLV = pDrView->GetTextEditOutlinerView();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if( pOLV )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				const SvxFieldItem* pFldItem = pOLV->GetFieldAtSelection();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if( pFldItem && (pFldItem->GetField()->ISA( SvxDateField ) ||
//STRIP001 /*?*/ 								 pFldItem->GetField()->ISA( SvxAuthorField ) ||
//STRIP001 /*?*/ 								 pFldItem->GetField()->ISA( SvxExtFileField ) ||
//STRIP001 /*?*/ 								 pFldItem->GetField()->ISA( SvxExtTimeField ) ) )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					// Dialog...
//STRIP001 /*?*/ 					SdModifyFieldDlg aDlg( pWindow, pFldItem->GetField(), pOLV->GetAttribs() );
//STRIP001 /*?*/ 					if( aDlg.Execute() == RET_OK )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						// #108538#
//STRIP001 /*?*/ 						// To make a correct SetAttribs() call at the utlinerView
//STRIP001 /*?*/ 						// it is necessary to split the actions here
//STRIP001 /*?*/ 						SvxFieldData* pField = aDlg.GetField();
//STRIP001 /*?*/ 						ESelection aSel = pOLV->GetSelection();
//STRIP001 /*?*/ 						sal_Bool bSelectionWasModified(sal_False);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if( pField )
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							SvxFieldItem aFieldItem( *pField );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							if( aSel.nStartPos == aSel.nEndPos )
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								bSelectionWasModified = sal_True;
//STRIP001 /*?*/ 								aSel.nEndPos++;
//STRIP001 /*?*/ 								pOLV->SetSelection( aSel );
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							pOLV->InsertField( aFieldItem );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							// #108538# select again for eventual SetAttribs call
//STRIP001 /*?*/ 							pOLV->SetSelection( aSel );
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						SfxItemSet aSet( aDlg.GetItemSet() );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if( aSet.Count() )
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							pOLV->SetAttribs( aSet );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							Outliner* pOutliner = pOLV->GetOutliner();
//STRIP001 /*?*/ 							if( pOutliner )
//STRIP001 /*?*/ 								pOutliner->UpdateFields();
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if(pField)
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							// #108538# restore selection to original
//STRIP001 /*?*/ 							if(bSelectionWasModified)
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								aSel.nEndPos--;
//STRIP001 /*?*/ 								pOLV->SetSelection( aSel );
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 							delete pField;
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*?*/         case SID_OPEN_XML_FILTERSETTINGS:
/*?*/         {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 			try
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				::com::sun::star::uno::Reference < ::com::sun::star::ui::dialogs::XExecutableDialog > xDialog(::legacy_binfilters::getLegacyProcessServiceFactory()->createInstance(::rtl::OUString::createFromAscii("com.sun.star.comp.ui.XSLTFilterDialog")), ::com::sun::star::uno::UNO_QUERY);
//STRIP001 /*?*/ 				if( xDialog.is() )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					xDialog->execute();
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			catch( ::com::sun::star::uno::RuntimeException& )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Cancel();
//STRIP001 /*?*/ 			rReq.Ignore ();
/*?*/ 		}
/*?*/ 		break;
/*?*/ 
/*N*/ 		default:
/*N*/ 		{
/*N*/ 			// switch Anweisung wegen CLOOKS aufgeteilt. Alle case-Anweisungen die
/*N*/ 			// eine Fu???? -Funktion aufrufen, sind in die Methode FuTemp03 (drviewsb)
/*N*/ 			// gewandert.
/*N*/ 			FuTemp03(rReq);
/*N*/ 		}
/*N*/ 		break;
/*N*/ 	};
/*N*/ };

//STRIP001 bool SdDrawViewShell::RenameSlide( USHORT nPageId, const String & rName  )
//STRIP001 {
//STRIP001     BOOL   bOutDummy;
//STRIP001     if( pDoc->GetPageByName( rName, bOutDummy ) != SDRPAGE_NOTFOUND )
//STRIP001         return false;
//STRIP001 
//STRIP001     SdPage* pPageToRename = NULL;
//STRIP001     PageKind ePageKind = GetPageKind();
//STRIP001 
//STRIP001     if( GetEditMode() == EM_PAGE )
//STRIP001     {
//STRIP001         pPageToRename = pDoc->GetSdPage( nPageId - 1, ePageKind );
//STRIP001 
//STRIP001         // Undo
//STRIP001         SdPage* pUndoPage = pPageToRename;
//STRIP001         SdrLayerAdmin &  rLayerAdmin = pDoc->GetLayerAdmin();
//STRIP001         BYTE nBackground = rLayerAdmin.GetLayerID( String( SdResId( STR_LAYER_BCKGRND )), FALSE );
//STRIP001         BYTE nBgObj = rLayerAdmin.GetLayerID( String( SdResId( STR_LAYER_BCKGRNDOBJ )), FALSE );
//STRIP001         SetOfByte aVisibleLayers = pActualPage->GetMasterPageVisibleLayers( 0 );
//STRIP001 
//STRIP001         // (#67720#)
//STRIP001         SfxUndoManager* pManager = pDoc->GetDocSh()->GetUndoManager();
//STRIP001         ModifyPageUndoAction* pAction = new ModifyPageUndoAction(
//STRIP001             pManager, pDoc, pUndoPage, rName, pUndoPage->GetAutoLayout(),
//STRIP001             aVisibleLayers.IsSet( nBackground ),
//STRIP001             aVisibleLayers.IsSet( nBgObj ));
//STRIP001         pManager->AddUndoAction( pAction );
//STRIP001 
//STRIP001         // rename
//STRIP001         pPageToRename->SetName( rName );
//STRIP001 
//STRIP001         if( ePageKind == PK_STANDARD )
//STRIP001         {
//STRIP001             // also rename notes-page
//STRIP001             SdPage* pNotesPage = pDoc->GetSdPage( nPageId - 1, PK_NOTES );
//STRIP001             pNotesPage->SetName( rName );
//STRIP001         }
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         // rename MasterPage -> rename LayoutTemplate
//STRIP001         pPageToRename = pDoc->GetMasterSdPage( nPageId - 1, ePageKind );
//STRIP001         pDoc->RenameLayoutTemplate( pPageToRename->GetLayoutName(), rName );
//STRIP001     }
//STRIP001 
//STRIP001     bool bSuccess = ( FALSE != rName.Equals( pPageToRename->GetName()));
//STRIP001 
//STRIP001     if( bSuccess )
//STRIP001     {
//STRIP001         // user edited page names may be changed by the page so update control
//STRIP001         aTabControl.SetPageText( nPageId, rName );
//STRIP001 
//STRIP001         // set document to modified state
//STRIP001         pDoc->SetChanged( TRUE );
//STRIP001 
//STRIP001         // inform navigator about change
//STRIP001 		SfxBoolItem aItem( SID_NAVIGATOR_INIT, TRUE );
//STRIP001 		GetViewFrame()->GetDispatcher()->Execute(
//STRIP001 			SID_NAVIGATOR_INIT, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001     }
//STRIP001 
//STRIP001     return bSuccess;
//STRIP001 }

//STRIP001 IMPL_LINK( SdDrawViewShell, RenameSlideHdl, SvxNameDialog*, pDialog )
//STRIP001 {
//STRIP001     if( ! pDialog )
//STRIP001         return 0;
//STRIP001 
//STRIP001     String aNewName;
//STRIP001     pDialog->GetName( aNewName );
//STRIP001 
//STRIP001     SdPage* pCurrentPage = pDoc->GetSdPage( aTabControl.GetCurPageId() - 1, GetPageKind() );
//STRIP001 
//STRIP001     return ( aNewName.Equals( pCurrentPage->GetName() )
//STRIP001              || GetDocSh()->IsNewPageNameValid( aNewName ) );
//STRIP001 }

//STRIP001 void SdDrawViewShell::ModifyLayer( SdrLayer* pLayer, String& rLayerName, bool bIsVisible, bool bIsLocked, bool bIsPrintable )
//STRIP001 {
//STRIP001 	if( pLayer )
//STRIP001 	{
//STRIP001 
//STRIP001 		const USHORT nPageCount = aLayerTab.GetPageCount();
//STRIP001 		USHORT nCurPage = 0;
//STRIP001 		USHORT nPos;
//STRIP001 		for( nPos = 0; nPos < nPageCount; nPos++ )
//STRIP001 		{
//STRIP001 			USHORT nId = aLayerTab.GetPageId( nPos );
//STRIP001 			if( pLayer->GetName() == aLayerTab.GetPageText( nId ) )
//STRIP001 			{
//STRIP001 				nCurPage = nId;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		pLayer->SetName( rLayerName );
//STRIP001 		pDrView->SetLayerVisible( rLayerName, bIsVisible );
//STRIP001 		pDrView->SetLayerLocked( rLayerName, bIsLocked);
//STRIP001 		pDrView->SetLayerPrintable(rLayerName, bIsPrintable);
//STRIP001 
//STRIP001 		pDoc->SetChanged(TRUE);
//STRIP001 
//STRIP001 		aLayerTab.SetPageText(nCurPage, rLayerName);
//STRIP001 
//STRIP001 		TabBarPageBits nBits = 0;
//STRIP001 
//STRIP001 		if (!bIsVisible)
//STRIP001 		{
//STRIP001 			// Unsichtbare Layer werden anders dargestellt
//STRIP001 			nBits = TPB_SPECIAL;
//STRIP001 		}
//STRIP001 
//STRIP001 		aLayerTab.SetPageBits(nCurPage, nBits);
//STRIP001 
//STRIP001 		GetViewFrame()->GetDispatcher()->Execute(SID_SWITCHLAYER,
//STRIP001 						SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 
//STRIP001 		FmFormShell* pFmShell = (FmFormShell*) aShellTable.Get(RID_FORMLAYER_TOOLBOX);
//STRIP001 		if (pFmShell)
//STRIP001 			pFmShell->Invalidate();
//STRIP001 	}
//STRIP001 }

}
