/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_drviews7.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:37:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
// auto strip #include <com/sun/star/lang/XMultiServiceFactory.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_LANG_LOCALE_HPP_
// auto strip #include <com/sun/star/lang/Locale.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_LINGUISTIC2_XTHESAURUS_HPP_
// auto strip #include <com/sun/star/linguistic2/XThesaurus.hpp>
// auto strip #endif
#ifndef _SVX_FMGLOB_HXX
#include <bf_svx/fmglob.hxx>
#endif
#ifndef _E3D_GLOBL3D_HXX
#include <bf_svx/globl3d.hxx>
#endif
#ifndef _SVDOUNO_HXX
#include <bf_svx/svdouno.hxx>
#endif
#ifndef _EEITEM_HXX //autogen
#include <bf_svx/eeitem.hxx>
#endif

// auto strip #ifndef _PSTM_HXX
// auto strip #include <tools/pstm.hxx>
// auto strip #endif

// auto strip #ifndef _SFXPOOLITEM_HXX
// auto strip #include <svtools/poolitem.hxx>
// auto strip #endif

#ifndef _SVX_ITEMDATA_HXX
#include <bf_svx/itemdata.hxx>
#endif

// auto strip #ifndef _DATE_HXX
// auto strip #include <tools/date.hxx>
// auto strip #endif

// auto strip #ifndef _TOOLS_TIME_HXX
// auto strip #include <tools/time.hxx>
// auto strip #endif

#ifndef _FLDITEM_HXX
#define ITEMID_FIELD    EE_FEATURE_FIELD
// auto strip #include <bf_svx/flditem.hxx>
#endif
#ifndef _SVXIDS_HXX
#include <bf_svx/svxids.hrc>
#endif
#ifndef _SVDPAGV_HXX //autogen
#include <bf_svx/svdpagv.hxx>
#endif
// auto strip #ifndef _SVX_CLIPFMTITEM_HXX
// auto strip #include <bf_svx/clipfmtitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_FMSHELL_HXX
// auto strip #include <bf_svx/fmshell.hxx>
// auto strip #endif
// auto strip #ifndef _SFXENUMITEM_HXX //autogen
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
// auto strip #ifndef _AEITEM_HXX //autogen
// auto strip #include <svtools/aeitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXSTRITEM_HXX //autogen
// auto strip #include <svtools/stritem.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_WHITER_HXX //autogen
// auto strip #include <svtools/whiter.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
#ifndef _SVDOGRAF_HXX
#include <bf_svx/svdograf.hxx>
#endif

#ifndef _UNO_LINGU_HXX
#include <bf_svx/unolingu.hxx>
#endif

// #UndoRedo#
// auto strip #ifndef _SFXSLSTITM_HXX
// auto strip #include <svtools/slstitm.hxx>
// auto strip #endif

#include <svtools/moduleoptions.hxx>
#ifndef _SVTOOLS_LANGUAGEOPTIONS_HXX
#include <svtools/languageoptions.hxx>
#endif

// auto strip #ifndef _COMPHELPER_PROCESSFACTORY_HXX_
// auto strip #include <comphelper/processfactory.hxx>
// auto strip #endif
// auto strip #ifndef _SFXREQUEST_HXX
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #endif
// auto strip #ifndef _PASTEDLG_HXX
// auto strip #include <so3/pastedlg.hxx>
// auto strip #endif

#pragma hdrstop

// auto strip #include <bf_svx/pfiledlg.hxx>
#include <bf_svx/grafctrl.hxx>
// auto strip #include <svtools/cliplistener.hxx>

#include "app.hrc"
#include "glob.hrc"
#include "res_bmp.hrc"

#ifndef _SD_PRESVISH_HXX
#include "presvish.hxx"
#endif

// auto strip #include "misc.hxx"
// auto strip #include "sdoutl.hxx"
#include "drawdoc.hxx"
#include "sdresid.hxx"
#include "sdpage.hxx"
#include "sdclient.hxx"
#include "docshell.hxx"
#include "zoomlist.hxx"
//STRIP001 #include "preview.hxx"
#include "fuslshow.hxx"
#include "drawview.hxx"
namespace binfilter {

using namespace ::rtl;
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::linguistic2;

//////////////////////////////////////////////////////////////////////////////
// service routine for Undo/Redo implementation

//STRIP001 SfxUndoManager* ImpGetUndoManagerFromViewShell(SdDrawViewShell& rDViewShell)
//STRIP001 {
//STRIP001 	SdViewShell* pViewShell = rDViewShell.GetDocSh()->GetViewShell();
//STRIP001 	if(pViewShell)
//STRIP001 		return pViewShell->GetViewFrame()->GetDispatcher()->GetShell(0)->GetUndoManager();
//STRIP001 	DBG_ASSERT(pViewShell, "ViewShell not found");
//STRIP001 	return 0L;
//STRIP001 }

//STRIP001 IMPL_LINK( SdDrawViewShell, ClipboardChanged, TransferableDataHelper*, pDataHelper )
//STRIP001 {
//STRIP001 	if ( pDataHelper )
//STRIP001 	{
//STRIP001 		bPastePossible = ( pDataHelper->GetFormatCount() != 0 );
//STRIP001 
//STRIP001 		SfxBindings& rBindings = GetViewFrame()->GetBindings();
//STRIP001 		rBindings.Invalidate( SID_PASTE );
//STRIP001 		rBindings.Invalidate( SID_PASTE2 );
//STRIP001 		rBindings.Invalidate( SID_CLIPBOARD_FORMAT_ITEMS );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
|*
|* Status (Enabled/Disabled) von Menue-SfxSlots setzen
|*
\************************************************************************/

/*N*/ void SdDrawViewShell::GetMenuState( SfxItemSet &rSet )
/*N*/ {
/*N*/ 	SdViewShell::GetMenuState(rSet);
/*N*/ 	BOOL bDisableVerticalText = !SvtLanguageOptions().IsVerticalTextEnabled();
/*N*/ 
/*N*/ 	if (pFuSlideShow)
/*?*/ 		rSet.Put(SfxBoolItem(SID_LIVE_PRESENTATION, pFuSlideShow->IsLivePresentation()));
/*N*/ 
/*N*/ 	if ( bDisableVerticalText )
/*N*/ 	{
/*N*/ 		rSet.DisableItem( SID_DRAW_CAPTION_VERTICAL );
/*N*/ 		rSet.DisableItem( SID_TEXT_FITTOSIZE_VERTICAL );
/*N*/ 		rSet.DisableItem( SID_DRAW_TEXT_VERTICAL );
/*N*/ 	}
/*N*/ 
/*N*/ 	SfxApplication* pApp = SFX_APP();
/*N*/ 
/*N*/     if ( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PRESENTATION ) )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SfxChildWindow* pPreviewChildWindow = GetViewFrame()->GetChildWindow(SdPreviewChildWindow::GetChildWindowId());
//STRIP001 /*?*/ 		SdPreviewWin*	pPreviewWin = (SdPreviewWin*) ( pPreviewChildWindow ? pPreviewChildWindow->GetWindow() : NULL );
//STRIP001 /*?*/ 		FuSlideShow*	pShow = pPreviewWin ? pPreviewWin->GetSlideShow() : NULL;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if ( (pShow && pShow->IsInputLocked()) ||
//STRIP001 /*?*/ 		     pDocSh->IsPreview() )
//STRIP001 /*?*/         {
//STRIP001 /*?*/ 			rSet.DisableItem( SID_PRESENTATION );
//STRIP001 /*?*/         }
/*?*/ 	}

/*N*/ 	FASTBOOL bConvertToPathPossible = pDrView->IsConvertToPathObjPossible(FALSE);
/*N*/ 
/*N*/ 	const SdrMarkList& rMarkList = pDrView->GetMarkList();
/*N*/ 	ULONG nMarkCount = rMarkList.GetMarkCount();
/*N*/ 
/*N*/ 	// Stati der SfxChild-Windows (Animator, Fontwork etc.)
/*N*/ 	SetChildWindowState( rSet );
/*N*/ 
/*N*/ 	// Images der Toolboxen mappen (nur Zoom)
/*N*/ 	UpdateToolboxImages( rSet, FALSE );
/*N*/ 
/*N*/ 	if (pFuActual)
/*N*/ 	{
/*N*/ 		USHORT nSId = pFuActual->GetSlotID();

//		switch ( nSId )
//		{
//			case SID_OBJECT_SELECT:
//				rSet.Put( SfxAllEnumItem( SID_OBJECT_SELECT, pFuActual->GetSlotValue() ) );
//				break;
//			default:
/*N*/ 				rSet.Put( SfxBoolItem( nSId, TRUE ) );
//		}

        // Bewirkt ein uncheck eines simulierten Slots
/*N*/ 		USHORT nId = GetIdBySubId( nSId );
/*N*/ 
/*N*/ 		// Images der Toolboxen mappen
/*N*/ 		UpdateToolboxImages( rSet );

/*N*/ 		if( nId != SID_ZOOM_TOOLBOX &&
/*N*/ 			nSId != SID_DRAWTBX_INSERT &&
/*N*/ 			nSId != SID_POSITION &&
/*N*/ 			nSId != SID_OBJECT_ALIGN )
/*N*/ 		{
/*N*/ 			if( nId != SID_OBJECT_CHOOSE_MODE )
/*N*/ 				rSet.Put( TbxImageItem( SID_OBJECT_CHOOSE_MODE, 0 ) );
/*N*/ 			if( nId != SID_DRAWTBX_TEXT )
/*N*/ 				rSet.Put( TbxImageItem( SID_DRAWTBX_TEXT, 0 ) );
/*N*/ 			if( nId != SID_DRAWTBX_RECTANGLES )
/*N*/ 				rSet.Put( TbxImageItem( SID_DRAWTBX_RECTANGLES, 0 ) );
/*N*/ 			if( nId != SID_DRAWTBX_ELLIPSES )
/*N*/ 				rSet.Put( TbxImageItem( SID_DRAWTBX_ELLIPSES, 0 ) );
/*N*/ 			if( nId != SID_DRAWTBX_LINES )
/*N*/ 				rSet.Put( TbxImageItem( SID_DRAWTBX_LINES, 0 ) );
/*N*/ 			if( nId != SID_DRAWTBX_ARROWS )
/*N*/ 				rSet.Put( TbxImageItem( SID_DRAWTBX_ARROWS, 0 ) );
/*N*/ 			if( nId != SID_DRAWTBX_3D_OBJECTS )
/*N*/ 				rSet.Put( TbxImageItem( SID_DRAWTBX_3D_OBJECTS, 0 ) );
/*N*/             if( nId != SID_DRAWTBX_CONNECTORS )
/*N*/                 rSet.Put( TbxImageItem( SID_DRAWTBX_CONNECTORS, 0 ) );
/*N*/         }
/*N*/ 	}


/*N*/ 	SdrPageView* pPageView = pDrView->GetPageViewPvNum( 0 );
/*N*/ 
/*N*/ 	GetMenuStateSel(rSet);
/*N*/ 
/*N*/     if (SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_EXPAND_PAGE))
/*N*/     {
/*?*/         BOOL bDisable = TRUE;
/*?*/         SdPage* pPage = (SdPage*) pPageView->GetPage();
/*?*/ 
/*?*/         if ( pPage->GetPageKind() == PK_STANDARD && !pPage->IsMasterPage() )
/*?*/         {
/*?*/             SdrObject* pObj = pPage->GetPresObj(PRESOBJ_OUTLINE);
/*?*/ 
/*?*/             if (pObj && !pObj->IsEmptyPresObj())
/*?*/             {
/*?*/                 bDisable = FALSE;
/*?*/             }
/*?*/         }
/*?*/ 
/*?*/         if (bDisable)
/*?*/         {
/*?*/             rSet.DisableItem(SID_EXPAND_PAGE);
/*?*/         }
/*?*/     }

/*N*/     if (SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_SUMMARY_PAGE))
/*N*/     {
/*?*/         BOOL bDisable = TRUE;
/*?*/         SdPage* pPage = (SdPage*) pPageView->GetPage();
/*?*/ 
/*?*/         if (pPage->GetPageKind() == PK_STANDARD && !pPage->IsMasterPage() )
/*?*/         {
/*?*/             SdrObject* pObj = pPage->GetPresObj(PRESOBJ_TITLE);
/*?*/ 
/*?*/             if (pObj && !pObj->IsEmptyPresObj())
/*?*/             {
/*?*/                 bDisable = FALSE;
/*?*/             }
/*?*/         }
/*?*/ 
/*?*/         if (bDisable)
/*?*/         {
/*?*/             rSet.DisableItem(SID_SUMMARY_PAGE);
/*?*/         }
/*?*/     }

	// Starten der Praesentation moeglich?
/*N*/ 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PRESENTATION ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_REHEARSE_TIMINGS ) )
/*N*/     {
/*?*/         BOOL bDisable = TRUE;
/*?*/         USHORT nCount = pDoc->GetSdPageCount( PK_STANDARD );
/*?*/ 
/*?*/         for( USHORT i = 0; i < nCount && bDisable; i++ )
/*?*/         {
/*?*/             SdPage* pPage = pDoc->GetSdPage(i, PK_STANDARD);
/*?*/ 
/*?*/             if( !pPage->IsExcluded() )
/*?*/ 				bDisable = FALSE;
/*?*/         }
/*?*/ 
/*?*/         if( bDisable || pDocSh->IsPreview())
/*?*/ 		{
/*?*/             rSet.DisableItem( SID_PRESENTATION );
/*?*/             rSet.DisableItem( SID_REHEARSE_TIMINGS );
/*?*/ 		}
/*?*/     }

    // Klebepunkte
/*N*/ 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_GLUE_EDITMODE ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_GLUE_INSERT_POINT ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_GLUE_PERCENT ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_GLUE_ESCDIR ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_GLUE_ESCDIR_LEFT ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_GLUE_ESCDIR_RIGHT ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_GLUE_ESCDIR_TOP ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_GLUE_ESCDIR_BOTTOM ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_GLUE_HORZALIGN_CENTER ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_GLUE_HORZALIGN_LEFT ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_GLUE_HORZALIGN_RIGHT ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_GLUE_VERTALIGN_CENTER ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_GLUE_VERTALIGN_TOP ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_GLUE_VERTALIGN_BOTTOM ) )
/*N*/ 	{
		// Prozent
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 TRISTATE eState = pDrView->IsMarkedGluePointsPercent();
//STRIP001 /*?*/ 		if( eState == STATE_DONTKNOW )
//STRIP001 /*?*/ 			rSet.InvalidateItem( SID_GLUE_PERCENT );
//STRIP001 /*?*/ 		else
//STRIP001 /*?*/ 			rSet.Put( SfxBoolItem( SID_GLUE_PERCENT, eState == STATE_CHECK ) );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		// Bei Prozent hat Alignment keinen Effekt
//STRIP001 /*?*/ 		if( eState == STATE_CHECK )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			rSet.DisableItem( SID_GLUE_HORZALIGN_CENTER );
//STRIP001 /*?*/ 			rSet.DisableItem( SID_GLUE_HORZALIGN_LEFT );
//STRIP001 /*?*/ 			rSet.DisableItem( SID_GLUE_HORZALIGN_RIGHT );
//STRIP001 /*?*/ 			rSet.DisableItem( SID_GLUE_VERTALIGN_CENTER );
//STRIP001 /*?*/ 			rSet.DisableItem( SID_GLUE_VERTALIGN_TOP );
//STRIP001 /*?*/ 			rSet.DisableItem( SID_GLUE_VERTALIGN_BOTTOM );
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		else
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			// Horizontale Ausrichtung
//STRIP001 /*?*/ 			USHORT nHorz = pDrView->GetMarkedGluePointsAlign( FALSE );
//STRIP001 /*?*/ 			rSet.Put( SfxBoolItem( SID_GLUE_HORZALIGN_CENTER, nHorz == SDRHORZALIGN_CENTER ) );
//STRIP001 /*?*/ 			rSet.Put( SfxBoolItem( SID_GLUE_HORZALIGN_LEFT,   nHorz == SDRHORZALIGN_LEFT ) );
//STRIP001 /*?*/ 			rSet.Put( SfxBoolItem( SID_GLUE_HORZALIGN_RIGHT,  nHorz == SDRHORZALIGN_RIGHT ) );
//STRIP001 /*?*/ 			// Vertikale Ausrichtung
//STRIP001 /*?*/ 			USHORT nVert = pDrView->GetMarkedGluePointsAlign( TRUE );
//STRIP001 /*?*/ 			rSet.Put( SfxBoolItem( SID_GLUE_VERTALIGN_CENTER, nVert == SDRVERTALIGN_CENTER ) );
//STRIP001 /*?*/ 			rSet.Put( SfxBoolItem( SID_GLUE_VERTALIGN_TOP,	  nVert == SDRVERTALIGN_TOP ) );
//STRIP001 /*?*/ 			rSet.Put( SfxBoolItem( SID_GLUE_VERTALIGN_BOTTOM, nVert == SDRVERTALIGN_BOTTOM ) );
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		// Punkt einfuegen
//STRIP001 /*?*/ 		rSet.Put( SfxBoolItem( SID_GLUE_INSERT_POINT, pDrView->IsInsGluePointMode() ) );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		// Autrittsrichtung
//STRIP001 /*?*/ 		// Links
//STRIP001 /*?*/ 		eState = pDrView->IsMarkedGluePointsEscDir( SDRESC_LEFT );
//STRIP001 /*?*/ 		if( eState == STATE_DONTKNOW )
//STRIP001 /*?*/ 			rSet.InvalidateItem( SID_GLUE_ESCDIR_LEFT );
//STRIP001 /*?*/ 		else
//STRIP001 /*?*/ 			rSet.Put( SfxBoolItem( SID_GLUE_ESCDIR_LEFT, eState == STATE_CHECK ) );
//STRIP001 /*?*/ 		// Rechts
//STRIP001 /*?*/ 		eState = pDrView->IsMarkedGluePointsEscDir( SDRESC_RIGHT );
//STRIP001 /*?*/ 		if( eState == STATE_DONTKNOW )
//STRIP001 /*?*/ 			rSet.InvalidateItem( SID_GLUE_ESCDIR_RIGHT );
//STRIP001 /*?*/ 		else
//STRIP001 /*?*/ 			rSet.Put( SfxBoolItem( SID_GLUE_ESCDIR_RIGHT, eState == STATE_CHECK ) );
//STRIP001 /*?*/ 		// Oben
//STRIP001 /*?*/ 		eState = pDrView->IsMarkedGluePointsEscDir( SDRESC_TOP );
//STRIP001 /*?*/ 		if( eState == STATE_DONTKNOW )
//STRIP001 /*?*/ 			rSet.InvalidateItem( SID_GLUE_ESCDIR_TOP );
//STRIP001 /*?*/ 		else
//STRIP001 /*?*/ 			rSet.Put( SfxBoolItem( SID_GLUE_ESCDIR_TOP, eState == STATE_CHECK ) );
//STRIP001 /*?*/ 		// Unten
//STRIP001 /*?*/ 		eState = pDrView->IsMarkedGluePointsEscDir( SDRESC_BOTTOM );
//STRIP001 /*?*/ 		if( eState == STATE_DONTKNOW )
//STRIP001 /*?*/ 			rSet.InvalidateItem( SID_GLUE_ESCDIR_BOTTOM );
//STRIP001 /*?*/ 		else
//STRIP001 /*?*/ 			rSet.Put( SfxBoolItem( SID_GLUE_ESCDIR_BOTTOM, eState == STATE_CHECK ) );
/*N*/ 	}
/*N*/ 
/*N*/ 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_GRID_FRONT ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_HELPLINES_FRONT ) )
/*N*/ 	{
/*?*/ 		rSet.Put( SfxBoolItem( SID_GRID_FRONT, pDrView->IsGridFront() ) );
/*?*/ 		rSet.Put( SfxBoolItem( SID_HELPLINES_FRONT, pDrView->IsHlplFront() ) );
/*?*/ 	}

/*N*/ 	if (!pDrView->IsFrameDragSingles())
/*N*/ 	{
/*?*/         rSet.Put(SfxBoolItem(SID_BEZIER_EDIT, TRUE));
/*?*/     }

/*N*/     if( !pDrView->IsMirrorAllowed( TRUE, TRUE ) )
/*N*/ 	{
/*N*/ 		rSet.DisableItem( SID_HORIZONTAL );
/*N*/ 		rSet.DisableItem( SID_VERTICAL );
/*N*/     }
/*N*/ 
/*N*/     if( !pDrView->IsMirrorAllowed() )
/*N*/ 	{
/*N*/         rSet.DisableItem( SID_OBJECT_MIRROR );
/*N*/ //        rSet.DisableItem( SID_CONVERT_TO_3D_LATHE );
/*N*/ //        rSet.DisableItem( SID_CONVERT_TO_3D_LATHE_FAST );
/*N*/     }

	// interactive transparence control
/*N*/     if(!pDrView->IsTransparenceAllowed())
/*N*/ 	{
/*N*/         rSet.DisableItem( SID_OBJECT_TRANSPARENCE );
/*N*/     }
/*N*/ 
	// interactive gradient control
/*N*/     if(!pDrView->IsGradientAllowed())
/*N*/ 	{
/*N*/         rSet.DisableItem( SID_OBJECT_GRADIENT );
/*N*/     }
/*N*/ 
/*N*/ 	// Morphen ggf. disablen
/*N*/ 	if ( !pDrView->IsMorphingAllowed() )
/*N*/ 		rSet.DisableItem( SID_POLYGON_MORPHING );
/*N*/ 
/*N*/ 	// Vectorize ggf. disablen
/*N*/ 	if ( !pDrView->IsVectorizeAllowed() )
/*N*/ 		rSet.DisableItem( SID_VECTORIZE );
/*N*/ 
/*N*/ 	if( !pDrView->IsReverseOrderPossible() )
/*N*/ 	{
/*N*/ 		rSet.DisableItem( SID_REVERSE_ORDER );
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( !bConvertToPathPossible &&
/*N*/ 		 !pDrView->IsCrookAllowed( pDrView->IsCrookNoContortion() ) )
/*N*/ 	{
/*N*/ 		// Implizite Wandlung in Kurve nicht moeglich
/*N*/ 		rSet.DisableItem(SID_OBJECT_CROOK_ROTATE);
/*N*/ 		rSet.DisableItem(SID_OBJECT_CROOK_SLANT);
/*N*/ 		rSet.DisableItem(SID_OBJECT_CROOK_STRETCH);
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( !pDrView->IsGroupEntered() )
/*N*/ 	{
/*N*/ 		rSet.DisableItem( SID_LEAVE_GROUP );
/*N*/ 		rSet.Put( SfxBoolItem( SID_LEAVE_ALL_GROUPS, FALSE ) );
/*N*/ 		rSet.ClearItem( SID_LEAVE_ALL_GROUPS );
/*N*/ 		rSet.DisableItem( SID_LEAVE_ALL_GROUPS );
/*N*/ 	}
/*N*/ 	else
/*N*/ 		rSet.Put( SfxBoolItem( SID_LEAVE_ALL_GROUPS, TRUE ) );
/*N*/ 
/*N*/ 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_THESAURUS ) )
/*?*/ 	{
/*?*/ 		if ( !pDrView->IsTextEdit() )
/*?*/ 		{
/*?*/ 			rSet.DisableItem( SID_THESAURUS );
/*?*/ 		}
/*?*/ 		else
/*?*/ 		{
/*?*/ 			LanguageType            eLang = pDoc->GetLanguage( EE_CHAR_LANGUAGE );
/*?*/ 	        Reference< XThesaurus > xThesaurus( LinguMgr::GetThesaurus() );
/*?*/ 			Locale                  aLocale;
/*?*/ 			
/*?*/             SvxLanguageToLocale( aLocale, eLang );
/*?*/ 			
/*?*/             if (!xThesaurus.is() || eLang == LANGUAGE_NONE || !xThesaurus->hasLocale(aLocale) )
/*?*/ 				rSet.DisableItem( SID_THESAURUS );
/*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( !pDrView->IsTextEdit() )
/*N*/ 	{
/*N*/ 		rSet.DisableItem( SID_THESAURUS );
/*N*/ 	}

/*N*/ 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_SELECTALL ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_SIZE_ALL ) )
/*N*/ 	{
/*N*/ 		if( pPageView && pPageView->GetObjList()->GetObjCount() == 0 )
/*N*/ 		{
			// Sollte disabled sein, wenn kein Objekt auf der Zeichenflaeche ist:
/*N*/ 			rSet.DisableItem( SID_SELECTALL );
/*N*/ 			rSet.DisableItem( SID_SIZE_ALL );
/*N*/ 		}
/*N*/ 	}

/*N*/ 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_CONTEXT ) )
/*N*/ 		rSet.Put( SfxStringItem( SID_CONTEXT, pDrView->GetStatusText() ) );

	// clipboard (paste)
/*N*/     if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PASTE ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PASTE2 ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_CLIPBOARD_FORMAT_ITEMS ) )
/*N*/ 	{
/*?*/ 		if ( !pClipEvtLstnr )
/*?*/ 		{
/*?*/             // SSA: #108717# avoid clipboard initialization for read-only presentation views (workaround for NT4.0 clipboard prob...)
/*?*/ 			if( !ISA( SdPresViewShell ) || ( pFuSlideShow && pFuSlideShow->IsLivePresentation())  )
/*?*/ 			{
/*?*/ 				// create listener
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pClipEvtLstnr = new TransferableClipboardListener( LINK( this, SdDrawViewShell, ClipboardChanged ) );
//STRIP001 /*?*/ 				pClipEvtLstnr->acquire();
//STRIP001 /*?*/ 				pClipEvtLstnr->AddRemoveListener( GetActiveWindow(), TRUE );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			    // get initial state
//STRIP001 /*?*/ 			    TransferableDataHelper aDataHelper( TransferableDataHelper::CreateFromSystemClipboard( GetActiveWindow() ) );
//STRIP001 /*?*/ 			    bPastePossible = ( aDataHelper.GetFormatCount() != 0 );
/*?*/ 			}
/*?*/             else
/*?*/ 			    bPastePossible = FALSE;
/*?*/ 		}
/*?*/ 
/*?*/ 		if( !bPastePossible )
/*?*/ 		{
/*?*/ 			rSet.DisableItem( SID_PASTE );
/*?*/ 			rSet.DisableItem( SID_PASTE2 );
/*?*/             rSet.DisableItem( SID_CLIPBOARD_FORMAT_ITEMS );
/*?*/ 		}
/*?*/ 		else if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_CLIPBOARD_FORMAT_ITEMS ) )
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SvxClipboardFmtItem aItem( SID_CLIPBOARD_FORMAT_ITEMS );
//STRIP001 			TransferableDataHelper aDataHelper( TransferableDataHelper::CreateFromSystemClipboard( GetActiveWindow() ) );
//STRIP001 
//STRIP001 			for( sal_uInt32 i = 0; i < aDataHelper.GetFormatCount(); i++ )
//STRIP001 			{
//STRIP001                 static SotFormatStringId aSupportedFormats[] =
//STRIP001 				{
//STRIP001 					SOT_FORMATSTR_ID_EMBED_SOURCE,
//STRIP001 					SOT_FORMATSTR_ID_LINK_SOURCE,
//STRIP001 					SOT_FORMATSTR_ID_DRAWING,
//STRIP001 					SOT_FORMATSTR_ID_SVXB,
//STRIP001 					FORMAT_GDIMETAFILE,
//STRIP001 					FORMAT_BITMAP,
//STRIP001                     SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK,
//STRIP001 					FORMAT_STRING,
//STRIP001 					SOT_FORMATSTR_ID_HTML,
//STRIP001 					FORMAT_RTF,
//STRIP001 					SOT_FORMATSTR_ID_EDITENGINE
//STRIP001 				};
//STRIP001 
//STRIP001 				::com::sun::star::datatransfer::DataFlavor	aFlavor;
//STRIP001     			const SotFormatStringId						nTestFormat = aDataHelper.GetFormat( i );
//STRIP001 
//STRIP001                 sal_uInt32  j;
//STRIP001                 sal_Bool    bDouble = sal_False;
//STRIP001                 for ( j = 0; j < i; j++ )
//STRIP001                 {
//STRIP001                     const SotFormatStringId	nF = aDataHelper.GetFormat( j );
//STRIP001                     if (  nTestFormat == nF )
//STRIP001                     {
//STRIP001                         bDouble = sal_True;
//STRIP001                         break;
//STRIP001                     }
//STRIP001                 }
//STRIP001 		        if ( bDouble == sal_False )
//STRIP001                 {
//STRIP001 				    for( sal_uInt32 n = 0, nCount = sizeof( aSupportedFormats ) / sizeof( SotFormatStringId ); n < nCount; n++ )
//STRIP001 				    {
//STRIP001 					    if( nTestFormat == aSupportedFormats[ n ] )
//STRIP001 					    {
//STRIP001                             String aName;
//STRIP001 
//STRIP001 						    if( SOT_FORMATSTR_ID_EMBED_SOURCE == nTestFormat )
//STRIP001                             {
//STRIP001 	        				    TransferableObjectDescriptor aDesc;
//STRIP001 					            
//STRIP001                                 if( aDataHelper.GetTransferableObjectDescriptor( SOT_FORMATSTR_ID_OBJECTDESCRIPTOR, aDesc ) )
//STRIP001                                     aName = aDesc.maTypeName;
//STRIP001                             }
//STRIP001 
//STRIP001                             if( aName.Len() )
//STRIP001                                 aItem.AddClipbrdFormat( nTestFormat, aName );
//STRIP001                             else
//STRIP001                                 aItem.AddClipbrdFormat( nTestFormat );
//STRIP001 					    }
//STRIP001 				    }
//STRIP001                 }
//STRIP001 			}
//STRIP001 
//STRIP001             SotFormatStringId nFormat;
//STRIP001             bool bHasFormat = false;
//STRIP001             nFormat = SOT_FORMATSTR_ID_EMBED_SOURCE_OLE;
//STRIP001             bHasFormat = aDataHelper.HasFormat (nFormat);
//STRIP001             if ( ! bHasFormat)
//STRIP001             {
//STRIP001                 nFormat = SOT_FORMATSTR_ID_EMBEDDED_OBJ_OLE;
//STRIP001                 bHasFormat = aDataHelper.HasFormat (nFormat);
//STRIP001             }
//STRIP001             if (bHasFormat)
//STRIP001             {
//STRIP001                 String sName,sSource;
//STRIP001                 if (SvPasteObjectDialog::GetEmbeddedName (aDataHelper, sName, sSource, nFormat))
//STRIP001                     aItem.AddClipbrdFormat (nFormat, sName);
//STRIP001             }
//STRIP001 
//STRIP001 			rSet.Put( aItem );
/*?*/ 		}
/*N*/ 	}

/*N*/ 	if ( !bConvertToPathPossible )
/*N*/ 	{
/*N*/ 		rSet.DisableItem(SID_CHANGEBEZIER);
/*N*/ 	}
/*N*/ 
/*N*/ 	if( !( pDrView->IsConvertToPolyObjPossible(FALSE) || pDrView->IsVectorizeAllowed() ) )
/*N*/         rSet.DisableItem(SID_CHANGEPOLYGON);
/*N*/ 
/*N*/ 	if( !( pDrView->IsConvertToPolyObjPossible(FALSE) || pDrView->IsConvertToContourPossible() ) )
/*N*/         rSet.DisableItem(SID_CONVERT_TO_CONTOUR);
/*N*/ 
/*N*/ 	if ( !pDrView->IsConvertTo3DObjPossible() )
/*N*/ 	{
/*N*/ 		rSet.DisableItem(SID_CONVERT_TO_3D);
/*N*/ 		rSet.DisableItem(SID_CONVERT_TO_3D_LATHE);
/*N*/ 		rSet.DisableItem(SID_CONVERT_TO_3D_LATHE_FAST);
/*N*/ 	}
/*N*/ 
/*N*/     if (pDrView->IsPixelMode())
/*N*/     {
/*N*/         rSet.Put(SfxBoolItem(SID_PIXELMODE, TRUE));
/*N*/     }
/*N*/     else
/*N*/     {
/*N*/         rSet.Put(SfxBoolItem(SID_PIXELMODE, FALSE));
/*N*/     }
/*N*/ 
/*N*/     if (pDrView->GetSlideShow())
/*N*/     {
/*N*/         rSet.Put(SfxBoolItem(SID_ANIMATIONMODE, TRUE));
/*N*/     }
/*N*/     else
/*N*/     {
/*N*/         rSet.Put(SfxBoolItem(SID_ANIMATIONMODE, FALSE));
/*N*/     }
/*N*/ 
/*N*/     if (pDrView->IsActionMode())
/*N*/     {
/*N*/         rSet.Put(SfxBoolItem(SID_ACTIONMODE, TRUE));
/*N*/     }
/*N*/     else
/*N*/     {
/*N*/         rSet.Put(SfxBoolItem(SID_ACTIONMODE, FALSE));
/*N*/     }
/*N*/ 
/*N*/     if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_MANAGE_LINKS ) )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pDoc->GetLinkCount() == 0 )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			rSet.DisableItem(SID_MANAGE_LINKS);
//STRIP001 /*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	rSet.Put(SfxBoolItem(SID_DIAMODE, FALSE));
/*N*/ 	rSet.Put(SfxBoolItem(SID_OUTLINEMODE, FALSE));
/*N*/ 
/*N*/ 	if (ePageKind == PK_HANDOUT)
/*N*/ 	{
/*N*/ 		rSet.DisableItem(SID_ANIMATIONMODE);
/*N*/ 		rSet.DisableItem(SID_PRESENTATION_LAYOUT);
/*N*/ 	}
/*N*/ 
/*N*/ 	if (ePageKind == PK_NOTES)
/*N*/ 	{
/*N*/ 		rSet.DisableItem(SID_ANIMATIONMODE);
/*N*/ 		rSet.Put(SfxBoolItem(SID_DRAWINGMODE, FALSE));
/*N*/ 		rSet.Put(SfxBoolItem(SID_NOTESMODE, TRUE));
/*N*/ 		rSet.Put(SfxBoolItem(SID_HANDOUTMODE, FALSE));
/*N*/ 		rSet.DisableItem(SID_INSERTPAGE);
/*N*/ 		rSet.DisableItem(SID_RENAMEPAGE);
/*N*/ 		rSet.DisableItem(SID_RENAMEPAGE_QUICK);
/*N*/         rSet.DisableItem(SID_DUPLICATE_PAGE);
/*N*/ 		rSet.ClearItem(SID_ANIMATION_OBJECTS);
/*N*/ 		rSet.DisableItem(SID_ANIMATION_OBJECTS);
/*N*/ 		rSet.DisableItem(SID_ANIMATION_EFFECTS);
/*N*/ 
/*N*/ 		if (eEditMode == EM_MASTERPAGE)
/*N*/ 			rSet.DisableItem(SID_MODIFYPAGE);
/*N*/ 
/*N*/ 		rSet.DisableItem(SID_INSERTLAYER);
/*N*/ 		rSet.DisableItem(SID_LAYERMODE);
/*N*/ 		rSet.DisableItem(SID_INSERTFILE);
/*N*/ 	}
/*N*/ 	else if (ePageKind == PK_HANDOUT)
/*N*/ 	{
/*N*/ 		rSet.Put(SfxBoolItem(SID_DRAWINGMODE, FALSE));
/*N*/ 		rSet.Put(SfxBoolItem(SID_NOTESMODE, FALSE));
/*N*/ 		rSet.Put(SfxBoolItem(SID_HANDOUTMODE, TRUE));
/*N*/ 		rSet.DisableItem(SID_INSERTPAGE);
/*N*/         rSet.DisableItem(SID_DUPLICATE_PAGE);
/*N*/ 		rSet.ClearItem(SID_ANIMATION_OBJECTS);
/*N*/ 		rSet.DisableItem(SID_ANIMATION_OBJECTS);
/*N*/ 		rSet.DisableItem(SID_ANIMATION_EFFECTS);
/*N*/ 		rSet.DisableItem(SID_RENAMEPAGE);
/*N*/ 		rSet.DisableItem(SID_RENAMEPAGE_QUICK);
/*N*/ 		rSet.DisableItem(SID_INSERTLAYER);
/*N*/ 		rSet.DisableItem(SID_MODIFYLAYER);
/*N*/ 		rSet.DisableItem(SID_RENAMELAYER);
/*N*/ 		rSet.DisableItem(SID_LAYERMODE);
/*N*/ 		rSet.DisableItem(SID_INSERTFILE);
/*N*/ 		rSet.DisableItem(SID_PAGEMODE);
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		rSet.Put(SfxBoolItem(SID_DRAWINGMODE, TRUE));
/*N*/ 		rSet.Put(SfxBoolItem(SID_NOTESMODE, FALSE));
/*N*/ 		rSet.Put(SfxBoolItem(SID_HANDOUTMODE, FALSE));
/*N*/ 
/*N*/ 		if (eEditMode == EM_MASTERPAGE)
/*N*/ 		{
/*N*/ 			rSet.DisableItem(SID_INSERTPAGE);
/*N*/             rSet.DisableItem(SID_DUPLICATE_PAGE);
/*N*/ 			rSet.DisableItem(SID_MODIFYPAGE);
/*N*/ 			rSet.ClearItem(SID_ANIMATION_OBJECTS);
/*N*/ 			rSet.DisableItem(SID_ANIMATION_OBJECTS);
/*N*/ 		}
/*N*/ 
/*N*/ 		rSet.Put( SfxBoolItem( SID_LAYERMODE, bLayerMode ) );
/*N*/ 	}
/*N*/ 
/*N*/ 	if( !aLayerBtn.IsChecked() )
/*N*/ 	{
/*N*/ 		rSet.DisableItem( SID_INSERTLAYER );
/*N*/ 		rSet.DisableItem( SID_MODIFYLAYER );
/*N*/ 		rSet.DisableItem( SID_DELETE_LAYER );
/*N*/ 		rSet.DisableItem( SID_RENAMELAYER );
/*N*/ 	}
/*N*/ 
/*N*/ 	if (eEditMode == EM_PAGE)
/*N*/ 	{
        /**********************************************************************
        * Seiten-Modus
        **********************************************************************/
/*N*/ 		rSet.Put(SfxBoolItem(SID_PAGEMODE, TRUE));
/*N*/ 		rSet.Put(SfxBoolItem(SID_MASTERPAGE, FALSE));
/*N*/         rSet.Put(SfxBoolItem(SID_SLIDE_MASTERPAGE, FALSE));
/*N*/         rSet.Put(SfxBoolItem(SID_NOTES_MASTERPAGE, FALSE));
/*N*/         rSet.Put(SfxBoolItem(SID_HANDOUT_MASTERPAGE, FALSE));
/*N*/ 
/*N*/         if (ePageKind == PK_STANDARD &&
/*N*/             rSet.GetItemState(SID_TITLE_MASTERPAGE) == SFX_ITEM_AVAILABLE)
/*N*/         {
/*?*/             // Gibt es eine Seite mit dem AutoLayout "Titel"?
/*?*/             BOOL bDisable = TRUE;
/*?*/             USHORT i = 0;
/*?*/             USHORT nCount = pDoc->GetSdPageCount(PK_STANDARD);
/*?*/ 
/*?*/             while (i < nCount && bDisable)
/*?*/             {
/*?*/                 SdPage* pPage = pDoc->GetSdPage(i, PK_STANDARD);
/*?*/ 
/*?*/                 if (pPage->GetAutoLayout() == AUTOLAYOUT_TITLE)
/*?*/                 {
/*?*/                     bDisable = FALSE;
/*?*/                 }
/*?*/ 
/*?*/                 i++;
/*?*/             }
/*?*/ 
/*?*/             if (bDisable)
/*?*/             {
/*?*/                 rSet.DisableItem(SID_TITLE_MASTERPAGE);
/*?*/             }
/*?*/             else
/*?*/             {
/*?*/                 rSet.Put(SfxBoolItem(SID_TITLE_MASTERPAGE, FALSE));
/*?*/             }
/*N*/         }
/*N*/         else
/*N*/         {
/*N*/             rSet.DisableItem(SID_TITLE_MASTERPAGE);
/*N*/         }
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
        /**********************************************************************
        * Hintergrundseiten-Modus
        **********************************************************************/
/*?*/         if (ePageKind == PK_STANDARD)
/*?*/         {
/*?*/             rSet.Put(SfxBoolItem(SID_SLIDE_MASTERPAGE, TRUE));
/*?*/             rSet.Put(SfxBoolItem(SID_NOTES_MASTERPAGE, FALSE));
/*?*/             rSet.Put(SfxBoolItem(SID_HANDOUT_MASTERPAGE, FALSE));
/*?*/ 
/*?*/             if (rSet.GetItemState(SID_TITLE_MASTERPAGE) == SFX_ITEM_AVAILABLE)
/*?*/             {
/*?*/                 SdPage* pMPage = (SdPage*) pPageView->GetPage();
/*?*/ 
/*?*/                 BOOL bCheck = FALSE;
/*?*/                 BOOL bDisable = TRUE;
/*?*/                 USHORT i = 0;
/*?*/                 USHORT nCount = pDoc->GetSdPageCount(PK_STANDARD);
/*?*/ 
/*?*/                 // Referenziert eine Seite mit dem AutoLayout "Titel" die
/*?*/                 // aktuelle MasterPage?
/*?*/                 while (i < nCount && !bCheck && bDisable)
/*?*/                 {
/*?*/                     SdPage* pPage = pDoc->GetSdPage(i, PK_STANDARD);
/*?*/ 
/*?*/                     // Seite referenziert aktuelle MasterPage
/*?*/                     if (pPage->GetAutoLayout() == AUTOLAYOUT_TITLE)
/*?*/                     {
/*?*/                         // Eine Seite hat das AutoLayout "Titel"
/*?*/                         bDisable = FALSE;
/*?*/ 
/*?*/                         SdPage* pRefMPage = (SdPage*) pPage->GetMasterPage(0);
/*?*/                         if (pRefMPage && pRefMPage == pMPage)
/*?*/                         {
/*?*/                             // Eine Seite mit dem AutoLayout "Titel"
/*?*/                             // referenziert die aktuelle MasterPage
/*?*/                             bCheck = TRUE;
/*?*/                         }
/*?*/                     }
/*?*/ 
/*?*/                     i++;
/*?*/                 }
/*?*/ 
/*?*/                 if (bCheck)
/*?*/                 {
/*?*/                     rSet.Put(SfxBoolItem(SID_SLIDE_MASTERPAGE, FALSE));
/*?*/                 }
/*?*/ 
/*?*/                 rSet.Put(SfxBoolItem(SID_TITLE_MASTERPAGE, bCheck));
/*?*/ 
/*?*/                 if (bDisable)
/*?*/                 {
/*?*/                     rSet.ClearItem(SID_TITLE_MASTERPAGE);
/*?*/                     rSet.DisableItem(SID_TITLE_MASTERPAGE);
/*?*/                 }
/*?*/             }
/*?*/         }
/*?*/         else if (ePageKind == PK_NOTES)
/*?*/         {
/*?*/             rSet.Put(SfxBoolItem(SID_SLIDE_MASTERPAGE, FALSE));
/*?*/             rSet.DisableItem(SID_TITLE_MASTERPAGE);
/*?*/             rSet.Put(SfxBoolItem(SID_NOTES_MASTERPAGE, TRUE));
/*?*/             rSet.Put(SfxBoolItem(SID_HANDOUT_MASTERPAGE, FALSE));
/*?*/         }
/*?*/         else if (ePageKind == PK_HANDOUT)
/*?*/         {
/*?*/             rSet.Put(SfxBoolItem(SID_SLIDE_MASTERPAGE, FALSE));
/*?*/             rSet.DisableItem(SID_TITLE_MASTERPAGE);
/*?*/             rSet.Put(SfxBoolItem(SID_NOTES_MASTERPAGE, FALSE));
/*?*/             rSet.Put(SfxBoolItem(SID_HANDOUT_MASTERPAGE, TRUE));
/*?*/         }
/*N*/     }

    // Status der Lineale setzen
/*N*/     if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_RULER ) )
/*N*/ 		rSet.Put( SfxBoolItem( SID_RULER, HasRuler() ) );
/*N*/ 
/*N*/ 	// nicht die letzte Seite oder eine Masterpage loeschen
/*N*/ 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_DELETE_PAGE ) )
/*N*/ 	{
/*N*/ 		if (aTabControl.GetPageCount() == 1 ||
/*N*/ 			eEditMode == EM_MASTERPAGE		||
/*N*/ 			ePageKind == PK_NOTES			||
/*N*/ 			ePageKind == PK_HANDOUT 		||
/*N*/ 			bLayerMode)
/*N*/ 		{
/*N*/ 			rSet.DisableItem(SID_DELETE_PAGE);
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	// darf der aktuelle Layer geloescht werden?
/*N*/ 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_DELETE_LAYER ) )
/*N*/ 	{
/*N*/ 		SdrLayerAdmin& rAdmin = pDoc->GetLayerAdmin();
/*N*/ 
/*N*/ 		USHORT		  nCurrentLayer = aLayerTab.GetCurPageId();
/*N*/ 		const String& rName 		= aLayerTab.GetPageText(nCurrentLayer);
/*N*/ 
/*N*/ 		BOOL bDisableIt = !bLayerMode;
/*N*/         bDisableIt |= (rName == String(SdResId(STR_LAYER_LAYOUT)));
/*N*/         bDisableIt |= (rName == String(SdResId(STR_LAYER_BCKGRND)));
/*N*/         bDisableIt |= (rName == String(SdResId(STR_LAYER_BCKGRNDOBJ)));
/*N*/         bDisableIt |= (rName == String(SdResId(STR_LAYER_CONTROLS)));
/*N*/         bDisableIt |= (rName == String(SdResId(STR_LAYER_MEASURELINES)));
/*N*/ 
/*N*/ 		if (bDisableIt)
/*N*/ 		{
/*N*/ 			rSet.DisableItem(SID_DELETE_LAYER);
/*N*/             rSet.DisableItem(SID_RENAMELAYER);
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_CUT ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_COPY ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_OUTLINE_BULLET ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_BULLET ) )
/*N*/ 	{
/*N*/ 		OutlinerView* pOlView = pDrView->GetTextEditOutlinerView();
/*N*/ 
/*N*/ 		// Sonderbehandlung fr SID_OUTLINE_BULLET wenn Objekte
/*N*/ 		// mit unterschiedlichen arten von NumBullet Items markiert
/*N*/ 		// sind
/*N*/ 		BOOL bHasOutliner = FALSE;
/*N*/ 		BOOL bHasOther    = FALSE;
/*N*/ 		const SdrMarkList& rMarkList = pView->GetMarkList();
/*N*/ 		const ULONG nCount = rMarkList.GetMarkCount();
/*N*/ 		for(ULONG nNum = 0; nNum < nCount; nNum++)
/*N*/ 		{
/*N*/ 		    SdrObject* pObj = rMarkList.GetMark(nNum)->GetObj();
/*N*/ 			if( pObj->GetObjInventor() == SdrInventor )
/*N*/ 			{
/*N*/ 				if( pObj->GetObjIdentifier() == OBJ_OUTLINETEXT )
/*N*/ 				{
/*N*/ 					bHasOutliner = TRUE;
/*N*/ 					if(bHasOther)
/*N*/ 						break;
/*N*/ 				}
/*N*/ 				else
/*N*/ 				{
/*N*/ 					bHasOther = TRUE;
/*N*/ 					if(bHasOutliner)
/*N*/ 						break;
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		if( bHasOther && bHasOutliner )
/*N*/ 			rSet.DisableItem( SID_OUTLINE_BULLET );
/*N*/ 
/*N*/ 		if (pOlView)
/*N*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( pOlView->GetSelected().Len() == 0 )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				rSet.DisableItem( SID_CUT );
//STRIP001 /*?*/ 				rSet.DisableItem( SID_COPY );
//STRIP001 /*?*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		// ggfs. Menuepunkt "Aufzaehlungszeichen" bzw. "Sonderzeichen" disablen
/*N*/ 		if (! pOlView )
/*N*/ 		{
/*N*/ 			rSet.DisableItem(SID_BULLET);
/*N*/ 		}
/*N*/ 		else if (!pDrView->GetTextEditObject())
/*N*/ 		{
/*N*/ 			rSet.DisableItem(SID_BULLET);
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( pDocSh->IsUIActive() )
/*N*/ 	{
/*N*/ 		rSet.DisableItem( SID_INSERT_OBJECT );
/*N*/         rSet.DisableItem( SID_INSERT_PLUGIN );
/*N*/         rSet.DisableItem( SID_INSERT_SOUND );
/*N*/         rSet.DisableItem( SID_INSERT_VIDEO );
/*N*/         rSet.DisableItem( SID_INSERT_APPLET );
/*N*/         rSet.DisableItem( SID_INSERT_FLOATINGFRAME );
/*N*/ #ifdef STARIMAGE_AVAILABLE
/*N*/ 		rSet.DisableItem( SID_INSERT_IMAGE );
/*N*/ #endif
/*N*/ 		rSet.DisableItem( SID_INSERT_MATH );
/*N*/ 		rSet.DisableItem( SID_INSERT_DIAGRAM );
/*N*/ 		rSet.DisableItem( SID_ATTR_TABLE );
/*N*/ 		rSet.DisableItem( SID_SIZE_REAL );
/*N*/ 		rSet.DisableItem( SID_SIZE_OPTIMAL );
/*N*/ 		rSet.DisableItem( SID_SIZE_ALL );
/*N*/ 		rSet.DisableItem( SID_SIZE_PAGE_WIDTH );
/*N*/ 		rSet.DisableItem( SID_SIZE_PAGE );
/*N*/ //		rSet.DisableItem( SID_INSERTPAGE );
/*N*/         rSet.DisableItem( SID_DUPLICATE_PAGE );
/*N*/         rSet.DisableItem( SID_ZOOM_TOOLBOX );
/*N*/ 	}
/*N*/ 
/*N*/ 	// Zoom-Stati
/*N*/ 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_ZOOM_IN ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_ZOOM_OUT )||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_ZOOM_PANNING ) )
/*N*/ 	{
/*N*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if( pWindow->GetZoom() <= pWindow->GetMinZoom() || pDocSh->IsUIActive() )
//STRIP001 /*N*/ 		{
//STRIP001 /*N*/ 			rSet.DisableItem( SID_ZOOM_IN );
//STRIP001 /*N*/ 			rSet.DisableItem( SID_ZOOM_PANNING );
//STRIP001 /*N*/ 		}
//STRIP001 /*N*/ 		if( pWindow->GetZoom() >= pWindow->GetMaxZoom() || pDocSh->IsUIActive() )
//STRIP001 /*N*/ 			rSet.DisableItem( SID_ZOOM_OUT );
/*N*/ 	}
/*N*/ 
/*N*/ 	if (!pZoomList->IsNextPossible())
/*N*/ 	{
/*N*/ 	   rSet.DisableItem(SID_ZOOM_NEXT);
/*N*/ 	}
/*N*/ 	if (!pZoomList->IsPreviousPossible())
/*N*/ 	{
/*N*/ 	   rSet.DisableItem(SID_ZOOM_PREV);
/*N*/ 	}
/*N*/ 
/*N*/ 	// EditText aktiv
/*N*/ 	if( nCurrentObjectBar == RID_DRAW_TEXT_TOOLBOX )
/*N*/ 	{
/*N*/ 		USHORT nCurrentSId = SID_ATTR_CHAR;
/*N*/ 
/*N*/ 		if (pFuActual)
/*N*/ 		{
/*N*/ 			nCurrentSId = pFuActual->GetSlotID();
/*N*/ 		}
/*N*/ 		if( nCurrentSId != SID_TEXT_FITTOSIZE &&
/*N*/ 		    nCurrentSId != SID_TEXT_FITTOSIZE_VERTICAL &&
/*N*/ 			nCurrentSId != SID_ATTR_CHAR_VERTICAL )
/*N*/ 			nCurrentSId = SID_ATTR_CHAR;
/*N*/ 
/*N*/ 		rSet.Put( SfxBoolItem( nCurrentSId, TRUE ) );
/*N*/ 
/*N*/ 		// Kurzform von UpdateToolboxImages()
/*N*/ 		rSet.Put( TbxImageItem( SID_DRAWTBX_TEXT, nCurrentSId ) );
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( pDocSh->IsReadOnly() )
/*N*/ 	{
/*N*/ 		rSet.DisableItem( SID_AUTOSPELL_CHECK );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 	    if (pDoc->GetOnlineSpell())
/*N*/     	{
/*N*/         	rSet.Put(SfxBoolItem(SID_AUTOSPELL_CHECK, TRUE));
/*N*/ 	    }
/*N*/     	else
/*N*/ 	    {
/*N*/     	    rSet.Put(SfxBoolItem(SID_AUTOSPELL_CHECK, FALSE));
/*N*/     	}
/*N*/ 	}
/*N*/ 
/*N*/ 	SdrPageView* pPV = pDrView->GetPageViewPvNum(0);
/*N*/ 	String aActiveLayer = pDrView->GetActiveLayer();
/*N*/ 
/*N*/ 	if ( ( aActiveLayer.Len() != 0 && pPV && ( pPV->IsLayerLocked(aActiveLayer) ||
/*N*/ 		  !pPV->IsLayerVisible(aActiveLayer) ) ) ||
/*N*/           SD_MOD()->GetWaterCan() )
/*N*/ 	{
/*N*/ 		rSet.DisableItem( SID_PASTE );
/*N*/ 		rSet.DisableItem( SID_PASTE2 );
/*N*/         rSet.DisableItem( SID_CLIPBOARD_FORMAT_ITEMS );
/*N*/ 
/*N*/         rSet.DisableItem( SID_INSERT_FLD_DATE_FIX );
/*N*/         rSet.DisableItem( SID_INSERT_FLD_DATE_VAR );
/*N*/         rSet.DisableItem( SID_INSERT_FLD_TIME_FIX );
/*N*/         rSet.DisableItem( SID_INSERT_FLD_TIME_VAR );
/*N*/         rSet.DisableItem( SID_INSERT_FLD_AUTHOR );
/*N*/         rSet.DisableItem( SID_INSERT_FLD_PAGE );
/*N*/         rSet.DisableItem( SID_INSERT_FLD_FILE );
/*N*/ 
/*N*/ 		rSet.DisableItem( SID_INSERT_GRAPHIC );
/*N*/ 		rSet.DisableItem( SID_INSERT_DIAGRAM );
/*N*/ 		rSet.DisableItem( SID_INSERT_OBJECT );
/*N*/         rSet.DisableItem( SID_INSERT_PLUGIN );
/*N*/         rSet.DisableItem( SID_INSERT_SOUND );
/*N*/         rSet.DisableItem( SID_INSERT_VIDEO );
/*N*/         rSet.DisableItem( SID_INSERT_APPLET );
/*N*/         rSet.DisableItem( SID_INSERT_FLOATINGFRAME );
/*N*/ 
/*N*/ #ifdef STARIMAGE_AVAILABLE
/*N*/ 		rSet.DisableItem( SID_INSERT_IMAGE );
/*N*/ #endif
/*N*/ 		rSet.DisableItem( SID_INSERT_MATH );
/*N*/ 		rSet.DisableItem( SID_INSERT_FRAME );
/*N*/ 		rSet.DisableItem( SID_INSERTFILE );
/*N*/ 		rSet.DisableItem( SID_ATTR_TABLE );
/*N*/ 		rSet.DisableItem( SID_COPYOBJECTS );
/*N*/ 
/*N*/ 		rSet.DisableItem( SID_SCAN );
/*N*/ 		rSet.DisableItem( SID_TWAIN_SELECT );
/*N*/ 		rSet.DisableItem( SID_TWAIN_TRANSFER );
/*N*/ 
/*N*/ //        rSet.DisableItem( SID_BEZIER_EDIT );
/*N*/ 		rSet.DisableItem( SID_GLUE_EDITMODE );
/*N*/ 		rSet.DisableItem( SID_OBJECT_ROTATE );
/*N*/ 		rSet.DisableItem( SID_OBJECT_SHEAR );
/*N*/ 		rSet.DisableItem( SID_OBJECT_MIRROR );
/*N*/ 		rSet.DisableItem( SID_OBJECT_TRANSPARENCE );
/*N*/ 		rSet.DisableItem( SID_OBJECT_GRADIENT );
/*N*/ 		rSet.DisableItem( SID_OBJECT_CROOK_ROTATE );
/*N*/ 		rSet.DisableItem( SID_OBJECT_CROOK_SLANT );
/*N*/ 		rSet.DisableItem( SID_OBJECT_CROOK_STRETCH );
/*N*/ 
/*N*/ 		// Alle objekterzeugenden Werkzeuge disablen
/*N*/ 		rSet.ClearItem( SID_ATTR_CHAR );
/*N*/ 		rSet.DisableItem( SID_ATTR_CHAR );
/*N*/ 		rSet.ClearItem( SID_ATTR_CHAR_VERTICAL );
/*N*/ 		rSet.DisableItem( SID_ATTR_CHAR_VERTICAL );
/*N*/ 		rSet.ClearItem(SID_DRAW_LINE);
/*N*/ 		rSet.DisableItem(SID_DRAW_LINE);
/*N*/         rSet.ClearItem(SID_DRAW_MEASURELINE);
/*N*/         rSet.DisableItem(SID_DRAW_MEASURELINE);
/*N*/         rSet.ClearItem(SID_DRAW_XLINE);
/*N*/ 		rSet.DisableItem(SID_DRAW_XLINE);
/*N*/ 		rSet.ClearItem( SID_LINE_ARROW_START );
/*N*/ 		rSet.DisableItem( SID_LINE_ARROW_START );
/*N*/ 		rSet.ClearItem( SID_LINE_ARROW_END );
/*N*/ 		rSet.DisableItem( SID_LINE_ARROW_END );
/*N*/ 		rSet.ClearItem( SID_LINE_ARROWS );
/*N*/ 		rSet.DisableItem( SID_LINE_ARROWS );
/*N*/ 		rSet.ClearItem( SID_LINE_ARROW_CIRCLE );
/*N*/ 		rSet.DisableItem( SID_LINE_ARROW_CIRCLE );
/*N*/ 		rSet.ClearItem( SID_LINE_CIRCLE_ARROW );
/*N*/ 		rSet.DisableItem( SID_LINE_CIRCLE_ARROW );
/*N*/ 		rSet.ClearItem( SID_LINE_ARROW_SQUARE );
/*N*/ 		rSet.DisableItem( SID_LINE_ARROW_SQUARE );
/*N*/ 		rSet.ClearItem( SID_LINE_SQUARE_ARROW );
/*N*/ 		rSet.DisableItem( SID_LINE_SQUARE_ARROW );
/*N*/ 
/*N*/ 		rSet.ClearItem(SID_DRAW_RECT);
/*N*/ 		rSet.DisableItem(SID_DRAW_RECT);
/*N*/ 		rSet.ClearItem(SID_DRAW_RECT_NOFILL);
/*N*/ 		rSet.DisableItem(SID_DRAW_RECT_NOFILL);
/*N*/ 		rSet.ClearItem(SID_DRAW_RECT_ROUND);
/*N*/ 		rSet.DisableItem(SID_DRAW_RECT_ROUND);
/*N*/ 		rSet.ClearItem(SID_DRAW_RECT_ROUND_NOFILL);
/*N*/ 		rSet.DisableItem(SID_DRAW_RECT_ROUND_NOFILL);
/*N*/ 		rSet.ClearItem(SID_DRAW_SQUARE);
/*N*/ 		rSet.DisableItem(SID_DRAW_SQUARE);
/*N*/ 		rSet.ClearItem(SID_DRAW_SQUARE_NOFILL);
/*N*/ 		rSet.DisableItem(SID_DRAW_SQUARE_NOFILL);
/*N*/ 		rSet.ClearItem(SID_DRAW_SQUARE_ROUND);
/*N*/ 		rSet.DisableItem(SID_DRAW_SQUARE_ROUND);
/*N*/ 		rSet.ClearItem(SID_DRAW_SQUARE_ROUND_NOFILL);
/*N*/ 		rSet.DisableItem(SID_DRAW_SQUARE_ROUND_NOFILL);
/*N*/ 		rSet.ClearItem(SID_DRAW_ELLIPSE);
/*N*/ 		rSet.DisableItem(SID_DRAW_ELLIPSE);
/*N*/ 		rSet.ClearItem(SID_DRAW_ELLIPSE_NOFILL);
/*N*/ 		rSet.DisableItem(SID_DRAW_ELLIPSE_NOFILL);
/*N*/ 		rSet.ClearItem(SID_DRAW_CIRCLE);
/*N*/ 		rSet.DisableItem(SID_DRAW_CIRCLE);
/*N*/ 		rSet.ClearItem(SID_DRAW_CIRCLE_NOFILL);
/*N*/ 		rSet.DisableItem(SID_DRAW_CIRCLE_NOFILL);
/*N*/ 		rSet.ClearItem(SID_DRAW_CAPTION);
/*N*/ 		rSet.DisableItem(SID_DRAW_CAPTION);
/*N*/ 		rSet.ClearItem(SID_DRAW_CAPTION_VERTICAL);
/*N*/ 		rSet.DisableItem(SID_DRAW_CAPTION_VERTICAL);
/*N*/ 		rSet.ClearItem(SID_TEXT_FITTOSIZE);
/*N*/ 		rSet.DisableItem(SID_TEXT_FITTOSIZE);
/*N*/ 		rSet.ClearItem(SID_TEXT_FITTOSIZE_VERTICAL);
/*N*/ 		rSet.DisableItem(SID_TEXT_FITTOSIZE_VERTICAL);
/*N*/ 		rSet.ClearItem(SID_TOOL_CONNECTOR);
/*N*/ 		rSet.DisableItem(SID_TOOL_CONNECTOR);
/*N*/         rSet.ClearItem(SID_CONNECTOR_ARROW_START);
/*N*/         rSet.DisableItem(SID_CONNECTOR_ARROW_START);
/*N*/         rSet.ClearItem(SID_CONNECTOR_ARROW_END);
/*N*/         rSet.DisableItem(SID_CONNECTOR_ARROW_END);
/*N*/         rSet.ClearItem(SID_CONNECTOR_ARROWS);
/*N*/         rSet.DisableItem(SID_CONNECTOR_ARROWS);
/*N*/         rSet.ClearItem(SID_CONNECTOR_CIRCLE_START);
/*N*/         rSet.DisableItem(SID_CONNECTOR_CIRCLE_START);
/*N*/         rSet.ClearItem(SID_CONNECTOR_CIRCLE_END);
/*N*/         rSet.DisableItem(SID_CONNECTOR_CIRCLE_END);
/*N*/         rSet.ClearItem(SID_CONNECTOR_CIRCLES);
/*N*/         rSet.DisableItem(SID_CONNECTOR_CIRCLES);
/*N*/         rSet.ClearItem(SID_CONNECTOR_LINE);
/*N*/         rSet.DisableItem(SID_CONNECTOR_LINE);
/*N*/         rSet.ClearItem(SID_CONNECTOR_LINE_ARROW_START);
/*N*/         rSet.DisableItem(SID_CONNECTOR_LINE_ARROW_START);
/*N*/         rSet.ClearItem(SID_CONNECTOR_LINE_ARROW_END);
/*N*/         rSet.DisableItem(SID_CONNECTOR_LINE_ARROW_END);
/*N*/         rSet.ClearItem(SID_CONNECTOR_LINE_ARROWS);
/*N*/         rSet.DisableItem(SID_CONNECTOR_LINE_ARROWS);
/*N*/         rSet.ClearItem(SID_CONNECTOR_LINE_CIRCLE_START);
/*N*/         rSet.DisableItem(SID_CONNECTOR_LINE_CIRCLE_START);
/*N*/         rSet.ClearItem(SID_CONNECTOR_LINE_CIRCLE_END);
/*N*/         rSet.DisableItem(SID_CONNECTOR_LINE_CIRCLE_END);
/*N*/         rSet.ClearItem(SID_CONNECTOR_LINE_CIRCLES);
/*N*/         rSet.DisableItem(SID_CONNECTOR_LINE_CIRCLES);
/*N*/         rSet.ClearItem(SID_CONNECTOR_CURVE);
/*N*/         rSet.DisableItem(SID_CONNECTOR_CURVE);
/*N*/         rSet.ClearItem(SID_CONNECTOR_CURVE_ARROW_START);
/*N*/         rSet.DisableItem(SID_CONNECTOR_CURVE_ARROW_START);
/*N*/         rSet.ClearItem(SID_CONNECTOR_CURVE_ARROW_END);
/*N*/         rSet.DisableItem(SID_CONNECTOR_CURVE_ARROW_END);
/*N*/         rSet.ClearItem(SID_CONNECTOR_CURVE_ARROWS);
/*N*/         rSet.DisableItem(SID_CONNECTOR_CURVE_ARROWS);
/*N*/         rSet.ClearItem(SID_CONNECTOR_CURVE_CIRCLE_START);
/*N*/         rSet.DisableItem(SID_CONNECTOR_CURVE_CIRCLE_START);
/*N*/         rSet.ClearItem(SID_CONNECTOR_CURVE_CIRCLE_END);
/*N*/         rSet.DisableItem(SID_CONNECTOR_CURVE_CIRCLE_END);
/*N*/         rSet.ClearItem(SID_CONNECTOR_CURVE_CIRCLES);
/*N*/         rSet.DisableItem(SID_CONNECTOR_CURVE_CIRCLES);
/*N*/         rSet.ClearItem(SID_CONNECTOR_LINES);
/*N*/         rSet.DisableItem(SID_CONNECTOR_LINES);
/*N*/         rSet.ClearItem(SID_CONNECTOR_LINES_ARROW_START);
/*N*/         rSet.DisableItem(SID_CONNECTOR_LINES_ARROW_START);
/*N*/         rSet.ClearItem(SID_CONNECTOR_LINES_ARROW_END);
/*N*/         rSet.DisableItem(SID_CONNECTOR_LINES_ARROW_END);
/*N*/         rSet.ClearItem(SID_CONNECTOR_LINES_ARROWS);
/*N*/         rSet.DisableItem(SID_CONNECTOR_LINES_ARROWS);
/*N*/         rSet.ClearItem(SID_CONNECTOR_LINES_CIRCLE_START);
/*N*/         rSet.DisableItem(SID_CONNECTOR_LINES_CIRCLE_START);
/*N*/         rSet.ClearItem(SID_CONNECTOR_LINES_CIRCLE_END);
/*N*/         rSet.DisableItem(SID_CONNECTOR_LINES_CIRCLE_END);
/*N*/         rSet.ClearItem(SID_CONNECTOR_LINES_CIRCLES);
/*N*/         rSet.DisableItem(SID_CONNECTOR_LINES_CIRCLES);
/*N*/         rSet.ClearItem(SID_DRAW_ARC);
/*N*/ 		rSet.DisableItem(SID_DRAW_ARC);
/*N*/ 		rSet.ClearItem(SID_DRAW_CIRCLEARC);
/*N*/ 		rSet.DisableItem(SID_DRAW_CIRCLEARC);
/*N*/ 		rSet.ClearItem(SID_DRAW_PIE);
/*N*/ 		rSet.DisableItem(SID_DRAW_PIE);
/*N*/ 		rSet.ClearItem(SID_DRAW_PIE_NOFILL);
/*N*/ 		rSet.DisableItem(SID_DRAW_PIE_NOFILL);
/*N*/ 		rSet.ClearItem(SID_DRAW_CIRCLEPIE);
/*N*/ 		rSet.DisableItem(SID_DRAW_CIRCLEPIE);
/*N*/ 		rSet.ClearItem(SID_DRAW_CIRCLEPIE_NOFILL);
/*N*/ 		rSet.DisableItem(SID_DRAW_CIRCLEPIE_NOFILL);
/*N*/ 		rSet.ClearItem(SID_DRAW_ELLIPSECUT);
/*N*/ 		rSet.DisableItem(SID_DRAW_ELLIPSECUT);
/*N*/ 		rSet.ClearItem(SID_DRAW_ELLIPSECUT_NOFILL);
/*N*/ 		rSet.DisableItem(SID_DRAW_ELLIPSECUT_NOFILL);
/*N*/ 		rSet.ClearItem(SID_DRAW_CIRCLECUT);
/*N*/ 		rSet.DisableItem(SID_DRAW_CIRCLECUT);
/*N*/ 		rSet.ClearItem(SID_DRAW_CIRCLECUT_NOFILL);
/*N*/ 		rSet.DisableItem(SID_DRAW_CIRCLECUT_NOFILL);
/*N*/ 		rSet.ClearItem(SID_DRAW_POLYGON);
/*N*/ 		rSet.DisableItem(SID_DRAW_POLYGON);
/*N*/ 		rSet.ClearItem(SID_DRAW_POLYGON_NOFILL);
/*N*/ 		rSet.DisableItem(SID_DRAW_POLYGON_NOFILL);
/*N*/         rSet.ClearItem(SID_DRAW_FREELINE);
/*N*/         rSet.DisableItem(SID_DRAW_FREELINE);
/*N*/         rSet.ClearItem(SID_DRAW_FREELINE_NOFILL);
/*N*/         rSet.DisableItem(SID_DRAW_FREELINE_NOFILL);
/*N*/         rSet.ClearItem(SID_DRAW_XPOLYGON);
/*N*/         rSet.DisableItem(SID_DRAW_XPOLYGON);
/*N*/         rSet.ClearItem(SID_DRAW_XPOLYGON_NOFILL);
/*N*/ 		rSet.DisableItem(SID_DRAW_XPOLYGON_NOFILL);
/*N*/         rSet.ClearItem(SID_DRAW_BEZIER_FILL);
/*N*/         rSet.DisableItem(SID_DRAW_BEZIER_FILL);
/*N*/         rSet.ClearItem(SID_DRAW_BEZIER_NOFILL);
/*N*/         rSet.DisableItem(SID_DRAW_BEZIER_NOFILL);
/*N*/ 		rSet.ClearItem(SID_3D_CUBE);
/*N*/ 		rSet.DisableItem(SID_3D_CUBE);
/*N*/ 		rSet.ClearItem(SID_3D_SHELL);
/*N*/ 		rSet.DisableItem(SID_3D_SHELL);
/*N*/ 		rSet.ClearItem(SID_3D_SPHERE);
/*N*/ 		rSet.DisableItem(SID_3D_SPHERE);
/*N*/ 		rSet.ClearItem(SID_3D_HALF_SPHERE);
/*N*/ 		rSet.DisableItem(SID_3D_HALF_SPHERE);
/*N*/ 		rSet.ClearItem(SID_3D_CYLINDER);
/*N*/ 		rSet.DisableItem(SID_3D_CYLINDER);
/*N*/ 		rSet.ClearItem(SID_3D_CONE);
/*N*/ 		rSet.DisableItem(SID_3D_CONE);
/*N*/ 		rSet.ClearItem(SID_3D_TORUS);
/*N*/ 		rSet.DisableItem(SID_3D_TORUS);
/*N*/ 		rSet.ClearItem(SID_3D_PYRAMID);
/*N*/ 		rSet.DisableItem(SID_3D_PYRAMID);
/*N*/ 	}
/*N*/ 
/*N*/ 	// Sind die Module verfuegbar?
/*N*/ 
/*N*/ 	if (!SvtModuleOptions().IsCalc())
/*N*/ 	{
/*N*/ 		rSet.DisableItem( SID_ATTR_TABLE );
/*N*/ 	}
/*N*/ 	if (!SvtModuleOptions().IsChart())
/*N*/ 	{
/*N*/ 		rSet.DisableItem( SID_INSERT_DIAGRAM );
/*N*/ 	}
/*N*/ #ifdef STARIMAGE_AVAILABLE
/*N*/ 	if (!(pApp->HasFeature(SFX_FEATURE_SIMAGE)))
/*N*/ 	{
/*N*/ 		rSet.DisableItem( SID_INSERT_IMAGE );
/*N*/ 	}
/*N*/ #endif
/*N*/ 	if (!SvtModuleOptions().IsMath())
/*N*/ 	{
/*N*/ 		rSet.DisableItem( SID_INSERT_MATH );
/*N*/ 	}
/*N*/ 
/*N*/ 	const SvEditObjectProtocol& rProt = pDocSh->GetProtocol();
/*N*/ 
/*N*/     // #101976# Removed [pDocSh->GetActualFunction() ||] from the following
/*N*/     // clause because the current function of the docshell can only be
/*N*/     // search and replace or spell checking and in that case switching the
/*N*/     // view mode is allowed.
/*N*/ 	if (rProt.IsInPlaceActive() || pFuSlideShow)
/*N*/ 	{
/*N*/ 		if ( !rProt.IsInPlaceActive() )
/*N*/ 		{
/*N*/ 			rSet.ClearItem( SID_DRAWINGMODE );
/*N*/ 			rSet.DisableItem( SID_DRAWINGMODE );
/*N*/ 		}
/*N*/ 
/*N*/ 		rSet.ClearItem( SID_NOTESMODE );
/*N*/ 		rSet.DisableItem( SID_NOTESMODE );
/*N*/ 
/*N*/ 		rSet.ClearItem( SID_HANDOUTMODE );
/*N*/ 		rSet.DisableItem( SID_HANDOUTMODE );
/*N*/ 
/*N*/ 		rSet.ClearItem( SID_OUTLINEMODE );
/*N*/ 		rSet.DisableItem( SID_OUTLINEMODE );
/*N*/ 
/*N*/ 		rSet.ClearItem( SID_DIAMODE );
/*N*/ 		rSet.DisableItem( SID_DIAMODE );
/*N*/ 	}
/*N*/ 
/*N*/ 	if (pDocSh->GetCreateMode() == SFX_CREATE_MODE_EMBEDDED)
/*N*/ 	{
/*N*/ 		// Outplace-Edit: Kein Umschalten erlauben
/*N*/ 		rSet.ClearItem( SID_OUTLINEMODE );
/*N*/ 		rSet.DisableItem( SID_OUTLINEMODE );
/*N*/ 
/*N*/ 		rSet.ClearItem( SID_DIAMODE );
/*N*/ 		rSet.DisableItem( SID_DIAMODE );
/*N*/ 
/*N*/ 		rSet.ClearItem( SID_NOTESMODE );
/*N*/ 		rSet.DisableItem( SID_NOTESMODE );
/*N*/ 
/*N*/ 		rSet.ClearItem( SID_HANDOUTMODE );
/*N*/ 		rSet.DisableItem( SID_HANDOUTMODE );
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( pFuSlideShow || pDocSh->IsPreview() || bInEffectAssignment )
/*N*/ 	{
/*N*/ 		// Eigene Slots
/*N*/ 		rSet.DisableItem( SID_PRESENTATION );
/*N*/ 		rSet.DisableItem( SID_ZOOM_IN );
/*N*/ 		rSet.DisableItem( SID_ZOOM_OUT );
/*N*/ 		rSet.DisableItem( SID_ZOOM_PANNING );
/*N*/ 		rSet.DisableItem( SID_ZOOM_NEXT );
/*N*/ 		rSet.DisableItem( SID_ZOOM_PREV );
/*N*/ 		rSet.DisableItem( SID_SIZE_REAL );
/*N*/ 		rSet.DisableItem( SID_SIZE_OPTIMAL );
/*N*/ 		rSet.DisableItem( SID_SIZE_ALL );
/*N*/ 		rSet.DisableItem( SID_SIZE_PAGE_WIDTH );
/*N*/ 		rSet.DisableItem( SID_SIZE_PAGE );
/*N*/ 		rSet.DisableItem( SID_INSERTPAGE );
/*N*/         rSet.DisableItem( SID_DUPLICATE_PAGE );
/*N*/ 		rSet.DisableItem( SID_MODIFYPAGE );
/*N*/ 		rSet.DisableItem( SID_RENAMEPAGE );
/*N*/ 		rSet.DisableItem( SID_RENAMEPAGE_QUICK );
/*N*/ 		rSet.DisableItem( SID_DELETE_PAGE );
/*N*/ 		rSet.DisableItem( SID_PAGESETUP );
/*N*/ 
/*N*/ 		if( pFuSlideShow || bInEffectAssignment )
/*N*/ 		{
/*?*/ 			if( pFuSlideShow && pFuSlideShow->IsLivePresentation())
/*N*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 rSet.DisableItem(SID_ANIMATION_OBJECTS);
/*N*/ 			}
/*N*/ 			else
/*N*/ 			{
/*N*/ 				rSet.ClearItem(SID_OBJECT_ALIGN);
/*N*/ 				rSet.ClearItem(SID_ZOOM_TOOLBOX);
/*N*/ 				rSet.ClearItem(SID_OBJECT_CHOOSE_MODE);
/*N*/ 				rSet.ClearItem(SID_DRAWTBX_TEXT);
/*N*/ 				rSet.ClearItem(SID_DRAWTBX_RECTANGLES);
/*N*/ 				rSet.ClearItem(SID_DRAWTBX_ELLIPSES);
/*N*/ 				rSet.ClearItem(SID_DRAWTBX_LINES);
/*N*/ 				rSet.ClearItem(SID_DRAWTBX_ARROWS);
/*N*/ 				rSet.ClearItem(SID_DRAWTBX_3D_OBJECTS);
/*N*/ 		        rSet.ClearItem(SID_DRAWTBX_CONNECTORS);
/*N*/ 				rSet.ClearItem(SID_OBJECT_CHOOSE_MODE );
/*N*/ 				rSet.ClearItem(SID_DRAWTBX_INSERT);
/*N*/ 				rSet.ClearItem(SID_INSERTFILE);
/*N*/ 				rSet.ClearItem(SID_OBJECT_ROTATE);
/*N*/ 				rSet.ClearItem(SID_OBJECT_ALIGN);
/*N*/ 				rSet.ClearItem(SID_POSITION);
/*N*/ 				rSet.ClearItem(SID_FM_CONFIG);
/*N*/ 				rSet.ClearItem(SID_ANIMATION_EFFECTS);
/*N*/ 				rSet.ClearItem(SID_ANIMATION_OBJECTS);
/*N*/ 				rSet.ClearItem(SID_3D_WIN);
/*N*/ 
/*N*/ 				rSet.DisableItem(SID_OBJECT_ALIGN);
/*N*/ 				rSet.DisableItem(SID_ZOOM_TOOLBOX);
/*N*/ 				rSet.DisableItem(SID_OBJECT_CHOOSE_MODE);
/*N*/ 				rSet.DisableItem(SID_DRAWTBX_TEXT);
/*N*/ 				rSet.DisableItem(SID_DRAWTBX_RECTANGLES);
/*N*/ 				rSet.DisableItem(SID_DRAWTBX_ELLIPSES);
/*N*/ 				rSet.DisableItem(SID_DRAWTBX_LINES);
/*N*/ 				rSet.DisableItem(SID_DRAWTBX_ARROWS);
/*N*/ 				rSet.DisableItem(SID_DRAWTBX_3D_OBJECTS);
/*N*/ 		        rSet.DisableItem(SID_DRAWTBX_CONNECTORS);
/*N*/ 				rSet.DisableItem(SID_OBJECT_CHOOSE_MODE );
/*N*/ 				rSet.DisableItem(SID_DRAWTBX_INSERT);
/*N*/ 				rSet.DisableItem(SID_INSERTFILE);
/*N*/ 				rSet.DisableItem(SID_OBJECT_ROTATE);
/*N*/ 				rSet.DisableItem(SID_OBJECT_ALIGN);
/*N*/ 				rSet.DisableItem(SID_POSITION);
/*N*/ 				rSet.DisableItem(SID_FM_CONFIG);
/*N*/ 				rSet.DisableItem(SID_ANIMATION_EFFECTS);
/*N*/ 				rSet.DisableItem(SID_ANIMATION_OBJECTS);
/*N*/ 				rSet.DisableItem(SID_3D_WIN);
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_INSERT_SOUND ) ||
/*N*/ 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_INSERT_VIDEO ) )
/*N*/ 	{
/*?*/ 		///////////////////////////////////////////////////////////////////////
/*?*/ 		// Menuoption : Insert->Object->Sound and Insert->Object->Video
/*?*/ 		//              diable, if there isn't installed any appropriate plugin
/*?*/ 		//
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if (!SvxPluginFileDlg::IsAvailable (SID_INSERT_SOUND))
//STRIP001 /*?*/ 			rSet.DisableItem (SID_INSERT_SOUND);
//STRIP001 /*?*/ 		if (!SvxPluginFileDlg::IsAvailable (SID_INSERT_VIDEO))
//STRIP001 /*?*/ 			rSet.DisableItem (SID_INSERT_VIDEO);
/*N*/ 	}
/*N*/ 
/*N*/ 	///////////////////////////////////////////////////////////////////////
/*N*/ 	// Menuoption: Change->Convert->To Bitmap, Change->Convert->To Metafile
/*N*/ 	//             disable, if there only Bitmap or Metafiles marked
/*N*/ 	// Menuoption: Format->Area, Format->Line
/*N*/ 	//             disabled, if the marked objects not able to handle
/*N*/ 	//             these attributes
/*N*/ 	//
/*N*/ 	if (!pDrView->HasMarked())
/*N*/ 	{
/*N*/ 		rSet.DisableItem (SID_CONVERT_TO_METAFILE);
/*N*/ 		rSet.DisableItem (SID_CONVERT_TO_BITMAP);
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		// get marklist
/*N*/ 		SdrMarkList aMarkList = pDrView->GetMarkList();
/*N*/ 
/*N*/ 		BOOL bFoundBitmap         = FALSE;
/*N*/ 		BOOL bFoundMetafile       = FALSE;
/*N*/ 		BOOL bFoundObjNoLine      = FALSE;
/*N*/ 		BOOL bFoundObjNoArea      = FALSE;
/*N*/ 		BOOL bFoundNoGraphicObj = FALSE;
/*N*/ 		BOOL bFoundAny            = FALSE;
/*N*/ 
/*N*/ 		for (int i=0; i < (int) aMarkList.GetMarkCount() && !bFoundAny; i++)
/*N*/ 		{
/*N*/ 			SdrObject* pObj=  aMarkList.GetMark(i)->GetObj();
/*N*/ 			UINT16 nId = pObj->GetObjIdentifier();
/*N*/ 			UINT32 nInv = pObj->GetObjInventor();
/*N*/ 
/*N*/ 			if(nInv == SdrInventor)
/*N*/ 			{
/*N*/ 				// 2D objects
/*N*/ 				switch( nId )
/*N*/ 				{
/*N*/ 					case OBJ_PATHLINE :
/*N*/ 					case OBJ_PLIN :
/*N*/ 					case OBJ_LINE:
/*N*/ 					case OBJ_FREELINE :
/*N*/ 					case OBJ_EDGE:
/*N*/ 					case OBJ_CARC :
/*N*/ 						bFoundObjNoArea      = TRUE;
/*N*/ 						bFoundNoGraphicObj = TRUE;
/*N*/ 						break;
/*N*/ 					case OBJ_OLE2 :
/*N*/ 						bFoundObjNoLine      = TRUE;
/*N*/ 						bFoundObjNoArea      = TRUE;
/*N*/ 						bFoundNoGraphicObj = TRUE;
/*N*/ 						break;
/*N*/ 					case OBJ_GRAF :
/*N*/ 						switch ( ((SdrGrafObj*)pObj)->GetGraphicType() )
/*N*/ 						{
/*N*/ 							case GRAPHIC_BITMAP :
/*N*/ 								bFoundBitmap = TRUE;
/*N*/ 								break;
/*N*/ 							case GRAPHIC_GDIMETAFILE :
/*N*/ 								bFoundMetafile = TRUE;
/*N*/ 								break;
/*N*/ 						}
/*N*/ 
/*N*/ 						bFoundObjNoLine = TRUE;
/*N*/ 						bFoundObjNoArea = TRUE;
/*N*/ 						break;
/*N*/ 					default :
/*N*/ 						bFoundAny = TRUE;
/*N*/ 				}
/*N*/ 			}
/*N*/ 			else if(nInv == E3dInventor)
/*N*/ 			{
/*N*/ 				// 3D objects
/*N*/ 				bFoundAny = TRUE;
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		if (!bFoundAny)
/*N*/ 		{
/*N*/ 			// Disable menuitem for area-dialog
/*N*/ 			rSet.DisableItem( SID_ATTRIBUTES_AREA );
/*N*/ 
/*N*/ 			// Disable menuitem for line-dialog
/*N*/ 			if( bFoundObjNoLine )
/*N*/ 				rSet.DisableItem( SID_ATTRIBUTES_LINE );
/*N*/ 
/*N*/ 			if( bFoundBitmap && !bFoundMetafile && !bFoundNoGraphicObj )	// only Bitmaps marked
/*N*/ 				rSet.DisableItem( SID_CONVERT_TO_BITMAP );
/*N*/ 			else if( !bFoundBitmap && bFoundMetafile && !bFoundNoGraphicObj )	// only Metafiles marked
/*N*/ 				rSet.DisableItem( SID_CONVERT_TO_METAFILE );
/*N*/ 			else if( !bFoundBitmap && !bFoundMetafile && !bFoundNoGraphicObj )	// nothing to do
/*N*/ 			{
/*N*/ 				rSet.DisableItem( SID_CONVERT_TO_BITMAP );
/*N*/ 				rSet.DisableItem( SID_CONVERT_TO_METAFILE );
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	// #96090# moved SID_UNDO to SdViewShell::GetMenuState()
/*N*/ 	// #96090# moved SID_REDO to SdViewShell::GetMenuState()
/*N*/ 	// #96090# moved SID_GETUNDOSTRINGS to SdViewShell::GetMenuState()
/*N*/ 	// #96090# moved SID_GETREDOSTRINGS to SdViewShell::GetMenuState()
/*N*/ 
/*N*/ 	///////////////////////////////////////////////////////////////////////
/*N*/ 	// Menuoption: Edit->Hyperlink
/*N*/ 	// Disable, if there is no hyperlink
/*N*/ 	//
/*N*/     sal_Bool bDisableEditHyperlink = sal_True;
/*N*/ 	if( pDrView->HasMarked() && ( pDrView->GetMarkList().GetMarkCount() == 1 ) )
/*N*/ 	{
/*N*/ 		if( pDrView->IsTextEdit() )
/*N*/ 		{
/*N*/ 			OutlinerView* pOLV = pDrView->GetTextEditOutlinerView();
/*N*/ 			if (pOLV)
/*N*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 const SvxFieldItem* pFieldItem = pOLV->GetFieldAtSelection();
//STRIP001 /*?*/ 				if (pFieldItem)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/                     ESelection aSel = pOLV->GetSelection();
//STRIP001 /*?*/                     if ( abs( aSel.nEndPos - aSel.nStartPos ) == 1 )
//STRIP001 /*?*/                     {
//STRIP001 /*?*/ 					    const SvxFieldData* pField = pFieldItem->GetField();
//STRIP001 /*?*/ 					    if ( pField->ISA(SvxURLField) )
//STRIP001 /*?*/                             bDisableEditHyperlink = sal_False;
//STRIP001 /*?*/                     }
//STRIP001 /*?*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			SdrUnoObj* pUnoCtrl = PTR_CAST(SdrUnoObj, pDrView->GetMarkList().GetMark(0)->GetObj());
/*N*/ 
/*N*/ 			if ( pUnoCtrl && FmFormInventor == pUnoCtrl->GetObjInventor() )
/*N*/ 			{
/*N*/ 				uno::Reference< awt::XControlModel > xControlModel( pUnoCtrl->GetUnoControlModel() );
/*N*/ 				if( xControlModel.is() )
/*N*/ 				{
/*N*/ 					uno::Reference< beans::XPropertySet > xPropSet( xControlModel, uno::UNO_QUERY );
/*N*/ 					if( xPropSet.is() )
/*N*/ 					{
/*N*/ 						uno::Reference< beans::XPropertySetInfo > xPropInfo( xPropSet->getPropertySetInfo() );
/*N*/ 						if( xPropInfo.is() && xPropInfo->hasPropertyByName(
/*N*/ 							::rtl::OUString( RTL_CONSTASCII_USTRINGPARAM( "TargetURL"))))
/*N*/ 						{
/*N*/ 							bDisableEditHyperlink = sal_False;
/*N*/ 						}
/*N*/ 					}
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/     if ( bDisableEditHyperlink || pDocSh->IsReadOnly() )
/*N*/         rSet.DisableItem( SID_EDIT_HYPERLINK );
/*N*/ 
/*N*/ 	if ( bDisableEditHyperlink )
/*N*/ 		rSet.DisableItem( SID_OPEN_HYPERLINK );
/*N*/ 
/*N*/ #if defined WIN || defined WNT || defined UNX
/*N*/ 	if( !mxScannerManager.is() )
/*N*/ 	{
/*N*/ 		rSet.DisableItem( SID_TWAIN_SELECT );
/*N*/ 		rSet.DisableItem( SID_TWAIN_TRANSFER );
/*N*/ 	}
/*N*/ #endif
/*N*/ 
/*N*/ // Fuer Win16
/*N*/ #ifndef SOLAR_JAVA
/*N*/ 	rSet.DisableItem( SID_INSERT_APPLET );
/*N*/ #endif
/*N*/ 
/*N*/ 
/*N*/     // #94252# Hands off from controls if we're editing an OLE
/*N*/     const SdClient* pIPClient = (const SdClient*) GetIPClient();
/*N*/ 
/*N*/     // editing an internal OLE switches off our UI
/*N*/ 	if( !pIPClient || !pIPClient->IsUIActive() )
/*N*/     {
/*N*/         SfxItemState nState = rSet.GetItemState(SID_PRESENTATION);
/*N*/         if( pDocSh->IsPreview() || SFX_ITEM_DISABLED == nState )
/*N*/             aPresentationBtn.Disable();
/*N*/         else if( SFX_ITEM_UNKNOWN != nState )
/*N*/             aPresentationBtn.Enable();
/*N*/ 
/*N*/         nState = rSet.GetItemState(SID_NOTESMODE);
/*N*/         if( SFX_ITEM_DISABLED == nState )
/*N*/             aNotesBtn.Disable();
/*N*/         else if( SFX_ITEM_UNKNOWN != nState )
/*N*/             aNotesBtn.Enable();
/*N*/ 
/*N*/         nState = rSet.GetItemState(SID_HANDOUTMODE);
/*N*/         if( SFX_ITEM_DISABLED == nState )
/*N*/             aHandoutBtn.Disable();
/*N*/         else if( SFX_ITEM_UNKNOWN != nState )
/*N*/             aHandoutBtn.Enable();
/*N*/ 
/*N*/         nState = rSet.GetItemState(SID_OUTLINEMODE);
/*N*/         if( SFX_ITEM_DISABLED == nState )
/*N*/             aOutlineBtn.Disable();
/*N*/         else if( SFX_ITEM_UNKNOWN != nState )
/*N*/             aOutlineBtn.Enable();
/*N*/ 
/*N*/         nState = rSet.GetItemState(SID_DIAMODE);
/*N*/         if( SFX_ITEM_DISABLED == nState )
/*N*/             aSlideBtn.Disable();
/*N*/         else if( SFX_ITEM_UNKNOWN != nState )
/*N*/             aSlideBtn.Enable();
/*N*/ 
/*N*/         nState = rSet.GetItemState(SID_DRAWINGMODE);
/*N*/         if( SFX_ITEM_DISABLED == nState )
/*N*/             aDrawBtn.Disable();
/*N*/         else if( SFX_ITEM_UNKNOWN != nState )
/*N*/             aDrawBtn.Enable();
/*N*/ 
/*N*/         // these are manually changed from SdDrawViewShell::ActivateObject()
/*N*/         // and SdDrawViewShell::SelectionHasChanged
/*N*/         // aTabControl.Enable();
/*N*/         // aLayerTab.Enable();	  
/*N*/     }
/*N*/ }




//STRIP001 void SdDrawViewShell::GetState (SfxItemSet& rSet)
//STRIP001 {
//STRIP001     // Iterate over all requested items in the set.
//STRIP001 	SfxWhichIter aIter( rSet );
//STRIP001 	USHORT nWhich = aIter.FirstWhich();
//STRIP001 	while (nWhich)
//STRIP001 	{
//STRIP001 		switch (nWhich)
//STRIP001 		{
//STRIP001 			case SID_SEARCH_ITEM:
//STRIP001 			case SID_SEARCH_OPTIONS:
//STRIP001                 // Forward this request to the the common (old) code of the
//STRIP001                 // document shell.
//STRIP001                 pDocSh->GetState (rSet);
//STRIP001                 break;
//STRIP001 			default:
//STRIP001                 OSL_TRACE ("SdDrawViewShell::GetState(): can not handle which id %d", nWhich);
//STRIP001                 break;
//STRIP001 		}
//STRIP001 		nWhich = aIter.NextWhich();
//STRIP001 	}
//STRIP001 }




//STRIP001 void SdDrawViewShell::Execute (SfxRequest& rReq)
//STRIP001 {
//STRIP001     FuSlideShow* pFuSlideShow = GetSlideShow();
//STRIP001     if (pFuSlideShow!=NULL && !pFuSlideShow->IsLivePresentation())
//STRIP001     {
//STRIP001         // Do not execute anything during a native slide show.
//STRIP001         return;
//STRIP001 	}
//STRIP001 
//STRIP001 	switch (rReq.GetSlot())
//STRIP001 	{
//STRIP001 		case SID_SEARCH_ITEM:
//STRIP001             // Forward this request to the the common (old) code of the
//STRIP001             // document shell.
//STRIP001             pDocSh->Execute (rReq);
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001             OSL_TRACE ("SdDrawViewShell::Execute(): can not handle slot %d", rReq.GetSlot());
//STRIP001             break;
//STRIP001 	}
//STRIP001 }
}
