/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_WindowUpdater.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:33:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "WindowUpdater.hxx"

// auto strip #include "viewshel.hxx"
// auto strip #include "sdwindow.hxx"
// auto strip #include "preview.hxx"
// auto strip #include "drawdoc.hxx"
// auto strip #include "showwin.hxx"
// auto strip #include "sdview.hxx"

// auto strip #ifndef _SPLIT_HXX
// auto strip #include <vcl/split.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_CHILDWIN_HXX
// auto strip #include <bf_sfx2/childwin.hxx>
// auto strip #endif
// auto strip #ifndef _SFXVIEWFRM_HXX
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #endif
// auto strip #ifndef _SFXSMPLHINT_HXX
// auto strip #include <svtools/smplhint.hxx>
// auto strip #endif

#include <algorithm>
namespace binfilter {

namespace sd {

/*N*/ WindowUpdater::WindowUpdater (void)
/*N*/     : mpViewShell (NULL),
/*N*/       mpDocument (NULL)
/*N*/ {
/*N*/     StartListening (maCTLOptions);
/*N*/ }




/*N*/ WindowUpdater::~WindowUpdater (void) throw ()
/*N*/ {
/*N*/     EndListening (maCTLOptions);
/*N*/ }




//STRIP001 void WindowUpdater::RegisterWindow (Window* pWindow)
//STRIP001 {
//STRIP001     if (pWindow != NULL)
//STRIP001     {
//STRIP001         tWindowList::iterator aWindowIterator (
//STRIP001             ::std::find (
//STRIP001                 maWindowList.begin(), maWindowList.end(), pWindow));
//STRIP001         if (aWindowIterator == maWindowList.end())
//STRIP001         {
//STRIP001             // Update the device once right now and add it to the list.
//STRIP001             Update (pWindow);
//STRIP001             maWindowList.push_back (pWindow);
//STRIP001         }
//STRIP001     }
//STRIP001 }




//STRIP001 void WindowUpdater::UnregisterWindow (Window* pWindow)
//STRIP001 {
//STRIP001     tWindowList::iterator aWindowIterator (
//STRIP001         ::std::find (
//STRIP001             maWindowList.begin(), maWindowList.end(), pWindow));
//STRIP001     if (aWindowIterator != maWindowList.end())
//STRIP001     {
//STRIP001         maWindowList.erase (aWindowIterator);
//STRIP001     }
//STRIP001 }



/*N*/ void WindowUpdater::SetViewShell (SdViewShell& rViewShell)
/*N*/ {
/*N*/     mpViewShell = &rViewShell;
/*N*/ }




/*N*/ void WindowUpdater::SetDocument (SdDrawDocument* pDocument)
/*N*/ {
/*N*/     mpDocument = pDocument;
/*N*/ }




//STRIP001 void WindowUpdater::RegisterPreview (void)
//STRIP001 {
//STRIP001     RegisterWindow (GetPreviewWindow());
//STRIP001 }




//STRIP001 void WindowUpdater::UnregisterPreview (void)
//STRIP001 {
//STRIP001     UnregisterWindow (GetPreviewWindow());
//STRIP001 }




//STRIP001 Window* WindowUpdater::GetPreviewWindow (void) const
//STRIP001 {
//STRIP001     SdShowWindow* pShowWindow = NULL;
//STRIP001 
//STRIP001     // Get the show window of the preview.
//STRIP001     if (mpViewShell != NULL)
//STRIP001     {
//STRIP001         SfxChildWindow* pPreviewChildWindow = 
//STRIP001             mpViewShell->GetViewFrame()->GetChildWindow (
//STRIP001                 SdPreviewChildWindow::GetChildWindowId());
//STRIP001         if (pPreviewChildWindow != NULL)
//STRIP001         {
//STRIP001             SdPreviewWin* pPreviewWindow = 
//STRIP001                 static_cast<SdPreviewWin*> (pPreviewChildWindow->GetWindow());
//STRIP001             if (pPreviewWindow!=NULL && pPreviewWindow->GetDoc()==mpViewShell->GetDoc())
//STRIP001                 pShowWindow = pPreviewWindow->GetShowWindow();
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     return pShowWindow;
//STRIP001 }




//STRIP001 void WindowUpdater::Update (
//STRIP001     OutputDevice* pDevice,
//STRIP001     SdDrawDocument* pDocument) const
//STRIP001 {
//STRIP001     if (pDevice != NULL)
//STRIP001     {
//STRIP001         UpdateWindow (pDevice);
//STRIP001         if (pDocument != NULL)
//STRIP001             pDocument->ReformatAllTextObjects();
//STRIP001     }
//STRIP001 }




//STRIP001 void WindowUpdater::UpdateWindow (OutputDevice* pDevice) const
//STRIP001 {
//STRIP001     if (pDevice != NULL)
//STRIP001     {
//STRIP001         SvtCTLOptions::TextNumerals aNumeralMode (maCTLOptions.GetCTLTextNumerals());
//STRIP001 
//STRIP001         LanguageType aLanguage;
//STRIP001         // Now this is a bit confusing.  The numerals in arabic languages
//STRIP001         // are Hindi numerals and what the western world generally uses are
//STRIP001         // arabic numerals.  The digits used in the Hindi language are not
//STRIP001         // used at all.
//STRIP001         switch (aNumeralMode)
//STRIP001         {
//STRIP001             case SvtCTLOptions::NUMERALS_HINDI:
//STRIP001                 aLanguage = LANGUAGE_ARABIC;
//STRIP001                 break;
//STRIP001 
//STRIP001             case SvtCTLOptions::NUMERALS_SYSTEM:
//STRIP001                 aLanguage = LANGUAGE_SYSTEM;
//STRIP001                 break;
//STRIP001 
//STRIP001             case SvtCTLOptions::NUMERALS_ARABIC:
//STRIP001             default:
//STRIP001                 aLanguage = LANGUAGE_ENGLISH;
//STRIP001                 break;
//STRIP001         }
//STRIP001 
//STRIP001         pDevice->SetDigitLanguage (aLanguage);
//STRIP001     }
//STRIP001 }




//STRIP001 void WindowUpdater::Notify (SfxBroadcaster& rBC, const SfxHint& rHint)
//STRIP001 {
//STRIP001     const SfxSimpleHint& rSimpleHint = static_cast<const SfxSimpleHint&>(rHint);
//STRIP001     if (rSimpleHint.GetId() == SFX_HINT_CTL_SETTINGS_CHANGED)
//STRIP001     {
//STRIP001         // Clear the master page cache so that master pages will be redrawn.
//STRIP001         if (mpViewShell != NULL)
//STRIP001         {
//STRIP001             SdView* pView = mpViewShell->GetView();
//STRIP001             if (pView != NULL)
//STRIP001                 pView->ReleaseMasterPagePaintCache ();
//STRIP001         }
//STRIP001         // Set the current state at all registered output devices.
//STRIP001         tWindowList::iterator aWindowIterator (maWindowList.begin());
//STRIP001         while (aWindowIterator != maWindowList.end())
//STRIP001             Update (*aWindowIterator++);
//STRIP001 
//STRIP001         // Reformat the document for the modified state to take effect.
//STRIP001         if (mpDocument != NULL)
//STRIP001             mpDocument->ReformatAllTextObjects();
//STRIP001         
//STRIP001         // Invalidate the windows to make the modified state visible.
//STRIP001         aWindowIterator = maWindowList.begin();
//STRIP001         while (aWindowIterator != maWindowList.end())
//STRIP001             (*aWindowIterator++)->Invalidate();
//STRIP001     }
//STRIP001 }


} // end of namespace sd
}
