/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: speedctl.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:08:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

//STRIP001 #ifndef _SPEEDCTL_HXX
//STRIP001 #define _SPEEDCTL_HXX

//STRIP001 #include <tools/solar.h>

// ----------------
// - SpeedControl -
// ----------------

//STRIP001 class	OutputDevice;
//STRIP001 class	Polygon;
//STRIP001 class	Point;

//STRIP001 class SpeedControl
//STRIP001 {
//STRIP001 protected:
//STRIP001 
//STRIP001 	Window*		mpWin;
//STRIP001 	double		mfUnitsPerSec;
//STRIP001 	double		mfCurStep;
//STRIP001 	double		mfLastStep;
//STRIP001 	double		mfCumulatedSteps;
//STRIP001 	double		mfLastCumulatedSteps;
//STRIP001 	ULONG		mnLastTime;
//STRIP001 	ULONG		mnCurStep;
//STRIP001 	ULONG		mnLastStep;
//STRIP001 	ULONG       mnMagic;
//STRIP001 
//STRIP001 	void 		ImplInit( Window* pWin, const double& rUnitsPerSec );
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 				SpeedControl();
//STRIP001 				~SpeedControl();
//STRIP001 
//STRIP001 	void		Terminate() { mnMagic = 0; }
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 	void		Reset( Window* pWin, const double& rUnitsPerSec );
//STRIP001 	ULONG		GetNextStep();
//STRIP001 };

// ---------------------
// - MoverSpeedControl -
// ---------------------

//STRIP001 struct DistInfo;

//STRIP001 class MoverSpeedControl : public SpeedControl
//STRIP001 {
//STRIP001 protected:
//STRIP001 
//STRIP001 	DistInfo*	mpDist;
//STRIP001 	ULONG		mnDistCount;
//STRIP001 	ULONG		mnActDistPos;
//STRIP001 	double		mfTotalDist;
//STRIP001 	double		mfStartScaleX;
//STRIP001 	double		mfStartScaleY;
//STRIP001 	double		mfEndScaleX;
//STRIP001 	double		mfEndScaleY;
//STRIP001 	BOOL		mbScaleOnly;
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 				MoverSpeedControl();
//STRIP001 				~MoverSpeedControl();
//STRIP001 
//STRIP001 public: 
//STRIP001 
//STRIP001 	void		Reset( const Polygon& rPath, Window* pWin,
//STRIP001 					   const double& rUnitsPerSec, 
//STRIP001 					   const double& rStartScaleX, const double& rEndScaleX,
//STRIP001 					   const double& rStartScaleY, const double& rEndScaleY );
//STRIP001 	BOOL		GetNextPathPoint( Point& rPt, double& rScaleX, double& rScaleY );
//STRIP001 };

//STRIP001 #endif // _SPEEDCTL_HXX
