/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: outlinfo.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:58:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

//STRIP001 #ifndef _OUTLINFO_HXX
//STRIP001 #define _OUTLINFO_HXX
//STRIP001 
//STRIP001 #ifndef _GEN_HXX //autogen
//STRIP001 #include <tools/gen.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SV_OUTDEV_HXX //autogen
//STRIP001 #include <vcl/outdev.hxx>
//STRIP001 #endif

// ---------------
// - SdLaserInfo -
// ---------------

//STRIP001 struct OutlinerCharacter
//STRIP001 {
//STRIP001 	Rectangle	aRect;
//STRIP001 	ULONG		nPara;
//STRIP001 	Color		aColor;
//STRIP001 	
//STRIP001 	// #101500# Removed CharCode, it's only used in one place to compare
//STRIP001 	// for single space character. This can be done at creation, too.
//STRIP001 	//USHORT		nCharCode;
//STRIP001 
//STRIP001 	OutlinerCharacter( const Rectangle& _rRect, ULONG _nPara, const Color& _rCol /* #101500#, USHORT _nCharCode*/ ) 
//STRIP001 	:	aRect( _rRect ), 
//STRIP001 		nPara( _nPara ), 
//STRIP001 		aColor( _rCol ) 
//STRIP001 	{
//STRIP001 	}
//STRIP001 };

// -----------------------------------------------------------------------------

//STRIP001 struct OutlinerParagraph
//STRIP001 {
//STRIP001 	Rectangle	aRect;
//STRIP001 	ULONG		nCharCount;
//STRIP001 
//STRIP001 				OutlinerParagraph() : nCharCount( 0 ) {}
//STRIP001 				~OutlinerParagraph() {};
//STRIP001 };

// ----------------
// - OutlinerInfo -
// ----------------

//STRIP001 class DrawPortionInfo;
//STRIP001 class SdDrawDocument;
//STRIP001 class SdrRectObj;

//STRIP001 class OutlinerInfo
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 	List				aCharacterList;
//STRIP001 	Rectangle			aObjBound;
//STRIP001 	Rectangle			aParaBound;
//STRIP001 	Point				aTextOffset;
//STRIP001 	OutlinerParagraph*	pParagraphs;
//STRIP001 	OutputDevice*		pOut;
//STRIP001 	ULONG				nParaCount;
//STRIP001 	ULONG				nCurPara;
//STRIP001 	long				nExtraData;
//STRIP001 	BOOL				bInit;
//STRIP001 	BOOL				mbVertical;
//STRIP001 
//STRIP001 						OutlinerInfo( const OutlinerInfo& rInfo ) {}
//STRIP001 	OutlinerInfo&		operator=( const OutlinerInfo& rInfo ) { return *this; }
//STRIP001 
//STRIP001 						DECL_LINK( DrawPortionHdl, DrawPortionInfo* );
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 						OutlinerInfo();
//STRIP001 						~OutlinerInfo();
//STRIP001 
//STRIP001 	void				Clear();
//STRIP001 
//STRIP001 	void				SetTextObj( SdDrawDocument* pDoc, SdrRectObj* pObj, OutputDevice* _pOut );
//STRIP001 
//STRIP001 	const Rectangle&	GetObjRect() const { return aObjBound; }
//STRIP001 	const Rectangle&	GetTextRect() const { return aParaBound; }
//STRIP001 	const Point&		GetTextOffset() const { return aTextOffset; }
//STRIP001 
//STRIP001 	const ULONG			GetParaCount() const { return nParaCount; }
//STRIP001 	
//STRIP001 	const Rectangle&	GetParaRect( const ULONG nPara ) const;
//STRIP001 	BOOL				GetParaCharCount( const ULONG nPara ) const;
//STRIP001 
//STRIP001 	ULONG				GetCharacterCount() const { return aCharacterList.Count(); }
//STRIP001 	OutlinerCharacter*	GetCharacter( ULONG nPos ) const { return (OutlinerCharacter*) aCharacterList.GetObject( nPos ); };
//STRIP001 	OutlinerCharacter*	GetFirstCharacter() { return (OutlinerCharacter*) aCharacterList.First(); }
//STRIP001 	OutlinerCharacter*	GetNextCharacter() { return (OutlinerCharacter*) aCharacterList.Next(); }
//STRIP001 
//STRIP001 	void				SetExtraData( const long _nExtraData = 0L ) { nExtraData = _nExtraData; }
//STRIP001 	const long			GetExtraData() const { return nExtraData; }
//STRIP001 
//STRIP001 	BOOL IsVertical() const { return mbVertical; }
//STRIP001 };

//STRIP001 #endif
