/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: SdOutlinerIteratorImpl.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:29:07 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SD_OUTLINER_ITERATOR_IMPL_HXX
#define _SD_OUTLINER_ITERATOR_IMPL_HXX

#include "SdOutlinerIterator.hxx"
#include <tools/debug.hxx> //STRIP001 
class SdrObjListIter;
namespace binfilter {
class SdDrawDocument;
class SdDrawViewShell;
class SdPage;

namespace sd { namespace outliner {

class IteratorImplBase;

/** Base class for the polymorphic implementation class of the
    <type>Iterator</type> class.  The iterators based on this class are
    basically uni directional iterators.  Their direction can, however, be
    reversed at any point of their life time.
*/
class IteratorImplBase
{
public: 
//STRIP001     /** The constructor stores the given arguments to be used by the derived
//STRIP001         classes.
//STRIP001         @param pDocument
//STRIP001             The document provides the information to be iterated on.
//STRIP001         @param pViewShell
//STRIP001             Some information has to be taken from the view shell.
//STRIP001         @param bDirectionIsForward
//STRIP001             This flag defines the iteration direction.  When <TRUE/> then
//STRIP001             the direction is forwards otherwise it is backwards.
//STRIP001     */
    IteratorImplBase (SdDrawDocument* pDocument, SdDrawViewShell* pViewShell, 
        bool bDirectionIsForward){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 bool bDirectionIsForward);
    IteratorImplBase (SdDrawDocument* pDocument, SdDrawViewShell* pViewShell, 
        bool bDirectionIsForward, PageKind ePageKind, EditMode eEditMode){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 bool bDirectionIsForward, PageKind ePageKind, EditMode eEditMode);
    virtual ~IteratorImplBase (void){DBG_BF_ASSERT(0, "STRIP");} //STRIP001 virtual ~IteratorImplBase (void);
//STRIP001 
//STRIP001     /** Advance to the next object.  This takes the iteration direction into
//STRIP001         account.  The new object pointed to can be retrieved (among other
//STRIP001         information) by calling the <member>GetPosition</member> method.
//STRIP001     */
//STRIP001     virtual void GotoNextObject (void) = 0;
//STRIP001     /** Return an object that describes the current object.
//STRIP001         @return
//STRIP001             The returned object describes the current object pointed to by
//STRIP001             the iterator.  See the description of
//STRIP001             <type>IteratorPosition</type> for details on the available
//STRIP001             information.
//STRIP001     */
//STRIP001     virtual const IteratorPosition& GetPosition (void);
//STRIP001     /** Create an exact copy of this object.  No argument should be
//STRIP001         specified when called from the outside.  It then creates an object
//STRIP001         first and passes that to the inherited <member>Clone()</member>
//STRIP001         methods to fill in class specific information.
//STRIP001         @return
//STRIP001             Returns a copy of this object.  When this method is called with
//STRIP001             an argument then this value will be returned.
//STRIP001     */
//STRIP001     virtual IteratorImplBase* Clone (IteratorImplBase* pObject=NULL) const;
//STRIP001     /** Test the equality of the this object and the given iterator.  Two
//STRIP001         iterators are taken to be equal when they point to the same object.
//STRIP001         Iteration direction is not taken into account.
//STRIP001         @param rIterator
//STRIP001             The iterator to compare to.
//STRIP001         @return
//STRIP001             When both iterators ar equal <TRUE/> is returned, <FALSE/> otherwise.
//STRIP001     */
//STRIP001     virtual bool operator== (const IteratorImplBase& rIterator) const;
//STRIP001     /** This method is used by the equality operator.  Additionaly to the
//STRIP001         iterator it takes a type information which is taken into account on
//STRIP001         comparison.  It is part of a "multimethod" pattern.
//STRIP001         @param rIterator
//STRIP001             The iterator to compare to.
//STRIP001         @param aType
//STRIP001             The type of the iterator.
//STRIP001         @return
//STRIP001             Returns <TRUE/> when both iterators point to the same object.
//STRIP001     */
//STRIP001     virtual bool IsEqual (const IteratorImplBase& rIterator, IteratorType aType) const;
//STRIP001     /** Reverse the direction of iteration.  The current object stays the same.
//STRIP001     */
//STRIP001     virtual void Reverse (void);
//STRIP001 
//STRIP001 protected:
//STRIP001     /// The current position as returned by <member>GetPosition()</member>.
//STRIP001     IteratorPosition maPosition;
//STRIP001     /// The document on whose data the iterator operates.
//STRIP001     SdDrawDocument* mpDocument;
//STRIP001     /// Necessary secondary source of information.
//STRIP001     SdDrawViewShell* mpViewShell;
//STRIP001     /// Specifies the search direction.
//STRIP001     bool mbDirectionIsForward;
};




/** Iterator all objects that belong to the current mark list
    a.k.a. selection.  It is assumed that all marked objects belong to the
    same page.  It is further assumed that the mark list does not change
    while an iterator is alive.  It is therefore the responsibility of an
    iterator's owner to handle the case of a changed mark list.

    <p>For documentation of the methods please refere to the base class
    <type>IteratorImplBase</type>.</p>
*/
//STRIP001 class SelectionIteratorImpl : public IteratorImplBase
//STRIP001 {
//STRIP001 public:
//STRIP001     SelectionIteratorImpl (const ::std::vector<SdrObject*>& rObjectList,
//STRIP001         sal_Int32 nObjectIndex,
//STRIP001         SdDrawDocument* pDocument, SdDrawViewShell* pViewShell,
//STRIP001         bool bDirectionIsForward);
//STRIP001     SelectionIteratorImpl (const SelectionIteratorImpl& rObject);
//STRIP001     virtual ~SelectionIteratorImpl (void);
//STRIP001 
//STRIP001     virtual void GotoNextObject (void);
//STRIP001     virtual const IteratorPosition& GetPosition (void);
//STRIP001     virtual IteratorImplBase* Clone (IteratorImplBase* pObject) const;
//STRIP001     virtual bool operator== (const IteratorImplBase& rIterator) const;
//STRIP001 
//STRIP001 private:
//STRIP001     const ::std::vector<SdrObject*>& mrObjectList;
//STRIP001     sal_Int32 mnObjectIndex;
//STRIP001 
//STRIP001     /** Compare the given iterator with this object.  This method handles
//STRIP001         only the case that the given iterator is an instance of this class.
//STRIP001         @param rIterator
//STRIP001             The iterator to compare to.
//STRIP001         @param aType
//STRIP001             The type of the iterator.
//STRIP001         @return
//STRIP001             Returns <TRUE/> when both iterators point to the same object.
//STRIP001     */
//STRIP001     virtual bool IsEqual (const IteratorImplBase& rIterator, IteratorType aType) const; 
//STRIP001 
//STRIP001     IteratorImplBase& operator= (const IteratorImplBase& rIterator);
//STRIP001 };


/** Iterator for iteration over all objects in a single view.  On reaching
    the last object on the last page (or the first object on the first page)
    the view is *not* switched.  Further calls to the
    <member>GotoNextObject()</member> method will be ignored.

    <p>For documentation of the methods please refere to the base class
    <type>IteratorImplBase</type>.</p>
*/
//STRIP001 class ViewIteratorImpl : public IteratorImplBase
//STRIP001 {
//STRIP001 public:
//STRIP001     ViewIteratorImpl (sal_Int32 nPageIndex, 
//STRIP001         SdDrawDocument* pDocument, SdDrawViewShell* pViewShell,
//STRIP001         bool bDirectionIsForward);
//STRIP001     ViewIteratorImpl (sal_Int32 nPageIndex, 
//STRIP001         SdDrawDocument* pDocument, SdDrawViewShell* pViewShell,
//STRIP001         bool bDirectionIsForward, PageKind ePageKind, EditMode eEditMode);
//STRIP001     virtual ~ViewIteratorImpl (void);
//STRIP001 
//STRIP001     virtual void GotoNextObject (void);
//STRIP001     virtual IteratorImplBase* Clone (IteratorImplBase* pObject) const;
//STRIP001     virtual void Reverse (void);
//STRIP001 
//STRIP001 protected:
//STRIP001     /// Number of pages in the view that is specified by <member>maPosition</member>.
//STRIP001     sal_Int32 mnPageCount;
//STRIP001 
//STRIP001     /** Initialize this iterator with respect to the given location.  After
//STRIP001         this call the object looks like newly constructed.
//STRIP001     */
//STRIP001     void Init (IteratorLocation aLocation);
//STRIP001 
//STRIP001     /** Set up page pointer and object list iterator for the specified
//STRIP001         page.
//STRIP001         @param nPageIndex
//STRIP001             Index of the new page.  It may lie outside the valid range for
//STRIP001             page indices.
//STRIP001     */
//STRIP001     void SetPage (sal_Int32 nPageIndex);
//STRIP001 
//STRIP001 private:
//STRIP001     /// Indicates whether a page changed occured on switching to current page.
//STRIP001     bool mbPageChangeOccured;
//STRIP001     /// Pointer to the page associated with the current page index. May be NULL.
//STRIP001     SdPage* mpPage;
//STRIP001     /// Iterator of all objects on the current page.
//STRIP001     SdrObjListIter* mpObjectIterator;
//STRIP001 
//STRIP001     // Don't use this operator.
//STRIP001     ViewIteratorImpl& operator= (const ViewIteratorImpl&){return *this;};
//STRIP001 };


/** Iterator for iteration over all objects in all views.  It automatically
    switches views when reaching the end/beginning of a view.

    <p>For documentation of the methods please refere to the base class
    <type>IteratorImplBase</type>.</p>
*/
//STRIP001 class DocumentIteratorImpl : public ViewIteratorImpl
//STRIP001 {
//STRIP001 public:
//STRIP001     DocumentIteratorImpl (sal_Int32 nPageIndex,
//STRIP001         PageKind ePageKind, EditMode eEditMode,
//STRIP001         SdDrawDocument* pDocument, SdDrawViewShell* pViewShell,
//STRIP001         bool bDirectionIsForward);
//STRIP001     virtual ~DocumentIteratorImpl (void);
//STRIP001 
//STRIP001     virtual void GotoNextObject (void);
//STRIP001     virtual IteratorImplBase* Clone (IteratorImplBase* pObject) const;
//STRIP001 
//STRIP001 private:
//STRIP001     sal_Int32 mnPageCount;
//STRIP001 
//STRIP001     // Don't use this operator.
//STRIP001     DocumentIteratorImpl& operator= (const DocumentIteratorImpl& rIterator){return *this;};
//STRIP001 };


} } // end of namespace ::sd::outliner

} //namespace binfilter
#endif
