/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_sprite.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:24:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _TOOLS_STREAM_HXX //autogen
// auto strip #include <tools/stream.hxx>
// auto strip #endif
// auto strip #ifndef _TOOLS_DEBUG_HXX //autogen
// auto strip #include <tools/debug.hxx>
// auto strip #endif
// auto strip #ifndef _SV_IMAGE_HXX //autogen
// auto strip #include <vcl/image.hxx>
// auto strip #endif
// auto strip #ifndef _SV_VIRDEV_HXX //autogen
// auto strip #include <vcl/virdev.hxx>
// auto strip #endif
// auto strip #ifndef _SV_WINDOW_HXX //autogen
// auto strip #include <vcl/window.hxx>
// auto strip #endif
// auto strip #ifndef _SV_IMAGE_HXX //autogen
// auto strip #include <vcl/image.hxx>
// auto strip #endif
// auto strip #ifndef _SV_SALBTYPE_HXX //autogen
// auto strip #include <vcl/salbtype.hxx>
// auto strip #endif

// auto strip #include "sprite.hxx"
// auto strip #include "sdmtf.hxx"
namespace binfilter {

#define SPRITE_TIMEDIST (200UL)

// ----------
// - Sprite -
// ----------

//STRIP001 Sprite::Sprite( List* _pListOfImages ) :
//STRIP001 			pPaintDev		( NULL ),
//STRIP001 			pActBmpEx		( NULL ),
//STRIP001 			pListOfBmpEx	( _pListOfImages ),
//STRIP001 			pBottomLayer	( NULL ),
//STRIP001 			pTopLayer		( NULL ),
//STRIP001 			ppTopMtf		( NULL )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 Sprite::~Sprite()
//STRIP001 {
//STRIP001 	delete pPaintDev;
//STRIP001 	delete pBottomLayer;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL Sprite::StartMoving( OutputDevice* pOut,
//STRIP001 						  OutputDevice* _pBottomLayer,
//STRIP001 						  BitmapEx* _pTopLayer,
//STRIP001 						  SdMetaFile** _ppTopMtf,
//STRIP001 						  Marker* _pObjStartMarker,
//STRIP001 						  Marker* _pObjEndMarker )
//STRIP001 {
//STRIP001 	const Size	aOutSizePix( pOut->GetOutputSizePixel() );
//STRIP001 	const Point	aNullPt;
//STRIP001 	BOOL		bRet;
//STRIP001 
//STRIP001 	delete pPaintDev;
//STRIP001 	pPaintDev = new VirtualDevice();
//STRIP001 
//STRIP001 	delete pBottomLayer;
//STRIP001 	pBottomLayer = new VirtualDevice();
//STRIP001 	bRet = pBottomLayer->SetOutputSizePixel( aOutSizePix );
//STRIP001 
//STRIP001 	pTopLayer = _pTopLayer;
//STRIP001 	ppTopMtf = _ppTopMtf;
//STRIP001 	pObjStartMarker = _pObjStartMarker;
//STRIP001 	pObjEndMarker = _pObjEndMarker;
//STRIP001 
//STRIP001 	if( bRet )
//STRIP001 	{
//STRIP001 		if( _pBottomLayer )
//STRIP001 		{
//STRIP001 			const Point aOrigin( _pBottomLayer->PixelToLogic( aNullPt ) );
//STRIP001 			const Size	aOutSize( _pBottomLayer->GetOutputSize() );
//STRIP001 			const Point	aDestOrigin( pOut->LogicToPixel( aOrigin ) );
//STRIP001 			const Size	aDestSize( pOut->LogicToPixel( aOutSize ) );
//STRIP001 
//STRIP001 			pBottomLayer->DrawOutDev( aDestOrigin, aDestSize, aOrigin, aOutSize, *_pBottomLayer );
//STRIP001 			aLayerOffsetPix = aDestOrigin;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pBottomLayer->DrawOutDev( aNullPt, aOutSizePix,
//STRIP001 									  pOut->PixelToLogic( aNullPt ), pOut->GetOutputSize(), *pOut );
//STRIP001 
//STRIP001 			if( pTopLayer )
//STRIP001 				aLayerOffsetPix = pOut->LogicToPixel( _pBottomLayer->PixelToLogic( aNullPt ) );
//STRIP001 			else
//STRIP001 				aLayerOffsetPix = Point();
//STRIP001 		}
//STRIP001 
//STRIP001 		if( pListOfBmpEx )
//STRIP001 			pListOfBmpEx->Last();
//STRIP001 
//STRIP001 		aOldMap = pOut->GetMapMode();
//STRIP001 
//STRIP001 		if( ( bClipRegion = pOut->IsClipRegion() ) == TRUE )
//STRIP001 		{
//STRIP001 			aOldClip = pOut->GetClipRegion();
//STRIP001 			pOut->EnableMapMode( FALSE );
//STRIP001 			pOut->SetClipRegion( pOut->LogicToPixel( aOldClip, aOldMap ) );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pOut->EnableMapMode( FALSE );
//STRIP001 
//STRIP001 		aPaintRect = Rectangle();
//STRIP001 	}
//STRIP001 
//STRIP001 	nLastTime = 0UL;
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Sprite::MoveTo( OutputDevice* pOut, const Point& rPt, const Size* pSz )
//STRIP001 {
//STRIP001 	if( ImplPrepareMoveTo() )
//STRIP001 	{
//STRIP001 		ImplDrawSprite( pOut, 
//STRIP001 					    pOut->LogicToPixel( rPt, aOldMap ), 
//STRIP001 					   ( pSz ? pOut->LogicToPixel( *pSz, aOldMap ) : pActBmpEx->GetSizePixel() ) );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Sprite::MoveTo( OutputDevice* pOut, const Point& rPt, const double& rScaleX, const double& rScaleY )
//STRIP001 {
//STRIP001 	if( ImplPrepareMoveTo() )
//STRIP001 	{
//STRIP001 		const Size& rSizePixel = pActBmpEx->GetSizePixel();
//STRIP001 		const Size	aSzPixel( FRound( rSizePixel.Width() * rScaleX ), 
//STRIP001 							  FRound( rSizePixel.Height() * rScaleY ) );
//STRIP001 
//STRIP001 		ImplDrawSprite( pOut, pOut->LogicToPixel( rPt, aOldMap ), aSzPixel );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Sprite::EndMoving( OutputDevice* pOut )
//STRIP001 {
//STRIP001 	pOut->EnableMapMode( TRUE );
//STRIP001 	
//STRIP001 	if( bClipRegion )
//STRIP001 		pOut->SetClipRegion( aOldClip );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL Sprite::ImplPrepareMoveTo()
//STRIP001 {
//STRIP001 	DBG_ASSERT( pBottomLayer && pPaintDev, "You have to call ::StartMoving(...) first!" );
//STRIP001 	BOOL bRet;
//STRIP001 
//STRIP001 	if( ( bRet = ( pListOfBmpEx != NULL ) ) == TRUE )
//STRIP001 	{
//STRIP001 		if( !nLastTime || ( ( Time::GetSystemTicks() - nLastTime ) >= SPRITE_TIMEDIST ) )
//STRIP001 		{
//STRIP001 			if( !( pActBmpEx = (BitmapEx*) pListOfBmpEx->Next() ) )
//STRIP001 				pActBmpEx = (BitmapEx*) pListOfBmpEx->First();
//STRIP001 
//STRIP001 			nLastTime = Time::GetSystemTicks();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void Sprite::ImplDrawSprite( OutputDevice* pOut, const Point& rPt, const Size& rSz )
//STRIP001 {
//STRIP001 	const Rectangle aSpriteRect( rPt, rSz );
//STRIP001 
//STRIP001 	// calculate total paint rect
//STRIP001 	aPaintRect.Union( aSpriteRect );
//STRIP001 
//STRIP001 	const Point	aNewPt( aPaintRect.TopLeft() );
//STRIP001 	const Size	aNewSize( aPaintRect.GetSize() );
//STRIP001 
//STRIP001 	pPaintDev->SetOutputSizePixel( aNewSize, FALSE );
//STRIP001 	
//STRIP001 	// BottomLayer
//STRIP001 	pPaintDev->DrawOutDev( Point(), aNewSize, aNewPt, aNewSize, *pBottomLayer );
//STRIP001 
//STRIP001 	// Sprite
//STRIP001 	pPaintDev->DrawBitmapEx( rPt - aNewPt, rSz, *pActBmpEx );
//STRIP001 
//STRIP001 	// TopLayer
//STRIP001 	if( pTopLayer )
//STRIP001 		pPaintDev->DrawBitmapEx( Point(), aNewSize, aNewPt - aLayerOffsetPix, aNewSize, *pTopLayer );
//STRIP001 	else if( ppTopMtf && *ppTopMtf && pObjEndMarker )
//STRIP001 	{
//STRIP001 		MapMode		aTempMap( aOldMap );
//STRIP001 		const Point	aNewTL( pOut->PixelToLogic( aNewPt, aTempMap ) );
//STRIP001 
//STRIP001 		aTempMap.SetOrigin( Point( -aNewTL.X(), -aNewTL.Y() ) );
//STRIP001 		pPaintDev->SetMapMode( aTempMap );
//STRIP001 		(*ppTopMtf)->Play( pPaintDev, *pObjEndMarker, MTF_END );
//STRIP001 		pPaintDev->SetMapMode( MapMode() );
//STRIP001 	}
//STRIP001 
//STRIP001 	// copy back
//STRIP001 	pOut->DrawOutDev( aNewPt, aNewSize, Point(), aNewSize, *pPaintDev );
//STRIP001 
//STRIP001 	// update paint rect
//STRIP001 	aPaintRect = aSpriteRect;
//STRIP001 }
}
