/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_fupoor.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:15:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#include <bf_svx/svxids.hrc>

#ifndef _AEITEM_HXX //autogen
#include <svtools/aeitem.hxx>
#endif
// auto strip #ifndef _SVDPAGV_HXX //autogen
// auto strip #include <bf_svx/svdpagv.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOOLE2_HXX
// auto strip #include <bf_svx/svdoole2.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOGRAF_HXX
// auto strip #include <bf_svx/svdograf.hxx>
// auto strip #endif
#ifndef _SV_SELENG_HXX //autogen
#include <vcl/seleng.hxx>
#endif
// auto strip #ifndef _SFXAPP_HXX //autogen
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_BINDINGS_HXX //autogen
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #endif
#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif
#ifndef _SV_DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif
// auto strip #ifndef _SFXSTBMGR_HXX //autogen
// auto strip #include <bf_sfx2/stbmgr.hxx>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
// auto strip #include <com/sun/star/beans/XPropertySet.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_DRAWING_XLAYER_HPP_
// auto strip #include <com/sun/star/drawing/XLayer.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_DRAWING_XLAYERMANAGER_HPP_
// auto strip #include <com/sun/star/drawing/XLayerManager.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_CONTAINER_XCHILD_HPP_
// auto strip #include <com/sun/star/container/XChild.hpp>
// auto strip #endif

// auto strip #include "frmview.hxx"

#include "app.hrc"

// auto strip #include "fupoor.hxx"
// auto strip #include "fusel.hxx"
// auto strip #include "sdpage.hxx"
#include "drawview.hxx"
// auto strip #include "drviewsh.hxx"
#include "sdwindow.hxx"
#include "drawdoc.hxx"
// auto strip #include "docshell.hxx"
// auto strip #include "zoomlist.hxx"
// auto strip #include "sdclient.hxx"
#include "fuslshow.hxx"

// #97016# IV
// auto strip #ifndef _SVDITER_HXX
// auto strip #include <bf_svx/svditer.hxx>
// auto strip #endif

// #98533#
// auto strip #ifndef _MyEDITENG_HXX
// auto strip #include <bf_svx/editeng.hxx>
// auto strip #endif
namespace binfilter {

using namespace ::com::sun::star;
using ::com::sun::star::uno::Reference;


TYPEINIT0( FuPoor );

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

/*N*/ FuPoor::FuPoor(SdViewShell* pViewSh, SdWindow* pWin, SdView* pView,
/*N*/ 			   SdDrawDocument* pDrDoc, SfxRequest& rReq) :
/*N*/ 	pViewShell(pViewSh),
/*N*/ 	pWindow(pWin),
/*N*/ 	pView(pView),
/*N*/ 	pDoc(pDrDoc),
/*N*/ 	pDocSh( pDrDoc->GetDocSh() ),
/*N*/ 	nSlotId( rReq.GetSlot() ),
/*N*/ 	pDialog(NULL),
/*N*/ 	bIsInDragMode(FALSE),
/*N*/ 	bScrollable (FALSE),
/*N*/ 	bDelayActive (FALSE),
/*N*/ 	bNoScrollUntilInside (TRUE),
/*N*/ 	nSlotValue(0),
/*N*/ 	// #95491# remember MouseButton state
/*N*/ 	mnCode(0)
/*N*/ {
/*N*/ 	ReceiveRequest(rReq);
/*N*/ 
/*N*/ 	aScrollTimer.SetTimeoutHdl( LINK(this, FuPoor, ScrollHdl) );
/*N*/ 	aScrollTimer.SetTimeout(SELENG_AUTOREPEAT_INTERVAL);
/*N*/ 
/*N*/ 	aDragTimer.SetTimeoutHdl( LINK(this, FuPoor, DragHdl) );
/*N*/ 	aDragTimer.SetTimeout(SELENG_DRAGDROP_TIMEOUT);
/*N*/ 
/*N*/ 	aDelayToScrollTimer.SetTimeoutHdl( LINK(this, FuPoor, DelayHdl) );
/*N*/ 	aDelayToScrollTimer.SetTimeout(2000);
/*N*/ }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

/*N*/ FuPoor::~FuPoor()
/*N*/ {
/*N*/ 	aDragTimer.Stop();
/*N*/ 	aScrollTimer.Stop();
/*N*/ 	aDelayToScrollTimer.Stop ();

/*N*/ 	if (pDialog)
/*?*/ 		delete pDialog;
/*N*/ }

/*************************************************************************
|*
|* Function aktivieren
|*
\************************************************************************/

/*N*/ void FuPoor::Activate()
/*N*/ {
/*N*/ 	if (pDialog)
/*?*/ 	{
/*?*/ 		pDialog->Show();
/*?*/ 	}
/*N*/ }

/*************************************************************************
|*
|* Function deaktivieren
|*
\************************************************************************/

/*N*/ void FuPoor::Deactivate()
/*N*/ {
/*N*/ 	aDragTimer.Stop();
/*N*/ 	aScrollTimer.Stop();
/*N*/ 	aDelayToScrollTimer.Stop ();
/*N*/ 		bScrollable  =
/*N*/ 		bDelayActive = FALSE;

/*N*/ 	if (pDialog)
/*?*/ 	{
/*?*/ 		pDialog->Hide();
/*?*/ 	}

/*N*/ 	if (pWindow) pWindow->ReleaseMouse ();
/*N*/ }

/*************************************************************************
|*
|* Scrollen bei Erreichen des Fensterrandes; wird von
|* MouseMove aufgerufen
|*
\************************************************************************/

//STRIP001 void FuPoor::ForceScroll(const Point& aPixPos)
//STRIP001 {
//STRIP001 	aScrollTimer.Stop();
//STRIP001 
//STRIP001 	if ( !pView->IsDragHelpLine() && !pView->IsSetPageOrg() &&
//STRIP001 		 !pViewShell->GetSlideShow() )
//STRIP001 	{
/*		Size aSize = pWindow->GetSizePixel();
		short dx = 0, dy = 0;

		if ( aPixPos.X() <= 0			   ) dx = -1;
		if ( aPixPos.X() >= aSize.Width()  ) dx =  1;
		if ( aPixPos.Y() <= 0			   ) dy = -1;
		if ( aPixPos.Y() >= aSize.Height() ) dy =  1;
*/
//STRIP001 		Point aPos = pWindow->OutputToScreenPixel(aPixPos);
//STRIP001 		const Rectangle& rRect = pViewShell->GetAllWindowRect();
//STRIP001 
//STRIP001 		if ( bNoScrollUntilInside )
//STRIP001 		{
//STRIP001 			if ( rRect.IsInside(aPos) )
//STRIP001 				bNoScrollUntilInside = FALSE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			short dx = 0, dy = 0;
//STRIP001 
//STRIP001 			if ( aPos.X() <= rRect.Left()	) dx = -1;
//STRIP001 			if ( aPos.X() >= rRect.Right()	) dx =	1;
//STRIP001 			if ( aPos.Y() <= rRect.Top()	) dy = -1;
//STRIP001 			if ( aPos.Y() >= rRect.Bottom() ) dy =	1;
//STRIP001 
//STRIP001 			if ( dx != 0 || dy != 0 )
//STRIP001 			{
//STRIP001 				if (bScrollable)
//STRIP001 				{
//STRIP001 					// Scrollaktion in abgeleiteter Klasse
//STRIP001 					ScrollStart();
//STRIP001 					pViewShell->ScrollLines(dx, dy);
//STRIP001 					ScrollEnd();
//STRIP001 					aScrollTimer.Start();
//STRIP001 				}
//STRIP001 				else if (! bDelayActive) StartDelayToScrollTimer ();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Timer-Handler fuer Fensterscrolling
|*
\************************************************************************/

IMPL_LINK_INLINE_START( FuPoor, ScrollHdl, Timer *, pTimer )
{
	DBG_BF_ASSERT(0, "STRIP"); //STRIP001  	Point aPnt(pWindow->GetPointerPosPixel());
//STRIP001 	
//STRIP001 	// #95491# use remembered MouseButton state to create correct
//STRIP001 	// MouseEvents for this artifical MouseMove.
//STRIP001 	MouseMove(MouseEvent(aPnt, 1, 0, GetMouseButtonCode()));
//STRIP001 
	return 0;
}
IMPL_LINK_INLINE_END( FuPoor, ScrollHdl, Timer *, pTimer )

/*************************************************************************
|*
|* String in Applikations-Statuszeile ausgeben
|*
\************************************************************************/

//STRIP001 void FuPoor::WriteStatus(const String& aStr)
//STRIP001 {
/*
//	SFX_APP()->SetHelpText(aStr);
	SfxStatusBarManager* pStatBarMan = SFX_APP()->GetStatusBarManager();
	pStatBarMan->ShowHelpText(aStr);
*/
//STRIP001 }

/*************************************************************************
|*
|* Tastaturereignisse bearbeiten
|*
|* Wird ein KeyEvent bearbeitet, so ist der Return-Wert TRUE, andernfalls
|* FALSE.
|*
\************************************************************************/

//STRIP001 BOOL FuPoor::KeyInput(const KeyEvent& rKEvt)
//STRIP001 {
//STRIP001 	USHORT          nCode = rKEvt.GetKeyCode().GetCode();
//STRIP001 	BOOL            bReturn = FALSE;
//STRIP001 	BOOL            bSlideShow = FALSE;
//STRIP001  	FuSlideShow*    pFuSlideShow = pViewShell->GetSlideShow();
//STRIP001 
//STRIP001 	if( pFuSlideShow )
//STRIP001 		bSlideShow = TRUE;
//STRIP001 
//STRIP001 	switch (nCode)
//STRIP001 	{
//STRIP001 		// #97016# IV
//STRIP001 		case KEY_RETURN:
//STRIP001 		{
//STRIP001 			if(rKEvt.GetKeyCode().IsMod1())
//STRIP001 			{
//STRIP001 				if(pViewShell && pViewShell->ISA(SdDrawViewShell))
//STRIP001 				{
//STRIP001 					SdDrawViewShell* pDrawViewShell = (SdDrawViewShell*)pViewShell;
//STRIP001 					SdPage* pActualPage = pDrawViewShell->GetActualPage();
//STRIP001 					SdrTextObj* pCandidate = 0L;
//STRIP001 
//STRIP001 					if(pActualPage)
//STRIP001 					{
//STRIP001 						SdrObjListIter aIter(*pActualPage, IM_DEEPNOGROUPS);
//STRIP001 
//STRIP001 						while(aIter.IsMore() && !pCandidate)
//STRIP001 						{
//STRIP001 							SdrObject* pObj = aIter.Next();
//STRIP001 
//STRIP001 							if(pObj && pObj->ISA(SdrTextObj))
//STRIP001 							{
//STRIP001 								sal_uInt32 nInv(pObj->GetObjInventor());
//STRIP001 								sal_uInt16 nKnd(pObj->GetObjIdentifier());
//STRIP001 
//STRIP001 								if(SdrInventor == nInv && 
//STRIP001 									(OBJ_TITLETEXT == nKnd || OBJ_OUTLINETEXT == nKnd || OBJ_TEXT == nKnd))
//STRIP001 								{
//STRIP001 									pCandidate = (SdrTextObj*)pObj;
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					if(pCandidate)
//STRIP001 					{
//STRIP001 						pView->UnMarkAll();
//STRIP001 						pView->MarkObj(pCandidate, pView->GetPageViewPvNum(0));
//STRIP001 
//STRIP001 						pViewShell->GetViewFrame()->GetDispatcher()->Execute(
//STRIP001 							SID_ATTR_CHAR, SFX_CALLMODE_ASYNCHRON);
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						// insert a new page with the same page layout
//STRIP001 						pViewShell->GetViewFrame()->GetDispatcher()->Execute(
//STRIP001 							SID_INSERTPAGE_QUICK, SFX_CALLMODE_ASYNCHRON);
//STRIP001 					}
//STRIP001 
//STRIP001 					// consumed
//STRIP001 					bReturn = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001                 // #98255# activate OLE object on RETURN for selected object
//STRIP001 				// #98198# activate text edit on RETURN for selected object
//STRIP001 				const SdrMarkList& rMarkList = pView->GetMarkList();
//STRIP001 	
//STRIP001 				if( !pView->IsTextEdit() && 1 == rMarkList.GetMarkCount() )
//STRIP001 				{
//STRIP001                     SdrObject* pObj = rMarkList.GetMark( 0 )->GetObj();
//STRIP001 
//STRIP001         			if( pObj && pObj->ISA( SdrOle2Obj ) && !pDocSh->IsUIActive() )
//STRIP001 			        {
//STRIP001                         pView->HideMarkHdl(NULL);
//STRIP001                         pViewShell->ActivateObject( static_cast< SdrOle2Obj* >( pObj ), 0 );
//STRIP001 			        }
//STRIP001 			        else if( pObj && pObj->IsEmptyPresObj() && pObj->ISA( SdrGrafObj ) )
//STRIP001 			        {
//STRIP001 				        pViewShell->GetViewFrame()->GetDispatcher()->Execute( SID_INSERT_GRAPHIC, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
//STRIP001 			        }
//STRIP001                     else
//STRIP001                     {
//STRIP001     					pViewShell->GetViewFrame()->GetDispatcher()->Execute( SID_ATTR_CHAR, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
//STRIP001                     }
//STRIP001 
//STRIP001 					// consumed
//STRIP001 					bReturn = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		// #97016# II
//STRIP001 		case KEY_TAB:
//STRIP001 		{
//STRIP001 			// #98994# handle Mod1 and Mod2 to get travelling running on different systems
//STRIP001 			if(rKEvt.GetKeyCode().IsMod1() || rKEvt.GetKeyCode().IsMod2())
//STRIP001 			{
//STRIP001 				// #97016# II do something with a selected handle?
//STRIP001 				const SdrHdlList& rHdlList = pView->GetHdlList();
//STRIP001 				sal_Bool bForward(!rKEvt.GetKeyCode().IsShift());
//STRIP001 
//STRIP001 				((SdrHdlList&)rHdlList).TravelFocusHdl(bForward);
//STRIP001 
//STRIP001 				// guarantee visibility of focused handle
//STRIP001 				SdrHdl* pHdl = rHdlList.GetFocusHdl();
//STRIP001 
//STRIP001 				if(pHdl)
//STRIP001 				{
//STRIP001 					Point aHdlPosition(pHdl->GetPos());
//STRIP001 					Rectangle aVisRect(aHdlPosition - Point(100, 100), Size(200, 200));
//STRIP001 					pView->MakeVisible(aVisRect, *pWindow);
//STRIP001 				}
//STRIP001 
//STRIP001 				// consumed
//STRIP001 				bReturn = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	
//STRIP001 		case KEY_ESCAPE:
//STRIP001 		{
//STRIP001 			bReturn = FuPoor::cancel();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case KEY_ADD:
//STRIP001 		{
//STRIP001 			if (!pView->IsTextEdit() && !bSlideShow && !pDocSh->IsUIActive())
//STRIP001 			{
//STRIP001 				// Zoom vergroessern
//STRIP001 				pViewShell->SetZoom(pWindow->GetZoom() * 3 / 2);
//STRIP001 
//STRIP001 				if (pViewShell->ISA(SdDrawViewShell))
//STRIP001 					((SdDrawViewShell*) pViewShell)->SetZoomOnPage(FALSE);
//STRIP001 
//STRIP001 				bReturn = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case KEY_SUBTRACT:
//STRIP001 		{
//STRIP001 			if (!pView->IsTextEdit() && !bSlideShow && !pDocSh->IsUIActive())
//STRIP001 			{
//STRIP001 				// Zoom verringern
//STRIP001 				pViewShell->SetZoom(pWindow->GetZoom() * 2 / 3);
//STRIP001 
//STRIP001 				if (pViewShell->ISA(SdDrawViewShell))
//STRIP001 					((SdDrawViewShell*) pViewShell)->SetZoomOnPage(FALSE);
//STRIP001 
//STRIP001 				bReturn = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case KEY_MULTIPLY:
//STRIP001 		{
//STRIP001 			if (!pView->IsTextEdit() && !bSlideShow)
//STRIP001 			{
//STRIP001 				// Zoom auf Seite
//STRIP001 				pViewShell->GetViewFrame()->GetDispatcher()->
//STRIP001 				Execute(SID_SIZE_PAGE, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 				bReturn = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case KEY_DIVIDE:
//STRIP001 		{
//STRIP001 			if (!pView->IsTextEdit() && !bSlideShow)
//STRIP001 			{
//STRIP001 				// Zoom auf selektierte Objekte
//STRIP001 				pViewShell->GetViewFrame()->GetDispatcher()->
//STRIP001 				Execute(SID_SIZE_OPTIMAL, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 				bReturn = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case KEY_POINT:
//STRIP001 		{
//STRIP001 			ZoomList* pZoomList = pViewShell->GetZoomList();
//STRIP001 
//STRIP001 			if (!pView->IsTextEdit() && pZoomList->IsNextPossible() && !bSlideShow && !pDocSh->IsUIActive())
//STRIP001 			{
//STRIP001 				// Naechstes ZoomRect einstellen
//STRIP001 				pViewShell->SetZoomRect(pZoomList->GetNextZoomRect());
//STRIP001 				bReturn = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case KEY_COMMA:
//STRIP001 		{
//STRIP001 			ZoomList* pZoomList = pViewShell->GetZoomList();
//STRIP001 
//STRIP001 			if (!pView->IsTextEdit() && pZoomList->IsPreviousPossible() && !bSlideShow && !pDocSh->IsUIActive())
//STRIP001 			{
//STRIP001 				// Vorheriges ZoomRect einstellen
//STRIP001 				pViewShell->SetZoomRect(pZoomList->GetPreviousZoomRect());
//STRIP001 				bReturn = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case KEY_HOME:
//STRIP001 		{
//STRIP001 			if (!pView->IsTextEdit() && pViewShell->ISA(SdDrawViewShell) && !bSlideShow)
//STRIP001 			{
//STRIP001 			   // Sprung zu erster Seite
//STRIP001 			   ((SdDrawViewShell*) pViewShell)->SwitchPage(0);
//STRIP001 			   bReturn = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case KEY_END:
//STRIP001 		{
//STRIP001 			if (!pView->IsTextEdit() && pViewShell->ISA(SdDrawViewShell) && !bSlideShow)
//STRIP001 			{
//STRIP001 				// Sprung zu letzter Seite
//STRIP001 				SdPage* pPage = ((SdDrawViewShell*) pViewShell)->GetActualPage();
//STRIP001 				((SdDrawViewShell*) pViewShell)->SwitchPage(pDoc->GetSdPageCount(
//STRIP001 												 pPage->GetPageKind()) - 1);
//STRIP001 				bReturn = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case KEY_PAGEUP:
//STRIP001 		{
//STRIP001 			if(pViewShell->ISA(SdDrawViewShell) && !bSlideShow)
//STRIP001 			{
//STRIP001                 // The page-up key works either with no or with the CTRL
//STRIP001                 // modifier.  The reaction in either case is the same.
//STRIP001                 if ( ! rKEvt.GetKeyCode().GetAllModifier()
//STRIP001                     || rKEvt.GetKeyCode().IsMod1())
//STRIP001                 {
//STRIP001                     // The type of reaction depends on whether the layer
//STRIP001                     // mode is active.
//STRIP001                     if (static_cast<SdDrawViewShell*>(pViewShell)->GetLayerMode())
//STRIP001                     {
//STRIP001                         // With the layer mode active pressing page-up
//STRIP001                         // moves to the previous layer.
//STRIP001                         SwitchLayer (-1);
//STRIP001                     }
//STRIP001                     else
//STRIP001                     {
//STRIP001                         // When not in layer mode the page-up key moves to
//STRIP001                         // the previous slide.
//STRIP001 
//STRIP001                         pView->EndTextEdit();
//STRIP001 		
//STRIP001                         // Previous page.
//STRIP001                         bReturn = TRUE;
//STRIP001                         SdPage* pPage = ((SdDrawViewShell*) pViewShell)->GetActualPage();
//STRIP001                         USHORT nSdPage = (pPage->GetPageNum() - 1) / 2;
//STRIP001                         
//STRIP001                         if (nSdPage > 0)
//STRIP001                         {
//STRIP001                             // Switch the page and send events regarding
//STRIP001                             // deactivation the old page and activating the new one.
//STRIP001                             SdTabControl* pPageTabControl =
//STRIP001                                 static_cast<SdDrawViewShell*>(pViewShell)->GetPageTabControl();
//STRIP001                             if (pPageTabControl->IsReallyShown())
//STRIP001                                 pPageTabControl->SendDeactivatePageEvent ();
//STRIP001                             ((SdDrawViewShell*) pViewShell)->SwitchPage(nSdPage - 1);
//STRIP001                             if (pPageTabControl->IsReallyShown())
//STRIP001                                 pPageTabControl->SendActivatePageEvent ();
//STRIP001                         }
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case KEY_PAGEDOWN:
//STRIP001 		{
//STRIP001             if(pViewShell->ISA(SdDrawViewShell) && !bSlideShow)
//STRIP001             {
//STRIP001                 // The page-down key works either with no or with the CTRL
//STRIP001                 // modifier.  The reaction in either case is the same.
//STRIP001                 if ( ! rKEvt.GetKeyCode().GetAllModifier()
//STRIP001                     || rKEvt.GetKeyCode().IsMod1())
//STRIP001                 { 
//STRIP001                     // The type of reaction depends on whether the layer
//STRIP001                     // mode is active.
//STRIP001                     if (static_cast<SdDrawViewShell*>(pViewShell)->GetLayerMode())
//STRIP001                     {
//STRIP001                         // With the layer mode active pressing page-down
//STRIP001                         // moves to the next layer.
//STRIP001                         SwitchLayer (+1);
//STRIP001                     }
//STRIP001                     else
//STRIP001                     {
//STRIP001                         // When not in layer mode the page-down key moves to
//STRIP001                         // the next slide.
//STRIP001                         
//STRIP001                         pView->EndTextEdit();
//STRIP001 
//STRIP001                         // Next page.
//STRIP001                         bReturn = TRUE;
//STRIP001                         SdPage* pPage = ((SdDrawViewShell*) pViewShell)->GetActualPage();
//STRIP001                         USHORT nSdPage = (pPage->GetPageNum() - 1) / 2;
//STRIP001                         
//STRIP001                         if (nSdPage < pDoc->GetSdPageCount(pPage->GetPageKind()) - 1)
//STRIP001                         {
//STRIP001                             // Switch the page and send events regarding
//STRIP001                             // deactivation the old page and activating the new one.
//STRIP001                             SdTabControl* pPageTabControl =
//STRIP001                                 static_cast<SdDrawViewShell*>(pViewShell)->GetPageTabControl();
//STRIP001                             if (pPageTabControl->IsReallyShown())
//STRIP001                                 pPageTabControl->SendDeactivatePageEvent ();
//STRIP001                             ((SdDrawViewShell*) pViewShell)->SwitchPage(nSdPage + 1);
//STRIP001                             if (pPageTabControl->IsReallyShown())
//STRIP001                                 pPageTabControl->SendActivatePageEvent ();
//STRIP001                         }
//STRIP001                     }
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001         break;
//STRIP001 
//STRIP001 		// #97016# II change select state when focus is on poly point
//STRIP001 		case KEY_SPACE:
//STRIP001 		{
//STRIP001 			const SdrHdlList& rHdlList = pView->GetHdlList();
//STRIP001 			SdrHdl* pHdl = rHdlList.GetFocusHdl();
//STRIP001 
//STRIP001 			if(pHdl)
//STRIP001 			{
//STRIP001 				if(pHdl->GetKind() == HDL_POLY)
//STRIP001 				{
//STRIP001 					// rescue ID of point with focus
//STRIP001 					sal_uInt16 nPol(pHdl->GetPolyNum());
//STRIP001 					sal_uInt16 nPnt(pHdl->GetPointNum());
//STRIP001 					
//STRIP001 					if(pView->IsPointMarked(*pHdl))
//STRIP001 					{
//STRIP001 						if(rKEvt.GetKeyCode().IsShift())
//STRIP001 						{
//STRIP001 							pView->UnmarkPoint(*pHdl);
//STRIP001 						}
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						if(!rKEvt.GetKeyCode().IsShift())
//STRIP001 						{
//STRIP001 							pView->UnmarkAllPoints();
//STRIP001 						}
//STRIP001 
//STRIP001 						pView->MarkPoint(*pHdl);
//STRIP001 					}
//STRIP001 		
//STRIP001 					if(0L == rHdlList.GetFocusHdl())
//STRIP001 					{
//STRIP001 						// restore point with focus
//STRIP001 						SdrHdl* pNewOne = 0L;
//STRIP001 
//STRIP001 						for(sal_uInt32 a(0); !pNewOne && a < rHdlList.GetHdlCount(); a++)
//STRIP001 						{
//STRIP001 							SdrHdl* pAct = rHdlList.GetHdl(a);
//STRIP001 							
//STRIP001 							if(pAct 
//STRIP001 								&& pAct->GetKind() == HDL_POLY 
//STRIP001 								&& pAct->GetPolyNum() == nPol
//STRIP001 								&& pAct->GetPointNum() == nPnt)
//STRIP001 							{
//STRIP001 								pNewOne = pAct;
//STRIP001 							}
//STRIP001 						}
//STRIP001 
//STRIP001 						if(pNewOne)
//STRIP001 						{
//STRIP001 							((SdrHdlList&)rHdlList).SetFocusHdl(pNewOne);
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					bReturn = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case KEY_UP:
//STRIP001 		case KEY_DOWN:
//STRIP001 		case KEY_LEFT:
//STRIP001 		case KEY_RIGHT:
//STRIP001 		{
//STRIP001 			if (!pView->IsTextEdit() && !bSlideShow)
//STRIP001 			{
//STRIP001 				long nX = 0;
//STRIP001 				long nY = 0;
//STRIP001 
//STRIP001 				if (nCode == KEY_UP)
//STRIP001 				{
//STRIP001 					// Scroll nach oben
//STRIP001 					nX = 0;
//STRIP001 					nY =-1;
//STRIP001 				}
//STRIP001 				else if (nCode == KEY_DOWN)
//STRIP001 				{
//STRIP001 					// Scroll nach unten
//STRIP001 					nX = 0;
//STRIP001 					nY = 1;
//STRIP001 				}
//STRIP001 				else if (nCode == KEY_LEFT)
//STRIP001 				{
//STRIP001 					// Scroll nach links
//STRIP001 					nX =-1;
//STRIP001 					nY = 0;
//STRIP001 				}
//STRIP001 				else if (nCode == KEY_RIGHT)
//STRIP001 				{
//STRIP001 					// Scroll nach rechts
//STRIP001 					nX = 1;
//STRIP001 					nY = 0;
//STRIP001 				}
//STRIP001 
//STRIP001 				if (pView->HasMarkedObj() && !rKEvt.GetKeyCode().IsMod1() &&
//STRIP001 					!pDocSh->IsReadOnly())
//STRIP001 				{
//STRIP001 					// #97016# II
//STRIP001 					const SdrHdlList& rHdlList = pView->GetHdlList();
//STRIP001 					SdrHdl* pHdl = rHdlList.GetFocusHdl();
//STRIP001 
//STRIP001 					// #109007#
//STRIP001 					sal_Bool bIsMoveOfConnectedHandle(sal_False);
//STRIP001 					sal_Bool bOldSuppress;
//STRIP001 					SdrEdgeObj* pEdgeObj = 0L;
//STRIP001 
//STRIP001 					if(pHdl && pHdl->GetObj() && pHdl->GetObj()->ISA(SdrEdgeObj) && 0 == pHdl->GetPolyNum())
//STRIP001 					{
//STRIP001 						pEdgeObj = (SdrEdgeObj*)pHdl->GetObj();
//STRIP001 
//STRIP001 						if(0 == pHdl->GetPointNum())
//STRIP001 						{
//STRIP001 							if(pEdgeObj->GetConnection(sal_True).GetObject())
//STRIP001 							{
//STRIP001 								bIsMoveOfConnectedHandle = sal_True;
//STRIP001 							}
//STRIP001 						}
//STRIP001 						if(1 == pHdl->GetPointNum())
//STRIP001 						{
//STRIP001 							if(pEdgeObj->GetConnection(sal_False).GetObject())
//STRIP001 							{
//STRIP001 								bIsMoveOfConnectedHandle = sal_True;
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					// #109007#
//STRIP001 					if(pEdgeObj)
//STRIP001 					{
//STRIP001 						// Suppress default connects to inside object and object center
//STRIP001 						bOldSuppress = pEdgeObj->GetSuppressDefaultConnect();
//STRIP001 						pEdgeObj->SetSuppressDefaultConnect(sal_True);
//STRIP001 					}
//STRIP001 
//STRIP001 					// #109007#
//STRIP001 					if(bIsMoveOfConnectedHandle)
//STRIP001 					{
//STRIP001 						sal_uInt16 nMarkHdSiz(pView->GetMarkHdlSizePixel());
//STRIP001 						Size aHalfConSiz(nMarkHdSiz + 1, nMarkHdSiz + 1);
//STRIP001 						aHalfConSiz = pWindow->PixelToLogic(aHalfConSiz);
//STRIP001 
//STRIP001 						if(100 < aHalfConSiz.Width())
//STRIP001 							nX *= aHalfConSiz.Width();
//STRIP001 						else
//STRIP001 							nX *= 100;
//STRIP001 
//STRIP001 						if(100 < aHalfConSiz.Height())
//STRIP001 							nY *= aHalfConSiz.Height();
//STRIP001 						else
//STRIP001 							nY *= 100;
//STRIP001 					}
//STRIP001 					else if(rKEvt.GetKeyCode().IsMod2())
//STRIP001 					{
//STRIP001 						// #97016# move in 1 pixel distance
//STRIP001 						Size aLogicSizeOnePixel = (pWindow) ? pWindow->PixelToLogic(Size(1,1)) : Size(100, 100);
//STRIP001 						nX *= aLogicSizeOnePixel.Width();
//STRIP001 						nY *= aLogicSizeOnePixel.Height();
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						// old, fixed move distance
//STRIP001 						nX *= 100;
//STRIP001 						nY *= 100;
//STRIP001 					}
//STRIP001 
//STRIP001 					if(0L == pHdl)
//STRIP001 					{
//STRIP001 						// #67368# only take action when move is allowed
//STRIP001 						if(pView->IsMoveAllowed())
//STRIP001 						{
//STRIP001 							// #90129# restrict movement to WorkArea
//STRIP001 							const Rectangle& rWorkArea = pView->GetWorkArea();
//STRIP001 
//STRIP001 							if(!rWorkArea.IsEmpty())
//STRIP001 							{
//STRIP001 								Rectangle aMarkRect(pView->GetMarkedObjRect());
//STRIP001 								aMarkRect.Move(nX, nY);
//STRIP001 
//STRIP001 								if(!aMarkRect.IsInside(rWorkArea))
//STRIP001 								{
//STRIP001 									if(aMarkRect.Left() < rWorkArea.Left())
//STRIP001 									{
//STRIP001 										nX += rWorkArea.Left() - aMarkRect.Left();
//STRIP001 									}
//STRIP001 
//STRIP001 									if(aMarkRect.Right() > rWorkArea.Right())
//STRIP001 									{
//STRIP001 										nX -= aMarkRect.Right() - rWorkArea.Right();
//STRIP001 									}
//STRIP001 
//STRIP001 									if(aMarkRect.Top() < rWorkArea.Top())
//STRIP001 									{
//STRIP001 										nY += rWorkArea.Top() - aMarkRect.Top();
//STRIP001 									}
//STRIP001 
//STRIP001 									if(aMarkRect.Bottom() > rWorkArea.Bottom())
//STRIP001 									{
//STRIP001 										nY -= aMarkRect.Bottom() - rWorkArea.Bottom();
//STRIP001 									}
//STRIP001 								}
//STRIP001 							}
//STRIP001 
//STRIP001 							// no handle selected
//STRIP001 							if(0 != nX || 0 != nY)
//STRIP001 							{
//STRIP001 								pView->MoveAllMarked(Size(nX, nY));
//STRIP001 
//STRIP001 								// #97016# II
//STRIP001 								pView->MakeVisible(pView->GetAllMarkedRect(), *pWindow);
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						// move handle with index nHandleIndex
//STRIP001 						if(pHdl && (nX || nY))
//STRIP001 						{
//STRIP001 							// now move the Handle (nX, nY)
//STRIP001 							Point aStartPoint(pHdl->GetPos());
//STRIP001 							Point aEndPoint(pHdl->GetPos() + Point(nX, nY));
//STRIP001 							const SdrDragStat& rDragStat = pView->GetDragStat();
//STRIP001 
//STRIP001 							// start dragging
//STRIP001 							pView->BegDragObj(aStartPoint, 0, pHdl, 0);
//STRIP001 
//STRIP001 					        if(pView->IsDragObj())
//STRIP001 							{
//STRIP001 								FASTBOOL bWasNoSnap = rDragStat.IsNoSnap();
//STRIP001 								BOOL bWasSnapEnabled = pView->IsSnapEnabled();
//STRIP001 
//STRIP001 								// switch snapping off
//STRIP001 								if(!bWasNoSnap)
//STRIP001 									((SdrDragStat&)rDragStat).SetNoSnap(TRUE);
//STRIP001 								if(bWasSnapEnabled)
//STRIP001 									pView->SetSnapEnabled(FALSE);
//STRIP001 
//STRIP001 								pView->MovAction(aEndPoint);
//STRIP001 								pView->EndDragObj();
//STRIP001 							
//STRIP001 								// restore snap
//STRIP001 								if(!bWasNoSnap)
//STRIP001 									((SdrDragStat&)rDragStat).SetNoSnap(bWasNoSnap);
//STRIP001 								if(bWasSnapEnabled)
//STRIP001 									pView->SetSnapEnabled(bWasSnapEnabled);
//STRIP001 							}
//STRIP001 
//STRIP001 							// make moved handle visible
//STRIP001 							Rectangle aVisRect(aEndPoint - Point(100, 100), Size(200, 200));
//STRIP001 							pView->MakeVisible(aVisRect, *pWindow);
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					// #109007#
//STRIP001 					if(pEdgeObj)
//STRIP001 					{
//STRIP001 						// Restore original suppress value
//STRIP001 						pEdgeObj->SetSuppressDefaultConnect(bOldSuppress);
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					// Seite scrollen
//STRIP001 					ScrollStart();
//STRIP001 					pViewShell->ScrollLines(nX, nY);
//STRIP001 					ScrollEnd();
//STRIP001 				}
//STRIP001 
//STRIP001 				bReturn = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bReturn)
//STRIP001 	{
//STRIP001 		pWindow->ReleaseMouse();
//STRIP001 	}
//STRIP001 
//STRIP001 	// #98198# when a text-editable object is selected and the
//STRIP001 	// input character is printable, activate text edit on that object
//STRIP001 	// and feed character to object
//STRIP001 	if(!bReturn && !pDocSh->IsReadOnly())
//STRIP001 	{
//STRIP001 		if(!pView->IsTextEdit() && pViewShell)
//STRIP001 		{
//STRIP001 			const SdrMarkList& rMarkList = pView->GetMarkList();
//STRIP001 
//STRIP001 			if(1 == rMarkList.GetMarkCount())
//STRIP001 			{
//STRIP001 				SdrObject* pObj = rMarkList.GetMark(0)->GetObj();
//STRIP001 
//STRIP001 				if(pObj->ISA(SdrTextObj) && pObj->HasTextEdit() && !pObj->ISA(SdrOle2Obj))
//STRIP001 				{
//STRIP001 					// #98533# use common IsSimpleCharInput from
//STRIP001 					// the EditEngine.
//STRIP001 					sal_Bool bPrintable(EditEngine::IsSimpleCharInput(rKEvt));
//STRIP001 					
//STRIP001 					if(bPrintable)
//STRIP001 					{
//STRIP001 						// try to activate textedit mode for the selected object
//STRIP001 						SfxStringItem aInputString(SID_ATTR_CHAR, String(rKEvt.GetCharCode()));
//STRIP001 						
//STRIP001 						pViewShell->GetViewFrame()->GetDispatcher()->Execute(
//STRIP001 							SID_ATTR_CHAR, 
//STRIP001 							SFX_CALLMODE_ASYNCHRON,
//STRIP001 							&aInputString,
//STRIP001 							0L);
//STRIP001 
//STRIP001 						// consumed
//STRIP001 						bReturn = TRUE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// #99039# test if there is a title object there. If yes, try to
//STRIP001 				// set it to edit mode and start typing...
//STRIP001 				if(pViewShell->ISA(SdDrawViewShell) && EditEngine::IsSimpleCharInput(rKEvt))
//STRIP001 				{
//STRIP001 					SdDrawViewShell* pDrawViewShell = (SdDrawViewShell*)pViewShell;
//STRIP001 					SdPage* pActualPage = pDrawViewShell->GetActualPage();
//STRIP001 					SdrTextObj* pCandidate = 0L;
//STRIP001 
//STRIP001 					if(pActualPage)
//STRIP001 					{
//STRIP001 						SdrObjListIter aIter(*pActualPage, IM_DEEPNOGROUPS);
//STRIP001 
//STRIP001 						while(aIter.IsMore() && !pCandidate)
//STRIP001 						{
//STRIP001 							SdrObject* pObj = aIter.Next();
//STRIP001 
//STRIP001 							if(pObj && pObj->ISA(SdrTextObj))
//STRIP001 							{
//STRIP001 								sal_uInt32 nInv(pObj->GetObjInventor());
//STRIP001 								sal_uInt16 nKnd(pObj->GetObjIdentifier());
//STRIP001 
//STRIP001 								if(SdrInventor == nInv && OBJ_TITLETEXT == nKnd)
//STRIP001 								{
//STRIP001 									pCandidate = (SdrTextObj*)pObj;
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					// when candidate found and candidate is untouched, start editing text...
//STRIP001 					if(pCandidate && pCandidate->IsEmptyPresObj())
//STRIP001 					{
//STRIP001 						pView->UnMarkAll();
//STRIP001 						pView->MarkObj(pCandidate, pView->GetPageViewPvNum(0));
//STRIP001 						SfxStringItem aInputString(SID_ATTR_CHAR, String(rKEvt.GetCharCode()));
//STRIP001 
//STRIP001 						pViewShell->GetViewFrame()->GetDispatcher()->Execute(
//STRIP001 							SID_ATTR_CHAR, 
//STRIP001 							SFX_CALLMODE_ASYNCHRON,
//STRIP001 							&aInputString,
//STRIP001 							0L);
//STRIP001 
//STRIP001 						// consumed
//STRIP001 						bReturn = TRUE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return(bReturn);
//STRIP001 }

// #97016# II
/*N*/ void FuPoor::SelectionHasChanged()
/*N*/ {
/*N*/ 	const SdrHdlList& rHdlList = pView->GetHdlList();
/*N*/ 	((SdrHdlList&)rHdlList).ResetFocusHdl();
/*N*/ }

/*************************************************************************
|*
|* Cut object to clipboard
|*
\************************************************************************/

//STRIP001 void FuPoor::DoCut()
//STRIP001 {
//STRIP001 	if (pView)
//STRIP001 	{
//STRIP001 		pView->DoCut(pWindow);
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Copy object to clipboard
|*
\************************************************************************/

//STRIP001 void FuPoor::DoCopy()
//STRIP001 {
//STRIP001 	if (pView)
//STRIP001 	{
//STRIP001 		pView->DoCopy(pWindow);
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Paste object from clipboard
|*
\************************************************************************/

//STRIP001 void FuPoor::DoPaste()
//STRIP001 {
//STRIP001 	if (pView)
//STRIP001 	{
//STRIP001 		pView->DoPaste(pWindow);
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Timer-Handler fuer Drag&Drop
|*
\************************************************************************/

IMPL_LINK( FuPoor, DragHdl, Timer *, pTimer )
{
	DBG_BF_ASSERT(0, "STRIP"); //STRIP001  	USHORT nHitLog = USHORT ( pWindow->PixelToLogic(Size(HITPIX,0)).Width() );
//STRIP001 	SdrHdl* pHdl = pView->HitHandle(aMDPos, *pWindow);
//STRIP001 
//STRIP001 	if ( pHdl==NULL && pView->IsMarkedHit(aMDPos, nHitLog)
//STRIP001 		 && !pView->IsPresObjSelected(FALSE, TRUE) )
//STRIP001 	{
//STRIP001 		pWindow->ReleaseMouse();
//STRIP001 		bIsInDragMode = TRUE;
//STRIP001 		pView->StartDrag( aMDPos, pWindow );
//STRIP001 	}
	return 0;
}

/*************************************************************************
|*
|* Command-event
|*
\************************************************************************/

//STRIP001 BOOL FuPoor::Command(const CommandEvent& rCEvt)
//STRIP001 {
//STRIP001 	return( pView->Command(rCEvt,pWindow) );
//STRIP001 }

/*************************************************************************
|*
|* Timer-Handler fuer Fensterscrolling
|*
\************************************************************************/

IMPL_LINK_INLINE_START( FuPoor, DelayHdl, Timer *, pTimer )
{
{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	aDelayToScrollTimer.Stop ();
//STRIP001 	bScrollable = TRUE;
//STRIP001 
//STRIP001 	Point aPnt(pWindow->GetPointerPosPixel());
//STRIP001 	
//STRIP001 	// #95491# use remembered MouseButton state to create correct
//STRIP001 	// MouseEvents for this artifical MouseMove.
//STRIP001 	MouseMove(MouseEvent(aPnt, 1, 0, GetMouseButtonCode()));
//STRIP001 
	return 0;
}
IMPL_LINK_INLINE_END( FuPoor, DelayHdl, Timer *, pTimer )

/*************************************************************************
|*
|* Handler fuer Maustaste
|*
\************************************************************************/

//STRIP001 BOOL FuPoor::MouseButtonUp (const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	// #95491# remember button state for creation of own MouseEvents
//STRIP001 	SetMouseButtonCode(rMEvt.GetButtons());
//STRIP001 
//STRIP001 	aDelayToScrollTimer.Stop ();
//STRIP001 	return bScrollable	= 
//STRIP001 		bDelayActive = FALSE;
//STRIP001 }

//STRIP001 BOOL FuPoor::MouseButtonDown(const MouseEvent& rMEvt) 
//STRIP001 { 
//STRIP001 	// #95491# remember button state for creation of own MouseEvents
//STRIP001 	SetMouseButtonCode(rMEvt.GetButtons());
//STRIP001 
//STRIP001 	return FALSE; 
//STRIP001 }

/*************************************************************************
|*
|* Handler fuer Maustaste
|*
\************************************************************************/

//STRIP001 void FuPoor::StartDelayToScrollTimer ()
//STRIP001 {
//STRIP001 	bDelayActive = TRUE;
//STRIP001 	aDelayToScrollTimer.Start ();
//STRIP001 }

/*************************************************************************
|*
|* Handler fuer Maustaste
|*
\************************************************************************/

//STRIP001 long FuPoor::diffPoint (long pos1, long pos2)
//STRIP001 {
//STRIP001 	return (pos1 > pos2) ? pos1 - pos2
//STRIP001 						 : pos2 - pos1;
//STRIP001 }

/*************************************************************************
|*
|* Help-event
|*
\************************************************************************/

//STRIP001 BOOL FuPoor::RequestHelp(const HelpEvent& rHEvt)
//STRIP001 {
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 
//STRIP001 	SdrPageView* pPV = pView->GetPageViewPvNum(0);
//STRIP001 
//STRIP001 	if (pPV)
//STRIP001 	{
//STRIP001 		SdPage* pPage = (SdPage*) pPV->GetPage();
//STRIP001 
//STRIP001 		if (pPage)
//STRIP001 		{
//STRIP001 			bReturn = pPage->RequestHelp(pWindow, pView, rHEvt);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return(bReturn);
//STRIP001 }

/*************************************************************************
|*
|* Request verarbeiten
|*
\************************************************************************/

/*N*/ void FuPoor::ReceiveRequest(SfxRequest& rReq)
/*N*/ {
/*N*/ 	const SfxItemSet* pSet = rReq.GetArgs();
/*N*/ 
/*N*/ 	if (pSet)
/*N*/ 	{
/*?*/ 		if( pSet->GetItemState( nSlotId ) == SFX_ITEM_SET )
/*?*/ 		{
/*?*/ 			const SfxPoolItem& rItem = pSet->Get( nSlotId );
/*?*/ 
/*?*/ 			if( rItem.ISA( SfxAllEnumItem ) )
/*?*/ 			{
/*?*/ 				nSlotValue = ( ( const SfxAllEnumItem& ) rItem ).GetValue();
/*?*/ 			}
/*?*/ 		}
/*N*/ 	}
/*N*/ }

/*************************************************************************
|*
|* #97016#
|*
\************************************************************************/

//STRIP001 SdrObject* FuPoor::CreateDefaultObject(const sal_uInt16 nID, const Rectangle& rRectangle)
//STRIP001 {
//STRIP001 	// empty base implementation
//STRIP001 	return 0L;
//STRIP001 }

//STRIP001 void FuPoor::ImpForceQuadratic(Rectangle& rRect)
//STRIP001 {
//STRIP001 	if(rRect.GetWidth() > rRect.GetHeight())
//STRIP001 	{
//STRIP001 		rRect = Rectangle(
//STRIP001 			Point(rRect.Left() + ((rRect.GetWidth() - rRect.GetHeight()) / 2), rRect.Top()), 
//STRIP001 			Size(rRect.GetHeight(), rRect.GetHeight()));
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		rRect = Rectangle(
//STRIP001 			Point(rRect.Left(), rRect.Top() + ((rRect.GetHeight() - rRect.GetWidth()) / 2)), 
//STRIP001 			Size(rRect.GetWidth(), rRect.GetWidth()));
//STRIP001 	}
//STRIP001 }




//STRIP001 void FuPoor::SwitchLayer (sal_Int32 nOffset)
//STRIP001 {
//STRIP001     if(pViewShell && pViewShell->ISA(SdDrawViewShell))
//STRIP001     {
//STRIP001         SdDrawViewShell* pDrawViewShell = (SdDrawViewShell*)pViewShell;
//STRIP001 
//STRIP001         // Calculate the new index.
//STRIP001         sal_Int32 nIndex = pDrawViewShell->GetActiveTabLayerIndex() + nOffset;
//STRIP001 
//STRIP001         // Make sure the new index lies inside the range of valid indices.
//STRIP001         if (nIndex < 0)
//STRIP001             nIndex = 0;
//STRIP001         else if (nIndex >= pDrawViewShell->GetTabLayerCount ())
//STRIP001             nIndex = pDrawViewShell->GetTabLayerCount() - 1;
//STRIP001 
//STRIP001         // Set the new active layer.
//STRIP001         if (nIndex != pDrawViewShell->GetActiveTabLayerIndex ())
//STRIP001         {
//STRIP001             SdLayerTab* pLayerTabControl =
//STRIP001                 static_cast<SdDrawViewShell*>(pViewShell)->GetLayerTabControl();
//STRIP001             pLayerTabControl->SendDeactivatePageEvent ();
//STRIP001 
//STRIP001             pDrawViewShell->SetActiveTabLayerIndex (nIndex);
//STRIP001 
//STRIP001             pLayerTabControl->SendActivatePageEvent ();
//STRIP001         }
//STRIP001     }
//STRIP001 }

/** is called when the currenct function should be aborted. <p>
	This is used when a function gets a KEY_ESCAPE but can also
	be called directly.

	@returns true if a active function was aborted
*/
//STRIP001 bool FuPoor::cancel()
//STRIP001 {
//STRIP001 	if ( !this->ISA(FuSelection) )
//STRIP001 	{
//STRIP001 		pViewShell->GetViewFrame()->GetDispatcher()->Execute(SID_OBJECT_SELECT, SFX_CALLMODE_ASYNCHRON);
//STRIP001 		return true;
//STRIP001 	}
//STRIP001 
//STRIP001 	return false;
//STRIP001 }

}
