/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_fucon3d.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:09:16 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _SV_WAITOBJ_HXX
// auto strip #include <vcl/waitobj.hxx>
// auto strip #endif

#include <bf_svx/svxids.hrc>
// auto strip #ifndef _AEITEM_HXX //autogen
// auto strip #include <svtools/aeitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXAPP_HXX //autogen
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
// auto strip #ifndef _SFXVIEWFRM_HXX //autogen
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #endif
// auto strip #ifndef _TL_POLY_HXX
// auto strip #include <tools/poly.hxx>
// auto strip #endif

#include <math.h>
// auto strip #include <bf_svx/globl3d.hxx>
// auto strip #include <bf_svx/scene3d.hxx>
// auto strip #include <bf_svx/sphere3d.hxx>
// auto strip #include <bf_svx/cube3d.hxx>
// auto strip #include <bf_svx/lathe3d.hxx>
// auto strip #include <bf_svx/camera3d.hxx>
// auto strip #include <bf_svx/xpoly.hxx>
// auto strip #include <bf_svx/xoutx.hxx>

#include "app.hrc"
#include "res_bmp.hrc"

// auto strip #include "sdview.hxx"
// auto strip #include "sdwindow.hxx"
// auto strip #include "viewshel.hxx"
// auto strip #include "fucon3d.hxx"
// auto strip #include "drawdoc.hxx"

// auto strip #ifndef _SVX3DITEMS_HXX
// auto strip #include <bf_svx/svx3ditems.hxx>
// auto strip #endif

// #97016#
// auto strip #ifndef _E3D_POLYSC3D_HXX
// auto strip #include <bf_svx/polysc3d.hxx>
// auto strip #endif
namespace binfilter {

class SfxRequest;
class SdDrawDocument;

//STRIP001 TYPEINIT1( FuConst3dObj, FuConstruct );
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Konstruktor
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 FuConst3dObj::FuConst3dObj(SdViewShell* 	pViewSh,
//STRIP001 						   SdWindow*		pWin,
//STRIP001 						   SdView*			pView,
//STRIP001 						   SdDrawDocument*	pDoc,
//STRIP001 						   SfxRequest&		rReq) :
//STRIP001 	  FuConstruct(pViewSh, pWin, pView, pDoc, rReq)
//STRIP001 {
//STRIP001 	pViewShell->SwitchObjectBar(RID_DRAW_OBJ_TOOLBOX);
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Destruktor
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 FuConst3dObj::~FuConst3dObj()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* MouseButtonDown-event
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 // #97016#
//STRIP001 E3dCompoundObject* FuConst3dObj::ImpCreateBasic3DShape()
//STRIP001 {
//STRIP001 	E3dCompoundObject* p3DObj = NULL;
//STRIP001 
//STRIP001 	switch (nSlotId)
//STRIP001 	{
//STRIP001 		default:
//STRIP001 		case SID_3D_CUBE:
//STRIP001 		{
//STRIP001 			p3DObj = new E3dCubeObj(
//STRIP001 				pView->Get3DDefaultAttributes(),
//STRIP001 				Vector3D(-2500, -2500, -2500),
//STRIP001 				Vector3D(5000, 5000, 5000));
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SID_3D_SPHERE:
//STRIP001 		{
//STRIP001 			p3DObj = new E3dSphereObj(
//STRIP001 				pView->Get3DDefaultAttributes(),
//STRIP001 				Vector3D(0, 0, 0),
//STRIP001 				Vector3D(5000, 5000, 5000));
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SID_3D_SHELL:
//STRIP001 		{
//STRIP001 			XPolygon aXPoly(Point (0, 1250), 2500, 2500, 0, 900, FALSE);
//STRIP001 			aXPoly.Scale(5.0, 5.0);
//STRIP001 
//STRIP001 			p3DObj = new E3dLatheObj(
//STRIP001 				pView->Get3DDefaultAttributes(),
//STRIP001 				(XPolygon)XOutCreatePolygon (aXPoly, pWindow));
//STRIP001 
//STRIP001 			// Dies ist ein offenes Objekt, muss daher defaultmaessig
//STRIP001 			// doppelseitig behandelt werden
//STRIP001 			p3DObj->SetItem(Svx3DDoubleSidedItem(TRUE));
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SID_3D_HALF_SPHERE:
//STRIP001 		{
//STRIP001 			XPolygon aXPoly(Point (0, 1250), 2500, 2500, 0, 900, FALSE);
//STRIP001 			aXPoly.Scale(5.0, 5.0);
//STRIP001 
//STRIP001 			aXPoly.Insert(0, Point (2400*5, 1250*5), XPOLY_NORMAL);
//STRIP001 			aXPoly.Insert(0, Point (2000*5, 1250*5), XPOLY_NORMAL);
//STRIP001 			aXPoly.Insert(0, Point (1500*5, 1250*5), XPOLY_NORMAL);
//STRIP001 			aXPoly.Insert(0, Point (1000*5, 1250*5), XPOLY_NORMAL);
//STRIP001 			aXPoly.Insert(0, Point (500*5, 1250*5), XPOLY_NORMAL);
//STRIP001 			aXPoly.Insert(0, Point (250*5, 1250*5), XPOLY_NORMAL);
//STRIP001 			aXPoly.Insert(0, Point (50*5, 1250*5), XPOLY_NORMAL);
//STRIP001 			aXPoly.Insert(0, Point (0*5, 1250*5), XPOLY_NORMAL);
//STRIP001 			p3DObj = new E3dLatheObj(
//STRIP001 				pView->Get3DDefaultAttributes(),
//STRIP001 				(XPolygon)XOutCreatePolygon (aXPoly, pWindow));
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SID_3D_TORUS:
//STRIP001 		{
//STRIP001 			p3DObj = new E3dLatheObj(
//STRIP001 				pView->Get3DDefaultAttributes(),
//STRIP001 				(XPolygon)XOutCreatePolygon(XPolygon (Point (1000, 0), 500, 500, 0, 3600), pWindow));
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SID_3D_CYLINDER:
//STRIP001 		{
//STRIP001 			XPolygon aXPoly(16);
//STRIP001 			aXPoly[0] = Point(0, 1000*5);
//STRIP001 			aXPoly[1] = Point(50*5, 1000*5);
//STRIP001 			aXPoly[2] = Point(100*5, 1000*5);
//STRIP001 			aXPoly[3] = Point(200*5, 1000*5);
//STRIP001 			aXPoly[4] = Point(300*5, 1000*5);
//STRIP001 			aXPoly[5] = Point(400*5, 1000*5);
//STRIP001 			aXPoly[6] = Point(450*5, 1000*5);
//STRIP001 			aXPoly[7] = Point(500*5, 1000*5);
//STRIP001 			aXPoly[8] = Point(500*5, -1000*5);
//STRIP001 			aXPoly[9] = Point(450*5, -1000*5);
//STRIP001 			aXPoly[10] = Point(400*5, -1000*5);
//STRIP001 			aXPoly[11] = Point(300*5, -1000*5);
//STRIP001 			aXPoly[12] = Point(200*5, -1000*5);
//STRIP001 			aXPoly[13] = Point(100*5, -1000*5);
//STRIP001 			aXPoly[14] = Point(50*5, -1000*5);
//STRIP001 			aXPoly[15] = Point(0*5, -1000*5);
//STRIP001 
//STRIP001 			p3DObj = new E3dLatheObj(
//STRIP001 				pView->Get3DDefaultAttributes(),
//STRIP001 				aXPoly);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SID_3D_CONE:
//STRIP001 		{
//STRIP001 			XPolygon aXPoly(14);
//STRIP001 			aXPoly[0] = Point(0, -1000*5);
//STRIP001 			aXPoly[1] = Point(25*5, -900*5);
//STRIP001 			aXPoly[2] = Point(50*5, -800*5);
//STRIP001 			aXPoly[3] = Point(100*5, -600*5);
//STRIP001 			aXPoly[4] = Point(200*5, -200*5);
//STRIP001 			aXPoly[5] = Point(300*5, 200*5);
//STRIP001 			aXPoly[6] = Point(400*5, 600*5);
//STRIP001 			aXPoly[7] = Point(500*5, 1000*5);
//STRIP001 			aXPoly[8] = Point(400*5, 1000*5);
//STRIP001 			aXPoly[9] = Point(300*5, 1000*5);
//STRIP001 			aXPoly[10] = Point(200*5, 1000*5);
//STRIP001 			aXPoly[11] = Point(100*5, 1000*5);
//STRIP001 			aXPoly[12] = Point(50*5, 1000*5);
//STRIP001 			aXPoly[13] = Point(0*5, 1000*5);
//STRIP001 
//STRIP001 			p3DObj = new E3dLatheObj(
//STRIP001 				pView->Get3DDefaultAttributes(),
//STRIP001 				aXPoly);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SID_3D_PYRAMID:
//STRIP001 		{
//STRIP001 			XPolygon aXPoly(14);
//STRIP001 			aXPoly[0] = Point(0, -1000*5);
//STRIP001 			aXPoly[1] = Point(25*5, -900*5);
//STRIP001 			aXPoly[2] = Point(50*5, -800*5);
//STRIP001 			aXPoly[3] = Point(100*5, -600*5);
//STRIP001 			aXPoly[4] = Point(200*5, -200*5);
//STRIP001 			aXPoly[5] = Point(300*5, 200*5);
//STRIP001 			aXPoly[6] = Point(400*5, 600*5);
//STRIP001 			aXPoly[7] = Point(500*5, 1000*5);
//STRIP001 			aXPoly[8] = Point(400*5, 1000*5);
//STRIP001 			aXPoly[9] = Point(300*5, 1000*5);
//STRIP001 			aXPoly[10] = Point(200*5, 1000*5);
//STRIP001 			aXPoly[11] = Point(100*5, 1000*5);
//STRIP001 			aXPoly[12] = Point(50*5, 1000*5);
//STRIP001 			aXPoly[13] = Point(0, 1000*5);
//STRIP001 
//STRIP001 			p3DObj = new E3dLatheObj(
//STRIP001 				pView->Get3DDefaultAttributes(),
//STRIP001 				aXPoly);
//STRIP001 			p3DObj->SetItem(Svx3DHorizontalSegmentsItem(4));
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return p3DObj;
//STRIP001 }
//STRIP001 
//STRIP001 // #97016#
//STRIP001 void FuConst3dObj::ImpPrepareBasic3DShape(E3dCompoundObject* p3DObj, E3dScene *pScene)
//STRIP001 {
//STRIP001 	Camera3D &aCamera  = (Camera3D&) pScene->GetCamera ();
//STRIP001 
//STRIP001 	// get transformed BoundVolume of the new object
//STRIP001 	Volume3D aBoundVol;
//STRIP001 	const Volume3D& rObjVol = p3DObj->GetBoundVolume();
//STRIP001 	const Matrix4D& rObjTrans  = p3DObj->GetTransform();
//STRIP001 	aBoundVol.Union(rObjVol.GetTransformVolume(rObjTrans));
//STRIP001 	
//STRIP001 	Vector3D aMinVec (aBoundVol.MinVec ());
//STRIP001 	Vector3D aMaxVec (aBoundVol.MaxVec ());
//STRIP001 	double fDeepth = fabs (aMaxVec.Z () - aMinVec.Z ());
//STRIP001 
//STRIP001 	aCamera.SetPRP(Vector3D(0, 0, 1000));
//STRIP001 	aCamera.SetPosition(Vector3D(0.0, 0.0, pView->GetDefaultCamPosZ() + fDeepth / 2));
//STRIP001 	aCamera.SetFocalLength(pView->GetDefaultCamFocal());
//STRIP001 	pScene->SetCamera(aCamera);
//STRIP001 
//STRIP001 	switch (nSlotId)
//STRIP001 	{
//STRIP001 		case SID_3D_CUBE:
//STRIP001 		{
//STRIP001 			pScene->RotateX(DEG2RAD(20));
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_3D_SPHERE:
//STRIP001 		{
//STRIP001 //				pScene->RotateX(DEG2RAD(60));
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_3D_SHELL:
//STRIP001 		case SID_3D_HALF_SPHERE:
//STRIP001 		{
//STRIP001 			pScene->RotateX(DEG2RAD(200));
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_3D_CYLINDER:
//STRIP001 		case SID_3D_CONE:
//STRIP001 		case SID_3D_PYRAMID:
//STRIP001 		{
//STRIP001 //				pScene->RotateX(DEG2RAD(25));
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_3D_TORUS:
//STRIP001 		{
//STRIP001 //				pScene->RotateX(DEG2RAD(15));
//STRIP001 			pScene->RotateX(DEG2RAD(90));
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		{
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (nSlotId == SID_3D_SPHERE)
//STRIP001 	{
//STRIP001 		// Keine Sortierung noetig
//STRIP001 		pScene->SetSortingMode(E3D_SORT_NO_SORTING);
//STRIP001 	}
//STRIP001 	else if (nSlotId == SID_3D_CYLINDER)
//STRIP001 	{
//STRIP001 		// Das muss auch ohne aufwendige Sortierung gehen!
//STRIP001 		// Ersteinaml jedoch: Sortierung ueber Lookupfield
//STRIP001 		pScene->SetSortingMode(E3D_SORT_LOOKUP_FIELD |
//STRIP001 							   E3D_SORT_IN_PARENTS   |
//STRIP001 							   E3D_SORT_TEST_LENGTH);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Einfache Sortierung
//STRIP001 		pScene->SetSortingMode(E3D_SORT_FAST_SORTING |
//STRIP001 							   E3D_SORT_IN_PARENTS   |
//STRIP001 							   E3D_SORT_TEST_LENGTH);
//STRIP001 	}
//STRIP001 
//STRIP001 	pScene->FitSnapRectToBoundVol();
//STRIP001 
//STRIP001 	SfxItemSet aAttr (pViewShell->GetPool());
//STRIP001 	pScene->SetItemSetAndBroadcast(aAttr);
//STRIP001 }
//STRIP001 
//STRIP001 BOOL FuConst3dObj::MouseButtonDown(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	BOOL bReturn = FuConstruct::MouseButtonDown(rMEvt);
//STRIP001 
//STRIP001 	if ( rMEvt.IsLeft() && !pView->IsAction() )
//STRIP001 	{
//STRIP001 		Point aPnt( pWindow->PixelToLogic( rMEvt.GetPosPixel() ) );
//STRIP001 
//STRIP001 		pWindow->CaptureMouse();
//STRIP001 		USHORT nDrgLog = USHORT ( pWindow->PixelToLogic(Size(DRGPIX,0)).Width() );
//STRIP001 
//STRIP001 		E3dCompoundObject* p3DObj = NULL;
//STRIP001 
//STRIP001 		WaitObject aWait( (Window*)pViewShell->GetActiveWindow() );
//STRIP001 
//STRIP001 		// #97016#
//STRIP001 		p3DObj = ImpCreateBasic3DShape();
//STRIP001 
//STRIP001 		pView->SetCurrent3DObj(p3DObj);
//STRIP001 		E3dScene *pScene   = (E3dScene*) pView->GetCurrentLibObj();
//STRIP001 
//STRIP001 		// #97016#
//STRIP001 		ImpPrepareBasic3DShape(p3DObj, pScene);
//STRIP001 
//STRIP001 		bReturn = pView->BegCreateObj(aPnt, (OutputDevice*) NULL, nDrgLog);
//STRIP001 
//STRIP001 		SdrObject* pObj = pView->GetCreateObj();
//STRIP001 
//STRIP001 		if (pObj)
//STRIP001 		{
//STRIP001 			SfxItemSet aAttr(pDoc->GetPool());
//STRIP001 			SetStyleSheet(aAttr, pObj);
//STRIP001 
//STRIP001 			// LineStyle rausnehmen
//STRIP001 			aAttr.Put(XLineStyleItem (XLINE_NONE));
//STRIP001 
//STRIP001 			pObj->SetItemSet(aAttr);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bReturn;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* MouseMove-event
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BOOL FuConst3dObj::MouseMove(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	return FuConstruct::MouseMove(rMEvt);
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* MouseButtonUp-event
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BOOL FuConst3dObj::MouseButtonUp(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 
//STRIP001 	if ( pView->IsCreateObj() && rMEvt.IsLeft() )
//STRIP001 	{
//STRIP001 		Point aPnt( pWindow->PixelToLogic( rMEvt.GetPosPixel() ) );
//STRIP001 		pView->EndCreateObj(SDRCREATE_FORCEEND);
//STRIP001 		bReturn = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	bReturn = FuConstruct::MouseButtonUp(rMEvt) || bReturn;
//STRIP001 
//STRIP001 	if (!bPermanent)
//STRIP001 		pViewShell->GetViewFrame()->GetDispatcher()->Execute(SID_OBJECT_SELECT, SFX_CALLMODE_ASYNCHRON);
//STRIP001 
//STRIP001 	return bReturn;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Tastaturereignisse bearbeiten
//STRIP001 |*
//STRIP001 |* Wird ein KeyEvent bearbeitet, so ist der Return-Wert TRUE, andernfalls
//STRIP001 |* FALSE.
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BOOL FuConst3dObj::KeyInput(const KeyEvent& rKEvt)
//STRIP001 {
//STRIP001 	return( FuConstruct::KeyInput(rKEvt) );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Function aktivieren
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void FuConst3dObj::Activate()
//STRIP001 {
//STRIP001 	pView->SetCurrentObj(OBJ_NONE);
//STRIP001 
//STRIP001 	FuConstruct::Activate();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Function deaktivieren
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void FuConst3dObj::Deactivate()
//STRIP001 {
//STRIP001 	FuConstruct::Deactivate();
//STRIP001 }
//STRIP001 
//STRIP001 // #97016#
//STRIP001 SdrObject* FuConst3dObj::CreateDefaultObject(const sal_uInt16 nID, const Rectangle& rRectangle)
//STRIP001 {
//STRIP001 	// case SID_3D_CUBE:
//STRIP001 	// case SID_3D_SHELL:
//STRIP001 	// case SID_3D_SPHERE:
//STRIP001 	// case SID_3D_TORUS:
//STRIP001 	// case SID_3D_HALF_SPHERE:
//STRIP001 	// case SID_3D_CYLINDER:
//STRIP001 	// case SID_3D_CONE:
//STRIP001 	// case SID_3D_PYRAMID:
//STRIP001 
//STRIP001 	E3dCompoundObject* p3DObj = ImpCreateBasic3DShape();
//STRIP001 
//STRIP001 	// E3dView::SetCurrent3DObj part		
//STRIP001 	// get transformed BoundVolume of the object
//STRIP001 	const Volume3D& rObjVol = p3DObj->GetBoundVolume();
//STRIP001 	const Matrix4D& rObjTrans = p3DObj->GetTransform();
//STRIP001 	Volume3D aVolume;
//STRIP001 	aVolume.Union(rObjVol.GetTransformVolume(rObjTrans));
//STRIP001 	double fW(aVolume.GetWidth());
//STRIP001 	double fH(aVolume.GetHeight());
//STRIP001 	Rectangle a3DRect(0, 0, (long)fW, (long)fH);
//STRIP001 	E3dScene* pScene = new E3dPolyScene(pView->Get3DDefaultAttributes());
//STRIP001 
//STRIP001 	// pView->InitScene(pScene, fW, fH, aVolume.MaxVec().Z() + ((fW + fH) / 4.0));
//STRIP001 	// copied code from E3dView::InitScene
//STRIP001 	double fCamZ(aVolume.MaxVec().Z() + ((fW + fH) / 4.0));
//STRIP001 	Camera3D aCam(pScene->GetCamera());
//STRIP001 	aCam.SetAutoAdjustProjection(FALSE);
//STRIP001 	aCam.SetViewWindow(- fW / 2, - fH / 2, fW, fH);
//STRIP001 	Vector3D aLookAt;
//STRIP001 	double fDefaultCamPosZ = pView->GetDefaultCamPosZ();
//STRIP001 	Vector3D aCamPos(0.0, 0.0, fCamZ < fDefaultCamPosZ ? fDefaultCamPosZ : fCamZ);
//STRIP001 	aCam.SetPosAndLookAt(aCamPos, aLookAt);
//STRIP001 	aCam.SetFocalLength(pView->GetDefaultCamFocal());
//STRIP001 	aCam.SetDefaults(Vector3D(0.0, 0.0, fDefaultCamPosZ), aLookAt, pView->GetDefaultCamFocal());
//STRIP001 	pScene->SetCamera(aCam);
//STRIP001 	
//STRIP001 	pScene->Insert3DObj(p3DObj);
//STRIP001 	pScene->NbcSetSnapRect(a3DRect);
//STRIP001 	// SetCurrentLibObj(pScene);
//STRIP001 	pScene->SetModel(pDoc);
//STRIP001 		
//STRIP001 	ImpPrepareBasic3DShape(p3DObj, pScene);
//STRIP001 		
//STRIP001 	SfxItemSet aAttr(pDoc->GetPool());
//STRIP001 	SetStyleSheet(aAttr, p3DObj);
//STRIP001 	aAttr.Put(XLineStyleItem (XLINE_NONE));
//STRIP001 	p3DObj->SetItemSet(aAttr);
//STRIP001 	
//STRIP001 	// make object interactive at once
//STRIP001 	pScene->SetRectsDirty();
//STRIP001 	pScene->InitTransformationSet();
//STRIP001 
//STRIP001 	// Take care of restrictions for the rectangle
//STRIP001 	Rectangle aRect(rRectangle);
//STRIP001 
//STRIP001 	switch(nID)
//STRIP001 	{
//STRIP001 		case SID_3D_CUBE:
//STRIP001 		case SID_3D_SPHERE:
//STRIP001 		case SID_3D_TORUS:
//STRIP001 		{
//STRIP001 			// force quadratic
//STRIP001 			ImpForceQuadratic(aRect);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SID_3D_SHELL:
//STRIP001 		case SID_3D_HALF_SPHERE:
//STRIP001 		{
//STRIP001 			// force horizontal layout
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SID_3D_CYLINDER:
//STRIP001 		case SID_3D_CONE:
//STRIP001 		case SID_3D_PYRAMID:
//STRIP001 		{
//STRIP001 			// force vertical layout
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// #97016#, #98245# use changed rectangle, not original one
//STRIP001 	pScene->SetLogicRect(aRect);
//STRIP001 
//STRIP001 	return pScene;
//STRIP001 }
}
