/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_sdmod1.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:42:59 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <svtools/lckbitem.hxx>
#ifndef _SFXFRAME_HXX //autogen
#include <bf_sfx2/frame.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <bf_sfx2/viewfrm.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_MODULEOPTIONS_HXX
#include <svtools/moduleoptions.hxx>
#endif

#include <bf_svx/dialogs.hrc>
#include <bf_offmgr/ofaids.hrc>

#define ITEMID_LANGUAGE 	SID_ATTR_LANGUAGE
#include <bf_svx/langitem.hxx>
#include <bf_svx/editdata.hxx>

#ifndef _OFF_APP_HXX //autogen
#include <bf_offmgr/app.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SVX_SVXENUM_HXX //autogen
#include <bf_svx/svxenum.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <bf_sfx2/request.hxx>
#endif
#ifndef _SFX_PRINTER_HXX //autogen
#include <bf_sfx2/printer.hxx>
#endif
#ifndef _SFXDOCFILE_HXX //autogen
#include <bf_sfx2/docfile.hxx>
#endif
#ifndef _SVX_PAPERINF_HXX //autogen
#include <bf_svx/paperinf.hxx>
#endif

#ifndef _EEITEM_HXX
#include <bf_svx/eeitem.hxx>
#endif

#ifndef INCLUDED_SVTOOLS_USEROPTIONS_HXX
#include <svtools/useroptions.hxx>
#endif

#include "app.hrc"
#include "glob.hrc"
#include "strings.hrc"
#include "res_bmp.hrc"

#define _SD_DLL                 // fuer SD_MOD()
#include "sdmod.hxx"
#include "sddll.hxx"
#include "pres.hxx"
#include "optsitem.hxx"
#include "viewshel.hxx"
#include "sdattr.hxx"
#include "sdpage.hxx"
#include "docshell.hxx"
#include "drawdoc.hxx"
#include "assclass.hxx"
#include "dlgass.hxx"
#include "sdresid.hxx"
#include "outlnvsh.hxx"
#include "frmview.hxx"
namespace binfilter {


/*************************************************************************
|*
|* Execute
|*
\************************************************************************/

//STRIP001 void SdModule::Execute(SfxRequest& rReq)
//STRIP001 {
//STRIP001 	const SfxItemSet* pSet = rReq.GetArgs();
//STRIP001 	ULONG nSlotId = rReq.GetSlot();
//STRIP001 
//STRIP001 	// #94442# keep track of created frames
//STRIP001 	SfxFrame* pFrame = NULL;
//STRIP001 
//STRIP001 	switch ( nSlotId )
//STRIP001 	{
//STRIP001 		case SID_NEWDOC:
//STRIP001 		{
//STRIP001 			OFF_APP()->ExecuteSlot(rReq, OFF_APP()->GetInterface());
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_AUTOSPELL_CHECK:
//STRIP001 		{
//STRIP001 			// automatische Rechtschreibpruefung
//STRIP001 			const SfxPoolItem* pItem;
//STRIP001 			if( pSet && SFX_ITEM_SET == pSet->GetItemState(
//STRIP001 						SID_AUTOSPELL_CHECK, FALSE, &pItem ) )
//STRIP001 			{
//STRIP001 				BOOL bOnlineSpelling = ( (const SfxBoolItem*) pItem )->GetValue();
//STRIP001 				// am Dokument sichern:
//STRIP001 				SdDrawDocShell* pDocSh = PTR_CAST(SdDrawDocShell, SfxObjectShell::Current());
//STRIP001 				if( pDocSh )
//STRIP001 				{
//STRIP001 					SdDrawDocument* pDoc = pDocSh->GetDoc();
//STRIP001 					pDoc->SetOnlineSpell( bOnlineSpelling );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_AUTOSPELL_MARKOFF:
//STRIP001 		{
//STRIP001 			const SfxPoolItem* pItem;
//STRIP001 			if( pSet && SFX_ITEM_SET == pSet->GetItemState(
//STRIP001 						SID_AUTOSPELL_MARKOFF, FALSE, &pItem ) )
//STRIP001 			{
//STRIP001 				BOOL bHideSpell = ( (const SfxBoolItem*) pItem )->GetValue();
//STRIP001 				// am Dokument sichern:
//STRIP001 				SdDrawDocShell* pDocSh = PTR_CAST(SdDrawDocShell, SfxObjectShell::Current());
//STRIP001 				if( pDocSh )
//STRIP001 				{
//STRIP001 					SdDrawDocument* pDoc = pDocSh->GetDoc();
//STRIP001 					pDoc->SetHideSpell( bHideSpell );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_ATTR_METRIC:
//STRIP001 		{
//STRIP001 			const SfxPoolItem* pItem;
//STRIP001 			if ( pSet && SFX_ITEM_SET == pSet->GetItemState( SID_ATTR_METRIC, TRUE, &pItem ) )
//STRIP001 			{
//STRIP001 				FieldUnit eUnit = (FieldUnit)((const SfxUInt16Item*)pItem)->GetValue();
//STRIP001 				switch( eUnit )
//STRIP001 				{
//STRIP001 					case FUNIT_MM:		// nur die Einheiten, die auch im Dialog stehen
//STRIP001 					case FUNIT_CM:
//STRIP001 					case FUNIT_INCH:
//STRIP001 					case FUNIT_PICA:
//STRIP001 					case FUNIT_POINT:
//STRIP001 						{
//STRIP001 							SdDrawDocShell* pDocSh = PTR_CAST( SdDrawDocShell, SfxObjectShell::Current() );
//STRIP001 							if(pDocSh)
//STRIP001 							{
//STRIP001 								DocumentType eDocType = pDocSh->GetDoc()->GetDocumentType();
//STRIP001 
//STRIP001 								PutItem( *pItem );
//STRIP001 								SdOptions* pOptions = GetSdOptions( eDocType );
//STRIP001 								if(pOptions)
//STRIP001 									pOptions->SetMetric( eUnit );
//STRIP001 								rReq.Done();
//STRIP001 							}
//STRIP001 						}
//STRIP001 						break;
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_ATTR_LANGUAGE:
//STRIP001 		case SID_ATTR_CHAR_CJK_LANGUAGE:
//STRIP001 		case SID_ATTR_CHAR_CTL_LANGUAGE:
//STRIP001 		{
//STRIP001 			const SfxPoolItem* pItem;
//STRIP001 			if( pSet &&
//STRIP001 			    SFX_ITEM_SET == pSet->GetItemState(SID_ATTR_LANGUAGE, FALSE, &pItem ) ||
//STRIP001 				SFX_ITEM_SET == pSet->GetItemState(SID_ATTR_CHAR_CJK_LANGUAGE, FALSE, &pItem ) ||
//STRIP001 				SFX_ITEM_SET == pSet->GetItemState(SID_ATTR_CHAR_CTL_LANGUAGE, FALSE, &pItem ) )
//STRIP001 			{
//STRIP001 				// am Dokument sichern:
//STRIP001 				SdDrawDocShell* pDocSh = PTR_CAST(SdDrawDocShell, SfxObjectShell::Current());
//STRIP001 				if ( pDocSh )
//STRIP001 				{
//STRIP001 					LanguageType eLanguage = ( (SvxLanguageItem*)pItem )->GetValue();
//STRIP001 					SdDrawDocument* pDoc = pDocSh->GetDoc();
//STRIP001 
//STRIP001 					if( nSlotId == SID_ATTR_CHAR_CJK_LANGUAGE )
//STRIP001 						pDoc->SetLanguage( eLanguage, EE_CHAR_LANGUAGE_CJK );
//STRIP001 					else if( nSlotId == SID_ATTR_CHAR_CTL_LANGUAGE )
//STRIP001 						pDoc->SetLanguage( eLanguage, EE_CHAR_LANGUAGE_CTL );
//STRIP001 					else
//STRIP001 						pDoc->SetLanguage( eLanguage, EE_CHAR_LANGUAGE );
//STRIP001 
//STRIP001 					if( pDoc->GetOnlineSpell() )
//STRIP001 					{
//STRIP001 						pDoc->StopOnlineSpelling();
//STRIP001 						pDoc->StartOnlineSpelling();
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_SD_AUTOPILOT:
//STRIP001 		{
//STRIP001 			if ( SvtModuleOptions().IsImpress() )
//STRIP001 			{
//STRIP001 				SdOptions* pOpt = GetSdOptions(DOCUMENT_TYPE_IMPRESS);
//STRIP001 				BOOL bStartWithTemplate = pOpt->IsStartWithTemplate();
//STRIP001 
//STRIP001 				const SfxPoolItem* pItem;
//STRIP001 				BOOL bNewDocDirect = pSet != NULL &&
//STRIP001 									 pSet->GetItemState( SID_NEWDOCDIRECT, FALSE, &pItem ) == SFX_ITEM_SET &&
//STRIP001 									 ((SfxBoolItem*)pItem)->GetValue();
//STRIP001 
//STRIP001 				if( bNewDocDirect && !bStartWithTemplate )
//STRIP001 				{
//STRIP001 					SfxObjectShellLock xDocShell;
//STRIP001 					SdDrawDocShell* pNewDocSh;
//STRIP001 					xDocShell = pNewDocSh = new SdDrawDocShell(SFX_CREATE_MODE_STANDARD, FALSE);
//STRIP001 					if(pNewDocSh)
//STRIP001 					{
//STRIP001 						pNewDocSh->DoInitNew(NULL);
//STRIP001 						SdDrawDocument* pDoc = pNewDocSh->GetDoc();
//STRIP001 						if(pDoc)
//STRIP001 						{
//STRIP001 							pDoc->CreateFirstPages();
//STRIP001 							pDoc->StopWorkStartupDelay();
//STRIP001 						}
//STRIP001 
//STRIP001 						SFX_REQUEST_ARG( rReq, pFrmItem, SfxFrameItem, SID_DOCFRAME, FALSE);
//STRIP001 						if ( pFrmItem )
//STRIP001 						{
//STRIP001 							pFrame = pFrmItem->GetFrame();
//STRIP001 							pFrame->InsertDocument( pNewDocSh );
//STRIP001 						}
//STRIP001 						else
//STRIP001 							SFX_APP()->CreateViewFrame( *pNewDocSh );
//STRIP001 					}
//STRIP001 					break;
//STRIP001 				}
//STRIP001 
//STRIP001 				String aFileToOpen;
//STRIP001 				AssistentDlg* pPilotDlg=new AssistentDlg( NULL, !bNewDocDirect );
//STRIP001 
//STRIP001 				// Open the Pilot
//STRIP001 				if(	pPilotDlg->Execute()==RET_CANCEL )
//STRIP001 				{
//STRIP001 					delete pPilotDlg;
//STRIP001 					break;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					const String aPasswrd( pPilotDlg->GetPassword() );
//STRIP001 					const sal_Bool bSummary = pPilotDlg->IsSummary();
//STRIP001 					const sal_Int32 eMedium = pPilotDlg->GetOutputMedium();
//STRIP001 					const String aDocPath( pPilotDlg->GetDocPath());
//STRIP001 					const sal_Bool bIsDocEmpty = pPilotDlg->IsDocEmpty();
//STRIP001 
//STRIP001 					// So that you can open the document without AutoLayout-Dialog
//STRIP001 					pOpt->SetStartWithTemplate(FALSE);
//STRIP001 					if(bNewDocDirect && !pPilotDlg->GetStartWithFlag())
//STRIP001 						bStartWithTemplate = FALSE;
//STRIP001 
//STRIP001 					if( pPilotDlg->GetStartType() == ST_OPEN )
//STRIP001 					{
//STRIP001 						String aFileToOpen = aDocPath;
//STRIP001 						delete pPilotDlg;
//STRIP001 
//STRIP001                         DBG_ASSERT( aFileToOpen.Len()!=0, "The autopilot should have asked for a file itself already!" );
//STRIP001 						if(aFileToOpen.Len() != 0)
//STRIP001 						{
//STRIP001 							SfxStringItem aFile( SID_FILE_NAME, aFileToOpen );
//STRIP001 							SfxStringItem aReferer( SID_REFERER, UniString() );
//STRIP001 							SfxStringItem aPassword( SID_PASSWORD, aPasswrd );
//STRIP001 
//STRIP001 							SFX_REQUEST_ARG( rReq, pFrmItem, SfxFrameItem, SID_DOCFRAME, FALSE);
//STRIP001 							if ( pFrmItem && pFrmItem->GetFrame())
//STRIP001 							{
//STRIP001 								pFrame = pFrmItem->GetFrame();
//STRIP001 
//STRIP001 								SfxAllItemSet aSet( *pSet->GetPool() );
//STRIP001 								aSet.Put( aFile );
//STRIP001 								aSet.Put( aReferer );
//STRIP001 								aSet.Put( aPassword );
//STRIP001 
//STRIP001 								const SfxPoolItem* pRet = pFrame->LoadDocumentSynchron( aSet );
//STRIP001 							}
//STRIP001 							else
//STRIP001 							{
//STRIP001                                 SfxRequest aRequest (SID_OPENDOC, SFX_CALLMODE_SYNCHRON, 
//STRIP001                                     SFX_APP()->GetPool());
//STRIP001                                 aRequest.AppendItem (aFile);
//STRIP001                                 aRequest.AppendItem (aReferer);
//STRIP001                                 aRequest.AppendItem (aPassword);
//STRIP001                                 aRequest.AppendItem (SfxStringItem (
//STRIP001                                     SID_TARGETNAME, 
//STRIP001                                     String (RTL_CONSTASCII_USTRINGPARAM ("_default"))));
//STRIP001                                 try
//STRIP001                                 {
//STRIP001                                     SFX_APP()->ExecuteSlot (aRequest);
//STRIP001                                 }
//STRIP001                                 catch (::com::sun::star::uno::Exception e)
//STRIP001                                 {
//STRIP001                                     DBG_ASSERT (FALSE, "caught IllegalArgumentException while loading document from Impress autopilot");
//STRIP001                                 }
//STRIP001 							}
//STRIP001 						}
//STRIP001 
//STRIP001 						pOpt->SetStartWithTemplate(bStartWithTemplate);
//STRIP001 						if(bNewDocDirect && !bStartWithTemplate)
//STRIP001 						{
//STRIP001 							SfxItemSet*	pRet = CreateItemSet( SID_SD_EDITOPTIONS );
//STRIP001 							if(pRet)
//STRIP001 							{
//STRIP001 								ApplyItemSet( SID_SD_EDITOPTIONS, *pRet );
//STRIP001 								delete pRet;
//STRIP001 							}
//STRIP001 
//STRIP001 						}
//STRIP001 						break;
//STRIP001 					}
//STRIP001 
//STRIP001 
//STRIP001 					SfxObjectShellLock xShell( pPilotDlg->GetDocument() );
//STRIP001 					SfxObjectShell* pShell = xShell;
//STRIP001 
//STRIP001 					delete pPilotDlg;
//STRIP001 
//STRIP001 					SfxViewFrame* pViewFrame = NULL;
//STRIP001 					SFX_REQUEST_ARG( rReq, pFrmItem, SfxFrameItem, SID_DOCFRAME, FALSE);
//STRIP001 					if ( pFrmItem && pShell )
//STRIP001 					{
//STRIP001 						pFrame = pFrmItem->GetFrame();
//STRIP001 						pFrame->InsertDocument( pShell );
//STRIP001 						pViewFrame = pFrame->GetCurrentViewFrame();
//STRIP001 					}
//STRIP001 					else if( pShell )
//STRIP001 						pViewFrame = SFX_APP()->CreateViewFrame( *pShell );
//STRIP001 
//STRIP001 					DBG_ASSERT( pViewFrame, "Kein ViewFrame!!" );
//STRIP001 
//STRIP001 					pOpt->SetStartWithTemplate(bStartWithTemplate);
//STRIP001 					if(bNewDocDirect && !bStartWithTemplate)
//STRIP001 					{
//STRIP001 						SfxItemSet*	pRet = CreateItemSet( SID_SD_EDITOPTIONS );
//STRIP001 						if(pRet)
//STRIP001 						{
//STRIP001 							ApplyItemSet( SID_SD_EDITOPTIONS, *pRet );
//STRIP001 							delete pRet;
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					if( pShell && pViewFrame )
//STRIP001 					{
//STRIP001 						SdDrawDocShell* pDocShell = PTR_CAST(SdDrawDocShell,pShell);
//STRIP001 						SdDrawDocument* pDoc = pDocShell->GetDoc();
//STRIP001 
//STRIP001 						SdViewShell* pViewSh = (SdViewShell*) pViewFrame->GetViewShell();
//STRIP001 						SdOptions* pOptions = GetSdOptions(pDoc->GetDocumentType());
//STRIP001 
//STRIP001 						if (pOptions && pViewSh)
//STRIP001 						{
//STRIP001 							// The AutoPilot-document shall be open without its own options
//STRIP001 							FrameView* pFrameView = pViewSh->GetFrameView();
//STRIP001 							pFrameView->Update(pOptions);
//STRIP001 							pViewSh->ReadFrameViewData(pFrameView);
//STRIP001 						}
//STRIP001 
//STRIP001 						USHORT nPages=pDoc->GetPageCount();
//STRIP001 
//STRIP001 						// settings for the Outputmedium
//STRIP001 						Size aNewSize;
//STRIP001 						UINT32 nLeft;
//STRIP001 						UINT32 nRight;
//STRIP001 						UINT32 nLower;
//STRIP001 						UINT32 nUpper;
//STRIP001 						switch(eMedium)
//STRIP001 						{
//STRIP001 							case OUTPUT_PAGE:
//STRIP001 							case OUTPUT_OVERHEAD:
//STRIP001 							{
//STRIP001 								SfxPrinter* pPrinter = pDocShell->GetPrinter(TRUE);
//STRIP001 
//STRIP001 								if (pPrinter->IsValid())
//STRIP001 								{
//STRIP001 									// Der Printer gibt leider kein exaktes
//STRIP001 									// Format (z.B. A4) zurueck
//STRIP001 									Size aSize(pPrinter->GetPaperSize());
//STRIP001 									SvxPaper ePaper = SvxPaperInfo::GetSvxPaper( aSize, MAP_100TH_MM, TRUE);
//STRIP001 
//STRIP001 									if (ePaper != SVX_PAPER_USER)
//STRIP001 									{
//STRIP001 										// Korrekte Size holen
//STRIP001 										aSize = SvxPaperInfo::GetPaperSize(ePaper, MAP_100TH_MM);
//STRIP001 									}
//STRIP001 
//STRIP001 									if (aSize.Height() > aSize.Width())
//STRIP001 									{
//STRIP001 										 // Stets Querformat
//STRIP001 										 aNewSize.Width()  = aSize.Height();
//STRIP001 										 aNewSize.Height() = aSize.Width();
//STRIP001 									}
//STRIP001 									else
//STRIP001 									{
//STRIP001 										 aNewSize = aSize;
//STRIP001 									}
//STRIP001 								}
//STRIP001 								else
//STRIP001 								{
//STRIP001 									aNewSize=Size(29700, 21000);
//STRIP001 								}
//STRIP001 
//STRIP001 								if (eMedium == OUTPUT_PAGE)
//STRIP001 								{
//STRIP001 									nLeft =1000;
//STRIP001 									nRight=1000;
//STRIP001 									nUpper=1000;
//STRIP001 									nLower=1000;
//STRIP001 								}
//STRIP001 								else
//STRIP001 								{
//STRIP001 									nLeft =0;
//STRIP001 									nRight=0;
//STRIP001 									nUpper=0;
//STRIP001 									nLower=0;
//STRIP001 								}
//STRIP001 							}
//STRIP001 							break;
//STRIP001 
//STRIP001 							case OUTPUT_SLIDE:
//STRIP001 							{
//STRIP001 								aNewSize = Size(27000, 18000);
//STRIP001 								nLeft =0;
//STRIP001 								nRight=0;
//STRIP001 								nUpper=0;
//STRIP001 								nLower=0;
//STRIP001 							}
//STRIP001 							break;
//STRIP001 
//STRIP001 							case OUTPUT_PRESENTATION:
//STRIP001 							{
//STRIP001 								aNewSize = Size(28000, 21000);
//STRIP001 								nLeft =0;
//STRIP001 								nRight=0;
//STRIP001 								nUpper=0;
//STRIP001 								nLower=0;
//STRIP001 							}
//STRIP001 							break;
//STRIP001 						}
//STRIP001 
//STRIP001 						BOOL bScaleAll = TRUE;
//STRIP001 						USHORT nPageCnt = pDoc->GetMasterSdPageCount(PK_STANDARD);
//STRIP001 						USHORT i;
//STRIP001 						SdPage* pPage;
//STRIP001 
//STRIP001 						for (i = 0; i < nPageCnt; i++)
//STRIP001 						{
//STRIP001 							// ********************************************************************
//STRIP001 							// Erst alle MasterPages bearbeiten
//STRIP001 							// ********************************************************************
//STRIP001 							pPage = pDoc->GetMasterSdPage(i, PK_STANDARD);
//STRIP001 
//STRIP001 							if (pPage)
//STRIP001 							{
//STRIP001 								if(eMedium != OUTPUT_ORIGINAL)
//STRIP001 								{
//STRIP001 									Rectangle aBorderRect(nLeft, nUpper, nRight, nLower);
//STRIP001 									pPage->ScaleObjects(aNewSize, aBorderRect, bScaleAll);
//STRIP001 									pPage->SetSize(aNewSize);
//STRIP001 									pPage->SetBorder(nLeft, nUpper, nRight, nLower);
//STRIP001 								}
//STRIP001 								SdPage* pNotesPage = pDoc->GetMasterSdPage(i, PK_NOTES);
//STRIP001 								DBG_ASSERT( pNotesPage, "Wrong page ordering!" );
//STRIP001 								if( pNotesPage ) pNotesPage->CreateTitleAndLayout();
//STRIP001 								pPage->CreateTitleAndLayout();
//STRIP001 							}
//STRIP001 						}
//STRIP001 
//STRIP001 						nPageCnt = pDoc->GetSdPageCount(PK_STANDARD);
//STRIP001 
//STRIP001 						for (i = 0; i < nPageCnt; i++)
//STRIP001 						{
//STRIP001 							// *********************************************************************
//STRIP001 							// Danach alle Pages bearbeiten
//STRIP001 							// *********************************************************************
//STRIP001 							pPage = pDoc->GetSdPage(i, PK_STANDARD);
//STRIP001 
//STRIP001 							if (pPage)
//STRIP001 							{
//STRIP001 								if(eMedium != OUTPUT_ORIGINAL)
//STRIP001 								{
//STRIP001 									Rectangle aBorderRect(nLeft, nUpper, nRight, nLower);
//STRIP001 									pPage->ScaleObjects(aNewSize, aBorderRect, bScaleAll);
//STRIP001 									pPage->SetSize(aNewSize);
//STRIP001 									pPage->SetBorder(nLeft, nUpper, nRight, nLower);
//STRIP001 								}
//STRIP001 								SdPage* pNotesPage = pDoc->GetSdPage(i, PK_NOTES);
//STRIP001 								DBG_ASSERT( pNotesPage, "Wrong page ordering!" );
//STRIP001 								if( pNotesPage ) pNotesPage->SetAutoLayout( pNotesPage->GetAutoLayout() );
//STRIP001 								pPage->SetAutoLayout( pPage->GetAutoLayout() );
//STRIP001 							}
//STRIP001 						}
//STRIP001 
//STRIP001 						SdPage* pHandoutPage = pDoc->GetSdPage(0, PK_HANDOUT);
//STRIP001 						pHandoutPage->CreateTitleAndLayout(TRUE);
//STRIP001 
//STRIP001 						if(eMedium != OUTPUT_ORIGINAL)
//STRIP001 						{
//STRIP001 							pViewFrame->GetDispatcher()->Execute(SID_SIZE_PAGE,
//STRIP001 							SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 						}
//STRIP001 
//STRIP001 						if(bSummary)
//STRIP001                             AddSummaryPage (pViewFrame, pDoc);
//STRIP001 
//STRIP001 						if(aDocPath.Len() == 0) // leeres Document?
//STRIP001 						{
//STRIP001 							SfxBoolItem aIsChangedItem(SID_MODIFYPAGE, !bIsDocEmpty);
//STRIP001 							SfxUInt32Item eAutoLayout( ID_VAL_WHATLAYOUT, (UINT32) AUTOLAYOUT_TITLE );
//STRIP001 							pViewFrame->GetDispatcher()->Execute(SID_MODIFYPAGE,
//STRIP001 							   SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aIsChangedItem, &eAutoLayout, 0L);
//STRIP001 						}
//STRIP001 
//STRIP001 						pDoc->SetChanged(!bIsDocEmpty);
//STRIP001 
//STRIP001 						// clear document info
//STRIP001 						SfxDocumentInfo& rInfo = pDocShell->GetDocInfo();
//STRIP001 
//STRIP001 						SfxStamp aCreated;
//STRIP001 						SvtUserOptions aOptions;
//STRIP001 						aCreated.SetName( aOptions.GetFullName() );
//STRIP001 						rInfo.SetCreated( aCreated );
//STRIP001 
//STRIP001 						SfxStamp aInvalid( TIMESTAMP_INVALID_DATETIME );
//STRIP001 						rInfo.SetChanged( aInvalid );
//STRIP001 						rInfo.SetPrinted( aInvalid );
//STRIP001 						rInfo.SetTime( 0L );
//STRIP001 						rInfo.SetDocumentNumber( 1 );
//STRIP001 						rInfo.SetUseUserData( TRUE );
//STRIP001 
//STRIP001 						// #94652# clear UNDO stack after autopilot
//STRIP001 						SfxUndoManager* pUndoManager = pDocShell->GetUndoManager();
//STRIP001 						DBG_ASSERT(pUndoManager, "No UNDO MANAGER ?!?");
//STRIP001 						if(pUndoManager->GetUndoActionCount())
//STRIP001 							pUndoManager->Clear();
//STRIP001 
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_OPENDOC:
//STRIP001 		{
//STRIP001 			BOOL bIntercept = FALSE;
//STRIP001 			SdDrawDocShell* pDocShell = PTR_CAST(SdDrawDocShell, SfxObjectShell::Current());
//STRIP001 			if (pDocShell)
//STRIP001 			{
//STRIP001 				SdViewShell* pViewShell = pDocShell->GetViewShell();
//STRIP001 				if (pViewShell)
//STRIP001 				{
//STRIP001 					if (pViewShell->GetSlideShow())
//STRIP001 					{
//STRIP001 						const SfxItemSet* pSet = rReq.GetArgs();
//STRIP001 						if (pSet == NULL)
//STRIP001                         {
//STRIP001                             // e.g. open button during a presentation.
//STRIP001 							bIntercept = TRUE;
//STRIP001                         }
//STRIP001                         /* Since #110295# the following block is not
//STRIP001                            necessary anymore: Star/OpenOffice
//STRIP001                            documents can be opened during a show.
//STRIP001                                                                 
//STRIP001                         else
//STRIP001                         {
//STRIP001 							String aBookmark(((SfxStringItem&)pSet->Get(SID_FILE_NAME)).GetValue());
//STRIP001 
//STRIP001 							// interner Sprung?
//STRIP001 							String aDocName(aBookmark.GetToken(0, '#'));
//STRIP001 							if (aBookmark.Search( '#' ) != STRING_NOTFOUND &&
//STRIP001 							    aDocName.Len() > 0 &&
//STRIP001 								pDocShell->GetMedium()->GetName() != aDocName &&
//STRIP001 								pDocShell->GetName() != aDocName              &&
//STRIP001 								aDocName.Search( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( ".wav" ) ) ) == STRING_NOTFOUND )
//STRIP001 							{
//STRIP001 								bIntercept = TRUE;
//STRIP001 
//STRIP001 								// nur ein Frame in meinem Doc?
//STRIP001 								SFX_REQUEST_ARG(rReq, pFrmItem, SfxFrameItem, SID_DOCFRAME, FALSE);
//STRIP001 								if (pFrmItem)
//STRIP001 								{
//STRIP001 									SfxFrame* pFrame = pFrmItem->GetFrame();
//STRIP001 									SFX_REQUEST_ARG(rReq, pTargetItem, SfxStringItem, SID_TARGETNAME, FALSE);
//STRIP001 									if (pTargetItem)
//STRIP001 									{
//STRIP001 										pFrame = pFrame->SearchFrame(pTargetItem->GetValue());
//STRIP001 									}
//STRIP001 
//STRIP001 									SfxFrame* pMyFrame = pViewShell->GetViewFrame()->GetFrame();
//STRIP001 									SfxFrame* pParent = pFrame->GetParentFrame();
//STRIP001 
//STRIP001 									while (pParent)
//STRIP001 									{
//STRIP001 										if (pParent == pMyFrame)
//STRIP001 										{
//STRIP001 											bIntercept = FALSE;
//STRIP001 											break;
//STRIP001 										}
//STRIP001 										pParent = pParent->GetParentFrame();
//STRIP001 									}
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001                         */
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			if (!bIntercept)
//STRIP001 			{
//STRIP001 				OFF_APP()->ExecuteSlot(rReq, OFF_APP()->GetInterface());
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				ErrorBox(NULL, WB_OK, String(SdResId(STR_CANT_PERFORM_IN_LIVEMODE))).Execute();
//STRIP001 
//STRIP001     			SFX_REQUEST_ARG( rReq, pLinkItem, SfxLinkItem, SID_DONELINK, FALSE );
//STRIP001 				if( pLinkItem )
//STRIP001 	        		pLinkItem->GetValue().Call( 0 );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_OUTLINE_TO_IMPRESS:
//STRIP001 		{
//STRIP001 			const SfxItemSet* pSet = rReq.GetArgs();
//STRIP001 
//STRIP001 			if (pSet)
//STRIP001 			{
//STRIP001 				SvLockBytes* pBytes = ((SfxLockBytesItem&) pSet->Get(SID_OUTLINE_TO_IMPRESS)).GetValue();
//STRIP001 
//STRIP001 				if (pBytes)
//STRIP001 				{
//STRIP001 					SfxObjectShellLock xDocShell;
//STRIP001 					SdDrawDocShell* pDocSh;
//STRIP001 					xDocShell = pDocSh = new SdDrawDocShell(SFX_CREATE_MODE_STANDARD, FALSE);
//STRIP001 					if(pDocSh)
//STRIP001 					{
//STRIP001 						pDocSh->DoInitNew(NULL);
//STRIP001 						SdDrawDocument* pDoc = pDocSh->GetDoc();
//STRIP001 						if(pDoc)
//STRIP001 						{
//STRIP001 							pDoc->CreateFirstPages();
//STRIP001 							pDoc->StopWorkStartupDelay();
//STRIP001 						}
//STRIP001 
//STRIP001 						SFX_REQUEST_ARG( rReq, pFrmItem, SfxFrameItem, SID_DOCFRAME, FALSE);
//STRIP001 						if ( pFrmItem )
//STRIP001 						{
//STRIP001 							SfxFrame* pFrame = pFrmItem->GetFrame();
//STRIP001 							pFrame->InsertDocument( pDocSh );
//STRIP001 						}
//STRIP001 						else
//STRIP001 							SFX_APP()->CreateViewFrame( *pDocSh );
//STRIP001 
//STRIP001 						SdViewShell* pViewSh = pDocSh->GetViewShell();
//STRIP001 
//STRIP001 						if (pViewSh)
//STRIP001 						{
//STRIP001 							// AutoLayouts muessen fertig sein
//STRIP001 							SdDrawDocument* pDoc = pDocSh->GetDoc();
//STRIP001 							pDoc->StopWorkStartupDelay();
//STRIP001 
//STRIP001 							// hide preview
//STRIP001 							SfxViewFrame* pViewFrame = pViewSh->GetViewFrame();
//STRIP001 							SfxBoolItem aItem( SID_PREVIEW_WIN, FALSE );
//STRIP001 							pViewFrame->GetDispatcher()->Execute( SID_PREVIEW_WIN, SFX_CALLMODE_SYNCHRON |
//STRIP001 													SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 
//STRIP001 							// In den Gliederungsmodus wechseln
//STRIP001 							pViewFrame->GetDispatcher()->Execute(
//STRIP001 							SID_VIEWSHELL2, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 
//STRIP001 							// OutlineViewShell holen
//STRIP001 							SdOutlineViewShell* pViewSh = PTR_CAST(SdOutlineViewShell, pViewFrame->GetViewShell());
//STRIP001 
//STRIP001 							if (pViewSh)
//STRIP001 							{
//STRIP001 								SvStream* pStream = (SvStream*) pBytes->GetStream();
//STRIP001 								if ( pViewSh->Read(*pStream, EE_FORMAT_RTF) == 0 )
//STRIP001 								{
//STRIP001 									// Remove the first empty pages
//STRIP001 									USHORT nPageCount = pDoc->GetPageCount();
//STRIP001 									pDoc->RemovePage( --nPageCount );  // notes page
//STRIP001 									pDoc->RemovePage( --nPageCount );  // standard page
//STRIP001 								}
//STRIP001 							}
//STRIP001 						}
//STRIP001 
//STRIP001 						// #97231# Undo-Stack needs to be cleared, else the user may remove the
//STRIP001 						// only drawpage and this is a state we cannot handle ATM.
//STRIP001 						SfxUndoManager* pUndoManager = pDocSh->GetUndoManager();
//STRIP001 						DBG_ASSERT(pUndoManager, "No UNDO MANAGER ?!?");
//STRIP001 						if(pUndoManager->GetUndoActionCount())
//STRIP001 							pUndoManager->Clear();
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			rReq.IsDone();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	// #94442# if a frame was created, set it as return value
//STRIP001 	if(pFrame)
//STRIP001 	{
//STRIP001 		rReq.SetReturnValue(SfxFrameItem(0, pFrame));
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* GetState
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdModule::GetState(SfxItemSet& rItemSet)
//STRIP001 {
//STRIP001 	// Autopilot waehrend der Praesentation disablen
//STRIP001 	if (rItemSet.GetItemState(SID_SD_AUTOPILOT) != SFX_ITEM_UNKNOWN)
//STRIP001 	{
//STRIP001 		if (!SvtModuleOptions().IsImpress())
//STRIP001 		{
//STRIP001 			rItemSet.DisableItem(SID_SD_AUTOPILOT);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			SdDrawDocShell* pDocShell = PTR_CAST(SdDrawDocShell, SfxObjectShell::Current());
//STRIP001 			if (pDocShell)
//STRIP001 			{
//STRIP001 				SdViewShell* pViewShell = pDocShell->GetViewShell();
//STRIP001 				if (pViewShell)
//STRIP001 				{
//STRIP001 					if (pViewShell->GetSlideShow())
//STRIP001 					{
//STRIP001 						rItemSet.DisableItem(SID_SD_AUTOPILOT);
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if( SFX_ITEM_AVAILABLE == rItemSet.GetItemState( SID_ATTR_METRIC ) )
//STRIP001 	{
//STRIP001 		SdDrawDocShell* pDocSh = PTR_CAST( SdDrawDocShell, SfxObjectShell::Current() );
//STRIP001 		if(pDocSh)
//STRIP001 		{
//STRIP001 			DocumentType eDocType = pDocSh->GetDoc()->GetDocumentType();
//STRIP001 
//STRIP001 			SdOptions* pOptions = GetSdOptions(eDocType);
//STRIP001 			rItemSet.Put( SfxUInt16Item( SID_ATTR_METRIC, pOptions->GetMetric() ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// der Status von SID_OPENDOC wird von der Basisklasse bestimmt
//STRIP001 	if (rItemSet.GetItemState(SID_OPENDOC) != SFX_ITEM_UNKNOWN)
//STRIP001 	{
//STRIP001 		const SfxPoolItem* pItem = OFF_APP()->GetSlotState(SID_OPENDOC, OFF_APP()->GetInterface());
//STRIP001 		if (pItem)
//STRIP001 			rItemSet.Put(*pItem);
//STRIP001 	}
//STRIP001 
//STRIP001 	if( SFX_ITEM_AVAILABLE == rItemSet.GetItemState( SID_AUTOSPELL_CHECK ) ||
//STRIP001 		SFX_ITEM_AVAILABLE == rItemSet.GetItemState( SID_AUTOSPELL_MARKOFF ) )
//STRIP001 	{
//STRIP001 		SdDrawDocShell* pDocSh = PTR_CAST(SdDrawDocShell, SfxObjectShell::Current());
//STRIP001 		if( pDocSh )
//STRIP001 		{
//STRIP001 			SdDrawDocument* pDoc = pDocSh->GetDoc();
//STRIP001 			rItemSet.Put( SfxBoolItem( SID_AUTOSPELL_CHECK, pDoc->GetOnlineSpell() ) );
//STRIP001 			rItemSet.Put( SfxBoolItem( SID_AUTOSPELL_MARKOFF, pDoc->GetHideSpell() ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if( SFX_ITEM_AVAILABLE == rItemSet.GetItemState( SID_ATTR_LANGUAGE ) )
//STRIP001 	{
//STRIP001 		SdDrawDocShell* pDocSh = PTR_CAST(SdDrawDocShell, SfxObjectShell::Current());
//STRIP001 		if( pDocSh )
//STRIP001 			rItemSet.Put( SvxLanguageItem( pDocSh->GetDoc()->GetLanguage( EE_CHAR_LANGUAGE ), SID_ATTR_LANGUAGE ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( SFX_ITEM_AVAILABLE == rItemSet.GetItemState( SID_ATTR_CHAR_CJK_LANGUAGE ) )
//STRIP001 	{
//STRIP001 		SdDrawDocShell* pDocSh = PTR_CAST(SdDrawDocShell, SfxObjectShell::Current());
//STRIP001 		if( pDocSh )
//STRIP001 			rItemSet.Put( SvxLanguageItem( pDocSh->GetDoc()->GetLanguage( EE_CHAR_LANGUAGE_CJK ), SID_ATTR_CHAR_CJK_LANGUAGE ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( SFX_ITEM_AVAILABLE == rItemSet.GetItemState( SID_ATTR_CHAR_CTL_LANGUAGE ) )
//STRIP001 	{
//STRIP001 		SdDrawDocShell* pDocSh = PTR_CAST(SdDrawDocShell, SfxObjectShell::Current());
//STRIP001 		if( pDocSh )
//STRIP001 			rItemSet.Put( SvxLanguageItem( pDocSh->GetDoc()->GetLanguage( EE_CHAR_LANGUAGE_CTL ), SID_ATTR_CHAR_CTL_LANGUAGE ) );
//STRIP001 	}
//STRIP001 }




//STRIP001 void SdModule::AddSummaryPage (SfxViewFrame* pViewFrame, SdDrawDocument* pDocument)
//STRIP001 {
//STRIP001     pViewFrame->GetDispatcher()->Execute(SID_SUMMARY_PAGE,
//STRIP001         SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 
//STRIP001     OSL_ASSERT (pDocument!=NULL);
//STRIP001 
//STRIP001     sal_Int32 nPageCount = pDocument->GetSdPageCount (PK_STANDARD);
//STRIP001 
//STRIP001     // We need at least two pages: the summary page and one to use as
//STRIP001     // template to take the transition parameters from.
//STRIP001     if (nPageCount >= 2)
//STRIP001     {
//STRIP001         // Get a page from which to retrieve the transition parameters.
//STRIP001         SdPage* pTemplatePage = pDocument->GetSdPage (0, PK_STANDARD);
//STRIP001         OSL_ASSERT (pTemplatePage!=NULL);
//STRIP001 
//STRIP001         // The summary page, if it exists, is the last page.
//STRIP001         SdPage* pSummaryPage = pDocument->GetSdPage (nPageCount-1, PK_STANDARD);
//STRIP001         OSL_ASSERT (pSummaryPage!=NULL);
//STRIP001 
//STRIP001         // Take the change mode of the template page as indication of the
//STRIP001         // document's kiosk mode.
//STRIP001         pSummaryPage->SetFadeSpeed (pTemplatePage->GetFadeSpeed());
//STRIP001         pSummaryPage->SetFadeEffect (pTemplatePage->GetFadeEffect());
//STRIP001         pSummaryPage->SetPresChange (pTemplatePage->GetPresChange());
//STRIP001         pSummaryPage->SetTime (pTemplatePage->GetTime());
//STRIP001         pSummaryPage->SetSound (pTemplatePage->IsSoundOn());
//STRIP001         pSummaryPage->SetSoundFile (pTemplatePage->GetSoundFile());
//STRIP001     }
//STRIP001 }

}
