/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_output.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:30:21 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

#include "scitems.hxx"
#include <bf_svx/boxitem.hxx>
// auto strip #include <bf_svx/brshitem.hxx>
#include <svtools/colorcfg.hxx>
// auto strip #include <bf_svx/rotmodit.hxx>
#include <bf_svx/shaditem.hxx>
// auto strip #include <bf_svx/svxfont.hxx>
// auto strip #include <so3/ipobj.hxx>
// auto strip #include <tools/poly.hxx>
#include <vcl/svapp.hxx>
#include <svtools/accessibilityoptions.hxx>

#include <math.h>

#include "output.hxx"
// auto strip #include "document.hxx"
#include "cell.hxx"
#include "attrib.hxx"
// auto strip #include "patattr.hxx"
#include "sclnlnk.hxx"
// auto strip #include "docpool.hxx"
// auto strip #include "tabvwsh.hxx"
// auto strip #include "progress.hxx"
// auto strip #include "pagedata.hxx"
#include "chgtrack.hxx"
// auto strip #include "chgviset.hxx"
// auto strip #include "viewutil.hxx"
#include "gridmerg.hxx"
#include "invmerge.hxx"

#include "scmod.hxx"
#include "appoptio.hxx"
namespace binfilter {


// STATIC DATA -----------------------------------------------------------

//	Farben fuer ChangeTracking "nach Autor" wie im Writer (swmodul1.cxx)

#define SC_AUTHORCOLORCOUNT		9

static ColorData nAuthorColor[ SC_AUTHORCOLORCOUNT ] = {
					COL_LIGHTRED, 		COL_LIGHTBLUE,		COL_LIGHTMAGENTA,
					COL_GREEN,			COL_RED,			COL_BLUE,
					COL_BROWN,			COL_MAGENTA,		COL_CYAN };

//	Hilfsklasse, fuer die Farbzuordnung,
//	um nicht mehrfach hintereinander denselben User aus der Liste zu suchen

//STRIP001 class ScActionColorChanger
//STRIP001 {
//STRIP001 private:
//STRIP001 	const ScAppOptions&		rOpt;
//STRIP001 	const StrCollection&	rUsers;
//STRIP001 	String					aLastUserName;
//STRIP001 	USHORT					nLastUserIndex;
//STRIP001 	ColorData				nColor;
//STRIP001 
//STRIP001 public:
//STRIP001 				ScActionColorChanger( const ScChangeTrack& rTrack );
//STRIP001 				~ScActionColorChanger() {}
//STRIP001 
//STRIP001 	void		Update( const ScChangeAction& rAction );
//STRIP001 	ColorData	GetColor() const	{ return nColor; }
//STRIP001 };

//------------------------------------------------------------------

//STRIP001 ScActionColorChanger::ScActionColorChanger( const ScChangeTrack& rTrack ) :
//STRIP001 	rOpt( SC_MOD()->GetAppOptions() ),
//STRIP001 	rUsers( rTrack.GetUserCollection() ),
//STRIP001 	nLastUserIndex( 0 ),
//STRIP001 	nColor( COL_BLACK )
//STRIP001 {
//STRIP001 }

//STRIP001 void ScActionColorChanger::Update( const ScChangeAction& rAction )
//STRIP001 {
//STRIP001 	ColorData nSetColor;
//STRIP001 	switch (rAction.GetType())
//STRIP001 	{
//STRIP001 		case SC_CAT_INSERT_COLS:
//STRIP001 		case SC_CAT_INSERT_ROWS:
//STRIP001 		case SC_CAT_INSERT_TABS:
//STRIP001 			nSetColor = rOpt.GetTrackInsertColor();
//STRIP001 			break;
//STRIP001 		case SC_CAT_DELETE_COLS:
//STRIP001 		case SC_CAT_DELETE_ROWS:
//STRIP001 		case SC_CAT_DELETE_TABS:
//STRIP001 			nSetColor = rOpt.GetTrackDeleteColor();
//STRIP001 			break;
//STRIP001 		case SC_CAT_MOVE:
//STRIP001 			nSetColor = rOpt.GetTrackMoveColor();
//STRIP001 			break;
//STRIP001 		default:
//STRIP001 			nSetColor = rOpt.GetTrackContentColor();
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	if ( nSetColor != COL_TRANSPARENT )		// Farbe eingestellt
//STRIP001 		nColor = nSetColor;
//STRIP001 	else									// nach Autor
//STRIP001 	{
//STRIP001 		if ( rAction.GetUser() != aLastUserName )
//STRIP001 		{
//STRIP001 			aLastUserName = rAction.GetUser();
//STRIP001 			StrData aData(aLastUserName);
//STRIP001 			USHORT nIndex;
//STRIP001 			if (!rUsers.Search(&aData, nIndex))
//STRIP001 			{
//STRIP001 				// empty string is possible if a name wasn't found while saving a 5.0 file
//STRIP001 				DBG_ASSERT( aLastUserName.Len() == 0, "Author not found" );
//STRIP001 				nIndex = 0;
//STRIP001 			}
//STRIP001 			nLastUserIndex = nIndex % SC_AUTHORCOLORCOUNT;
//STRIP001 		}
//STRIP001 		nColor = nAuthorColor[nLastUserIndex];
//STRIP001 	}
//STRIP001 }

//==================================================================

/*N*/ ScOutputData::ScOutputData( OutputDevice* pNewDev, ScOutputType eNewType,
/*N*/ 							RowInfo* pNewRowInfo, USHORT nNewCount, ScDocument* pNewDoc,
/*N*/ 							USHORT nNewTab, long nNewScrX, long nNewScrY,
/*N*/ 							USHORT nNewX1, USHORT nNewY1, USHORT nNewX2, USHORT nNewY2,
/*N*/ 							double nPixelPerTwipsX, double nPixelPerTwipsY,
/*N*/ 							const Fraction* pZoomX, const Fraction* pZoomY ) :
/*N*/ 	pDev( pNewDev ),
/*N*/ 	pRefDevice( pNewDev ),		// default is output device
/*N*/ 	pFmtDevice( pNewDev ),		// default is output device
/*N*/ 	eType( eNewType ),
/*N*/ 	pRowInfo( pNewRowInfo ),
/*N*/ 	nArrCount( nNewCount ),
/*N*/ 	pDoc( pNewDoc ),
/*N*/ 	nTab( nNewTab ),
/*N*/ 	nScrX( nNewScrX ),
/*N*/ 	nScrY( nNewScrY ),
/*N*/ 	nX1( nNewX1 ),
/*N*/ 	nY1( nNewY1 ),
/*N*/ 	nX2( nNewX2 ),
/*N*/ 	nY2( nNewY2 ),
/*N*/ 	nPPTX( nPixelPerTwipsX ),
/*N*/ 	nPPTY( nPixelPerTwipsY ),
/*N*/ 	bEditMode( FALSE ),
/*N*/ 	bMetaFile( FALSE ),
/*N*/ 	bPagebreakMode( FALSE ),
/*N*/ 	bSolidBackground( FALSE ),
/*N*/ 	bUseStyleColor( FALSE ),
/*N*/ 	bForceAutoColor( SC_MOD()->GetAccessOptions().GetIsAutomaticFontColor() ),
/*N*/ 	bSyntaxMode( FALSE ),
/*N*/ 	pValueColor( NULL ),
/*N*/ 	pTextColor( NULL ),
/*N*/ 	pFormulaColor( NULL ),
/*N*/ 	bSingleGrid( FALSE ),
/*N*/ 	aGridColor( COL_BLACK ),
/*N*/ 	bMarkClipped( FALSE ),			// FALSE fuer Drucker/Metafile etc.
/*N*/ 	bShowNullValues( TRUE ),
/*N*/ 	bShowFormulas( FALSE ),
/*N*/ 	bSnapPixel( FALSE ),
/*N*/ 	bShowSpellErrors( FALSE ),
/*N*/ 	pEditObj( NULL ),
/*N*/ 	pViewShell( NULL ),
/*N*/ 	bAnyRotated( FALSE ),
/*N*/ 	bAnyClipped( FALSE )
/*N*/ {
/*N*/ 	if (pZoomX)
/*N*/ 		aZoomX = *pZoomX;
/*N*/ 	else
/*?*/ 		aZoomX = Fraction(1,1);
/*N*/ 	if (pZoomY)
/*N*/ 		aZoomY = *pZoomY;
/*N*/ 	else
/*?*/ 		aZoomY = Fraction(1,1);
/*N*/ 
/*N*/ 	nVisX1 = nX1;
/*N*/ 	nVisY1 = nY1;
/*N*/ 	nVisX2 = nX2;
/*N*/ 	nVisY2 = nY2;
/*N*/ 	pDoc->StripHidden( nVisX1, nVisY1, nVisX2, nVisY2, nTab );
/*N*/ 
/*N*/ 	nScrW = 0;
/*N*/ 	for (USHORT nX=nVisX1; nX<=nVisX2; nX++)
/*N*/ 		nScrW += pRowInfo[0].pCellInfo[nX+1].nWidth;
/*N*/ 
/*N*/ 	nScrH = 0;
/*N*/ 	for (USHORT nArrY=1; nArrY+1<nArrCount; nArrY++)
/*N*/ 		nScrH += pRowInfo[nArrY].nHeight;
/*N*/ 
/*N*/ 	bTabProtected = pDoc->IsTabProtected( nTab );
/*N*/ 	nTabTextDirection = pDoc->GetEditTextDirection( nTab );
/*N*/ }

/*N*/ ScOutputData::~ScOutputData()
/*N*/ {
/*N*/ 	delete pValueColor;
/*N*/ 	delete pTextColor;
/*N*/ 	delete pFormulaColor;
/*N*/ }

/*N*/ void ScOutputData::SetGridColor( const Color& rColor )
/*N*/ {
/*N*/ 	aGridColor = rColor;
/*N*/ }

/*N*/ void ScOutputData::SetMarkClipped( BOOL bSet )
/*N*/ {
/*N*/ 	bMarkClipped = bSet;
/*N*/ }

/*N*/ void ScOutputData::SetShowNullValues( BOOL bSet )
/*N*/ {
/*N*/ 	bShowNullValues = bSet;
/*N*/ }

/*N*/ void ScOutputData::SetShowFormulas( BOOL bSet )
/*N*/ {
/*N*/ 	bShowFormulas = bSet;
/*N*/ }

/*N*/ void ScOutputData::SetShowSpellErrors( BOOL bSet )
/*N*/ {
/*N*/ 	bShowSpellErrors = bSet;
/*N*/ }

//STRIP001 void ScOutputData::SetSnapPixel( BOOL bSet )
//STRIP001 {
//STRIP001 	bSnapPixel = bSet;
//STRIP001 }

//STRIP001 void ScOutputData::SetEditCell( USHORT nCol, USHORT nRow )
//STRIP001 {
//STRIP001 	nEditCol = nCol;
//STRIP001 	nEditRow = nRow;
//STRIP001 	bEditMode = TRUE;
//STRIP001 }

//STRIP001 void ScOutputData::SetMetaFileMode( BOOL bNewMode )
//STRIP001 {
//STRIP001 	bMetaFile = bNewMode;
//STRIP001 }

/*N*/ void ScOutputData::SetSingleGrid( BOOL bNewMode )
/*N*/ {
/*N*/ 	bSingleGrid = bNewMode;
/*N*/ }

/*N*/ void ScOutputData::SetSyntaxMode( BOOL bNewMode )
/*N*/ {
/*N*/ 	bSyntaxMode = bNewMode;
/*N*/ 	if (bNewMode)
/*?*/ 		if (!pValueColor)
/*?*/ 		{
/*?*/ 			pValueColor = new Color( COL_LIGHTBLUE );
/*?*/ 			pTextColor = new Color( COL_BLACK );
/*?*/ 			pFormulaColor = new Color( COL_GREEN );
/*?*/ 		}
/*N*/ }

/*N*/ void ScOutputData::DrawGrid( BOOL bGrid, BOOL bPage )
/*N*/ {
/*N*/ 	USHORT nX;
/*N*/ 	USHORT nY;
/*N*/ 	long nPosX;
/*N*/ 	long nPosY;
/*N*/ 	USHORT i;
/*N*/ 	USHORT nArrY;
/*N*/ 	BYTE nOldFlags = 0;
/*N*/ 	BYTE nFlags;
/*N*/ 	BOOL bSingle;
/*N*/ 	Color aPageColor;
/*N*/ 	Color aManualColor;
/*N*/ 
/*N*/ 	if (bPagebreakMode)
/*N*/ 		bPage = FALSE;			// keine "normalen" Umbrueche ueber volle Breite/Hoehe
/*N*/ 
/*N*/ 	//!	um den einen Pixel sieht das Metafile (oder die Druck-Ausgabe) anders aus
/*N*/ 	//!	als die Bildschirmdarstellung, aber wenigstens passen Druck und Metafile zusammen
/*N*/ 
/*N*/ 	Size aOnePixel = pDev->PixelToLogic(Size(1,1));
/*N*/ 	long nOneX = aOnePixel.Width();
/*N*/ 	long nOneY = aOnePixel.Height();
/*N*/ 	if (bMetaFile)
/*N*/ 		nOneX = nOneY = 1;
/*N*/ 
/*N*/ 	if ( eType == OUTTYPE_WINDOW )
/*N*/ 	{
/*N*/         const svtools::ColorConfig& rColorCfg = SC_MOD()->GetColorConfig();
/*N*/         aPageColor.SetColor( rColorCfg.GetColorValue(svtools::CALCPAGEBREAKAUTOMATIC).nColor );
/*N*/         aManualColor.SetColor( rColorCfg.GetColorValue(svtools::CALCPAGEBREAKMANUAL).nColor );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		aPageColor = aGridColor;
/*N*/ 		aManualColor = aGridColor;
/*N*/ 	}
/*N*/ 
/*N*/ 	pDev->SetLineColor( aGridColor );
/*N*/ 	ScGridMerger aGrid( pDev, nOneX, nOneY );
/*N*/ 
/*N*/ 										//
/*N*/ 										//	Vertikale Linien
/*N*/ 										//
/*N*/ 
/*N*/ 	nPosX = nScrX;
/*N*/ 	for (nX=nX1; nX<=nX2; nX++)
/*N*/ 	{
/*N*/ 		USHORT nXplus1 = nX+1;
/*N*/ 		USHORT nXplus2 = nX+2;
/*N*/ 		USHORT nWidth = pRowInfo[0].pCellInfo[nXplus1].nWidth;
/*N*/ 		if (nWidth)
/*N*/ 		{
/*N*/ 			nPosX += nWidth;
/*N*/ 
/*N*/ 			if ( bPage )
/*N*/ 			{
/*N*/ 				//	Seitenumbrueche auch in ausgeblendeten suchen
/*N*/ 				nFlags = 0;
/*N*/ 				USHORT nCol = nXplus1;
/*N*/ 				while (nCol <= MAXCOL)
/*N*/ 				{
/*N*/ 					BYTE nDocFl = pDoc->GetColFlags( nCol, nTab );
/*N*/ 					nFlags = nDocFl & ( CR_PAGEBREAK | CR_MANUALBREAK );
/*N*/ 					if ( nFlags || !(nDocFl & CR_HIDDEN) )
/*N*/ 						break;
/*N*/ 					++nCol;
/*N*/ 				}
/*N*/ 
/*N*/ 				if (nFlags != nOldFlags)
/*N*/ 				{
/*N*/ 					aGrid.Flush();
/*N*/ 					pDev->SetLineColor( (nFlags & CR_MANUALBREAK) ? aManualColor :
/*N*/ 									 (nFlags) ? aPageColor : aGridColor );
/*N*/ 					nOldFlags = nFlags;
/*N*/ 				}
/*N*/ 			}
/*N*/ 
/*N*/ 			BOOL bDraw = bGrid || nOldFlags;	// einfaches Gitter nur wenn eingestellt
/*N*/ 
/*N*/ 			//!	Mit dieser Abfrage wird zuviel weggelassen, wenn ein automatischer
/*N*/ 			//!	Umbruch mitten in den Wiederholungsspalten liegt.
/*N*/ 			//!	Dann lieber den aeusseren Rahmen zweimal ausgeben...
/*N*/ #if 0
/*?*/ 			//	auf dem Drucker die Aussen-Linien weglassen (werden getrennt ausgegeben)
/*?*/ 			if ( eType == OUTTYPE_PRINTER && !bMetaFile )
/*?*/ 			{
/*?*/ 				if ( nX == MAXCOL )
/*?*/ 					bDraw = FALSE;
/*?*/ 				else if (pDoc->GetColFlags(nXplus1,nTab) & ( CR_PAGEBREAK | CR_MANUALBREAK ))
/*?*/ 					bDraw = FALSE;
/*?*/ 			}
/*N*/ #endif
/*N*/ 
/*N*/ 			USHORT nWidthXplus2 = pRowInfo[0].pCellInfo[nXplus2].nWidth;
/*N*/ 			bSingle = bSingleGrid;									//! in Fillinfo holen !!!!!
/*N*/ 			if ( nX<MAXCOL && !bSingle )
/*N*/ 			{
/*?*/ 				bSingle = ( nWidthXplus2 == 0 );
/*?*/ 				for (nArrY=1; nArrY+1<nArrCount && !bSingle; nArrY++)
/*?*/ 				{
/*?*/ 					if (pRowInfo[nArrY].pCellInfo[nXplus2].bHOverlapped)
/*?*/ 						bSingle = TRUE;
/*?*/ 					if (pRowInfo[nArrY].pCellInfo[nXplus1].bHideGrid)
/*?*/ 						bSingle = TRUE;
/*?*/ 				}
/*N*/ 			}
/*N*/ 
/*N*/ 			if (bDraw)
/*N*/ 			{
/*N*/ 				if ( nX<MAXCOL && bSingle )
/*N*/ 				{
/*N*/ 					USHORT nVisX = nXplus1;
/*N*/ 					while ( nVisX < MAXCOL && !pDoc->GetColWidth(nVisX,nTab) )
/*N*/ 						++nVisX;
/*N*/ 
/*N*/ 					nPosY = nScrY;
/*N*/ 					long nNextY;
/*N*/ 					for (nArrY=1; nArrY+1<nArrCount; nArrY++)
/*N*/ 					{
/*N*/ 						RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*N*/ 						nNextY = nPosY + pThisRowInfo->nHeight;
/*N*/ 
/*N*/ 						BOOL bHOver = pThisRowInfo->pCellInfo[nXplus1].bHideGrid;
/*N*/ 						if (!bHOver)
/*N*/ 						{
/*N*/ 							if (nWidthXplus2)
/*N*/ 								bHOver = pThisRowInfo->pCellInfo[nXplus2].bHOverlapped;
/*N*/ 							else
/*N*/ 							{
/*?*/ 								if (nVisX <= nX2)
/*?*/ 									bHOver = pThisRowInfo->pCellInfo[nVisX+1].bHOverlapped;
/*?*/ 								else
/*?*/ 									bHOver = ((ScMergeFlagAttr*)pDoc->GetAttr(
/*?*/ 												nVisX,pThisRowInfo->nRowNo,nTab,ATTR_MERGE_FLAG))
/*?*/ 												->IsHorOverlapped();
/*?*/ 								if (bHOver)
/*?*/ 									bHOver = ((ScMergeFlagAttr*)pDoc->GetAttr(
/*?*/ 												nXplus1,pThisRowInfo->nRowNo,nTab,ATTR_MERGE_FLAG))
/*?*/ 												->IsHorOverlapped();
/*N*/ 							}
/*N*/ 						}
/*N*/ 
/*N*/ 						if (pThisRowInfo->bChanged && !bHOver)
/*N*/ 						{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 							//Point aStart( nPosX-nOneX, nPosY );
//STRIP001 /*?*/ 							//Point aEnd( nPosX-nOneX, nNextY-nOneY );
//STRIP001 /*?*/ 							//pDev->DrawLine( aStart, aEnd );
//STRIP001 /*?*/ 							aGrid.AddVerLine( nPosX-nOneX, nPosY, nNextY-nOneY );
/*N*/ 						}
/*N*/ 						nPosY = nNextY;
/*N*/ 					}
/*N*/ 				}
/*N*/ 				else
/*N*/ 				{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 					//Point aStart( nPosX-nOneX, nScrY );
//STRIP001 /*?*/ 					//Point aEnd( nPosX-nOneX, nScrY+nScrH-nOneY );
//STRIP001 /*?*/ 					//pDev->DrawLine( aStart, aEnd );
//STRIP001 /*?*/ 					aGrid.AddVerLine( nPosX-nOneX, nScrY, nScrY+nScrH-nOneY );
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 										//
/*N*/ 										//	Horizontale Linien
/*N*/ 										//
/*N*/ 
/*N*/ 	nPosY = nScrY;
/*N*/ 	for (nArrY=1; nArrY+1<nArrCount; nArrY++)
/*N*/ 	{
/*N*/ 		USHORT nArrYplus1 = nArrY+1;
/*N*/ 		nY = pRowInfo[nArrY].nRowNo;
/*N*/ 		USHORT nYplus1 = nY+1;
/*N*/ 		nPosY += pRowInfo[nArrY].nHeight;
/*N*/ 
/*N*/ 		if (pRowInfo[nArrY].bChanged)
/*N*/ 		{
/*?*/ 			if ( bPage )
/*?*/ 			{
/*?*/ 				//	Seitenumbrueche auch in ausgeblendeten suchen
/*?*/ 				nFlags = 0;
/*?*/ 				USHORT nRow = nYplus1;
/*?*/ 				while (nRow <= MAXROW)
/*?*/ 				{
/*?*/ 					BYTE nDocFl = pDoc->GetRowFlags( nRow, nTab );
/*?*/ 					nFlags = nDocFl & ( CR_PAGEBREAK | CR_MANUALBREAK );
/*?*/ 					if ( nFlags || !(nDocFl & CR_HIDDEN) )
/*?*/ 						break;
/*?*/ 					++nRow;
/*?*/ 				}
/*?*/ 
/*?*/ 				if (nFlags != nOldFlags)
/*?*/ 				{
/*?*/ 					aGrid.Flush();
/*?*/ 					pDev->SetLineColor( (nFlags & CR_MANUALBREAK) ? aManualColor :
/*?*/ 									 (nFlags) ? aPageColor : aGridColor );
/*?*/ 					nOldFlags = nFlags;
/*?*/ 				}
/*?*/ 			}
/*?*/ 
/*?*/ 			BOOL bDraw = bGrid || nOldFlags;	// einfaches Gitter nur wenn eingestellt
/*?*/ 
/*?*/ 			//!	Mit dieser Abfrage wird zuviel weggelassen, wenn ein automatischer
/*?*/ 			//!	Umbruch mitten in den Wiederholungszeilen liegt.
/*?*/ 			//!	Dann lieber den aeusseren Rahmen zweimal ausgeben...
/*?*/ #if 0
/*?*/ 			//	auf dem Drucker die Aussen-Linien weglassen (werden getrennt ausgegeben)
/*?*/ 			if ( eType == OUTTYPE_PRINTER && !bMetaFile )
/*?*/ 			{
/*?*/ 				if ( nY == MAXROW )
/*?*/ 					bDraw = FALSE;
/*?*/ 				else if (pDoc->GetRowFlags(nYplus1,nTab) & ( CR_PAGEBREAK | CR_MANUALBREAK ))
/*?*/ 					bDraw = FALSE;
/*?*/ 			}
/*?*/ #endif
/*?*/ 
/*?*/ 			BOOL bNextYisNextRow = (pRowInfo[nArrYplus1].nRowNo == nYplus1);
/*?*/ 			bSingle = !bNextYisNextRow;				// Hidden
/*?*/ 			for (i=nX1; i<=nX2 && !bSingle; i++)
/*?*/ 			{
/*?*/ 				if (pRowInfo[nArrYplus1].pCellInfo[i+1].bVOverlapped)
/*?*/ 					bSingle = TRUE;
/*?*/ 			}
/*?*/ 
/*?*/ 			if (bDraw)
/*?*/ 			{
/*?*/ 				if ( bSingle && nY<MAXROW )
/*?*/ 				{
/*?*/ 					USHORT nVisY = pRowInfo[nArrYplus1].nRowNo;
/*?*/ 
/*?*/ 					nPosX = nScrX;
/*?*/ 					long nNextX;
/*?*/ 					for (i=nX1; i<=nX2; i++)
/*?*/ 					{
/*?*/ 						nNextX = nPosX + pRowInfo[0].pCellInfo[i+1].nWidth;
/*?*/ 						if (nNextX != nPosX)								// sichtbar
/*?*/ 						{
/*?*/ 							BOOL bVOver;
/*?*/ 							if ( bNextYisNextRow )
/*?*/ 								bVOver = pRowInfo[nArrYplus1].pCellInfo[i+1].bVOverlapped;
/*?*/ 							else
/*?*/ 							{
/*?*/ 								bVOver = ((ScMergeFlagAttr*)pDoc->GetAttr(
/*?*/ 											i,nYplus1,nTab,ATTR_MERGE_FLAG))
/*?*/ 											->IsVerOverlapped()
/*?*/ 									&& 	 ((ScMergeFlagAttr*)pDoc->GetAttr(
/*?*/ 											i,nVisY,nTab,ATTR_MERGE_FLAG))
/*?*/ 											->IsVerOverlapped();
/*?*/ 									//! nVisY aus Array ??
/*?*/ 							}
/*?*/ 							if (!bVOver)
/*?*/ 							{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 								//Point aStart( nPosX, nPosY-nOneY );
//STRIP001 /*?*/ 								//Point aEnd( nNextX-nOneX, nPosY-nOneY );
//STRIP001 /*?*/ 								//pDev->DrawLine( aStart, aEnd );
//STRIP001 /*?*/ 								aGrid.AddHorLine( nPosX, nNextX-nOneX, nPosY-nOneY );
/*?*/ 							}
/*?*/ 						}
/*?*/ 						nPosX = nNextX;
/*?*/ 					}
/*?*/ 				}
/*?*/ 				else
/*?*/ 				{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 					//Point aStart( nScrX, nPosY-nOneY );
//STRIP001 /*?*/ 					//Point aEnd( nScrX+nScrW-nOneX, nPosY-nOneY );
//STRIP001 /*?*/ 					//pDev->DrawLine( aStart, aEnd );
//STRIP001 /*?*/ 					aGrid.AddHorLine( nScrX, nScrX+nScrW-nOneX, nPosY-nOneY );
/*?*/ 				}
/*?*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//	----------------------------------------------------------------------------

//STRIP001 void ScOutputData::SetPagebreakMode( ScPageBreakData* pPageData )
//STRIP001 {
//STRIP001 	bPagebreakMode = TRUE;
//STRIP001 	if (!pPageData)
//STRIP001 		return;						// noch nicht initialisiert -> alles "nicht gedruckt"
//STRIP001 
//STRIP001 	//	gedruckten Bereich markieren
//STRIP001 	//	(in FillInfo ist schon alles auf FALSE initialisiert)
//STRIP001 
//STRIP001 	USHORT nRangeCount = pPageData->GetCount();
//STRIP001 	for (USHORT nPos=0; nPos<nRangeCount; nPos++)
//STRIP001 	{
//STRIP001 		ScRange aRange = pPageData->GetData( nPos ).GetPrintRange();
//STRIP001 
//STRIP001 		USHORT nStartX = Max( aRange.aStart.Col(), nX1 );
//STRIP001 		USHORT nEndX   = Min( aRange.aEnd.Col(),   nX2 );
//STRIP001 		USHORT nStartY = Max( aRange.aStart.Row(), nY1 );
//STRIP001 		USHORT nEndY   = Min( aRange.aEnd.Row(),   nY2 );
//STRIP001 
//STRIP001 		for (USHORT nArrY=1; nArrY+1<nArrCount; nArrY++)
//STRIP001 		{
//STRIP001 			RowInfo* pThisRowInfo = &pRowInfo[nArrY];
//STRIP001 			if ( pThisRowInfo->bChanged && pThisRowInfo->nRowNo >= nStartY &&
//STRIP001 										   pThisRowInfo->nRowNo <= nEndY )
//STRIP001 			{
//STRIP001 				for (USHORT nX=nStartX; nX<=nEndX; nX++)
//STRIP001 					pThisRowInfo->pCellInfo[nX+1].bPrinted = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*N*/ void ScOutputData::FindRotated()
/*N*/ {
/*N*/ 	//!	nRotMax speichern
/*N*/ 	USHORT nRotMax = nX2;
/*N*/ 	for (USHORT nRotY=0; nRotY<nArrCount; nRotY++)
/*N*/ 		if (pRowInfo[nRotY].nRotMaxCol != SC_ROTMAX_NONE && pRowInfo[nRotY].nRotMaxCol > nRotMax)
/*N*/ 			nRotMax = pRowInfo[nRotY].nRotMaxCol;
/*N*/ 
/*N*/ 	for (USHORT nArrY=1; nArrY<nArrCount; nArrY++)
/*N*/ 	{
/*N*/ 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*N*/ 		if ( pThisRowInfo->nRotMaxCol != SC_ROTMAX_NONE &&
/*N*/ 			 ( pThisRowInfo->bChanged || pRowInfo[nArrY-1].bChanged ||
/*N*/ 			   ( nArrY+1<nArrCount && pRowInfo[nArrY+1].bChanged ) ) )
/*N*/ 		{
/*?*/ 			USHORT nY = pThisRowInfo->nRowNo;
/*?*/ 
/*?*/ 			for (USHORT nX=0; nX<=nRotMax; nX++)
/*?*/ 			{
/*?*/ 				CellInfo* pInfo = &pThisRowInfo->pCellInfo[nX+1];
/*?*/ 				const ScPatternAttr* pPattern = pInfo->pPatternAttr;
/*?*/ 				const SfxItemSet* pCondSet = pInfo->pConditionSet;
/*?*/ 
/*?*/ 				if ( !pPattern && (pDoc->GetColFlags(nX,nTab) & CR_HIDDEN) == 0 )
/*?*/ 				{
/*?*/ 					pPattern = pDoc->GetPattern( nX, nY, nTab );
/*?*/ 					pCondSet = pDoc->GetCondResult( nX, nY, nTab );
/*?*/ 				}
/*?*/ 
/*?*/ 				if ( pPattern )		// Spalte nicht ausgeblendet
/*?*/ 				{
/*?*/ 					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 BYTE nDir = pPattern->GetRotateDir( pCondSet );
//STRIP001 /*?*/ 					if (nDir != SC_ROTDIR_NONE)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						pInfo->nRotateDir = nDir;
//STRIP001 /*?*/ 						bAnyRotated = TRUE;
//STRIP001 /*?*/ 					}
/*?*/ 				}
/*?*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//	----------------------------------------------------------------------------

//STRIP001 USHORT lcl_GetRotateDir( ScDocument* pDoc, USHORT nCol, USHORT nRow, USHORT nTab )
//STRIP001 {
//STRIP001 	const ScPatternAttr* pPattern = pDoc->GetPattern( nCol, nRow, nTab );
//STRIP001 	const SfxItemSet* pCondSet = pDoc->GetCondResult( nCol, nRow, nTab );
//STRIP001 
//STRIP001 	USHORT nRet = SC_ROTDIR_NONE;
//STRIP001 
//STRIP001 	long nAttrRotate = pPattern->GetRotateVal( pCondSet );
//STRIP001 	if ( nAttrRotate )
//STRIP001 	{
//STRIP001 		SvxRotateMode eRotMode = (SvxRotateMode)((const SvxRotateModeItem&)
//STRIP001 					pPattern->GetItem(ATTR_ROTATE_MODE, pCondSet)).GetValue();
//STRIP001 
//STRIP001 		if ( eRotMode == SVX_ROTATE_MODE_STANDARD )
//STRIP001 			nRet = SC_ROTDIR_STANDARD;
//STRIP001 		else if ( eRotMode == SVX_ROTATE_MODE_CENTER )
//STRIP001 			nRet = SC_ROTDIR_CENTER;
//STRIP001 		else if ( eRotMode == SVX_ROTATE_MODE_TOP || eRotMode == SVX_ROTATE_MODE_BOTTOM )
//STRIP001 		{
//STRIP001 			long nRot180 = nAttrRotate % 18000;		// 1/100 Grad
//STRIP001 			if ( nRot180 == 9000 )
//STRIP001 				nRet = SC_ROTDIR_CENTER;
//STRIP001 			else if ( ( eRotMode == SVX_ROTATE_MODE_TOP && nRot180 < 9000 ) ||
//STRIP001 					  ( eRotMode == SVX_ROTATE_MODE_BOTTOM && nRot180 > 9000 ) )
//STRIP001 				nRet = SC_ROTDIR_LEFT;
//STRIP001 			else
//STRIP001 				nRet = SC_ROTDIR_RIGHT;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }

//STRIP001 const SvxBrushItem* lcl_FindBackground( ScDocument* pDoc, USHORT nCol, USHORT nRow, USHORT nTab )
//STRIP001 {
//STRIP001 	const ScPatternAttr* pPattern = pDoc->GetPattern( nCol, nRow, nTab );
//STRIP001 	const SfxItemSet* pCondSet = pDoc->GetCondResult( nCol, nRow, nTab );
//STRIP001 	const SvxBrushItem* pBackground = (const SvxBrushItem*)
//STRIP001 							&pPattern->GetItem( ATTR_BACKGROUND, pCondSet );
//STRIP001 
//STRIP001 	USHORT nDir = lcl_GetRotateDir( pDoc, nCol, nRow, nTab );
//STRIP001 
//STRIP001 	//	CENTER wird wie RIGHT behandelt...
//STRIP001 	if ( nDir == SC_ROTDIR_RIGHT || nDir == SC_ROTDIR_CENTER )
//STRIP001 	{
//STRIP001 		//	Text geht nach rechts -> Hintergrund von links nehmen
//STRIP001 		while ( nCol > 0 && lcl_GetRotateDir( pDoc, nCol, nRow, nTab ) == nDir &&
//STRIP001 							pBackground->GetColor().GetTransparency() != 255 )
//STRIP001 		{
//STRIP001 			--nCol;
//STRIP001 			pPattern = pDoc->GetPattern( nCol, nRow, nTab );
//STRIP001 			pCondSet = pDoc->GetCondResult( nCol, nRow, nTab );
//STRIP001 			pBackground = (const SvxBrushItem*)&pPattern->GetItem( ATTR_BACKGROUND, pCondSet );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( nDir == SC_ROTDIR_LEFT )
//STRIP001 	{
//STRIP001 		//	Text geht nach links -> Hintergrund von rechts nehmen
//STRIP001 		while ( nCol < MAXCOL && lcl_GetRotateDir( pDoc, nCol, nRow, nTab ) == nDir &&
//STRIP001 							pBackground->GetColor().GetTransparency() != 255 )
//STRIP001 		{
//STRIP001 			++nCol;
//STRIP001 			pPattern = pDoc->GetPattern( nCol, nRow, nTab );
//STRIP001 			pCondSet = pDoc->GetCondResult( nCol, nRow, nTab );
//STRIP001 			pBackground = (const SvxBrushItem*)&pPattern->GetItem( ATTR_BACKGROUND, pCondSet );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return pBackground;
//STRIP001 }

//	----------------------------------------------------------------------------

//STRIP001 BOOL lcl_EqualBack( const RowInfo& rFirst, const RowInfo& rOther,
//STRIP001 					USHORT nX1, USHORT nX2, BOOL bShowProt, BOOL bPagebreakMode )
//STRIP001 {
//STRIP001 	if ( rFirst.bChanged   != rOther.bChanged ||
//STRIP001 		 rFirst.bEmptyBack != rOther.bEmptyBack )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	USHORT nX;
//STRIP001 	if ( bShowProt )
//STRIP001 	{
//STRIP001 		for ( nX=nX1; nX<=nX2; nX++ )
//STRIP001 		{
//STRIP001 			const ScPatternAttr* pPat1 = rFirst.pCellInfo[nX+1].pPatternAttr;
//STRIP001 			const ScPatternAttr* pPat2 = rOther.pCellInfo[nX+1].pPatternAttr;
//STRIP001 			if ( !pPat1 || !pPat2 ||
//STRIP001 					&pPat1->GetItem(ATTR_PROTECTION) != &pPat2->GetItem(ATTR_PROTECTION) )
//STRIP001 				return FALSE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		for ( nX=nX1; nX<=nX2; nX++ )
//STRIP001 			if ( rFirst.pCellInfo[nX+1].pBackground != rOther.pCellInfo[nX+1].pBackground )
//STRIP001 				return FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( rFirst.nRotMaxCol != SC_ROTMAX_NONE || rOther.nRotMaxCol != SC_ROTMAX_NONE )
//STRIP001 		for ( nX=nX1; nX<=nX2; nX++ )
//STRIP001 			if ( rFirst.pCellInfo[nX+1].nRotateDir != rOther.pCellInfo[nX+1].nRotateDir )
//STRIP001 				return FALSE;
//STRIP001 
//STRIP001 	if ( bPagebreakMode )
//STRIP001 		for ( nX=nX1; nX<=nX2; nX++ )
//STRIP001 			if ( rFirst.pCellInfo[nX+1].bPrinted != rOther.pCellInfo[nX+1].bPrinted )
//STRIP001 				return FALSE;
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

/*N*/ void ScOutputData::DrawBackground()
/*N*/ {
/*N*/ 	FindRotated();				//! von aussen ?
/*N*/ 
/*N*/ 	ScModule* pScMod = SC_MOD();
/*N*/ 
/*N*/ 	// used only if bSolidBackground is set (only for ScGridWindow):
/*N*/     Color aBgColor( pScMod->GetColorConfig().GetColorValue(svtools::DOCCOLOR).nColor );
/*N*/ 
/*N*/ 	Rectangle aRect;
/*N*/ 	Size aOnePixel = pDev->PixelToLogic(Size(1,1));
/*N*/ 	long nOneX = aOnePixel.Width();
/*N*/ 	long nOneY = aOnePixel.Height();
/*N*/ 
/*N*/ 	if (bMetaFile)
/*N*/ 		nOneX = nOneY = 0;
/*N*/ 
/*N*/ 	pDev->SetLineColor();
/*N*/ 
/*N*/ 	BOOL bShowProt = bSyntaxMode && pDoc->IsTabProtected(nTab);
/*N*/ 	BOOL bDoAll = bShowProt || bPagebreakMode || bSolidBackground;
/*N*/ 
/*N*/ 	//	#105733# SvtAccessibilityOptions::GetIsForBorders is no longer used (always assumed TRUE)
/*N*/ 	BOOL bCellContrast = bUseStyleColor &&
/*N*/ 			Application::GetSettings().GetStyleSettings().GetHighContrastMode();
/*N*/ 
/*N*/ 	long nPosY = nScrY;
/*N*/ 	for (USHORT nArrY=1; nArrY+1<nArrCount; nArrY++)
/*N*/ 	{
/*N*/ 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*N*/ 		long nRowHeight = pThisRowInfo->nHeight;
/*N*/ 
/*N*/ 		if ( pThisRowInfo->bChanged )
/*N*/ 		{
/*?*/ 			if ( ( ( pThisRowInfo->bEmptyBack ) || bSyntaxMode ) && !bDoAll )
/*?*/ 			{
/*?*/ 				//	nichts
/*?*/ 			}
/*?*/ 			else
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 				// scan for rows with the same background:
//STRIP001 /*?*/ 				USHORT nSkip = 0;
//STRIP001 /*?*/ 				while ( nArrY+nSkip+2<nArrCount &&
//STRIP001 /*?*/ 						lcl_EqualBack( *pThisRowInfo, pRowInfo[nArrY+nSkip+1],
//STRIP001 /*?*/ 										nX1, nX2, bShowProt, bPagebreakMode ) )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					++nSkip;
//STRIP001 /*?*/ 					nRowHeight += pRowInfo[nArrY+nSkip].nHeight;	// after incrementing
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				long nPosX = nScrX;
//STRIP001 /*?*/ 				aRect = Rectangle( nPosX,nPosY, nPosX,nPosY+nRowHeight-nOneY );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				const SvxBrushItem* pOldBackground = NULL;
//STRIP001 /*?*/ 				const SvxBrushItem* pBackground;
//STRIP001 /*?*/ 				for (USHORT nX=nX1; nX<=nX2; nX++)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					CellInfo* pInfo = &pThisRowInfo->pCellInfo[nX+1];
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if (bCellContrast)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						//	high contrast for cell borders and backgrounds -> empty background
//STRIP001 /*?*/ 						pBackground = ScGlobal::GetEmptyBrushItem();
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					else if (bShowProt)			// show cell protection in syntax mode
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						const ScPatternAttr* pP = pInfo->pPatternAttr;
//STRIP001 /*?*/ 						if (pP)
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							const ScProtectionAttr& rProt = (const ScProtectionAttr&)
//STRIP001 /*?*/ 																pP->GetItem(ATTR_PROTECTION);
//STRIP001 /*?*/ 							if (rProt.GetProtection() || rProt.GetHideCell())
//STRIP001 /*?*/ 								pBackground = ScGlobal::GetProtectedBrushItem();
//STRIP001 /*?*/ 							else
//STRIP001 /*?*/ 								pBackground = ScGlobal::GetEmptyBrushItem();
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 						else
//STRIP001 /*?*/ 							pBackground = NULL;
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 						pBackground = pInfo->pBackground;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if ( bPagebreakMode && !pInfo->bPrinted )
//STRIP001 /*?*/ 						pBackground = ScGlobal::GetProtectedBrushItem();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if ( pInfo->nRotateDir > SC_ROTDIR_STANDARD &&
//STRIP001 /*?*/ 							pBackground->GetColor().GetTransparency() != 255 &&
//STRIP001 /*?*/ 							!bCellContrast )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						USHORT nY = pRowInfo[nArrY].nRowNo;
//STRIP001 /*?*/ 						pBackground = lcl_FindBackground( pDoc, nX, nY, nTab );
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if ( pBackground != pOldBackground )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						aRect.Right() = nPosX-nOneX;
//STRIP001 /*?*/ 						if (pOldBackground)				// ==0 if hidden
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							Color aBackCol = pOldBackground->GetColor();
//STRIP001 /*?*/ 							if ( bSolidBackground && aBackCol.GetTransparency() )
//STRIP001 /*?*/ 								aBackCol = aBgColor;
//STRIP001 /*?*/ 							if ( !aBackCol.GetTransparency() )		//! partial transparency?
//STRIP001 /*?*/ 							{
//STRIP001 /*?*/ 								pDev->SetFillColor( aBackCol );
//STRIP001 /*?*/ 								pDev->DrawRect( aRect );
//STRIP001 /*?*/ 							}
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 						aRect.Left() = nPosX;
//STRIP001 /*?*/ 						pOldBackground = pBackground;
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					nPosX += pRowInfo[0].pCellInfo[nX+1].nWidth;
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				aRect.Right() = nPosX-nOneX;
//STRIP001 /*?*/ 				if (pOldBackground)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					Color aBackCol = pOldBackground->GetColor();
//STRIP001 /*?*/ 					if ( bSolidBackground && aBackCol.GetTransparency() )
//STRIP001 /*?*/ 						aBackCol = aBgColor;
//STRIP001 /*?*/ 					if ( !aBackCol.GetTransparency() )		//! partial transparency?
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						pDev->SetFillColor( aBackCol );
//STRIP001 /*?*/ 						pDev->DrawRect( aRect );
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				nArrY += nSkip;
/*?*/ 			}
/*N*/ 		}
/*N*/ 		nPosY += nRowHeight;
/*N*/ 	}
/*N*/ }

/*N*/ void ScOutputData::DrawShadow()
/*N*/ {
/*N*/ 	pDev->SetLineColor();
/*N*/ 
/*N*/ 	const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
	//	#105733# SvtAccessibilityOptions::GetIsForBorders is no longer used (always assumed TRUE)
/*N*/ 	BOOL bCellContrast = bUseStyleColor && rStyleSettings.GetHighContrastMode();
/*N*/ 	Color aAutoTextColor;
/*N*/ 	if ( bCellContrast )
/*?*/         aAutoTextColor.SetColor( SC_MOD()->GetColorConfig().GetColorValue(svtools::FONTCOLOR).nColor );
/*N*/ 
/*N*/ 	long nPosY = nScrY;
/*N*/ 	for (USHORT nArrY=1; nArrY+1<nArrCount; nArrY++)
/*N*/ 	{
/*N*/ 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*N*/ 		long nRowHeight = pThisRowInfo->nHeight;
/*N*/ 
/*N*/ 		if ( pThisRowInfo->bChanged )
/*N*/ 		{
/*?*/ 			long nPosX = nScrX;
/*?*/ 
/*?*/ 			for (USHORT nX=nX1; nX<=nX2; nX++)
/*?*/ 			{
/*?*/ 				for (USHORT nPass=0; nPass<2; nPass++)			// horizontal / vertikal
/*?*/ 				{
/*?*/ 					const SvxShadowItem* pAttr = nPass ?
/*?*/ 							pThisRowInfo->pCellInfo[nX+1].pVShadowOrigin :
/*?*/ 							pThisRowInfo->pCellInfo[nX+1].pHShadowOrigin;
/*?*/ 					if (pAttr)
/*?*/ 					{
/*?*/ 						ScShadowPart ePart = nPass ?
/*?*/ 								pThisRowInfo->pCellInfo[nX+1].eVShadowPart :
/*?*/ 								pThisRowInfo->pCellInfo[nX+1].eHShadowPart;
/*?*/ 
/*?*/ 						long nMaxWidth = pRowInfo[0].pCellInfo[nX+1].nWidth;
/*?*/ 						if (!nMaxWidth)
/*?*/ 						{
/*?*/ 							USHORT nWx = nX+1;
/*?*/ 							while (!pRowInfo[0].pCellInfo[nWx+1].nWidth && nWx<nX2)
/*?*/ 								++nWx;
/*?*/ 							nMaxWidth = pRowInfo[0].pCellInfo[nWx+1].nWidth;
/*?*/ 						}
/*?*/ 
/*?*/ 						Rectangle aRect( Point(nPosX,nPosY),
/*?*/ 										 Size( pRowInfo[0].pCellInfo[nX+1].nWidth,
/*?*/ 												pRowInfo[nArrY].nHeight ) );
/*?*/ 
/*?*/ 						long nSize = pAttr->GetWidth();
/*?*/ 						long nSizeX = (long)(nSize*nPPTX);
/*?*/ 						if (nSizeX >= nMaxWidth) nSizeX = nMaxWidth-1;
/*?*/ 						long nSizeY = (long)(nSize*nPPTY);
/*?*/ 						if (nSizeY >= nRowHeight) nSizeY = nRowHeight-1;
/*?*/ 
/*?*/ 						SvxShadowLocation eLoc = pAttr->GetLocation();
/*?*/ 
/*?*/ 						if (ePart == SC_SHADOW_HORIZ || ePart == SC_SHADOW_HSTART ||
/*?*/ 							ePart == SC_SHADOW_CORNER)
/*?*/ 						{
/*?*/ 							if (eLoc == SVX_SHADOW_TOPLEFT || eLoc == SVX_SHADOW_TOPRIGHT)
/*?*/ 								aRect.Top() = aRect.Bottom() - nSizeY;
/*?*/ 							else
/*?*/ 								aRect.Bottom() = aRect.Top() + nSizeY;
/*?*/ 						}
/*?*/ 						if (ePart == SC_SHADOW_VERT || ePart == SC_SHADOW_VSTART ||
/*?*/ 							ePart == SC_SHADOW_CORNER)
/*?*/ 						{
/*?*/ 							if (eLoc == SVX_SHADOW_TOPLEFT || eLoc == SVX_SHADOW_BOTTOMLEFT)
/*?*/ 								aRect.Left() = aRect.Right() - nSizeX;
/*?*/ 							else
/*?*/ 								aRect.Right() = aRect.Left() + nSizeX;
/*?*/ 						}
/*?*/ 						if (ePart == SC_SHADOW_HSTART)
/*?*/ 						{
/*?*/ 							if (eLoc == SVX_SHADOW_TOPLEFT || eLoc == SVX_SHADOW_BOTTOMLEFT)
/*?*/ 								aRect.Right() -= nSizeX;
/*?*/ 							else
/*?*/ 								aRect.Left() += nSizeX;
/*?*/ 						}
/*?*/ 						if (ePart == SC_SHADOW_VSTART)
/*?*/ 						{
/*?*/ 							if (eLoc == SVX_SHADOW_TOPLEFT || eLoc == SVX_SHADOW_TOPRIGHT)
/*?*/ 								aRect.Bottom() -= nSizeY;
/*?*/ 							else
/*?*/ 								aRect.Top() += nSizeY;
/*?*/ 						}
/*?*/ 
/*?*/ 						//! merge rectangles?
/*?*/ 						pDev->SetFillColor( bCellContrast ? aAutoTextColor : pAttr->GetColor() );
/*?*/ 						pDev->DrawRect( aRect );
/*?*/ 					}
/*?*/ 				}
/*?*/ 
/*?*/ 				nPosX += pRowInfo[0].pCellInfo[nX+1].nWidth;
/*?*/ 			}
/*N*/ 		}
/*N*/ 		nPosY += nRowHeight;
/*N*/ 	}
/*N*/ }

//STRIP001 void ScOutputData::DrawExtraShadow(BOOL bLeft, BOOL bTop, BOOL bRight, BOOL bBottom)
//STRIP001 {
//STRIP001 	//	DrawExtraShadow enthaelt DrawShadow
//STRIP001 	//!	DrawShadow weglassen, stattdessen DrawExtraShadow(FALSE,FALSE,FALSE,FALSE) ???
//STRIP001 
//STRIP001 	pDev->SetLineColor();
//STRIP001 
//STRIP001 	const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
//STRIP001 	//	#105733# SvtAccessibilityOptions::GetIsForBorders is no longer used (always assumed TRUE)
//STRIP001 	BOOL bCellContrast = bUseStyleColor && rStyleSettings.GetHighContrastMode();
//STRIP001 	Color aAutoTextColor;
//STRIP001 	if ( bCellContrast )
//STRIP001         aAutoTextColor.SetColor( SC_MOD()->GetColorConfig().GetColorValue(svtools::FONTCOLOR).nColor );
//STRIP001 
//STRIP001 	long nPosY = nScrY - pRowInfo[0].nHeight;
//STRIP001 	for (USHORT nArrY=0; nArrY<nArrCount; nArrY++)
//STRIP001 	{
//STRIP001 		BOOL bCornerY = ( nArrY == 0 ) || ( nArrY+1 == nArrCount );
//STRIP001 		BOOL bSkipY = ( nArrY==0 && !bTop ) || ( nArrY+1 == nArrCount && !bBottom );
//STRIP001 
//STRIP001 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
//STRIP001 		long nRowHeight = pThisRowInfo->nHeight;
//STRIP001 
//STRIP001 		if ( pThisRowInfo->bChanged && !bSkipY )
//STRIP001 		{
//STRIP001 			long nPosX = nScrX - pRowInfo[0].pCellInfo[nX1].nWidth;
//STRIP001 			for (USHORT nArrX=nX1; nArrX<=nX2+2; nArrX++)
//STRIP001 			{
//STRIP001 				BOOL bCornerX = ( nArrX==nX1 || nArrX==nX2+2 );
//STRIP001 				BOOL bSkipX = ( nArrX==nX1 && !bLeft ) || ( nArrX==nX2+2 && !bRight );
//STRIP001 
//STRIP001 				for (USHORT nPass=0; nPass<2; nPass++)			// horizontal / vertikal
//STRIP001 				{
//STRIP001 					const SvxShadowItem* pAttr = nPass ?
//STRIP001 							pThisRowInfo->pCellInfo[nArrX].pVShadowOrigin :
//STRIP001 							pThisRowInfo->pCellInfo[nArrX].pHShadowOrigin;
//STRIP001 					if ( pAttr && !bSkipX )
//STRIP001 					{
//STRIP001 						ScShadowPart ePart = nPass ?
//STRIP001 								pThisRowInfo->pCellInfo[nArrX].eVShadowPart :
//STRIP001 								pThisRowInfo->pCellInfo[nArrX].eHShadowPart;
//STRIP001 
//STRIP001 						BOOL bDo = TRUE;
//STRIP001 						if ( (nPass==0 && bCornerX) || (nPass==1 && bCornerY) )
//STRIP001 							if ( ePart != SC_SHADOW_CORNER )
//STRIP001 								bDo = FALSE;
//STRIP001 
//STRIP001 						if (bDo)
//STRIP001 						{
//STRIP001 							long nMaxWidth = pRowInfo[0].pCellInfo[nArrX].nWidth;
//STRIP001 							if (!nMaxWidth)
//STRIP001 							{
//STRIP001 								USHORT nWx = nArrX;		// nX+1
//STRIP001 								while (nWx<nX2 && !pRowInfo[0].pCellInfo[nWx+1].nWidth)
//STRIP001 									++nWx;
//STRIP001 								nMaxWidth = pRowInfo[0].pCellInfo[nWx+1].nWidth;
//STRIP001 							}
//STRIP001 
//STRIP001 							Rectangle aRect( Point(nPosX,nPosY),
//STRIP001 											 Size( pRowInfo[0].pCellInfo[nArrX].nWidth,
//STRIP001 													pRowInfo[nArrY].nHeight ) );
//STRIP001 
//STRIP001 							long nSize = pAttr->GetWidth();
//STRIP001 							long nSizeX = (long)(nSize*nPPTX);
//STRIP001 							if (nSizeX >= nMaxWidth) nSizeX = nMaxWidth-1;
//STRIP001 							long nSizeY = (long)(nSize*nPPTY);
//STRIP001 							if (nSizeY >= nRowHeight) nSizeY = nRowHeight-1;
//STRIP001 
//STRIP001 							SvxShadowLocation eLoc = pAttr->GetLocation();
//STRIP001 
//STRIP001 							if (ePart == SC_SHADOW_HORIZ || ePart == SC_SHADOW_HSTART ||
//STRIP001 								ePart == SC_SHADOW_CORNER)
//STRIP001 							{
//STRIP001 								if (eLoc == SVX_SHADOW_TOPLEFT || eLoc == SVX_SHADOW_TOPRIGHT)
//STRIP001 									aRect.Top() = aRect.Bottom() - nSizeY;
//STRIP001 								else
//STRIP001 									aRect.Bottom() = aRect.Top() + nSizeY;
//STRIP001 							}
//STRIP001 							if (ePart == SC_SHADOW_VERT || ePart == SC_SHADOW_VSTART ||
//STRIP001 								ePart == SC_SHADOW_CORNER)
//STRIP001 							{
//STRIP001 								if (eLoc == SVX_SHADOW_TOPLEFT || eLoc == SVX_SHADOW_BOTTOMLEFT)
//STRIP001 									aRect.Left() = aRect.Right() - nSizeX;
//STRIP001 								else
//STRIP001 									aRect.Right() = aRect.Left() + nSizeX;
//STRIP001 							}
//STRIP001 							if (ePart == SC_SHADOW_HSTART)
//STRIP001 							{
//STRIP001 								if (eLoc == SVX_SHADOW_TOPLEFT || eLoc == SVX_SHADOW_BOTTOMLEFT)
//STRIP001 									aRect.Right() -= nSizeX;
//STRIP001 								else
//STRIP001 									aRect.Left() += nSizeX;
//STRIP001 							}
//STRIP001 							if (ePart == SC_SHADOW_VSTART)
//STRIP001 							{
//STRIP001 								if (eLoc == SVX_SHADOW_TOPLEFT || eLoc == SVX_SHADOW_TOPRIGHT)
//STRIP001 									aRect.Bottom() -= nSizeY;
//STRIP001 								else
//STRIP001 									aRect.Top() += nSizeY;
//STRIP001 							}
//STRIP001 
//STRIP001 							//! merge rectangles?
//STRIP001 							pDev->SetFillColor( bCellContrast ? aAutoTextColor : pAttr->GetColor() );
//STRIP001 							pDev->DrawRect( aRect );
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				nPosX += pRowInfo[0].pCellInfo[nArrX].nWidth;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		nPosY += nRowHeight;
//STRIP001 	}
//STRIP001 }

//
//	Loeschen
//

//STRIP001 void ScOutputData::DrawClear()
//STRIP001 {
//STRIP001 	Rectangle aRect;
//STRIP001 	Size aOnePixel = pDev->PixelToLogic(Size(1,1));
//STRIP001 	long nOneX = aOnePixel.Width();
//STRIP001 	long nOneY = aOnePixel.Height();
//STRIP001 
//STRIP001 	// (called only for ScGridWindow)
//STRIP001     Color aBgColor( SC_MOD()->GetColorConfig().GetColorValue(svtools::DOCCOLOR).nColor );
//STRIP001 
//STRIP001 	if (bMetaFile)
//STRIP001 		nOneX = nOneY = 0;
//STRIP001 
//STRIP001 	pDev->SetLineColor();
//STRIP001 
//STRIP001 	pDev->SetFillColor( aBgColor );
//STRIP001 
//STRIP001 	long nPosY = nScrY;
//STRIP001 	for (USHORT nArrY=1; nArrY+1<nArrCount; nArrY++)
//STRIP001 	{
//STRIP001 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
//STRIP001 		long nRowHeight = pThisRowInfo->nHeight;
//STRIP001 
//STRIP001 		if ( pThisRowInfo->bChanged )
//STRIP001 		{
//STRIP001 			// scan for more rows which must be painted:
//STRIP001 			USHORT nSkip = 0;
//STRIP001 			while ( nArrY+nSkip+2<nArrCount && pRowInfo[nArrY+nSkip+1].bChanged )
//STRIP001 			{
//STRIP001 				++nSkip;
//STRIP001 				nRowHeight += pRowInfo[nArrY+nSkip].nHeight;	// after incrementing
//STRIP001 			}
//STRIP001 
//STRIP001 			aRect = Rectangle( Point( nScrX, nPosY ),
//STRIP001 					Size( nScrW+1-nOneX, nRowHeight+1-nOneY) );
//STRIP001 			pDev->DrawRect( aRect );
//STRIP001 
//STRIP001 			nArrY += nSkip;
//STRIP001 		}
//STRIP001 		nPosY += nRowHeight;
//STRIP001 	}
//STRIP001 }


//
//	Linien
//

//STRIP001 void lcl_SnapPixelX( OutputDevice* pDev, long& rValue )
//STRIP001 {
//STRIP001 	if (rValue)
//STRIP001 	{
//STRIP001 		Size aSize = pDev->LogicToPixel(Size(rValue,0));
//STRIP001 		rValue = pDev->PixelToLogic(aSize).Width();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void lcl_SnapPixelY( OutputDevice* pDev, long& rValue )
//STRIP001 {
//STRIP001 	if (rValue)
//STRIP001 	{
//STRIP001 		Size aSize = pDev->LogicToPixel(Size(0,rValue));
//STRIP001 		rValue = pDev->PixelToLogic(aSize).Height();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 inline short MultOne( short nVal, double nScale )
//STRIP001 {
//STRIP001 	return nVal ? Max((short)1, (short)(nVal*nScale)) : 0;
//STRIP001 }
//STRIP001 
//STRIP001 inline void GetLineStruct( ScLineStruct& rLine, const SvxBorderLine* pAttr, double nScale )
//STRIP001 {
//STRIP001 	if (pAttr)
//STRIP001 	{
//STRIP001 		rLine.nLeft		= MultOne(pAttr->GetOutWidth(), nScale);
//STRIP001 		rLine.nMiddle	= MultOne(pAttr->GetDistance(), nScale);
//STRIP001 		rLine.nRight	= MultOne(pAttr->GetInWidth(), nScale);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		rLine.nLeft		= 0;
//STRIP001 		rLine.nMiddle	= 0;
//STRIP001 		rLine.nRight	= 0;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 inline void SwapLineStruct( ScLineStruct& rLine )
//STRIP001 {
//STRIP001 	if ( rLine.nRight )
//STRIP001 	{
//STRIP001 		short nTemp = rLine.nRight;
//STRIP001 		rLine.nRight = rLine.nLeft;
//STRIP001 		rLine.nLeft = nTemp;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 inline void UpdateOldRectHor( OutputDevice* pDev, Rectangle& rOldRect, BOOL& rOldValid,
//STRIP001 								long nStartX, long nStartY, long nEndX, long nEndY )
//STRIP001 {
//STRIP001 	if ( rOldValid )
//STRIP001 	{
//STRIP001 		if ( nStartY != rOldRect.Top() || nEndY != rOldRect.Bottom() ||
//STRIP001 			 nStartX > rOldRect.Right()+1 )
//STRIP001 		{
//STRIP001 			pDev->DrawRect( rOldRect );
//STRIP001 			rOldValid = FALSE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !rOldValid )
//STRIP001 	{
//STRIP001 		rOldRect.Left()   = nStartX;
//STRIP001 		rOldRect.Top()	  = nStartY;
//STRIP001 		rOldRect.Bottom() = nEndY;
//STRIP001 		rOldValid = TRUE;
//STRIP001 	}
//STRIP001 	rOldRect.Right() = nEndX;
//STRIP001 }
//STRIP001 
//STRIP001 inline void UpdateOldRectVer( OutputDevice* pDev, Rectangle& rOldRect, BOOL& rOldValid,
//STRIP001 								long nStartX, long nStartY, long nEndX, long nEndY )
//STRIP001 {
//STRIP001 	if ( rOldValid )
//STRIP001 	{
//STRIP001 		if ( nStartX != rOldRect.Left() || nEndX != rOldRect.Right() ||
//STRIP001 			 nStartY > rOldRect.Bottom()+1 )
//STRIP001 		{
//STRIP001 			pDev->DrawRect( rOldRect );
//STRIP001 			rOldValid = FALSE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !rOldValid )
//STRIP001 	{
//STRIP001 		rOldRect.Top()	  = nStartY;
//STRIP001 		rOldRect.Left()	  = nStartX;
//STRIP001 		rOldRect.Right()  = nEndX;
//STRIP001 		rOldValid = TRUE;
//STRIP001 	}
//STRIP001 	rOldRect.Bottom() = nEndY;
//STRIP001 }
//STRIP001 
inline void FinishOldRect( OutputDevice* pDev, Rectangle& rOldRect, BOOL& rOldValid )
{
	if ( rOldValid )
	{
		pDev->DrawRect( rOldRect );
 		rOldValid = FALSE;
 	}
}

/*N*/ void ScOutputData::DrawFrame()
/*N*/ {
/*N*/ 	ULONG nOldDrawMode = pDev->GetDrawMode();
/*N*/ 
/*N*/ 	Color aSingleColor;
/*N*/ 	BOOL bUseSingleColor = FALSE;
/*N*/ 	const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
/*N*/ 	//	#105733# SvtAccessibilityOptions::GetIsForBorders is no longer used (always assumed TRUE)
/*N*/ 	BOOL bCellContrast = bUseStyleColor && rStyleSettings.GetHighContrastMode();
/*N*/ 
/*N*/ 	//	#107519# if a Calc OLE object is embedded in Draw/Impress, the VCL DrawMode is used
/*N*/ 	//	for display mode / B&W printing. The VCL DrawMode handling doesn't work for lines
/*N*/ 	//	that are drawn with DrawRect, so if the line/background bits are set, the DrawMode
/*N*/ 	//	must be reset and the border colors handled here.
/*N*/ 	//	(Similar to fix for #72796# in SdrObject::ImpDrawLineGeometry)
/*N*/ 
/*N*/ 	if ( ( nOldDrawMode & DRAWMODE_WHITEFILL ) && ( nOldDrawMode & DRAWMODE_BLACKLINE ) )
/*N*/ 	{
/*?*/ 		pDev->SetDrawMode( nOldDrawMode & (~DRAWMODE_WHITEFILL) );
/*?*/ 		aSingleColor.SetColor( COL_BLACK );
/*?*/ 		bUseSingleColor = TRUE;
/*N*/ 	}
/*N*/ 	else if ( ( nOldDrawMode & DRAWMODE_SETTINGSFILL ) && ( nOldDrawMode & DRAWMODE_SETTINGSLINE ) )
/*N*/ 	{
/*?*/ 		pDev->SetDrawMode( nOldDrawMode & (~DRAWMODE_SETTINGSFILL) );
/*?*/ 		aSingleColor = rStyleSettings.GetWindowTextColor();		// same as used in VCL for DRAWMODE_SETTINGSLINE
/*?*/ 		bUseSingleColor = TRUE;
/*N*/ 	}
/*N*/ 	else if ( bCellContrast )
/*N*/ 	{
/*?*/ 		aSingleColor.SetColor( SC_MOD()->GetColorConfig().GetColorValue(svtools::FONTCOLOR).nColor );
/*?*/ 		bUseSingleColor = TRUE;
/*N*/ 	}
/*N*/ 
/*N*/ 	if (bAnyRotated)
/*N*/ 	{
/*?*/ 		const Color* pForceColor = NULL;
/*?*/ 		if ( bUseSingleColor )
/*?*/ 			pForceColor = &aSingleColor;
/*?*/ 		DrawRotatedFrame( pForceColor );		// removes the lines that must not be painted here
/*N*/ 	}
/*N*/ 
/*N*/ 	USHORT nArrY;
/*N*/ 	USHORT nArrX;
/*N*/ 
/*N*/ 	long nPosX;
/*N*/ 	long nPosY;
/*N*/ 
/*N*/ 	short nFirstSize;
/*N*/ 	short nSpaceSize;
/*N*/ 	short nSecondSize;
/*N*/ 
/*N*/ 	long nDrawX;
/*N*/ 	long nDrawY;
/*N*/ 	long nDrawStartX;
/*N*/ 	long nDrawStartY;
/*N*/ 	long nDrawEndX;
/*N*/ 	long nDrawEndY;
/*N*/ 
/*N*/ 	const SvxBorderLine* pDrawLine;
/*N*/ 	const SvxBorderLine* pOldLine = NULL;
/*N*/ 
/*N*/ 	Color aOldCol( COL_BLACK );
/*N*/ 
/*N*/ 	short nLinkRes[4];
/*N*/ 	ScLineStruct aDrawLine;
/*N*/ 	ScLineStruct aLineLT;
/*N*/ 	ScLineStruct aLineLB;
/*N*/ 	ScLineStruct aLineRT;
/*N*/ 	ScLineStruct aLineRB;
/*N*/ 	ScLineStruct aLineL;
/*N*/ 	ScLineStruct aLineR;
/*N*/ 
/*N*/ 	//	Dummy-Initialisierung
/*N*/ 	aDrawLine.nLeft   = 0;
/*N*/ 	aDrawLine.nMiddle = 0;
/*N*/ 	aDrawLine.nRight  = 0;
/*N*/ 	aLineLT = aDrawLine;
/*N*/ 	aLineLB = aDrawLine;
/*N*/ 	aLineRT = aDrawLine;
/*N*/ 	aLineRB = aDrawLine;
/*N*/ 	aLineL = aDrawLine;
/*N*/ 	aLineR = aDrawLine;
/*N*/ 
/*N*/ 	BOOL bIsLine;
/*N*/ 	BOOL bWasLine;
/*N*/ 
/*N*/ 	BOOL bOldValid = FALSE;								// Rechtecke zusammenfassen
/*N*/ 	Rectangle aOldRect;
/*N*/ 	BOOL bOldValid2 = FALSE;							// zweite Linien
/*N*/ 	Rectangle aOldRect2;
/*N*/ 
/*N*/ 	pDev->SetLineColor();
/*N*/ 	pDev->SetFillColor( aOldCol );
/*N*/ 
/*N*/ 				//
/*N*/ 				//			Horizontale Linien
/*N*/ 				//
/*N*/ 
/*N*/ 	nPosY = nScrY - 1;
/*N*/ 	for (nArrY=0; nArrY+1<nArrCount; nArrY++)			// einer vorher
/*N*/ 	{
/*N*/ 		if (nArrY>0)									// "nullte Zeile" ganz oben
/*N*/ 			nPosY += pRowInfo[nArrY].nHeight;
/*N*/ 
/*N*/ 		long nSnapPosY = nPosY;
/*N*/ 		if (bSnapPixel)
				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*N*/ 			lcl_SnapPixelY(pDev,nSnapPosY);
/*N*/ 
/*N*/ 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*N*/ 		if ( pThisRowInfo->bChanged || pRowInfo[nArrY+1].bChanged )
/*N*/ 		{
/*N*/ 			bWasLine = FALSE;
/*N*/ 			nPosX = nScrX - 1;
/*N*/ 
/*N*/ 			for (USHORT nX=nX1; nX<=nX2; nX++)
/*N*/ 			{
/*N*/ 				bIsLine = FALSE;
/*N*/ 				long nEndX = nPosX + pRowInfo[0].pCellInfo[nX+1].nWidth;
/*N*/ 
/*N*/ 				pDrawLine = pThisRowInfo->pCellInfo[nX+1].pBottomLine;
/*N*/ 				if ( pDrawLine )
/*N*/ 				{
/*N*/ 					if ( pDrawLine->GetOutWidth() )
/*N*/ 					{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*N*/ 						long nSnapPosX = nPosX;
//STRIP001 /*N*/ 						long nSnapEndX = nEndX;
//STRIP001 /*N*/ 						if (bSnapPixel)
//STRIP001 /*N*/ 						{
//STRIP001 /*N*/ 							lcl_SnapPixelX(pDev,nSnapPosX);
//STRIP001 /*N*/ 							lcl_SnapPixelX(pDev,nSnapEndX);
//STRIP001 /*N*/ 						}
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 						bIsLine = TRUE;
//STRIP001 /*N*/ 						if ( pDrawLine != pOldLine )
//STRIP001 /*N*/ 						{
//STRIP001 /*N*/ 							Color aColor( pDrawLine->GetColor() );
//STRIP001 							if ( bUseSingleColor )
//STRIP001 								aColor = aSingleColor;
//STRIP001 /*N*/ 							if ( aColor != aOldCol )
//STRIP001 /*N*/ 							{ 
//STRIP001 /*N*/ 								FinishOldRect( pDev, aOldRect, bOldValid );
//STRIP001 /*N*/ 								FinishOldRect( pDev, aOldRect2, bOldValid2 );
//STRIP001 /*N*/ 								pDev->SetFillColor( aColor );
//STRIP001 /*N*/ 								aOldCol = aColor;
//STRIP001 /*N*/ 							}
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 							nFirstSize = Max((short) 1, (short) ( pDrawLine->GetOutWidth() * nPPTY ));
//STRIP001 /*N*/ 							if ( pDrawLine->GetInWidth() )
//STRIP001 /*N*/ 							{
//STRIP001 /*N*/ 								nSpaceSize = Max((short) 1, (short) ( pDrawLine->GetDistance() * nPPTY ));
//STRIP001 /*N*/ 								nSecondSize = Max((short) 1, (short) ( pDrawLine->GetInWidth() * nPPTY ));
//STRIP001 /*N*/ 							}
//STRIP001 /*N*/ 							else
//STRIP001 /*N*/ 							{
//STRIP001 /*N*/ 								nSpaceSize = 0;
//STRIP001 /*N*/ 								nSecondSize = 0;
//STRIP001 /*N*/ 							}
//STRIP001 /*N*/ 						}
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 						nDrawY = nSnapPosY - (nFirstSize + nSpaceSize + nSecondSize - 1) / 2;
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 						// durchzeichnen ?
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 						if( (nX == 0) ? FALSE :
//STRIP001 /*N*/ 								 ( pRowInfo[nArrY].pCellInfo[nX].pBottomLine 	== pRowInfo[nArrY].pCellInfo[nX-1].pBottomLine
//STRIP001 /*N*/ 								&& pRowInfo[nArrY].pCellInfo[nX].pRightLine 	== pRowInfo[nArrY].pCellInfo[nX-1].pRightLine
//STRIP001 /*N*/ 								&& pRowInfo[nArrY].pCellInfo[nX+1].pBottomLine 	== pRowInfo[nArrY].pCellInfo[nX].pBottomLine
//STRIP001 /*N*/ 								&& pRowInfo[nArrY].pCellInfo[nX+1].pRightLine 	== pRowInfo[nArrY].pCellInfo[nX].pRightLine
//STRIP001 /*N*/ 								&& pRowInfo[nArrY].pCellInfo[nX+2].pBottomLine 	== pRowInfo[nArrY].pCellInfo[nX+1].pBottomLine
//STRIP001 /*N*/ 								&& pRowInfo[nArrY+1].pCellInfo[nX].pRightLine 	== pRowInfo[nArrY+1].pCellInfo[nX-1].pRightLine
//STRIP001 /*N*/ 								&& pRowInfo[nArrY+1].pCellInfo[nX+1].pRightLine == pRowInfo[nArrY+1].pCellInfo[nX].pRightLine
//STRIP001 /*N*/ 									) )
//STRIP001 /*N*/ 						{
//STRIP001 /*N*/ 							bIsLine = FALSE;					// Variablen ungueltig
//STRIP001 /*N*/ 							nDrawStartX	= nSnapPosX + nLinkRes[0];
//STRIP001 /*N*/ 							nDrawEndX	= nSnapEndX + nLinkRes[2];
//STRIP001 /*N*/ 						}
//STRIP001 /*N*/ 						else
//STRIP001 /*N*/ 						{
//STRIP001 /*N*/ 							if (bWasLine)						// Vorgaenger gueltig ?
//STRIP001 /*N*/ 							{
//STRIP001 /*N*/ 								aLineLT = aLineRT;
//STRIP001 /*N*/ 								aLineLB = aLineRB;
//STRIP001 /*N*/ 								aLineL = aDrawLine;
//STRIP001 /*N*/ 								aDrawLine = aLineR;
//STRIP001 /*N*/ 							}
//STRIP001 /*N*/ 							else
//STRIP001 /*N*/ 							{
//STRIP001 /*N*/ 								aDrawLine.nLeft		= nFirstSize;
//STRIP001 /*N*/ 								aDrawLine.nMiddle	= nSpaceSize;
//STRIP001 /*N*/ 								aDrawLine.nRight	= nSecondSize;
//STRIP001 /*N*/ 								GetLineStruct( aLineLT, pRowInfo[nArrY].pCellInfo[nX].pRightLine, nPPTX );
//STRIP001 /*N*/ 								GetLineStruct( aLineLB, pRowInfo[nArrY+1].pCellInfo[nX].pRightLine, nPPTX );
//STRIP001 /*N*/ 								GetLineStruct( aLineL,  pRowInfo[nArrY].pCellInfo[nX].pBottomLine, nPPTY );
//STRIP001 /*N*/ 							}
//STRIP001 /*N*/ 							GetLineStruct( aLineRT, pRowInfo[nArrY].pCellInfo[nX+1].pRightLine, nPPTX );
//STRIP001 /*N*/ 							GetLineStruct( aLineRB, pRowInfo[nArrY+1].pCellInfo[nX+1].pRightLine, nPPTX );
//STRIP001 /*N*/ 							GetLineStruct( aLineR,  pRowInfo[nArrY].pCellInfo[nX+2].pBottomLine, nPPTY );
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 							ScLinkLine( aDrawLine, aLineLT, aLineL, aLineLB, aLineRT, aLineR, aLineRB, nLinkRes );
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 							nDrawStartX	= nSnapPosX + nLinkRes[0];
//STRIP001 /*N*/ 							nDrawEndX	= nSnapEndX + nLinkRes[2];
//STRIP001 /*N*/ 						}
//STRIP001 /*N*/ 						nDrawStartY	= nDrawY;
//STRIP001 /*N*/ 						nDrawEndY	= nDrawY + nFirstSize - 1;
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 						UpdateOldRectHor( pDev, aOldRect, bOldValid,
//STRIP001 /*N*/ 											nDrawStartX, nDrawStartY, nDrawEndX, nDrawEndY );
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 						if (nSecondSize)
//STRIP001 /*N*/ 						{
//STRIP001 /*N*/ 							nDrawStartX	= nSnapPosX + nLinkRes[1];
//STRIP001 /*N*/ 							nDrawEndX	= nSnapEndX + nLinkRes[3];
//STRIP001 /*N*/ 							nDrawStartY	= nDrawY + nFirstSize + nSpaceSize;
//STRIP001 /*N*/ 							nDrawEndY	= nDrawY + nFirstSize + nSpaceSize + nSecondSize - 1;
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 							UpdateOldRectHor( pDev, aOldRect2, bOldValid2,
//STRIP001 /*N*/ 												nDrawStartX, nDrawStartY, nDrawEndX, nDrawEndY );
//STRIP001 /*N*/ 						}
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 						pOldLine = pDrawLine;			// nur vorhandene
/*N*/ 					}
/*N*/ 				}
/*N*/ 				nPosX = nEndX;
/*N*/ 				bWasLine = bIsLine;
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 				//
/*N*/ 				//			Vertikale Linien
/*N*/ 				//
/*N*/ 
/*N*/ 	nPosX = nScrX - 1;
/*N*/ 	for (nArrX=nX1; nArrX<=nX2+1; nArrX++)						// einer vorher
/*N*/ 	{
/*N*/ 		if (nArrX>nX1)											// "nullte Zeile" ganz links
/*N*/ 			nPosX += pRowInfo[0].pCellInfo[nArrX].nWidth;
/*N*/ 
/*N*/ 		long nSnapPosX = nPosX;
/*N*/ 		if (bSnapPixel)
				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*N*/			lcl_SnapPixelX(pDev,nSnapPosX);
/*N*/ 
/*N*/ 		bWasLine = FALSE;
/*N*/ 		nPosY = nScrY - 1;
/*N*/ 		for (nArrY=1; nArrY+1<nArrCount; nArrY++)
/*N*/ 		{
/*N*/ 			bIsLine = FALSE;
/*N*/ 			long nEndY = nPosY + pRowInfo[nArrY].nHeight;
/*N*/ 
/*N*/ 			//	Zeile +-1 nur, um Variablen mitzufuehren, gezeichnet wird nicht
/*N*/ 			if ( pRowInfo[nArrY].bChanged ||
/*N*/ 				pRowInfo[nArrY+1].bChanged || pRowInfo[nArrY-1].bChanged )
/*N*/ 			{
/*N*/ 				pDrawLine = pRowInfo[nArrY].pCellInfo[nArrX].pRightLine;
/*N*/ 				if ( pDrawLine )
/*N*/ 				{
/*N*/ 					if ( pDrawLine->GetOutWidth() )
/*N*/ 					{
/*N*/ 						long nSnapPosY = nPosY;
/*N*/ 						long nSnapEndY = nEndY;
/*N*/ 						if (bSnapPixel)
/*N*/ 						{ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*N*/ 							lcl_SnapPixelY(pDev,nSnapPosY);
//STRIP001 /*N*/ 							lcl_SnapPixelY(pDev,nSnapEndY);
/*N*/ 						}
/*N*/ 
/*N*/ 						bIsLine = TRUE;
/*N*/ 						if ( pDrawLine != pOldLine )
/*N*/ 						{
/*N*/ 							Color aColor( pDrawLine->GetColor() );
/*N*/ 							if ( bUseSingleColor )
/*N*/ 								aColor = aSingleColor;
/*N*/ 							if ( aColor != aOldCol )
/*N*/ 							{ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*N*/ 								FinishOldRect( pDev, aOldRect, bOldValid );
//STRIP001 /*N*/ 								FinishOldRect( pDev, aOldRect2, bOldValid2 );
//STRIP001 /*N*/ 								pDev->SetFillColor( aColor );
//STRIP001 /*N*/ 								aOldCol = aColor;
/*N*/ 							}
/*N*/ 
/*N*/ 							nFirstSize = Max((short) 1, (short) ( pDrawLine->GetOutWidth() * nPPTX ));
/*N*/ 							if ( pDrawLine->GetInWidth() )
/*N*/ 							{
/*N*/ 								nSpaceSize = Max((short) 1, (short) ( pDrawLine->GetDistance() * nPPTX ));
/*N*/ 								nSecondSize = Max((short) 1, (short) ( pDrawLine->GetInWidth() * nPPTX ));
/*N*/ 							}
/*N*/ 							else
/*N*/ 							{
/*N*/ 								nSpaceSize = 0;
/*N*/ 								nSecondSize = 0;
/*N*/ 							}
/*N*/ 						}
/*N*/ 
/*N*/ 						nDrawX = nSnapPosX - (nFirstSize + nSpaceSize + nSecondSize - 1) / 2;
/*N*/ 
/*N*/ 						// durchzeichnen ?
/*N*/ 						//	(nur wenn nLinkRes gueltig -> bChanged)
/*N*/ 
/*N*/ 						if ( nArrY >= 2
/*N*/ 								&& pRowInfo[nArrY].bChanged
/*N*/ 								&& pRowInfo[nArrY-1].pCellInfo[nArrX].pRightLine 	== pRowInfo[nArrY-2].pCellInfo[nArrX].pRightLine
/*N*/ 								&& pRowInfo[nArrY-1].pCellInfo[nArrX].pBottomLine 	== pRowInfo[nArrY-2].pCellInfo[nArrX].pBottomLine
/*N*/ 								&& pRowInfo[nArrY  ].pCellInfo[nArrX].pRightLine 	== pRowInfo[nArrY-1].pCellInfo[nArrX].pRightLine
/*N*/ 								&& pRowInfo[nArrY  ].pCellInfo[nArrX].pBottomLine 	== pRowInfo[nArrY-1].pCellInfo[nArrX].pBottomLine
/*N*/ 								&& pRowInfo[nArrY+1].pCellInfo[nArrX].pRightLine 	== pRowInfo[nArrY  ].pCellInfo[nArrX].pRightLine
/*N*/ 								&& pRowInfo[nArrY-1].pCellInfo[nArrX+1].pBottomLine	== pRowInfo[nArrY-2].pCellInfo[nArrX+1].pBottomLine
/*N*/ 								&& pRowInfo[nArrY  ].pCellInfo[nArrX+1].pBottomLine	== pRowInfo[nArrY-1].pCellInfo[nArrX+1].pBottomLine )
/*N*/ 						{DBG_BF_ASSERT(0, "STRIP"); //STRIP001_nLinkRes not init. 
//STRIP001 /*N*/ 							bIsLine = FALSE;					// Variablen ungueltig
//STRIP001 /*N*/ 							nDrawStartY	= nSnapPosY + nLinkRes[0];
//STRIP001 /*N*/ 							nDrawEndY	= nSnapEndY + nLinkRes[2];
/*N*/ 						}
/*N*/ 						else
/*N*/ 						{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*N*/ 							if (bWasLine)						// Vorgaenger gueltig ?
//STRIP001 /*N*/ 							{
//STRIP001 /*N*/ 								aLineLT = aLineRT;
//STRIP001 /*N*/ 								aLineLB = aLineRB;
//STRIP001 /*N*/ 								aLineL = aDrawLine;
//STRIP001 /*N*/ 								aDrawLine = aLineR;
//STRIP001 /*N*/ 							}
//STRIP001 /*N*/ 							else
//STRIP001 /*N*/ 							{
//STRIP001 /*N*/ 								aDrawLine.nLeft		= nSecondSize;
//STRIP001 /*N*/ 								aDrawLine.nMiddle	= nSpaceSize;
//STRIP001 /*N*/ 								aDrawLine.nRight	= nFirstSize;
//STRIP001 /*N*/ 								SwapLineStruct( aDrawLine );
//STRIP001 /*N*/ 								GetLineStruct( aLineLT, pRowInfo[nArrY-1].pCellInfo[nArrX].pBottomLine, nPPTY );
//STRIP001 /*N*/ 								GetLineStruct( aLineLB, pRowInfo[nArrY-1].pCellInfo[nArrX+1].pBottomLine, nPPTY );
//STRIP001 /*N*/ 								GetLineStruct( aLineL,	pRowInfo[nArrY-1].pCellInfo[nArrX].pRightLine, nPPTX );
//STRIP001 /*N*/ 								SwapLineStruct( aLineL );
//STRIP001 /*N*/ 							}
//STRIP001 /*N*/ 							GetLineStruct( aLineRT, pRowInfo[nArrY].pCellInfo[nArrX].pBottomLine, nPPTY );
//STRIP001 /*N*/ 							GetLineStruct( aLineRB, pRowInfo[nArrY].pCellInfo[nArrX+1].pBottomLine, nPPTY );
//STRIP001 /*N*/ 							GetLineStruct( aLineR,	pRowInfo[nArrY+1].pCellInfo[nArrX].pRightLine, nPPTX );
//STRIP001 /*N*/ 							SwapLineStruct( aLineR );
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 							ScLinkLine( aDrawLine, aLineLT, aLineL, aLineLB, aLineRT, aLineR, aLineRB, nLinkRes );
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 							nDrawStartY	= nSnapPosY + nLinkRes[0];
//STRIP001 /*N*/ 							nDrawEndY	= nSnapEndY + nLinkRes[2];
/*N*/ 						}
/*N*/ 
/*N*/ 						if (pRowInfo[nArrY].bChanged)
/*N*/ 						{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*N*/ 							//	Zeichnen nur in wirklich geaenderten Zeilen
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 							nDrawStartX	= nDrawX;
//STRIP001 /*N*/ 							nDrawEndX	= nDrawX + nFirstSize - 1;
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 							UpdateOldRectVer( pDev, aOldRect, bOldValid,
//STRIP001 /*N*/ 												nDrawStartX, nDrawStartY, nDrawEndX, nDrawEndY );
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 							if (nSecondSize && pRowInfo[nArrY].bChanged)	//!
//STRIP001 /*N*/ 							{
//STRIP001 /*N*/ 								nDrawStartX	= nDrawX + nFirstSize + nSpaceSize;
//STRIP001 /*N*/ 								nDrawEndX	= nDrawX + nFirstSize + nSpaceSize + nSecondSize - 1;
//STRIP001 /*N*/ 								nDrawStartY	= nSnapPosY + nLinkRes[1];
//STRIP001 /*N*/ 								nDrawEndY	= nSnapEndY + nLinkRes[3];
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 
//STRIP001 /*N*/ 								UpdateOldRectVer( pDev, aOldRect2, bOldValid2,
//STRIP001 /*N*/ 													nDrawStartX, nDrawStartY, nDrawEndX, nDrawEndY );
//STRIP001 /*N*/ 							}
/*N*/ 						}
/*N*/ 
/*N*/ 						pOldLine = pDrawLine;			// nur vorhandene
/*N*/ 					}
/*N*/ 				}
/*N*/ 			}
/*N*/ 			nPosY = nEndY;
/*N*/ 			bWasLine = bIsLine;
/*N*/ 		}
/*N*/ 
/*N*/ 		//	Bei ausgeblendeten Spalten liegt die naechste Spalte an derselben Position
/*N*/ 		//	-> ohne FinishOldRect wuerden die Rechtecke dann weitergezeichnet (#31261#)
/*N*/ 		FinishOldRect( pDev, aOldRect, bOldValid );
/*N*/ 		FinishOldRect( pDev, aOldRect2, bOldValid2 );
/*N*/ 	}
/*N*/ 
/*N*/ 	FinishOldRect( pDev, aOldRect, bOldValid );
/*N*/ 	FinishOldRect( pDev, aOldRect2, bOldValid2 );
/*N*/ 
/*N*/ 	pDev->SetDrawMode(nOldDrawMode);
/*N*/ }

//	-------------------------------------------------------------------------

//	Linie unter der Zelle

//STRIP001 const SvxBorderLine* lcl_FindHorLine( ScDocument* pDoc,
//STRIP001 						USHORT nCol, USHORT nRow, USHORT nTab, USHORT nRotDir,
//STRIP001 						BOOL bTopLine )
//STRIP001 {
//STRIP001 	if ( nRotDir != SC_ROTDIR_LEFT && nRotDir != SC_ROTDIR_RIGHT )
//STRIP001 		return NULL;
//STRIP001 
//STRIP001 	BOOL bFound = FALSE;
//STRIP001 	while (!bFound)
//STRIP001 	{
//STRIP001 		if ( nRotDir == SC_ROTDIR_LEFT )
//STRIP001 		{
//STRIP001 			//	Text nach links -> Linie von rechts
//STRIP001 			if ( nCol < MAXCOL )
//STRIP001 				++nCol;
//STRIP001 			else
//STRIP001 				return NULL;				// war nix
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			//	Text nach rechts -> Linie von links
//STRIP001 			if ( nCol > 0 )
//STRIP001 				--nCol;
//STRIP001 			else
//STRIP001 				return NULL;				// war nix
//STRIP001 		}
//STRIP001 		const ScPatternAttr* pPattern = pDoc->GetPattern( nCol, nRow, nTab );
//STRIP001 		const SfxItemSet* pCondSet = pDoc->GetCondResult( nCol, nRow, nTab );
//STRIP001 		if ( !pPattern->GetRotateVal( pCondSet ) ||
//STRIP001 				((const SvxRotateModeItem&)pPattern->GetItem(
//STRIP001 					ATTR_ROTATE_MODE, pCondSet)).GetValue() == SVX_ROTATE_MODE_STANDARD )
//STRIP001 			bFound = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bTopLine)
//STRIP001 		--nRow;
//STRIP001 	const SvxBorderLine* pThisBottom;
//STRIP001 	if ( nRow <= MAXROW )
//STRIP001 		pThisBottom = ((const SvxBoxItem*)pDoc->GetAttr( nCol, nRow, nTab, ATTR_BORDER ))->GetBottom();
//STRIP001 	else
//STRIP001 		pThisBottom = NULL;
//STRIP001 	const SvxBorderLine* pNextTop;
//STRIP001 	if ( nRow < MAXROW )
//STRIP001 		pNextTop = ((const SvxBoxItem*)pDoc->GetAttr( nCol, nRow+1, nTab, ATTR_BORDER ))->GetTop();
//STRIP001 	else
//STRIP001 		pNextTop = NULL;
//STRIP001 
//STRIP001 	if ( HasPriority( pThisBottom, pNextTop ) )
//STRIP001 		return pThisBottom;
//STRIP001 	else
//STRIP001 		return pNextTop;
//STRIP001 }

// lcl_HorizLine muss genau zu normal ausgegebenen Linien passen!

//STRIP001 void lcl_HorizLine( OutputDevice* pDev, const Point& rLeft, const Point& rRight,
//STRIP001 					const SvxBorderLine* pLine, double nLineScale, const Color* pForceColor )
//STRIP001 {
//STRIP001 	//	horizontal ist nicht schraeg
//STRIP001 	DBG_ASSERT( rLeft.Y() == rRight.Y(), "Horizontale Linie schraeg ???!?" );
//STRIP001 
//STRIP001 	if (!pLine || !pLine->GetOutWidth())
//STRIP001 		return;
//STRIP001 
//STRIP001 	pDev->SetLineColor();
//STRIP001 	pDev->SetFillColor( pForceColor ? *pForceColor : pLine->GetColor() );
//STRIP001 
//STRIP001 	long nFirst = (long) ( pLine->GetOutWidth() * nLineScale );
//STRIP001 	if (nFirst == 0)
//STRIP001 		nFirst = 1;
//STRIP001 	long nSpace = 0;
//STRIP001 	long nSecond = 0;
//STRIP001 	if ( pLine->GetInWidth() )
//STRIP001 	{
//STRIP001 		nSpace = (long) ( pLine->GetDistance() * nLineScale );
//STRIP001 		if (nSpace == 0)
//STRIP001 			nSpace = 1;
//STRIP001 		nSecond = (long) ( pLine->GetInWidth() * nLineScale );
//STRIP001 		if (nSecond == 0)
//STRIP001 			nSecond = 1;
//STRIP001 	}
//STRIP001 
//STRIP001 	long nStart = rLeft.Y() - (nFirst + nSpace + nSecond - 1) / 2;
//STRIP001 
//STRIP001 	Rectangle aRect( rLeft.X(), nStart, rRight.X(), nStart+nFirst-1 );
//STRIP001 	pDev->DrawRect( aRect );
//STRIP001 
//STRIP001 	if ( nSecond )
//STRIP001 	{
//STRIP001 		long nSecStart = nStart + nFirst + nSpace;
//STRIP001 		Rectangle aSecond( rLeft.X(), nSecStart, rRight.X(), nSecStart+nSecond-1 );
//STRIP001 		pDev->DrawRect( aSecond );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 long lcl_LineTotal( const SvxBorderLine& rLine, double nScale )
//STRIP001 {
//STRIP001 	long nFirst = 0;
//STRIP001 	long nSpace = 0;
//STRIP001 	long nSecond = 0;
//STRIP001 
//STRIP001 	if (rLine.GetOutWidth())
//STRIP001 	{
//STRIP001 		nFirst = (long) ( rLine.GetOutWidth() * nScale );
//STRIP001 		if (!nFirst)
//STRIP001 			nFirst = 1;
//STRIP001 	}
//STRIP001 	if (rLine.GetInWidth())
//STRIP001 	{
//STRIP001 		nSpace = (long) ( rLine.GetDistance() * nScale );
//STRIP001 		if (!nSpace)
//STRIP001 			nSpace = 1;
//STRIP001 		nSecond = (long) ( rLine.GetInWidth() * nScale );
//STRIP001 		if (!nSecond)
//STRIP001 			nSecond = 1;
//STRIP001 	}
//STRIP001 
//STRIP001 	return nFirst+nSpace+nSecond;
//STRIP001 }
//STRIP001 
//STRIP001 void lcl_VertLine( OutputDevice* pDev, const Point& rTop, const Point& rBottom,
//STRIP001 					const SvxBorderLine* pLine, double nLineScale,
//STRIP001 					const SvxBorderLine* pTopLine, const SvxBorderLine* pBottomLine,
//STRIP001 					double nPPTY, long nTopCenter, long nBottomCenter, const Color* pForceColor )
//STRIP001 {
//STRIP001 	if (!pLine || !pLine->GetOutWidth())
//STRIP001 		return;
//STRIP001 
//STRIP001 	if ( pLine->GetInWidth() )		// doppelte Linie -> zwei einzelne Aufrufe
//STRIP001 	{
//STRIP001 		long nFirst = (long) ( pLine->GetOutWidth() * nLineScale );
//STRIP001 		if (!nFirst)
//STRIP001 			nFirst = 1;
//STRIP001 		long nSpace = (long) ( pLine->GetDistance() * nLineScale );
//STRIP001 		if (!nSpace)
//STRIP001 			nSpace = 1;
//STRIP001 		long nSecond = (long) ( pLine->GetInWidth() * nLineScale );
//STRIP001 		if (!nSecond)
//STRIP001 			nSecond = 1;
//STRIP001 		Point aNewTop = rTop;
//STRIP001 		Point aNewBottom = rBottom;
//STRIP001 
//STRIP001 		// links
//STRIP001 		long nMove = ( nFirst + nSecond + nSpace - 1 ) / 2 - ( nFirst-1 ) / 2;
//STRIP001 		aNewTop.X() = rTop.X() - nMove;
//STRIP001 		aNewBottom.X() = rBottom.X() - nMove;
//STRIP001 		SvxBorderLine aLeft( &pLine->GetColor(), pLine->GetOutWidth() );
//STRIP001 		lcl_VertLine( pDev, aNewTop, aNewBottom, &aLeft, nLineScale,
//STRIP001 						pTopLine, pBottomLine, nPPTY, nTopCenter, nBottomCenter, pForceColor );
//STRIP001 
//STRIP001 		// rechts
//STRIP001 		aNewTop.X() += nFirst + nSpace;
//STRIP001 		aNewBottom.X() += nFirst + nSpace;
//STRIP001 		SvxBorderLine aRight( &pLine->GetColor(), pLine->GetInWidth() );
//STRIP001 		lcl_VertLine( pDev, aNewTop, aNewBottom, &aRight, nLineScale,
//STRIP001 						pTopLine, pBottomLine, nPPTY, nTopCenter, nBottomCenter, pForceColor );
//STRIP001 
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	Color aDrawColor( pForceColor ? *pForceColor : pLine->GetColor() );
//STRIP001 	pDev->SetLineColor(aDrawColor);				// PEN_NULL ???
//STRIP001 	pDev->SetFillColor(aDrawColor);
//STRIP001 
//STRIP001 	long nWidth = (long) ( pLine->GetOutWidth() * nLineScale );
//STRIP001 	if (nWidth == 0)
//STRIP001 		nWidth = 1;
//STRIP001 	long nSmall = (nWidth - 1) / 2;
//STRIP001 
//STRIP001 	//	Position oben/unten muss unabhaengig von der Liniendicke sein,
//STRIP001 	//	damit der Winkel stimmt (oder X-Position auch anpassen)
//STRIP001 	long nTopPos = rTop.Y();
//STRIP001 	long nBotPos = rBottom.Y();
//STRIP001 
//STRIP001 	long nTopLeft = rTop.X()-nSmall;
//STRIP001 	long nTopRight = nTopLeft+nWidth-1;
//STRIP001 	long nBotLeft = rBottom.X()-nSmall;
//STRIP001 	long nBotRight = nBotLeft+nWidth-1;
//STRIP001 
//STRIP001 	Point aPoints[4];
//STRIP001 	aPoints[0] = Point( nTopLeft, nTopPos );
//STRIP001 	aPoints[1] = Point( nTopRight, nTopPos );
//STRIP001 	aPoints[2] = Point( nBotRight, nBotPos );
//STRIP001 	aPoints[3] = Point( nBotLeft, nBotPos );
//STRIP001 
//STRIP001 	Polygon aPoly( 4, aPoints );
//STRIP001 	pDev->DrawPolygon( aPoly );
//STRIP001 
//STRIP001 	//	oben abschliessen
//STRIP001 
//STRIP001 	if ( pTopLine && pTopLine->GetOutWidth() )
//STRIP001 	{
//STRIP001 		long nLine = lcl_LineTotal( *pTopLine, nPPTY );
//STRIP001 		if (nLine >= 2)
//STRIP001 		{
//STRIP001 			Point aTriangle[3];
//STRIP001 			aTriangle[0] = Point( nTopLeft, nTopPos );		// wie aPoints[0]
//STRIP001 			aTriangle[1] = Point( nTopRight, nTopPos );		// wie aPoints[1]
//STRIP001 //			aTriangle[2] = Point( rTop.X(), nTopPos - nLine/2 + 1 );
//STRIP001 			aTriangle[2] = Point( nTopCenter, nTopPos - nLine/2 + 1 );
//STRIP001 			Polygon aTriPoly( 3, aTriangle );
//STRIP001 			pDev->DrawPolygon( aTriPoly );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//	unten abschliessen
//STRIP001 
//STRIP001 	if ( pBottomLine && pBottomLine->GetOutWidth() )
//STRIP001 	{
//STRIP001 		long nLine = lcl_LineTotal( *pBottomLine, nPPTY );
//STRIP001 		if (nLine >= 2)
//STRIP001 		{
//STRIP001 			Point aTriangle[3];
//STRIP001 			aTriangle[0] = Point( nBotLeft, nBotPos );		// wie aPoints[3]
//STRIP001 			aTriangle[1] = Point( nBotRight, nBotPos );		// wie aPoints[2]
//STRIP001 //			aTriangle[2] = Point( rBottom.X(), nBotPos + nLine/2 - 1 );
//STRIP001 			aTriangle[2] = Point( nBottomCenter, nBotPos + nLine/2 - 1 );
//STRIP001 			Polygon aTriPoly( 3, aTriangle );
//STRIP001 			pDev->DrawPolygon( aTriPoly );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScOutputData::DrawRotatedFrame( const Color* pForceColor )
//STRIP001 {
//STRIP001 	//!	nRotMax speichern
//STRIP001 	USHORT nRotMax = nX2;
//STRIP001 	for (USHORT nRotY=0; nRotY<nArrCount; nRotY++)
//STRIP001 		if (pRowInfo[nRotY].nRotMaxCol != SC_ROTMAX_NONE && pRowInfo[nRotY].nRotMaxCol > nRotMax)
//STRIP001 			nRotMax = pRowInfo[nRotY].nRotMaxCol;
//STRIP001 
//STRIP001 	const ScPatternAttr* pPattern;
//STRIP001 	const SfxItemSet*	 pCondSet;
//STRIP001 	const ScPatternAttr* pOldPattern = NULL;
//STRIP001 	const SfxItemSet*	 pOldCondSet = NULL;
//STRIP001 
//STRIP001 	const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
//STRIP001 	//	#105733# SvtAccessibilityOptions::GetIsForBorders is no longer used (always assumed TRUE)
//STRIP001 	BOOL bCellContrast = bUseStyleColor && rStyleSettings.GetHighContrastMode();
//STRIP001 
//STRIP001 	//	color (pForceColor) is determined externally, including DrawMode changes
//STRIP001 
//STRIP001 	Rectangle aClipRect( Point(nScrX, nScrY), Size(nScrW, nScrH) );
//STRIP001 	if (bMetaFile)
//STRIP001 	{
//STRIP001 		pDev->Push();
//STRIP001 		pDev->IntersectClipRegion( aClipRect );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pDev->SetClipRegion( Region( aClipRect ) );
//STRIP001 
//STRIP001 	long nPosY = nScrY;
//STRIP001 	for (USHORT nArrY=1; nArrY<nArrCount; nArrY++)
//STRIP001 	{
//STRIP001 		//	Rotated wird auch 1 Zeile ueber/unter Changed gezeichnet, falls Teile
//STRIP001 		//	in die Zeile hineinragen...
//STRIP001 
//STRIP001 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
//STRIP001 		long nRowHeight = pThisRowInfo->nHeight;
//STRIP001 		if ( pThisRowInfo->nRotMaxCol != SC_ROTMAX_NONE &&
//STRIP001 			 ( pThisRowInfo->bChanged || pRowInfo[nArrY-1].bChanged ||
//STRIP001 			   ( nArrY+1<nArrCount && pRowInfo[nArrY+1].bChanged ) ) )
//STRIP001 		{
//STRIP001 			USHORT nY = pRowInfo[nArrY].nRowNo;
//STRIP001 			long nPosX = 0;
//STRIP001 			USHORT nX;
//STRIP001 			for (nX=0; nX<=nRotMax; nX++)
//STRIP001 			{
//STRIP001 				if (nX==nX1) nPosX = nScrX;						// vorher wird einzeln berechnet
//STRIP001 
//STRIP001 				CellInfo* pInfo = &pThisRowInfo->pCellInfo[nX+1];
//STRIP001 				long nColWidth = pRowInfo[0].pCellInfo[nX+1].nWidth;
//STRIP001 				if ( pInfo->nRotateDir > SC_ROTDIR_STANDARD &&
//STRIP001 						!pInfo->bHOverlapped && !pInfo->bVOverlapped )
//STRIP001 				{
//STRIP001 					pPattern = pInfo->pPatternAttr;
//STRIP001 					pCondSet = pInfo->pConditionSet;
//STRIP001 					if (!pPattern)
//STRIP001 					{
//STRIP001 						pPattern = pDoc->GetPattern( nX, nY, nTab );
//STRIP001 						pInfo->pPatternAttr = pPattern;
//STRIP001 						pCondSet = pDoc->GetCondResult( nX, nY, nTab );
//STRIP001 						pInfo->pConditionSet = pCondSet;
//STRIP001 					}
//STRIP001 
//STRIP001 					//!	LastPattern etc.
//STRIP001 
//STRIP001 					long nAttrRotate = pPattern->GetRotateVal( pCondSet );
//STRIP001 					SvxRotateMode eRotMode = (SvxRotateMode)((const SvxRotateModeItem&)
//STRIP001 									pPattern->GetItem(ATTR_ROTATE_MODE, pCondSet)).GetValue();
//STRIP001 
//STRIP001 					if ( nAttrRotate )
//STRIP001 					{
//STRIP001 						if (nX<nX1)			// negative Position berechnen
//STRIP001 						{
//STRIP001 							nPosX = nScrX;
//STRIP001 							USHORT nCol = nX1;
//STRIP001 							while (nCol > nX)
//STRIP001 							{
//STRIP001 								--nCol;
//STRIP001 								nPosX -= (long) pRowInfo[0].pCellInfo[nCol+1].nWidth;
//STRIP001 							}
//STRIP001 						}
//STRIP001 
//STRIP001 						//	Startposition minus 1, damit auch schraege Hintergruende
//STRIP001 						//	zur Umrandung passen (Umrandung ist auf dem Gitter)
//STRIP001 
//STRIP001 						long nTop = nPosY - 1;
//STRIP001 						long nBottom = nPosY + nRowHeight - 1;
//STRIP001 						long nTopLeft = nPosX - 1;
//STRIP001 						long nTopRight = nPosX + nColWidth - 1;
//STRIP001 						long nBotLeft = nTopLeft;
//STRIP001 						long nBotRight = nTopRight;
//STRIP001 
//STRIP001 						double nRealOrient = nAttrRotate * F_PI18000;	// 1/100 Grad
//STRIP001 						double nCos = cos( nRealOrient );
//STRIP001 						double nSin = sin( nRealOrient );
//STRIP001 						//!	begrenzen !!!
//STRIP001 						long nSkew = (long) ( nRowHeight * nCos / nSin );
//STRIP001 
//STRIP001 						switch (eRotMode)
//STRIP001 						{
//STRIP001 							case SVX_ROTATE_MODE_BOTTOM:
//STRIP001 								nTopLeft += nSkew;
//STRIP001 								nTopRight += nSkew;
//STRIP001 								break;
//STRIP001 							case SVX_ROTATE_MODE_CENTER:
//STRIP001 								nSkew /= 2;
//STRIP001 								nTopLeft += nSkew;
//STRIP001 								nTopRight += nSkew;
//STRIP001 								nBotLeft -= nSkew;
//STRIP001 								nBotRight -= nSkew;
//STRIP001 								break;
//STRIP001 							case SVX_ROTATE_MODE_TOP:
//STRIP001 								nBotLeft -= nSkew;
//STRIP001 								nBotRight -= nSkew;
//STRIP001 								break;
//STRIP001 						}
//STRIP001 
//STRIP001 						Point aPoints[4];
//STRIP001 						aPoints[0] = Point( nTopLeft, nTop );
//STRIP001 						aPoints[1] = Point( nTopRight, nTop );
//STRIP001 						aPoints[2] = Point( nBotRight, nBottom );
//STRIP001 						aPoints[3] = Point( nBotLeft, nBottom );
//STRIP001 
//STRIP001 						const SvxBrushItem* pBackground = pInfo->pBackground;
//STRIP001 						if (!pBackground)
//STRIP001 							pBackground = (const SvxBrushItem*) &pPattern->GetItem(
//STRIP001 												ATTR_BACKGROUND, pCondSet );
//STRIP001 						if (bCellContrast)
//STRIP001 						{
//STRIP001 							//	high contrast for cell borders and backgrounds -> empty background
//STRIP001 							pBackground = ScGlobal::GetEmptyBrushItem();
//STRIP001 						}
//STRIP001 						const Color& rColor = pBackground->GetColor();
//STRIP001 						if ( rColor.GetTransparency() != 255 )
//STRIP001 						{
//STRIP001 							//	#95879# draw background only for the changed row itself
//STRIP001 							//	(background doesn't extend into other cells).
//STRIP001 							//	For the borders (rotated and normal), clipping should be
//STRIP001 							//	set if the row isn't changed, but at least the borders
//STRIP001 							//	don't cover the cell contents.
//STRIP001 							if ( pThisRowInfo->bChanged )
//STRIP001 							{
//STRIP001 								Polygon aPoly( 4, aPoints );
//STRIP001 
//STRIP001 								//	ohne Pen wird bei DrawPolygon rechts und unten
//STRIP001 								//	ein Pixel weggelassen...
//STRIP001 								if ( rColor.GetTransparency() == 0 )
//STRIP001 									pDev->SetLineColor(rColor);
//STRIP001 								else
//STRIP001 									pDev->SetLineColor();
//STRIP001 								pDev->SetFillColor(rColor);
//STRIP001 								pDev->DrawPolygon( aPoly );
//STRIP001 							}
//STRIP001 						}
//STRIP001 
//STRIP001 						const SvxBorderLine* pTopLine =
//STRIP001 									pRowInfo[nArrY-1].pCellInfo[nX+1].pBottomLine;
//STRIP001 						const SvxBorderLine* pBottomLine = pInfo->pBottomLine;
//STRIP001 						const SvxBorderLine* pLeftLine = pThisRowInfo->pCellInfo[nX].pRightLine;
//STRIP001 						const SvxBorderLine* pRightLine = pInfo->pRightLine;
//STRIP001 
//STRIP001 						if ( nX < nX1 || nX > nX2 )		// Attribute in FillInfo nicht gesetzt
//STRIP001 						{
//STRIP001 							//!	Seitengrenzen fuer Druck beruecksichtigen !!!!!
//STRIP001 							pDoc->GetBorderLines( nX, nY, nTab,
//STRIP001 									&pLeftLine, &pTopLine, &pRightLine, &pBottomLine );
//STRIP001 						}
//STRIP001 
//STRIP001 						lcl_HorizLine( pDev, aPoints[0],aPoints[1], pTopLine, nPPTY, pForceColor );
//STRIP001 						lcl_HorizLine( pDev, aPoints[3],aPoints[2], pBottomLine, nPPTY, pForceColor );
//STRIP001 
//STRIP001 						double nVLineScale = nPPTX / fabs(nSin);
//STRIP001 						lcl_VertLine( pDev, aPoints[0],aPoints[3], pLeftLine,
//STRIP001 										nVLineScale, pTopLine, pBottomLine, nPPTY,
//STRIP001 										aPoints[0].X(), aPoints[3].X(), pForceColor );
//STRIP001 						lcl_VertLine( pDev, aPoints[1],aPoints[2], pRightLine,
//STRIP001 										nVLineScale, pTopLine, pBottomLine, nPPTY,
//STRIP001 										aPoints[1].X(), aPoints[2].X(), pForceColor );
//STRIP001 					}
//STRIP001 				}
//STRIP001 				nPosX += nColWidth;
//STRIP001 			}
//STRIP001 
//STRIP001 			//	erst hinterher im zweiten Schritt die Linien fuer normale Ausgabe loeschen
//STRIP001 
//STRIP001 			nX = nX1 ? (nX1-1) : 0;
//STRIP001 			for (; nX<=nX2+1; nX++)			// sichtbarer Teil +- 1
//STRIP001 			{
//STRIP001 				CellInfo* pInfo = &pThisRowInfo->pCellInfo[nX+1];
//STRIP001 				if ( pInfo->nRotateDir > SC_ROTDIR_STANDARD &&
//STRIP001 						!pInfo->bHOverlapped && !pInfo->bVOverlapped )
//STRIP001 				{
//STRIP001 					pPattern = pInfo->pPatternAttr;
//STRIP001 					pCondSet = pInfo->pConditionSet;
//STRIP001 					SvxRotateMode eRotMode = (SvxRotateMode)((const SvxRotateModeItem&)
//STRIP001 									pPattern->GetItem(ATTR_ROTATE_MODE, pCondSet)).GetValue();
//STRIP001 
//STRIP001 					//	horizontal: angrenzende Linie verlaengern
//STRIP001 					//	(nur, wenn die gedrehte Zelle eine Umrandung hat)
//STRIP001 					USHORT nDir = pInfo->nRotateDir;
//STRIP001 					if ( pRowInfo[nArrY-1].pCellInfo[nX+1].pBottomLine &&
//STRIP001 							eRotMode != SVX_ROTATE_MODE_TOP )
//STRIP001 						pRowInfo[nArrY-1].pCellInfo[nX+1].pBottomLine =
//STRIP001 										lcl_FindHorLine( pDoc, nX, nY, nTab, nDir, TRUE );
//STRIP001 					if ( pInfo->pBottomLine && eRotMode != SVX_ROTATE_MODE_BOTTOM )
//STRIP001 						pInfo->pBottomLine = lcl_FindHorLine( pDoc, nX, nY, nTab, nDir, FALSE );
//STRIP001 
//STRIP001 					//	vertikale Linien kommen immer ganz weg...
//STRIP001 					pThisRowInfo->pCellInfo[nX].pRightLine = NULL;
//STRIP001 					pInfo->pRightLine = NULL;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		nPosY += nRowHeight;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bMetaFile)
//STRIP001 		pDev->Pop();
//STRIP001 	else
//STRIP001 		pDev->SetClipRegion();
//STRIP001 }

//	Drucker

//STRIP001 void ScOutputData::DrawPageBorder( USHORT nStartX, USHORT nStartY, USHORT nEndX, USHORT nEndY )
//STRIP001 {
//STRIP001 	PutInOrder( nStartX, nEndX );
//STRIP001 	PutInOrder( nStartY, nEndY );
//STRIP001 
//STRIP001 	if ( nStartX <= nX2 && nEndX >= nX1 &&
//STRIP001 		 nStartY <= nY2 && nEndY >= nY1 )
//STRIP001 	{
//STRIP001 		long nMinX = nScrX;
//STRIP001 		long nMinY = nScrY;
//STRIP001 		long nMaxX = nScrX+nScrW-1;
//STRIP001 		long nMaxY = nScrY+nScrH-1;
//STRIP001 		BOOL bTop    = FALSE;
//STRIP001 		BOOL bBottom = FALSE;
//STRIP001 		BOOL bLeft   = FALSE;
//STRIP001 		BOOL bRight	 = FALSE;
//STRIP001 
//STRIP001 		long nPosY = nScrY;
//STRIP001 		for (USHORT nArrY=1; nArrY+1<nArrCount; nArrY++)
//STRIP001 		{
//STRIP001 			USHORT nY = pRowInfo[nArrY].nRowNo;
//STRIP001 
//STRIP001 			if ( nY==nStartY )
//STRIP001 			{
//STRIP001 				nMinY = nPosY;
//STRIP001 				bTop = TRUE;
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( nY==nEndY )
//STRIP001 			{
//STRIP001 //				nMaxY = nPosY + pRowInfo[nArrY].nHeight - 2;
//STRIP001 				nMaxY = nPosY + pRowInfo[nArrY].nHeight;
//STRIP001 				bBottom = TRUE;
//STRIP001 			}
//STRIP001 
//STRIP001 			nPosY += pRowInfo[nArrY].nHeight;
//STRIP001 		}
//STRIP001 
//STRIP001 		RowInfo* pThisRowInfo = &pRowInfo[0];
//STRIP001 		long nPosX = nScrX;
//STRIP001 		for (USHORT nX=nX1; nX<=nX2; nX++)
//STRIP001 		{
//STRIP001 			if ( nX==nStartX )
//STRIP001 			{
//STRIP001 				nMinX = nPosX;
//STRIP001 				bLeft = TRUE;
//STRIP001 			}
//STRIP001 			if ( nX==nEndX )
//STRIP001 			{
//STRIP001 //				nMaxX = nPosX + pRowInfo[0].pCellInfo[nX+1].nWidth - 2;
//STRIP001 				nMaxX = nPosX + pRowInfo[0].pCellInfo[nX+1].nWidth;
//STRIP001 				bRight = TRUE;
//STRIP001 			}
//STRIP001 			nPosX += pRowInfo[0].pCellInfo[nX+1].nWidth;
//STRIP001 		}
//STRIP001 
//STRIP001 		pDev->SetLineColor( COL_BLACK );
//STRIP001 		if (bTop && bBottom && bLeft && bRight)
//STRIP001 		{
//STRIP001 			pDev->SetFillColor();
//STRIP001 			pDev->DrawRect( Rectangle( nMinX, nMinY, nMaxX, nMaxY ) );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if (bTop)
//STRIP001 				pDev->DrawLine( Point( nMinX,nMinY ), Point( nMaxX,nMinY ) );
//STRIP001 			if (bBottom)
//STRIP001 				pDev->DrawLine( Point( nMinX,nMaxY ), Point( nMaxX,nMaxY ) );
//STRIP001 			if (bLeft)
//STRIP001 				pDev->DrawLine( Point( nMinX,nMinY ), Point( nMinX,nMaxY ) );
//STRIP001 			if (bRight)
//STRIP001 				pDev->DrawLine( Point( nMaxX,nMinY ), Point( nMaxX,nMaxY ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*N*/ BOOL ScOutputData::SetChangedClip()
/*N*/ {
/*N*/ 	PolyPolygon aPoly;
/*N*/ 
/*N*/ 	Rectangle aDrawingRect;
/*N*/ 	aDrawingRect.Left() = nScrX;
/*N*/ 	aDrawingRect.Right() = nScrX+nScrW-1;
/*N*/ 
/*N*/ 	BOOL	bHad	= FALSE;
/*N*/ 	long	nPosY	= nScrY;
/*N*/ 	USHORT	nArrY;
/*N*/ 	for (nArrY=1; nArrY+1<nArrCount; nArrY++)
/*N*/ 	{
/*N*/ 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*N*/ 
/*N*/ 		if ( pThisRowInfo->bChanged )
/*N*/ 		{
/*N*/ 			if (!bHad)
/*N*/ 			{
/*N*/ 				aDrawingRect.Top() = nPosY;
/*N*/ 				bHad = TRUE;
/*N*/ 			}
/*N*/ 			aDrawingRect.Bottom() = nPosY + pRowInfo[nArrY].nHeight - 1;
/*N*/ 		}
/*N*/ 		else if (bHad)
/*N*/ 		{
/*N*/ 			aPoly.Insert( Polygon( pDev->PixelToLogic(aDrawingRect) ) );
/*N*/ 			bHad = FALSE;
/*N*/ 		}
/*N*/ 		nPosY += pRowInfo[nArrY].nHeight;
/*N*/ 	}
/*N*/ 
/*N*/ 	if (bHad)
/*N*/ 		aPoly.Insert( Polygon( pDev->PixelToLogic(aDrawingRect) ) );
/*N*/ 
/*N*/ 	BOOL bRet = (aPoly.Count() != 0);
/*N*/ 	if (bRet)
/*N*/ 		pDev->SetClipRegion(Region(aPoly));
/*N*/ 	return bRet;
/*N*/ }

/*N*/ void ScOutputData::FindChanged()
/*N*/ {
/*N*/ 	USHORT	nX;
/*N*/ 	USHORT	nArrY;
/*N*/ 
/*N*/ 	BOOL bWasIdleDisabled = pDoc->IsIdleDisabled();
/*N*/ 	pDoc->DisableIdle( TRUE );
/*N*/ 	for (nArrY=0; nArrY<nArrCount; nArrY++)
/*N*/ 		pRowInfo[nArrY].bChanged = FALSE;
/*N*/ 
/*N*/ 	BOOL bProgress = FALSE;
/*N*/ 	for (nArrY=0; nArrY<nArrCount; nArrY++)
/*N*/ 	{
/*N*/ 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*N*/ 		for (nX=nX1; nX<=nX2; nX++)
/*N*/ 		{
/*N*/ 			ScBaseCell* pCell = pThisRowInfo->pCellInfo[nX+1].pCell;
/*N*/ 			if (pCell)
/*N*/ 				if (pCell->GetCellType() == CELLTYPE_FORMULA)
/*N*/ 				{
/*N*/ 					ScFormulaCell* pFCell = (ScFormulaCell*)pCell;
/*N*/ 					if ( !bProgress && pFCell->GetDirty() )
/*N*/ 					{
/*?*/ 						DBG_BF_ASSERT(0, "STRIP"); //STRIP001 ScProgress::CreateInterpretProgress( pDoc, TRUE );
//STRIP001 /*?*/ 						bProgress = TRUE;
/*N*/ 					}
/*N*/ 					if (!pFCell->IsRunning())
/*N*/ 					{
/*N*/ 						double aVal = pFCell->GetValue();
/*N*/ 						if (pFCell->IsChanged())
/*N*/ 						{
/*?*/ 							pThisRowInfo->bChanged = TRUE;
/*?*/ 							if ( pThisRowInfo->pCellInfo[nX+1].bMerged )
/*?*/ 							{
/*?*/ 								DBG_BF_ASSERT(0, "STRIP"); //STRIP001 USHORT nOverY = nArrY + 1;
//STRIP001 /*?*/ 								while ( nOverY<nArrCount &&
//STRIP001 /*?*/ 										pRowInfo[nOverY].pCellInfo[nX+1].bVOverlapped )
//STRIP001 /*?*/ 								{
//STRIP001 /*?*/ 									pRowInfo[nOverY].bChanged = TRUE;
//STRIP001 /*?*/ 									++nOverY;
//STRIP001 /*?*/ 								}
/*?*/ 							}
/*N*/ 						}
/*N*/ 					}
/*N*/ 				}
/*N*/ 		}
/*N*/ 	}
/*N*/ 	if ( bProgress )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 ScProgress::DeleteInterpretProgress();
/*N*/ 	pDoc->DisableIdle( bWasIdleDisabled );
/*N*/ }

/*N*/ void ScOutputData::DrawMark( Window* pWin )
/*N*/ {
/*N*/ 	Rectangle aRect;
/*N*/ 	ScInvertMerger aInvert( pWin );
/*N*/ 	//!	additional method AddLineRect for ScInvertMerger?
/*N*/ 
/*N*/ 	long nPosY = nScrY;
/*N*/ 	for (USHORT nArrY=1; nArrY+1<nArrCount; nArrY++)
/*N*/ 	{
/*N*/ 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*N*/ 		if ( pThisRowInfo->bChanged )
/*N*/ 		{
/*?*/ 			long nPosX = nScrX;
/*?*/ 			aRect = Rectangle( Point( nPosX,nPosY ), Size(0, pThisRowInfo->nHeight) );
/*?*/ 
/*?*/ 			BOOL bOldMarked = FALSE;
/*?*/ 			for (USHORT nX=nX1; nX<=nX2; nX++)
/*?*/ 			{
/*?*/ 				if ( pThisRowInfo->pCellInfo[nX+1].bMarked != bOldMarked )
/*?*/ 				{
/*?*/ 					if (bOldMarked && aRect.Right() >= aRect.Left())
							{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 						aInvert.AddRect( aRect );
/*?*/ 					aRect.Left() = nPosX;
/*?*/ 					bOldMarked = pThisRowInfo->pCellInfo[nX+1].bMarked;
/*?*/ 				}
/*?*/ 				nPosX += pRowInfo[0].pCellInfo[nX+1].nWidth;
/*?*/ 				aRect.Right() = nPosX-1;
/*?*/ 			}
/*?*/ 			if (bOldMarked && aRect.Right() >= aRect.Left())
					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 				aInvert.AddRect( aRect );
/*N*/ 		}
/*N*/ 		nPosY += pThisRowInfo->nHeight;
/*N*/ 	}
/*N*/ }

//STRIP001 void ScOutputData::DrawRefMark( USHORT nRefStartX, USHORT nRefStartY,
//STRIP001 								USHORT nRefEndX, USHORT nRefEndY,
//STRIP001 								const Color& rColor, BOOL bHandle )
//STRIP001 {
//STRIP001 	PutInOrder( nRefStartX, nRefEndX );
//STRIP001 	PutInOrder( nRefStartY, nRefEndY );
//STRIP001 
//STRIP001 	if ( nRefStartX == nRefEndX && nRefStartY == nRefEndY )
//STRIP001 		pDoc->ExtendMerge( nRefStartX, nRefStartY, nRefEndX, nRefEndY, nTab );
//STRIP001 
//STRIP001 	if ( nRefStartX <= nVisX2 && nRefEndX >= nVisX1 &&
//STRIP001 		 nRefStartY <= nVisY2 && nRefEndY >= nVisY1 )
//STRIP001 	{
//STRIP001 		long nMinX = nScrX;
//STRIP001 		long nMinY = nScrY;
//STRIP001 		long nMaxX = nScrX+nScrW-1;
//STRIP001 		long nMaxY = nScrY+nScrH-1;
//STRIP001 		BOOL bTop    = FALSE;
//STRIP001 		BOOL bBottom = FALSE;
//STRIP001 		BOOL bLeft   = FALSE;
//STRIP001 		BOOL bRight	 = FALSE;
//STRIP001 
//STRIP001 		long nPosY = nScrY;
//STRIP001 		BOOL bNoStartY = ( nY1 < nRefStartY );
//STRIP001 		BOOL bNoEndY   = FALSE;
//STRIP001 		for (USHORT nArrY=1; nArrY<nArrCount; nArrY++)		// loop to end for bNoEndY check
//STRIP001 		{
//STRIP001 			USHORT nY = pRowInfo[nArrY].nRowNo;
//STRIP001 
//STRIP001 			if ( nY==nRefStartY || (nY>nRefStartY && bNoStartY) )
//STRIP001 			{
//STRIP001 				nMinY = nPosY;
//STRIP001 				bTop = TRUE;
//STRIP001 			}
//STRIP001 			if ( nY==nRefEndY )
//STRIP001 			{
//STRIP001 				nMaxY = nPosY + pRowInfo[nArrY].nHeight - 2;
//STRIP001 				bBottom = TRUE;
//STRIP001 			}
//STRIP001 			if ( nY>nRefEndY && bNoEndY )
//STRIP001 			{
//STRIP001 				nMaxY = nPosY-2;
//STRIP001 				bBottom = TRUE;
//STRIP001 			}
//STRIP001 			bNoStartY = ( nY < nRefStartY );
//STRIP001 			bNoEndY   = ( nY < nRefEndY );
//STRIP001 			nPosY += pRowInfo[nArrY].nHeight;
//STRIP001 		}
//STRIP001 
//STRIP001 		RowInfo* pThisRowInfo = &pRowInfo[0];
//STRIP001 		long nPosX = nScrX;
//STRIP001 		for (USHORT nX=nX1; nX<=nX2; nX++)
//STRIP001 		{
//STRIP001 			if ( nX==nRefStartX )
//STRIP001 			{
//STRIP001 				nMinX = nPosX;
//STRIP001 				bLeft = TRUE;
//STRIP001 			}
//STRIP001 			if ( nX==nRefEndX )
//STRIP001 			{
//STRIP001 				nMaxX = nPosX + pRowInfo[0].pCellInfo[nX+1].nWidth - 2;
//STRIP001 				bRight = TRUE;
//STRIP001 			}
//STRIP001 			nPosX += pRowInfo[0].pCellInfo[nX+1].nWidth;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( nMaxX >= nMinX && nMaxY >= nMinY )
//STRIP001 		{
//STRIP001 			pDev->SetLineColor( rColor );
//STRIP001 			if (bTop && bBottom && bLeft && bRight)
//STRIP001 			{
//STRIP001 				pDev->SetFillColor();
//STRIP001 				pDev->DrawRect( Rectangle( nMinX, nMinY, nMaxX, nMaxY ) );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				if (bTop)
//STRIP001 					pDev->DrawLine( Point( nMinX,nMinY ), Point( nMaxX,nMinY ) );
//STRIP001 				if (bBottom)
//STRIP001 					pDev->DrawLine( Point( nMinX,nMaxY ), Point( nMaxX,nMaxY ) );
//STRIP001 				if (bLeft)
//STRIP001 					pDev->DrawLine( Point( nMinX,nMinY ), Point( nMinX,nMaxY ) );
//STRIP001 				if (bRight)
//STRIP001 					pDev->DrawLine( Point( nMaxX,nMinY ), Point( nMaxX,nMaxY ) );
//STRIP001 			}
//STRIP001 			if ( bHandle && bRight && bBottom )
//STRIP001 			{
//STRIP001 				pDev->SetLineColor();
//STRIP001 				pDev->SetFillColor( rColor );
//STRIP001 				pDev->DrawRect( Rectangle( nMaxX-3, nMaxY-3, nMaxX+1, nMaxY+1 ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScOutputData::DrawOneChange( USHORT nRefStartX, USHORT nRefStartY,
//STRIP001 								USHORT nRefEndX, USHORT nRefEndY,
//STRIP001 								const Color& rColor, USHORT nType )
//STRIP001 {
//STRIP001 	PutInOrder( nRefStartX, nRefEndX );
//STRIP001 	PutInOrder( nRefStartY, nRefEndY );
//STRIP001 
//STRIP001 	if ( nRefStartX == nRefEndX && nRefStartY == nRefEndY )
//STRIP001 		pDoc->ExtendMerge( nRefStartX, nRefStartY, nRefEndX, nRefEndY, nTab );
//STRIP001 
//STRIP001 	if ( nRefStartX <= nVisX2 + 1 && nRefEndX >= nVisX1 &&
//STRIP001 		 nRefStartY <= nVisY2 + 1 && nRefEndY >= nVisY1 )		// +1 because it touches next cells left/top
//STRIP001 	{
//STRIP001 		long nMinX = nScrX;
//STRIP001 		long nMinY = nScrY;
//STRIP001 		long nMaxX = nScrX+nScrW-1;
//STRIP001 		long nMaxY = nScrY+nScrH-1;
//STRIP001 		BOOL bTop    = FALSE;
//STRIP001 		BOOL bBottom = FALSE;
//STRIP001 		BOOL bLeft   = FALSE;
//STRIP001 		BOOL bRight	 = FALSE;
//STRIP001 
//STRIP001 		long nPosY = nScrY;
//STRIP001 		BOOL bNoStartY = ( nY1 < nRefStartY );
//STRIP001 		BOOL bNoEndY   = FALSE;
//STRIP001 		for (USHORT nArrY=1; nArrY<nArrCount; nArrY++)		// loop to end for bNoEndY check
//STRIP001 		{
//STRIP001 			USHORT nY = pRowInfo[nArrY].nRowNo;
//STRIP001 
//STRIP001 			if ( nY==nRefStartY || (nY>nRefStartY && bNoStartY) )
//STRIP001 			{
//STRIP001 				nMinY = nPosY - 1;
//STRIP001 				bTop = TRUE;
//STRIP001 			}
//STRIP001 			if ( nY==nRefEndY )
//STRIP001 			{
//STRIP001 				nMaxY = nPosY + pRowInfo[nArrY].nHeight - 1;
//STRIP001 				bBottom = TRUE;
//STRIP001 			}
//STRIP001 			if ( nY>nRefEndY && bNoEndY )
//STRIP001 			{
//STRIP001 				nMaxY = nPosY - 1;
//STRIP001 				bBottom = TRUE;
//STRIP001 			}
//STRIP001 			bNoStartY = ( nY < nRefStartY );
//STRIP001 			bNoEndY   = ( nY < nRefEndY );
//STRIP001 			nPosY += pRowInfo[nArrY].nHeight;
//STRIP001 		}
//STRIP001 
//STRIP001 		RowInfo* pThisRowInfo = &pRowInfo[0];
//STRIP001 		long nPosX = nScrX;
//STRIP001 		for (USHORT nX=nX1; nX<=nX2+1; nX++)
//STRIP001 		{
//STRIP001 			if ( nX==nRefStartX )
//STRIP001 			{
//STRIP001 				nMinX = nPosX - 1;
//STRIP001 				bLeft = TRUE;
//STRIP001 			}
//STRIP001 			if ( nX==nRefEndX )
//STRIP001 			{
//STRIP001 				nMaxX = nPosX + pRowInfo[0].pCellInfo[nX+1].nWidth - 1;
//STRIP001 				bRight = TRUE;
//STRIP001 			}
//STRIP001 			nPosX += pRowInfo[0].pCellInfo[nX+1].nWidth;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( nMaxX >= nMinX && nMaxY >= nMinY )
//STRIP001 		{
//STRIP001 			if ( nType == SC_CAT_DELETE_ROWS )
//STRIP001 				bLeft = bRight = bBottom = FALSE;		//! dicke Linie ???
//STRIP001 			else if ( nType == SC_CAT_DELETE_COLS )
//STRIP001 				bTop = bBottom = bRight = FALSE;		//! dicke Linie ???
//STRIP001 
//STRIP001 			pDev->SetLineColor( rColor );
//STRIP001 			if (bTop && bBottom && bLeft && bRight)
//STRIP001 			{
//STRIP001 				pDev->SetFillColor();
//STRIP001 				pDev->DrawRect( Rectangle( nMinX, nMinY, nMaxX, nMaxY ) );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				if (bTop)
//STRIP001 				{
//STRIP001 					pDev->DrawLine( Point( nMinX,nMinY ), Point( nMaxX,nMinY ) );
//STRIP001 					if ( nType == SC_CAT_DELETE_ROWS )
//STRIP001 						pDev->DrawLine( Point( nMinX,nMinY+1 ), Point( nMaxX,nMinY+1 ) );
//STRIP001 				}
//STRIP001 				if (bBottom)
//STRIP001 					pDev->DrawLine( Point( nMinX,nMaxY ), Point( nMaxX,nMaxY ) );
//STRIP001 				if (bLeft)
//STRIP001 				{
//STRIP001 					pDev->DrawLine( Point( nMinX,nMinY ), Point( nMinX,nMaxY ) );
//STRIP001 					if ( nType == SC_CAT_DELETE_COLS )
//STRIP001 						pDev->DrawLine( Point( nMinX+1,nMinY ), Point( nMinX+1,nMaxY ) );
//STRIP001 				}
//STRIP001 				if (bRight)
//STRIP001 					pDev->DrawLine( Point( nMaxX,nMinY ), Point( nMaxX,nMaxY ) );
//STRIP001 			}
//STRIP001 			if ( bLeft && bTop )
//STRIP001 			{
//STRIP001 				pDev->SetLineColor();
//STRIP001 				pDev->SetFillColor( rColor );
//STRIP001 				pDev->DrawRect( Rectangle( nMinX+1, nMinY+1, nMinX+3, nMinY+3 ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScOutputData::DrawChangeTrack()
//STRIP001 {
//STRIP001 	ScChangeTrack* pTrack = pDoc->GetChangeTrack();
//STRIP001 	ScChangeViewSettings* pSettings = pDoc->GetChangeViewSettings();
//STRIP001 	if ( !pTrack || !pTrack->GetFirst() || !pSettings || !pSettings->ShowChanges() )
//STRIP001 		return;			// nix da oder abgeschaltet
//STRIP001 
//STRIP001 	ScActionColorChanger aColorChanger(*pTrack);
//STRIP001 
//STRIP001 	//	Clipping passiert von aussen
//STRIP001 	//!	ohne Clipping, nur betroffene Zeilen painten ??!??!?
//STRIP001 
//STRIP001 	USHORT nEndX = nX2;
//STRIP001 	USHORT nEndY = nY2;
//STRIP001 	if ( nEndX < MAXCOL ) ++nEndX;		// auch noch von der naechsten Zelle, weil die Markierung
//STRIP001 	if ( nEndY < MAXROW ) ++nEndY;		// in die jeweils vorhergehende Zelle hineinragt
//STRIP001 	ScRange aViewRange( nX1, nY1, nTab, nEndX, nEndY, nTab );
//STRIP001 	const ScChangeAction* pAction = pTrack->GetFirst();
//STRIP001 	while (pAction)
//STRIP001 	{
//STRIP001 		ScChangeActionType eType;
//STRIP001 		if ( pAction->IsVisible() )
//STRIP001 		{
//STRIP001 			eType = pAction->GetType();
//STRIP001 			const ScBigRange& rBig = pAction->GetBigRange();
//STRIP001 			if ( rBig.aStart.Tab() == nTab )
//STRIP001 			{
//STRIP001 				ScRange aRange = rBig.MakeRange();
//STRIP001 
//STRIP001 				if ( eType == SC_CAT_DELETE_ROWS )
//STRIP001 					aRange.aEnd.SetRow( aRange.aStart.Row() );
//STRIP001 				else if ( eType == SC_CAT_DELETE_COLS )
//STRIP001 					aRange.aEnd.SetCol( aRange.aStart.Col() );
//STRIP001 
//STRIP001 				if ( aRange.Intersects( aViewRange ) &&
//STRIP001 					 ScViewUtil::IsActionShown( *pAction, *pSettings, *pDoc ) )
//STRIP001 				{
//STRIP001 					aColorChanger.Update( *pAction );
//STRIP001 					Color aColor( aColorChanger.GetColor() );
//STRIP001 					DrawOneChange( aRange.aStart.Col(), aRange.aStart.Row(),
//STRIP001 									aRange.aEnd.Col(), aRange.aEnd.Row(), aColor, eType );
//STRIP001 
//STRIP001 				}
//STRIP001 			}
//STRIP001 			if ( eType == SC_CAT_MOVE &&
//STRIP001 					((const ScChangeActionMove*)pAction)->
//STRIP001 						GetFromRange().aStart.Tab() == nTab )
//STRIP001 			{
//STRIP001 				ScRange aRange = ((const ScChangeActionMove*)pAction)->
//STRIP001 						GetFromRange().MakeRange();
//STRIP001 				if ( aRange.Intersects( aViewRange ) &&
//STRIP001 					 ScViewUtil::IsActionShown( *pAction, *pSettings, *pDoc ) )
//STRIP001 				{
//STRIP001 					aColorChanger.Update( *pAction );
//STRIP001 					Color aColor( aColorChanger.GetColor() );
//STRIP001 					DrawOneChange( aRange.aStart.Col(), aRange.aStart.Row(),
//STRIP001 									aRange.aEnd.Col(), aRange.aEnd.Row(), aColor, eType );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		pAction = pAction->GetNext();
//STRIP001 	}
//STRIP001 }

/*N*/ void ScOutputData::DrawNoteMarks()
/*N*/ {
/*N*/ 	BOOL bFirst = TRUE;
/*N*/ 
/*N*/ 	long nPosY = nScrY;
/*N*/ 	for (USHORT nArrY=1; nArrY+1<nArrCount; nArrY++)
/*N*/ 	{
/*N*/ 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
/*N*/ 		if ( pThisRowInfo->bChanged )
/*N*/ 		{
/*?*/ 			long nPosX = nScrX;
/*?*/ 			for (USHORT nX=nX1; nX<=nX2; nX++)
/*?*/ 			{
/*?*/ 				CellInfo* pInfo = &pThisRowInfo->pCellInfo[nX+1];
/*?*/ 				ScBaseCell* pCell = pInfo->pCell;
/*?*/ 				BOOL bIsMerged = FALSE;
/*?*/ 
/*?*/ 				if ( nX==nX1 && pInfo->bHOverlapped && !pInfo->bVOverlapped )
/*?*/ 				{
/*?*/ 					// find start of merged cell
/*?*/ 					bIsMerged = TRUE;
/*?*/ 					USHORT nY = pRowInfo[nArrY].nRowNo;
/*?*/ 					USHORT nMergeX = nX;
/*?*/ 					USHORT nMergeY = nY;
/*?*/ 					pDoc->ExtendOverlapped( nMergeX, nMergeY, nX, nY, nTab );
/*?*/ 					pCell = pDoc->GetCell( ScAddress(nMergeX,nMergeY,nTab) );
/*?*/ 					// use origin's pCell for NotePtr test below
/*?*/ 				}
/*?*/ 
/*?*/ 				if ( pCell && pCell->GetNotePtr() && ( bIsMerged ||
/*?*/ 						( !pInfo->bHOverlapped && !pInfo->bVOverlapped ) ) )
/*?*/ 				{
/*?*/ 					if (bFirst)
/*?*/ 					{
/*?*/ 						pDev->SetLineColor();
/*?*/ 
/*?*/ 						const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
/*?*/ 						if ( bUseStyleColor && rStyleSettings.GetHighContrastMode() )
/*?*/                             pDev->SetFillColor( SC_MOD()->GetColorConfig().GetColorValue(svtools::FONTCOLOR).nColor );
/*?*/ 						else
/*?*/ 							pDev->SetFillColor(COL_LIGHTRED);
/*?*/ 
/*?*/ 						bFirst = FALSE;
/*?*/ 					}
/*?*/ 
/*?*/ 					long nMarkX = nPosX + pRowInfo[0].pCellInfo[nX+1].nWidth - 4;
/*?*/ 					if ( bIsMerged || pInfo->bMerged )
/*?*/ 					{
/*?*/ 						//	if merged, add widths of all cells
/*?*/ 						USHORT nNextX = nX + 1;
/*?*/ 						while ( nNextX <= nX2 + 1 && pThisRowInfo->pCellInfo[nNextX+1].bHOverlapped )
/*?*/ 						{
/*?*/ 							nMarkX += pRowInfo[0].pCellInfo[nNextX+1].nWidth;
/*?*/ 							++nNextX;
/*?*/ 						}
/*?*/ 					}
/*?*/ 					if ( nMarkX < nScrX+nScrW )
/*?*/ 						pDev->DrawRect( Rectangle( nMarkX,nPosY,nMarkX+2,nPosY+2 ) );
/*?*/ 				}
/*?*/ 
/*?*/ 				nPosX += pRowInfo[0].pCellInfo[nX+1].nWidth;
/*?*/ 			}
/*N*/ 		}
/*N*/ 		nPosY += pThisRowInfo->nHeight;
/*N*/ 	}
/*N*/ }

//STRIP001 long lcl_FindInList( const List& rPosList, const ScTripel &rPos )
//STRIP001 {
//STRIP001 	long nCount = rPosList.Count();
//STRIP001 	for (long i=0; i<nCount; i++)
//STRIP001 		if (*(ScTripel*)rPosList.GetObject(i) == rPos)
//STRIP001 			return i+1;
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 void ScOutputData::PrintNoteMarks( const List& rPosList )
//STRIP001 {
//STRIP001 	Font aFont;
//STRIP001 	ScAutoFontColorMode eColorMode = bUseStyleColor ?
//STRIP001 										( bForceAutoColor ? SC_AUTOCOL_IGNOREFONT : SC_AUTOCOL_DISPLAY ) :
//STRIP001 										SC_AUTOCOL_PRINT;
//STRIP001 	((const ScPatternAttr&)pDoc->GetPool()->GetDefaultItem(ATTR_PATTERN)).GetFont(aFont, eColorMode);
//STRIP001 	aFont.SetSize( Size( 0, (long) ( 120 * nPPTY ) ) );			// 6 pt
//STRIP001 	pDev->SetFont( aFont );
//STRIP001 
//STRIP001 	String aStr;
//STRIP001 
//STRIP001 	long nPosY = nScrY;
//STRIP001 	for (USHORT nArrY=1; nArrY+1<nArrCount; nArrY++)
//STRIP001 	{
//STRIP001 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
//STRIP001 		if ( pThisRowInfo->bChanged )
//STRIP001 		{
//STRIP001 			long nPosX = nScrX;
//STRIP001 			for (USHORT nX=nX1; nX<=nX2; nX++)
//STRIP001 			{
//STRIP001 				CellInfo* pInfo = &pThisRowInfo->pCellInfo[nX+1];
//STRIP001 				ScBaseCell* pCell = pInfo->pCell;
//STRIP001 				if ( pCell && pCell->GetNotePtr() )		// auch verdeckte wegen der Numerierung
//STRIP001 				{
//STRIP001 					aStr = lcl_FindInList( rPosList, ScTripel( nX, pThisRowInfo->nRowNo, nTab ) );
//STRIP001 					long nMarkX = nPosX + pRowInfo[0].pCellInfo[nX+1].nWidth - 2 -
//STRIP001 									pDev->GetTextWidth(aStr);
//STRIP001 					pDev->DrawText( Point( nMarkX,nPosY ), aStr );
//STRIP001 				}
//STRIP001 
//STRIP001 				nPosX += pRowInfo[0].pCellInfo[nX+1].nWidth;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		nPosY += pThisRowInfo->nHeight;
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScOutputData::ConnectObject( const SvInPlaceObjectRef& rRef, SdrOle2Obj* pOleObj )
//STRIP001 {
//STRIP001 	if (rRef.Is())
//STRIP001 	{
//STRIP001 		ULONG nMisc = rRef->GetMiscStatus();
//STRIP001 		if ( nMisc & SVOBJ_MISCSTATUS_ACTIVATEWHENVISIBLE )
//STRIP001 			pViewShell->ConnectObject( pOleObj );
//STRIP001 	}
//STRIP001 }

/*M*/ void ScOutputData::DrawClipMarks()
/*M*/ {
/*M*/ 	if (!bAnyClipped)
/*M*/ 		return;
/*M*/ 
/*M*/ 	Color aArrowFillCol( COL_LIGHTRED );
/*M*/ 
/*M*/ 	ULONG nOldDrawMode = pDev->GetDrawMode();
/*M*/ 	const StyleSettings& rStyleSettings = Application::GetSettings().GetStyleSettings();
/*M*/ 	if ( bUseStyleColor && rStyleSettings.GetHighContrastMode() )
/*M*/ 	{
/*M*/ 		//	use DrawMode to change the arrow's outline color
/*M*/ 		pDev->SetDrawMode( nOldDrawMode | DRAWMODE_SETTINGSLINE );
/*M*/ 		//	use text color also for the fill color
/*N*/         aArrowFillCol.SetColor( SC_MOD()->GetColorConfig().GetColorValue(svtools::FONTCOLOR).nColor );
/*N*/ 	}
/*N*/ 
/*N*/ 	Rectangle aCellRect;
/*N*/ 	long nPosY = nScrY;
/*N*/ 	for (USHORT nArrY=1; nArrY+1<nArrCount; nArrY++)
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 		RowInfo* pThisRowInfo = &pRowInfo[nArrY];
//STRIP001 /*?*/ 		if ( pThisRowInfo->bChanged )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			USHORT nY = pThisRowInfo->nRowNo;
//STRIP001 /*?*/ 			long nPosX = nScrX;
//STRIP001 /*?*/ 			for (USHORT nX=nX1; nX<=nX2; nX++)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				CellInfo* pInfo = &pThisRowInfo->pCellInfo[nX+1];
//STRIP001 /*?*/ 				if (pInfo->bStandard)	//! umbenennen in bClipped
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					if (pInfo->bHOverlapped || pInfo->bVOverlapped)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						//	merge origin may be outside of visible area - use document functions
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						USHORT nOverX = nX;
//STRIP001 /*?*/ 						USHORT nOverY = nY;
//STRIP001 /*?*/ 						long nStartPosX = nPosX;
//STRIP001 /*?*/ 						long nStartPosY = nPosY;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						while ( nOverX > 0 && ( ((const ScMergeFlagAttr*)pDoc->GetAttr(
//STRIP001 /*?*/ 								nOverX, nOverY, nTab, ATTR_MERGE_FLAG ))->GetValue() & SC_MF_HOR ) )
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							--nOverX;
//STRIP001 /*?*/ 							nStartPosX -= (long) ( pDoc->GetColWidth(nOverX,nTab) * nPPTX );
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						while ( nOverY > 0 && ( ((const ScMergeFlagAttr*)pDoc->GetAttr(
//STRIP001 /*?*/ 								nOverX, nOverY, nTab, ATTR_MERGE_FLAG ))->GetValue() & SC_MF_VER ) )
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							--nOverY;
//STRIP001 /*?*/ 							nStartPosY -= (long) ( pDoc->GetRowHeight(nOverY,nTab) * nPPTY );
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						long nOutWidth = (long) ( pDoc->GetColWidth(nOverX,nTab) * nPPTX );
//STRIP001 /*?*/ 						long nOutHeight = (long) ( pDoc->GetRowHeight(nOverY,nTab) * nPPTY );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						USHORT i;
//STRIP001 /*?*/ 						const ScMergeAttr* pMerge = (const ScMergeAttr*)
//STRIP001 /*?*/ 									pDoc->GetAttr( nOverX, nOverY, nTab, ATTR_MERGE );
//STRIP001 /*?*/ 						USHORT nCountX = pMerge->GetColMerge();
//STRIP001 /*?*/ 						for (i=1; i<nCountX; i++)
//STRIP001 /*?*/ 							nOutWidth += (long) ( pDoc->GetColWidth(nOverX+i,nTab) * nPPTX );
//STRIP001 /*?*/ 						USHORT nCountY = pMerge->GetRowMerge();
//STRIP001 /*?*/ 						for (i=1; i<nCountY; i++)
//STRIP001 /*?*/ 							nOutHeight += (long) ( pDoc->GetRowHeight(nOverY+i,nTab) * nPPTY );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						aCellRect = Rectangle( Point( nStartPosX, nStartPosY ), Size( nOutWidth, nOutHeight ) );
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						long nOutWidth = pRowInfo[0].pCellInfo[nX+1].nWidth;
//STRIP001 /*?*/ 						long nOutHeight = pThisRowInfo->nHeight;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if ( pInfo->bMerged && pInfo->pPatternAttr )
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							USHORT nOverX = nX;
//STRIP001 /*?*/ 							USHORT nOverY = nY;
//STRIP001 /*?*/ 							USHORT i;
//STRIP001 /*?*/ 							const ScMergeAttr* pMerge =
//STRIP001 /*?*/ 									(ScMergeAttr*)&pInfo->pPatternAttr->GetItem(ATTR_MERGE);
//STRIP001 /*?*/ 							USHORT nCountX = pMerge->GetColMerge();
//STRIP001 /*?*/ 							for (i=1; i<nCountX; i++)
//STRIP001 /*?*/ 								nOutWidth += (long) ( pDoc->GetColWidth(nOverX+i,nTab) * nPPTX );
//STRIP001 /*?*/ 							USHORT nCountY = pMerge->GetRowMerge();
//STRIP001 /*?*/ 							for (i=1; i<nCountY; i++)
//STRIP001 /*?*/ 								nOutHeight += (long) ( pDoc->GetRowHeight(nOverY+i,nTab) * nPPTY );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						aCellRect = Rectangle( Point( nPosX, nPosY ), Size( nOutWidth, nOutHeight ) );
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					long nMarkPixel = (long)( SC_CLIPMARK_SIZE * nPPTX );
//STRIP001 /*?*/ 					Size aMarkSize( nMarkPixel, (nMarkPixel-1)*2 );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					Rectangle aMarkRect = aCellRect;
//STRIP001 /*?*/ 					aMarkRect.Left() = aCellRect.Right()-nMarkPixel;
//STRIP001 /*?*/ 					aMarkRect.Bottom() -= 1;	// nicht das Gitter uebermalen
//STRIP001 /*?*/ 					aMarkRect.Right() -= 1;
//STRIP001 /*?*/ #if 0
//STRIP001 /*?*/ 					//!	Test
//STRIP001 /*?*/ 					pDev->SetLineColor(); pDev->SetFillColor(COL_LIGHTGREEN);
//STRIP001 /*?*/ 					pDev->DrawRect(aMarkRect);
//STRIP001 /*?*/ 					//!	Test
//STRIP001 /*?*/ #endif
//STRIP001 /*?*/ 					SvxFont::DrawArrow( *pDev, aMarkRect, aMarkSize, aArrowFillCol, FALSE );
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				nPosX += pRowInfo[0].pCellInfo[nX+1].nWidth;
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		nPosY += pThisRowInfo->nHeight;
/*N*/ 	}
/*N*/ 
/*N*/ 	pDev->SetDrawMode(nOldDrawMode);
/*N*/ }



}
