/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_drawview.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:25:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

#include <bf_svx/svditer.hxx>
#include <bf_svx/svdograf.hxx>
#include <bf_svx/svdogrp.hxx>
#include <bf_svx/svdoole2.hxx>
#include <bf_svx/svdouno.hxx>
#include <bf_svx/svdpage.hxx>
#include <bf_svx/svdundo.hxx>
#include <bf_svx/svdvmark.hxx>
#include <bf_svx/xoutx.hxx>
#include <bf_sfx2/bindings.hxx>
#include <bf_sfx2/ipfrm.hxx>
#include <so3/ipobj.hxx>
#include <so3/pseudo.hxx>

#include "drawview.hxx"
#include "global.hxx"
#include "viewdata.hxx"
#include "document.hxx"
#include "drawutil.hxx"
#include "globstr.hrc"
#include "tabvwsh.hxx"
#include "client.hxx"
#include "scmod.hxx"
#include "drwlayer.hxx"
#include "docsh.hxx"
#include "viewuno.hxx"

#include "bf_sc.hrc"
namespace binfilter {

using namespace ::com::sun::star;

// -----------------------------------------------------------------------

#define SC_HANDLESIZE_BIG		9
#define SC_HANDLESIZE_SMALL		7

// -----------------------------------------------------------------------


#ifdef WNT
#pragma optimize ( "", off )
#endif


/*N*/ void ScDrawView::Construct()
/*N*/ {
/*N*/ 	EnableExtendedKeyInputDispatcher(FALSE);
/*N*/ 	EnableExtendedMouseEventDispatcher(FALSE);
/*N*/ 	EnableExtendedCommandEventDispatcher(FALSE);
/*N*/ 
/*N*/ 	SetFrameDragSingles(TRUE);
/*N*/ //	SetSolidMarkHdl(TRUE);				// einstellbar -> UpdateUserViewOptions
/*N*/ 
/*N*/ 	SetMinMoveDistancePixel( 2 );
/*N*/ 	SetHitTolerancePixel( 2 );
/*N*/ 
/*N*/ 	if (pViewData)
/*N*/ 	{
/*N*/ 		USHORT nTab = pViewData->GetTabNo();
/*N*/ 		ShowPagePgNum( nTab, Point() );
/*N*/ 
/*N*/ 		BOOL bEx = pViewData->GetViewShell()->IsDrawSelMode();
/*N*/ 		BOOL bProt = pDoc->IsTabProtected( nTab ) ||
/*N*/ 					 pViewData->GetSfxDocShell()->IsReadOnly();
/*N*/ 
/*N*/ 		SdrLayer* pLayer;
/*N*/ 		SdrLayerAdmin& rAdmin = GetModel()->GetLayerAdmin();
/*N*/ 		pLayer = rAdmin.GetLayerPerID(SC_LAYER_BACK);
/*N*/ 		if (pLayer)
/*N*/ 			SetLayerLocked( pLayer->GetName(), bProt || !bEx );
/*N*/ 		pLayer = rAdmin.GetLayerPerID(SC_LAYER_INTERN);
/*N*/ 		if (pLayer)
/*N*/ 			SetLayerLocked( pLayer->GetName(), TRUE );
/*N*/ 		pLayer = rAdmin.GetLayerPerID(SC_LAYER_FRONT);
/*N*/ 		if (pLayer)
/*N*/ 		{
/*N*/ 			SetLayerLocked( pLayer->GetName(), bProt );
/*N*/ 			SetActiveLayer( pLayer->GetName() );		// FRONT als aktiven Layer setzen
/*N*/ 		}
/*N*/ 		pLayer = rAdmin.GetLayerPerID(SC_LAYER_CONTROLS);
/*N*/ 		if (pLayer)
/*N*/ 			SetLayerLocked( pLayer->GetName(), bProt );
/*N*/ 
/*N*/ 		SetSwapAsynchron(TRUE);
/*N*/ 	}
/*N*/ 	else
/*?*/ 		ShowPagePgNum( nTab, Point() );
/*N*/ 
/*N*/ 	UpdateUserViewOptions();
/*N*/ 	RecalcScale();
/*N*/ 	UpdateWorkArea();
/*N*/ 
/*N*/ 	bInConstruct = FALSE;
/*N*/ }

/*N*/ __EXPORT ScDrawView::~ScDrawView()
/*N*/ {
/*N*/ 	delete pDropMarker;
/*N*/ }

/*N*/ void ScDrawView::AddCustomHdl()
/*N*/ {
/*N*/ 	const SdrMarkList &rMrkList = GetMarkList();
/*N*/ 	UINT32 nCount = rMrkList.GetMarkCount();
/*N*/ 	for(UINT32 nPos=0; nPos<nCount; nPos++ )
/*N*/ 	{
/*?*/ 		const SdrObject* pObj = rMrkList.GetMark(nPos)->GetObj();
/*?*/ 		if(ScDrawLayer::GetAnchor(pObj) == SCA_CELL)
/*N*/ 		{
				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 			const INT32 nDelta = 1;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Point aPos = pObj->GetBoundRect().TopLeft();
//STRIP001 /*?*/ 			long nPosX = (long) (aPos.X() / HMM_PER_TWIPS) + nDelta;
//STRIP001 /*?*/ 			long nPosY = (long) (aPos.Y() / HMM_PER_TWIPS) + nDelta;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			UINT16 nCol;
//STRIP001 /*?*/ 			INT32 nWidth = 0;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			for(nCol=0; nCol<=MAXCOL && nWidth<=nPosX; nCol++)
//STRIP001 /*?*/ 				nWidth += pDoc->GetColWidth(nCol,nTab);
//STRIP001 /*?*/ 			
//STRIP001 /*?*/ 			if(nCol)
//STRIP001 /*?*/ 				--nCol;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			UINT16 nRow;
//STRIP001 /*?*/ 			INT32 nHeight = 0;
//STRIP001 /*?*/ 			
//STRIP001 /*?*/ 			for(nRow=0; nRow<=MAXROW && nHeight<=nPosY; nRow++)
//STRIP001 /*?*/ 				nHeight += pDoc->FastGetRowHeight(nRow,nTab);
//STRIP001 /*?*/ 			
//STRIP001 /*?*/ 			if(nRow)
//STRIP001 /*?*/ 				--nRow;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			ScTabView* pView = pViewData->GetView();
//STRIP001 /*?*/ 			ScAddress aScAddress(nCol, nRow, nTab);
//STRIP001 /*?*/ 			pView->CreateAnchorHandles(aHdl, aScAddress);
/*N*/ 		}
/*N*/ 	}
/*N*/ }

/*N*/ void ScDrawView::InvalidateAttribs()
/*N*/ {
/*N*/ 	if (!pViewData) return;
/*N*/ 	SfxBindings& rBindings = pViewData->GetBindings();
/*N*/ 
/*N*/ 		// echte Statuswerte:
/*N*/ 
/*N*/ 	rBindings.Invalidate( SID_ATTR_FILL_STYLE );
/*N*/ 	rBindings.Invalidate( SID_ATTR_FILL_COLOR );
/*N*/ 
/*N*/ 	rBindings.Invalidate( SID_ATTR_LINE_STYLE );
/*N*/ 	rBindings.Invalidate( SID_ATTR_LINE_WIDTH );
/*N*/ 	rBindings.Invalidate( SID_ATTR_LINE_COLOR );
/*N*/ 
/*N*/ 	rBindings.Invalidate( SID_ANCHOR_PAGE );
/*N*/ 	rBindings.Invalidate( SID_ANCHOR_CELL );
/*N*/ 
/*N*/ 	rBindings.Invalidate( SID_OLE_OBJECT );
/*N*/ 	rBindings.Invalidate( SID_OPENDLG_MODCHART );
/*N*/ 
/*N*/ 	rBindings.Invalidate( SID_HYPERLINK_GETLINK );
/*N*/ 
/*N*/ 		// Funktionen, die nicht immer moeglich sind:
/*N*/ 
/*N*/ 	rBindings.Invalidate( SID_ATTRIBUTES_LINE );
/*N*/ 	rBindings.Invalidate( SID_ATTRIBUTES_AREA );
/*N*/ 	rBindings.Invalidate( SID_ATTR_LINEEND_STYLE );		// Tbx-Controller
/*N*/ 
/*N*/ 	rBindings.Invalidate( SID_GROUP );
/*N*/ 	rBindings.Invalidate( SID_UNGROUP );
/*N*/ 	rBindings.Invalidate( SID_ENTER_GROUP );
/*N*/ 	rBindings.Invalidate( SID_LEAVE_GROUP );
/*N*/ 	rBindings.Invalidate( SID_MIRROR_HORIZONTAL );
/*N*/ 	rBindings.Invalidate( SID_MIRROR_VERTICAL );
/*N*/ 
/*N*/ 	rBindings.Invalidate( SID_IMAP_EXEC );
/*N*/ 
/*N*/ 	rBindings.Invalidate( SID_FRAME_UP );
/*N*/ 	rBindings.Invalidate( SID_FRAME_DOWN );
/*N*/ 	rBindings.Invalidate( SID_FRAME_TO_TOP );
/*N*/ 	rBindings.Invalidate( SID_FRAME_TO_BOTTOM );
/*N*/ 	rBindings.Invalidate( SID_OBJECT_HEAVEN );
/*N*/ 	rBindings.Invalidate( SID_OBJECT_HELL );
/*N*/ 
/*N*/ 	rBindings.Invalidate( SID_OBJECT_ALIGN_LEFT );
/*N*/ 	rBindings.Invalidate( SID_OBJECT_ALIGN_CENTER );
/*N*/ 	rBindings.Invalidate( SID_OBJECT_ALIGN_RIGHT );
/*N*/ 	rBindings.Invalidate( SID_OBJECT_ALIGN_UP );
/*N*/ 	rBindings.Invalidate( SID_OBJECT_ALIGN_MIDDLE );
/*N*/ 	rBindings.Invalidate( SID_OBJECT_ALIGN_DOWN );
/*N*/ 
/*N*/ 	rBindings.Invalidate( SID_DELETE );
/*N*/ 	rBindings.Invalidate( SID_DELETE_CONTENTS );
/*N*/ 	rBindings.Invalidate( SID_CUT );
/*N*/ 	rBindings.Invalidate( SID_COPY );
/*N*/ 
/*N*/ 	rBindings.Invalidate( SID_ANCHOR_TOGGLE );
/*N*/ 	rBindings.Invalidate( SID_ORIGINALSIZE );
/*N*/ 	rBindings.Invalidate( SID_RENAME_OBJECT );
/*N*/ 
/*N*/ 	rBindings.Invalidate( SID_ATTR_TRANSFORM );
/*N*/ 
/*N*/ 	rBindings.Invalidate( SID_ATTR_GRAF_MODE );
/*N*/ 	rBindings.Invalidate( SID_ATTR_GRAF_RED );
/*N*/ 	rBindings.Invalidate( SID_ATTR_GRAF_GREEN );
/*N*/ 	rBindings.Invalidate( SID_ATTR_GRAF_BLUE );
/*N*/ 	rBindings.Invalidate( SID_ATTR_GRAF_LUMINANCE );
/*N*/ 	rBindings.Invalidate( SID_ATTR_GRAF_CONTRAST );
/*N*/ 	rBindings.Invalidate( SID_ATTR_GRAF_GAMMA );
/*N*/ 	rBindings.Invalidate( SID_ATTR_GRAF_TRANSPARENCE );
/*N*/ 
/*N*/ 	rBindings.Invalidate( SID_GRFFILTER );
/*N*/ 	rBindings.Invalidate( SID_GRFFILTER_INVERT );
/*N*/ 	rBindings.Invalidate( SID_GRFFILTER_SMOOTH );
/*N*/ 	rBindings.Invalidate( SID_GRFFILTER_SHARPEN );
/*N*/ 	rBindings.Invalidate( SID_GRFFILTER_REMOVENOISE );
/*N*/ 	rBindings.Invalidate( SID_GRFFILTER_SOBEL );
/*N*/ 	rBindings.Invalidate( SID_GRFFILTER_MOSAIC );
/*N*/ 	rBindings.Invalidate( SID_GRFFILTER_EMBOSS );
/*N*/ 	rBindings.Invalidate( SID_GRFFILTER_POSTER );
/*N*/ 	rBindings.Invalidate( SID_GRFFILTER_POPART );
/*N*/ 	rBindings.Invalidate( SID_GRFFILTER_SEPIA );
/*N*/ 	rBindings.Invalidate( SID_GRFFILTER_SOLARIZE );
/*N*/ 
/*N*/ 	rBindings.Invalidate( SID_ENABLE_HYPHENATION );
/*N*/ }

/*M*/ void ScDrawView::InvalidateDrawTextAttrs()
/*M*/ {
/*M*/ 	if (!pViewData) return;
/*M*/ 	SfxBindings& rBindings = pViewData->GetBindings();
/*M*/ 
/*M*/ 	//	cjk/ctl font items have no configured slots,
/*M*/ 	//	need no invalidate
/*M*/ 
/*M*/ 	rBindings.Invalidate( SID_ATTR_CHAR_FONT );
/*M*/ 	rBindings.Invalidate( SID_ATTR_CHAR_FONTHEIGHT );
/*M*/ 	rBindings.Invalidate( SID_ATTR_CHAR_WEIGHT );
/*M*/ 	rBindings.Invalidate( SID_ATTR_CHAR_POSTURE );
/*M*/ 	rBindings.Invalidate( SID_ATTR_CHAR_UNDERLINE );
/*M*/ 	rBindings.Invalidate( SID_ULINE_VAL_NONE );
/*M*/ 	rBindings.Invalidate( SID_ULINE_VAL_SINGLE );
/*M*/ 	rBindings.Invalidate( SID_ULINE_VAL_DOUBLE );
/*M*/ 	rBindings.Invalidate( SID_ULINE_VAL_DOTTED );
/*M*/ 	rBindings.Invalidate( SID_ATTR_CHAR_COLOR );
/*M*/ 	rBindings.Invalidate( SID_ALIGNLEFT );
/*M*/ 	rBindings.Invalidate( SID_ALIGNCENTERHOR );
/*M*/ 	rBindings.Invalidate( SID_ALIGNRIGHT );
/*M*/ 	rBindings.Invalidate( SID_ALIGNBLOCK );
/*M*/ 	rBindings.Invalidate( SID_ATTR_PARA_LINESPACE_10 );
/*M*/ 	rBindings.Invalidate( SID_ATTR_PARA_LINESPACE_15 );
/*M*/ 	rBindings.Invalidate( SID_ATTR_PARA_LINESPACE_20 );
/*M*/ 	rBindings.Invalidate( SID_SET_SUPER_SCRIPT );
/*M*/ 	rBindings.Invalidate( SID_SET_SUB_SCRIPT );
/*M*/ 	rBindings.Invalidate( SID_TEXTDIRECTION_LEFT_TO_RIGHT );
/*M*/ 	rBindings.Invalidate( SID_TEXTDIRECTION_TOP_TO_BOTTOM );
/*M*/ 	rBindings.Invalidate( SID_ATTR_PARA_LEFT_TO_RIGHT );
/*M*/ 	rBindings.Invalidate( SID_ATTR_PARA_RIGHT_TO_LEFT );
/*M*/ }

/*N*/ void ScDrawView::DrawMarks( OutputDevice* pOut ) const
/*N*/ {
/*N*/ //	if (IsMarkHdlShown())
/*N*/ //		DrawMarkHdl(pOut,FALSE);
/*N*/ 
/*N*/ 	USHORT nWinNum = ((ScDrawView*)this)->FindWin(pOut);		//! DrawMarks nicht-const
/*N*/ 	if (nWinNum!=SDRVIEWWIN_NOTFOUND)
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 ((ScDrawView*)this)->AfterInitRedraw(nWinNum);			//! DrawMarks nicht-const
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if (IsShownXorVisibleWinNum(nWinNum))
//STRIP001 /*?*/ 			((ScDrawView*)this)->ToggleShownXor(pOut,NULL);		//! DrawMarks nicht-const
/*N*/ 	}
/*N*/ }

//STRIP001 void ScDrawView::SetMarkedToLayer( BYTE nLayerNo )
//STRIP001 {
//STRIP001 	if (HasMarkedObj())
//STRIP001 	{
//STRIP001 		//	#i11702# use SdrUndoObjectLayerChange for undo
//STRIP001 		//	STR_UNDO_SELATTR is "Attributes" - should use a different text later
//STRIP001 		BegUndo( ScGlobal::GetRscString( STR_UNDO_SELATTR ) );
//STRIP001 
//STRIP001 		const SdrMarkList& rMark = GetMarkList();
//STRIP001 		ULONG nCount = rMark.GetMarkCount();
//STRIP001 		for (ULONG i=0; i<nCount; i++)
//STRIP001 		{
//STRIP001 			SdrObject* pObj = rMark.GetMark(i)->GetObj();
//STRIP001 			if ( !pObj->ISA(SdrUnoObj) )
//STRIP001 			{
//STRIP001 				AddUndo( new SdrUndoObjectLayerChange( *pObj, pObj->GetLayer(), (SdrLayerID)nLayerNo) );
//STRIP001 				pObj->SetLayer( nLayerNo );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		EndUndo();
//STRIP001 
//STRIP001 		//	repaint is done in SetLayer
//STRIP001 
//STRIP001 		pViewData->GetDocShell()->SetDrawModified();
//STRIP001 
//STRIP001 		//	#84073# check mark list now instead of later in a timer
//STRIP001 		CheckMarked();
//STRIP001 		MarkListHasChanged();
//STRIP001 	}
//STRIP001 }

//STRIP001 BOOL ScDrawView::HasMarkedControl() const
//STRIP001 {
//STRIP001 	if (HasMarkedObj())
//STRIP001 	{
//STRIP001 		const SdrMarkList& rMark = GetMarkList();
//STRIP001 		ULONG nCount = rMark.GetMarkCount();
//STRIP001 		for (ULONG i=0; i<nCount; i++)
//STRIP001 		{
//STRIP001 			SdrObject* pObj = rMark.GetMark(i)->GetObj();
//STRIP001 			if ( pObj->ISA(SdrUnoObj) )
//STRIP001 				return TRUE;
//STRIP001 			else if ( pObj->ISA(SdrObjGroup) )
//STRIP001 			{
//STRIP001 				SdrObjListIter aIter( *pObj, IM_DEEPWITHGROUPS );
//STRIP001 				SdrObject* pSubObj = aIter.Next();
//STRIP001 				while (pSubObj)
//STRIP001 				{
//STRIP001 					if ( pSubObj->ISA(SdrUnoObj) )
//STRIP001 						return TRUE;
//STRIP001 					pSubObj = aIter.Next();
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return FALSE;		// war nix
//STRIP001 }

/*N*/ void ScDrawView::UpdateWorkArea()
/*N*/ {
/*N*/ 	SdrPage* pPage = GetModel()->GetPage(nTab);
/*N*/ 	if (pPage)
/*N*/ 		SetWorkArea( Rectangle( Point(), pPage->GetSize() ) );
/*N*/ 	else
/*N*/ 		DBG_ERROR("Page nicht gefunden");
/*N*/ }

//STRIP001 void ScDrawView::DoCut()
//STRIP001 {
//STRIP001 	DoCopy();
//STRIP001 	BegUndo( ScGlobal::GetRscString( STR_UNDO_CUT ) );
//STRIP001 	DeleteMarked();		// auf dieser View - von der 505f Umstellung nicht betroffen
//STRIP001 	EndUndo();
//STRIP001 }

/*N*/ void ScDrawView::GetScale( Fraction& rFractX, Fraction& rFractY ) const
/*N*/ {
/*N*/ 	rFractX = aScaleX;
/*N*/ 	rFractY = aScaleY;
/*N*/ }

/*N*/ void ScDrawView::RecalcScale()
/*N*/ {
/*N*/ 	double nPPTX;
/*N*/ 	double nPPTY;
/*N*/ 	Fraction aZoomX(1,1);
/*N*/ 	Fraction aZoomY(1,1);
/*N*/ 
/*N*/ 	if (pViewData)
/*N*/ 	{
/*N*/ 		nTab = pViewData->GetTabNo();
/*N*/ 		nPPTX = pViewData->GetPPTX();
/*N*/ 		nPPTY = pViewData->GetPPTY();
/*N*/ 		aZoomX = pViewData->GetZoomX();
/*N*/ 		aZoomY = pViewData->GetZoomY();
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*?*/ 		Point aLogic = pDev->LogicToPixel( Point(1000,1000), MAP_TWIP );
/*?*/ 		nPPTX = aLogic.X() / 1000.0;
/*?*/ 		nPPTY = aLogic.Y() / 1000.0;
/*?*/ 											//! Zoom uebergeben ???
/*N*/ 	}
/*N*/ 
/*N*/ 	USHORT nEndCol = 0;
/*N*/ 	USHORT nEndRow = 0;
/*N*/ 	pDoc->GetTableArea( nTab, nEndCol, nEndRow );
/*N*/ 	if (nEndCol<20)
/*N*/ 		nEndCol = 20;
/*N*/ 	if (nEndRow<20)
/*N*/ 		nEndRow = 20;
/*N*/ 
/*N*/ 	ScDrawUtil::CalcScale( pDoc, nTab, 0,0, nEndCol,nEndRow, pDev,aZoomX,aZoomY,nPPTX,nPPTY,
/*N*/ 							aScaleX,aScaleY );
/*N*/ }

//STRIP001 void ScDrawView::PaintObject( SdrObject* pObject, OutputDevice* pDev ) const
//STRIP001 {
//STRIP001 	pXOut->SetOutDev( pDev );
//STRIP001 	SdrPaintInfoRec aInfoRec;
//STRIP001 	pObject->Paint( *pXOut, aInfoRec );
//STRIP001 }

/*N*/ void __EXPORT ScDrawView::MarkListHasChanged()
/*N*/ {
/*N*/ 	FmFormView::MarkListHasChanged();
/*N*/ 
/*N*/ 	UpdateBrowser();
/*N*/ 
/*N*/ 	ScTabViewShell* pViewSh = pViewData->GetViewShell();
/*N*/ 
/*N*/ 	if (!bInConstruct)			// nicht wenn die View gerade angelegt wird
/*N*/ 	{
/*?*/ 		pViewSh->Unmark();		// Selektion auff'm Doc entfernen
/*?*/ 
/*?*/ 		//	#65379# end cell edit mode if drawing objects are selected
/*?*/ 		if ( GetMarkList().GetMarkCount() )
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 SC_MOD()->InputEnterHandler();
/*N*/ 	}
/*N*/ 
/*N*/ 	//	IP deaktivieren
/*N*/ 
/*N*/ 	ScClient* pClient = (ScClient*) pViewSh->GetIPClient();
/*N*/ 	if ( pClient && pClient->IsInPlaceActive() )
/*N*/ 	{
/*?*/ 		//	#41730# beim ViewShell::Activate aus dem Reset2Open nicht die Handles anzeigen
/*?*/ 		bDisableHdl = TRUE;
/*?*/ 
/*?*/ 		pClient->GetProtocol().Reset2Open();
/*?*/ 		SFX_APP()->SetViewFrame(pViewSh->GetViewFrame());
/*?*/ 
/*?*/ 		bDisableHdl = FALSE;
/*?*/ 
/*?*/ 		//	Image-Ole wieder durch Grafik ersetzen passiert jetzt in ScClient::UIActivate
/*N*/ 	}
/*N*/ 
/*N*/ 	//	Ole-Objekt selektiert?
/*N*/ 
/*N*/ 	SdrOle2Obj* pOle2Obj = NULL;
/*N*/ 	SdrGrafObj* pGrafObj = NULL;
/*N*/ 
/*N*/ 	const SdrMarkList& rMarkList = GetMarkList();
/*N*/ 	ULONG nMarkCount = rMarkList.GetMarkCount();
/*N*/ 
/*N*/ 	if ( nMarkCount == 0 && !pViewData->GetViewShell()->IsDrawSelMode() && !bInConstruct )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 //	re-lock background layer if it was unlocked in SelectObject
//STRIP001 /*?*/ 		SdrLayer* pLayer = GetModel()->GetLayerAdmin().GetLayerPerID(SC_LAYER_BACK);
//STRIP001 /*?*/ 		if ( pLayer && !IsLayerLocked( pLayer->GetName() ) )
//STRIP001 /*?*/ 			SetLayerLocked( pLayer->GetName(), TRUE );
/*N*/ 	}
/*N*/ 
/*N*/ 	BOOL bSubShellSet = FALSE;
/*N*/ 	if (nMarkCount == 1)
/*N*/ 	{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 		SdrObject* pObj = rMarkList.GetMark(0)->GetObj();
//STRIP001 /*?*/ 		if (pObj->GetObjIdentifier() == OBJ_OLE2)
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			pOle2Obj = (SdrOle2Obj*) pObj;
//STRIP001 /*?*/ 			if (!pDoc->IsChart(pObj) )
//STRIP001 /*?*/ 				pViewSh->SetOleObjectShell(TRUE);
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 				pViewSh->SetChartShell(TRUE);
//STRIP001 /*?*/ 			bSubShellSet = TRUE;
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		else if (pObj->GetObjIdentifier() == OBJ_GRAF)
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			pGrafObj = (SdrGrafObj*) pObj;
//STRIP001 /*?*/ 			pViewSh->SetGraphicShell(TRUE);
//STRIP001 /*?*/ 			bSubShellSet = TRUE;
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		else if (pObj->GetObjIdentifier() != OBJ_TEXT   // Verhindern, das beim Anlegen
//STRIP001 /*?*/ 					|| !pViewSh->IsDrawTextShell())		// eines TextObjekts auf die
//STRIP001 /*?*/ 		{												// DrawShell umgeschaltet wird.
//STRIP001 /*?*/ 			pViewSh->SetDrawShell(TRUE);				//@#70206#
//STRIP001 /*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( nMarkCount && !bSubShellSet )
/*N*/ 	{
/*?*/ 		BOOL bOnlyControls = TRUE;
/*?*/ 		BOOL bOnlyGraf     = TRUE;
/*?*/ 		for (ULONG i=0; i<nMarkCount; i++)
/*?*/ 		{
/*?*/ 			SdrObject* pObj = rMarkList.GetMark(i)->GetObj();
/*?*/ 			if ( pObj->ISA( SdrObjGroup ) )
/*?*/ 			{
/*?*/ 				const SdrObjList *pLst = ((SdrObjGroup*)pObj)->GetSubList();
/*?*/ 				ULONG nListCount = pLst->GetObjCount();
/*?*/ 				if ( nListCount == 0 )
/*?*/ 				{
/*?*/ 					//	#104156# An empty group (may occur during Undo) is no control or graphics object.
/*?*/ 					//	Creating the form shell during undo would lead to problems with the undo manager.
/*?*/ 					bOnlyControls = FALSE;
/*?*/ 					bOnlyGraf = FALSE;
/*?*/ 				}
/*?*/ 				for ( USHORT j = 0; j < nListCount; ++j )
/*?*/ 				{
/*?*/ 					SdrObject *pSubObj = pLst->GetObj( j );
/*?*/ 
/*?*/ 					if (!pSubObj->ISA(SdrUnoObj))
/*?*/ 						bOnlyControls = FALSE;
/*?*/ 					if (pSubObj->GetObjIdentifier() != OBJ_GRAF)
/*?*/ 						bOnlyGraf = FALSE;
/*?*/ 
/*?*/ 					if ( !bOnlyControls && !bOnlyGraf ) break;
/*?*/ 				}
/*?*/ 			}
/*?*/ 			else
/*?*/ 			{
/*?*/ 				if (!pObj->ISA(SdrUnoObj))
/*?*/ 					bOnlyControls = FALSE;
/*?*/ 				if (pObj->GetObjIdentifier() != OBJ_GRAF)
/*?*/ 					bOnlyGraf = FALSE;
/*?*/ 			}
/*?*/ 
/*?*/ 			if ( !bOnlyControls && !bOnlyGraf ) break;
/*?*/ 		}
/*?*/ 
/*?*/ 		if(bOnlyControls)
/*?*/ 		{
				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 			pViewSh->SetDrawFormShell(TRUE);			// jetzt UNO-Controls
/*?*/ 		}
/*?*/ 		else if(bOnlyGraf)
/*?*/ 		{
				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 			pViewSh->SetGraphicShell(TRUE);
/*?*/ 		}
/*?*/ 		else if(nMarkCount>1)
/*?*/ 		{
				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 			pViewSh->SetDrawShell(TRUE);
/*?*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 
/*N*/ 
/*N*/ 	//	Verben anpassen
/*N*/ 
/*N*/ 	SfxViewFrame* pViewFrame = pViewSh->GetViewFrame();
/*N*/ 	BOOL bOle = pViewFrame && pViewFrame->ISA(SfxInPlaceFrame);
/*N*/ 	if ( pOle2Obj && !bOle )
/*N*/ 	{
/*?*/ 		SvInPlaceObject* pIPObj = pOle2Obj->GetObjRef();
/*?*/ 		if (pIPObj)
/*?*/ 			pViewSh->SetVerbs( &pIPObj->GetVerbList() );
/*?*/ 		else
/*?*/ 		{
/*?*/ 			DBG_ERROR("SdrOle2Obj ohne ObjRef");
/*?*/ 			pViewSh->SetVerbs( 0 );
/*?*/ 		}
/*N*/ 	}
/*N*/ 	else
/*N*/ 		pViewSh->SetVerbs( 0 );
/*N*/ 
/*N*/ 	//	Image-Map Editor
/*N*/ 
/*N*/ 	if ( pOle2Obj )
				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 		UpdateIMap( pOle2Obj );
/*N*/ 	else if ( pGrafObj )
				{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 		UpdateIMap( pGrafObj );

/*N*/ 	InvalidateAttribs();				// nach dem IMap-Editor Update
/*N*/ 	InvalidateDrawTextAttrs();
/*N*/ 
/*N*/ 	USHORT nWinCount = GetWinCount();
/*N*/ 	for (USHORT i=0; i<nWinCount; i++)
/*N*/ 	{
/*N*/ 		OutputDevice* pDev = GetWin(i);
/*N*/ 		if (pDev->GetOutDevType() == OUTDEV_WINDOW)
/*N*/ 			((Window*)pDev)->Update();
/*N*/ 	}
/*N*/ 
/*N*/ 	//	uno object for view returns drawing objects as selection,
/*N*/ 	//	so it must notify its SelectionChangeListeners
/*N*/ 
/*N*/ 	if (pViewFrame)
/*N*/ 	{
/*N*/ 		SfxFrame* pFrame = pViewFrame->GetFrame();
/*N*/ 		if (pFrame)
/*N*/ 		{
/*N*/ 			uno::Reference<frame::XController> xController = pFrame->GetController();
/*N*/ 			if (xController.is())
/*N*/ 			{
/*N*/ 				ScTabViewObj* pImp = ScTabViewObj::getImplementation( xController );
/*N*/ 				if (pImp)
/*N*/ 					pImp->SelectionChanged();
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	//	update selection transfer object
/*N*/ 
/*N*/ 	pViewSh->CheckSelectionTransfer();
/*N*/ 
/*N*/ }

/*N*/ void __EXPORT ScDrawView::ModelHasChanged()
/*N*/ {
/*N*/ 	FmFormView::ModelHasChanged();
/*N*/ }

/*N*/ void __EXPORT ScDrawView::UpdateUserViewOptions()
/*N*/ {
/*N*/ 	if (pViewData)
/*N*/ 	{
/*N*/ 		const ScViewOptions&	rOpt = pViewData->GetOptions();
/*N*/ 		const ScGridOptions&	rGrid = rOpt.GetGridOptions();
/*N*/ 
/*N*/ 		BOOL bBigHdl = rOpt.GetOption( VOPT_BIGHANDLES );
/*N*/ 
/*N*/ 		SetDragStripes( rOpt.GetOption( VOPT_HELPLINES ) );
/*N*/ 		SetSolidMarkHdl( rOpt.GetOption( VOPT_SOLIDHANDLES ) );
/*N*/ 		SetMarkHdlSizePixel( bBigHdl ? SC_HANDLESIZE_BIG : SC_HANDLESIZE_SMALL );
/*N*/ 
/*N*/ 		SetGridVisible( rGrid.GetGridVisible() );
/*N*/ 		SetSnapEnabled( rGrid.GetUseGridSnap() );
/*N*/ 		SetGridSnap( rGrid.GetUseGridSnap() );
/*N*/ 
/*N*/ 		//	Snap from grid options is no longer used
/*N*/ //		SetSnapGrid( Size( rGrid.GetFldSnapX(), rGrid.GetFldSnapY() ) );
/*N*/ 
/*N*/ 		Fraction aFractX( rGrid.GetFldDrawX(), rGrid.GetFldDivisionX() + 1 );
/*N*/ 		Fraction aFractY( rGrid.GetFldDrawY(), rGrid.GetFldDivisionY() + 1 );
/*N*/ 		SetSnapGridWidth( aFractX, aFractY );
/*N*/ 
/*N*/ 		SetGridCoarse( Size( rGrid.GetFldDrawX(), rGrid.GetFldDrawY() ) );
/*N*/ 		SetGridFine( Size( rGrid.GetFldDrawX() / (rGrid.GetFldDivisionX() + 1),
/*N*/ 						   rGrid.GetFldDrawY() / (rGrid.GetFldDivisionY() + 1) ) );
/*N*/ 	}
/*N*/ }

#ifdef WNT
#pragma optimize ( "", on )
#endif

//STRIP001 BOOL ScDrawView::SelectObject( const String& rName )
//STRIP001 {
//STRIP001 	UnmarkAll();
//STRIP001 
//STRIP001 	USHORT nObjectTab = 0;
//STRIP001 	SdrObject* pFound = NULL;
//STRIP001 
//STRIP001 	SfxObjectShell*	pShell = pDoc->GetDocumentShell();
//STRIP001 	if (pShell)
//STRIP001 	{
//STRIP001 		SdrModel* pDrawLayer = GetModel();
//STRIP001 		USHORT nTabCount = pDoc->GetTableCount();
//STRIP001 		for (USHORT i=0; i<nTabCount && !pFound; i++)
//STRIP001 		{
//STRIP001 			SdrPage* pPage = pDrawLayer->GetPage(i);
//STRIP001 			DBG_ASSERT(pPage,"Page ?");
//STRIP001 			if (pPage)
//STRIP001 			{
//STRIP001 				SdrObjListIter aIter( *pPage, IM_DEEPWITHGROUPS );
//STRIP001 				SdrObject* pObject = aIter.Next();
//STRIP001 				while (pObject && !pFound)
//STRIP001 				{
//STRIP001 					if ( ScDrawLayer::GetVisibleName( pObject ) == rName )
//STRIP001 					{
//STRIP001 						pFound = pObject;
//STRIP001 						nObjectTab = i;
//STRIP001 					}
//STRIP001 					pObject = aIter.Next();
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pFound )
//STRIP001 	{
//STRIP001 		ScTabView* pView = pViewData->GetView();
//STRIP001 		if ( nObjectTab != nTab )								// Tabelle umschalten
//STRIP001 			pView->SetTabNo( nObjectTab );
//STRIP001 
//STRIP001 		DBG_ASSERT( nTab == nObjectTab, "Tabellen umschalten hat nicht geklappt" );
//STRIP001 
//STRIP001 		pView->ScrollToObject( pFound );
//STRIP001 
//STRIP001 		//	#61585# to select an object on the background layer, the layer has to
//STRIP001 		//	be unlocked even if exclusive drawing selection mode is not active
//STRIP001 		//	(this is reversed in MarkListHasChanged when nothing is selected)
//STRIP001 
//STRIP001 		if ( pFound->GetLayer() == SC_LAYER_BACK &&
//STRIP001 				!pViewData->GetViewShell()->IsDrawSelMode() &&
//STRIP001 				!pDoc->IsTabProtected( nTab ) &&
//STRIP001 				!pViewData->GetSfxDocShell()->IsReadOnly() )
//STRIP001 		{
//STRIP001 			SdrLayer* pLayer = GetModel()->GetLayerAdmin().GetLayerPerID(SC_LAYER_BACK);
//STRIP001 			if (pLayer)
//STRIP001 				SetLayerLocked( pLayer->GetName(), FALSE );
//STRIP001 		}
//STRIP001 
//STRIP001 		SdrPageView* pPV = GetPageViewPvNum(0);
//STRIP001 		MarkObj( pFound, pPV );
//STRIP001 	}
//STRIP001 
//STRIP001 	return ( pFound != NULL );
//STRIP001 }

//STRIP001 String ScDrawView::GetSelectedChartName() const
//STRIP001 {
//STRIP001 	//	used for modifying a chart's data area - PersistName must always be used
//STRIP001 	//	(as in ScDocument::FindChartData and UpdateChartArea)
//STRIP001 
//STRIP001 	const SdrMarkList& rMarkList = GetMarkList();
//STRIP001 	if (rMarkList.GetMarkCount() == 1)
//STRIP001 	{
//STRIP001 		SdrObject* pObj = rMarkList.GetMark(0)->GetObj();
//STRIP001 		if (pObj->GetObjIdentifier() == OBJ_OLE2)
//STRIP001 			if ( pDoc->IsChart(pObj) )
//STRIP001 				return static_cast<SdrOle2Obj*>(pObj)->GetPersistName();
//STRIP001 	}
//STRIP001 
//STRIP001 	return EMPTY_STRING;		// nichts gefunden
//STRIP001 }

//STRIP001 FASTBOOL ScDrawView::InsertObjectSafe(SdrObject* pObj, SdrPageView& rPV, ULONG nOptions)
//STRIP001 {
//STRIP001 	//	Markierung nicht aendern, wenn Ole-Objekt aktiv
//STRIP001 	//	(bei Drop aus Ole-Objekt wuerde sonst mitten im ExecuteDrag deaktiviert!)
//STRIP001 
//STRIP001 	if (pViewData)
//STRIP001 	{
//STRIP001 		SfxInPlaceClient* pClient = pViewData->GetViewShell()->GetIPClient();
//STRIP001 		if ( pClient && pClient->IsInPlaceActive() )
//STRIP001 			nOptions |= SDRINSERT_DONTMARK;
//STRIP001 	}
//STRIP001 
//STRIP001 	return InsertObject( pObj, rPV, nOptions );
//STRIP001 }

//STRIP001 void __EXPORT ScDrawView::MakeVisible( const Rectangle& rRect, Window& rWin )
//STRIP001 {
//STRIP001 	//!	rWin richtig auswerten
//STRIP001 	//!	ggf Zoom aendern
//STRIP001 
//STRIP001 	if ( pViewData && pViewData->GetActiveWin() == &rWin )
//STRIP001 		pViewData->GetView()->MakeVisible( rRect );
//STRIP001 }

/*N*/ SdrEndTextEditKind ScDrawView::ScEndTextEdit()
/*N*/ {
/*N*/ 	BOOL bIsTextEdit = IsTextEdit();
/*N*/ 	SdrEndTextEditKind eKind = EndTextEdit();
/*N*/ 
/*N*/ 	if ( bIsTextEdit && pViewData )
			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*N*/ 		pViewData->GetViewShell()->SetDrawTextUndo(NULL);	// "normaler" Undo-Manager
/*N*/ 
/*N*/ 	return eKind;
/*N*/ }

//STRIP001 void ScDrawView::MarkDropObj( SdrObject* pObj )
//STRIP001 {
//STRIP001 	if ( pObj )
//STRIP001 	{
//STRIP001 		if ( !pDropMarker )
//STRIP001 			pDropMarker = new SdrViewUserMarker(this);
//STRIP001 		if ( pDropMarkObj != pObj )
//STRIP001 		{
//STRIP001 			pDropMarkObj = pObj;
//STRIP001 			pDropMarker->SetXPolyPolygon(pDropMarkObj, GetPageViewPvNum(0));
//STRIP001 			pDropMarker->Show();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else				// Markierung aufheben
//STRIP001 	{
//STRIP001 		if (pDropMarker)
//STRIP001 		{
//STRIP001 			pDropMarker->Hide();
//STRIP001 			pDropMarkObj = NULL;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }



}
