/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_dptabres.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:47:20 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "core_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

#include <tools/debug.hxx>
#include <math.h>
#include <float.h>			//! Test !!!

// auto strip #include "dptabres.hxx"
// auto strip #include "dptabsrc.hxx"
// auto strip #include "dptabdat.hxx"
// auto strip #include "global.hxx"
// auto strip #include "subtotal.hxx"
#include "globstr.hrc"
#include "datauno.hxx"		// ScDataUnoConversion

// auto strip #include <com/sun/star/sheet/DataResultFlags.hpp>
// auto strip #include <com/sun/star/sheet/MemberResultFlags.hpp>
// auto strip #include <com/sun/star/sheet/DataPilotFieldOrientation.hpp>
namespace binfilter {

using namespace ::com::sun::star;

// -----------------------------------------------------------------------

//STRIP001 SV_IMPL_PTRARR( ScDPResultMembers, ScDPResultMemberPtr );
//STRIP001 SV_IMPL_PTRARR( ScDPDataMembers, ScDPDataMemberPtr );

// -----------------------------------------------------------------------

static USHORT nFuncStrIds[12] =		// passend zum enum ScSubTotalFunc
{
	0,								// SUBTOTAL_FUNC_NONE
	STR_FUN_TEXT_AVG,				// SUBTOTAL_FUNC_AVE
	STR_FUN_TEXT_COUNT,				// SUBTOTAL_FUNC_CNT
	STR_FUN_TEXT_COUNT,				// SUBTOTAL_FUNC_CNT2
	STR_FUN_TEXT_MAX,				// SUBTOTAL_FUNC_MAX
	STR_FUN_TEXT_MIN,				// SUBTOTAL_FUNC_MIN
	STR_FUN_TEXT_PRODUCT,			// SUBTOTAL_FUNC_PROD
	STR_FUN_TEXT_STDDEV,			// SUBTOTAL_FUNC_STD
	STR_FUN_TEXT_STDDEV,			// SUBTOTAL_FUNC_STDP
	STR_FUN_TEXT_SUM,				// SUBTOTAL_FUNC_SUM
	STR_FUN_TEXT_VAR,				// SUBTOTAL_FUNC_VAR
	STR_FUN_TEXT_VAR				// SUBTOTAL_FUNC_VARP
};


//!	member of something or pass as arguments !!!!!!!!!!
static ScSubTotalFunc eColForce = SUBTOTAL_FUNC_NONE;
static ScSubTotalFunc eRowForce = SUBTOTAL_FUNC_NONE;

static long nColSubTotalFunc = -1;
static long nRowSubTotalFunc = -1;

static BOOL bLateInit = TRUE;

// -----------------------------------------------------------------------

//STRIP001 void ScDPAggData::Update( const ScDPValueData& rNext, ScSubTotalFunc eFunc )
//STRIP001 {
//STRIP001 	if (nCount<0)		// error?
//STRIP001 		return;			// nothing more...
//STRIP001 
//STRIP001 	if ( rNext.nType == SC_VALTYPE_EMPTY )
//STRIP001 		return;
//STRIP001 
//STRIP001 	//! Test !!!
//STRIP001 	if ( eColForce != SUBTOTAL_FUNC_NONE && eRowForce != SUBTOTAL_FUNC_NONE && eColForce != eRowForce )
//STRIP001 		return;
//STRIP001 	if ( eColForce != SUBTOTAL_FUNC_NONE ) eFunc = eColForce;
//STRIP001 	if ( eRowForce != SUBTOTAL_FUNC_NONE ) eFunc = eRowForce;
//STRIP001 	//! Test !!!
//STRIP001 
//STRIP001 	if ( eFunc == SUBTOTAL_FUNC_NONE )
//STRIP001 		return;
//STRIP001 
//STRIP001 	if ( eFunc != SUBTOTAL_FUNC_CNT2 )			// CNT2 counts everything, incl. strings and errors
//STRIP001 	{
//STRIP001 		if ( rNext.nType == SC_VALTYPE_ERROR )
//STRIP001 		{
//STRIP001 			nCount = -1;		// -1 for error (not for CNT2)
//STRIP001 			return;
//STRIP001 		}
//STRIP001 		if ( rNext.nType == SC_VALTYPE_STRING )
//STRIP001 			return;				// ignore
//STRIP001 	}
//STRIP001 
//STRIP001 	++nCount;			// for all functions
//STRIP001 
//STRIP001 	switch (eFunc)
//STRIP001 	{
//STRIP001 		case SUBTOTAL_FUNC_SUM:
//STRIP001 		case SUBTOTAL_FUNC_AVE:
//STRIP001 			if ( !SubTotal::SafePlus( fVal, rNext.fValue ) )
//STRIP001 				nCount = -1;							// -1 for error
//STRIP001 			break;
//STRIP001 		case SUBTOTAL_FUNC_PROD:
//STRIP001 			if ( nCount == 1 )			// copy first value (fVal is initialized to 0)
//STRIP001 				fVal = rNext.fValue;
//STRIP001 			else if ( !SubTotal::SafeMult( fVal, rNext.fValue ) )
//STRIP001 				nCount = -1;							// -1 for error
//STRIP001 			break;
//STRIP001 		case SUBTOTAL_FUNC_CNT:
//STRIP001 		case SUBTOTAL_FUNC_CNT2:
//STRIP001 			//	nothing more than incrementing nCount
//STRIP001 			break;
//STRIP001 		case SUBTOTAL_FUNC_MAX:
//STRIP001 			if ( nCount == 1 || rNext.fValue > fVal )
//STRIP001 				fVal = rNext.fValue;
//STRIP001 			break;
//STRIP001 		case SUBTOTAL_FUNC_MIN:
//STRIP001 			if ( nCount == 1 || rNext.fValue < fVal )
//STRIP001 				fVal = rNext.fValue;
//STRIP001 			break;
//STRIP001 		case SUBTOTAL_FUNC_STD:
//STRIP001 		case SUBTOTAL_FUNC_STDP:
//STRIP001 		case SUBTOTAL_FUNC_VAR:
//STRIP001 		case SUBTOTAL_FUNC_VARP:
//STRIP001 			{
//STRIP001 				if ( !SubTotal::SafePlus( fVal, rNext.fValue ) )
//STRIP001 					nCount = -1;							// -1 for error
//STRIP001 				double fAdd = rNext.fValue;
//STRIP001 				if ( !SubTotal::SafeMult( fAdd, rNext.fValue ) ||
//STRIP001 					 !SubTotal::SafePlus( fSquare, fAdd ) )
//STRIP001 					nCount = -1;							// -1 for error
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		default:
//STRIP001 			DBG_ERROR("invalid function");
//STRIP001 	}
//STRIP001 }

//STRIP001 BOOL ScDPAggData::HasError( ScSubTotalFunc eFunc ) const
//STRIP001 {
//STRIP001 	//! Test !!!
//STRIP001 	if ( eColForce != SUBTOTAL_FUNC_NONE ) eFunc = eColForce;
//STRIP001 	if ( eRowForce != SUBTOTAL_FUNC_NONE ) eFunc = eRowForce;
//STRIP001 	//! Test !!!
//STRIP001 
//STRIP001 	switch (eFunc)
//STRIP001 	{
//STRIP001 		case SUBTOTAL_FUNC_SUM:
//STRIP001 		case SUBTOTAL_FUNC_PROD:
//STRIP001 		case SUBTOTAL_FUNC_CNT:
//STRIP001 		case SUBTOTAL_FUNC_CNT2:
//STRIP001 			return ( nCount < 0 );			// only real errors
//STRIP001 
//STRIP001 		case SUBTOTAL_FUNC_AVE:
//STRIP001 		case SUBTOTAL_FUNC_MAX:
//STRIP001 		case SUBTOTAL_FUNC_MIN:
//STRIP001 		case SUBTOTAL_FUNC_STDP:
//STRIP001 		case SUBTOTAL_FUNC_VARP:
//STRIP001 			return ( nCount <= 0 );			// no data is an error
//STRIP001 
//STRIP001 		case SUBTOTAL_FUNC_STD:
//STRIP001 		case SUBTOTAL_FUNC_VAR:
//STRIP001 			return ( nCount < 2 );			// need at least 2 values
//STRIP001 
//STRIP001 		default:
//STRIP001 			DBG_ERROR("invalid function");
//STRIP001 	}
//STRIP001 	return TRUE;
//STRIP001 }

//STRIP001 double ScDPAggData::GetResult( ScSubTotalFunc eFunc ) const
//STRIP001 {
//STRIP001 	//! Test !!!
//STRIP001 	if ( eColForce != SUBTOTAL_FUNC_NONE ) eFunc = eColForce;
//STRIP001 	if ( eRowForce != SUBTOTAL_FUNC_NONE ) eFunc = eRowForce;
//STRIP001 	//! Test !!!
//STRIP001 
//STRIP001 	switch (eFunc)
//STRIP001 	{
//STRIP001 		case SUBTOTAL_FUNC_MAX:
//STRIP001 		case SUBTOTAL_FUNC_MIN:
//STRIP001 		case SUBTOTAL_FUNC_SUM:
//STRIP001 		case SUBTOTAL_FUNC_PROD:
//STRIP001 			//	different error conditions are handled in HasError
//STRIP001 			return fVal;
//STRIP001 
//STRIP001 		case SUBTOTAL_FUNC_CNT:
//STRIP001 		case SUBTOTAL_FUNC_CNT2:
//STRIP001 			return nCount;
//STRIP001 
//STRIP001 		case SUBTOTAL_FUNC_AVE:
//STRIP001 			if ( nCount > 0 )
//STRIP001 				return fVal / (double) nCount;
//STRIP001 			DBG_ERROR("empty average");
//STRIP001 			break;
//STRIP001 
//STRIP001 		//!	use safe mul for fVal * fVal
//STRIP001 
//STRIP001 		case SUBTOTAL_FUNC_STD:
//STRIP001 			if ( nCount >= 2 )
//STRIP001 				return sqrt((fSquare - fVal*fVal/(double)(nCount)) / (double)(nCount-1));
//STRIP001 			DBG_ERROR("empty dev");
//STRIP001 			break;
//STRIP001 		case SUBTOTAL_FUNC_VAR:
//STRIP001 			if ( nCount >= 2 )
//STRIP001 				return (fSquare - fVal*fVal/(double)(nCount)) / (double)(nCount-1);
//STRIP001 			DBG_ERROR("empty var");
//STRIP001 			break;
//STRIP001 		case SUBTOTAL_FUNC_STDP:
//STRIP001 			if ( nCount > 0 )
//STRIP001 				return sqrt((fSquare - fVal*fVal/(double)(nCount)) / (double)nCount);
//STRIP001 			DBG_ERROR("empty devp")
//STRIP001 			break;
//STRIP001 		case SUBTOTAL_FUNC_VARP:
//STRIP001 			if ( nCount > 0 )
//STRIP001 				return (fSquare - fVal*fVal/(double)(nCount)) / (double)nCount;
//STRIP001 			DBG_ERROR("empty devp")
//STRIP001 			break;
//STRIP001 		default:
//STRIP001 			DBG_ERROR("invalid function");
//STRIP001 	}
//STRIP001 	return 0.0;
//STRIP001 }

//STRIP001 ScDPAggData* ScDPAggData::GetChild()
//STRIP001 {
//STRIP001 	if (!pChild)
//STRIP001 		pChild = new ScDPAggData;
//STRIP001 	return pChild;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 ScSubTotalFunc lcl_GetForceFunc( ScDPLevel* pLevel, long nFuncNo )
//STRIP001 {
//STRIP001 	ScSubTotalFunc eRet = SUBTOTAL_FUNC_NONE;
//STRIP001 	if ( pLevel )
//STRIP001 	{
//STRIP001 		//!	direct access via ScDPLevel
//STRIP001 
//STRIP001 		uno::Sequence<sheet::GeneralFunction> aSeq = pLevel->getSubTotals();
//STRIP001 		if ( nFuncNo < aSeq.getLength() )
//STRIP001 		{
//STRIP001 			sheet::GeneralFunction eUser = aSeq.getConstArray()[nFuncNo];
//STRIP001 			if (eUser != sheet::GeneralFunction_AUTO)
//STRIP001 				eRet = ScDataUnoConversion::GeneralToSubTotal( eUser );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return eRet;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 ScDPResultData::ScDPResultData( ScDPSource* pSrc ) :		//! Ref
//STRIP001 	pSource( pSrc ),
//STRIP001 	nMeasCount( 0 ),
//STRIP001 	pMeasFuncs( NULL ),
//STRIP001 	pMeasNames( NULL ),
//STRIP001 	bDataAtCol( FALSE ),
//STRIP001 	bDataAtRow( FALSE )
//STRIP001 {
//STRIP001 }

//STRIP001 ScDPResultData::~ScDPResultData()
//STRIP001 {
//STRIP001 	delete[] pMeasFuncs;
//STRIP001 	delete[] pMeasNames;
//STRIP001 }

//STRIP001 void ScDPResultData::SetMeasureData( long nCount, const ScSubTotalFunc* pFunctions,
//STRIP001 										const String* pNames )
//STRIP001 {
//STRIP001 	delete[] pMeasFuncs;
//STRIP001 	delete[] pMeasNames;
//STRIP001 	if ( nCount )
//STRIP001 	{
//STRIP001 		nMeasCount = nCount;
//STRIP001 		pMeasFuncs = new ScSubTotalFunc[nCount];
//STRIP001 		pMeasNames = new String[nCount];
//STRIP001 		for (long i=0; i<nCount; i++)
//STRIP001 		{
//STRIP001 			pMeasFuncs[i] = pFunctions[i];
//STRIP001 			pMeasNames[i] = pNames[i];
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		//	use one dummy measure
//STRIP001 		nMeasCount = 1;
//STRIP001 		pMeasFuncs = new ScSubTotalFunc[1];
//STRIP001 		pMeasFuncs[0] = SUBTOTAL_FUNC_NONE;
//STRIP001 		pMeasNames = new String[1];
//STRIP001 		pMeasNames[0] = ScGlobal::GetRscString( STR_EMPTYDATA );
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScDPResultData::SetDataLayoutOrientation( USHORT nOrient )
//STRIP001 {
//STRIP001 	bDataAtCol = ( nOrient == sheet::DataPilotFieldOrientation_COLUMN );
//STRIP001 	bDataAtRow = ( nOrient == sheet::DataPilotFieldOrientation_ROW );
//STRIP001 }

//STRIP001 long ScDPResultData::GetColStartMeasure() const
//STRIP001 {
//STRIP001 	if ( nMeasCount == 1 ) return 0;
//STRIP001 	return bDataAtCol ? SC_DPMEASURE_ALL : SC_DPMEASURE_ANY;
//STRIP001 }

//STRIP001 long ScDPResultData::GetRowStartMeasure() const
//STRIP001 {
//STRIP001 	if ( nMeasCount == 1 ) return 0;
//STRIP001 	return bDataAtRow ? SC_DPMEASURE_ALL : SC_DPMEASURE_ANY;
//STRIP001 }

//STRIP001 ScSubTotalFunc ScDPResultData::GetMeasureFunction(long nMeasure) const
//STRIP001 {
//STRIP001 	DBG_ASSERT( pMeasFuncs && nMeasure < nMeasCount, "bumm" );
//STRIP001 	return pMeasFuncs[nMeasure];
//STRIP001 }

//STRIP001 String ScDPResultData::GetMeasureString(long nMeasure, BOOL bForce, ScSubTotalFunc eForceFunc) const
//STRIP001 {
//STRIP001 	//	with bForce==TRUE, return function instead of "result" for single measure
//STRIP001 	//	with eForceFunc != SUBTOTAL_FUNC_NONE, always use eForceFunc
//STRIP001 
//STRIP001 	if ( nMeasure < 0 || ( nMeasCount == 1 && !bForce && eForceFunc == SUBTOTAL_FUNC_NONE ) )
//STRIP001 	{
//STRIP001 		//	for user-specified subtotal function with all measures,
//STRIP001 		//	display only function name
//STRIP001 		if ( eForceFunc != SUBTOTAL_FUNC_NONE )
//STRIP001 			return ScGlobal::GetRscString(nFuncStrIds[eForceFunc]);
//STRIP001 
//STRIP001 		return ScGlobal::GetRscString(STR_TABLE_ERGEBNIS);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DBG_ASSERT( pMeasNames && nMeasure < nMeasCount, "bumm" );
//STRIP001 
//STRIP001 		String aRet;
//STRIP001 		ScSubTotalFunc eFunc = ( eForceFunc == SUBTOTAL_FUNC_NONE ) ?
//STRIP001 									GetMeasureFunction(nMeasure) : eForceFunc;
//STRIP001 		USHORT nId = nFuncStrIds[eFunc];
//STRIP001 		if (nId)
//STRIP001 		{
//STRIP001 			aRet += ScGlobal::GetRscString(nId);		// function name
//STRIP001 			aRet.AppendAscii(RTL_CONSTASCII_STRINGPARAM( " - " ));
//STRIP001 		}
//STRIP001 		aRet += pMeasNames[nMeasure];					// field name
//STRIP001 
//STRIP001 		return aRet;
//STRIP001 	}
//STRIP001 }

//STRIP001 String ScDPResultData::GetMeasureDimensionName(long nMeasure) const
//STRIP001 {
//STRIP001 	if ( nMeasure < 0 )
//STRIP001 	{
//STRIP001 		DBG_ERROR("GetMeasureDimensionName: negative");
//STRIP001 		return String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("***"));
//STRIP001 	}
//STRIP001 
//STRIP001 	return pSource->GetDataDimName( nMeasure );
//STRIP001 }

// -----------------------------------------------------------------------


//STRIP001 ScDPResultMember::ScDPResultMember( ScDPResultData* pData, ScDPDimension* pDim,
//STRIP001 									ScDPLevel* pLev, ScDPMember* pDesc,
//STRIP001 									BOOL bForceSub ) :
//STRIP001 	pResultData( pData ),
//STRIP001 	pParentDim( pDim ),
//STRIP001 	pParentLevel( pLev ),
//STRIP001 	pMemberDesc( pDesc ),
//STRIP001 	pChildDimension( NULL ),
//STRIP001 	pDataRoot( NULL ),
//STRIP001 	bHasElements( FALSE ),
//STRIP001 	bForceSubTotal( bForceSub ),
//STRIP001 	bInitialized( FALSE )
//STRIP001 {
//STRIP001 	// pParentLevel/pMemberDesc is 0 for root members
//STRIP001 }

//STRIP001 ScDPResultMember::~ScDPResultMember()
//STRIP001 {
//STRIP001 	delete pChildDimension;
//STRIP001 	delete pDataRoot;
//STRIP001 }

//STRIP001 String ScDPResultMember::GetName() const
//STRIP001 {
//STRIP001 	if (pMemberDesc)
//STRIP001 		return pMemberDesc->GetNameStr();
//STRIP001 	else
//STRIP001 		return ScGlobal::GetRscString(STR_PIVOT_TOTAL);			// root member
//STRIP001 }

//STRIP001 BOOL ScDPResultMember::IsNamedItem( const ScDPItemData& r ) const
//STRIP001 {
//STRIP001 	//!	store ScDPMember pointer instead of ScDPMember ???
//STRIP001 
//STRIP001 	if (pMemberDesc)
//STRIP001 		return ((ScDPMember*)pMemberDesc)->IsNamedItem( r );
//STRIP001 	return FALSE;
//STRIP001 }

//STRIP001 void ScDPResultMember::InitFrom( ScDPDimension** ppDim, ScDPLevel** ppLev )
//STRIP001 {
//STRIP001 	//	with bLateInit, initialize only those members that have data
//STRIP001 	if ( bLateInit )
//STRIP001 		return;
//STRIP001 
//STRIP001 	bInitialized = TRUE;
//STRIP001 
//STRIP001 	//	skip child dimension if details are not shown
//STRIP001 	if ( pMemberDesc && !pMemberDesc->getShowDetails() )
//STRIP001 		return;
//STRIP001 
//STRIP001 	if ( *ppDim )
//STRIP001 	{
//STRIP001 		pChildDimension = new ScDPResultDimension( pResultData );
//STRIP001 		pChildDimension->InitFrom( ppDim, ppLev );
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScDPResultMember::LateInitFrom( ScDPDimension** ppDim, ScDPLevel** ppLev, ScDPItemData* pItemData )
//STRIP001 {
//STRIP001 	//	without bLateInit, everything has already been initialized
//STRIP001 	if ( !bLateInit )
//STRIP001 		return;
//STRIP001 
//STRIP001 	bInitialized = TRUE;
//STRIP001 
//STRIP001 	//	skip child dimension if details are not shown
//STRIP001 	if ( pMemberDesc && !pMemberDesc->getShowDetails() )
//STRIP001 		return;
//STRIP001 
//STRIP001 	if ( *ppDim )
//STRIP001 	{
//STRIP001 		//	LateInitFrom is called several times...
//STRIP001 		if ( !pChildDimension )
//STRIP001 			pChildDimension = new ScDPResultDimension( pResultData );
//STRIP001 		pChildDimension->LateInitFrom( ppDim, ppLev, pItemData );
//STRIP001 	}
//STRIP001 }

//STRIP001 long ScDPResultMember::GetSize(long nMeasure) const
//STRIP001 {
//STRIP001 	if ( !IsVisible() )
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	if ( pChildDimension )
//STRIP001 	{
//STRIP001 		long nSize = pChildDimension->GetSize(nMeasure);
//STRIP001 		long nUserSubCount = GetSubTotalCount();
//STRIP001 		if ( nUserSubCount )
//STRIP001 		{
//STRIP001 			if ( nMeasure == SC_DPMEASURE_ALL )
//STRIP001 				nSize += pResultData->GetMeasureCount() * nUserSubCount;
//STRIP001 			else
//STRIP001 				nSize += nUserSubCount;
//STRIP001 		}
//STRIP001 		return nSize;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( nMeasure == SC_DPMEASURE_ALL )
//STRIP001 			return pResultData->GetMeasureCount();
//STRIP001 		else
//STRIP001 			return 1;
//STRIP001 	}
//STRIP001 }

//STRIP001 BOOL ScDPResultMember::IsVisible() const
//STRIP001 {
//STRIP001 	//	not initialized -> shouldn't be there at all
//STRIP001 	//	(allocated only to preserve ordering)
//STRIP001 
//STRIP001 	return ( bHasElements || ( pParentLevel && pParentLevel->getShowEmpty() ) ) && IsValid() && bInitialized;
//STRIP001 }

//STRIP001 BOOL ScDPResultMember::IsValid() const
//STRIP001 {
//STRIP001 	//	non-Valid members are left out of calculation
//STRIP001 
//STRIP001 	//	was member set no invisible at the DataPilotSource?
//STRIP001 	if ( pMemberDesc && !pMemberDesc->getIsVisible() )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

//STRIP001 long ScDPResultMember::GetSubTotalCount() const
//STRIP001 {
//STRIP001 	if ( bForceSubTotal )		// set if needed for root members
//STRIP001 		return 1;				// grand total is always "automatic"
//STRIP001 	else if ( pParentLevel )
//STRIP001 	{
//STRIP001 		//!	direct access via ScDPLevel
//STRIP001 		return pParentLevel->getSubTotals().getLength();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return 0;
//STRIP001 }

//STRIP001 void ScDPResultMember::ProcessData( const ScDPItemData* pChildMembers, ScDPResultDimension* pDataDim,
//STRIP001 										const ScDPItemData* pDataMembers, const ScDPValueData* pValues )
//STRIP001 {
//STRIP001 	SetHasElements();
//STRIP001 
//STRIP001 	if (pChildDimension)
//STRIP001 		pChildDimension->ProcessData( pChildMembers, pDataDim, pDataMembers, pValues );
//STRIP001 
//STRIP001 	if ( pDataMembers )
//STRIP001 	{
//STRIP001 		if ( !pDataRoot )
//STRIP001 		{
//STRIP001 			pDataRoot = new ScDPDataMember( pResultData, NULL );
//STRIP001 			if ( pDataDim )
//STRIP001 				pDataRoot->InitFrom( pDataDim );			// recursive
//STRIP001 		}
//STRIP001 
//STRIP001 		//! Test !!!!
//STRIP001 		ScSubTotalFunc eOld = eRowForce;
//STRIP001 		long nOldSub = nRowSubTotalFunc;
//STRIP001 		//! Test !!!!
//STRIP001 
//STRIP001 		long nUserSubCount = GetSubTotalCount();
//STRIP001 		if ( !nUserSubCount || !pChildDimension )			//! Test
//STRIP001 			nUserSubCount = 1;								//! Test
//STRIP001 
//STRIP001 		for (long nUserPos=0; nUserPos<nUserSubCount; nUserPos++)
//STRIP001 		{
//STRIP001 			//! Test !!!!
//STRIP001 			if ( pChildDimension )
//STRIP001 			{
//STRIP001 				nRowSubTotalFunc = nUserPos;
//STRIP001 				eRowForce = lcl_GetForceFunc( pParentLevel, nUserPos );
//STRIP001 			}
//STRIP001 			//! Test !!!!
//STRIP001 
//STRIP001 			pDataRoot->ProcessData( pDataMembers, pValues );
//STRIP001 
//STRIP001 			//! Test !!!!
//STRIP001 			eRowForce = eOld;
//STRIP001 			nRowSubTotalFunc = nOldSub;
//STRIP001 			//! Test !!!!
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScDPResultMember::FillMemberResults( uno::Sequence<sheet::MemberResult>* pSequences,
//STRIP001 											long& rPos, long nMeasure, BOOL bRoot,
//STRIP001 											const String* pMemberName,
//STRIP001 											const String* pMemberCaption )
//STRIP001 {
//STRIP001 	//	IsVisible() test is in ScDPResultDimension::FillMemberResults
//STRIP001 	//	(not on data layout dimension)
//STRIP001 
//STRIP001 	long nSize = GetSize(nMeasure);
//STRIP001 	sheet::MemberResult* pArray = pSequences->getArray();
//STRIP001 	DBG_ASSERT( rPos+nSize <= pSequences->getLength(), "bumm" );
//STRIP001 
//STRIP001 	String aName;
//STRIP001 	if ( pMemberName )			// if pMemberName != NULL, use instead of real member name
//STRIP001 		aName = *pMemberName;
//STRIP001 	else
//STRIP001 		aName = GetName();
//STRIP001 
//STRIP001 	String aCaption = aName;
//STRIP001 	if ( pMemberCaption )					// use pMemberCaption if != NULL
//STRIP001 		aCaption = *pMemberCaption;
//STRIP001 	if (!aCaption.Len())
//STRIP001 		aCaption = ScGlobal::GetRscString(STR_EMPTYDATA);
//STRIP001 
//STRIP001 	if ( nSize && !bRoot )					// root is overwritten by first dimension
//STRIP001 	{
//STRIP001 		pArray[rPos].Name    = ::rtl::OUString(aName);
//STRIP001 		pArray[rPos].Caption = ::rtl::OUString(aCaption);
//STRIP001 		pArray[rPos].Flags	|= sheet::MemberResultFlags::HASMEMBER;
//STRIP001 
//STRIP001 		//	set "continue" flag (removed for subtotals later)
//STRIP001 		for (long i=1; i<nSize; i++)
//STRIP001 			pArray[rPos+i].Flags |= sheet::MemberResultFlags::CONTINUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bHasChild = ( pChildDimension != NULL );
//STRIP001 	if (bHasChild)
//STRIP001 	{
//STRIP001 		if (bRoot)		// same sequence for root member
//STRIP001 			pChildDimension->FillMemberResults( pSequences, rPos, nMeasure );
//STRIP001 		else
//STRIP001 			pChildDimension->FillMemberResults( pSequences + 1, rPos, nMeasure );
//STRIP001 	}
//STRIP001 
//STRIP001 	rPos += nSize;
//STRIP001 
//STRIP001 	long nUserSubCount = GetSubTotalCount();
//STRIP001 	if ( nUserSubCount && pChildDimension )
//STRIP001 	{
//STRIP001 		long nMemberMeasure = nMeasure;
//STRIP001 		long nSubSize = pResultData->GetCountForMeasure(nMeasure);
//STRIP001 
//STRIP001 		rPos -= nSubSize * nUserSubCount;					//	GetSize includes space for SubTotal
//STRIP001 
//STRIP001 		for (long nUserPos=0; nUserPos<nUserSubCount; nUserPos++)
//STRIP001 		{
//STRIP001 			for ( long nSubCount=0; nSubCount<nSubSize; nSubCount++ )
//STRIP001 			{
//STRIP001 				if ( nMeasure == SC_DPMEASURE_ALL )
//STRIP001 					nMemberMeasure = nSubCount;
//STRIP001 
//STRIP001 				ScSubTotalFunc eForce = SUBTOTAL_FUNC_NONE;
//STRIP001 				if (bHasChild)
//STRIP001 					eForce = lcl_GetForceFunc( pParentLevel, nUserPos );
//STRIP001 
//STRIP001 				String aSubStr = aName;		//! caption?
//STRIP001 				aSubStr += ' ';
//STRIP001 				aSubStr += pResultData->GetMeasureString(nMemberMeasure, FALSE, eForce);
//STRIP001 
//STRIP001 				pArray[rPos].Name    = ::rtl::OUString(aName);
//STRIP001 				pArray[rPos].Caption = ::rtl::OUString(aSubStr);
//STRIP001 				pArray[rPos].Flags = ( pArray[rPos].Flags |
//STRIP001 									( sheet::MemberResultFlags::HASMEMBER | sheet::MemberResultFlags::SUBTOTAL) ) &
//STRIP001 									~sheet::MemberResultFlags::CONTINUE;
//STRIP001 
//STRIP001 				if ( nMeasure == SC_DPMEASURE_ALL )
//STRIP001 				{
//STRIP001 					//	data layout dimension is (direct/indirect) child of this.
//STRIP001 					//	data layout dimension must have name for all entries.
//STRIP001 
//STRIP001 					uno::Sequence<sheet::MemberResult>* pLayoutSeq = pSequences;
//STRIP001 					if (!bRoot)
//STRIP001 						++pLayoutSeq;
//STRIP001 					ScDPResultDimension* pLayoutDim = pChildDimension;
//STRIP001 					while ( pLayoutDim && !pLayoutDim->IsDataLayout() )
//STRIP001 					{
//STRIP001 						pLayoutDim = pLayoutDim->GetFirstChildDimension();
//STRIP001 						++pLayoutSeq;
//STRIP001 					}
//STRIP001 					if ( pLayoutDim )
//STRIP001 					{
//STRIP001 						sheet::MemberResult* pLayoutArray = pLayoutSeq->getArray();
//STRIP001 						String aDataName = pResultData->GetMeasureDimensionName(nMemberMeasure);
//STRIP001 						pLayoutArray[rPos].Name = ::rtl::OUString(aDataName);
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				rPos += 1;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScDPResultMember::FillDataResults( const ScDPResultMember* pRefMember,
//STRIP001 							uno::Sequence< uno::Sequence<sheet::DataResult> >& rSequence,
//STRIP001 							long& rRow, long nMeasure ) const
//STRIP001 {
//STRIP001 	//	IsVisible() test is in ScDPResultDimension::FillDataResults
//STRIP001 	//	(not on data layout dimension)
//STRIP001 
//STRIP001 	BOOL bHasChild = ( pChildDimension != NULL );
//STRIP001 	if (bHasChild)
//STRIP001 	{
//STRIP001 		pChildDimension->FillDataResults( pRefMember, rSequence, rRow, nMeasure );
//STRIP001 		rRow += (USHORT) GetSize( nMeasure );
//STRIP001 	}
//STRIP001 
//STRIP001 	long nUserSubCount = GetSubTotalCount();
//STRIP001 	if ( nUserSubCount || !bHasChild )
//STRIP001 	{
//STRIP001 		if ( !nUserSubCount || !bHasChild )				//! Test
//STRIP001 			nUserSubCount = 1;							//! Test
//STRIP001 
//STRIP001 		long nMemberMeasure = nMeasure;
//STRIP001 		long nSubSize = pResultData->GetCountForMeasure(nMeasure);
//STRIP001 		if (bHasChild)
//STRIP001 			rRow -= nSubSize * nUserSubCount;		// GetSize includes space for SubTotal
//STRIP001 
//STRIP001 		//! Test !!!!
//STRIP001 		ScSubTotalFunc eOld = eRowForce;
//STRIP001 		long nOldSub = nRowSubTotalFunc;
//STRIP001 		//! Test !!!!
//STRIP001 
//STRIP001 		if ( pDataRoot )
//STRIP001 		{
//STRIP001 			for (long nUserPos=0; nUserPos<nUserSubCount; nUserPos++)
//STRIP001 			{
//STRIP001 				//! Test !!!!
//STRIP001 				if ( bHasChild )
//STRIP001 				{
//STRIP001 					nRowSubTotalFunc = nUserPos;
//STRIP001 					eRowForce = lcl_GetForceFunc( pParentLevel, nUserPos );
//STRIP001 				}
//STRIP001 				//! Test !!!!
//STRIP001 
//STRIP001 				for ( long nSubCount=0; nSubCount<nSubSize; nSubCount++ )
//STRIP001 				{
//STRIP001 					if ( nMeasure == SC_DPMEASURE_ALL )
//STRIP001 						nMemberMeasure = nSubCount;
//STRIP001 					else if ( pResultData->GetColStartMeasure() == SC_DPMEASURE_ALL )
//STRIP001 						nMemberMeasure = SC_DPMEASURE_ALL;
//STRIP001 
//STRIP001 					DBG_ASSERT( rRow < rSequence.getLength(), "bumm" );
//STRIP001 					uno::Sequence<sheet::DataResult>& rSubSeq = rSequence.getArray()[rRow];
//STRIP001 					long nSeqCol = 0;
//STRIP001 					pDataRoot->FillDataRow( pRefMember, rSubSeq, nSeqCol, nMemberMeasure, bHasChild );
//STRIP001 
//STRIP001 					rRow += 1;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 			rRow += nSubSize * nUserSubCount;		// empty rows occur when ShowEmpty is true
//STRIP001 
//STRIP001 		//! Test !!!!
//STRIP001 		eRowForce = eOld;
//STRIP001 		nRowSubTotalFunc = nOldSub;
//STRIP001 		//! Test !!!!
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 ScDPDataMember::ScDPDataMember( ScDPResultData* pData, ScDPResultMember* pRes ) :
//STRIP001 	pResultData( pData ),
//STRIP001 	pResultMember( pRes ),
//STRIP001 	pChildDimension( NULL )
//STRIP001 {
//STRIP001 	// pResultMember is 0 for root members
//STRIP001 }

//STRIP001 ScDPDataMember::~ScDPDataMember()
//STRIP001 {
//STRIP001 	delete pChildDimension;
//STRIP001 }

//STRIP001 String ScDPDataMember::GetName() const
//STRIP001 {
//STRIP001 	if (pResultMember)
//STRIP001 		return pResultMember->GetName();
//STRIP001 	else
//STRIP001 		return EMPTY_STRING;
//STRIP001 }

//STRIP001 BOOL ScDPDataMember::IsNamedItem( const ScDPItemData& r ) const
//STRIP001 {
//STRIP001 	if (pResultMember)
//STRIP001 		return pResultMember->IsNamedItem(r);
//STRIP001 	else
//STRIP001 		return FALSE;
//STRIP001 }

//STRIP001 void ScDPDataMember::InitFrom( ScDPResultDimension* pDim )
//STRIP001 {
//STRIP001 	if ( !pChildDimension )
//STRIP001 		pChildDimension = new ScDPDataDimension(pResultData);
//STRIP001 	pChildDimension->InitFrom(pDim);
//STRIP001 }

//STRIP001 long lcl_GetSubTotalPos()
//STRIP001 {
//STRIP001 //	return Max( nColSubTotalFunc, nRowSubTotalFunc );
//STRIP001 
//STRIP001 	long nRet = -1;
//STRIP001 	if ( nColSubTotalFunc >= 0 ) nRet = nColSubTotalFunc;
//STRIP001 	if ( nRowSubTotalFunc >= 0 ) nRet = nRowSubTotalFunc;
//STRIP001 	return nRet;
//STRIP001 }

//STRIP001 void ScDPDataMember::UpdateValues(const ScDPValueData* pValues)
//STRIP001 {
//STRIP001 	//!	find out how many and which subtotals are used
//STRIP001 
//STRIP001 	ScDPAggData* pAgg = &aAggregate;
//STRIP001 
//STRIP001 	long nSubPos = lcl_GetSubTotalPos();
//STRIP001 	if (nSubPos > 0)
//STRIP001 	{
//STRIP001 		long nSkip = nSubPos * pResultData->GetMeasureCount();
//STRIP001 		for (long i=0; i<nSkip; i++)
//STRIP001 			pAgg = pAgg->GetChild();		// created if not there
//STRIP001 	}
//STRIP001 
//STRIP001 	long nCount = pResultData->GetMeasureCount();
//STRIP001 	for (long nPos=0; nPos<nCount; nPos++)
//STRIP001 	{
//STRIP001 		pAgg->Update( *pValues, pResultData->GetMeasureFunction(nPos) );
//STRIP001 		if ( nPos+1 < nCount )
//STRIP001 		{
//STRIP001 			pAgg = pAgg->GetChild();		// created if not there
//STRIP001 			++pValues;						// next value entry
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScDPDataMember::ProcessData( const ScDPItemData* pChildMembers, const ScDPValueData* pValues )
//STRIP001 {
//STRIP001 	//! Test !!!!
//STRIP001 	ScSubTotalFunc eOld = eColForce;
//STRIP001 	long nOldSub = nColSubTotalFunc;
//STRIP001 	//! Test !!!!
//STRIP001 
//STRIP001 	if ( bLateInit && !pChildDimension && pResultMember && pResultMember->GetChildDimension() )
//STRIP001 	{
//STRIP001 		//	if this DataMember doesn't have a child dimension because the ResultMember's
//STRIP001 		//	child dimension wasn't there yet during this DataMembers's creation,
//STRIP001 		//	create the child dimension now
//STRIP001 		InitFrom( pResultMember->GetChildDimension() );
//STRIP001 	}
//STRIP001 
//STRIP001 	long nUserSubCount = pResultMember ? pResultMember->GetSubTotalCount() : 0;
//STRIP001 	if ( !nUserSubCount || !pChildDimension )			//! Test
//STRIP001 		nUserSubCount = 1;								//! Test
//STRIP001 
//STRIP001 	for (long nUserPos=0; nUserPos<nUserSubCount; nUserPos++)
//STRIP001 	{
//STRIP001 		//! Test !!!!
//STRIP001 		if ( pChildDimension )
//STRIP001 		{
//STRIP001 			ScDPLevel* pForceLevel = pResultMember ? pResultMember->GetParentLevel() : NULL;
//STRIP001 			nColSubTotalFunc = nUserPos;
//STRIP001 			eColForce = lcl_GetForceFunc( pForceLevel, nUserPos );
//STRIP001 		}
//STRIP001 		//! Test !!!!
//STRIP001 
//STRIP001 		UpdateValues(pValues);
//STRIP001 	}
//STRIP001 
//STRIP001 	//! Test !!!!
//STRIP001 	eColForce = eOld;
//STRIP001 	nColSubTotalFunc = nOldSub;
//STRIP001 	//! Test !!!!
//STRIP001 
//STRIP001 	if (pChildDimension)
//STRIP001 		pChildDimension->ProcessData( pChildMembers, pValues );
//STRIP001 }

//STRIP001 BOOL ScDPDataMember::HasData(long nMeasure) const
//STRIP001 {
//STRIP001 	//! Test !!!
//STRIP001 	if ( eColForce != SUBTOTAL_FUNC_NONE && eRowForce != SUBTOTAL_FUNC_NONE && eColForce != eRowForce )
//STRIP001 		return FALSE;
//STRIP001 	//! Test !!!
//STRIP001 
//STRIP001 	//	#74542# HasData can be different between measures!
//STRIP001 
//STRIP001 	DBG_ASSERT( nMeasure >= 0, "HasData: no measure" );
//STRIP001 
//STRIP001 	const ScDPAggData* pAgg = &aAggregate;
//STRIP001 	long nSkip = nMeasure;
//STRIP001 	long nSubPos = lcl_GetSubTotalPos();
//STRIP001 	if (nSubPos > 0)
//STRIP001 		nSkip += nSubPos * pResultData->GetMeasureCount();
//STRIP001 
//STRIP001 	for (long i=0; i<nSkip; i++)
//STRIP001 	{
//STRIP001 		pAgg = pAgg->GetExistingChild();
//STRIP001 //!		DBG_ASSERT( pAgg, "AggData not found" );
//STRIP001 		if (!pAgg)
//STRIP001 			return FALSE;			//! error?
//STRIP001 	}
//STRIP001 
//STRIP001 	return pAgg->HasData();
//STRIP001 }

//STRIP001 BOOL ScDPDataMember::HasError(long nMeasure) const
//STRIP001 {
//STRIP001 	//!	merge with GetAggregate?
//STRIP001 
//STRIP001 	DBG_ASSERT( nMeasure >= 0, "GetAggregate: no measure" );
//STRIP001 
//STRIP001 	const ScDPAggData* pAgg = &aAggregate;
//STRIP001 	long nSkip = nMeasure;
//STRIP001 	long nSubPos = lcl_GetSubTotalPos();
//STRIP001 	if (nSubPos > 0)
//STRIP001 		nSkip += nSubPos * pResultData->GetMeasureCount();
//STRIP001 
//STRIP001 	for ( long nPos=0; nPos<nSkip; nPos++ )
//STRIP001 	{
//STRIP001 		pAgg = pAgg->GetExistingChild();
//STRIP001 //!		DBG_ASSERT( pAgg, "AggData not found" );
//STRIP001 		if (!pAgg)
//STRIP001 			return TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return pAgg->HasError( pResultData->GetMeasureFunction(nMeasure) );
//STRIP001 }

//STRIP001 double ScDPDataMember::GetAggregate( long nMeasure ) const
//STRIP001 {
//STRIP001 	//!	allow to return errors
//STRIP001 
//STRIP001 	DBG_ASSERT( nMeasure >= 0, "GetAggregate: no measure" );
//STRIP001 
//STRIP001 	const ScDPAggData* pAgg = &aAggregate;
//STRIP001 	long nSkip = nMeasure;
//STRIP001 	long nSubPos = lcl_GetSubTotalPos();
//STRIP001 	if (nSubPos > 0)
//STRIP001 		nSkip += nSubPos * pResultData->GetMeasureCount();
//STRIP001 
//STRIP001 	for ( long nPos=0; nPos<nSkip; nPos++ )
//STRIP001 	{
//STRIP001 		pAgg = pAgg->GetExistingChild();
//STRIP001 //!		DBG_ASSERT( pAgg, "AggData not found" );
//STRIP001 		if (!pAgg)
//STRIP001 			return DBL_MAX;			//! error!!!
//STRIP001 	}
//STRIP001 
//STRIP001 	return pAgg->GetResult( pResultData->GetMeasureFunction(nMeasure) );
//STRIP001 }

//STRIP001 void ScDPDataMember::FillDataRow( const ScDPResultMember* pRefMember,
//STRIP001 									uno::Sequence<sheet::DataResult>& rSequence,
//STRIP001 									long& rCol, long nMeasure, BOOL bIsSubTotalRow ) const
//STRIP001 {
//STRIP001 	DBG_ASSERT( pRefMember == pResultMember || !pResultMember, "bla" );
//STRIP001 
//STRIP001 	if ( pRefMember->IsVisible() )	//! here or in ScDPDataDimension::FillDataRow ???
//STRIP001 	{
//STRIP001 		const ScDPDataMember* pDataMember = this;		//! Test
//STRIP001 
//STRIP001 		const ScDPDataDimension* pDataChild = pDataMember->GetChildDimension();
//STRIP001 		const ScDPResultDimension* pRefChild = pRefMember->GetChildDimension();
//STRIP001 
//STRIP001 		//	leave space for children even if the DataMember hasn't been initialized
//STRIP001 		//	(pDataChild is null then, this happens when no values for it are in this row)
//STRIP001 		BOOL bHasChild = ( pRefChild != NULL );
//STRIP001 
//STRIP001 		if ( bHasChild )
//STRIP001 		{
//STRIP001 			if ( pDataChild )
//STRIP001 				pDataChild->FillDataRow( pRefChild, rSequence, rCol, nMeasure, bIsSubTotalRow );
//STRIP001 			rCol += (USHORT)pRefMember->GetSize( nMeasure );
//STRIP001 		}
//STRIP001 
//STRIP001 		long nUserSubCount = pRefMember->GetSubTotalCount();
//STRIP001 		if ( nUserSubCount || !bHasChild )
//STRIP001 		{
//STRIP001 			if ( !nUserSubCount || !bHasChild )		//! Test
//STRIP001 				nUserSubCount = 1;					//! Test
//STRIP001 
//STRIP001 			//! Test !!!!
//STRIP001 			ScSubTotalFunc eOld = eColForce;
//STRIP001 			long nOldSub = nColSubTotalFunc;
//STRIP001 			//! Test !!!!
//STRIP001 
//STRIP001 			long nMemberMeasure = nMeasure;
//STRIP001 			long nSubSize = pResultData->GetCountForMeasure(nMeasure);
//STRIP001 			if (bHasChild)
//STRIP001 				rCol -= nSubSize * nUserSubCount;		// GetSize includes space for SubTotal
//STRIP001 
//STRIP001 			for (long nUserPos=0; nUserPos<nUserSubCount; nUserPos++)
//STRIP001 			{
//STRIP001 				//! Test !!!!
//STRIP001 				if ( pChildDimension )
//STRIP001 				{
//STRIP001 					ScDPLevel* pForceLevel = pResultMember ? pResultMember->GetParentLevel() : NULL;
//STRIP001 					nColSubTotalFunc = nUserPos;
//STRIP001 					eColForce = lcl_GetForceFunc( pForceLevel, nUserPos );
//STRIP001 				}
//STRIP001 				//! Test !!!!
//STRIP001 
//STRIP001 				for ( long nSubCount=0; nSubCount<nSubSize; nSubCount++ )
//STRIP001 				{
//STRIP001 					if ( nMeasure == SC_DPMEASURE_ALL )
//STRIP001 						nMemberMeasure = nSubCount;
//STRIP001 
//STRIP001 					DBG_ASSERT( rCol < rSequence.getLength(), "bumm" );
//STRIP001 					sheet::DataResult& rRes = rSequence.getArray()[rCol];
//STRIP001 
//STRIP001 					if ( pDataMember->HasData(nMemberMeasure) )
//STRIP001 					{
//STRIP001 						if ( pDataMember->HasError(nMemberMeasure) )
//STRIP001 						{
//STRIP001 							rRes.Value = 0;
//STRIP001 							rRes.Flags |= sheet::DataResultFlags::ERROR;
//STRIP001 						}
//STRIP001 						else
//STRIP001 						{
//STRIP001 							rRes.Value = pDataMember->GetAggregate(nMemberMeasure);
//STRIP001 							rRes.Flags |= sheet::DataResultFlags::HASDATA;
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					if ( bHasChild || bIsSubTotalRow )
//STRIP001 						rRes.Flags |= sheet::DataResultFlags::SUBTOTAL;
//STRIP001 
//STRIP001 					rCol += 1;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			//! Test !!!!
//STRIP001 			eColForce = eOld;
//STRIP001 			nColSubTotalFunc = nOldSub;
//STRIP001 			//! Test !!!!
//STRIP001 		}
//STRIP001 	}
//STRIP001 }


// -----------------------------------------------------------------------

//STRIP001 ScDPResultDimension::ScDPResultDimension( ScDPResultData* pData ) :
//STRIP001 	pResultData( pData ),
//STRIP001 	bIsDataLayout( FALSE )
//STRIP001 {
//STRIP001 }

//STRIP001 ScDPResultDimension::~ScDPResultDimension()
//STRIP001 {
//STRIP001 }

//STRIP001 void ScDPResultDimension::InitFrom( ScDPDimension** ppDim, ScDPLevel** ppLev )
//STRIP001 {
//STRIP001 	ScDPDimension* pThisDim = *ppDim;
//STRIP001 	ScDPLevel* pThisLevel = *ppLev;
//STRIP001 	if (pThisDim && pThisLevel)
//STRIP001 	{
//STRIP001 		ScDPDimension** ppChildDim = ppDim + 1;
//STRIP001 		ScDPLevel** ppChildLev = ppLev + 1;
//STRIP001 
//STRIP001 		bIsDataLayout = pThisDim->getIsDataLayoutDimension();
//STRIP001 
//STRIP001 		ScDPMembers* pMembers = pThisLevel->GetMembersObject();
//STRIP001 		long nMembCount = pMembers->getCount();
//STRIP001 		for ( long i=0; i<nMembCount; i++ )
//STRIP001 		{
//STRIP001 			ScDPMember* pMember = pMembers->getByIndex(i);
//STRIP001 			ScDPResultMember* pNew = new ScDPResultMember( pResultData, pThisDim,
//STRIP001 											pThisLevel, pMember, FALSE );
//STRIP001 			aMembers.Insert( pNew, aMembers.Count() );
//STRIP001 
//STRIP001 			pNew->InitFrom( ppChildDim, ppChildLev );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScDPResultDimension::LateInitFrom( ScDPDimension** ppDim, ScDPLevel** ppLev, ScDPItemData* pItemData )
//STRIP001 {
//STRIP001 	ScDPDimension* pThisDim = *ppDim;
//STRIP001 	ScDPLevel* pThisLevel = *ppLev;
//STRIP001 	ScDPItemData& rThisData = *pItemData;
//STRIP001 	if (pThisDim && pThisLevel)
//STRIP001 	{
//STRIP001 		ScDPDimension** ppChildDim = ppDim + 1;
//STRIP001 		ScDPLevel** ppChildLev = ppLev + 1;
//STRIP001 		ScDPItemData* pChildData = pItemData + 1;
//STRIP001 
//STRIP001 		if ( aMembers.Count() == 0 )
//STRIP001 		{
//STRIP001 			//	create all members at the first call (preserve order)
//STRIP001 
//STRIP001 			bIsDataLayout = pThisDim->getIsDataLayoutDimension();
//STRIP001 
//STRIP001 			ScDPMembers* pMembers = pThisLevel->GetMembersObject();
//STRIP001 			long nMembCount = pMembers->getCount();
//STRIP001 			for ( long i=0; i<nMembCount; i++ )
//STRIP001 			{
//STRIP001 				ScDPMember* pMember = pMembers->getByIndex(i);
//STRIP001 				ScDPResultMember* pNew = new ScDPResultMember( pResultData, pThisDim,
//STRIP001 												pThisLevel, pMember, FALSE );
//STRIP001 				aMembers.Insert( pNew, aMembers.Count() );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		//	initialize only specific member (or all if "show empty" flag is set)
//STRIP001 
//STRIP001 		BOOL bShowEmpty = pThisLevel->getShowEmpty();
//STRIP001 		long nCount = aMembers.Count();
//STRIP001 		for (long i=0; i<nCount; i++)
//STRIP001 		{
//STRIP001 			ScDPResultMember* pResultMember = aMembers[(USHORT)i];
//STRIP001 			if ( bIsDataLayout || bShowEmpty || pResultMember->IsNamedItem( rThisData ) )
//STRIP001 			{
//STRIP001 				pResultMember->LateInitFrom( ppChildDim, ppChildLev, pChildData );
//STRIP001 				if ( !bIsDataLayout && !bShowEmpty )
//STRIP001 					break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 long ScDPResultDimension::GetSize(long nMeasure) const
//STRIP001 {
//STRIP001 	long nTotal = 0;
//STRIP001 	long nMemberCount = aMembers.Count();
//STRIP001 	if (bIsDataLayout)
//STRIP001 	{
//STRIP001 		DBG_ASSERT(nMeasure == SC_DPMEASURE_ALL || pResultData->GetMeasureCount() == 1,
//STRIP001 					"DataLayout dimension twice?");
//STRIP001 		//	repeat first member...
//STRIP001 		nTotal = nMemberCount * aMembers[0]->GetSize(0);	// all measures have equal size
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		//	add all members
//STRIP001 		for (long nMem=0; nMem<nMemberCount; nMem++)
//STRIP001 			nTotal += aMembers[(USHORT)nMem]->GetSize(nMeasure);
//STRIP001 	}
//STRIP001 	return nTotal;
//STRIP001 }

//STRIP001 BOOL ScDPResultDimension::IsValidEntry( const ScDPItemData* pMembers ) const
//STRIP001 {
//STRIP001 	//!	pass end-marker behind valid members?
//STRIP001 
//STRIP001 //	if (!pMembers->IsEmpty())				//! non-empty sequence..
//STRIP001 	{
//STRIP001 		long nCount = aMembers.Count();
//STRIP001 		for (long i=0; i<nCount; i++)
//STRIP001 		{
//STRIP001 			ScDPResultMember* pMember = aMembers[(USHORT)i];
//STRIP001 			if ( bIsDataLayout || pMember->IsNamedItem( *pMembers ) )
//STRIP001 			{
//STRIP001 				if ( !pMember->IsValid() )
//STRIP001 					return FALSE;
//STRIP001 
//STRIP001 				ScDPResultDimension* pChildDim = pMember->GetChildDimension();
//STRIP001 				if (pChildDim)
//STRIP001 					return pChildDim->IsValidEntry( pMembers + 1 );
//STRIP001 				else
//STRIP001 					return TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	DBG_ERROR("IsValidEntry: Member not found");
//STRIP001 	return FALSE;
//STRIP001 }

//STRIP001 void ScDPResultDimension::ProcessData( const ScDPItemData* pMembers,
//STRIP001 							ScDPResultDimension* pDataDim, const ScDPItemData* pDataMembers,
//STRIP001 							const ScDPValueData* pValues )
//STRIP001 {
//STRIP001 	//!	pass end-marker behind valid members?
//STRIP001 
//STRIP001 //	if (!pMembers->IsEmpty())				//! non-empty sequence..
//STRIP001 	{
//STRIP001 		long nCount = aMembers.Count();
//STRIP001 		for (long i=0; i<nCount; i++)
//STRIP001 		{
//STRIP001 			ScDPResultMember* pMember = aMembers[(USHORT)i];
//STRIP001 
//STRIP001 			// always first member for data layout dim
//STRIP001 			if ( bIsDataLayout || pMember->IsNamedItem( *pMembers ) )
//STRIP001 			{
//STRIP001 				pMember->ProcessData( pMembers + 1, pDataDim, pDataMembers, pValues );
//STRIP001 				return;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	DBG_ERROR("ProcessData: Member not found");
//STRIP001 }

//STRIP001 void ScDPResultDimension::FillMemberResults( uno::Sequence<sheet::MemberResult>* pSequences,
//STRIP001 												long nStart, long nMeasure )
//STRIP001 {
//STRIP001 	long nPos = nStart;
//STRIP001 	long nCount = aMembers.Count();
//STRIP001 
//STRIP001 	for (long i=0; i<nCount; i++)
//STRIP001 	{
//STRIP001 		ScDPResultMember* pMember = aMembers[(USHORT)i];
//STRIP001 		//	in data layout dimension, use first member with different measures/names
//STRIP001 		if ( bIsDataLayout )
//STRIP001 		{
//STRIP001 			String aMbrName = pResultData->GetMeasureDimensionName( i );
//STRIP001 			String aMbrCapt = pResultData->GetMeasureString( i, FALSE, SUBTOTAL_FUNC_NONE );
//STRIP001 			aMembers[0]->FillMemberResults( pSequences, nPos, i, FALSE, &aMbrName, &aMbrCapt );
//STRIP001 		}
//STRIP001 		else if ( pMember->IsVisible() )
//STRIP001 			pMember->FillMemberResults( pSequences, nPos, nMeasure, FALSE, NULL, NULL );
//STRIP001 		// nPos is modified
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScDPResultDimension::FillDataResults( const ScDPResultMember* pRefMember,
//STRIP001 							uno::Sequence< uno::Sequence<sheet::DataResult> >& rSequence,
//STRIP001 							long nRow, long nMeasure ) const
//STRIP001 {
//STRIP001 	long nMemberRow = nRow;
//STRIP001 	long nMemberMeasure = nMeasure;
//STRIP001 	long nCount = aMembers.Count();
//STRIP001 	for (long i=0; i<nCount; i++)
//STRIP001 	{
//STRIP001 		const ScDPResultMember* pMember;
//STRIP001 		if (bIsDataLayout)
//STRIP001 		{
//STRIP001 			DBG_ASSERT(nMeasure == SC_DPMEASURE_ALL || pResultData->GetMeasureCount() == 1,
//STRIP001 						"DataLayout dimension twice?");
//STRIP001 			pMember = aMembers[0];
//STRIP001 			nMemberMeasure = i;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pMember = aMembers[(USHORT)i];
//STRIP001 
//STRIP001 		if ( pMember->IsVisible() )
//STRIP001 			pMember->FillDataResults( pRefMember, rSequence, nMemberRow, nMemberMeasure );
//STRIP001 			// nMemberRow is modified
//STRIP001 	}
//STRIP001 }

//STRIP001 long ScDPResultDimension::GetMemberCount() const
//STRIP001 {
//STRIP001 	return aMembers.Count();
//STRIP001 }

//STRIP001 ScDPResultMember* ScDPResultDimension::GetMember(long n) const
//STRIP001 {
//STRIP001 	return aMembers[(USHORT)n];
//STRIP001 }

//STRIP001 ScDPResultDimension* ScDPResultDimension::GetFirstChildDimension() const
//STRIP001 {
//STRIP001 	if ( aMembers.Count() > 0 )
//STRIP001 		return aMembers[0]->GetChildDimension();
//STRIP001 	else
//STRIP001 		return NULL;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 ScDPDataDimension::ScDPDataDimension( ScDPResultData* pData ) :
//STRIP001 	pResultData( pData ),
//STRIP001 	bIsDataLayout( FALSE )
//STRIP001 {
//STRIP001 }

//STRIP001 ScDPDataDimension::~ScDPDataDimension()
//STRIP001 {
//STRIP001 }

//STRIP001 void ScDPDataDimension::InitFrom( ScDPResultDimension* pDim )
//STRIP001 {
//STRIP001 	if (!pDim)
//STRIP001 		return;
//STRIP001 
//STRIP001 	bIsDataLayout = pDim->IsDataLayout();
//STRIP001 
//STRIP001 	long nCount = pDim->GetMemberCount();
//STRIP001 	for (long i=0; i<nCount; i++)
//STRIP001 	{
//STRIP001 		ScDPResultMember* pResMem = pDim->GetMember(i);
//STRIP001 
//STRIP001 		ScDPDataMember* pNew = new ScDPDataMember( pResultData, pResMem );
//STRIP001 		aMembers.Insert( pNew, aMembers.Count() );
//STRIP001 
//STRIP001 		if ( !bLateInit )
//STRIP001 		{
//STRIP001 			//	with bLateInit, pResMem hasn't necessarily been initialized yet,
//STRIP001 			//	so InitFrom for the new result member is called from its ProcessData method
//STRIP001 
//STRIP001 			ScDPResultDimension* pChildDim = pResMem->GetChildDimension();
//STRIP001 			if ( pChildDim )
//STRIP001 				pNew->InitFrom( pChildDim );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void ScDPDataDimension::ProcessData( const ScDPItemData* pDataMembers, const ScDPValueData* pValues )
//STRIP001 {
//STRIP001 	//!	pass end-marker behind valid members?
//STRIP001 
//STRIP001 //	if (!pDataMembers->IsEmpty())				//! non-empty sequence..
//STRIP001 	{
//STRIP001 		long nCount = aMembers.Count();
//STRIP001 		for (long i=0; i<nCount; i++)
//STRIP001 		{
//STRIP001 			ScDPDataMember* pMember = aMembers[(USHORT)i];
//STRIP001 
//STRIP001 			// always first member for data layout dim
//STRIP001 			if ( bIsDataLayout || pMember->IsNamedItem( *pDataMembers ) )
//STRIP001 			{
//STRIP001 				pMember->ProcessData( pDataMembers + 1, pValues );
//STRIP001 				return;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	DBG_ERROR("ProcessData: Member not found");
//STRIP001 }

//STRIP001 void ScDPDataDimension::FillDataRow( const ScDPResultDimension* pRefDim,
//STRIP001 									uno::Sequence<sheet::DataResult>& rSequence,
//STRIP001 									long nCol, long nMeasure, BOOL bIsSubTotalRow ) const
//STRIP001 {
//STRIP001 	DBG_ASSERT( pRefDim && pRefDim->GetMemberCount() == aMembers.Count(), "dimensions don't match" );
//STRIP001 
//STRIP001 	long nMemberMeasure = nMeasure;
//STRIP001 	long nMemberCol = nCol;
//STRIP001 	long nCount = aMembers.Count();
//STRIP001 	for (long i=0; i<nCount; i++)
//STRIP001 	{
//STRIP001 		long nMemberPos = i;
//STRIP001 		if (bIsDataLayout)
//STRIP001 		{
//STRIP001 			DBG_ASSERT(nMeasure == SC_DPMEASURE_ALL || pResultData->GetMeasureCount() == 1,
//STRIP001 						"DataLayout dimension twice?");
//STRIP001 			nMemberPos = 0;
//STRIP001 			nMemberMeasure = i;
//STRIP001 		}
//STRIP001 
//STRIP001 		const ScDPResultMember* pRefMember = pRefDim->GetMember(nMemberPos);
//STRIP001 		if ( pRefMember->IsVisible() )	//! here or in ScDPDataMember::FillDataRow ???
//STRIP001 		{
//STRIP001 			const ScDPDataMember* pDataMember = aMembers[(USHORT)nMemberPos];
//STRIP001 			pDataMember->FillDataRow( pRefMember, rSequence, nMemberCol, nMemberMeasure, bIsSubTotalRow );
//STRIP001 			// nMemberCol is modified
//STRIP001 		}
//STRIP001 	}
//STRIP001 }




}
